#import "@preview/lilaq:0.3.0" as lq
#import "@preview/tiptoe:0.3.0"
#import "library.typ": *



#show: lq.set-diagram(width: 15cm, height: 9cm)


#let onexicpeak = json("data/onexicpeak.json")
#let onexicpeak_minmax = json("data/onexicpeak_minmax.json")
#let onexicpeak_maxmin = json("data/onexicpeak_maxmin.json")

#xic-plot(rt_range: (3760, 3790), onexicpeak, onexicpeak_minmax, onexicpeak_maxmin)

#lq.diagram(
  title: [Xic],
  xlabel: [retention time (s)], 
  ylabel: [intensity],

  lq.plot(onexicpeak.x, onexicpeak.y, label: [Xic]),
  lq.plot(onexicpeak_minmax.x, onexicpeak_minmax.y, label: [Xic minmax]),
  lq.plot(onexicpeak_maxmin.x, onexicpeak_maxmin.y, label: [Xic maxmin])
)

#let psm = json("data/psm_with_delta.json")

#ms2spectra-plot(title: [AIADGSLLDLLR], max_intensity: 150, psm)

#let delta_arr = (
(
    "ion": "b",
    "mz": (185.128, 256.165),
    "level": 0,
    "label": "A"
),
(
    "ion": "y",
    "mz": (175.119, 288.202),
    "level": 1,
    "label": "L"
),
(
    "ion": "y",
    "mz": (288.202, 401.287),
    "level": 1,
    "label": "L"
),
(
    "ion": "y",
    "mz": (401.287,516.313),
    "level": 1,
    "label": "D"
),
(
    "ion": "y",
    "mz": (516.313,742.481),
    "level": 2,
    "label": "LL"
),
(
    "ion": "y",
    "mz": (742.481,829.511),
    "level": 1,
    "label": "S"
),
(
    "ion": "y",
    "mz": (829.511,886.535),
    "level": 1,
    "label": "G"
),
(
    "ion": "y",
    "mz": (886.535,1001.56),
    "level": 1,
    "label": "D"
),
(
    "ion": "y",
    "mz": (1001.56, 1072.6),
    "level": 1,
    "label": "A"
)
)

#let psm = json("data/psm.json")

#ms2spectra-plot(title: [AIADGSLLDLLR], max_intensity: 80, spectra: psm.spectra, ion-series: psm.ion-series, delta: delta_arr, delta-fragments: true, psm)


#let psm2 = json("data/psm2.json")

#ms2spectra-plot(title: [AIADGSLLDLLR], max_intensity: 80, spectra: psm.spectra, ion-series: psm.ion-series, delta: delta_arr, delta-fragments: true, psm2)


#let psm_isotope = json("data/psm_isotope.json")

#ms2spectra-plot(title: [AIADGSLLDLLR], max_intensity: 80, spectra: psm_isotope.spectra, ion-series: psm_isotope.ion-series, delta: delta_arr, delta-fragments: true, psm_isotope)

