// CHN_INFO.H : a class protein/RNA/DNA chain information storage.

// Copyright (C) 1998 Tommi Hassinen, Geoff Hutchison.

// This package is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this package; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

/*################################################################################################*/

#ifndef CHN_INFO_H
#define CHN_INFO_H

#include "libghemicaldefine.h"

class chn_info;

/*################################################################################################*/

class model;	// model.h

#include "typedef.h"

/*################################################################################################*/

#define PSTATE_CHARGE_mask		0x07	// three least significant bits...

#define PSTATE_SIGN_NEGATIVE		0x08
#define PSTATE_SIGN_POSITIVE		0x10
#define PSTATE_CHARGED_TERMINAL		0x20

/**	A "##chain info"-class. 
	This is used in the context of peptides/proteins and nucleic acids...
*/

class chn_info
{
	public:
	
	enum chn_type
	{
		not_defined = 0, amino_acid = 1, nucleic_acid = 2
	};
	
	protected:
	
	chn_type type;
	
	i32s id_mol;		///< the molecule number (see also atom::id[]).
	i32s id_chn;		///< the chain number (see also atom::id[]).
	
	i32s length;
	char * sequence1;	// 1-letter codes (C-string).
	char ** sequence3;	// 3-letter codes (new-allocated NULL-terminated array of C-strings).
	
	char * ss_state;	// sec-str-state (as determined in DefineSecondaryStructure()).
	char * p_state;		// protonation state (as determined in SF).
	
	char * description;
	
	friend class sequencebuilder;
	friend class setup1_sf;
	
	friend void DefineSecondaryStructure(model *);		// protein-specific...
	friend f64 HBondEnergy(model *, i32s *, i32s *);	// protein-specific...
	
	public:
	
	chn_info(void);
	chn_info(chn_type, i32s);
	chn_info(const chn_info &);
	~chn_info(void);
	
	chn_type GetType(void) { return type; }
	i32s GetLength(void) { return length; }
	
	i32s GetIDmol(void) { return id_mol; }
	i32s GetIDchn(void) { return id_chn; }
	
	const char * GetSequence1(void) { return (const char *) sequence1; }
	const char ** GetSequence3(void) { return (const char **) sequence3; }
	
	const char * GetSecStrStates(void) { return (const char *) ss_state; }
	const char * GetProtonationStates(void) { return (const char *) p_state; }
};

/*################################################################################################*/

#endif	// CHN_INFO_H

// eof
