/*! 
* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this file,
* You can obtain one at http://mozilla.org/MPL/2.0/.
*
* Copyright(c) 2009 Apogee Instruments, Inc. 
* \class CamGen2Base 
* \brief This is the base class for the second generation apogee cameras (Ascent, Aspen, etc).  This is a derived class of the ApogeeCam, which contains the function common to both Alta and second generation cameras. 
* 
*/ 


#ifndef CAMGEN2BASE_INCLUDE_H__ 
#define CAMGEN2BASE_INCLUDE_H__ 

#include "ApogeeCam.h" 
#include <string>

class DLL_EXPORT CamGen2Base  : public ApogeeCam
{ 
    public: 
        virtual ~CamGen2Base(); 

        CameraStatusRegs GetStatus();
        Apg::Status GetImagingStatus();

        void GetImage( std::vector<uint16_t> & out );

        void StopExposure( bool Digitize );

        uint32_t GetAvailableMemory();

        int32_t GetNumAds();

        double GetCoolerDrive();

        double GetTempHeatsink();

    protected:
        CamGen2Base(const uint16_t FirmwareRev,
                const uint16_t Id, 
                CamModel::PlatformType platform);

        CamGen2Base(CamModel::PlatformType platform);

        uint16_t ExposureZ();

        uint16_t GetImageZ();

        uint16_t GetIlluminationMask();

        void DefaultStartExposure( double Duration, bool IsLight, bool IssueReset=true );

    private:
        const std::string m_fileName;

        //disabling the copy ctor and assignment operator
        //generated by the compiler - don't want them
        //Effective C++ Item 6
        CamGen2Base(const CamGen2Base&);
        CamGen2Base& operator=(CamGen2Base&);
}; 

#endif
