; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; FIXME: crash "Input type needs to be promoted!"
; SKIP: sed 's/iXLen/i32/g' %s | llc -ppc-asm-full-reg-names \
; SKIP:   -ppc-vsr-nums-as-vr -mtriple=powerpc-unknown-unknown \
; SKIP:   -verify-machineinstrs | FileCheck %s --check-prefixes=PPC32
; RUN: sed 's/iXLen/i32/g' %s | llc -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc64-unknown-unknown \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefixes=BE
; RUN: sed 's/iXLen/i32/g' %s | llc -mcpu=pwr8 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc64le-unknown-unknown \
; RUN:   -verify-machineinstrs | FileCheck %s
; FIXME: crash "Input type needs to be promoted!"
; SKIP: sed 's/iXLen/i64/g' %s | llc -ppc-asm-full-reg-names \
; SKIP:   -ppc-vsr-nums-as-vr -mtriple=powerpc-unknown-unknown \
; SKIP:   -verify-machineinstrs | FileCheck %s --check-prefixes=PPC32
; RUN: sed 's/iXLen/i64/g' %s | llc -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc64-unknown-unknown \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefixes=BE
; RUN: sed 's/iXLen/i64/g' %s | llc -mcpu=pwr8 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc64le-unknown-unknown \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefixes=CHECK

define <1 x i64> @lrint_v1f16(<1 x half> %x) nounwind {
; BE-LABEL: lrint_v1f16:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -112(r1)
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    std r0, 128(r1)
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    addi r1, r1, 112
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -32(r1)
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    std r0, 48(r1)
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    addi r1, r1, 32
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <1 x i64> @llvm.lrint.v1i64.v1f16(<1 x half> %x)
  ret <1 x i64> %a
}
declare <1 x i64> @llvm.lrint.v1i64.v1f16(<1 x half>)

define <2 x i64> @lrint_v2f16(<2 x half> %x) nounwind {
; BE-LABEL: lrint_v2f16:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -144(r1)
; BE-NEXT:    std r0, 160(r1)
; BE-NEXT:    std r30, 128(r1) # 8-byte Folded Spill
; BE-NEXT:    mr r30, r3
; BE-NEXT:    clrldi r3, r4, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 120(r1)
; BE-NEXT:    clrldi r3, r30, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 112(r1)
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    ld r30, 128(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r1, r1, 144
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -96(r1)
; CHECK-NEXT:    li r5, 48
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    std r0, 112(r1)
; CHECK-NEXT:    std r29, 72(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r30, 80(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r30, r4
; CHECK-NEXT:    stxvd2x v31, r1, r5 # 16-byte Folded Spill
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    clrldi r3, r30, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    ld r30, 80(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r29, 72(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxmrghd v2, vs0, v31
; CHECK-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 96
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <2 x i64> @llvm.lrint.v2i64.v2f16(<2 x half> %x)
  ret <2 x i64> %a
}
declare <2 x i64> @llvm.lrint.v2i64.v2f16(<2 x half>)

define <4 x i64> @lrint_v4f16(<4 x half> %x) nounwind {
; BE-LABEL: lrint_v4f16:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -176(r1)
; BE-NEXT:    std r0, 192(r1)
; BE-NEXT:    std r28, 144(r1) # 8-byte Folded Spill
; BE-NEXT:    mr r28, r3
; BE-NEXT:    clrldi r3, r4, 48
; BE-NEXT:    std r29, 152(r1) # 8-byte Folded Spill
; BE-NEXT:    std r30, 160(r1) # 8-byte Folded Spill
; BE-NEXT:    mr r30, r6
; BE-NEXT:    mr r29, r5
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 120(r1)
; BE-NEXT:    clrldi r3, r28, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 112(r1)
; BE-NEXT:    clrldi r3, r30, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    clrldi r3, r29, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    ld r30, 160(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r29, 152(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r28, 144(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    addi r1, r1, 176
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -128(r1)
; CHECK-NEXT:    li r7, 48
; CHECK-NEXT:    std r0, 144(r1)
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    std r27, 88(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r28, 96(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r29, 104(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r29, r5
; CHECK-NEXT:    mr r28, r4
; CHECK-NEXT:    stxvd2x v30, r1, r7 # 16-byte Folded Spill
; CHECK-NEXT:    li r7, 64
; CHECK-NEXT:    std r30, 112(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r30, r6
; CHECK-NEXT:    stxvd2x v31, r1, r7 # 16-byte Folded Spill
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r27, r3
; CHECK-NEXT:    clrldi r3, r28, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r27
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    clrldi r3, r29, 48
; CHECK-NEXT:    xxmrghd v31, vs0, v31
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    clrldi r3, r30, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v30, r29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    vmr v2, v31
; CHECK-NEXT:    ld r30, 112(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r29, 104(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r28, 96(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r27, 88(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    xxmrghd v3, vs0, v30
; CHECK-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 128
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <4 x i64> @llvm.lrint.v4i64.v4f16(<4 x half> %x)
  ret <4 x i64> %a
}
declare <4 x i64> @llvm.lrint.v4i64.v4f16(<4 x half>)

define <8 x i64> @lrint_v8f16(<8 x half> %x) nounwind {
; BE-LABEL: lrint_v8f16:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -240(r1)
; BE-NEXT:    std r0, 256(r1)
; BE-NEXT:    std r24, 176(r1) # 8-byte Folded Spill
; BE-NEXT:    mr r24, r3
; BE-NEXT:    clrldi r3, r4, 48
; BE-NEXT:    std r25, 184(r1) # 8-byte Folded Spill
; BE-NEXT:    std r26, 192(r1) # 8-byte Folded Spill
; BE-NEXT:    std r27, 200(r1) # 8-byte Folded Spill
; BE-NEXT:    std r28, 208(r1) # 8-byte Folded Spill
; BE-NEXT:    std r29, 216(r1) # 8-byte Folded Spill
; BE-NEXT:    std r30, 224(r1) # 8-byte Folded Spill
; BE-NEXT:    mr r29, r10
; BE-NEXT:    mr r30, r9
; BE-NEXT:    mr r27, r8
; BE-NEXT:    mr r28, r7
; BE-NEXT:    mr r26, r6
; BE-NEXT:    mr r25, r5
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 120(r1)
; BE-NEXT:    clrldi r3, r24, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 112(r1)
; BE-NEXT:    clrldi r3, r26, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    clrldi r3, r25, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    clrldi r3, r27, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 152(r1)
; BE-NEXT:    clrldi r3, r28, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 144(r1)
; BE-NEXT:    clrldi r3, r29, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 168(r1)
; BE-NEXT:    clrldi r3, r30, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 160(r1)
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    ld r30, 224(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r29, 216(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r28, 208(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r27, 200(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r26, 192(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r25, 184(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r24, 176(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    lxvd2x v4, 0, r3
; BE-NEXT:    addi r3, r1, 160
; BE-NEXT:    lxvd2x v5, 0, r3
; BE-NEXT:    addi r1, r1, 240
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -192(r1)
; CHECK-NEXT:    li r11, 48
; CHECK-NEXT:    std r0, 208(r1)
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    std r23, 120(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r24, 128(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r25, 136(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r25, r5
; CHECK-NEXT:    mr r24, r4
; CHECK-NEXT:    stxvd2x v28, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    li r11, 64
; CHECK-NEXT:    std r26, 144(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r26, r6
; CHECK-NEXT:    std r27, 152(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r28, 160(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r28, r8
; CHECK-NEXT:    mr r27, r7
; CHECK-NEXT:    stxvd2x v29, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    li r11, 80
; CHECK-NEXT:    std r29, 168(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r29, r9
; CHECK-NEXT:    std r30, 176(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r30, r10
; CHECK-NEXT:    stxvd2x v30, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    li r11, 96
; CHECK-NEXT:    stxvd2x v31, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r23, r3
; CHECK-NEXT:    clrldi r3, r24, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r23
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    clrldi r3, r25, 48
; CHECK-NEXT:    xxmrghd v31, vs0, v31
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r25, r3
; CHECK-NEXT:    clrldi r3, r26, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v30, r25
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    clrldi r3, r27, 48
; CHECK-NEXT:    xxmrghd v30, vs0, v30
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r27, r3
; CHECK-NEXT:    clrldi r3, r28, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v29, r27
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    clrldi r3, r29, 48
; CHECK-NEXT:    xxmrghd v29, vs0, v29
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    clrldi r3, r30, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v28, r29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    vmr v2, v31
; CHECK-NEXT:    ld r30, 176(r1) # 8-byte Folded Reload
; CHECK-NEXT:    vmr v3, v30
; CHECK-NEXT:    vmr v4, v29
; CHECK-NEXT:    ld r29, 168(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r28, 160(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    ld r27, 152(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r26, 144(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r25, 136(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r24, 128(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r23, 120(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    lxvd2x v29, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    xxmrghd v5, vs0, v28
; CHECK-NEXT:    lxvd2x v28, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 192
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <8 x i64> @llvm.lrint.v8i64.v8f16(<8 x half> %x)
  ret <8 x i64> %a
}
declare <8 x i64> @llvm.lrint.v8i64.v8f16(<8 x half>)

define <16 x i64> @lrint_v16i64_v16f16(<16 x half> %x) nounwind {
; BE-LABEL: lrint_v16i64_v16f16:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -368(r1)
; BE-NEXT:    std r0, 384(r1)
; BE-NEXT:    std r24, 304(r1) # 8-byte Folded Spill
; BE-NEXT:    mr r24, r3
; BE-NEXT:    lhz r3, 494(r1)
; BE-NEXT:    std r16, 240(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r16, 486(r1)
; BE-NEXT:    std r17, 248(r1) # 8-byte Folded Spill
; BE-NEXT:    std r18, 256(r1) # 8-byte Folded Spill
; BE-NEXT:    std r19, 264(r1) # 8-byte Folded Spill
; BE-NEXT:    std r20, 272(r1) # 8-byte Folded Spill
; BE-NEXT:    std r21, 280(r1) # 8-byte Folded Spill
; BE-NEXT:    std r22, 288(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r22, 534(r1)
; BE-NEXT:    lhz r21, 542(r1)
; BE-NEXT:    lhz r20, 518(r1)
; BE-NEXT:    lhz r19, 526(r1)
; BE-NEXT:    lhz r18, 502(r1)
; BE-NEXT:    lhz r17, 510(r1)
; BE-NEXT:    std r23, 296(r1) # 8-byte Folded Spill
; BE-NEXT:    std r25, 312(r1) # 8-byte Folded Spill
; BE-NEXT:    std r26, 320(r1) # 8-byte Folded Spill
; BE-NEXT:    std r27, 328(r1) # 8-byte Folded Spill
; BE-NEXT:    std r28, 336(r1) # 8-byte Folded Spill
; BE-NEXT:    std r29, 344(r1) # 8-byte Folded Spill
; BE-NEXT:    std r30, 352(r1) # 8-byte Folded Spill
; BE-NEXT:    mr r29, r10
; BE-NEXT:    mr r30, r9
; BE-NEXT:    mr r27, r8
; BE-NEXT:    mr r28, r7
; BE-NEXT:    mr r25, r6
; BE-NEXT:    mr r26, r5
; BE-NEXT:    mr r23, r4
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 120(r1)
; BE-NEXT:    mr r3, r16
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 112(r1)
; BE-NEXT:    mr r3, r17
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    mr r3, r18
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    mr r3, r19
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 152(r1)
; BE-NEXT:    mr r3, r20
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 144(r1)
; BE-NEXT:    mr r3, r21
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 168(r1)
; BE-NEXT:    mr r3, r22
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 160(r1)
; BE-NEXT:    clrldi r3, r23, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 184(r1)
; BE-NEXT:    clrldi r3, r24, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 176(r1)
; BE-NEXT:    clrldi r3, r25, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 200(r1)
; BE-NEXT:    clrldi r3, r26, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 192(r1)
; BE-NEXT:    clrldi r3, r27, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 216(r1)
; BE-NEXT:    clrldi r3, r28, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 208(r1)
; BE-NEXT:    clrldi r3, r29, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 232(r1)
; BE-NEXT:    clrldi r3, r30, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 224(r1)
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    ld r30, 352(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r29, 344(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r28, 336(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r27, 328(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r26, 320(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r25, 312(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r24, 304(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v6, 0, r3
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    ld r23, 296(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r22, 288(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r21, 280(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r20, 272(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r19, 264(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r18, 256(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r17, 248(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r16, 240(r1) # 8-byte Folded Reload
; BE-NEXT:    lxvd2x v7, 0, r3
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    lxvd2x v8, 0, r3
; BE-NEXT:    addi r3, r1, 160
; BE-NEXT:    lxvd2x v9, 0, r3
; BE-NEXT:    addi r3, r1, 176
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 192
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    addi r3, r1, 208
; BE-NEXT:    lxvd2x v4, 0, r3
; BE-NEXT:    addi r3, r1, 224
; BE-NEXT:    lxvd2x v5, 0, r3
; BE-NEXT:    addi r1, r1, 368
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v16i64_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -320(r1)
; CHECK-NEXT:    li r11, 48
; CHECK-NEXT:    std r0, 336(r1)
; CHECK-NEXT:    std r23, 248(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r23, r3
; CHECK-NEXT:    lhz r3, 416(r1)
; CHECK-NEXT:    std r16, 192(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r17, 200(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r17, 432(r1)
; CHECK-NEXT:    stxvd2x v24, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    li r11, 64
; CHECK-NEXT:    std r18, 208(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r18, 440(r1)
; CHECK-NEXT:    std r19, 216(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r19, 448(r1)
; CHECK-NEXT:    lhz r16, 424(r1)
; CHECK-NEXT:    stxvd2x v25, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    li r11, 80
; CHECK-NEXT:    std r20, 224(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r20, 456(r1)
; CHECK-NEXT:    stxvd2x v26, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    li r11, 96
; CHECK-NEXT:    std r21, 232(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r22, 240(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r22, 472(r1)
; CHECK-NEXT:    lhz r21, 464(r1)
; CHECK-NEXT:    stxvd2x v27, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    li r11, 112
; CHECK-NEXT:    std r15, 184(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r24, 256(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r25, 264(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r25, r5
; CHECK-NEXT:    mr r24, r4
; CHECK-NEXT:    stxvd2x v28, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    li r11, 128
; CHECK-NEXT:    std r26, 272(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r27, 280(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r28, 288(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r29, 296(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r29, r9
; CHECK-NEXT:    mr r28, r8
; CHECK-NEXT:    mr r27, r7
; CHECK-NEXT:    mr r26, r6
; CHECK-NEXT:    stxvd2x v29, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    li r11, 144
; CHECK-NEXT:    std r30, 304(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r30, r10
; CHECK-NEXT:    stxvd2x v30, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    li r11, 160
; CHECK-NEXT:    stxvd2x v31, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r15, r3
; CHECK-NEXT:    mr r3, r16
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r15
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    mr r3, r17
; CHECK-NEXT:    xxmrghd v31, vs0, v31
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r17, r3
; CHECK-NEXT:    mr r3, r18
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v30, r17
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    mr r3, r19
; CHECK-NEXT:    xxmrghd v30, vs0, v30
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r19, r3
; CHECK-NEXT:    mr r3, r20
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v29, r19
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    mr r3, r21
; CHECK-NEXT:    xxmrghd v29, vs0, v29
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r21, r3
; CHECK-NEXT:    mr r3, r22
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v28, r21
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    clrldi r3, r23, 48
; CHECK-NEXT:    xxmrghd v28, vs0, v28
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r23, r3
; CHECK-NEXT:    clrldi r3, r24, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v27, r23
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    clrldi r3, r25, 48
; CHECK-NEXT:    xxmrghd v27, vs0, v27
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r25, r3
; CHECK-NEXT:    clrldi r3, r26, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v26, r25
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    clrldi r3, r27, 48
; CHECK-NEXT:    xxmrghd v26, vs0, v26
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r27, r3
; CHECK-NEXT:    clrldi r3, r28, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v25, r27
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    clrldi r3, r29, 48
; CHECK-NEXT:    xxmrghd v25, vs0, v25
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    clrldi r3, r30, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v24, r29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 160
; CHECK-NEXT:    vmr v6, v31
; CHECK-NEXT:    ld r30, 304(r1) # 8-byte Folded Reload
; CHECK-NEXT:    vmr v7, v30
; CHECK-NEXT:    vmr v8, v29
; CHECK-NEXT:    ld r29, 296(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r28, 288(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 144
; CHECK-NEXT:    vmr v9, v28
; CHECK-NEXT:    vmr v2, v27
; CHECK-NEXT:    vmr v3, v26
; CHECK-NEXT:    vmr v4, v25
; CHECK-NEXT:    ld r27, 280(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r26, 272(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 128
; CHECK-NEXT:    ld r25, 264(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r24, 256(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxmrghd v5, vs0, v24
; CHECK-NEXT:    ld r23, 248(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r22, 240(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r21, 232(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lxvd2x v29, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 112
; CHECK-NEXT:    ld r20, 224(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r19, 216(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r18, 208(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r17, 200(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r16, 192(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r15, 184(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lxvd2x v28, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    lxvd2x v27, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    lxvd2x v26, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    lxvd2x v25, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lxvd2x v24, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 320
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <16 x i64> @llvm.lrint.v16i64.v16f16(<16 x half> %x)
  ret <16 x i64> %a
}
declare <16 x i64> @llvm.lrint.v16i64.v16f16(<16 x half>)

define <32 x i64> @lrint_v32i64_v32f16(<32 x half> %x) nounwind {
; BE-LABEL: lrint_v32i64_v32f16:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -624(r1)
; BE-NEXT:    std r0, 640(r1)
; BE-NEXT:    std r30, 608(r1) # 8-byte Folded Spill
; BE-NEXT:    mr r30, r3
; BE-NEXT:    lhz r3, 926(r1)
; BE-NEXT:    std r14, 480(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r14, 822(r1)
; BE-NEXT:    std r15, 488(r1) # 8-byte Folded Spill
; BE-NEXT:    std r19, 520(r1) # 8-byte Folded Spill
; BE-NEXT:    std r3, 216(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r3, 934(r1)
; BE-NEXT:    lhz r15, 814(r1)
; BE-NEXT:    lhz r19, 742(r1)
; BE-NEXT:    std r22, 544(r1) # 8-byte Folded Spill
; BE-NEXT:    std r23, 552(r1) # 8-byte Folded Spill
; BE-NEXT:    std r25, 568(r1) # 8-byte Folded Spill
; BE-NEXT:    std r26, 576(r1) # 8-byte Folded Spill
; BE-NEXT:    std r3, 208(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r3, 910(r1)
; BE-NEXT:    lhz r26, 766(r1)
; BE-NEXT:    lhz r25, 774(r1)
; BE-NEXT:    std r27, 584(r1) # 8-byte Folded Spill
; BE-NEXT:    std r28, 592(r1) # 8-byte Folded Spill
; BE-NEXT:    std r29, 600(r1) # 8-byte Folded Spill
; BE-NEXT:    std r31, 616(r1) # 8-byte Folded Spill
; BE-NEXT:    std r3, 200(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r3, 918(r1)
; BE-NEXT:    lhz r31, 798(r1)
; BE-NEXT:    lhz r29, 806(r1)
; BE-NEXT:    lhz r28, 782(r1)
; BE-NEXT:    lhz r27, 790(r1)
; BE-NEXT:    lhz r23, 750(r1)
; BE-NEXT:    lhz r22, 758(r1)
; BE-NEXT:    std r16, 496(r1) # 8-byte Folded Spill
; BE-NEXT:    std r17, 504(r1) # 8-byte Folded Spill
; BE-NEXT:    std r3, 192(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r3, 894(r1)
; BE-NEXT:    mr r17, r7
; BE-NEXT:    mr r16, r4
; BE-NEXT:    std r18, 512(r1) # 8-byte Folded Spill
; BE-NEXT:    std r20, 528(r1) # 8-byte Folded Spill
; BE-NEXT:    std r21, 536(r1) # 8-byte Folded Spill
; BE-NEXT:    std r24, 560(r1) # 8-byte Folded Spill
; BE-NEXT:    std r3, 184(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r3, 902(r1)
; BE-NEXT:    mr r24, r10
; BE-NEXT:    mr r20, r9
; BE-NEXT:    mr r21, r8
; BE-NEXT:    mr r18, r6
; BE-NEXT:    std r3, 176(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r3, 878(r1)
; BE-NEXT:    std r3, 168(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r3, 886(r1)
; BE-NEXT:    std r3, 160(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r3, 862(r1)
; BE-NEXT:    std r3, 152(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r3, 870(r1)
; BE-NEXT:    std r3, 144(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r3, 846(r1)
; BE-NEXT:    std r3, 136(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r3, 854(r1)
; BE-NEXT:    std r3, 128(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r3, 830(r1)
; BE-NEXT:    std r3, 120(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r3, 838(r1)
; BE-NEXT:    std r3, 112(r1) # 8-byte Folded Spill
; BE-NEXT:    clrldi r3, r5, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 424(r1)
; BE-NEXT:    clrldi r3, r16, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 416(r1)
; BE-NEXT:    clrldi r3, r17, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 440(r1)
; BE-NEXT:    clrldi r3, r18, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 432(r1)
; BE-NEXT:    clrldi r3, r20, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 456(r1)
; BE-NEXT:    clrldi r3, r21, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 448(r1)
; BE-NEXT:    mr r3, r19
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 472(r1)
; BE-NEXT:    clrldi r3, r24, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 464(r1)
; BE-NEXT:    mr r3, r22
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 232(r1)
; BE-NEXT:    mr r3, r23
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 224(r1)
; BE-NEXT:    mr r3, r25
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 248(r1)
; BE-NEXT:    mr r3, r26
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 240(r1)
; BE-NEXT:    mr r3, r27
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 264(r1)
; BE-NEXT:    mr r3, r28
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 256(r1)
; BE-NEXT:    mr r3, r29
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 280(r1)
; BE-NEXT:    mr r3, r31
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 272(r1)
; BE-NEXT:    mr r3, r14
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 296(r1)
; BE-NEXT:    mr r3, r15
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 288(r1)
; BE-NEXT:    ld r3, 112(r1) # 8-byte Folded Reload
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 312(r1)
; BE-NEXT:    ld r3, 120(r1) # 8-byte Folded Reload
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 304(r1)
; BE-NEXT:    ld r3, 128(r1) # 8-byte Folded Reload
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 328(r1)
; BE-NEXT:    ld r3, 136(r1) # 8-byte Folded Reload
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 320(r1)
; BE-NEXT:    ld r3, 144(r1) # 8-byte Folded Reload
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 344(r1)
; BE-NEXT:    ld r3, 152(r1) # 8-byte Folded Reload
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 336(r1)
; BE-NEXT:    ld r3, 160(r1) # 8-byte Folded Reload
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 360(r1)
; BE-NEXT:    ld r3, 168(r1) # 8-byte Folded Reload
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 352(r1)
; BE-NEXT:    ld r3, 176(r1) # 8-byte Folded Reload
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 376(r1)
; BE-NEXT:    ld r3, 184(r1) # 8-byte Folded Reload
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 368(r1)
; BE-NEXT:    ld r3, 192(r1) # 8-byte Folded Reload
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 392(r1)
; BE-NEXT:    ld r3, 200(r1) # 8-byte Folded Reload
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 384(r1)
; BE-NEXT:    ld r3, 208(r1) # 8-byte Folded Reload
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 408(r1)
; BE-NEXT:    ld r3, 216(r1) # 8-byte Folded Reload
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 400(r1)
; BE-NEXT:    addi r3, r1, 416
; BE-NEXT:    lxvd2x vs0, 0, r3
; BE-NEXT:    addi r3, r1, 432
; BE-NEXT:    lxvd2x vs1, 0, r3
; BE-NEXT:    addi r3, r1, 448
; BE-NEXT:    lxvd2x vs2, 0, r3
; BE-NEXT:    addi r3, r1, 464
; BE-NEXT:    lxvd2x vs3, 0, r3
; BE-NEXT:    addi r3, r1, 224
; BE-NEXT:    lxvd2x vs4, 0, r3
; BE-NEXT:    addi r3, r1, 240
; BE-NEXT:    lxvd2x vs5, 0, r3
; BE-NEXT:    addi r3, r1, 256
; BE-NEXT:    lxvd2x vs6, 0, r3
; BE-NEXT:    addi r3, r1, 272
; BE-NEXT:    lxvd2x vs7, 0, r3
; BE-NEXT:    addi r3, r1, 288
; BE-NEXT:    lxvd2x vs8, 0, r3
; BE-NEXT:    addi r3, r1, 304
; BE-NEXT:    lxvd2x vs9, 0, r3
; BE-NEXT:    addi r3, r1, 320
; BE-NEXT:    lxvd2x vs10, 0, r3
; BE-NEXT:    addi r3, r1, 336
; BE-NEXT:    lxvd2x vs11, 0, r3
; BE-NEXT:    addi r3, r1, 352
; BE-NEXT:    lxvd2x vs12, 0, r3
; BE-NEXT:    addi r3, r1, 368
; BE-NEXT:    lxvd2x vs13, 0, r3
; BE-NEXT:    addi r3, r1, 384
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 400
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    li r3, 240
; BE-NEXT:    stxvd2x v3, r30, r3
; BE-NEXT:    li r3, 224
; BE-NEXT:    stxvd2x v2, r30, r3
; BE-NEXT:    li r3, 208
; BE-NEXT:    stxvd2x vs13, r30, r3
; BE-NEXT:    li r3, 192
; BE-NEXT:    stxvd2x vs12, r30, r3
; BE-NEXT:    li r3, 176
; BE-NEXT:    stxvd2x vs11, r30, r3
; BE-NEXT:    li r3, 160
; BE-NEXT:    stxvd2x vs10, r30, r3
; BE-NEXT:    li r3, 144
; BE-NEXT:    stxvd2x vs9, r30, r3
; BE-NEXT:    li r3, 128
; BE-NEXT:    stxvd2x vs8, r30, r3
; BE-NEXT:    li r3, 112
; BE-NEXT:    stxvd2x vs7, r30, r3
; BE-NEXT:    li r3, 96
; BE-NEXT:    stxvd2x vs6, r30, r3
; BE-NEXT:    li r3, 80
; BE-NEXT:    stxvd2x vs5, r30, r3
; BE-NEXT:    li r3, 64
; BE-NEXT:    stxvd2x vs4, r30, r3
; BE-NEXT:    li r3, 48
; BE-NEXT:    stxvd2x vs3, r30, r3
; BE-NEXT:    li r3, 32
; BE-NEXT:    stxvd2x vs2, r30, r3
; BE-NEXT:    li r3, 16
; BE-NEXT:    stxvd2x vs1, r30, r3
; BE-NEXT:    stxvd2x vs0, 0, r30
; BE-NEXT:    ld r31, 616(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r30, 608(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r29, 600(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r28, 592(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r27, 584(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r26, 576(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r25, 568(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r24, 560(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r23, 552(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r22, 544(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r21, 536(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r20, 528(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r19, 520(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r18, 512(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r17, 504(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r16, 496(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r15, 488(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r14, 480(r1) # 8-byte Folded Reload
; BE-NEXT:    addi r1, r1, 624
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v32i64_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -576(r1)
; CHECK-NEXT:    std r0, 592(r1)
; CHECK-NEXT:    std r30, 560(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r30, r3
; CHECK-NEXT:    lhz r3, 864(r1)
; CHECK-NEXT:    li r11, 240
; CHECK-NEXT:    std r14, 432(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r19, 472(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r14, 744(r1)
; CHECK-NEXT:    stxvd2x v20, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    li r11, 256
; CHECK-NEXT:    std r22, 496(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r22, 680(r1)
; CHECK-NEXT:    std r3, 216(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r3, 856(r1)
; CHECK-NEXT:    lhz r19, 672(r1)
; CHECK-NEXT:    stxvd2x v21, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    li r11, 272
; CHECK-NEXT:    std r23, 504(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r23, 688(r1)
; CHECK-NEXT:    stxvd2x v22, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    std r3, 184(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r3, 848(r1)
; CHECK-NEXT:    li r11, 288
; CHECK-NEXT:    std r25, 520(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r25, 696(r1)
; CHECK-NEXT:    stxvd2x v23, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    li r11, 304
; CHECK-NEXT:    std r26, 528(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r27, 536(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r28, 544(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r28, 720(r1)
; CHECK-NEXT:    lhz r27, 712(r1)
; CHECK-NEXT:    lhz r26, 704(r1)
; CHECK-NEXT:    stxvd2x v24, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    std r3, 176(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r3, 840(r1)
; CHECK-NEXT:    li r11, 320
; CHECK-NEXT:    std r29, 552(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r29, 728(r1)
; CHECK-NEXT:    stxvd2x v25, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    std r3, 152(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r3, 832(r1)
; CHECK-NEXT:    li r11, 336
; CHECK-NEXT:    std r31, 568(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r31, 736(r1)
; CHECK-NEXT:    stxvd2x v26, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    li r11, 352
; CHECK-NEXT:    std r15, 440(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r16, 448(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r17, 456(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r17, r6
; CHECK-NEXT:    mr r16, r5
; CHECK-NEXT:    stxvd2x v27, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    std r3, 144(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r3, 824(r1)
; CHECK-NEXT:    li r11, 368
; CHECK-NEXT:    std r18, 464(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r20, 480(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r20, r8
; CHECK-NEXT:    mr r18, r7
; CHECK-NEXT:    stxvd2x v28, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    std r3, 120(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r3, 816(r1)
; CHECK-NEXT:    li r11, 384
; CHECK-NEXT:    std r21, 488(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r24, 512(r1) # 8-byte Folded Spill
; CHECK-NEXT:    mr r24, r10
; CHECK-NEXT:    mr r21, r9
; CHECK-NEXT:    stxvd2x v29, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    li r11, 400
; CHECK-NEXT:    std r3, 112(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r3, 808(r1)
; CHECK-NEXT:    stxvd2x v30, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    li r11, 416
; CHECK-NEXT:    std r3, 104(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r3, 800(r1)
; CHECK-NEXT:    stxvd2x v31, r1, r11 # 16-byte Folded Spill
; CHECK-NEXT:    std r3, 96(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r3, 792(r1)
; CHECK-NEXT:    std r3, 88(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r3, 784(r1)
; CHECK-NEXT:    std r3, 80(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r3, 776(r1)
; CHECK-NEXT:    std r3, 72(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r3, 768(r1)
; CHECK-NEXT:    std r3, 64(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r3, 760(r1)
; CHECK-NEXT:    std r3, 56(r1) # 8-byte Folded Spill
; CHECK-NEXT:    lhz r3, 752(r1)
; CHECK-NEXT:    std r3, 48(r1) # 8-byte Folded Spill
; CHECK-NEXT:    clrldi r3, r4, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r15, r3
; CHECK-NEXT:    clrldi r3, r16, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r15
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 224
; CHECK-NEXT:    xxmrghd vs0, vs0, v31
; CHECK-NEXT:    stxvd2x vs0, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    clrldi r3, r17, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r17, r3
; CHECK-NEXT:    clrldi r3, r18, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r17
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 192
; CHECK-NEXT:    xxmrghd vs0, vs0, v31
; CHECK-NEXT:    stxvd2x vs0, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    clrldi r3, r20, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r20, r3
; CHECK-NEXT:    clrldi r3, r21, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r20
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 160
; CHECK-NEXT:    xxmrghd vs0, vs0, v31
; CHECK-NEXT:    stxvd2x vs0, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    mr r3, r19
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r21, r3
; CHECK-NEXT:    clrldi r3, r24, 48
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r21
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 128
; CHECK-NEXT:    xxmrghd vs0, v31, vs0
; CHECK-NEXT:    stxvd2x vs0, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    mr r3, r22
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r24, r3
; CHECK-NEXT:    mr r3, r23
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r24
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    mr r3, r25
; CHECK-NEXT:    xxmrghd v27, vs0, v31
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r25, r3
; CHECK-NEXT:    mr r3, r26
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r25
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    mr r3, r27
; CHECK-NEXT:    xxmrghd v26, vs0, v31
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r27, r3
; CHECK-NEXT:    mr r3, r28
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r27
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    mr r3, r29
; CHECK-NEXT:    xxmrghd v25, vs0, v31
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    mr r3, r31
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    mr r3, r14
; CHECK-NEXT:    xxmrghd v24, vs0, v31
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    ld r3, 48(r1) # 8-byte Folded Reload
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    ld r3, 56(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxmrghd v23, vs0, v31
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    ld r3, 64(r1) # 8-byte Folded Reload
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    ld r3, 72(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxmrghd v22, vs0, v31
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    ld r3, 80(r1) # 8-byte Folded Reload
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    ld r3, 88(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxmrghd v21, vs0, v31
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    ld r3, 96(r1) # 8-byte Folded Reload
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    ld r3, 104(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxmrghd v20, vs0, v31
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    ld r3, 112(r1) # 8-byte Folded Reload
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    ld r3, 120(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxmrghd v31, vs0, v31
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    ld r3, 144(r1) # 8-byte Folded Reload
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v30, r29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    ld r3, 152(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxmrghd v30, vs0, v30
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    ld r3, 176(r1) # 8-byte Folded Reload
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v29, r29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    ld r3, 184(r1) # 8-byte Folded Reload
; CHECK-NEXT:    xxmrghd v29, vs0, v29
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mr r29, r3
; CHECK-NEXT:    ld r3, 216(r1) # 8-byte Folded Reload
; CHECK-NEXT:    bl __extendhfsf2
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v28, r29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 240
; CHECK-NEXT:    xxswapd vs1, v29
; CHECK-NEXT:    li r4, 128
; CHECK-NEXT:    xxswapd vs2, v30
; CHECK-NEXT:    xxswapd vs3, v25
; CHECK-NEXT:    xxmrghd v2, vs0, v28
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    stxvd2x vs0, r30, r3
; CHECK-NEXT:    li r3, 224
; CHECK-NEXT:    stxvd2x vs1, r30, r3
; CHECK-NEXT:    li r3, 208
; CHECK-NEXT:    stxvd2x vs2, r30, r3
; CHECK-NEXT:    li r3, 192
; CHECK-NEXT:    xxswapd vs0, v31
; CHECK-NEXT:    stxvd2x vs0, r30, r3
; CHECK-NEXT:    li r3, 176
; CHECK-NEXT:    xxswapd vs1, v20
; CHECK-NEXT:    stxvd2x vs1, r30, r3
; CHECK-NEXT:    li r3, 160
; CHECK-NEXT:    xxswapd vs2, v23
; CHECK-NEXT:    xxswapd vs0, v21
; CHECK-NEXT:    stxvd2x vs0, r30, r3
; CHECK-NEXT:    li r3, 144
; CHECK-NEXT:    xxswapd vs1, v22
; CHECK-NEXT:    stxvd2x vs1, r30, r3
; CHECK-NEXT:    li r3, 128
; CHECK-NEXT:    stxvd2x vs2, r30, r3
; CHECK-NEXT:    li r3, 112
; CHECK-NEXT:    xxswapd vs0, v24
; CHECK-NEXT:    stxvd2x vs0, r30, r3
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    stxvd2x vs3, r30, r3
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    lxvd2x vs2, r1, r4 # 16-byte Folded Reload
; CHECK-NEXT:    li r4, 160
; CHECK-NEXT:    xxswapd vs1, v26
; CHECK-NEXT:    stxvd2x vs1, r30, r3
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    lxvd2x vs1, r1, r4 # 16-byte Folded Reload
; CHECK-NEXT:    li r4, 192
; CHECK-NEXT:    lxvd2x vs3, r1, r4 # 16-byte Folded Reload
; CHECK-NEXT:    li r4, 224
; CHECK-NEXT:    lxvd2x vs4, r1, r4 # 16-byte Folded Reload
; CHECK-NEXT:    xxswapd vs0, v27
; CHECK-NEXT:    stxvd2x vs0, r30, r3
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    xxswapd vs2, vs2
; CHECK-NEXT:    stxvd2x vs2, r30, r3
; CHECK-NEXT:    li r3, 32
; CHECK-NEXT:    xxswapd vs1, vs1
; CHECK-NEXT:    stxvd2x vs1, r30, r3
; CHECK-NEXT:    li r3, 16
; CHECK-NEXT:    xxswapd vs3, vs3
; CHECK-NEXT:    stxvd2x vs3, r30, r3
; CHECK-NEXT:    li r3, 416
; CHECK-NEXT:    xxswapd vs4, vs4
; CHECK-NEXT:    stxvd2x vs4, 0, r30
; CHECK-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 400
; CHECK-NEXT:    ld r31, 568(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r30, 560(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r29, 552(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r28, 544(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r27, 536(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r26, 528(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r25, 520(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r24, 512(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r23, 504(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r22, 496(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r21, 488(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r20, 480(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r19, 472(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r18, 464(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r17, 456(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r16, 448(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 384
; CHECK-NEXT:    ld r15, 440(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r14, 432(r1) # 8-byte Folded Reload
; CHECK-NEXT:    lxvd2x v29, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 368
; CHECK-NEXT:    lxvd2x v28, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 352
; CHECK-NEXT:    lxvd2x v27, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 336
; CHECK-NEXT:    lxvd2x v26, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 320
; CHECK-NEXT:    lxvd2x v25, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 304
; CHECK-NEXT:    lxvd2x v24, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 288
; CHECK-NEXT:    lxvd2x v23, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 272
; CHECK-NEXT:    lxvd2x v22, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 256
; CHECK-NEXT:    lxvd2x v21, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 240
; CHECK-NEXT:    lxvd2x v20, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 576
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <32 x i64> @llvm.lrint.v32i64.v32f16(<32 x half> %x)
  ret <32 x i64> %a
}
declare <32 x i64> @llvm.lrint.v32i64.v32f16(<32 x half>)

define <1 x i64> @lrint_v1f32(<1 x float> %x) nounwind {
; BE-LABEL: lrint_v1f32:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -112(r1)
; BE-NEXT:    std r0, 128(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    addi r1, r1, 112
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -32(r1)
; CHECK-NEXT:    std r0, 48(r1)
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    addi r1, r1, 32
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <1 x i64> @llvm.lrint.v1i64.v1f32(<1 x float> %x)
  ret <1 x i64> %a
}
declare <1 x i64> @llvm.lrint.v1i64.v1f32(<1 x float>)

define <2 x i64> @lrint_v2f32(<2 x float> %x) nounwind {
; BE-LABEL: lrint_v2f32:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -144(r1)
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    std r0, 160(r1)
; BE-NEXT:    stxvw4x v2, 0, r3
; BE-NEXT:    lfs f1, 116(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 112(r1)
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r1, r1, 144
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -64(r1)
; CHECK-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    std r0, 80(r1)
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v2
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs0, v31
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    xxmrghd v2, vs0, v31
; CHECK-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 64
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <2 x i64> @llvm.lrint.v2i64.v2f32(<2 x float> %x)
  ret <2 x i64> %a
}
declare <2 x i64> @llvm.lrint.v2i64.v2f32(<2 x float>)

define <4 x i64> @lrint_v4f32(<4 x float> %x) nounwind {
; BE-LABEL: lrint_v4f32:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -160(r1)
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    std r0, 176(r1)
; BE-NEXT:    stxvw4x v2, 0, r3
; BE-NEXT:    lfs f1, 116(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 112(r1)
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 124(r1)
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 120(r1)
; BE-NEXT:    std r3, 152(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 144(r1)
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    addi r1, r1, 160
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -80(r1)
; CHECK-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    std r0, 96(r1)
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    stxvd2x v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v2
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs0, v31
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xscvspdpn f1, v31
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v30, vs0, v30
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxsldwi vs0, v31, v31, 1
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    vmr v2, v30
; CHECK-NEXT:    xxmrghd v3, v31, vs0
; CHECK-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 80
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <4 x i64> @llvm.lrint.v4i64.v4f32(<4 x float> %x)
  ret <4 x i64> %a
}
declare <4 x i64> @llvm.lrint.v4i64.v4f32(<4 x float>)

define <8 x i64> @lrint_v8f32(<8 x float> %x) nounwind {
; BE-LABEL: lrint_v8f32:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -208(r1)
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    std r0, 224(r1)
; BE-NEXT:    stxvw4x v2, 0, r3
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    stxvw4x v3, 0, r3
; BE-NEXT:    lfs f1, 116(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 112(r1)
; BE-NEXT:    std r3, 152(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 124(r1)
; BE-NEXT:    std r3, 144(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 120(r1)
; BE-NEXT:    std r3, 168(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 132(r1)
; BE-NEXT:    std r3, 160(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 128(r1)
; BE-NEXT:    std r3, 184(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 140(r1)
; BE-NEXT:    std r3, 176(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 136(r1)
; BE-NEXT:    std r3, 200(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 192(r1)
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 160
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    addi r3, r1, 176
; BE-NEXT:    lxvd2x v4, 0, r3
; BE-NEXT:    addi r3, r1, 192
; BE-NEXT:    lxvd2x v5, 0, r3
; BE-NEXT:    addi r1, r1, 208
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -112(r1)
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-NEXT:    std r0, 128(r1)
; CHECK-NEXT:    stxvd2x v28, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    stxvd2x v29, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    stxvd2x v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    vmr v30, v2
; CHECK-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v3
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs0, v30
; CHECK-NEXT:    mtvsrd v29, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xscvspdpn f1, v30
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v29, vs0, v29
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxsldwi vs0, v30, v30, 1
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v30, v30, vs0
; CHECK-NEXT:    xxsldwi vs0, v31, v31, 3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs0, v31
; CHECK-NEXT:    mtvsrd v28, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xscvspdpn f1, v31
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v28, vs0, v28
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxsldwi vs0, v31, v31, 1
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    vmr v3, v30
; CHECK-NEXT:    vmr v2, v29
; CHECK-NEXT:    vmr v4, v28
; CHECK-NEXT:    xxmrghd v5, v31, vs0
; CHECK-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    lxvd2x v29, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lxvd2x v28, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 112
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <8 x i64> @llvm.lrint.v8i64.v8f32(<8 x float> %x)
  ret <8 x i64> %a
}
declare <8 x i64> @llvm.lrint.v8i64.v8f32(<8 x float>)

define <16 x i64> @lrint_v16i64_v16f32(<16 x float> %x) nounwind {
; BE-LABEL: lrint_v16i64_v16f32:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -304(r1)
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    std r0, 320(r1)
; BE-NEXT:    stxvw4x v2, 0, r3
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    stxvw4x v3, 0, r3
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    stxvw4x v4, 0, r3
; BE-NEXT:    addi r3, r1, 160
; BE-NEXT:    stxvw4x v5, 0, r3
; BE-NEXT:    lfs f1, 116(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 112(r1)
; BE-NEXT:    std r3, 184(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 124(r1)
; BE-NEXT:    std r3, 176(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 120(r1)
; BE-NEXT:    std r3, 200(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 132(r1)
; BE-NEXT:    std r3, 192(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 128(r1)
; BE-NEXT:    std r3, 216(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 140(r1)
; BE-NEXT:    std r3, 208(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 136(r1)
; BE-NEXT:    std r3, 232(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 148(r1)
; BE-NEXT:    std r3, 224(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 144(r1)
; BE-NEXT:    std r3, 248(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 156(r1)
; BE-NEXT:    std r3, 240(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 152(r1)
; BE-NEXT:    std r3, 264(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 164(r1)
; BE-NEXT:    std r3, 256(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 160(r1)
; BE-NEXT:    std r3, 280(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 172(r1)
; BE-NEXT:    std r3, 272(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 168(r1)
; BE-NEXT:    std r3, 296(r1)
; BE-NEXT:    bl lrintf
; BE-NEXT:    nop
; BE-NEXT:    std r3, 288(r1)
; BE-NEXT:    addi r3, r1, 176
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 192
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    addi r3, r1, 208
; BE-NEXT:    lxvd2x v4, 0, r3
; BE-NEXT:    addi r3, r1, 224
; BE-NEXT:    lxvd2x v5, 0, r3
; BE-NEXT:    addi r3, r1, 240
; BE-NEXT:    lxvd2x v6, 0, r3
; BE-NEXT:    addi r3, r1, 256
; BE-NEXT:    lxvd2x v7, 0, r3
; BE-NEXT:    addi r3, r1, 272
; BE-NEXT:    lxvd2x v8, 0, r3
; BE-NEXT:    addi r3, r1, 288
; BE-NEXT:    lxvd2x v9, 0, r3
; BE-NEXT:    addi r1, r1, 304
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v16i64_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -176(r1)
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    std r0, 192(r1)
; CHECK-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-NEXT:    stxvd2x v24, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    stxvd2x v25, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    stxvd2x v26, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    vmr v26, v3
; CHECK-NEXT:    stxvd2x v27, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 112
; CHECK-NEXT:    stxvd2x v28, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 128
; CHECK-NEXT:    vmr v28, v4
; CHECK-NEXT:    stxvd2x v29, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 144
; CHECK-NEXT:    vmr v29, v2
; CHECK-NEXT:    stxvd2x v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 160
; CHECK-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v5
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs0, v29
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xscvspdpn f1, v29
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v30, vs0, v30
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxsldwi vs0, v29, v29, 1
; CHECK-NEXT:    mtvsrd v29, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v29, v29, vs0
; CHECK-NEXT:    xxsldwi vs0, v26, v26, 3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs0, v26
; CHECK-NEXT:    mtvsrd v27, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xscvspdpn f1, v26
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v27, vs0, v27
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxsldwi vs0, v26, v26, 1
; CHECK-NEXT:    mtvsrd v26, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v26, v26, vs0
; CHECK-NEXT:    xxsldwi vs0, v28, v28, 3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs0, v28
; CHECK-NEXT:    mtvsrd v25, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xscvspdpn f1, v28
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v25, vs0, v25
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxsldwi vs0, v28, v28, 1
; CHECK-NEXT:    mtvsrd v28, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v28, v28, vs0
; CHECK-NEXT:    xxsldwi vs0, v31, v31, 3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs0, v31
; CHECK-NEXT:    mtvsrd v24, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xscvspdpn f1, v31
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxmrghd v24, vs0, v24
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxsldwi vs0, v31, v31, 1
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    bl lrintf
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 160
; CHECK-NEXT:    vmr v2, v30
; CHECK-NEXT:    vmr v3, v29
; CHECK-NEXT:    vmr v7, v28
; CHECK-NEXT:    vmr v4, v27
; CHECK-NEXT:    vmr v5, v26
; CHECK-NEXT:    vmr v6, v25
; CHECK-NEXT:    vmr v8, v24
; CHECK-NEXT:    xxmrghd v9, v31, vs0
; CHECK-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 144
; CHECK-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 128
; CHECK-NEXT:    lxvd2x v29, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 112
; CHECK-NEXT:    lxvd2x v28, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    lxvd2x v27, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    lxvd2x v26, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    lxvd2x v25, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lxvd2x v24, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 176
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <16 x i64> @llvm.lrint.v16i64.v16f32(<16 x float> %x)
  ret <16 x i64> %a
}
declare <16 x i64> @llvm.lrint.v16i64.v16f32(<16 x float>)

define <1 x i64> @lrint_v1f64(<1 x double> %x) nounwind {
; BE-LABEL: lrint_v1f64:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -112(r1)
; BE-NEXT:    std r0, 128(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    addi r1, r1, 112
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -32(r1)
; CHECK-NEXT:    std r0, 48(r1)
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    addi r1, r1, 32
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <1 x i64> @llvm.lrint.v1i64.v1f64(<1 x double> %x)
  ret <1 x i64> %a
}
declare <1 x i64> @llvm.lrint.v1i64.v1f64(<1 x double>)

define <2 x i64> @lrint_v2f64(<2 x double> %x) nounwind {
; BE-LABEL: lrint_v2f64:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -160(r1)
; BE-NEXT:    li r3, 144
; BE-NEXT:    std r0, 176(r1)
; BE-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    vmr v31, v2
; BE-NEXT:    xxlor f1, v31, v31
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxswapd vs1, v31
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    li r3, 144
; BE-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    addi r1, r1, 160
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -64(r1)
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    std r0, 80(r1)
; CHECK-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v2
; CHECK-NEXT:    xxlor f1, v31, v31
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs1, v31
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    xxmrghd v2, v31, vs0
; CHECK-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 64
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <2 x i64> @llvm.lrint.v2i64.v2f64(<2 x double> %x)
  ret <2 x i64> %a
}
declare <2 x i64> @llvm.lrint.v2i64.v2f64(<2 x double>)

define <4 x i64> @lrint_v4f64(<4 x double> %x) nounwind {
; BE-LABEL: lrint_v4f64:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -192(r1)
; BE-NEXT:    li r3, 160
; BE-NEXT:    std r0, 208(r1)
; BE-NEXT:    stxvd2x v30, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    vmr v30, v2
; BE-NEXT:    li r3, 176
; BE-NEXT:    xxlor f1, v30, v30
; BE-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    vmr v31, v3
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxswapd vs1, v30
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxlor f1, v31, v31
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxswapd vs1, v31
; BE-NEXT:    std r3, 144(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    std r3, 152(r1)
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    li r3, 176
; BE-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 160
; BE-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    addi r1, r1, 192
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -80(r1)
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    std r0, 96(r1)
; CHECK-NEXT:    stxvd2x v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v30, v2
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    xxlor f1, v30, v30
; CHECK-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v3
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs1, v30
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxlor f1, v31, v31
; CHECK-NEXT:    xxmrghd v30, v30, vs0
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs1, v31
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    vmr v2, v30
; CHECK-NEXT:    xxmrghd v3, v31, vs0
; CHECK-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 80
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <4 x i64> @llvm.lrint.v4i64.v4f64(<4 x double> %x)
  ret <4 x i64> %a
}
declare <4 x i64> @llvm.lrint.v4i64.v4f64(<4 x double>)

define <8 x i64> @lrint_v8f64(<8 x double> %x) nounwind {
; BE-LABEL: lrint_v8f64:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -256(r1)
; BE-NEXT:    li r3, 192
; BE-NEXT:    std r0, 272(r1)
; BE-NEXT:    stxvd2x v28, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 208
; BE-NEXT:    vmr v28, v2
; BE-NEXT:    stxvd2x v29, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 224
; BE-NEXT:    xxlor f1, v28, v28
; BE-NEXT:    vmr v29, v3
; BE-NEXT:    stxvd2x v30, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 240
; BE-NEXT:    vmr v30, v4
; BE-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    vmr v31, v5
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxswapd vs1, v28
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxlor f1, v29, v29
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxswapd vs1, v29
; BE-NEXT:    std r3, 144(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxlor f1, v30, v30
; BE-NEXT:    std r3, 152(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxswapd vs1, v30
; BE-NEXT:    std r3, 160(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxlor f1, v31, v31
; BE-NEXT:    std r3, 168(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    xxswapd vs1, v31
; BE-NEXT:    std r3, 176(r1)
; BE-NEXT:    bl lrint
; BE-NEXT:    nop
; BE-NEXT:    std r3, 184(r1)
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    addi r3, r1, 160
; BE-NEXT:    lxvd2x v4, 0, r3
; BE-NEXT:    addi r3, r1, 176
; BE-NEXT:    lxvd2x v5, 0, r3
; BE-NEXT:    li r3, 240
; BE-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 224
; BE-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 208
; BE-NEXT:    lxvd2x v29, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 192
; BE-NEXT:    lxvd2x v28, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    addi r1, r1, 256
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -112(r1)
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    std r0, 128(r1)
; CHECK-NEXT:    stxvd2x v28, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    vmr v28, v2
; CHECK-NEXT:    stxvd2x v29, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    xxlor f1, v28, v28
; CHECK-NEXT:    vmr v29, v3
; CHECK-NEXT:    stxvd2x v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    vmr v30, v4
; CHECK-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v5
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs1, v28
; CHECK-NEXT:    mtvsrd v28, r3
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxlor f1, v29, v29
; CHECK-NEXT:    xxmrghd v28, v28, vs0
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs1, v29
; CHECK-NEXT:    mtvsrd v29, r3
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxlor f1, v30, v30
; CHECK-NEXT:    xxmrghd v29, v29, vs0
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs1, v30
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxlor f1, v31, v31
; CHECK-NEXT:    xxmrghd v30, v30, vs0
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    xxswapd vs1, v31
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    bl lrint
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    vmr v4, v30
; CHECK-NEXT:    vmr v3, v29
; CHECK-NEXT:    vmr v2, v28
; CHECK-NEXT:    xxmrghd v5, v31, vs0
; CHECK-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    lxvd2x v29, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lxvd2x v28, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 112
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <8 x i64> @llvm.lrint.v8i64.v8f64(<8 x double> %x)
  ret <8 x i64> %a
}
declare <8 x i64> @llvm.lrint.v8i64.v8f64(<8 x double>)

define <1 x i64> @lrint_v1f128(<1 x fp128> %x) nounwind {
; BE-LABEL: lrint_v1f128:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -112(r1)
; BE-NEXT:    std r0, 128(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    addi r1, r1, 112
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v1f128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -32(r1)
; CHECK-NEXT:    std r0, 48(r1)
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    addi r1, r1, 32
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <1 x i64> @llvm.lrint.v1i64.v1f128(<1 x fp128> %x)
  ret <1 x i64> %a
}
declare <1 x i64> @llvm.lrint.v1i64.v1f128(<1 x fp128>)

define <2 x i64> @lrint_v2f128(<2 x fp128> %x) nounwind {
; BE-LABEL: lrint_v2f128:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -160(r1)
; BE-NEXT:    li r3, 144
; BE-NEXT:    std r0, 176(r1)
; BE-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    vmr v31, v2
; BE-NEXT:    vmr v2, v3
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v31
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    li r3, 144
; BE-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    addi r1, r1, 160
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v2f128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -80(r1)
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    std r0, 96(r1)
; CHECK-NEXT:    stxvd2x v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v3
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    vmr v2, v31
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    xxmrghd v2, vs0, v30
; CHECK-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 80
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <2 x i64> @llvm.lrint.v2i64.v2f128(<2 x fp128> %x)
  ret <2 x i64> %a
}
declare <2 x i64> @llvm.lrint.v2i64.v2f128(<2 x fp128>)

define <4 x i64> @lrint_v4f128(<4 x fp128> %x) nounwind {
; BE-LABEL: lrint_v4f128:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -208(r1)
; BE-NEXT:    li r3, 160
; BE-NEXT:    std r0, 224(r1)
; BE-NEXT:    stxvd2x v29, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 176
; BE-NEXT:    vmr v29, v2
; BE-NEXT:    vmr v2, v3
; BE-NEXT:    stxvd2x v30, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 192
; BE-NEXT:    vmr v30, v4
; BE-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    vmr v31, v5
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v29
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v31
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v30
; BE-NEXT:    std r3, 152(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    std r3, 144(r1)
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    li r3, 192
; BE-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 176
; BE-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 160
; BE-NEXT:    lxvd2x v29, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    addi r1, r1, 208
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v4f128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -112(r1)
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    std r0, 128(r1)
; CHECK-NEXT:    stxvd2x v28, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    stxvd2x v29, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    vmr v29, v3
; CHECK-NEXT:    stxvd2x v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    vmr v30, v4
; CHECK-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v5
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    vmr v2, v29
; CHECK-NEXT:    mtvsrd v28, r3
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    vmr v2, v30
; CHECK-NEXT:    xxmrghd v29, vs0, v28
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    vmr v2, v31
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    vmr v2, v29
; CHECK-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    xxmrghd v3, vs0, v30
; CHECK-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    lxvd2x v29, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lxvd2x v28, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 112
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <4 x i64> @llvm.lrint.v4i64.v4f128(<4 x fp128> %x)
  ret <4 x i64> %a
}
declare <4 x i64> @llvm.lrint.v4i64.v4f128(<4 x fp128>)

define <8 x i64> @lrint_v8f128(<8 x fp128> %x) nounwind {
; BE-LABEL: lrint_v8f128:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -304(r1)
; BE-NEXT:    li r3, 192
; BE-NEXT:    std r0, 320(r1)
; BE-NEXT:    stxvd2x v25, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 208
; BE-NEXT:    vmr v25, v2
; BE-NEXT:    vmr v2, v3
; BE-NEXT:    stxvd2x v26, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 224
; BE-NEXT:    vmr v26, v4
; BE-NEXT:    stxvd2x v27, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 240
; BE-NEXT:    vmr v27, v5
; BE-NEXT:    stxvd2x v28, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 256
; BE-NEXT:    vmr v28, v6
; BE-NEXT:    stxvd2x v29, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 272
; BE-NEXT:    vmr v29, v7
; BE-NEXT:    stxvd2x v30, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 288
; BE-NEXT:    vmr v30, v8
; BE-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    vmr v31, v9
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v25
; BE-NEXT:    std r3, 136(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v27
; BE-NEXT:    std r3, 128(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v26
; BE-NEXT:    std r3, 152(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v29
; BE-NEXT:    std r3, 144(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v28
; BE-NEXT:    std r3, 168(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v31
; BE-NEXT:    std r3, 160(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v30
; BE-NEXT:    std r3, 184(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    std r3, 176(r1)
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    addi r3, r1, 160
; BE-NEXT:    lxvd2x v4, 0, r3
; BE-NEXT:    addi r3, r1, 176
; BE-NEXT:    lxvd2x v5, 0, r3
; BE-NEXT:    li r3, 288
; BE-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 272
; BE-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 256
; BE-NEXT:    lxvd2x v29, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 240
; BE-NEXT:    lxvd2x v28, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 224
; BE-NEXT:    lxvd2x v27, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 208
; BE-NEXT:    lxvd2x v26, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 192
; BE-NEXT:    lxvd2x v25, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    addi r1, r1, 304
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v8f128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -176(r1)
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    std r0, 192(r1)
; CHECK-NEXT:    stxvd2x v24, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    stxvd2x v25, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    vmr v25, v3
; CHECK-NEXT:    stxvd2x v26, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    vmr v26, v4
; CHECK-NEXT:    stxvd2x v27, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 112
; CHECK-NEXT:    vmr v27, v5
; CHECK-NEXT:    stxvd2x v28, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 128
; CHECK-NEXT:    vmr v28, v6
; CHECK-NEXT:    stxvd2x v29, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 144
; CHECK-NEXT:    vmr v29, v7
; CHECK-NEXT:    stxvd2x v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 160
; CHECK-NEXT:    vmr v30, v8
; CHECK-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    vmr v31, v9
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    vmr v2, v25
; CHECK-NEXT:    mtvsrd v24, r3
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    vmr v2, v26
; CHECK-NEXT:    xxmrghd v25, vs0, v24
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    vmr v2, v27
; CHECK-NEXT:    mtvsrd v26, r3
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    vmr v2, v28
; CHECK-NEXT:    xxmrghd v27, vs0, v26
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    vmr v2, v29
; CHECK-NEXT:    mtvsrd v28, r3
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    vmr v2, v30
; CHECK-NEXT:    xxmrghd v29, vs0, v28
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    vmr v2, v31
; CHECK-NEXT:    mtvsrd v30, r3
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 160
; CHECK-NEXT:    vmr v4, v29
; CHECK-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 144
; CHECK-NEXT:    vmr v3, v27
; CHECK-NEXT:    vmr v2, v25
; CHECK-NEXT:    xxmrghd v5, vs0, v30
; CHECK-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 128
; CHECK-NEXT:    lxvd2x v29, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 112
; CHECK-NEXT:    lxvd2x v28, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    lxvd2x v27, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    lxvd2x v26, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    lxvd2x v25, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lxvd2x v24, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 176
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <8 x i64> @llvm.lrint.v8i64.v8f128(<8 x fp128> %x)
  ret <8 x i64> %a
}
declare <8 x i64> @llvm.lrint.v8i64.v8f128(<8 x fp128>)

define <16 x i64> @lrint_v16i64_v16f128(<16 x fp128> %x) nounwind {
; BE-LABEL: lrint_v16i64_v16f128:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -496(r1)
; BE-NEXT:    li r3, 304
; BE-NEXT:    std r0, 512(r1)
; BE-NEXT:    stxvd2x v20, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 320
; BE-NEXT:    stxvd2x v21, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 336
; BE-NEXT:    vmr v21, v2
; BE-NEXT:    vmr v2, v3
; BE-NEXT:    stxvd2x v22, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 352
; BE-NEXT:    vmr v22, v4
; BE-NEXT:    stxvd2x v23, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 368
; BE-NEXT:    vmr v23, v5
; BE-NEXT:    stxvd2x v24, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 384
; BE-NEXT:    vmr v24, v6
; BE-NEXT:    stxvd2x v25, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 400
; BE-NEXT:    vmr v25, v7
; BE-NEXT:    stxvd2x v26, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 416
; BE-NEXT:    vmr v26, v8
; BE-NEXT:    stxvd2x v27, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 432
; BE-NEXT:    vmr v27, v9
; BE-NEXT:    stxvd2x v28, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 448
; BE-NEXT:    vmr v28, v11
; BE-NEXT:    stxvd2x v29, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 464
; BE-NEXT:    vmr v29, v10
; BE-NEXT:    stxvd2x v30, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 480
; BE-NEXT:    vmr v30, v13
; BE-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    li r3, 128
; BE-NEXT:    stxvd2x v12, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    addi r3, r1, 768
; BE-NEXT:    lxvw4x vs0, 0, r3
; BE-NEXT:    li r3, 160
; BE-NEXT:    stxvd2x vs0, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    addi r3, r1, 784
; BE-NEXT:    lxvw4x vs0, 0, r3
; BE-NEXT:    li r3, 144
; BE-NEXT:    stxvd2x vs0, r1, r3 # 16-byte Folded Spill
; BE-NEXT:    addi r3, r1, 736
; BE-NEXT:    lxvw4x v20, 0, r3
; BE-NEXT:    addi r3, r1, 752
; BE-NEXT:    lxvw4x v31, 0, r3
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v21
; BE-NEXT:    std r3, 184(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v23
; BE-NEXT:    std r3, 176(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v22
; BE-NEXT:    std r3, 200(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v25
; BE-NEXT:    std r3, 192(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v24
; BE-NEXT:    std r3, 216(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v27
; BE-NEXT:    std r3, 208(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v26
; BE-NEXT:    std r3, 232(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v28
; BE-NEXT:    std r3, 224(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v29
; BE-NEXT:    std r3, 248(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v30
; BE-NEXT:    std r3, 240(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    std r3, 264(r1)
; BE-NEXT:    li r3, 128
; BE-NEXT:    lxvd2x v2, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v31
; BE-NEXT:    std r3, 256(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    vmr v2, v20
; BE-NEXT:    std r3, 280(r1)
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    std r3, 272(r1)
; BE-NEXT:    li r3, 144
; BE-NEXT:    lxvd2x v2, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    std r3, 296(r1)
; BE-NEXT:    li r3, 160
; BE-NEXT:    lxvd2x v2, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    bl lrintf128
; BE-NEXT:    nop
; BE-NEXT:    std r3, 288(r1)
; BE-NEXT:    addi r3, r1, 176
; BE-NEXT:    lxvd2x v2, 0, r3
; BE-NEXT:    addi r3, r1, 192
; BE-NEXT:    lxvd2x v3, 0, r3
; BE-NEXT:    addi r3, r1, 208
; BE-NEXT:    lxvd2x v4, 0, r3
; BE-NEXT:    addi r3, r1, 224
; BE-NEXT:    lxvd2x v5, 0, r3
; BE-NEXT:    addi r3, r1, 240
; BE-NEXT:    lxvd2x v6, 0, r3
; BE-NEXT:    addi r3, r1, 256
; BE-NEXT:    lxvd2x v7, 0, r3
; BE-NEXT:    addi r3, r1, 272
; BE-NEXT:    lxvd2x v8, 0, r3
; BE-NEXT:    addi r3, r1, 288
; BE-NEXT:    lxvd2x v9, 0, r3
; BE-NEXT:    li r3, 480
; BE-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 464
; BE-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 448
; BE-NEXT:    lxvd2x v29, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 432
; BE-NEXT:    lxvd2x v28, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 416
; BE-NEXT:    lxvd2x v27, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 400
; BE-NEXT:    lxvd2x v26, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 384
; BE-NEXT:    lxvd2x v25, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 368
; BE-NEXT:    lxvd2x v24, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 352
; BE-NEXT:    lxvd2x v23, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 336
; BE-NEXT:    lxvd2x v22, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 320
; BE-NEXT:    lxvd2x v21, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    li r3, 304
; BE-NEXT:    lxvd2x v20, r1, r3 # 16-byte Folded Reload
; BE-NEXT:    addi r1, r1, 496
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
;
; CHECK-LABEL: lrint_v16i64_v16f128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    stdu r1, -304(r1)
; CHECK-NEXT:    li r3, 112
; CHECK-NEXT:    std r0, 320(r1)
; CHECK-NEXT:    stxvd2x v20, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 128
; CHECK-NEXT:    stxvd2x v21, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 144
; CHECK-NEXT:    vmr v21, v4
; CHECK-NEXT:    stxvd2x v22, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 160
; CHECK-NEXT:    vmr v22, v6
; CHECK-NEXT:    stxvd2x v23, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 176
; CHECK-NEXT:    vmr v23, v8
; CHECK-NEXT:    stxvd2x v24, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 192
; CHECK-NEXT:    vmr v24, v9
; CHECK-NEXT:    stxvd2x v25, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 208
; CHECK-NEXT:    vmr v25, v7
; CHECK-NEXT:    stxvd2x v26, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 224
; CHECK-NEXT:    vmr v26, v10
; CHECK-NEXT:    stxvd2x v27, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 240
; CHECK-NEXT:    vmr v27, v5
; CHECK-NEXT:    stxvd2x v28, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 256
; CHECK-NEXT:    vmr v28, v11
; CHECK-NEXT:    stxvd2x v29, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 272
; CHECK-NEXT:    vmr v29, v12
; CHECK-NEXT:    stxvd2x v30, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 288
; CHECK-NEXT:    vmr v30, v3
; CHECK-NEXT:    stxvd2x v31, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    stxvd2x v13, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    addi r3, r1, 576
; CHECK-NEXT:    lxvd2x vs0, 0, r3
; CHECK-NEXT:    addi r3, r1, 560
; CHECK-NEXT:    lxvd2x vs1, 0, r3
; CHECK-NEXT:    addi r3, r1, 544
; CHECK-NEXT:    lxvd2x vs2, 0, r3
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    xxswapd vs0, vs0
; CHECK-NEXT:    stxvd2x vs0, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    xxswapd vs0, vs1
; CHECK-NEXT:    stxvd2x vs0, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    xxswapd vs0, vs2
; CHECK-NEXT:    stxvd2x vs0, r1, r3 # 16-byte Folded Spill
; CHECK-NEXT:    addi r3, r1, 528
; CHECK-NEXT:    lxvd2x vs0, 0, r3
; CHECK-NEXT:    xxswapd v31, vs0
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    vmr v2, v30
; CHECK-NEXT:    mtvsrd v20, r3
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    vmr v2, v21
; CHECK-NEXT:    xxmrghd v30, vs0, v20
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    vmr v2, v27
; CHECK-NEXT:    mtvsrd v21, r3
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    vmr v2, v22
; CHECK-NEXT:    xxmrghd v27, vs0, v21
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    vmr v2, v25
; CHECK-NEXT:    mtvsrd v22, r3
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    vmr v2, v23
; CHECK-NEXT:    xxmrghd v25, vs0, v22
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    vmr v2, v24
; CHECK-NEXT:    mtvsrd v23, r3
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    vmr v2, v26
; CHECK-NEXT:    xxmrghd v24, vs0, v23
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    vmr v2, v28
; CHECK-NEXT:    mtvsrd v26, r3
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    vmr v2, v29
; CHECK-NEXT:    xxmrghd v28, vs0, v26
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v29, r3
; CHECK-NEXT:    li r3, 64
; CHECK-NEXT:    lxvd2x v2, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    vmr v2, v31
; CHECK-NEXT:    xxmrghd v29, vs0, v29
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v31, r3
; CHECK-NEXT:    li r3, 48
; CHECK-NEXT:    lxvd2x v2, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 80
; CHECK-NEXT:    lxvd2x v2, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    xxmrghd v31, vs0, v31
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtvsrd v26, r3
; CHECK-NEXT:    li r3, 96
; CHECK-NEXT:    lxvd2x v2, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    bl lrintf128
; CHECK-NEXT:    nop
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    li r3, 288
; CHECK-NEXT:    vmr v8, v31
; CHECK-NEXT:    lxvd2x v31, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 272
; CHECK-NEXT:    vmr v2, v30
; CHECK-NEXT:    vmr v7, v29
; CHECK-NEXT:    vmr v6, v28
; CHECK-NEXT:    vmr v3, v27
; CHECK-NEXT:    lxvd2x v30, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 256
; CHECK-NEXT:    vmr v4, v25
; CHECK-NEXT:    vmr v5, v24
; CHECK-NEXT:    lxvd2x v29, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 240
; CHECK-NEXT:    lxvd2x v28, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 224
; CHECK-NEXT:    lxvd2x v27, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 208
; CHECK-NEXT:    xxmrghd v9, vs0, v26
; CHECK-NEXT:    lxvd2x v26, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 192
; CHECK-NEXT:    lxvd2x v25, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 176
; CHECK-NEXT:    lxvd2x v24, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 160
; CHECK-NEXT:    lxvd2x v23, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 144
; CHECK-NEXT:    lxvd2x v22, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 128
; CHECK-NEXT:    lxvd2x v21, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    li r3, 112
; CHECK-NEXT:    lxvd2x v20, r1, r3 # 16-byte Folded Reload
; CHECK-NEXT:    addi r1, r1, 304
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
  %a = call <16 x i64> @llvm.lrint.v16i64.v16f128(<16 x fp128> %x)
  ret <16 x i64> %a
}
declare <16 x i64> @llvm.lrint.v16i64.v16f128(<16 x fp128>)
