; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s -mtriple=powerpc64-unknown-linux-gnu -mcpu=pwr7 -mattr=-vsx \
; RUN:   -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr | FileCheck --check-prefix=CHECK-P7 %s
; RUN: llc -verify-machineinstrs < %s -mtriple=powerpc64le-unknown-linux-gnu -mcpu=pwr8 \
; RUN:   -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr | FileCheck --check-prefix=CHECK-P8 %s
; RUN: llc -verify-machineinstrs < %s -mtriple=powerpc64le-unknown-linux-gnu -mcpu=pwr9 \
; RUN:   -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr | FileCheck --check-prefix=CHECK-P9 %s

target datalayout = "E-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-f128:128:128-v128:128:128-n32:64"

declare double @llvm.sqrt.f64(double)
declare float @llvm.sqrt.f32(float)
declare fp128 @llvm.sqrt.f128(fp128)
declare <4 x float> @llvm.sqrt.v4f32(<4 x float>)
declare <2 x double> @llvm.sqrt.v2f64(<2 x double>)

define double @foo_fmf(double %a, double %b) nounwind {
; CHECK-P7-LABEL: foo_fmf:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    frsqrte f0, f2
; CHECK-P7-NEXT:    addis r3, r2, .LCPI0_0@toc@ha
; CHECK-P7-NEXT:    lfs f4, .LCPI0_0@toc@l(r3)
; CHECK-P7-NEXT:    addis r3, r2, .LCPI0_1@toc@ha
; CHECK-P7-NEXT:    lfs f5, .LCPI0_1@toc@l(r3)
; CHECK-P7-NEXT:    fmul f3, f2, f0
; CHECK-P7-NEXT:    fmadd f3, f3, f0, f4
; CHECK-P7-NEXT:    fmul f0, f0, f5
; CHECK-P7-NEXT:    fmul f0, f0, f3
; CHECK-P7-NEXT:    fmul f2, f2, f0
; CHECK-P7-NEXT:    fmadd f2, f2, f0, f4
; CHECK-P7-NEXT:    fmul f0, f0, f5
; CHECK-P7-NEXT:    fmul f0, f0, f2
; CHECK-P7-NEXT:    fmul f1, f1, f0
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: foo_fmf:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    vspltisw v2, -3
; CHECK-P8-NEXT:    xsrsqrtedp f0, f2
; CHECK-P8-NEXT:    addis r3, r2, .LCPI0_0@toc@ha
; CHECK-P8-NEXT:    xvcvsxwdp vs4, v2
; CHECK-P8-NEXT:    xsmuldp f3, f2, f0
; CHECK-P8-NEXT:    fmr f5, f4
; CHECK-P8-NEXT:    xsmaddadp f5, f3, f0
; CHECK-P8-NEXT:    lfs f3, .LCPI0_0@toc@l(r3)
; CHECK-P8-NEXT:    xsmuldp f0, f0, f3
; CHECK-P8-NEXT:    xsmuldp f0, f0, f5
; CHECK-P8-NEXT:    xsmuldp f2, f2, f0
; CHECK-P8-NEXT:    xsmaddadp f4, f2, f0
; CHECK-P8-NEXT:    xsmuldp f0, f0, f3
; CHECK-P8-NEXT:    xsmuldp f0, f0, f4
; CHECK-P8-NEXT:    xsmuldp f1, f1, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: foo_fmf:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xsrsqrtedp f0, f2
; CHECK-P9-NEXT:    vspltisw v2, -3
; CHECK-P9-NEXT:    addis r3, r2, .LCPI0_0@toc@ha
; CHECK-P9-NEXT:    xsmuldp f3, f2, f0
; CHECK-P9-NEXT:    xvcvsxwdp vs4, v2
; CHECK-P9-NEXT:    fmr f5, f4
; CHECK-P9-NEXT:    xsmaddadp f5, f3, f0
; CHECK-P9-NEXT:    lfs f3, .LCPI0_0@toc@l(r3)
; CHECK-P9-NEXT:    xsmuldp f0, f0, f3
; CHECK-P9-NEXT:    xsmuldp f0, f0, f5
; CHECK-P9-NEXT:    xsmuldp f2, f2, f0
; CHECK-P9-NEXT:    xsmaddadp f4, f2, f0
; CHECK-P9-NEXT:    xsmuldp f0, f0, f3
; CHECK-P9-NEXT:    xsmuldp f0, f0, f4
; CHECK-P9-NEXT:    xsmuldp f1, f1, f0
; CHECK-P9-NEXT:    blr
  %x = call arcp contract reassoc double @llvm.sqrt.f64(double %b)
  %r = fdiv arcp contract reassoc double %a, %x
  ret double %r
}

define double @foo_safe(double %a, double %b) nounwind {
; CHECK-P7-LABEL: foo_safe:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    fsqrt f0, f2
; CHECK-P7-NEXT:    fdiv f1, f1, f0
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: foo_safe:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xssqrtdp f0, f2
; CHECK-P8-NEXT:    xsdivdp f1, f1, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: foo_safe:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xssqrtdp f0, f2
; CHECK-P9-NEXT:    xsdivdp f1, f1, f0
; CHECK-P9-NEXT:    blr
  %x = call double @llvm.sqrt.f64(double %b)
  %r = fdiv double %a, %x
  ret double %r
}

define double @no_estimate_refinement_f64(double %a, double %b) #0 {
; CHECK-P7-LABEL: no_estimate_refinement_f64:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    frsqrte f0, f2
; CHECK-P7-NEXT:    fmul f1, f1, f0
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: no_estimate_refinement_f64:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xsrsqrtedp f0, f2
; CHECK-P8-NEXT:    xsmuldp f1, f1, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: no_estimate_refinement_f64:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xsrsqrtedp f0, f2
; CHECK-P9-NEXT:    xsmuldp f1, f1, f0
; CHECK-P9-NEXT:    blr
  %x = call arcp reassoc double @llvm.sqrt.f64(double %b)
  %r = fdiv arcp reassoc double %a, %x
  ret double %r
}

define double @foof_fmf(double %a, float %b) nounwind {
; CHECK-P7-LABEL: foof_fmf:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    frsqrtes f0, f2
; CHECK-P7-NEXT:    addis r3, r2, .LCPI3_0@toc@ha
; CHECK-P7-NEXT:    lfs f3, .LCPI3_0@toc@l(r3)
; CHECK-P7-NEXT:    addis r3, r2, .LCPI3_1@toc@ha
; CHECK-P7-NEXT:    fmuls f2, f2, f0
; CHECK-P7-NEXT:    fmadds f2, f2, f0, f3
; CHECK-P7-NEXT:    lfs f3, .LCPI3_1@toc@l(r3)
; CHECK-P7-NEXT:    fmuls f0, f0, f3
; CHECK-P7-NEXT:    fmuls f0, f0, f2
; CHECK-P7-NEXT:    fmul f1, f1, f0
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: foof_fmf:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xsrsqrtesp f0, f2
; CHECK-P8-NEXT:    vspltisw v2, -3
; CHECK-P8-NEXT:    addis r3, r2, .LCPI3_0@toc@ha
; CHECK-P8-NEXT:    xvcvsxwdp vs3, v2
; CHECK-P8-NEXT:    xsmulsp f2, f2, f0
; CHECK-P8-NEXT:    xsmaddasp f3, f2, f0
; CHECK-P8-NEXT:    lfs f2, .LCPI3_0@toc@l(r3)
; CHECK-P8-NEXT:    xsmulsp f0, f0, f2
; CHECK-P8-NEXT:    xsmulsp f0, f0, f3
; CHECK-P8-NEXT:    xsmuldp f1, f1, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: foof_fmf:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xsrsqrtesp f0, f2
; CHECK-P9-NEXT:    vspltisw v2, -3
; CHECK-P9-NEXT:    addis r3, r2, .LCPI3_0@toc@ha
; CHECK-P9-NEXT:    xsmulsp f2, f2, f0
; CHECK-P9-NEXT:    xvcvsxwdp vs3, v2
; CHECK-P9-NEXT:    xsmaddasp f3, f2, f0
; CHECK-P9-NEXT:    lfs f2, .LCPI3_0@toc@l(r3)
; CHECK-P9-NEXT:    xsmulsp f0, f0, f2
; CHECK-P9-NEXT:    xsmulsp f0, f0, f3
; CHECK-P9-NEXT:    xsmuldp f1, f1, f0
; CHECK-P9-NEXT:    blr
  %x = call contract reassoc arcp float @llvm.sqrt.f32(float %b)
  %y = fpext arcp float %x to double
  %r = fdiv contract reassoc arcp double %a, %y
  ret double %r
}

define double @foof_safe(double %a, float %b) nounwind {
; CHECK-P7-LABEL: foof_safe:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    fsqrts f0, f2
; CHECK-P7-NEXT:    fdiv f1, f1, f0
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: foof_safe:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xssqrtsp f0, f2
; CHECK-P8-NEXT:    xsdivdp f1, f1, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: foof_safe:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xssqrtsp f0, f2
; CHECK-P9-NEXT:    xsdivdp f1, f1, f0
; CHECK-P9-NEXT:    blr
  %x = call float @llvm.sqrt.f32(float %b)
  %y = fpext float %x to double
  %r = fdiv double %a, %y
  ret double %r
}

define float @food_fmf(float %a, double %b) nounwind {
; CHECK-P7-LABEL: food_fmf:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    frsqrte f0, f2
; CHECK-P7-NEXT:    addis r3, r2, .LCPI5_0@toc@ha
; CHECK-P7-NEXT:    lfs f4, .LCPI5_0@toc@l(r3)
; CHECK-P7-NEXT:    addis r3, r2, .LCPI5_1@toc@ha
; CHECK-P7-NEXT:    lfs f5, .LCPI5_1@toc@l(r3)
; CHECK-P7-NEXT:    fmul f3, f2, f0
; CHECK-P7-NEXT:    fmadd f3, f3, f0, f4
; CHECK-P7-NEXT:    fmul f0, f0, f5
; CHECK-P7-NEXT:    fmul f0, f0, f3
; CHECK-P7-NEXT:    fmul f2, f2, f0
; CHECK-P7-NEXT:    fmadd f2, f2, f0, f4
; CHECK-P7-NEXT:    fmul f0, f0, f5
; CHECK-P7-NEXT:    fmul f0, f0, f2
; CHECK-P7-NEXT:    frsp f0, f0
; CHECK-P7-NEXT:    fmuls f1, f1, f0
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: food_fmf:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    vspltisw v2, -3
; CHECK-P8-NEXT:    xsrsqrtedp f0, f2
; CHECK-P8-NEXT:    addis r3, r2, .LCPI5_0@toc@ha
; CHECK-P8-NEXT:    xvcvsxwdp vs4, v2
; CHECK-P8-NEXT:    xsmuldp f3, f2, f0
; CHECK-P8-NEXT:    fmr f5, f4
; CHECK-P8-NEXT:    xsmaddadp f5, f3, f0
; CHECK-P8-NEXT:    lfs f3, .LCPI5_0@toc@l(r3)
; CHECK-P8-NEXT:    xsmuldp f0, f0, f3
; CHECK-P8-NEXT:    xsmuldp f0, f0, f5
; CHECK-P8-NEXT:    xsmuldp f2, f2, f0
; CHECK-P8-NEXT:    xsmaddadp f4, f2, f0
; CHECK-P8-NEXT:    xsmuldp f0, f0, f3
; CHECK-P8-NEXT:    xsmuldp f0, f0, f4
; CHECK-P8-NEXT:    xsrsp f0, f0
; CHECK-P8-NEXT:    xsmulsp f1, f1, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: food_fmf:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xsrsqrtedp f0, f2
; CHECK-P9-NEXT:    vspltisw v2, -3
; CHECK-P9-NEXT:    addis r3, r2, .LCPI5_0@toc@ha
; CHECK-P9-NEXT:    xsmuldp f3, f2, f0
; CHECK-P9-NEXT:    xvcvsxwdp vs4, v2
; CHECK-P9-NEXT:    fmr f5, f4
; CHECK-P9-NEXT:    xsmaddadp f5, f3, f0
; CHECK-P9-NEXT:    lfs f3, .LCPI5_0@toc@l(r3)
; CHECK-P9-NEXT:    xsmuldp f0, f0, f3
; CHECK-P9-NEXT:    xsmuldp f0, f0, f5
; CHECK-P9-NEXT:    xsmuldp f2, f2, f0
; CHECK-P9-NEXT:    xsmaddadp f4, f2, f0
; CHECK-P9-NEXT:    xsmuldp f0, f0, f3
; CHECK-P9-NEXT:    xsmuldp f0, f0, f4
; CHECK-P9-NEXT:    xsrsp f0, f0
; CHECK-P9-NEXT:    xsmulsp f1, f1, f0
; CHECK-P9-NEXT:    blr
  %x = call contract reassoc arcp double @llvm.sqrt.f64(double %b)
  %y = fptrunc double %x to float
  %r = fdiv contract reassoc arcp float %a, %y
  ret float %r
}

define float @food_safe(float %a, double %b) nounwind {
; CHECK-P7-LABEL: food_safe:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    fsqrt f0, f2
; CHECK-P7-NEXT:    frsp f0, f0
; CHECK-P7-NEXT:    fdivs f1, f1, f0
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: food_safe:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xssqrtdp f0, f2
; CHECK-P8-NEXT:    xsrsp f0, f0
; CHECK-P8-NEXT:    xsdivsp f1, f1, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: food_safe:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xssqrtdp f0, f2
; CHECK-P9-NEXT:    xsrsp f0, f0
; CHECK-P9-NEXT:    xsdivsp f1, f1, f0
; CHECK-P9-NEXT:    blr
  %x = call double @llvm.sqrt.f64(double %b)
  %y = fptrunc double %x to float
  %r = fdiv float %a, %y
  ret float %r
}

define float @goo_fmf(float %a, float %b) nounwind {
; CHECK-P7-LABEL: goo_fmf:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    frsqrtes f0, f2
; CHECK-P7-NEXT:    addis r3, r2, .LCPI7_0@toc@ha
; CHECK-P7-NEXT:    lfs f3, .LCPI7_0@toc@l(r3)
; CHECK-P7-NEXT:    addis r3, r2, .LCPI7_1@toc@ha
; CHECK-P7-NEXT:    fmuls f2, f2, f0
; CHECK-P7-NEXT:    fmadds f2, f2, f0, f3
; CHECK-P7-NEXT:    lfs f3, .LCPI7_1@toc@l(r3)
; CHECK-P7-NEXT:    fmuls f0, f0, f3
; CHECK-P7-NEXT:    fmuls f0, f0, f2
; CHECK-P7-NEXT:    fmuls f1, f1, f0
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: goo_fmf:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xsrsqrtesp f0, f2
; CHECK-P8-NEXT:    vspltisw v2, -3
; CHECK-P8-NEXT:    addis r3, r2, .LCPI7_0@toc@ha
; CHECK-P8-NEXT:    xvcvsxwdp vs3, v2
; CHECK-P8-NEXT:    xsmulsp f2, f2, f0
; CHECK-P8-NEXT:    xsmaddasp f3, f2, f0
; CHECK-P8-NEXT:    lfs f2, .LCPI7_0@toc@l(r3)
; CHECK-P8-NEXT:    xsmulsp f0, f0, f2
; CHECK-P8-NEXT:    xsmulsp f0, f0, f3
; CHECK-P8-NEXT:    xsmulsp f1, f1, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: goo_fmf:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xsrsqrtesp f0, f2
; CHECK-P9-NEXT:    vspltisw v2, -3
; CHECK-P9-NEXT:    addis r3, r2, .LCPI7_0@toc@ha
; CHECK-P9-NEXT:    xsmulsp f2, f2, f0
; CHECK-P9-NEXT:    xvcvsxwdp vs3, v2
; CHECK-P9-NEXT:    xsmaddasp f3, f2, f0
; CHECK-P9-NEXT:    lfs f2, .LCPI7_0@toc@l(r3)
; CHECK-P9-NEXT:    xsmulsp f0, f0, f2
; CHECK-P9-NEXT:    xsmulsp f0, f0, f3
; CHECK-P9-NEXT:    xsmulsp f1, f1, f0
; CHECK-P9-NEXT:    blr
  %x = call contract reassoc arcp float @llvm.sqrt.f32(float %b)
  %r = fdiv contract reassoc arcp float %a, %x
  ret float %r
}

define float @goo_safe(float %a, float %b) nounwind {
; CHECK-P7-LABEL: goo_safe:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    fsqrts f0, f2
; CHECK-P7-NEXT:    fdivs f1, f1, f0
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: goo_safe:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xssqrtsp f0, f2
; CHECK-P8-NEXT:    xsdivsp f1, f1, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: goo_safe:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xssqrtsp f0, f2
; CHECK-P9-NEXT:    xsdivsp f1, f1, f0
; CHECK-P9-NEXT:    blr
  %x = call float @llvm.sqrt.f32(float %b)
  %r = fdiv float %a, %x
  ret float %r
}

define float @no_estimate_refinement_f32(float %a, float %b) #0 {
; CHECK-P7-LABEL: no_estimate_refinement_f32:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    frsqrtes f0, f2
; CHECK-P7-NEXT:    fmuls f1, f1, f0
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: no_estimate_refinement_f32:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xsrsqrtesp f0, f2
; CHECK-P8-NEXT:    xsmulsp f1, f1, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: no_estimate_refinement_f32:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xsrsqrtesp f0, f2
; CHECK-P9-NEXT:    xsmulsp f1, f1, f0
; CHECK-P9-NEXT:    blr
  %x = call reassoc arcp float @llvm.sqrt.f32(float %b)
  %r = fdiv reassoc arcp float %a, %x
  ret float %r
}

define float @rsqrt_fmul_fmf(float %a, float %b, float %c) {
; CHECK-P7-LABEL: rsqrt_fmul_fmf:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    frsqrtes f0, f1
; CHECK-P7-NEXT:    addis r3, r2, .LCPI10_0@toc@ha
; CHECK-P7-NEXT:    lfs f4, .LCPI10_0@toc@l(r3)
; CHECK-P7-NEXT:    addis r3, r2, .LCPI10_1@toc@ha
; CHECK-P7-NEXT:    fmuls f1, f1, f0
; CHECK-P7-NEXT:    fmadds f1, f1, f0, f4
; CHECK-P7-NEXT:    lfs f4, .LCPI10_1@toc@l(r3)
; CHECK-P7-NEXT:    fmuls f0, f0, f4
; CHECK-P7-NEXT:    fmuls f0, f0, f1
; CHECK-P7-NEXT:    fres f1, f2
; CHECK-P7-NEXT:    fmuls f4, f0, f1
; CHECK-P7-NEXT:    fnmsubs f0, f2, f4, f0
; CHECK-P7-NEXT:    fmadds f0, f1, f0, f4
; CHECK-P7-NEXT:    fmuls f1, f3, f0
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: rsqrt_fmul_fmf:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xsrsqrtesp f0, f1
; CHECK-P8-NEXT:    vspltisw v2, -3
; CHECK-P8-NEXT:    addis r3, r2, .LCPI10_0@toc@ha
; CHECK-P8-NEXT:    xvcvsxwdp vs4, v2
; CHECK-P8-NEXT:    xsmulsp f1, f1, f0
; CHECK-P8-NEXT:    xsmaddasp f4, f1, f0
; CHECK-P8-NEXT:    lfs f1, .LCPI10_0@toc@l(r3)
; CHECK-P8-NEXT:    xsmulsp f0, f0, f1
; CHECK-P8-NEXT:    xsresp f1, f2
; CHECK-P8-NEXT:    xsmulsp f0, f0, f4
; CHECK-P8-NEXT:    xsmulsp f4, f0, f1
; CHECK-P8-NEXT:    xsnmsubasp f0, f2, f4
; CHECK-P8-NEXT:    xsmaddasp f4, f1, f0
; CHECK-P8-NEXT:    xsmulsp f1, f3, f4
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: rsqrt_fmul_fmf:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xsrsqrtesp f0, f1
; CHECK-P9-NEXT:    vspltisw v2, -3
; CHECK-P9-NEXT:    addis r3, r2, .LCPI10_0@toc@ha
; CHECK-P9-NEXT:    xsmulsp f1, f1, f0
; CHECK-P9-NEXT:    xvcvsxwdp vs4, v2
; CHECK-P9-NEXT:    xsmaddasp f4, f1, f0
; CHECK-P9-NEXT:    lfs f1, .LCPI10_0@toc@l(r3)
; CHECK-P9-NEXT:    xsmulsp f0, f0, f1
; CHECK-P9-NEXT:    xsresp f1, f2
; CHECK-P9-NEXT:    xsmulsp f0, f0, f4
; CHECK-P9-NEXT:    xsmulsp f4, f0, f1
; CHECK-P9-NEXT:    xsnmsubasp f0, f2, f4
; CHECK-P9-NEXT:    xsmaddasp f4, f1, f0
; CHECK-P9-NEXT:    xsmulsp f1, f3, f4
; CHECK-P9-NEXT:    blr
  %x = call contract reassoc arcp nsz float @llvm.sqrt.f32(float %a)
  %y = fmul contract reassoc nsz float %x, %b
  %z = fdiv contract reassoc arcp nsz ninf float %c, %y
  ret float %z
}

define float @rsqrt_fmul_safe(float %a, float %b, float %c) {
; CHECK-P7-LABEL: rsqrt_fmul_safe:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    fsqrts f0, f1
; CHECK-P7-NEXT:    fmuls f0, f0, f2
; CHECK-P7-NEXT:    fdivs f1, f3, f0
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: rsqrt_fmul_safe:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xssqrtsp f0, f1
; CHECK-P8-NEXT:    xsmulsp f0, f0, f2
; CHECK-P8-NEXT:    xsdivsp f1, f3, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: rsqrt_fmul_safe:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xssqrtsp f0, f1
; CHECK-P9-NEXT:    xsmulsp f0, f0, f2
; CHECK-P9-NEXT:    xsdivsp f1, f3, f0
; CHECK-P9-NEXT:    blr
  %x = call float @llvm.sqrt.f32(float %a)
  %y = fmul float %x, %b
  %z = fdiv float %c, %y
  ret float %z
}

define <4 x float> @hoo_fmf(<4 x float> %a, <4 x float> %b) nounwind {
; CHECK-P7-LABEL: hoo_fmf:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    addis r3, r2, .LCPI12_0@toc@ha
; CHECK-P7-NEXT:    vspltisw v4, -1
; CHECK-P7-NEXT:    vrsqrtefp v5, v3
; CHECK-P7-NEXT:    addi r3, r3, .LCPI12_0@toc@l
; CHECK-P7-NEXT:    vslw v4, v4, v4
; CHECK-P7-NEXT:    lvx v0, 0, r3
; CHECK-P7-NEXT:    addis r3, r2, .LCPI12_1@toc@ha
; CHECK-P7-NEXT:    vmaddfp v3, v3, v5, v4
; CHECK-P7-NEXT:    addi r3, r3, .LCPI12_1@toc@l
; CHECK-P7-NEXT:    vmaddfp v3, v3, v5, v0
; CHECK-P7-NEXT:    lvx v0, 0, r3
; CHECK-P7-NEXT:    vmaddfp v5, v5, v0, v4
; CHECK-P7-NEXT:    vmaddfp v3, v5, v3, v4
; CHECK-P7-NEXT:    vmaddfp v2, v2, v3, v4
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: hoo_fmf:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xvrsqrtesp vs0, v3
; CHECK-P8-NEXT:    addis r3, r2, .LCPI12_0@toc@ha
; CHECK-P8-NEXT:    addi r3, r3, .LCPI12_0@toc@l
; CHECK-P8-NEXT:    lxvd2x vs2, 0, r3
; CHECK-P8-NEXT:    addis r3, r2, .LCPI12_1@toc@ha
; CHECK-P8-NEXT:    xvmulsp vs1, v3, vs0
; CHECK-P8-NEXT:    addi r3, r3, .LCPI12_1@toc@l
; CHECK-P8-NEXT:    xvmaddasp vs2, vs1, vs0
; CHECK-P8-NEXT:    lxvd2x vs1, 0, r3
; CHECK-P8-NEXT:    xvmulsp vs0, vs0, vs1
; CHECK-P8-NEXT:    xvmulsp vs0, vs0, vs2
; CHECK-P8-NEXT:    xvmulsp v2, v2, vs0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: hoo_fmf:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xvrsqrtesp vs0, v3
; CHECK-P9-NEXT:    addis r3, r2, .LCPI12_0@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, .LCPI12_0@toc@l
; CHECK-P9-NEXT:    lxv vs2, 0(r3)
; CHECK-P9-NEXT:    addis r3, r2, .LCPI12_1@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, .LCPI12_1@toc@l
; CHECK-P9-NEXT:    xvmulsp vs1, v3, vs0
; CHECK-P9-NEXT:    xvmaddasp vs2, vs1, vs0
; CHECK-P9-NEXT:    lxv vs1, 0(r3)
; CHECK-P9-NEXT:    xvmulsp vs0, vs0, vs1
; CHECK-P9-NEXT:    xvmulsp vs0, vs0, vs2
; CHECK-P9-NEXT:    xvmulsp v2, v2, vs0
; CHECK-P9-NEXT:    blr
  %x = call contract reassoc arcp <4 x float> @llvm.sqrt.v4f32(<4 x float> %b)
  %r = fdiv contract reassoc arcp <4 x float> %a, %x
  ret <4 x float> %r
}

define <4 x float> @hoo_safe(<4 x float> %a, <4 x float> %b) nounwind {
; CHECK-P7-LABEL: hoo_safe:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    addi r3, r1, -32
; CHECK-P7-NEXT:    stvx v3, 0, r3
; CHECK-P7-NEXT:    addi r3, r1, -48
; CHECK-P7-NEXT:    lfs f3, -20(r1)
; CHECK-P7-NEXT:    lfs f2, -24(r1)
; CHECK-P7-NEXT:    lfs f0, -32(r1)
; CHECK-P7-NEXT:    lfs f1, -28(r1)
; CHECK-P7-NEXT:    fsqrts f3, f3
; CHECK-P7-NEXT:    stvx v2, 0, r3
; CHECK-P7-NEXT:    lfs f4, -36(r1)
; CHECK-P7-NEXT:    fsqrts f2, f2
; CHECK-P7-NEXT:    fsqrts f1, f1
; CHECK-P7-NEXT:    fsqrts f0, f0
; CHECK-P7-NEXT:    addi r3, r1, -16
; CHECK-P7-NEXT:    fdivs f3, f4, f3
; CHECK-P7-NEXT:    stfs f3, -4(r1)
; CHECK-P7-NEXT:    lfs f3, -40(r1)
; CHECK-P7-NEXT:    fdivs f2, f3, f2
; CHECK-P7-NEXT:    stfs f2, -8(r1)
; CHECK-P7-NEXT:    lfs f2, -44(r1)
; CHECK-P7-NEXT:    fdivs f1, f2, f1
; CHECK-P7-NEXT:    stfs f1, -12(r1)
; CHECK-P7-NEXT:    lfs f1, -48(r1)
; CHECK-P7-NEXT:    fdivs f0, f1, f0
; CHECK-P7-NEXT:    stfs f0, -16(r1)
; CHECK-P7-NEXT:    lvx v2, 0, r3
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: hoo_safe:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xvsqrtsp vs0, v3
; CHECK-P8-NEXT:    xvdivsp v2, v2, vs0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: hoo_safe:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xvsqrtsp vs0, v3
; CHECK-P9-NEXT:    xvdivsp v2, v2, vs0
; CHECK-P9-NEXT:    blr
  %x = call <4 x float> @llvm.sqrt.v4f32(<4 x float> %b)
  %r = fdiv <4 x float> %a, %x
  ret <4 x float> %r
}

define double @foo2_fmf(double %a, double %b) nounwind {
; CHECK-P7-LABEL: foo2_fmf:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    fre f0, f2
; CHECK-P7-NEXT:    addis r3, r2, .LCPI14_0@toc@ha
; CHECK-P7-NEXT:    lfs f3, .LCPI14_0@toc@l(r3)
; CHECK-P7-NEXT:    fmadd f3, f2, f0, f3
; CHECK-P7-NEXT:    fnmsub f0, f0, f3, f0
; CHECK-P7-NEXT:    fmul f3, f1, f0
; CHECK-P7-NEXT:    fnmsub f1, f2, f3, f1
; CHECK-P7-NEXT:    fmadd f1, f0, f1, f3
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: foo2_fmf:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    vspltisw v2, -1
; CHECK-P8-NEXT:    xsredp f3, f2
; CHECK-P8-NEXT:    xvcvsxwdp vs0, v2
; CHECK-P8-NEXT:    xsmaddadp f0, f2, f3
; CHECK-P8-NEXT:    xsnmsubadp f3, f3, f0
; CHECK-P8-NEXT:    xsmuldp f0, f1, f3
; CHECK-P8-NEXT:    xsnmsubadp f1, f2, f0
; CHECK-P8-NEXT:    xsmaddadp f0, f3, f1
; CHECK-P8-NEXT:    fmr f1, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: foo2_fmf:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    vspltisw v2, -1
; CHECK-P9-NEXT:    xsredp f3, f2
; CHECK-P9-NEXT:    xvcvsxwdp vs0, v2
; CHECK-P9-NEXT:    xsmaddadp f0, f2, f3
; CHECK-P9-NEXT:    xsnmsubadp f3, f3, f0
; CHECK-P9-NEXT:    xsmuldp f0, f1, f3
; CHECK-P9-NEXT:    xsnmsubadp f1, f2, f0
; CHECK-P9-NEXT:    xsmaddadp f0, f3, f1
; CHECK-P9-NEXT:    fmr f1, f0
; CHECK-P9-NEXT:    blr
  %r = fdiv contract reassoc arcp nsz ninf double %a, %b
  ret double %r
}

define double @foo2_safe(double %a, double %b) nounwind {
; CHECK-P7-LABEL: foo2_safe:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    fdiv f1, f1, f2
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: foo2_safe:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xsdivdp f1, f1, f2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: foo2_safe:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xsdivdp f1, f1, f2
; CHECK-P9-NEXT:    blr
  %r = fdiv double %a, %b
  ret double %r
}

define float @goo2_fmf(float %a, float %b) nounwind {
; CHECK-P7-LABEL: goo2_fmf:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    fres f0, f2
; CHECK-P7-NEXT:    fmuls f3, f1, f0
; CHECK-P7-NEXT:    fnmsubs f1, f2, f3, f1
; CHECK-P7-NEXT:    fmadds f1, f0, f1, f3
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: goo2_fmf:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xsresp f3, f2
; CHECK-P8-NEXT:    xsmulsp f0, f1, f3
; CHECK-P8-NEXT:    xsnmsubasp f1, f2, f0
; CHECK-P8-NEXT:    xsmaddasp f0, f3, f1
; CHECK-P8-NEXT:    fmr f1, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: goo2_fmf:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xsresp f3, f2
; CHECK-P9-NEXT:    xsmulsp f0, f1, f3
; CHECK-P9-NEXT:    xsnmsubasp f1, f2, f0
; CHECK-P9-NEXT:    xsmaddasp f0, f3, f1
; CHECK-P9-NEXT:    fmr f1, f0
; CHECK-P9-NEXT:    blr
  %r = fdiv contract reassoc arcp nsz ninf float %a, %b
  ret float %r
}

define float @goo2_safe(float %a, float %b) nounwind {
; CHECK-P7-LABEL: goo2_safe:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    fdivs f1, f1, f2
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: goo2_safe:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xsdivsp f1, f1, f2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: goo2_safe:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xsdivsp f1, f1, f2
; CHECK-P9-NEXT:    blr
  %r = fdiv float %a, %b
  ret float %r
}

define <4 x float> @hoo2_fmf(<4 x float> %a, <4 x float> %b) nounwind {
; CHECK-P7-LABEL: hoo2_fmf:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    vspltisw v4, -1
; CHECK-P7-NEXT:    vrefp v5, v3
; CHECK-P7-NEXT:    vslw v4, v4, v4
; CHECK-P7-NEXT:    vmaddfp v4, v2, v5, v4
; CHECK-P7-NEXT:    vnmsubfp v2, v3, v4, v2
; CHECK-P7-NEXT:    vmaddfp v2, v5, v2, v4
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: hoo2_fmf:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xvresp vs1, v3
; CHECK-P8-NEXT:    xvmulsp vs0, v2, vs1
; CHECK-P8-NEXT:    xvnmsubasp v2, v3, vs0
; CHECK-P8-NEXT:    xvmaddasp vs0, vs1, v2
; CHECK-P8-NEXT:    xxlor v2, vs0, vs0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: hoo2_fmf:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xvresp vs1, v3
; CHECK-P9-NEXT:    xvmulsp vs0, v2, vs1
; CHECK-P9-NEXT:    xvnmsubasp v2, v3, vs0
; CHECK-P9-NEXT:    xvmaddasp vs0, vs1, v2
; CHECK-P9-NEXT:    xxlor v2, vs0, vs0
; CHECK-P9-NEXT:    blr
  %r = fdiv contract reassoc arcp nsz ninf <4 x float> %a, %b
  ret <4 x float> %r
}

define <4 x float> @hoo2_safe(<4 x float> %a, <4 x float> %b) nounwind {
; CHECK-P7-LABEL: hoo2_safe:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    addi r3, r1, -32
; CHECK-P7-NEXT:    stvx v3, 0, r3
; CHECK-P7-NEXT:    addi r3, r1, -48
; CHECK-P7-NEXT:    stvx v2, 0, r3
; CHECK-P7-NEXT:    addi r3, r1, -16
; CHECK-P7-NEXT:    lfs f0, -20(r1)
; CHECK-P7-NEXT:    lfs f1, -36(r1)
; CHECK-P7-NEXT:    fdivs f0, f1, f0
; CHECK-P7-NEXT:    lfs f1, -40(r1)
; CHECK-P7-NEXT:    stfs f0, -4(r1)
; CHECK-P7-NEXT:    lfs f0, -24(r1)
; CHECK-P7-NEXT:    fdivs f0, f1, f0
; CHECK-P7-NEXT:    lfs f1, -44(r1)
; CHECK-P7-NEXT:    stfs f0, -8(r1)
; CHECK-P7-NEXT:    lfs f0, -28(r1)
; CHECK-P7-NEXT:    fdivs f0, f1, f0
; CHECK-P7-NEXT:    lfs f1, -48(r1)
; CHECK-P7-NEXT:    stfs f0, -12(r1)
; CHECK-P7-NEXT:    lfs f0, -32(r1)
; CHECK-P7-NEXT:    fdivs f0, f1, f0
; CHECK-P7-NEXT:    stfs f0, -16(r1)
; CHECK-P7-NEXT:    lvx v2, 0, r3
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: hoo2_safe:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xvdivsp v2, v2, v3
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: hoo2_safe:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xvdivsp v2, v2, v3
; CHECK-P9-NEXT:    blr
  %r = fdiv <4 x float> %a, %b
  ret <4 x float> %r
}

define double @foo3_fmf(double %a) nounwind {
; CHECK-P7-LABEL: foo3_fmf:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    ftsqrt cr0, f1
; CHECK-P7-NEXT:    bc 12, eq, .LBB20_2
; CHECK-P7-NEXT:  # %bb.1:
; CHECK-P7-NEXT:    frsqrte f0, f1
; CHECK-P7-NEXT:    addis r3, r2, .LCPI20_0@toc@ha
; CHECK-P7-NEXT:    lfs f3, .LCPI20_0@toc@l(r3)
; CHECK-P7-NEXT:    addis r3, r2, .LCPI20_1@toc@ha
; CHECK-P7-NEXT:    lfs f4, .LCPI20_1@toc@l(r3)
; CHECK-P7-NEXT:    fmul f2, f1, f0
; CHECK-P7-NEXT:    fmadd f2, f2, f0, f3
; CHECK-P7-NEXT:    fmul f0, f0, f4
; CHECK-P7-NEXT:    fmul f0, f0, f2
; CHECK-P7-NEXT:    fmul f1, f1, f0
; CHECK-P7-NEXT:    fmadd f0, f1, f0, f3
; CHECK-P7-NEXT:    fmul f1, f1, f4
; CHECK-P7-NEXT:    fmul f1, f1, f0
; CHECK-P7-NEXT:    blr
; CHECK-P7-NEXT:  .LBB20_2:
; CHECK-P7-NEXT:    fsqrt f1, f1
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: foo3_fmf:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xstsqrtdp cr0, f1
; CHECK-P8-NEXT:    bc 12, eq, .LBB20_2
; CHECK-P8-NEXT:  # %bb.1:
; CHECK-P8-NEXT:    vspltisw v2, -3
; CHECK-P8-NEXT:    xsrsqrtedp f0, f1
; CHECK-P8-NEXT:    addis r3, r2, .LCPI20_0@toc@ha
; CHECK-P8-NEXT:    xvcvsxwdp vs3, v2
; CHECK-P8-NEXT:    xsmuldp f2, f1, f0
; CHECK-P8-NEXT:    fmr f4, f3
; CHECK-P8-NEXT:    xsmaddadp f4, f2, f0
; CHECK-P8-NEXT:    lfs f2, .LCPI20_0@toc@l(r3)
; CHECK-P8-NEXT:    xsmuldp f0, f0, f2
; CHECK-P8-NEXT:    xsmuldp f0, f0, f4
; CHECK-P8-NEXT:    xsmuldp f1, f1, f0
; CHECK-P8-NEXT:    xsmaddadp f3, f1, f0
; CHECK-P8-NEXT:    xsmuldp f0, f1, f2
; CHECK-P8-NEXT:    xsmuldp f1, f0, f3
; CHECK-P8-NEXT:    blr
; CHECK-P8-NEXT:  .LBB20_2:
; CHECK-P8-NEXT:    xssqrtdp f1, f1
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: foo3_fmf:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xstsqrtdp cr0, f1
; CHECK-P9-NEXT:    bc 12, eq, .LBB20_2
; CHECK-P9-NEXT:  # %bb.1:
; CHECK-P9-NEXT:    xsrsqrtedp f0, f1
; CHECK-P9-NEXT:    vspltisw v2, -3
; CHECK-P9-NEXT:    addis r3, r2, .LCPI20_0@toc@ha
; CHECK-P9-NEXT:    xsmuldp f2, f1, f0
; CHECK-P9-NEXT:    xvcvsxwdp vs3, v2
; CHECK-P9-NEXT:    fmr f4, f3
; CHECK-P9-NEXT:    xsmaddadp f4, f2, f0
; CHECK-P9-NEXT:    lfs f2, .LCPI20_0@toc@l(r3)
; CHECK-P9-NEXT:    xsmuldp f0, f0, f2
; CHECK-P9-NEXT:    xsmuldp f0, f0, f4
; CHECK-P9-NEXT:    xsmuldp f1, f1, f0
; CHECK-P9-NEXT:    xsmaddadp f3, f1, f0
; CHECK-P9-NEXT:    xsmuldp f0, f1, f2
; CHECK-P9-NEXT:    xsmuldp f1, f0, f3
; CHECK-P9-NEXT:    blr
; CHECK-P9-NEXT:  .LBB20_2:
; CHECK-P9-NEXT:    xssqrtdp f1, f1
; CHECK-P9-NEXT:    blr
  %r = call contract reassoc ninf afn double @llvm.sqrt.f64(double %a)
  ret double %r
}

define double @foo3_fmf_crbits_off(double %a) #2 {
; CHECK-P7-LABEL: foo3_fmf_crbits_off:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    fabs f0, f1
; CHECK-P7-NEXT:    addis r3, r2, .LCPI21_2@toc@ha
; CHECK-P7-NEXT:    lfd f2, .LCPI21_2@toc@l(r3)
; CHECK-P7-NEXT:    fcmpu cr0, f0, f2
; CHECK-P7-NEXT:    blt cr0, .LBB21_2
; CHECK-P7-NEXT:  # %bb.1:
; CHECK-P7-NEXT:    frsqrte f0, f1
; CHECK-P7-NEXT:    addis r3, r2, .LCPI21_0@toc@ha
; CHECK-P7-NEXT:    lfs f3, .LCPI21_0@toc@l(r3)
; CHECK-P7-NEXT:    addis r3, r2, .LCPI21_1@toc@ha
; CHECK-P7-NEXT:    lfs f4, .LCPI21_1@toc@l(r3)
; CHECK-P7-NEXT:    fmul f2, f1, f0
; CHECK-P7-NEXT:    fmadd f2, f2, f0, f3
; CHECK-P7-NEXT:    fmul f0, f0, f4
; CHECK-P7-NEXT:    fmul f0, f0, f2
; CHECK-P7-NEXT:    fmul f1, f1, f0
; CHECK-P7-NEXT:    fmadd f0, f1, f0, f3
; CHECK-P7-NEXT:    fmul f1, f1, f4
; CHECK-P7-NEXT:    fmul f1, f1, f0
; CHECK-P7-NEXT:    blr
; CHECK-P7-NEXT:  .LBB21_2:
; CHECK-P7-NEXT:    fsqrt f1, f1
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: foo3_fmf_crbits_off:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    addis r3, r2, .LCPI21_1@toc@ha
; CHECK-P8-NEXT:    xsabsdp f0, f1
; CHECK-P8-NEXT:    lfd f2, .LCPI21_1@toc@l(r3)
; CHECK-P8-NEXT:    xscmpudp cr0, f0, f2
; CHECK-P8-NEXT:    blt cr0, .LBB21_2
; CHECK-P8-NEXT:  # %bb.1:
; CHECK-P8-NEXT:    vspltisw v2, -3
; CHECK-P8-NEXT:    xsrsqrtedp f0, f1
; CHECK-P8-NEXT:    addis r3, r2, .LCPI21_0@toc@ha
; CHECK-P8-NEXT:    xvcvsxwdp vs3, v2
; CHECK-P8-NEXT:    xsmuldp f2, f1, f0
; CHECK-P8-NEXT:    fmr f4, f3
; CHECK-P8-NEXT:    xsmaddadp f4, f2, f0
; CHECK-P8-NEXT:    lfs f2, .LCPI21_0@toc@l(r3)
; CHECK-P8-NEXT:    xsmuldp f0, f0, f2
; CHECK-P8-NEXT:    xsmuldp f0, f0, f4
; CHECK-P8-NEXT:    xsmuldp f1, f1, f0
; CHECK-P8-NEXT:    xsmaddadp f3, f1, f0
; CHECK-P8-NEXT:    xsmuldp f0, f1, f2
; CHECK-P8-NEXT:    xsmuldp f1, f0, f3
; CHECK-P8-NEXT:    blr
; CHECK-P8-NEXT:  .LBB21_2:
; CHECK-P8-NEXT:    xssqrtdp f1, f1
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: foo3_fmf_crbits_off:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    addis r3, r2, .LCPI21_1@toc@ha
; CHECK-P9-NEXT:    xsabsdp f0, f1
; CHECK-P9-NEXT:    lfd f2, .LCPI21_1@toc@l(r3)
; CHECK-P9-NEXT:    xscmpudp cr0, f0, f2
; CHECK-P9-NEXT:    blt cr0, .LBB21_2
; CHECK-P9-NEXT:  # %bb.1:
; CHECK-P9-NEXT:    xsrsqrtedp f0, f1
; CHECK-P9-NEXT:    vspltisw v2, -3
; CHECK-P9-NEXT:    addis r3, r2, .LCPI21_0@toc@ha
; CHECK-P9-NEXT:    xsmuldp f2, f1, f0
; CHECK-P9-NEXT:    xvcvsxwdp vs3, v2
; CHECK-P9-NEXT:    fmr f4, f3
; CHECK-P9-NEXT:    xsmaddadp f4, f2, f0
; CHECK-P9-NEXT:    lfs f2, .LCPI21_0@toc@l(r3)
; CHECK-P9-NEXT:    xsmuldp f0, f0, f2
; CHECK-P9-NEXT:    xsmuldp f0, f0, f4
; CHECK-P9-NEXT:    xsmuldp f1, f1, f0
; CHECK-P9-NEXT:    xsmaddadp f3, f1, f0
; CHECK-P9-NEXT:    xsmuldp f0, f1, f2
; CHECK-P9-NEXT:    xsmuldp f1, f0, f3
; CHECK-P9-NEXT:    blr
; CHECK-P9-NEXT:  .LBB21_2:
; CHECK-P9-NEXT:    xssqrtdp f1, f1
; CHECK-P9-NEXT:    blr
  %r = call contract reassoc ninf afn double @llvm.sqrt.f64(double %a)
  ret double %r
}

define double @foo3_safe(double %a) nounwind {
; CHECK-P7-LABEL: foo3_safe:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    fsqrt f1, f1
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: foo3_safe:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xssqrtdp f1, f1
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: foo3_safe:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xssqrtdp f1, f1
; CHECK-P9-NEXT:    blr
  %r = call double @llvm.sqrt.f64(double %a)
  ret double %r
}

define float @goo3_fmf(float %a) nounwind {
; CHECK-P7-LABEL: goo3_fmf:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    fabs f0, f1
; CHECK-P7-NEXT:    addis r3, r2, .LCPI23_2@toc@ha
; CHECK-P7-NEXT:    lfs f2, .LCPI23_2@toc@l(r3)
; CHECK-P7-NEXT:    fcmpu cr0, f0, f2
; CHECK-P7-NEXT:    blt cr0, .LBB23_2
; CHECK-P7-NEXT:  # %bb.1:
; CHECK-P7-NEXT:    frsqrtes f0, f1
; CHECK-P7-NEXT:    addis r3, r2, .LCPI23_0@toc@ha
; CHECK-P7-NEXT:    lfs f2, .LCPI23_0@toc@l(r3)
; CHECK-P7-NEXT:    addis r3, r2, .LCPI23_1@toc@ha
; CHECK-P7-NEXT:    fmuls f1, f1, f0
; CHECK-P7-NEXT:    fmadds f0, f1, f0, f2
; CHECK-P7-NEXT:    lfs f2, .LCPI23_1@toc@l(r3)
; CHECK-P7-NEXT:    fmuls f1, f1, f2
; CHECK-P7-NEXT:    fmuls f1, f1, f0
; CHECK-P7-NEXT:    blr
; CHECK-P7-NEXT:  .LBB23_2:
; CHECK-P7-NEXT:    addis r3, r2, .LCPI23_3@toc@ha
; CHECK-P7-NEXT:    lfs f1, .LCPI23_3@toc@l(r3)
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: goo3_fmf:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    addis r3, r2, .LCPI23_1@toc@ha
; CHECK-P8-NEXT:    xsabsdp f0, f1
; CHECK-P8-NEXT:    lfs f2, .LCPI23_1@toc@l(r3)
; CHECK-P8-NEXT:    fcmpu cr0, f0, f2
; CHECK-P8-NEXT:    xxlxor f0, f0, f0
; CHECK-P8-NEXT:    blt cr0, .LBB23_2
; CHECK-P8-NEXT:  # %bb.1:
; CHECK-P8-NEXT:    xsrsqrtesp f0, f1
; CHECK-P8-NEXT:    vspltisw v2, -3
; CHECK-P8-NEXT:    addis r3, r2, .LCPI23_0@toc@ha
; CHECK-P8-NEXT:    xvcvsxwdp vs2, v2
; CHECK-P8-NEXT:    xsmulsp f1, f1, f0
; CHECK-P8-NEXT:    xsmaddasp f2, f1, f0
; CHECK-P8-NEXT:    lfs f0, .LCPI23_0@toc@l(r3)
; CHECK-P8-NEXT:    xsmulsp f0, f1, f0
; CHECK-P8-NEXT:    xsmulsp f0, f0, f2
; CHECK-P8-NEXT:  .LBB23_2:
; CHECK-P8-NEXT:    fmr f1, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: goo3_fmf:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    addis r3, r2, .LCPI23_1@toc@ha
; CHECK-P9-NEXT:    xsabsdp f0, f1
; CHECK-P9-NEXT:    lfs f2, .LCPI23_1@toc@l(r3)
; CHECK-P9-NEXT:    fcmpu cr0, f0, f2
; CHECK-P9-NEXT:    xxlxor f0, f0, f0
; CHECK-P9-NEXT:    blt cr0, .LBB23_2
; CHECK-P9-NEXT:  # %bb.1:
; CHECK-P9-NEXT:    xsrsqrtesp f0, f1
; CHECK-P9-NEXT:    vspltisw v2, -3
; CHECK-P9-NEXT:    addis r3, r2, .LCPI23_0@toc@ha
; CHECK-P9-NEXT:    xsmulsp f1, f1, f0
; CHECK-P9-NEXT:    xvcvsxwdp vs2, v2
; CHECK-P9-NEXT:    xsmaddasp f2, f1, f0
; CHECK-P9-NEXT:    lfs f0, .LCPI23_0@toc@l(r3)
; CHECK-P9-NEXT:    xsmulsp f0, f1, f0
; CHECK-P9-NEXT:    xsmulsp f0, f0, f2
; CHECK-P9-NEXT:  .LBB23_2:
; CHECK-P9-NEXT:    fmr f1, f0
; CHECK-P9-NEXT:    blr
  %r = call contract reassoc ninf afn float @llvm.sqrt.f32(float %a)
  ret float %r
}

define float @goo3_safe(float %a) nounwind {
; CHECK-P7-LABEL: goo3_safe:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    fsqrts f1, f1
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: goo3_safe:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xssqrtsp f1, f1
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: goo3_safe:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xssqrtsp f1, f1
; CHECK-P9-NEXT:    blr
  %r = call float @llvm.sqrt.f32(float %a)
  ret float %r
}

define <4 x float> @hoo3_fmf(<4 x float> %a) #1 {
; CHECK-P7-LABEL: hoo3_fmf:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    addis r3, r2, .LCPI25_0@toc@ha
; CHECK-P7-NEXT:    vspltisw v3, -1
; CHECK-P7-NEXT:    vrsqrtefp v4, v2
; CHECK-P7-NEXT:    addi r3, r3, .LCPI25_0@toc@l
; CHECK-P7-NEXT:    vslw v3, v3, v3
; CHECK-P7-NEXT:    lvx v0, 0, r3
; CHECK-P7-NEXT:    addis r3, r2, .LCPI25_1@toc@ha
; CHECK-P7-NEXT:    vmaddfp v5, v2, v4, v3
; CHECK-P7-NEXT:    addi r3, r3, .LCPI25_1@toc@l
; CHECK-P7-NEXT:    vmaddfp v4, v5, v4, v0
; CHECK-P7-NEXT:    lvx v0, 0, r3
; CHECK-P7-NEXT:    vmaddfp v5, v5, v0, v3
; CHECK-P7-NEXT:    vmaddfp v3, v5, v4, v3
; CHECK-P7-NEXT:    vxor v4, v4, v4
; CHECK-P7-NEXT:    vcmpeqfp v2, v2, v4
; CHECK-P7-NEXT:    vnot v2, v2
; CHECK-P7-NEXT:    vand v2, v2, v3
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: hoo3_fmf:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xvtsqrtsp cr0, v2
; CHECK-P8-NEXT:    bc 12, eq, .LBB25_2
; CHECK-P8-NEXT:  # %bb.1:
; CHECK-P8-NEXT:    xvrsqrtesp vs0, v2
; CHECK-P8-NEXT:    addis r3, r2, .LCPI25_0@toc@ha
; CHECK-P8-NEXT:    addi r3, r3, .LCPI25_0@toc@l
; CHECK-P8-NEXT:    lxvd2x vs2, 0, r3
; CHECK-P8-NEXT:    addis r3, r2, .LCPI25_1@toc@ha
; CHECK-P8-NEXT:    xvmulsp vs1, v2, vs0
; CHECK-P8-NEXT:    addi r3, r3, .LCPI25_1@toc@l
; CHECK-P8-NEXT:    xvmaddasp vs2, vs1, vs0
; CHECK-P8-NEXT:    lxvd2x vs0, 0, r3
; CHECK-P8-NEXT:    xvmulsp vs0, vs1, vs0
; CHECK-P8-NEXT:    xvmulsp v2, vs0, vs2
; CHECK-P8-NEXT:    blr
; CHECK-P8-NEXT:  .LBB25_2:
; CHECK-P8-NEXT:    xvsqrtsp v2, v2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: hoo3_fmf:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xvtsqrtsp cr0, v2
; CHECK-P9-NEXT:    bc 12, eq, .LBB25_2
; CHECK-P9-NEXT:  # %bb.1:
; CHECK-P9-NEXT:    xvrsqrtesp vs0, v2
; CHECK-P9-NEXT:    addis r3, r2, .LCPI25_0@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, .LCPI25_0@toc@l
; CHECK-P9-NEXT:    lxv vs2, 0(r3)
; CHECK-P9-NEXT:    addis r3, r2, .LCPI25_1@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, .LCPI25_1@toc@l
; CHECK-P9-NEXT:    xvmulsp vs1, v2, vs0
; CHECK-P9-NEXT:    xvmaddasp vs2, vs1, vs0
; CHECK-P9-NEXT:    lxv vs0, 0(r3)
; CHECK-P9-NEXT:    xvmulsp vs0, vs1, vs0
; CHECK-P9-NEXT:    xvmulsp v2, vs0, vs2
; CHECK-P9-NEXT:    blr
; CHECK-P9-NEXT:  .LBB25_2:
; CHECK-P9-NEXT:    xvsqrtsp v2, v2
; CHECK-P9-NEXT:    blr
  %r = call contract reassoc ninf afn <4 x float> @llvm.sqrt.v4f32(<4 x float> %a)
  ret <4 x float> %r
}

define <4 x float> @hoo3_safe(<4 x float> %a) nounwind {
; CHECK-P7-LABEL: hoo3_safe:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    addi r3, r1, -32
; CHECK-P7-NEXT:    stvx v2, 0, r3
; CHECK-P7-NEXT:    addi r3, r1, -16
; CHECK-P7-NEXT:    lfs f0, -20(r1)
; CHECK-P7-NEXT:    fsqrts f0, f0
; CHECK-P7-NEXT:    stfs f0, -4(r1)
; CHECK-P7-NEXT:    lfs f0, -24(r1)
; CHECK-P7-NEXT:    fsqrts f0, f0
; CHECK-P7-NEXT:    stfs f0, -8(r1)
; CHECK-P7-NEXT:    lfs f0, -28(r1)
; CHECK-P7-NEXT:    fsqrts f0, f0
; CHECK-P7-NEXT:    stfs f0, -12(r1)
; CHECK-P7-NEXT:    lfs f0, -32(r1)
; CHECK-P7-NEXT:    fsqrts f0, f0
; CHECK-P7-NEXT:    stfs f0, -16(r1)
; CHECK-P7-NEXT:    lvx v2, 0, r3
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: hoo3_safe:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xvsqrtsp v2, v2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: hoo3_safe:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xvsqrtsp v2, v2
; CHECK-P9-NEXT:    blr
  %r = call <4 x float> @llvm.sqrt.v4f32(<4 x float> %a)
  ret <4 x float> %r
}

define <2 x double> @hoo4_fmf(<2 x double> %a) #1 {
; CHECK-P7-LABEL: hoo4_fmf:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    ftsqrt cr0, f1
; CHECK-P7-NEXT:    addis r3, r2, .LCPI27_0@toc@ha
; CHECK-P7-NEXT:    lfs f0, .LCPI27_0@toc@l(r3)
; CHECK-P7-NEXT:    addis r3, r2, .LCPI27_1@toc@ha
; CHECK-P7-NEXT:    lfs f3, .LCPI27_1@toc@l(r3)
; CHECK-P7-NEXT:    bc 12, eq, .LBB27_3
; CHECK-P7-NEXT:  # %bb.1:
; CHECK-P7-NEXT:    frsqrte f4, f1
; CHECK-P7-NEXT:    fmul f5, f1, f4
; CHECK-P7-NEXT:    fmadd f5, f5, f4, f0
; CHECK-P7-NEXT:    fmul f4, f4, f3
; CHECK-P7-NEXT:    fmul f4, f4, f5
; CHECK-P7-NEXT:    fmul f1, f1, f4
; CHECK-P7-NEXT:    fmadd f4, f1, f4, f0
; CHECK-P7-NEXT:    fmul f1, f1, f3
; CHECK-P7-NEXT:    fmul f1, f1, f4
; CHECK-P7-NEXT:    ftsqrt cr0, f2
; CHECK-P7-NEXT:    bc 4, eq, .LBB27_4
; CHECK-P7-NEXT:  .LBB27_2:
; CHECK-P7-NEXT:    fsqrt f2, f2
; CHECK-P7-NEXT:    blr
; CHECK-P7-NEXT:  .LBB27_3:
; CHECK-P7-NEXT:    fsqrt f1, f1
; CHECK-P7-NEXT:    ftsqrt cr0, f2
; CHECK-P7-NEXT:    bc 12, eq, .LBB27_2
; CHECK-P7-NEXT:  .LBB27_4:
; CHECK-P7-NEXT:    frsqrte f4, f2
; CHECK-P7-NEXT:    fmul f5, f2, f4
; CHECK-P7-NEXT:    fmadd f5, f5, f4, f0
; CHECK-P7-NEXT:    fmul f4, f4, f3
; CHECK-P7-NEXT:    fmul f4, f4, f5
; CHECK-P7-NEXT:    fmul f2, f2, f4
; CHECK-P7-NEXT:    fmadd f0, f2, f4, f0
; CHECK-P7-NEXT:    fmul f2, f2, f3
; CHECK-P7-NEXT:    fmul f2, f2, f0
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: hoo4_fmf:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xvtsqrtdp cr0, v2
; CHECK-P8-NEXT:    bc 12, eq, .LBB27_2
; CHECK-P8-NEXT:  # %bb.1:
; CHECK-P8-NEXT:    xvrsqrtedp vs0, v2
; CHECK-P8-NEXT:    addis r3, r2, .LCPI27_0@toc@ha
; CHECK-P8-NEXT:    addi r3, r3, .LCPI27_0@toc@l
; CHECK-P8-NEXT:    lxvd2x vs2, 0, r3
; CHECK-P8-NEXT:    addis r3, r2, .LCPI27_1@toc@ha
; CHECK-P8-NEXT:    xvmuldp vs1, v2, vs0
; CHECK-P8-NEXT:    addi r3, r3, .LCPI27_1@toc@l
; CHECK-P8-NEXT:    xxlor vs3, vs2, vs2
; CHECK-P8-NEXT:    xvmaddadp vs3, vs1, vs0
; CHECK-P8-NEXT:    lxvd2x vs1, 0, r3
; CHECK-P8-NEXT:    xvmuldp vs0, vs0, vs1
; CHECK-P8-NEXT:    xvmuldp vs0, vs0, vs3
; CHECK-P8-NEXT:    xvmuldp vs3, v2, vs0
; CHECK-P8-NEXT:    xvmaddadp vs2, vs3, vs0
; CHECK-P8-NEXT:    xvmuldp vs0, vs3, vs1
; CHECK-P8-NEXT:    xvmuldp v2, vs0, vs2
; CHECK-P8-NEXT:    blr
; CHECK-P8-NEXT:  .LBB27_2:
; CHECK-P8-NEXT:    xvsqrtdp v2, v2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: hoo4_fmf:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xvtsqrtdp cr0, v2
; CHECK-P9-NEXT:    bc 12, eq, .LBB27_2
; CHECK-P9-NEXT:  # %bb.1:
; CHECK-P9-NEXT:    xvrsqrtedp vs0, v2
; CHECK-P9-NEXT:    addis r3, r2, .LCPI27_0@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, .LCPI27_0@toc@l
; CHECK-P9-NEXT:    lxv vs2, 0(r3)
; CHECK-P9-NEXT:    addis r3, r2, .LCPI27_1@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, .LCPI27_1@toc@l
; CHECK-P9-NEXT:    xvmuldp vs1, v2, vs0
; CHECK-P9-NEXT:    xxlor vs3, vs2, vs2
; CHECK-P9-NEXT:    xvmaddadp vs3, vs1, vs0
; CHECK-P9-NEXT:    lxv vs1, 0(r3)
; CHECK-P9-NEXT:    xvmuldp vs0, vs0, vs1
; CHECK-P9-NEXT:    xvmuldp vs0, vs0, vs3
; CHECK-P9-NEXT:    xvmuldp vs3, v2, vs0
; CHECK-P9-NEXT:    xvmaddadp vs2, vs3, vs0
; CHECK-P9-NEXT:    xvmuldp vs0, vs3, vs1
; CHECK-P9-NEXT:    xvmuldp v2, vs0, vs2
; CHECK-P9-NEXT:    blr
; CHECK-P9-NEXT:  .LBB27_2:
; CHECK-P9-NEXT:    xvsqrtdp v2, v2
; CHECK-P9-NEXT:    blr
  %r = call contract reassoc ninf afn <2 x double> @llvm.sqrt.v2f64(<2 x double> %a)
  ret <2 x double> %r
}

define <2 x double> @hoo4_safe(<2 x double> %a) #1 {
; CHECK-P7-LABEL: hoo4_safe:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    fsqrt f1, f1
; CHECK-P7-NEXT:    fsqrt f2, f2
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: hoo4_safe:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    xvsqrtdp v2, v2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: hoo4_safe:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xvsqrtdp v2, v2
; CHECK-P9-NEXT:    blr
  %r = call <2 x double> @llvm.sqrt.v2f64(<2 x double> %a)
  ret <2 x double> %r
}

define fp128 @hoo5_fmf(fp128 %a) #1 {
; CHECK-P7-LABEL: hoo5_fmf:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    mflr r0
; CHECK-P7-NEXT:    stdu r1, -112(r1)
; CHECK-P7-NEXT:    std r0, 128(r1)
; CHECK-P7-NEXT:    bl sqrtf128
; CHECK-P7-NEXT:    nop
; CHECK-P7-NEXT:    addi r1, r1, 112
; CHECK-P7-NEXT:    ld r0, 16(r1)
; CHECK-P7-NEXT:    mtlr r0
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: hoo5_fmf:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    mflr r0
; CHECK-P8-NEXT:    stdu r1, -32(r1)
; CHECK-P8-NEXT:    std r0, 48(r1)
; CHECK-P8-NEXT:    bl sqrtf128
; CHECK-P8-NEXT:    nop
; CHECK-P8-NEXT:    addi r1, r1, 32
; CHECK-P8-NEXT:    ld r0, 16(r1)
; CHECK-P8-NEXT:    mtlr r0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: hoo5_fmf:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xssqrtqp v2, v2
; CHECK-P9-NEXT:    blr
  %r = call contract reassoc ninf afn fp128 @llvm.sqrt.f128(fp128 %a)
  ret fp128 %r
}

define fp128 @hoo5_safe(fp128 %a) #1 {
; CHECK-P7-LABEL: hoo5_safe:
; CHECK-P7:       # %bb.0:
; CHECK-P7-NEXT:    mflr r0
; CHECK-P7-NEXT:    stdu r1, -112(r1)
; CHECK-P7-NEXT:    std r0, 128(r1)
; CHECK-P7-NEXT:    bl sqrtf128
; CHECK-P7-NEXT:    nop
; CHECK-P7-NEXT:    addi r1, r1, 112
; CHECK-P7-NEXT:    ld r0, 16(r1)
; CHECK-P7-NEXT:    mtlr r0
; CHECK-P7-NEXT:    blr
;
; CHECK-P8-LABEL: hoo5_safe:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    mflr r0
; CHECK-P8-NEXT:    stdu r1, -32(r1)
; CHECK-P8-NEXT:    std r0, 48(r1)
; CHECK-P8-NEXT:    bl sqrtf128
; CHECK-P8-NEXT:    nop
; CHECK-P8-NEXT:    addi r1, r1, 32
; CHECK-P8-NEXT:    ld r0, 16(r1)
; CHECK-P8-NEXT:    mtlr r0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: hoo5_safe:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    xssqrtqp v2, v2
; CHECK-P9-NEXT:    blr
  %r = call fp128 @llvm.sqrt.f128(fp128 %a)
  ret fp128 %r
}

attributes #0 = { nounwind "reciprocal-estimates"="sqrtf:0,sqrtd:0" }
attributes #1 = { nounwind "denormal-fp-math"="preserve-sign,preserve-sign" }
attributes #2 = { nounwind readnone "target-features"="-crbits" }
