; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mtriple=powerpc64-unknown-unknown < %s | FileCheck  %s \
; RUN:   -check-prefix=P9BE -implicit-check-not frsp
; RUN: llc -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck  %s \
; RUN:   -check-prefix=P9LE -implicit-check-not frsp
; RUN: llc -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mtriple=powerpc64-unknown-unknown < %s | FileCheck  %s \
; RUN:   -check-prefix=P8BE -implicit-check-not frsp
; RUN: llc -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck  %s \
; RUN:   -check-prefix=P8LE -implicit-check-not frsp

; This test case comes from the following C test case (included as it may be
; slightly more readable than the LLVM IR.

;/*  This test case provides various ways of building vectors to ensure we
;    produce optimal code for all cases. The cases are (for each type):
;    - All zeros
;    - All ones - split to build-vector-allones.ll
;    - Splat of a constant
;    - From different values already in registers
;    - From different constants
;    - From different values in memory
;    - Splat of a value in register
;    - Splat of a value in memory
;    - Inserting element into existing vector
;    - Inserting element from existing vector into existing vector
;
;    With conversions (float <-> int)
;    - Splat of a constant
;    - From different values already in registers
;    - From different constants
;    - From different values in memory
;    - Splat of a value in register
;    - Splat of a value in memory
;    - Inserting element into existing vector
;    - Inserting element from existing vector into existing vector
;*/
;
;/*=================================== int ===================================*/
;// P8: xxlxor                                                                //
;// P9: xxlxor                                                                //
;vector int allZeroi() {                                                      //
;  return (vector int)0;                                                      //
;}                                                                            //
;// P8: vspltisb -1                                                           //
;// P9: xxspltisb 255                                                         //
;vector int spltConst1i() {                                                   //
;  return (vector int)1;                                                      //
;}                                                                            //
;// P8: vspltisw -15; vsrw                                                    //
;// P9: vspltisw -15; vsrw                                                    //
;vector int spltConst16ki() {                                                 //
;  return (vector int)((1<<15) - 1);                                          //
;}                                                                            //
;// P8: vspltisw -16; vsrw                                                    //
;// P9: vspltisw -16; vsrw                                                    //
;vector int spltConst32ki() {                                                 //
;  return (vector int)((1<<16) - 1);                                          //
;}                                                                            //
;// P8: 4 x mtvsrwz, 2 x xxmrgh, vmrgow                                       //
;// P9: 2 x mtvsrdd, vmrgow                                                   //
;vector int fromRegsi(int a, int b, int c, int d) {                           //
;  return (vector int){ a, b, c, d };                                         //
;}                                                                            //
;// P8: lxvd2x, xxswapd                                                       //
;// P9: lxvx (or even lxv)                                                    //
;vector int fromDiffConstsi() {                                               //
;  return (vector int) { 242, -113, 889, 19 };                                //
;}                                                                            //
;// P8: lxvd2x, xxswapd                                                       //
;// P9: lxvx                                                                  //
;vector int fromDiffMemConsAi(int *arr) {                                     //
;  return (vector int) { arr[0], arr[1], arr[2], arr[3] };                    //
;}                                                                            //
;// P8: 2 x lxvd2x, 2 x xxswapd, vperm                                        //
;// P9: 2 x lxvx, vperm                                                       //
;vector int fromDiffMemConsDi(int *arr) {                                     //
;  return (vector int) { arr[3], arr[2], arr[1], arr[0] };                    //
;}                                                                            //
;// P8: sldi 2, lxvd2x, xxswapd                                               //
;// P9: sldi 2, lxvx                                                          //
;vector int fromDiffMemVarAi(int *arr, int elem) {                            //
;  return (vector int) { arr[elem], arr[elem+1], arr[elem+2], arr[elem+3] };  //
;}                                                                            //
;// P8: sldi 2, 2 x lxvd2x, 2 x xxswapd, vperm                                //
;// P9: sldi 2, 2 x lxvx, vperm                                               //
;vector int fromDiffMemVarDi(int *arr, int elem) {                            //
;  return (vector int) { arr[elem], arr[elem-1], arr[elem-2], arr[elem-3] };  //
;}                                                                            //
;// P8: 4 x lwz, 4 x mtvsrwz, 2 x xxmrghd, vmrgow                             //
;// P9: 4 x lwz, 2 x mtvsrdd, vmrgow                                          //
;vector int fromRandMemConsi(int *arr) {                                      //
;  return (vector int) { arr[4], arr[18], arr[2], arr[88] };                  //
;}                                                                            //
;// P8: sldi 2, 4 x lwz, 4 x mtvsrwz, 2 x xxmrghd, vmrgow                     //
;// P9: sldi 2, add, 4 x lwz, 2 x mtvsrdd, vmrgow                             //
;vector int fromRandMemVari(int *arr, int elem) {                             //
;  return (vector int) { arr[elem+4], arr[elem+1], arr[elem+2], arr[elem+8] };//
;}                                                                            //
;// P8: mtvsrwz, xxspltw                                                      //
;// P9: mtvsrws                                                               //
;vector int spltRegVali(int val) {                                            //
;  return (vector int) val;                                                   //
;}                                                                            //
;// P8: (LE) lfiwzx, xxpermdi, xxspltw (BE): lfiwzx, xxsldwi, xxspltw         //
;// P9: (LE) lfiwzx, xxpermdi, xxspltw (BE): lfiwzx, xxsldwi, xxspltw         //
;vector int spltMemVali(int *ptr) {                                           //
;  return (vector int)*ptr;                                                   //
;}                                                                            //
;// P8: vspltisw                                                              //
;// P9: vspltisw                                                              //
;vector int spltCnstConvftoi() {                                              //
;  return (vector int) 4.74f;                                                 //
;}                                                                            //
;// P8: 2 x xxmrghd, 2 x xvcvspsxws, vmrgew                                   //
;// P9: 2 x xxmrghd, 2 x xvcvspsxws, vmrgew                                   //
;vector int fromRegsConvftoi(float a, float b, float c, float d) {            //
;  return (vector int) { a, b, c, d };                                        //
;}                                                                            //
;// P8: lxvd2x, xxswapd                                                       //
;// P9: lxvx (even lxv)                                                       //
;vector int fromDiffConstsConvftoi() {                                        //
;  return (vector int) { 24.46f, 234.f, 988.19f, 422.39f };                   //
;}                                                                            //
;// P8: lxvd2x, xxswapd, xvcvspsxws                                           //
;// P9: lxvx, xvcvspsxws                                                      //
;vector int fromDiffMemConsAConvftoi(ptr ptr) {                            //
;  return (vector int) { ptr[0], ptr[1], ptr[2], ptr[3] };                    //
;}                                                                            //
;// P8: 2 x lxvd2x, 2 x xxswapd, vperm, xvcvspsxws                            //
;// P9: 2 x lxvx, vperm, xvcvspsxws                                           //
;vector int fromDiffMemConsDConvftoi(ptr ptr) {                            //
;  return (vector int) { ptr[3], ptr[2], ptr[1], ptr[0] };                    //
;}                                                                            //
;// P8: 4 x lxsspx, 2 x xxmrghd, 2 x xvcvspsxws, vmrgew                       //
;// P9: 4 x lxssp, 2 x xxmrghd, 2 x xvcvspsxws, vmrgew                        //
;// Note: if the consecutive loads learns to handle pre-inc, this can be:     //
;//       sldi 2, load, xvcvspuxws                                            //
;vector int fromDiffMemVarAConvftoi(ptr arr, int elem) {                   //
;  return (vector int) { arr[elem], arr[elem+1], arr[elem+2], arr[elem+3] };  //
;}                                                                            //
;// P8: 4 x lxsspx, 2 x xxmrghd, 2 x xvcvspsxws, vmrgew                       //
;// P9: 4 x lxssp, 2 x xxmrghd, 2 x xvcvspsxws, vmrgew                        //
;// Note: if the consecutive loads learns to handle pre-inc, this can be:     //
;//       sldi 2, 2 x load, vperm, xvcvspuxws                                 //
;vector int fromDiffMemVarDConvftoi(ptr arr, int elem) {                   //
;  return (vector int) { arr[elem], arr[elem-1], arr[elem-2], arr[elem-3] };  //
;}                                                                            //
;// P8: xscvdpsxws, xxspltw                                                   //
;// P9: xscvdpsxws, xxspltw                                                   //
;vector int spltRegValConvftoi(float val) {                                   //
;  return (vector int) val;                                                   //
;}                                                                            //
;// P8: lxsspx, xscvdpsxws, xxspltw                                           //
;// P9: lxvwsx, xvcvspsxws                                                    //
;vector int spltMemValConvftoi(ptr ptr) {                                  //
;  return (vector int)*ptr;                                                   //
;}                                                                            //
;// P8: vspltisw                                                              //
;// P9: vspltisw                                                              //
;vector int spltCnstConvdtoi() {                                              //
;  return (vector int) 4.74;                                                  //
;}                                                                            //
;// P8: 2 x xxmrghd, 2 x xvcvspsxws, vmrgew                                   //
;// P9: 2 x xxmrghd, 2 x xvcvspsxws, vmrgew                                   //
;vector int fromRegsConvdtoi(double a, double b, double c, double d) {        //
;  return (vector int) { a, b, c, d };                                        //
;}                                                                            //
;// P8: lxvd2x, xxswapd                                                       //
;// P9: lxvx (even lxv)                                                       //
;vector int fromDiffConstsConvdtoi() {                                        //
;  return (vector int) { 24.46, 234., 988.19, 422.39 };                       //
;}                                                                            //
;// P8: 2 x lxvd2x, 2 x xxswapd, xxmrgld, xxmrghd, 2 x xvcvspsxws, vmrgew     //
;// P9: 2 x lxvx, 2 x xxswapd, xxmrgld, xxmrghd, 2 x xvcvspsxws, vmrgew       //
;vector int fromDiffMemConsAConvdtoi(ptr ptr) {                           //
;  return (vector int) { ptr[0], ptr[1], ptr[2], ptr[3] };                    //
;}                                                                            //
;// P8: 4 x lxsdx, 2 x xxmrghd, 2 x xvcvspsxws, vmrgew                        //
;// P9: 4 x lfd, 2 x xxmrghd, 2 x xvcvspsxws, vmrgew                          //
;vector int fromDiffMemConsDConvdtoi(ptr ptr) {                           //
;  return (vector int) { ptr[3], ptr[2], ptr[1], ptr[0] };                    //
;}                                                                            //
;// P8: lfdux, 3 x lxsdx, 2 x xxmrghd, 2 x xvcvspsxws, vmrgew                 //
;// P9: lfdux, 3 x lfd, 2 x xxmrghd, 2 x xvcvspsxws, vmrgew                   //
;vector int fromDiffMemVarAConvdtoi(ptr arr, int elem) {                  //
;  return (vector int) { arr[elem], arr[elem+1], arr[elem+2], arr[elem+3] };  //
;}                                                                            //
;// P8: lfdux, 3 x lxsdx, 2 x xxmrghd, 2 x xvcvspsxws, vmrgew                 //
;// P9: lfdux, 3 x lfd, 2 x xxmrghd, 2 x xvcvspsxws, vmrgew                   //
;vector int fromDiffMemVarDConvdtoi(ptr arr, int elem) {                  //
;  return (vector int) { arr[elem], arr[elem-1], arr[elem-2], arr[elem-3] };  //
;}                                                                            //
;// P8: xscvdpsxws, xxspltw                                                   //
;// P9: xscvdpsxws, xxspltw                                                   //
;vector int spltRegValConvdtoi(double val) {                                  //
;  return (vector int) val;                                                   //
;}                                                                            //
;// P8: lxsdx, xscvdpsxws, xxspltw                                            //
;// P9: lxssp, xscvdpsxws, xxspltw                                            //
;vector int spltMemValConvdtoi(ptr ptr) {                                 //
;  return (vector int)*ptr;                                                   //
;}                                                                            //
;/*=================================== int ===================================*/
;/*=============================== unsigned int ==============================*/
;// P8: xxlxor                                                                //
;// P9: xxlxor                                                                //
;vector unsigned int allZeroui() {                                            //
;  return (vector unsigned int)0;                                             //
;}                                                                            //
;// P8: vspltisb -1                                                           //
;// P9: xxspltisb 255                                                         //
;vector unsigned int spltConst1ui() {                                         //
;  return (vector unsigned int)1;                                             //
;}                                                                            //
;// P8: vspltisw -15; vsrw                                                    //
;// P9: vspltisw -15; vsrw                                                    //
;vector unsigned int spltConst16kui() {                                       //
;  return (vector unsigned int)((1<<15) - 1);                                 //
;}                                                                            //
;// P8: vspltisw -16; vsrw                                                    //
;// P9: vspltisw -16; vsrw                                                    //
;vector unsigned int spltConst32kui() {                                       //
;  return (vector unsigned int)((1<<16) - 1);                                 //
;}                                                                            //
;// P8: 4 x mtvsrwz, 2 x xxmrghd, vmrgow                                      //
;// P9: 2 x mtvsrdd, vmrgow                                                   //
;vector unsigned int fromRegsui(unsigned int a, unsigned int b,               //
;                              unsigned int c, unsigned int d) {              //
;  return (vector unsigned int){ a, b, c, d };                                //
;}                                                                            //
;// P8: lxvd2x, xxswapd                                                       //
;// P9: lxvx (or even lxv)                                                    //
;vector unsigned int fromDiffConstsui() {                                     //
;  return (vector unsigned int) { 242, -113, 889, 19 };                       //
;}                                                                            //
;// P8: lxvd2x, xxswapd                                                       //
;// P9: lxvx                                                                  //
;vector unsigned int fromDiffMemConsAui(unsigned int *arr) {                  //
;  return (vector unsigned int) { arr[0], arr[1], arr[2], arr[3] };           //
;}                                                                            //
;// P8: 2 x lxvd2x, 2 x xxswapd, vperm                                        //
;// P9: 2 x lxvx, vperm                                                       //
;vector unsigned int fromDiffMemConsDui(unsigned int *arr) {                  //
;  return (vector unsigned int) { arr[3], arr[2], arr[1], arr[0] };           //
;}                                                                            //
;// P8: sldi 2, lxvd2x, xxswapd                                               //
;// P9: sldi 2, lxvx                                                          //
;vector unsigned int fromDiffMemVarAui(unsigned int *arr, int elem) {         //
;  return (vector unsigned int) { arr[elem], arr[elem+1],                     //
;                                 arr[elem+2], arr[elem+3] };                 //
;}                                                                            //
;// P8: sldi 2, 2 x lxvd2x, 2 x xxswapd, vperm                                //
;// P9: sldi 2, 2 x lxvx, vperm                                               //
;vector unsigned int fromDiffMemVarDui(unsigned int *arr, int elem) {         //
;  return (vector unsigned int) { arr[elem], arr[elem-1],                     //
;                                 arr[elem-2], arr[elem-3] };                 //
;}                                                                            //
;// P8: 4 x lwz, 4 x mtvsrwz, 2 x xxmrghd, vmrgow                             //
;// P9: 4 x lwz, 2 x mtvsrdd, vmrgow                                          //
;vector unsigned int fromRandMemConsui(unsigned int *arr) {                   //
;  return (vector unsigned int) { arr[4], arr[18], arr[2], arr[88] };         //
;}                                                                            //
;// P8: sldi 2, 4 x lwz, 4 x mtvsrwz, 2 x xxmrghd, vmrgow                     //
;// P9: sldi 2, add, 4 x lwz, 2 x mtvsrdd, vmrgow                             //
;vector unsigned int fromRandMemVarui(unsigned int *arr, int elem) {          //
;  return (vector unsigned int) { arr[elem+4], arr[elem+1],                   //
;                                 arr[elem+2], arr[elem+8] };                 //
;}                                                                            //
;// P8: mtvsrwz, xxspltw                                                      //
;// P9: mtvsrws                                                               //
;vector unsigned int spltRegValui(unsigned int val) {                         //
;  return (vector unsigned int) val;                                          //
;}                                                                            //
;// P8: (LE) lfiwzx, xxpermdi, xxspltw (BE): lfiwzx, xxsldwi, xxspltw         //
;// P9: (LE) lfiwzx, xxpermdi, xxspltw (BE): lfiwzx, xxsldwi, xxspltw         //
;vector unsigned int spltMemValui(unsigned int *ptr) {                        //
;  return (vector unsigned int)*ptr;                                          //
;}                                                                            //
;// P8: vspltisw                                                              //
;// P9: vspltisw                                                              //
;vector unsigned int spltCnstConvftoui() {                                    //
;  return (vector unsigned int) 4.74f;                                        //
;}                                                                            //
;// P8: 2 x xxmrghd, 2 x xvcvspuxws, vmrgew                                   //
;// P9: 2 x xxmrghd, 2 x xvcvspuxws, vmrgew                                   //
;vector unsigned int fromRegsConvftoui(float a, float b, float c, float d) {  //
;  return (vector unsigned int) { a, b, c, d };                               //
;}                                                                            //
;// P8: lxvd2x, xxswapd                                                       //
;// P9: lxvx (even lxv)                                                       //
;vector unsigned int fromDiffConstsConvftoui() {                              //
;  return (vector unsigned int) { 24.46f, 234.f, 988.19f, 422.39f };          //
;}                                                                            //
;// P8: lxvd2x, xxswapd, xvcvspuxws                                           //
;// P9: lxvx, xvcvspuxws                                                      //
;vector unsigned int fromDiffMemConsAConvftoui(ptr ptr) {                  //
;  return (vector unsigned int) { ptr[0], ptr[1], ptr[2], ptr[3] };           //
;}                                                                            //
;// P8: 2 x lxvd2x, 2 x xxswapd, vperm, xvcvspuxws                            //
;// P9: 2 x lxvx, vperm, xvcvspuxws                                           //
;vector unsigned int fromDiffMemConsDConvftoui(ptr ptr) {                  //
;  return (vector unsigned int) { ptr[3], ptr[2], ptr[1], ptr[0] };           //
;}                                                                            //
;// P8: lfsux, 3 x lxsspx, 2 x xxmrghd, 2 x xvcvspuxws, vmrgew                //
;// P9: lfsux, 3 x lfs, 2 x xxmrghd, 2 x xvcvspuxws, vmrgew                   //
;// Note: if the consecutive loads learns to handle pre-inc, this can be:     //
;//       sldi 2, load, xvcvspuxws                                            //
;vector unsigned int fromDiffMemVarAConvftoui(ptr arr, int elem) {         //
;  return (vector unsigned int) { arr[elem], arr[elem+1],                     //
;                                 arr[elem+2], arr[elem+3] };                 //
;}                                                                            //
;// P8: lfsux, 3 x lxsspx, 2 x xxmrghd, 2 x xvcvspuxws, vmrgew                //
;// P9: lfsux, 3 x lfs, 2 x xxmrghd, 2 x xvcvspuxws, vmrgew                   //
;// Note: if the consecutive loads learns to handle pre-inc, this can be:     //
;//       sldi 2, 2 x load, vperm, xvcvspuxws                                 //
;vector unsigned int fromDiffMemVarDConvftoui(ptr arr, int elem) {         //
;  return (vector unsigned int) { arr[elem], arr[elem-1],                     //
;                                 arr[elem-2], arr[elem-3] };                 //
;}                                                                            //
;// P8: xscvdpuxws, xxspltw                                                   //
;// P9: xscvdpuxws, xxspltw                                                   //
;vector unsigned int spltRegValConvftoui(float val) {                         //
;  return (vector unsigned int) val;                                          //
;}                                                                            //
;// P8: lxsspx, xscvdpuxws, xxspltw                                           //
;// P9: lxvwsx, xvcvspuxws                                                    //
;vector unsigned int spltMemValConvftoui(ptr ptr) {                        //
;  return (vector unsigned int)*ptr;                                          //
;}                                                                            //
;// P8: vspltisw                                                              //
;// P9: vspltisw                                                              //
;vector unsigned int spltCnstConvdtoui() {                                    //
;  return (vector unsigned int) 4.74;                                         //
;}                                                                            //
;// P8: 2 x xxmrghd, 2 x xvcvspuxws, vmrgew                                   //
;// P9: 2 x xxmrghd, 2 x xvcvspuxws, vmrgew                                   //
;vector unsigned int fromRegsConvdtoui(double a, double b,                    //
;                                      double c, double d) {                  //
;  return (vector unsigned int) { a, b, c, d };                               //
;}                                                                            //
;// P8: lxvd2x, xxswapd                                                       //
;// P9: lxvx (even lxv)                                                       //
;vector unsigned int fromDiffConstsConvdtoui() {                              //
;  return (vector unsigned int) { 24.46, 234., 988.19, 422.39 };              //
;}                                                                            //
;// P8: 2 x lxvd2x, 2 x xxswapd, xxmrgld, xxmrghd, 2 x xvcvspuxws, vmrgew     //
;// P9: 2 x lxvx, xxmrgld, xxmrghd, 2 x xvcvspuxws, vmrgew                    //
;vector unsigned int fromDiffMemConsAConvdtoui(ptr ptr) {                 //
;  return (vector unsigned int) { ptr[0], ptr[1], ptr[2], ptr[3] };           //
;}                                                                            //
;// P8: 4 x lxsdx, 2 x xxmrghd, 2 x xvcvspuxws, vmrgew                        //
;// P9: 4 x lfd, 2 x xxmrghd, 2 x xvcvspuxws, vmrgew                          //
;vector unsigned int fromDiffMemConsDConvdtoui(ptr ptr) {                 //
;  return (vector unsigned int) { ptr[3], ptr[2], ptr[1], ptr[0] };           //
;}                                                                            //
;// P8: lfdux, 3 x lxsdx, 2 x xxmrghd, 2 x xvcvspuxws, vmrgew                 //
;// P9: lfdux, 3 x lfd, 2 x xxmrghd, 2 x xvcvspuxws, vmrgew                   //
;vector unsigned int fromDiffMemVarAConvdtoui(ptr arr, int elem) {        //
;  return (vector unsigned int) { arr[elem], arr[elem+1],                     //
;                                 arr[elem+2], arr[elem+3] };                 //
;}                                                                            //
;// P8: lfdux, 3 x lxsdx, 2 x xxmrghd, 2 x xvcvspuxws, vmrgew                 //
;// P9: lfdux, 3 x lfd, 2 x xxmrghd, 2 x xvcvspuxws, vmrgew                   //
;vector unsigned int fromDiffMemVarDConvdtoui(ptr arr, int elem) {        //
;  return (vector unsigned int) { arr[elem], arr[elem-1],                     //
;                                 arr[elem-2], arr[elem-3] };                 //
;}                                                                            //
;// P8: xscvdpuxws, xxspltw                                                   //
;// P9: xscvdpuxws, xxspltw                                                   //
;vector unsigned int spltRegValConvdtoui(double val) {                        //
;  return (vector unsigned int) val;                                          //
;}                                                                            //
;// P8: lxsspx, xscvdpuxws, xxspltw                                           //
;// P9: lfd, xscvdpuxws, xxspltw                                              //
;vector unsigned int spltMemValConvdtoui(ptr ptr) {                       //
;  return (vector unsigned int)*ptr;                                          //
;}                                                                            //
;/*=============================== unsigned int ==============================*/
;/*=============================== long long =================================*/
;// P8: xxlxor                                                                //
;// P9: xxlxor                                                                //
;vector long long allZeroll() {                                               //
;  return (vector long long)0;                                                //
;}                                                                            //
;// P8: vspltisb -1                                                           //
;// P9: xxspltisb 255                                                         //
;vector long long spltConst1ll() {                                            //
;  return (vector long long)1;                                                //
;}                                                                            //
;// P8: constant pool load (possible: vmrgew (xxlxor), (vspltisw, vsrw))      //
;// P9: constant pool load (possible: vmrgew (xxlxor), (vspltisw, vsrw))      //
;vector long long spltConst16kll() {                                          //
;  return (vector long long)((1<<15) - 1);                                    //
;}                                                                            //
;// P8: constant pool load (possible: vmrgew (xxlxor), (vspltisw, vsrw))      //
;// P9: constant pool load (possible: vmrgew (xxlxor), (vspltisw, vsrw))      //
;vector long long spltConst32kll() {                                          //
;  return (vector long long)((1<<16) - 1);                                    //
;}                                                                            //
;// P8: 2 x mtvsrd, xxmrghd                                                   //
;// P9: mtvsrdd                                                               //
;vector long long fromRegsll(long long a, long long b) {                      //
;  return (vector long long){ a, b };                                         //
;}                                                                            //
;// P8: lxvd2x, xxswapd                                                       //
;// P9: lxvx (or even lxv)                                                    //
;vector long long fromDiffConstsll() {                                        //
;  return (vector long long) { 242, -113 };                                   //
;}                                                                            //
;// P8: lxvd2x, xxswapd                                                       //
;// P9: lxvx                                                                  //
;vector long long fromDiffMemConsAll(long long *arr) {                        //
;  return (vector long long) { arr[0], arr[1] };                              //
;}                                                                            //
;// P8: lxvd2x                                                                //
;// P9: lxvx, xxswapd (maybe just use lxvd2x)                                 //
;vector long long fromDiffMemConsDll(long long *arr) {                        //
;  return (vector long long) { arr[3], arr[2] };                              //
;}                                                                            //
;// P8: sldi 3, lxvd2x, xxswapd                                               //
;// P9: sldi 3, lxvx                                                          //
;vector long long fromDiffMemVarAll(long long *arr, int elem) {               //
;  return (vector long long) { arr[elem], arr[elem+1] };                      //
;}                                                                            //
;// P8: sldi 3, lxvd2x                                                        //
;// P9: sldi 3, lxvx, xxswapd (maybe just use lxvd2x)                         //
;vector long long fromDiffMemVarDll(long long *arr, int elem) {               //
;  return (vector long long) { arr[elem], arr[elem-1] };                      //
;}                                                                            //
;// P8: 2 x ld, 2 x mtvsrd, xxmrghd                                           //
;// P9: 2 x ld, mtvsrdd                                                       //
;vector long long fromRandMemConsll(long long *arr) {                         //
;  return (vector long long) { arr[4], arr[18] };                             //
;}                                                                            //
;// P8: sldi 3, add, 2 x ld, 2 x mtvsrd, xxmrghd                              //
;// P9: sldi 3, add, 2 x ld, mtvsrdd                                          //
;vector long long fromRandMemVarll(long long *arr, int elem) {                //
;  return (vector long long) { arr[elem+4], arr[elem+1] };                    //
;}                                                                            //
;// P8: mtvsrd, xxspltd                                                       //
;// P9: mtvsrdd                                                               //
;vector long long spltRegValll(long long val) {                               //
;  return (vector long long) val;                                             //
;}                                                                            //
;// P8: lxvdsx                                                                //
;// P9: lxvdsx                                                                //
;vector long long spltMemValll(long long *ptr) {                              //
;  return (vector long long)*ptr;                                             //
;}                                                                            //
;// P8: constant pool load (possible: vmrgew (xxlxor), (vspltisw))            //
;// P9: constant pool load (possible: vmrgew (xxlxor), (vspltisw))            //
;vector long long spltCnstConvftoll() {                                       //
;  return (vector long long) 4.74f;                                           //
;}                                                                            //
;// P8: xxmrghd, xvcvdpsxds                                                   //
;// P9: xxmrghd, xvcvdpsxds                                                   //
;vector long long fromRegsConvftoll(float a, float b) {                       //
;  return (vector long long) { a, b };                                        //
;}                                                                            //
;// P8: lxvd2x, xxswapd                                                       //
;// P9: lxvx (even lxv)                                                       //
;vector long long fromDiffConstsConvftoll() {                                 //
;  return (vector long long) { 24.46f, 234.f };                               //
;}                                                                            //
;// P8: 2 x lxsspx, xxmrghd, xvcvdpsxds                                       //
;// P9: 2 x lxssp, xxmrghd, xvcvdpsxds                                        //
;vector long long fromDiffMemConsAConvftoll(ptr ptr) {                     //
;  return (vector long long) { ptr[0], ptr[1] };                              //
;}                                                                            //
;// P8: 2 x lxsspx, xxmrghd, xvcvdpsxds                                       //
;// P9: 2 x lxssp, xxmrghd, xvcvdpsxds                                        //
;vector long long fromDiffMemConsDConvftoll(ptr ptr) {                     //
;  return (vector long long) { ptr[3], ptr[2] };                              //
;}                                                                            //
;// P8: sldi 2, lfsux, lxsspx, xxmrghd, xvcvdpsxds                            //
;// P9: sldi 2, lfsux, lfs, xxmrghd, xvcvdpsxds                               //
;vector long long fromDiffMemVarAConvftoll(ptr arr, int elem) {            //
;  return (vector long long) { arr[elem], arr[elem+1] };                      //
;}                                                                            //
;// P8: sldi 2, lfsux, lxsspx, xxmrghd, xvcvdpsxds                            //
;// P9: sldi 2, lfsux, lfs, xxmrghd, xvcvdpsxds                               //
;vector long long fromDiffMemVarDConvftoll(ptr arr, int elem) {            //
;  return (vector long long) { arr[elem], arr[elem-1] };                      //
;}                                                                            //
;// P8: xscvdpsxds, xxspltd                                                   //
;// P9: xscvdpsxds, xxspltd                                                   //
;vector long long spltRegValConvftoll(float val) {                            //
;  return (vector long long) val;                                             //
;}                                                                            //
;// P8: lxsspx, xscvdpsxds, xxspltd                                           //
;// P9: lfs, xscvdpsxds, xxspltd                                              //
;vector long long spltMemValConvftoll(ptr ptr) {                           //
;  return (vector long long)*ptr;                                             //
;}                                                                            //
;// P8: constant pool load (possible: vmrgew (xxlxor), (vspltisw))            //
;// P9: constant pool load (possible: vmrgew (xxlxor), (vspltisw))            //
;vector long long spltCnstConvdtoll() {                                       //
;  return (vector long long) 4.74;                                            //
;}                                                                            //
;// P8: xxmrghd, xvcvdpsxds                                                   //
;// P9: xxmrghd, xvcvdpsxds                                                   //
;vector long long fromRegsConvdtoll(double a, double b) {                     //
;  return (vector long long) { a, b };                                        //
;}                                                                            //
;// P8: lxvd2x, xxswapd                                                       //
;// P9: lxvx (even lxv)                                                       //
;vector long long fromDiffConstsConvdtoll() {                                 //
;  return (vector long long) { 24.46, 234. };                                 //
;}                                                                            //
;// P8: lxvd2x, xxswapd, xvcvdpsxds                                           //
;// P9: lxvx, xvcvdpsxds                                                      //
;vector long long fromDiffMemConsAConvdtoll(ptr ptr) {                    //
;  return (vector long long) { ptr[0], ptr[1] };                              //
;}                                                                            //
;// P8: lxvd2x, xvcvdpsxds                                                    //
;// P9: lxvx, xxswapd, xvcvdpsxds                                             //
;vector long long fromDiffMemConsDConvdtoll(ptr ptr) {                    //
;  return (vector long long) { ptr[3], ptr[2] };                              //
;}                                                                            //
;// P8: sldi 3, lxvd2x, xxswapd, xvcvdpsxds                                   //
;// P9: sldi 3, lxvx, xvcvdpsxds                                              //
;vector long long fromDiffMemVarAConvdtoll(ptr arr, int elem) {           //
;  return (vector long long) { arr[elem], arr[elem+1] };                      //
;}                                                                            //
;// P8: sldi 3, lxvd2x, xvcvdpsxds                                            //
;// P9: sldi 3, lxvx, xxswapd, xvcvdpsxds                                     //
;vector long long fromDiffMemVarDConvdtoll(ptr arr, int elem) {           //
;  return (vector long long) { arr[elem], arr[elem-1] };                      //
;}                                                                            //
;// P8: xscvdpsxds, xxspltd                                                   //
;// P9: xscvdpsxds, xxspltd                                                   //
;vector long long spltRegValConvdtoll(double val) {                           //
;  return (vector long long) val;                                             //
;}                                                                            //
;// P8: lxvdsx, xvcvdpsxds                                                    //
;// P9: lxvdsx, xvcvdpsxds                                                    //
;vector long long spltMemValConvdtoll(ptr ptr) {                          //
;  return (vector long long)*ptr;                                             //
;}                                                                            //
;/*=============================== long long =================================*/
;/*========================== unsigned long long =============================*/
;// P8: xxlxor                                                                //
;// P9: xxlxor                                                                //
;vector unsigned long long allZeroull() {                                     //
;  return (vector unsigned long long)0;                                       //
;}                                                                            //
;// P8: vspltisb -1                                                           //
;// P9: xxspltisb 255                                                         //
;vector unsigned long long spltConst1ull() {                                  //
;  return (vector unsigned long long)1;                                       //
;}                                                                            //
;// P8: constant pool load (possible: vmrgew (xxlxor), (vspltisw, vsrw))      //
;// P9: constant pool load (possible: vmrgew (xxlxor), (vspltisw, vsrw))      //
;vector unsigned long long spltConst16kull() {                                //
;  return (vector unsigned long long)((1<<15) - 1);                           //
;}                                                                            //
;// P8: constant pool load (possible: vmrgew (xxlxor), (vspltisw, vsrw))      //
;// P9: constant pool load (possible: vmrgew (xxlxor), (vspltisw, vsrw))      //
;vector unsigned long long spltConst32kull() {                                //
;  return (vector unsigned long long)((1<<16) - 1);                           //
;}                                                                            //
;// P8: 2 x mtvsrd, xxmrghd                                                   //
;// P9: mtvsrdd                                                               //
;vector unsigned long long fromRegsull(unsigned long long a,                  //
;                                      unsigned long long b) {                //
;  return (vector unsigned long long){ a, b };                                //
;}                                                                            //
;// P8: lxvd2x, xxswapd                                                       //
;// P9: lxvx (or even lxv)                                                    //
;vector unsigned long long fromDiffConstsull() {                              //
;  return (vector unsigned long long) { 242, -113 };                          //
;}                                                                            //
;// P8: lxvd2x, xxswapd                                                       //
;// P9: lxvx                                                                  //
;vector unsigned long long fromDiffMemConsAull(unsigned long long *arr) {     //
;  return (vector unsigned long long) { arr[0], arr[1] };                     //
;}                                                                            //
;// P8: lxvd2x                                                                //
;// P9: lxvx, xxswapd (maybe just use lxvd2x)                                 //
;vector unsigned long long fromDiffMemConsDull(unsigned long long *arr) {     //
;  return (vector unsigned long long) { arr[3], arr[2] };                     //
;}                                                                            //
;// P8: sldi 3, lxvd2x, xxswapd                                               //
;// P9: sldi 3, lxvx                                                          //
;vector unsigned long long fromDiffMemVarAull(unsigned long long *arr,        //
;                                             int elem) {                     //
;  return (vector unsigned long long) { arr[elem], arr[elem+1] };             //
;}                                                                            //
;// P8: sldi 3, lxvd2x                                                        //
;// P9: sldi 3, lxvx, xxswapd (maybe just use lxvd2x)                         //
;vector unsigned long long fromDiffMemVarDull(unsigned long long *arr,        //
;                                             int elem) {                     //
;  return (vector unsigned long long) { arr[elem], arr[elem-1] };             //
;}                                                                            //
;// P8: 2 x ld, 2 x mtvsrd, xxmrghd                                           //
;// P9: 2 x ld, mtvsrdd                                                       //
;vector unsigned long long fromRandMemConsull(unsigned long long *arr) {      //
;  return (vector unsigned long long) { arr[4], arr[18] };                    //
;}                                                                            //
;// P8: sldi 3, add, 2 x ld, 2 x mtvsrd, xxmrghd                              //
;// P9: sldi 3, add, 2 x ld, mtvsrdd                                          //
;vector unsigned long long fromRandMemVarull(unsigned long long *arr,         //
;                                            int elem) {                      //
;  return (vector unsigned long long) { arr[elem+4], arr[elem+1] };           //
;}                                                                            //
;// P8: mtvsrd, xxspltd                                                       //
;// P9: mtvsrdd                                                               //
;vector unsigned long long spltRegValull(unsigned long long val) {            //
;  return (vector unsigned long long) val;                                    //
;}                                                                            //
;// P8: lxvdsx                                                                //
;// P9: lxvdsx                                                                //
;vector unsigned long long spltMemValull(unsigned long long *ptr) {           //
;  return (vector unsigned long long)*ptr;                                    //
;}                                                                            //
;// P8: constant pool load (possible: vmrgew (xxlxor), (vspltisw))            //
;// P9: constant pool load (possible: vmrgew (xxlxor), (vspltisw))            //
;vector unsigned long long spltCnstConvftoull() {                             //
;  return (vector unsigned long long) 4.74f;                                  //
;}                                                                            //
;// P8: xxmrghd, xvcvdpuxds                                                   //
;// P9: xxmrghd, xvcvdpuxds                                                   //
;vector unsigned long long fromRegsConvftoull(float a, float b) {             //
;  return (vector unsigned long long) { a, b };                               //
;}                                                                            //
;// P8: lxvd2x, xxswapd                                                       //
;// P9: lxvx (even lxv)                                                       //
;vector unsigned long long fromDiffConstsConvftoull() {                       //
;  return (vector unsigned long long) { 24.46f, 234.f };                      //
;}                                                                            //
;// P8: 2 x lxsspx, xxmrghd, xvcvdpuxds                                       //
;// P9: 2 x lxssp, xxmrghd, xvcvdpuxds                                        //
;vector unsigned long long fromDiffMemConsAConvftoull(ptr ptr) {           //
;  return (vector unsigned long long) { ptr[0], ptr[1] };                     //
;}                                                                            //
;// P8: 2 x lxsspx, xxmrghd, xvcvdpuxds                                       //
;// P9: 2 x lxssp, xxmrghd, xvcvdpuxds                                        //
;vector unsigned long long fromDiffMemConsDConvftoull(ptr ptr) {           //
;  return (vector unsigned long long) { ptr[3], ptr[2] };                     //
;}                                                                            //
;// P8: sldi 2, lfsux, lxsspx, xxmrghd, xvcvdpuxds                            //
;// P9: sldi 2, lfsux, lfs, xxmrghd, xvcvdpuxds                               //
;vector unsigned long long fromDiffMemVarAConvftoull(ptr arr, int elem) {  //
;  return (vector unsigned long long) { arr[elem], arr[elem+1] };             //
;}                                                                            //
;// P8: sldi 2, lfsux, lxsspx, xxmrghd, xvcvdpuxds                            //
;// P9: sldi 2, lfsux, lfs, xxmrghd, xvcvdpuxds                               //
;vector unsigned long long fromDiffMemVarDConvftoull(ptr arr, int elem) {  //
;  return (vector unsigned long long) { arr[elem], arr[elem-1] };             //
;}                                                                            //
;// P8: xscvdpuxds, xxspltd                                                   //
;// P9: xscvdpuxds, xxspltd                                                   //
;vector unsigned long long spltRegValConvftoull(float val) {                  //
;  return (vector unsigned long long) val;                                    //
;}                                                                            //
;// P8: lxsspx, xscvdpuxds, xxspltd                                           //
;// P9: lfs, xscvdpuxds, xxspltd                                              //
;vector unsigned long long spltMemValConvftoull(ptr ptr) {                 //
;  return (vector unsigned long long)*ptr;                                    //
;}                                                                            //
;// P8: constant pool load (possible: vmrgew (xxlxor), (vspltisw))            //
;// P9: constant pool load (possible: vmrgew (xxlxor), (vspltisw))            //
;vector unsigned long long spltCnstConvdtoull() {                             //
;  return (vector unsigned long long) 4.74;                                   //
;}                                                                            //
;// P8: xxmrghd, xvcvdpuxds                                                   //
;// P9: xxmrghd, xvcvdpuxds                                                   //
;vector unsigned long long fromRegsConvdtoull(double a, double b) {           //
;  return (vector unsigned long long) { a, b };                               //
;}                                                                            //
;// P8: lxvd2x, xxswapd                                                       //
;// P9: lxvx (even lxv)                                                       //
;vector unsigned long long fromDiffConstsConvdtoull() {                       //
;  return (vector unsigned long long) { 24.46, 234. };                        //
;}                                                                            //
;// P8: lxvd2x, xxswapd, xvcvdpuxds                                           //
;// P9: lxvx, xvcvdpuxds                                                      //
;vector unsigned long long fromDiffMemConsAConvdtoull(ptr ptr) {          //
;  return (vector unsigned long long) { ptr[0], ptr[1] };                     //
;}                                                                            //
;// P8: lxvd2x, xvcvdpuxds                                                    //
;// P9: lxvx, xxswapd, xvcvdpuxds                                             //
;vector unsigned long long fromDiffMemConsDConvdtoull(ptr ptr) {          //
;  return (vector unsigned long long) { ptr[3], ptr[2] };                     //
;}                                                                            //
;// P8: sldi 3, lxvd2x, xxswapd, xvcvdpuxds                                   //
;// P9: sldi 3, lxvx, xvcvdpuxds                                              //
;vector unsigned long long fromDiffMemVarAConvdtoull(ptr arr, int elem) { //
;  return (vector unsigned long long) { arr[elem], arr[elem+1] };             //
;}                                                                            //
;// P8: sldi 3, lxvd2x, xvcvdpuxds                                            //
;// P9: sldi 3, lxvx, xxswapd, xvcvdpuxds                                     //
;vector unsigned long long fromDiffMemVarDConvdtoull(ptr arr, int elem) { //
;  return (vector unsigned long long) { arr[elem], arr[elem-1] };             //
;}                                                                            //
;// P8: xscvdpuxds, xxspltd                                                   //
;// P9: xscvdpuxds, xxspltd                                                   //
;vector unsigned long long spltRegValConvdtoull(double val) {                 //
;  return (vector unsigned long long) val;                                    //
;}                                                                            //
;// P8: lxvdsx, xvcvdpuxds                                                    //
;// P9: lxvdsx, xvcvdpuxds                                                    //
;vector unsigned long long spltMemValConvdtoull(ptr ptr) {                //
;  return (vector unsigned long long)*ptr;                                    //
;}                                                                            //
;/*========================== unsigned long long ==============================*/

define <4 x i32> @allZeroi() {
; P9BE-LABEL: allZeroi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxlxor v2, v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: allZeroi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxlxor v2, v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: allZeroi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxlxor v2, v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: allZeroi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxlxor v2, v2, v2
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> zeroinitializer
}

define <4 x i32> @spltConst1i() {
; P9BE-LABEL: spltConst1i:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    vspltisw v2, 1
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltConst1i:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    vspltisw v2, 1
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltConst1i:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    vspltisw v2, 1
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltConst1i:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    vspltisw v2, 1
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> <i32 1, i32 1, i32 1, i32 1>
}

define <4 x i32> @spltConst16ki() {
; P9BE-LABEL: spltConst16ki:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    vspltisw v2, -15
; P9BE-NEXT:    vsrw v2, v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltConst16ki:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    vspltisw v2, -15
; P9LE-NEXT:    vsrw v2, v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltConst16ki:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    vspltisw v2, -15
; P8BE-NEXT:    vsrw v2, v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltConst16ki:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    vspltisw v2, -15
; P8LE-NEXT:    vsrw v2, v2, v2
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> <i32 32767, i32 32767, i32 32767, i32 32767>
}

define <4 x i32> @spltConst32ki() {
; P9BE-LABEL: spltConst32ki:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    vspltisw v2, -16
; P9BE-NEXT:    vsrw v2, v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltConst32ki:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    vspltisw v2, -16
; P9LE-NEXT:    vsrw v2, v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltConst32ki:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    vspltisw v2, -16
; P8BE-NEXT:    vsrw v2, v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltConst32ki:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    vspltisw v2, -16
; P8LE-NEXT:    vsrw v2, v2, v2
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
}

define <4 x i32> @fromRegsi(i32 signext %a, i32 signext %b, i32 signext %c, i32 signext %d) {
; P9BE-LABEL: fromRegsi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    rldimi r6, r5, 32, 0
; P9BE-NEXT:    rldimi r4, r3, 32, 0
; P9BE-NEXT:    mtvsrdd v2, r4, r6
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRegsi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    rldimi r3, r4, 32, 0
; P9LE-NEXT:    rldimi r5, r6, 32, 0
; P9LE-NEXT:    mtvsrdd v2, r5, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRegsi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    rldimi r6, r5, 32, 0
; P8BE-NEXT:    rldimi r4, r3, 32, 0
; P8BE-NEXT:    mtfprd f0, r6
; P8BE-NEXT:    mtfprd f1, r4
; P8BE-NEXT:    xxmrghd v2, vs1, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRegsi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    rldimi r3, r4, 32, 0
; P8LE-NEXT:    rldimi r5, r6, 32, 0
; P8LE-NEXT:    mtfprd f0, r3
; P8LE-NEXT:    mtfprd f1, r5
; P8LE-NEXT:    xxmrghd v2, vs1, vs0
; P8LE-NEXT:    blr
entry:
  %vecinit = insertelement <4 x i32> undef, i32 %a, i32 0
  %vecinit1 = insertelement <4 x i32> %vecinit, i32 %b, i32 1
  %vecinit2 = insertelement <4 x i32> %vecinit1, i32 %c, i32 2
  %vecinit3 = insertelement <4 x i32> %vecinit2, i32 %d, i32 3
  ret <4 x i32> %vecinit3
}

define <4 x i32> @fromDiffConstsi() {
; P9BE-LABEL: fromDiffConstsi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    addis r3, r2, .LCPI5_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI5_0@toc@l
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffConstsi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addis r3, r2, .LCPI5_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI5_0@toc@l
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffConstsi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addis r3, r2, .LCPI5_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI5_0@toc@l
; P8BE-NEXT:    lxvw4x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffConstsi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r3, r2, .LCPI5_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI5_0@toc@l
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> <i32 242, i32 -113, i32 889, i32 19>
}

define <4 x i32> @fromDiffMemConsAi(ptr nocapture readonly %arr) {
; P9BE-LABEL: fromDiffMemConsAi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsAi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsAi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lxvw4x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsAi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  %0 = load i32, ptr %arr, align 4
  %vecinit = insertelement <4 x i32> undef, i32 %0, i32 0
  %arrayidx1 = getelementptr inbounds i32, ptr %arr, i64 1
  %1 = load i32, ptr %arrayidx1, align 4
  %vecinit2 = insertelement <4 x i32> %vecinit, i32 %1, i32 1
  %arrayidx3 = getelementptr inbounds i32, ptr %arr, i64 2
  %2 = load i32, ptr %arrayidx3, align 4
  %vecinit4 = insertelement <4 x i32> %vecinit2, i32 %2, i32 2
  %arrayidx5 = getelementptr inbounds i32, ptr %arr, i64 3
  %3 = load i32, ptr %arrayidx5, align 4
  %vecinit6 = insertelement <4 x i32> %vecinit4, i32 %3, i32 3
  ret <4 x i32> %vecinit6
}

define <4 x i32> @fromDiffMemConsDi(ptr nocapture readonly %arr) {
; P9BE-LABEL: fromDiffMemConsDi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    addis r3, r2, .LCPI7_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI7_0@toc@l
; P9BE-NEXT:    lxv vs0, 0(r3)
; P9BE-NEXT:    xxperm v2, v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsDi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxvw4x v2, 0, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsDi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lxvw4x v2, 0, r3
; P8BE-NEXT:    addis r3, r2, .LCPI7_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI7_0@toc@l
; P8BE-NEXT:    lxvw4x v3, 0, r3
; P8BE-NEXT:    vperm v2, v2, v2, v3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsDi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    addis r3, r2, .LCPI7_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI7_0@toc@l
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v3, vs0
; P8LE-NEXT:    vperm v2, v2, v2, v3
; P8LE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds i32, ptr %arr, i64 3
  %0 = load i32, ptr %arrayidx, align 4
  %vecinit = insertelement <4 x i32> undef, i32 %0, i32 0
  %arrayidx1 = getelementptr inbounds i32, ptr %arr, i64 2
  %1 = load i32, ptr %arrayidx1, align 4
  %vecinit2 = insertelement <4 x i32> %vecinit, i32 %1, i32 1
  %arrayidx3 = getelementptr inbounds i32, ptr %arr, i64 1
  %2 = load i32, ptr %arrayidx3, align 4
  %vecinit4 = insertelement <4 x i32> %vecinit2, i32 %2, i32 2
  %3 = load i32, ptr %arr, align 4
  %vecinit6 = insertelement <4 x i32> %vecinit4, i32 %3, i32 3
  ret <4 x i32> %vecinit6
}

define <4 x i32> @fromDiffMemVarAi(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarAi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 2
; P9BE-NEXT:    lxvx v2, r3, r4
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarAi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 2
; P9LE-NEXT:    lxvx v2, r3, r4
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarAi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 2
; P8BE-NEXT:    lxvw4x v2, r3, r4
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarAi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 2
; P8LE-NEXT:    lxvd2x vs0, r3, r4
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds i32, ptr %arr, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  %vecinit = insertelement <4 x i32> undef, i32 %0, i32 0
  %add = add nsw i32 %elem, 1
  %idxprom1 = sext i32 %add to i64
  %arrayidx2 = getelementptr inbounds i32, ptr %arr, i64 %idxprom1
  %1 = load i32, ptr %arrayidx2, align 4
  %vecinit3 = insertelement <4 x i32> %vecinit, i32 %1, i32 1
  %add4 = add nsw i32 %elem, 2
  %idxprom5 = sext i32 %add4 to i64
  %arrayidx6 = getelementptr inbounds i32, ptr %arr, i64 %idxprom5
  %2 = load i32, ptr %arrayidx6, align 4
  %vecinit7 = insertelement <4 x i32> %vecinit3, i32 %2, i32 2
  %add8 = add nsw i32 %elem, 3
  %idxprom9 = sext i32 %add8 to i64
  %arrayidx10 = getelementptr inbounds i32, ptr %arr, i64 %idxprom9
  %3 = load i32, ptr %arrayidx10, align 4
  %vecinit11 = insertelement <4 x i32> %vecinit7, i32 %3, i32 3
  ret <4 x i32> %vecinit11
}

define <4 x i32> @fromDiffMemVarDi(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarDi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 2
; P9BE-NEXT:    add r3, r3, r4
; P9BE-NEXT:    li r4, -12
; P9BE-NEXT:    lxvx v2, r3, r4
; P9BE-NEXT:    addis r3, r2, .LCPI9_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI9_0@toc@l
; P9BE-NEXT:    lxv vs0, 0(r3)
; P9BE-NEXT:    xxperm v2, v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarDi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 2
; P9LE-NEXT:    add r3, r3, r4
; P9LE-NEXT:    addi r3, r3, -12
; P9LE-NEXT:    lxvw4x v2, 0, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarDi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 2
; P8BE-NEXT:    add r3, r3, r4
; P8BE-NEXT:    addi r3, r3, -12
; P8BE-NEXT:    lxvw4x v2, 0, r3
; P8BE-NEXT:    addis r3, r2, .LCPI9_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI9_0@toc@l
; P8BE-NEXT:    lxvw4x v3, 0, r3
; P8BE-NEXT:    vperm v2, v2, v2, v3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarDi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 2
; P8LE-NEXT:    add r3, r3, r4
; P8LE-NEXT:    addi r3, r3, -12
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    addis r3, r2, .LCPI9_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI9_0@toc@l
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v3, vs0
; P8LE-NEXT:    vperm v2, v2, v2, v3
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds i32, ptr %arr, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  %vecinit = insertelement <4 x i32> undef, i32 %0, i32 0
  %sub = add nsw i32 %elem, -1
  %idxprom1 = sext i32 %sub to i64
  %arrayidx2 = getelementptr inbounds i32, ptr %arr, i64 %idxprom1
  %1 = load i32, ptr %arrayidx2, align 4
  %vecinit3 = insertelement <4 x i32> %vecinit, i32 %1, i32 1
  %sub4 = add nsw i32 %elem, -2
  %idxprom5 = sext i32 %sub4 to i64
  %arrayidx6 = getelementptr inbounds i32, ptr %arr, i64 %idxprom5
  %2 = load i32, ptr %arrayidx6, align 4
  %vecinit7 = insertelement <4 x i32> %vecinit3, i32 %2, i32 2
  %sub8 = add nsw i32 %elem, -3
  %idxprom9 = sext i32 %sub8 to i64
  %arrayidx10 = getelementptr inbounds i32, ptr %arr, i64 %idxprom9
  %3 = load i32, ptr %arrayidx10, align 4
  %vecinit11 = insertelement <4 x i32> %vecinit7, i32 %3, i32 3
  ret <4 x i32> %vecinit11
}

define <4 x i32> @fromRandMemConsi(ptr nocapture readonly %arr) {
; P9BE-LABEL: fromRandMemConsi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lwz r4, 16(r3)
; P9BE-NEXT:    lwz r5, 72(r3)
; P9BE-NEXT:    lwz r6, 8(r3)
; P9BE-NEXT:    lwz r3, 352(r3)
; P9BE-NEXT:    rldimi r3, r6, 32, 0
; P9BE-NEXT:    rldimi r5, r4, 32, 0
; P9BE-NEXT:    mtvsrdd v2, r5, r3
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRandMemConsi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lwz r4, 16(r3)
; P9LE-NEXT:    lwz r5, 72(r3)
; P9LE-NEXT:    lwz r6, 8(r3)
; P9LE-NEXT:    lwz r3, 352(r3)
; P9LE-NEXT:    rldimi r4, r5, 32, 0
; P9LE-NEXT:    rldimi r6, r3, 32, 0
; P9LE-NEXT:    mtvsrdd v2, r6, r4
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRandMemConsi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lwz r4, 16(r3)
; P8BE-NEXT:    lwz r5, 72(r3)
; P8BE-NEXT:    lwz r6, 8(r3)
; P8BE-NEXT:    lwz r3, 352(r3)
; P8BE-NEXT:    rldimi r3, r6, 32, 0
; P8BE-NEXT:    rldimi r5, r4, 32, 0
; P8BE-NEXT:    mtfprd f0, r3
; P8BE-NEXT:    mtfprd f1, r5
; P8BE-NEXT:    xxmrghd v2, vs1, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRandMemConsi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lwz r4, 16(r3)
; P8LE-NEXT:    lwz r5, 72(r3)
; P8LE-NEXT:    lwz r6, 8(r3)
; P8LE-NEXT:    lwz r3, 352(r3)
; P8LE-NEXT:    rldimi r4, r5, 32, 0
; P8LE-NEXT:    rldimi r6, r3, 32, 0
; P8LE-NEXT:    mtfprd f0, r4
; P8LE-NEXT:    mtfprd f1, r6
; P8LE-NEXT:    xxmrghd v2, vs1, vs0
; P8LE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds i32, ptr %arr, i64 4
  %0 = load i32, ptr %arrayidx, align 4
  %vecinit = insertelement <4 x i32> undef, i32 %0, i32 0
  %arrayidx1 = getelementptr inbounds i32, ptr %arr, i64 18
  %1 = load i32, ptr %arrayidx1, align 4
  %vecinit2 = insertelement <4 x i32> %vecinit, i32 %1, i32 1
  %arrayidx3 = getelementptr inbounds i32, ptr %arr, i64 2
  %2 = load i32, ptr %arrayidx3, align 4
  %vecinit4 = insertelement <4 x i32> %vecinit2, i32 %2, i32 2
  %arrayidx5 = getelementptr inbounds i32, ptr %arr, i64 88
  %3 = load i32, ptr %arrayidx5, align 4
  %vecinit6 = insertelement <4 x i32> %vecinit4, i32 %3, i32 3
  ret <4 x i32> %vecinit6
}

define <4 x i32> @fromRandMemVari(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromRandMemVari:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 2
; P9BE-NEXT:    add r3, r3, r4
; P9BE-NEXT:    lwz r4, 16(r3)
; P9BE-NEXT:    lwz r5, 4(r3)
; P9BE-NEXT:    lwz r6, 8(r3)
; P9BE-NEXT:    lwz r3, 32(r3)
; P9BE-NEXT:    rldimi r3, r6, 32, 0
; P9BE-NEXT:    rldimi r5, r4, 32, 0
; P9BE-NEXT:    mtvsrdd v2, r5, r3
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRandMemVari:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 2
; P9LE-NEXT:    add r3, r3, r4
; P9LE-NEXT:    lwz r4, 16(r3)
; P9LE-NEXT:    lwz r5, 4(r3)
; P9LE-NEXT:    lwz r6, 8(r3)
; P9LE-NEXT:    lwz r3, 32(r3)
; P9LE-NEXT:    rldimi r4, r5, 32, 0
; P9LE-NEXT:    rldimi r6, r3, 32, 0
; P9LE-NEXT:    mtvsrdd v2, r6, r4
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRandMemVari:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 2
; P8BE-NEXT:    add r3, r3, r4
; P8BE-NEXT:    lwz r4, 16(r3)
; P8BE-NEXT:    lwz r5, 4(r3)
; P8BE-NEXT:    lwz r6, 8(r3)
; P8BE-NEXT:    lwz r3, 32(r3)
; P8BE-NEXT:    rldimi r3, r6, 32, 0
; P8BE-NEXT:    rldimi r5, r4, 32, 0
; P8BE-NEXT:    mtfprd f0, r3
; P8BE-NEXT:    mtfprd f1, r5
; P8BE-NEXT:    xxmrghd v2, vs1, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRandMemVari:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 2
; P8LE-NEXT:    add r3, r3, r4
; P8LE-NEXT:    lwz r4, 16(r3)
; P8LE-NEXT:    lwz r5, 4(r3)
; P8LE-NEXT:    lwz r6, 8(r3)
; P8LE-NEXT:    lwz r3, 32(r3)
; P8LE-NEXT:    rldimi r4, r5, 32, 0
; P8LE-NEXT:    rldimi r6, r3, 32, 0
; P8LE-NEXT:    mtfprd f0, r4
; P8LE-NEXT:    mtfprd f1, r6
; P8LE-NEXT:    xxmrghd v2, vs1, vs0
; P8LE-NEXT:    blr
entry:
  %add = add nsw i32 %elem, 4
  %idxprom = sext i32 %add to i64
  %arrayidx = getelementptr inbounds i32, ptr %arr, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  %vecinit = insertelement <4 x i32> undef, i32 %0, i32 0
  %add1 = add nsw i32 %elem, 1
  %idxprom2 = sext i32 %add1 to i64
  %arrayidx3 = getelementptr inbounds i32, ptr %arr, i64 %idxprom2
  %1 = load i32, ptr %arrayidx3, align 4
  %vecinit4 = insertelement <4 x i32> %vecinit, i32 %1, i32 1
  %add5 = add nsw i32 %elem, 2
  %idxprom6 = sext i32 %add5 to i64
  %arrayidx7 = getelementptr inbounds i32, ptr %arr, i64 %idxprom6
  %2 = load i32, ptr %arrayidx7, align 4
  %vecinit8 = insertelement <4 x i32> %vecinit4, i32 %2, i32 2
  %add9 = add nsw i32 %elem, 8
  %idxprom10 = sext i32 %add9 to i64
  %arrayidx11 = getelementptr inbounds i32, ptr %arr, i64 %idxprom10
  %3 = load i32, ptr %arrayidx11, align 4
  %vecinit12 = insertelement <4 x i32> %vecinit8, i32 %3, i32 3
  ret <4 x i32> %vecinit12
}

define <4 x i32> @spltRegVali(i32 signext %val) {
; P9BE-LABEL: spltRegVali:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    mtvsrws v2, r3
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltRegVali:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    mtvsrws v2, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltRegVali:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    mtfprwz f0, r3
; P8BE-NEXT:    xxspltw v2, vs0, 1
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltRegVali:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    mtfprwz f0, r3
; P8LE-NEXT:    xxspltw v2, vs0, 1
; P8LE-NEXT:    blr
entry:
  %splat.splatinsert = insertelement <4 x i32> undef, i32 %val, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> undef, <4 x i32> zeroinitializer
  ret <4 x i32> %splat.splat
}

define <4 x i32> @spltMemVali(ptr nocapture readonly %ptr) {
; P9BE-LABEL: spltMemVali:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxvwsx v2, 0, r3
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltMemVali:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxvwsx v2, 0, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltMemVali:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lfiwzx f0, 0, r3
; P8BE-NEXT:    xxspltw v2, vs0, 1
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltMemVali:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lfiwzx f0, 0, r3
; P8LE-NEXT:    xxspltw v2, vs0, 1
; P8LE-NEXT:    blr
entry:
  %0 = load i32, ptr %ptr, align 4
  %splat.splatinsert = insertelement <4 x i32> undef, i32 %0, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> undef, <4 x i32> zeroinitializer
  ret <4 x i32> %splat.splat
}

define <4 x i32> @spltCnstConvftoi() {
; P9BE-LABEL: spltCnstConvftoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    vspltisw v2, 4
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltCnstConvftoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    vspltisw v2, 4
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltCnstConvftoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    vspltisw v2, 4
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltCnstConvftoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    vspltisw v2, 4
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> <i32 4, i32 4, i32 4, i32 4>
}

define <4 x i32> @fromRegsConvftoi(float %a, float %b, float %c, float %d) {
; P9BE-LABEL: fromRegsConvftoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxmrghd vs0, vs2, vs4
; P9BE-NEXT:    xvcvdpsxws v2, vs0
; P9BE-NEXT:    xxmrghd vs0, vs1, vs3
; P9BE-NEXT:    xvcvdpsxws v3, vs0
; P9BE-NEXT:    vmrgew v2, v3, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRegsConvftoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxmrghd vs0, vs3, vs1
; P9LE-NEXT:    xvcvdpsxws v2, vs0
; P9LE-NEXT:    xxmrghd vs0, vs4, vs2
; P9LE-NEXT:    xvcvdpsxws v3, vs0
; P9LE-NEXT:    vmrgew v2, v3, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRegsConvftoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxmrghd vs0, vs2, vs4
; P8BE-NEXT:    xxmrghd vs1, vs1, vs3
; P8BE-NEXT:    xvcvdpsxws v2, vs0
; P8BE-NEXT:    xvcvdpsxws v3, vs1
; P8BE-NEXT:    vmrgew v2, v3, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRegsConvftoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxmrghd vs0, vs3, vs1
; P8LE-NEXT:    xxmrghd vs1, vs4, vs2
; P8LE-NEXT:    xvcvdpsxws v2, vs0
; P8LE-NEXT:    xvcvdpsxws v3, vs1
; P8LE-NEXT:    vmrgew v2, v3, v2
; P8LE-NEXT:    blr
entry:
  %conv = fptosi float %a to i32
  %vecinit = insertelement <4 x i32> undef, i32 %conv, i32 0
  %conv1 = fptosi float %b to i32
  %vecinit2 = insertelement <4 x i32> %vecinit, i32 %conv1, i32 1
  %conv3 = fptosi float %c to i32
  %vecinit4 = insertelement <4 x i32> %vecinit2, i32 %conv3, i32 2
  %conv5 = fptosi float %d to i32
  %vecinit6 = insertelement <4 x i32> %vecinit4, i32 %conv5, i32 3
  ret <4 x i32> %vecinit6
}

define <4 x i32> @fromDiffConstsConvftoi() {
; P9BE-LABEL: fromDiffConstsConvftoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    addis r3, r2, .LCPI16_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI16_0@toc@l
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffConstsConvftoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addis r3, r2, .LCPI16_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI16_0@toc@l
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffConstsConvftoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addis r3, r2, .LCPI16_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI16_0@toc@l
; P8BE-NEXT:    lxvw4x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffConstsConvftoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r3, r2, .LCPI16_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI16_0@toc@l
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> <i32 24, i32 234, i32 988, i32 422>
}

define <4 x i32> @fromDiffMemConsAConvftoi(ptr nocapture readonly %ptr) {
; P9BE-LABEL: fromDiffMemConsAConvftoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv vs0, 0(r3)
; P9BE-NEXT:    xvcvspsxws v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsAConvftoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxv vs0, 0(r3)
; P9LE-NEXT:    xvcvspsxws v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsAConvftoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lxvw4x vs0, 0, r3
; P8BE-NEXT:    xvcvspsxws v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsAConvftoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    xvcvspsxws v2, v2
; P8LE-NEXT:    blr
entry:
  %0 = load <4 x float>, ptr %ptr, align 4
  %1 = fptosi <4 x float> %0 to <4 x i32>
  ret <4 x i32> %1
}

define <4 x i32> @fromDiffMemConsDConvftoi(ptr nocapture readonly %ptr) {
; P9BE-LABEL: fromDiffMemConsDConvftoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv vs0, 0(r3)
; P9BE-NEXT:    addis r3, r2, .LCPI18_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI18_0@toc@l
; P9BE-NEXT:    lxv vs1, 0(r3)
; P9BE-NEXT:    xxperm vs0, vs0, vs1
; P9BE-NEXT:    xvcvspsxws v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsDConvftoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxv vs0, 0(r3)
; P9LE-NEXT:    addis r3, r2, .LCPI18_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI18_0@toc@l
; P9LE-NEXT:    lxv vs1, 0(r3)
; P9LE-NEXT:    xxperm vs0, vs0, vs1
; P9LE-NEXT:    xvcvspsxws v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsDConvftoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lxvw4x v2, 0, r3
; P8BE-NEXT:    addis r3, r2, .LCPI18_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI18_0@toc@l
; P8BE-NEXT:    lxvw4x v3, 0, r3
; P8BE-NEXT:    vperm v2, v2, v2, v3
; P8BE-NEXT:    xvcvspsxws v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsDConvftoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r4, r2, .LCPI18_0@toc@ha
; P8LE-NEXT:    lxvd2x v3, 0, r3
; P8LE-NEXT:    addi r4, r4, .LCPI18_0@toc@l
; P8LE-NEXT:    lxvd2x vs0, 0, r4
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    vperm v2, v3, v3, v2
; P8LE-NEXT:    xvcvspsxws v2, v2
; P8LE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds float, ptr %ptr, i64 3
  %0 = load float, ptr %arrayidx, align 4
  %conv = fptosi float %0 to i32
  %vecinit = insertelement <4 x i32> undef, i32 %conv, i32 0
  %arrayidx1 = getelementptr inbounds float, ptr %ptr, i64 2
  %1 = load float, ptr %arrayidx1, align 4
  %conv2 = fptosi float %1 to i32
  %vecinit3 = insertelement <4 x i32> %vecinit, i32 %conv2, i32 1
  %arrayidx4 = getelementptr inbounds float, ptr %ptr, i64 1
  %2 = load float, ptr %arrayidx4, align 4
  %conv5 = fptosi float %2 to i32
  %vecinit6 = insertelement <4 x i32> %vecinit3, i32 %conv5, i32 2
  %3 = load float, ptr %ptr, align 4
  %conv8 = fptosi float %3 to i32
  %vecinit9 = insertelement <4 x i32> %vecinit6, i32 %conv8, i32 3
  ret <4 x i32> %vecinit9
}

define <4 x i32> @fromDiffMemVarAConvftoi(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarAConvftoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 2
; P9BE-NEXT:    lfsux f0, r3, r4
; P9BE-NEXT:    lfs f1, 12(r3)
; P9BE-NEXT:    lfs f2, 4(r3)
; P9BE-NEXT:    xxmrghd vs1, vs2, vs1
; P9BE-NEXT:    xvcvdpsp v2, vs1
; P9BE-NEXT:    lfs f1, 8(r3)
; P9BE-NEXT:    xxmrghd vs0, vs0, vs1
; P9BE-NEXT:    xvcvdpsp v3, vs0
; P9BE-NEXT:    vmrgew v2, v3, v2
; P9BE-NEXT:    xvcvspsxws v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarAConvftoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 2
; P9LE-NEXT:    lfsux f0, r3, r4
; P9LE-NEXT:    lfs f1, 8(r3)
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    lfs f1, 12(r3)
; P9LE-NEXT:    xvcvdpsp v2, vs0
; P9LE-NEXT:    lfs f0, 4(r3)
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    xvcvdpsp v3, vs0
; P9LE-NEXT:    vmrgew v2, v3, v2
; P9LE-NEXT:    xvcvspsxws v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarAConvftoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 2
; P8BE-NEXT:    lfsux f0, r3, r4
; P8BE-NEXT:    lfs f1, 12(r3)
; P8BE-NEXT:    lfs f2, 4(r3)
; P8BE-NEXT:    xxmrghd vs1, vs2, vs1
; P8BE-NEXT:    lfs f2, 8(r3)
; P8BE-NEXT:    xvcvdpsp v2, vs1
; P8BE-NEXT:    xxmrghd vs0, vs0, vs2
; P8BE-NEXT:    xvcvdpsp v3, vs0
; P8BE-NEXT:    vmrgew v2, v3, v2
; P8BE-NEXT:    xvcvspsxws v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarAConvftoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 2
; P8LE-NEXT:    lfsux f0, r3, r4
; P8LE-NEXT:    lfs f1, 8(r3)
; P8LE-NEXT:    xxmrghd vs0, vs1, vs0
; P8LE-NEXT:    lfs f1, 4(r3)
; P8LE-NEXT:    lfs f2, 12(r3)
; P8LE-NEXT:    xvcvdpsp v2, vs0
; P8LE-NEXT:    xxmrghd vs1, vs2, vs1
; P8LE-NEXT:    xvcvdpsp v3, vs1
; P8LE-NEXT:    vmrgew v2, v3, v2
; P8LE-NEXT:    xvcvspsxws v2, v2
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds float, ptr %arr, i64 %idxprom
  %0 = load float, ptr %arrayidx, align 4
  %conv = fptosi float %0 to i32
  %vecinit = insertelement <4 x i32> undef, i32 %conv, i32 0
  %add = add nsw i32 %elem, 1
  %idxprom1 = sext i32 %add to i64
  %arrayidx2 = getelementptr inbounds float, ptr %arr, i64 %idxprom1
  %1 = load float, ptr %arrayidx2, align 4
  %conv3 = fptosi float %1 to i32
  %vecinit4 = insertelement <4 x i32> %vecinit, i32 %conv3, i32 1
  %add5 = add nsw i32 %elem, 2
  %idxprom6 = sext i32 %add5 to i64
  %arrayidx7 = getelementptr inbounds float, ptr %arr, i64 %idxprom6
  %2 = load float, ptr %arrayidx7, align 4
  %conv8 = fptosi float %2 to i32
  %vecinit9 = insertelement <4 x i32> %vecinit4, i32 %conv8, i32 2
  %add10 = add nsw i32 %elem, 3
  %idxprom11 = sext i32 %add10 to i64
  %arrayidx12 = getelementptr inbounds float, ptr %arr, i64 %idxprom11
  %3 = load float, ptr %arrayidx12, align 4
  %conv13 = fptosi float %3 to i32
  %vecinit14 = insertelement <4 x i32> %vecinit9, i32 %conv13, i32 3
  ret <4 x i32> %vecinit14
}

define <4 x i32> @fromDiffMemVarDConvftoi(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarDConvftoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 2
; P9BE-NEXT:    lfsux f0, r3, r4
; P9BE-NEXT:    lfs f1, -12(r3)
; P9BE-NEXT:    lfs f2, -4(r3)
; P9BE-NEXT:    xxmrghd vs1, vs2, vs1
; P9BE-NEXT:    xvcvdpsp v2, vs1
; P9BE-NEXT:    lfs f1, -8(r3)
; P9BE-NEXT:    xxmrghd vs0, vs0, vs1
; P9BE-NEXT:    xvcvdpsp v3, vs0
; P9BE-NEXT:    vmrgew v2, v3, v2
; P9BE-NEXT:    xvcvspsxws v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarDConvftoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 2
; P9LE-NEXT:    lfsux f0, r3, r4
; P9LE-NEXT:    lfs f1, -8(r3)
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    lfs f1, -12(r3)
; P9LE-NEXT:    xvcvdpsp v2, vs0
; P9LE-NEXT:    lfs f0, -4(r3)
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    xvcvdpsp v3, vs0
; P9LE-NEXT:    vmrgew v2, v3, v2
; P9LE-NEXT:    xvcvspsxws v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarDConvftoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 2
; P8BE-NEXT:    lfsux f0, r3, r4
; P8BE-NEXT:    lfs f1, -12(r3)
; P8BE-NEXT:    lfs f2, -4(r3)
; P8BE-NEXT:    xxmrghd vs1, vs2, vs1
; P8BE-NEXT:    lfs f2, -8(r3)
; P8BE-NEXT:    xvcvdpsp v2, vs1
; P8BE-NEXT:    xxmrghd vs0, vs0, vs2
; P8BE-NEXT:    xvcvdpsp v3, vs0
; P8BE-NEXT:    vmrgew v2, v3, v2
; P8BE-NEXT:    xvcvspsxws v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarDConvftoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 2
; P8LE-NEXT:    lfsux f0, r3, r4
; P8LE-NEXT:    lfs f1, -8(r3)
; P8LE-NEXT:    xxmrghd vs0, vs1, vs0
; P8LE-NEXT:    lfs f1, -4(r3)
; P8LE-NEXT:    lfs f2, -12(r3)
; P8LE-NEXT:    xvcvdpsp v2, vs0
; P8LE-NEXT:    xxmrghd vs1, vs2, vs1
; P8LE-NEXT:    xvcvdpsp v3, vs1
; P8LE-NEXT:    vmrgew v2, v3, v2
; P8LE-NEXT:    xvcvspsxws v2, v2
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds float, ptr %arr, i64 %idxprom
  %0 = load float, ptr %arrayidx, align 4
  %conv = fptosi float %0 to i32
  %vecinit = insertelement <4 x i32> undef, i32 %conv, i32 0
  %sub = add nsw i32 %elem, -1
  %idxprom1 = sext i32 %sub to i64
  %arrayidx2 = getelementptr inbounds float, ptr %arr, i64 %idxprom1
  %1 = load float, ptr %arrayidx2, align 4
  %conv3 = fptosi float %1 to i32
  %vecinit4 = insertelement <4 x i32> %vecinit, i32 %conv3, i32 1
  %sub5 = add nsw i32 %elem, -2
  %idxprom6 = sext i32 %sub5 to i64
  %arrayidx7 = getelementptr inbounds float, ptr %arr, i64 %idxprom6
  %2 = load float, ptr %arrayidx7, align 4
  %conv8 = fptosi float %2 to i32
  %vecinit9 = insertelement <4 x i32> %vecinit4, i32 %conv8, i32 2
  %sub10 = add nsw i32 %elem, -3
  %idxprom11 = sext i32 %sub10 to i64
  %arrayidx12 = getelementptr inbounds float, ptr %arr, i64 %idxprom11
  %3 = load float, ptr %arrayidx12, align 4
  %conv13 = fptosi float %3 to i32
  %vecinit14 = insertelement <4 x i32> %vecinit9, i32 %conv13, i32 3
  ret <4 x i32> %vecinit14
; FIXME: implement finding consecutive loads with pre-inc
}

define <4 x i32> @spltRegValConvftoi(float %val) {
; P9BE-LABEL: spltRegValConvftoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xscvdpsxws f0, f1
; P9BE-NEXT:    xxspltw v2, vs0, 1
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltRegValConvftoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xscvdpsxws f0, f1
; P9LE-NEXT:    xxspltw v2, vs0, 1
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltRegValConvftoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xscvdpsxws f0, f1
; P8BE-NEXT:    xxspltw v2, vs0, 1
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltRegValConvftoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xscvdpsxws f0, f1
; P8LE-NEXT:    xxspltw v2, vs0, 1
; P8LE-NEXT:    blr
entry:
  %conv = fptosi float %val to i32
  %splat.splatinsert = insertelement <4 x i32> undef, i32 %conv, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> undef, <4 x i32> zeroinitializer
  ret <4 x i32> %splat.splat
}

define <4 x i32> @spltMemValConvftoi(ptr nocapture readonly %ptr) {
; P9BE-LABEL: spltMemValConvftoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lfiwzx f0, 0, r3
; P9BE-NEXT:    xvcvspsxws vs0, vs0
; P9BE-NEXT:    xxspltw v2, vs0, 1
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltMemValConvftoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lfiwzx f0, 0, r3
; P9LE-NEXT:    xvcvspsxws vs0, vs0
; P9LE-NEXT:    xxspltw v2, vs0, 1
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltMemValConvftoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lfsx f0, 0, r3
; P8BE-NEXT:    xscvdpsxws f0, f0
; P8BE-NEXT:    xxspltw v2, vs0, 1
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltMemValConvftoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lfsx f0, 0, r3
; P8LE-NEXT:    xscvdpsxws f0, f0
; P8LE-NEXT:    xxspltw v2, vs0, 1
; P8LE-NEXT:    blr
entry:
  %0 = load float, ptr %ptr, align 4
  %conv = fptosi float %0 to i32
  %splat.splatinsert = insertelement <4 x i32> undef, i32 %conv, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> undef, <4 x i32> zeroinitializer
  ret <4 x i32> %splat.splat
}

define <4 x i32> @spltCnstConvdtoi() {
; P9BE-LABEL: spltCnstConvdtoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    vspltisw v2, 4
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltCnstConvdtoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    vspltisw v2, 4
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltCnstConvdtoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    vspltisw v2, 4
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltCnstConvdtoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    vspltisw v2, 4
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> <i32 4, i32 4, i32 4, i32 4>
}

define <4 x i32> @fromRegsConvdtoi(double %a, double %b, double %c, double %d) {
; P9BE-LABEL: fromRegsConvdtoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxmrghd vs0, vs2, vs4
; P9BE-NEXT:    xvcvdpsxws v2, vs0
; P9BE-NEXT:    xxmrghd vs0, vs1, vs3
; P9BE-NEXT:    xvcvdpsxws v3, vs0
; P9BE-NEXT:    vmrgew v2, v3, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRegsConvdtoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxmrghd vs0, vs3, vs1
; P9LE-NEXT:    xvcvdpsxws v2, vs0
; P9LE-NEXT:    xxmrghd vs0, vs4, vs2
; P9LE-NEXT:    xvcvdpsxws v3, vs0
; P9LE-NEXT:    vmrgew v2, v3, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRegsConvdtoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxmrghd vs0, vs2, vs4
; P8BE-NEXT:    xxmrghd vs1, vs1, vs3
; P8BE-NEXT:    xvcvdpsxws v2, vs0
; P8BE-NEXT:    xvcvdpsxws v3, vs1
; P8BE-NEXT:    vmrgew v2, v3, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRegsConvdtoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxmrghd vs0, vs3, vs1
; P8LE-NEXT:    xxmrghd vs1, vs4, vs2
; P8LE-NEXT:    xvcvdpsxws v2, vs0
; P8LE-NEXT:    xvcvdpsxws v3, vs1
; P8LE-NEXT:    vmrgew v2, v3, v2
; P8LE-NEXT:    blr
entry:
  %conv = fptosi double %a to i32
  %vecinit = insertelement <4 x i32> undef, i32 %conv, i32 0
  %conv1 = fptosi double %b to i32
  %vecinit2 = insertelement <4 x i32> %vecinit, i32 %conv1, i32 1
  %conv3 = fptosi double %c to i32
  %vecinit4 = insertelement <4 x i32> %vecinit2, i32 %conv3, i32 2
  %conv5 = fptosi double %d to i32
  %vecinit6 = insertelement <4 x i32> %vecinit4, i32 %conv5, i32 3
  ret <4 x i32> %vecinit6
}

define <4 x i32> @fromDiffConstsConvdtoi() {
; P9BE-LABEL: fromDiffConstsConvdtoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    addis r3, r2, .LCPI25_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI25_0@toc@l
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffConstsConvdtoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addis r3, r2, .LCPI25_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI25_0@toc@l
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffConstsConvdtoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addis r3, r2, .LCPI25_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI25_0@toc@l
; P8BE-NEXT:    lxvw4x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffConstsConvdtoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r3, r2, .LCPI25_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI25_0@toc@l
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> <i32 24, i32 234, i32 988, i32 422>
}

define <4 x i32> @fromDiffMemConsAConvdtoi(ptr nocapture readonly %ptr) {
; P9BE-LABEL: fromDiffMemConsAConvdtoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv vs0, 0(r3)
; P9BE-NEXT:    lxv vs1, 16(r3)
; P9BE-NEXT:    xxmrgld vs2, vs0, vs1
; P9BE-NEXT:    xxmrghd vs0, vs0, vs1
; P9BE-NEXT:    xvcvdpsxws v2, vs2
; P9BE-NEXT:    xvcvdpsxws v3, vs0
; P9BE-NEXT:    vmrgew v2, v3, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsAConvdtoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxv vs0, 0(r3)
; P9LE-NEXT:    lxv vs1, 16(r3)
; P9LE-NEXT:    xxmrgld vs2, vs1, vs0
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    xvcvdpsxws v2, vs2
; P9LE-NEXT:    xvcvdpsxws v3, vs0
; P9LE-NEXT:    vmrgew v2, v3, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsAConvdtoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    li r4, 16
; P8BE-NEXT:    lxvd2x vs0, 0, r3
; P8BE-NEXT:    lxvd2x vs1, r3, r4
; P8BE-NEXT:    xxmrgld vs2, vs0, vs1
; P8BE-NEXT:    xxmrghd vs0, vs0, vs1
; P8BE-NEXT:    xvcvdpsxws v2, vs2
; P8BE-NEXT:    xvcvdpsxws v3, vs0
; P8BE-NEXT:    vmrgew v2, v3, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsAConvdtoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    li r4, 16
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    lxvd2x vs1, r3, r4
; P8LE-NEXT:    xxswapd vs0, vs0
; P8LE-NEXT:    xxswapd vs1, vs1
; P8LE-NEXT:    xxmrgld vs2, vs1, vs0
; P8LE-NEXT:    xxmrghd vs0, vs1, vs0
; P8LE-NEXT:    xvcvdpsxws v2, vs2
; P8LE-NEXT:    xvcvdpsxws v3, vs0
; P8LE-NEXT:    vmrgew v2, v3, v2
; P8LE-NEXT:    blr
entry:
  %0 = load <2 x double>, ptr %ptr, align 8
  %1 = fptosi <2 x double> %0 to <2 x i32>
  %arrayidx4 = getelementptr inbounds double, ptr %ptr, i64 2
  %2 = load <2 x double>, ptr %arrayidx4, align 8
  %3 = fptosi <2 x double> %2 to <2 x i32>
  %vecinit9 = shufflevector <2 x i32> %1, <2 x i32> %3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i32> %vecinit9
}

define <4 x i32> @fromDiffMemConsDConvdtoi(ptr nocapture readonly %ptr) {
; P9BE-LABEL: fromDiffMemConsDConvdtoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lfd f0, 24(r3)
; P9BE-NEXT:    lfd f1, 16(r3)
; P9BE-NEXT:    lfd f2, 8(r3)
; P9BE-NEXT:    xxmrghd vs0, vs0, vs2
; P9BE-NEXT:    lfd f3, 0(r3)
; P9BE-NEXT:    xxmrghd vs1, vs1, vs3
; P9BE-NEXT:    xvcvdpsxws v2, vs1
; P9BE-NEXT:    xvcvdpsxws v3, vs0
; P9BE-NEXT:    vmrgew v2, v3, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsDConvdtoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lfd f0, 24(r3)
; P9LE-NEXT:    lfd f2, 8(r3)
; P9LE-NEXT:    xxmrghd vs0, vs2, vs0
; P9LE-NEXT:    lfd f1, 16(r3)
; P9LE-NEXT:    lfd f3, 0(r3)
; P9LE-NEXT:    xvcvdpsxws v2, vs0
; P9LE-NEXT:    xxmrghd vs0, vs3, vs1
; P9LE-NEXT:    xvcvdpsxws v3, vs0
; P9LE-NEXT:    vmrgew v2, v3, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsDConvdtoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lfd f0, 24(r3)
; P8BE-NEXT:    lfd f1, 16(r3)
; P8BE-NEXT:    lfd f2, 8(r3)
; P8BE-NEXT:    lfd f3, 0(r3)
; P8BE-NEXT:    xxmrghd vs1, vs1, vs3
; P8BE-NEXT:    xxmrghd vs0, vs0, vs2
; P8BE-NEXT:    xvcvdpsxws v2, vs1
; P8BE-NEXT:    xvcvdpsxws v3, vs0
; P8BE-NEXT:    vmrgew v2, v3, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsDConvdtoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lfd f0, 24(r3)
; P8LE-NEXT:    lfd f1, 16(r3)
; P8LE-NEXT:    lfd f2, 8(r3)
; P8LE-NEXT:    lfd f3, 0(r3)
; P8LE-NEXT:    xxmrghd vs0, vs2, vs0
; P8LE-NEXT:    xxmrghd vs1, vs3, vs1
; P8LE-NEXT:    xvcvdpsxws v2, vs0
; P8LE-NEXT:    xvcvdpsxws v3, vs1
; P8LE-NEXT:    vmrgew v2, v3, v2
; P8LE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds double, ptr %ptr, i64 3
  %0 = load double, ptr %arrayidx, align 8
  %conv = fptosi double %0 to i32
  %vecinit = insertelement <4 x i32> undef, i32 %conv, i32 0
  %arrayidx1 = getelementptr inbounds double, ptr %ptr, i64 2
  %1 = load double, ptr %arrayidx1, align 8
  %conv2 = fptosi double %1 to i32
  %vecinit3 = insertelement <4 x i32> %vecinit, i32 %conv2, i32 1
  %arrayidx4 = getelementptr inbounds double, ptr %ptr, i64 1
  %2 = load double, ptr %arrayidx4, align 8
  %conv5 = fptosi double %2 to i32
  %vecinit6 = insertelement <4 x i32> %vecinit3, i32 %conv5, i32 2
  %3 = load double, ptr %ptr, align 8
  %conv8 = fptosi double %3 to i32
  %vecinit9 = insertelement <4 x i32> %vecinit6, i32 %conv8, i32 3
  ret <4 x i32> %vecinit9
}

define <4 x i32> @fromDiffMemVarAConvdtoi(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarAConvdtoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 3
; P9BE-NEXT:    lfdux f0, r3, r4
; P9BE-NEXT:    lfd f1, 8(r3)
; P9BE-NEXT:    lfd f2, 16(r3)
; P9BE-NEXT:    lfd f3, 24(r3)
; P9BE-NEXT:    xxmrghd vs1, vs1, vs3
; P9BE-NEXT:    xxmrghd vs0, vs0, vs2
; P9BE-NEXT:    xvcvdpsxws v2, vs1
; P9BE-NEXT:    xvcvdpsxws v3, vs0
; P9BE-NEXT:    vmrgew v2, v3, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarAConvdtoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 3
; P9LE-NEXT:    lfdux f0, r3, r4
; P9LE-NEXT:    lfd f2, 16(r3)
; P9LE-NEXT:    lfd f1, 8(r3)
; P9LE-NEXT:    lfd f3, 24(r3)
; P9LE-NEXT:    xxmrghd vs0, vs2, vs0
; P9LE-NEXT:    xvcvdpsxws v2, vs0
; P9LE-NEXT:    xxmrghd vs0, vs3, vs1
; P9LE-NEXT:    xvcvdpsxws v3, vs0
; P9LE-NEXT:    vmrgew v2, v3, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarAConvdtoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 3
; P8BE-NEXT:    lfdux f0, r3, r4
; P8BE-NEXT:    lfd f1, 8(r3)
; P8BE-NEXT:    lfd f2, 16(r3)
; P8BE-NEXT:    lfd f3, 24(r3)
; P8BE-NEXT:    xxmrghd vs1, vs1, vs3
; P8BE-NEXT:    xxmrghd vs0, vs0, vs2
; P8BE-NEXT:    xvcvdpsxws v2, vs1
; P8BE-NEXT:    xvcvdpsxws v3, vs0
; P8BE-NEXT:    vmrgew v2, v3, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarAConvdtoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 3
; P8LE-NEXT:    lfdux f0, r3, r4
; P8LE-NEXT:    lfd f1, 8(r3)
; P8LE-NEXT:    lfd f2, 16(r3)
; P8LE-NEXT:    lfd f3, 24(r3)
; P8LE-NEXT:    xxmrghd vs0, vs2, vs0
; P8LE-NEXT:    xxmrghd vs1, vs3, vs1
; P8LE-NEXT:    xvcvdpsxws v2, vs0
; P8LE-NEXT:    xvcvdpsxws v3, vs1
; P8LE-NEXT:    vmrgew v2, v3, v2
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds double, ptr %arr, i64 %idxprom
  %0 = load double, ptr %arrayidx, align 8
  %conv = fptosi double %0 to i32
  %vecinit = insertelement <4 x i32> undef, i32 %conv, i32 0
  %add = add nsw i32 %elem, 1
  %idxprom1 = sext i32 %add to i64
  %arrayidx2 = getelementptr inbounds double, ptr %arr, i64 %idxprom1
  %1 = load double, ptr %arrayidx2, align 8
  %conv3 = fptosi double %1 to i32
  %vecinit4 = insertelement <4 x i32> %vecinit, i32 %conv3, i32 1
  %add5 = add nsw i32 %elem, 2
  %idxprom6 = sext i32 %add5 to i64
  %arrayidx7 = getelementptr inbounds double, ptr %arr, i64 %idxprom6
  %2 = load double, ptr %arrayidx7, align 8
  %conv8 = fptosi double %2 to i32
  %vecinit9 = insertelement <4 x i32> %vecinit4, i32 %conv8, i32 2
  %add10 = add nsw i32 %elem, 3
  %idxprom11 = sext i32 %add10 to i64
  %arrayidx12 = getelementptr inbounds double, ptr %arr, i64 %idxprom11
  %3 = load double, ptr %arrayidx12, align 8
  %conv13 = fptosi double %3 to i32
  %vecinit14 = insertelement <4 x i32> %vecinit9, i32 %conv13, i32 3
  ret <4 x i32> %vecinit14
}

define <4 x i32> @fromDiffMemVarDConvdtoi(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarDConvdtoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 3
; P9BE-NEXT:    lfdux f0, r3, r4
; P9BE-NEXT:    lfd f1, -8(r3)
; P9BE-NEXT:    lfd f2, -16(r3)
; P9BE-NEXT:    lfd f3, -24(r3)
; P9BE-NEXT:    xxmrghd vs1, vs1, vs3
; P9BE-NEXT:    xxmrghd vs0, vs0, vs2
; P9BE-NEXT:    xvcvdpsxws v2, vs1
; P9BE-NEXT:    xvcvdpsxws v3, vs0
; P9BE-NEXT:    vmrgew v2, v3, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarDConvdtoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 3
; P9LE-NEXT:    lfdux f0, r3, r4
; P9LE-NEXT:    lfd f2, -16(r3)
; P9LE-NEXT:    lfd f1, -8(r3)
; P9LE-NEXT:    lfd f3, -24(r3)
; P9LE-NEXT:    xxmrghd vs0, vs2, vs0
; P9LE-NEXT:    xvcvdpsxws v2, vs0
; P9LE-NEXT:    xxmrghd vs0, vs3, vs1
; P9LE-NEXT:    xvcvdpsxws v3, vs0
; P9LE-NEXT:    vmrgew v2, v3, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarDConvdtoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 3
; P8BE-NEXT:    lfdux f0, r3, r4
; P8BE-NEXT:    lfd f1, -8(r3)
; P8BE-NEXT:    lfd f2, -16(r3)
; P8BE-NEXT:    lfd f3, -24(r3)
; P8BE-NEXT:    xxmrghd vs1, vs1, vs3
; P8BE-NEXT:    xxmrghd vs0, vs0, vs2
; P8BE-NEXT:    xvcvdpsxws v2, vs1
; P8BE-NEXT:    xvcvdpsxws v3, vs0
; P8BE-NEXT:    vmrgew v2, v3, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarDConvdtoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 3
; P8LE-NEXT:    lfdux f0, r3, r4
; P8LE-NEXT:    lfd f1, -8(r3)
; P8LE-NEXT:    lfd f2, -16(r3)
; P8LE-NEXT:    lfd f3, -24(r3)
; P8LE-NEXT:    xxmrghd vs0, vs2, vs0
; P8LE-NEXT:    xxmrghd vs1, vs3, vs1
; P8LE-NEXT:    xvcvdpsxws v2, vs0
; P8LE-NEXT:    xvcvdpsxws v3, vs1
; P8LE-NEXT:    vmrgew v2, v3, v2
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds double, ptr %arr, i64 %idxprom
  %0 = load double, ptr %arrayidx, align 8
  %conv = fptosi double %0 to i32
  %vecinit = insertelement <4 x i32> undef, i32 %conv, i32 0
  %sub = add nsw i32 %elem, -1
  %idxprom1 = sext i32 %sub to i64
  %arrayidx2 = getelementptr inbounds double, ptr %arr, i64 %idxprom1
  %1 = load double, ptr %arrayidx2, align 8
  %conv3 = fptosi double %1 to i32
  %vecinit4 = insertelement <4 x i32> %vecinit, i32 %conv3, i32 1
  %sub5 = add nsw i32 %elem, -2
  %idxprom6 = sext i32 %sub5 to i64
  %arrayidx7 = getelementptr inbounds double, ptr %arr, i64 %idxprom6
  %2 = load double, ptr %arrayidx7, align 8
  %conv8 = fptosi double %2 to i32
  %vecinit9 = insertelement <4 x i32> %vecinit4, i32 %conv8, i32 2
  %sub10 = add nsw i32 %elem, -3
  %idxprom11 = sext i32 %sub10 to i64
  %arrayidx12 = getelementptr inbounds double, ptr %arr, i64 %idxprom11
  %3 = load double, ptr %arrayidx12, align 8
  %conv13 = fptosi double %3 to i32
  %vecinit14 = insertelement <4 x i32> %vecinit9, i32 %conv13, i32 3
  ret <4 x i32> %vecinit14
}

define <4 x i32> @spltRegValConvdtoi(double %val) {
; P9BE-LABEL: spltRegValConvdtoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xscvdpsxws f0, f1
; P9BE-NEXT:    xxspltw v2, vs0, 1
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltRegValConvdtoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xscvdpsxws f0, f1
; P9LE-NEXT:    xxspltw v2, vs0, 1
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltRegValConvdtoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xscvdpsxws f0, f1
; P8BE-NEXT:    xxspltw v2, vs0, 1
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltRegValConvdtoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xscvdpsxws f0, f1
; P8LE-NEXT:    xxspltw v2, vs0, 1
; P8LE-NEXT:    blr
entry:
  %conv = fptosi double %val to i32
  %splat.splatinsert = insertelement <4 x i32> undef, i32 %conv, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> undef, <4 x i32> zeroinitializer
  ret <4 x i32> %splat.splat
}

define <4 x i32> @spltMemValConvdtoi(ptr nocapture readonly %ptr) {
; P9BE-LABEL: spltMemValConvdtoi:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lfd f0, 0(r3)
; P9BE-NEXT:    xscvdpsxws f0, f0
; P9BE-NEXT:    xxspltw v2, vs0, 1
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltMemValConvdtoi:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lfd f0, 0(r3)
; P9LE-NEXT:    xscvdpsxws f0, f0
; P9LE-NEXT:    xxspltw v2, vs0, 1
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltMemValConvdtoi:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lfdx f0, 0, r3
; P8BE-NEXT:    xscvdpsxws f0, f0
; P8BE-NEXT:    xxspltw v2, vs0, 1
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltMemValConvdtoi:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lfdx f0, 0, r3
; P8LE-NEXT:    xscvdpsxws f0, f0
; P8LE-NEXT:    xxspltw v2, vs0, 1
; P8LE-NEXT:    blr
entry:
  %0 = load double, ptr %ptr, align 8
  %conv = fptosi double %0 to i32
  %splat.splatinsert = insertelement <4 x i32> undef, i32 %conv, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> undef, <4 x i32> zeroinitializer
  ret <4 x i32> %splat.splat
}

define <4 x i32> @allZeroui() {
; P9BE-LABEL: allZeroui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxlxor v2, v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: allZeroui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxlxor v2, v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: allZeroui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxlxor v2, v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: allZeroui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxlxor v2, v2, v2
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> zeroinitializer
}

define <4 x i32> @spltConst1ui() {
; P9BE-LABEL: spltConst1ui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    vspltisw v2, 1
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltConst1ui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    vspltisw v2, 1
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltConst1ui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    vspltisw v2, 1
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltConst1ui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    vspltisw v2, 1
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> <i32 1, i32 1, i32 1, i32 1>
}

define <4 x i32> @spltConst16kui() {
; P9BE-LABEL: spltConst16kui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    vspltisw v2, -15
; P9BE-NEXT:    vsrw v2, v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltConst16kui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    vspltisw v2, -15
; P9LE-NEXT:    vsrw v2, v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltConst16kui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    vspltisw v2, -15
; P8BE-NEXT:    vsrw v2, v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltConst16kui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    vspltisw v2, -15
; P8LE-NEXT:    vsrw v2, v2, v2
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> <i32 32767, i32 32767, i32 32767, i32 32767>
}

define <4 x i32> @spltConst32kui() {
; P9BE-LABEL: spltConst32kui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    vspltisw v2, -16
; P9BE-NEXT:    vsrw v2, v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltConst32kui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    vspltisw v2, -16
; P9LE-NEXT:    vsrw v2, v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltConst32kui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    vspltisw v2, -16
; P8BE-NEXT:    vsrw v2, v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltConst32kui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    vspltisw v2, -16
; P8LE-NEXT:    vsrw v2, v2, v2
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
}

define <4 x i32> @fromRegsui(i32 zeroext %a, i32 zeroext %b, i32 zeroext %c, i32 zeroext %d) {
; P9BE-LABEL: fromRegsui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    rldimi r6, r5, 32, 0
; P9BE-NEXT:    rldimi r4, r3, 32, 0
; P9BE-NEXT:    mtvsrdd v2, r4, r6
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRegsui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    rldimi r3, r4, 32, 0
; P9LE-NEXT:    rldimi r5, r6, 32, 0
; P9LE-NEXT:    mtvsrdd v2, r5, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRegsui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    rldimi r6, r5, 32, 0
; P8BE-NEXT:    rldimi r4, r3, 32, 0
; P8BE-NEXT:    mtfprd f0, r6
; P8BE-NEXT:    mtfprd f1, r4
; P8BE-NEXT:    xxmrghd v2, vs1, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRegsui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    rldimi r3, r4, 32, 0
; P8LE-NEXT:    rldimi r5, r6, 32, 0
; P8LE-NEXT:    mtfprd f0, r3
; P8LE-NEXT:    mtfprd f1, r5
; P8LE-NEXT:    xxmrghd v2, vs1, vs0
; P8LE-NEXT:    blr
entry:
  %vecinit = insertelement <4 x i32> undef, i32 %a, i32 0
  %vecinit1 = insertelement <4 x i32> %vecinit, i32 %b, i32 1
  %vecinit2 = insertelement <4 x i32> %vecinit1, i32 %c, i32 2
  %vecinit3 = insertelement <4 x i32> %vecinit2, i32 %d, i32 3
  ret <4 x i32> %vecinit3
}

define <4 x i32> @fromDiffConstsui() {
; P9BE-LABEL: fromDiffConstsui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    addis r3, r2, .LCPI37_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI37_0@toc@l
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffConstsui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addis r3, r2, .LCPI37_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI37_0@toc@l
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffConstsui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addis r3, r2, .LCPI37_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI37_0@toc@l
; P8BE-NEXT:    lxvw4x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffConstsui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r3, r2, .LCPI37_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI37_0@toc@l
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> <i32 242, i32 -113, i32 889, i32 19>
}

define <4 x i32> @fromDiffMemConsAui(ptr nocapture readonly %arr) {
; P9BE-LABEL: fromDiffMemConsAui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsAui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsAui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lxvw4x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsAui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  %0 = load i32, ptr %arr, align 4
  %vecinit = insertelement <4 x i32> undef, i32 %0, i32 0
  %arrayidx1 = getelementptr inbounds i32, ptr %arr, i64 1
  %1 = load i32, ptr %arrayidx1, align 4
  %vecinit2 = insertelement <4 x i32> %vecinit, i32 %1, i32 1
  %arrayidx3 = getelementptr inbounds i32, ptr %arr, i64 2
  %2 = load i32, ptr %arrayidx3, align 4
  %vecinit4 = insertelement <4 x i32> %vecinit2, i32 %2, i32 2
  %arrayidx5 = getelementptr inbounds i32, ptr %arr, i64 3
  %3 = load i32, ptr %arrayidx5, align 4
  %vecinit6 = insertelement <4 x i32> %vecinit4, i32 %3, i32 3
  ret <4 x i32> %vecinit6
}

define <4 x i32> @fromDiffMemConsDui(ptr nocapture readonly %arr) {
; P9BE-LABEL: fromDiffMemConsDui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    addis r3, r2, .LCPI39_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI39_0@toc@l
; P9BE-NEXT:    lxv vs0, 0(r3)
; P9BE-NEXT:    xxperm v2, v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsDui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxvw4x v2, 0, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsDui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lxvw4x v2, 0, r3
; P8BE-NEXT:    addis r3, r2, .LCPI39_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI39_0@toc@l
; P8BE-NEXT:    lxvw4x v3, 0, r3
; P8BE-NEXT:    vperm v2, v2, v2, v3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsDui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    addis r3, r2, .LCPI39_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI39_0@toc@l
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v3, vs0
; P8LE-NEXT:    vperm v2, v2, v2, v3
; P8LE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds i32, ptr %arr, i64 3
  %0 = load i32, ptr %arrayidx, align 4
  %vecinit = insertelement <4 x i32> undef, i32 %0, i32 0
  %arrayidx1 = getelementptr inbounds i32, ptr %arr, i64 2
  %1 = load i32, ptr %arrayidx1, align 4
  %vecinit2 = insertelement <4 x i32> %vecinit, i32 %1, i32 1
  %arrayidx3 = getelementptr inbounds i32, ptr %arr, i64 1
  %2 = load i32, ptr %arrayidx3, align 4
  %vecinit4 = insertelement <4 x i32> %vecinit2, i32 %2, i32 2
  %3 = load i32, ptr %arr, align 4
  %vecinit6 = insertelement <4 x i32> %vecinit4, i32 %3, i32 3
  ret <4 x i32> %vecinit6
}

define <4 x i32> @fromDiffMemVarAui(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarAui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 2
; P9BE-NEXT:    lxvx v2, r3, r4
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarAui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 2
; P9LE-NEXT:    lxvx v2, r3, r4
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarAui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 2
; P8BE-NEXT:    lxvw4x v2, r3, r4
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarAui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 2
; P8LE-NEXT:    lxvd2x vs0, r3, r4
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds i32, ptr %arr, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  %vecinit = insertelement <4 x i32> undef, i32 %0, i32 0
  %add = add nsw i32 %elem, 1
  %idxprom1 = sext i32 %add to i64
  %arrayidx2 = getelementptr inbounds i32, ptr %arr, i64 %idxprom1
  %1 = load i32, ptr %arrayidx2, align 4
  %vecinit3 = insertelement <4 x i32> %vecinit, i32 %1, i32 1
  %add4 = add nsw i32 %elem, 2
  %idxprom5 = sext i32 %add4 to i64
  %arrayidx6 = getelementptr inbounds i32, ptr %arr, i64 %idxprom5
  %2 = load i32, ptr %arrayidx6, align 4
  %vecinit7 = insertelement <4 x i32> %vecinit3, i32 %2, i32 2
  %add8 = add nsw i32 %elem, 3
  %idxprom9 = sext i32 %add8 to i64
  %arrayidx10 = getelementptr inbounds i32, ptr %arr, i64 %idxprom9
  %3 = load i32, ptr %arrayidx10, align 4
  %vecinit11 = insertelement <4 x i32> %vecinit7, i32 %3, i32 3
  ret <4 x i32> %vecinit11
}

define <4 x i32> @fromDiffMemVarDui(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarDui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 2
; P9BE-NEXT:    add r3, r3, r4
; P9BE-NEXT:    li r4, -12
; P9BE-NEXT:    lxvx v2, r3, r4
; P9BE-NEXT:    addis r3, r2, .LCPI41_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI41_0@toc@l
; P9BE-NEXT:    lxv vs0, 0(r3)
; P9BE-NEXT:    xxperm v2, v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarDui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 2
; P9LE-NEXT:    add r3, r3, r4
; P9LE-NEXT:    addi r3, r3, -12
; P9LE-NEXT:    lxvw4x v2, 0, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarDui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 2
; P8BE-NEXT:    add r3, r3, r4
; P8BE-NEXT:    addi r3, r3, -12
; P8BE-NEXT:    lxvw4x v2, 0, r3
; P8BE-NEXT:    addis r3, r2, .LCPI41_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI41_0@toc@l
; P8BE-NEXT:    lxvw4x v3, 0, r3
; P8BE-NEXT:    vperm v2, v2, v2, v3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarDui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 2
; P8LE-NEXT:    add r3, r3, r4
; P8LE-NEXT:    addi r3, r3, -12
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    addis r3, r2, .LCPI41_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI41_0@toc@l
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v3, vs0
; P8LE-NEXT:    vperm v2, v2, v2, v3
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds i32, ptr %arr, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  %vecinit = insertelement <4 x i32> undef, i32 %0, i32 0
  %sub = add nsw i32 %elem, -1
  %idxprom1 = sext i32 %sub to i64
  %arrayidx2 = getelementptr inbounds i32, ptr %arr, i64 %idxprom1
  %1 = load i32, ptr %arrayidx2, align 4
  %vecinit3 = insertelement <4 x i32> %vecinit, i32 %1, i32 1
  %sub4 = add nsw i32 %elem, -2
  %idxprom5 = sext i32 %sub4 to i64
  %arrayidx6 = getelementptr inbounds i32, ptr %arr, i64 %idxprom5
  %2 = load i32, ptr %arrayidx6, align 4
  %vecinit7 = insertelement <4 x i32> %vecinit3, i32 %2, i32 2
  %sub8 = add nsw i32 %elem, -3
  %idxprom9 = sext i32 %sub8 to i64
  %arrayidx10 = getelementptr inbounds i32, ptr %arr, i64 %idxprom9
  %3 = load i32, ptr %arrayidx10, align 4
  %vecinit11 = insertelement <4 x i32> %vecinit7, i32 %3, i32 3
  ret <4 x i32> %vecinit11
}

define <4 x i32> @fromRandMemConsui(ptr nocapture readonly %arr) {
; P9BE-LABEL: fromRandMemConsui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lwz r4, 16(r3)
; P9BE-NEXT:    lwz r5, 72(r3)
; P9BE-NEXT:    lwz r6, 8(r3)
; P9BE-NEXT:    lwz r3, 352(r3)
; P9BE-NEXT:    rldimi r3, r6, 32, 0
; P9BE-NEXT:    rldimi r5, r4, 32, 0
; P9BE-NEXT:    mtvsrdd v2, r5, r3
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRandMemConsui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lwz r4, 16(r3)
; P9LE-NEXT:    lwz r5, 72(r3)
; P9LE-NEXT:    lwz r6, 8(r3)
; P9LE-NEXT:    lwz r3, 352(r3)
; P9LE-NEXT:    rldimi r4, r5, 32, 0
; P9LE-NEXT:    rldimi r6, r3, 32, 0
; P9LE-NEXT:    mtvsrdd v2, r6, r4
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRandMemConsui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lwz r4, 16(r3)
; P8BE-NEXT:    lwz r5, 72(r3)
; P8BE-NEXT:    lwz r6, 8(r3)
; P8BE-NEXT:    lwz r3, 352(r3)
; P8BE-NEXT:    rldimi r3, r6, 32, 0
; P8BE-NEXT:    rldimi r5, r4, 32, 0
; P8BE-NEXT:    mtfprd f0, r3
; P8BE-NEXT:    mtfprd f1, r5
; P8BE-NEXT:    xxmrghd v2, vs1, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRandMemConsui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lwz r4, 16(r3)
; P8LE-NEXT:    lwz r5, 72(r3)
; P8LE-NEXT:    lwz r6, 8(r3)
; P8LE-NEXT:    lwz r3, 352(r3)
; P8LE-NEXT:    rldimi r4, r5, 32, 0
; P8LE-NEXT:    rldimi r6, r3, 32, 0
; P8LE-NEXT:    mtfprd f0, r4
; P8LE-NEXT:    mtfprd f1, r6
; P8LE-NEXT:    xxmrghd v2, vs1, vs0
; P8LE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds i32, ptr %arr, i64 4
  %0 = load i32, ptr %arrayidx, align 4
  %vecinit = insertelement <4 x i32> undef, i32 %0, i32 0
  %arrayidx1 = getelementptr inbounds i32, ptr %arr, i64 18
  %1 = load i32, ptr %arrayidx1, align 4
  %vecinit2 = insertelement <4 x i32> %vecinit, i32 %1, i32 1
  %arrayidx3 = getelementptr inbounds i32, ptr %arr, i64 2
  %2 = load i32, ptr %arrayidx3, align 4
  %vecinit4 = insertelement <4 x i32> %vecinit2, i32 %2, i32 2
  %arrayidx5 = getelementptr inbounds i32, ptr %arr, i64 88
  %3 = load i32, ptr %arrayidx5, align 4
  %vecinit6 = insertelement <4 x i32> %vecinit4, i32 %3, i32 3
  ret <4 x i32> %vecinit6
}

define <4 x i32> @fromRandMemVarui(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromRandMemVarui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 2
; P9BE-NEXT:    add r3, r3, r4
; P9BE-NEXT:    lwz r4, 16(r3)
; P9BE-NEXT:    lwz r5, 4(r3)
; P9BE-NEXT:    lwz r6, 8(r3)
; P9BE-NEXT:    lwz r3, 32(r3)
; P9BE-NEXT:    rldimi r3, r6, 32, 0
; P9BE-NEXT:    rldimi r5, r4, 32, 0
; P9BE-NEXT:    mtvsrdd v2, r5, r3
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRandMemVarui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 2
; P9LE-NEXT:    add r3, r3, r4
; P9LE-NEXT:    lwz r4, 16(r3)
; P9LE-NEXT:    lwz r5, 4(r3)
; P9LE-NEXT:    lwz r6, 8(r3)
; P9LE-NEXT:    lwz r3, 32(r3)
; P9LE-NEXT:    rldimi r4, r5, 32, 0
; P9LE-NEXT:    rldimi r6, r3, 32, 0
; P9LE-NEXT:    mtvsrdd v2, r6, r4
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRandMemVarui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 2
; P8BE-NEXT:    add r3, r3, r4
; P8BE-NEXT:    lwz r4, 16(r3)
; P8BE-NEXT:    lwz r5, 4(r3)
; P8BE-NEXT:    lwz r6, 8(r3)
; P8BE-NEXT:    lwz r3, 32(r3)
; P8BE-NEXT:    rldimi r3, r6, 32, 0
; P8BE-NEXT:    rldimi r5, r4, 32, 0
; P8BE-NEXT:    mtfprd f0, r3
; P8BE-NEXT:    mtfprd f1, r5
; P8BE-NEXT:    xxmrghd v2, vs1, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRandMemVarui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 2
; P8LE-NEXT:    add r3, r3, r4
; P8LE-NEXT:    lwz r4, 16(r3)
; P8LE-NEXT:    lwz r5, 4(r3)
; P8LE-NEXT:    lwz r6, 8(r3)
; P8LE-NEXT:    lwz r3, 32(r3)
; P8LE-NEXT:    rldimi r4, r5, 32, 0
; P8LE-NEXT:    rldimi r6, r3, 32, 0
; P8LE-NEXT:    mtfprd f0, r4
; P8LE-NEXT:    mtfprd f1, r6
; P8LE-NEXT:    xxmrghd v2, vs1, vs0
; P8LE-NEXT:    blr
entry:
  %add = add nsw i32 %elem, 4
  %idxprom = sext i32 %add to i64
  %arrayidx = getelementptr inbounds i32, ptr %arr, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  %vecinit = insertelement <4 x i32> undef, i32 %0, i32 0
  %add1 = add nsw i32 %elem, 1
  %idxprom2 = sext i32 %add1 to i64
  %arrayidx3 = getelementptr inbounds i32, ptr %arr, i64 %idxprom2
  %1 = load i32, ptr %arrayidx3, align 4
  %vecinit4 = insertelement <4 x i32> %vecinit, i32 %1, i32 1
  %add5 = add nsw i32 %elem, 2
  %idxprom6 = sext i32 %add5 to i64
  %arrayidx7 = getelementptr inbounds i32, ptr %arr, i64 %idxprom6
  %2 = load i32, ptr %arrayidx7, align 4
  %vecinit8 = insertelement <4 x i32> %vecinit4, i32 %2, i32 2
  %add9 = add nsw i32 %elem, 8
  %idxprom10 = sext i32 %add9 to i64
  %arrayidx11 = getelementptr inbounds i32, ptr %arr, i64 %idxprom10
  %3 = load i32, ptr %arrayidx11, align 4
  %vecinit12 = insertelement <4 x i32> %vecinit8, i32 %3, i32 3
  ret <4 x i32> %vecinit12
}

define <4 x i32> @spltRegValui(i32 zeroext %val) {
; P9BE-LABEL: spltRegValui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    mtvsrws v2, r3
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltRegValui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    mtvsrws v2, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltRegValui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    mtfprwz f0, r3
; P8BE-NEXT:    xxspltw v2, vs0, 1
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltRegValui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    mtfprwz f0, r3
; P8LE-NEXT:    xxspltw v2, vs0, 1
; P8LE-NEXT:    blr
entry:
  %splat.splatinsert = insertelement <4 x i32> undef, i32 %val, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> undef, <4 x i32> zeroinitializer
  ret <4 x i32> %splat.splat
}

define <4 x i32> @spltMemValui(ptr nocapture readonly %ptr) {
; P9BE-LABEL: spltMemValui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxvwsx v2, 0, r3
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltMemValui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxvwsx v2, 0, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltMemValui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lfiwzx f0, 0, r3
; P8BE-NEXT:    xxspltw v2, vs0, 1
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltMemValui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lfiwzx f0, 0, r3
; P8LE-NEXT:    xxspltw v2, vs0, 1
; P8LE-NEXT:    blr
entry:
  %0 = load i32, ptr %ptr, align 4
  %splat.splatinsert = insertelement <4 x i32> undef, i32 %0, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> undef, <4 x i32> zeroinitializer
  ret <4 x i32> %splat.splat
}

define <4 x i32> @spltCnstConvftoui() {
; P9BE-LABEL: spltCnstConvftoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    vspltisw v2, 4
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltCnstConvftoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    vspltisw v2, 4
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltCnstConvftoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    vspltisw v2, 4
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltCnstConvftoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    vspltisw v2, 4
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> <i32 4, i32 4, i32 4, i32 4>
}

define <4 x i32> @fromRegsConvftoui(float %a, float %b, float %c, float %d) {
; P9BE-LABEL: fromRegsConvftoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxmrghd vs0, vs2, vs4
; P9BE-NEXT:    xvcvdpuxws v2, vs0
; P9BE-NEXT:    xxmrghd vs0, vs1, vs3
; P9BE-NEXT:    xvcvdpuxws v3, vs0
; P9BE-NEXT:    vmrgew v2, v3, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRegsConvftoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxmrghd vs0, vs3, vs1
; P9LE-NEXT:    xvcvdpuxws v2, vs0
; P9LE-NEXT:    xxmrghd vs0, vs4, vs2
; P9LE-NEXT:    xvcvdpuxws v3, vs0
; P9LE-NEXT:    vmrgew v2, v3, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRegsConvftoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxmrghd vs0, vs2, vs4
; P8BE-NEXT:    xxmrghd vs1, vs1, vs3
; P8BE-NEXT:    xvcvdpuxws v2, vs0
; P8BE-NEXT:    xvcvdpuxws v3, vs1
; P8BE-NEXT:    vmrgew v2, v3, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRegsConvftoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxmrghd vs0, vs3, vs1
; P8LE-NEXT:    xxmrghd vs1, vs4, vs2
; P8LE-NEXT:    xvcvdpuxws v2, vs0
; P8LE-NEXT:    xvcvdpuxws v3, vs1
; P8LE-NEXT:    vmrgew v2, v3, v2
; P8LE-NEXT:    blr
entry:
  %conv = fptoui float %a to i32
  %vecinit = insertelement <4 x i32> undef, i32 %conv, i32 0
  %conv1 = fptoui float %b to i32
  %vecinit2 = insertelement <4 x i32> %vecinit, i32 %conv1, i32 1
  %conv3 = fptoui float %c to i32
  %vecinit4 = insertelement <4 x i32> %vecinit2, i32 %conv3, i32 2
  %conv5 = fptoui float %d to i32
  %vecinit6 = insertelement <4 x i32> %vecinit4, i32 %conv5, i32 3
  ret <4 x i32> %vecinit6
}

define <4 x i32> @fromDiffConstsConvftoui() {
; P9BE-LABEL: fromDiffConstsConvftoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    addis r3, r2, .LCPI48_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI48_0@toc@l
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffConstsConvftoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addis r3, r2, .LCPI48_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI48_0@toc@l
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffConstsConvftoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addis r3, r2, .LCPI48_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI48_0@toc@l
; P8BE-NEXT:    lxvw4x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffConstsConvftoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r3, r2, .LCPI48_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI48_0@toc@l
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> <i32 24, i32 234, i32 988, i32 422>
}

define <4 x i32> @fromDiffMemConsAConvftoui(ptr nocapture readonly %ptr) {
; P9BE-LABEL: fromDiffMemConsAConvftoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv vs0, 0(r3)
; P9BE-NEXT:    xvcvspuxws v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsAConvftoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxv vs0, 0(r3)
; P9LE-NEXT:    xvcvspuxws v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsAConvftoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lxvw4x vs0, 0, r3
; P8BE-NEXT:    xvcvspuxws v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsAConvftoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    xvcvspuxws v2, v2
; P8LE-NEXT:    blr
entry:
  %0 = load <4 x float>, ptr %ptr, align 4
  %1 = fptoui <4 x float> %0 to <4 x i32>
  ret <4 x i32> %1
}

define <4 x i32> @fromDiffMemConsDConvftoui(ptr nocapture readonly %ptr) {
; P9BE-LABEL: fromDiffMemConsDConvftoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv vs0, 0(r3)
; P9BE-NEXT:    addis r3, r2, .LCPI50_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI50_0@toc@l
; P9BE-NEXT:    lxv vs1, 0(r3)
; P9BE-NEXT:    xxperm vs0, vs0, vs1
; P9BE-NEXT:    xvcvspuxws v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsDConvftoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxv vs0, 0(r3)
; P9LE-NEXT:    addis r3, r2, .LCPI50_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI50_0@toc@l
; P9LE-NEXT:    lxv vs1, 0(r3)
; P9LE-NEXT:    xxperm vs0, vs0, vs1
; P9LE-NEXT:    xvcvspuxws v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsDConvftoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lxvw4x v2, 0, r3
; P8BE-NEXT:    addis r3, r2, .LCPI50_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI50_0@toc@l
; P8BE-NEXT:    lxvw4x v3, 0, r3
; P8BE-NEXT:    vperm v2, v2, v2, v3
; P8BE-NEXT:    xvcvspuxws v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsDConvftoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r4, r2, .LCPI50_0@toc@ha
; P8LE-NEXT:    lxvd2x v3, 0, r3
; P8LE-NEXT:    addi r4, r4, .LCPI50_0@toc@l
; P8LE-NEXT:    lxvd2x vs0, 0, r4
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    vperm v2, v3, v3, v2
; P8LE-NEXT:    xvcvspuxws v2, v2
; P8LE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds float, ptr %ptr, i64 3
  %0 = load float, ptr %arrayidx, align 4
  %conv = fptoui float %0 to i32
  %vecinit = insertelement <4 x i32> undef, i32 %conv, i32 0
  %arrayidx1 = getelementptr inbounds float, ptr %ptr, i64 2
  %1 = load float, ptr %arrayidx1, align 4
  %conv2 = fptoui float %1 to i32
  %vecinit3 = insertelement <4 x i32> %vecinit, i32 %conv2, i32 1
  %arrayidx4 = getelementptr inbounds float, ptr %ptr, i64 1
  %2 = load float, ptr %arrayidx4, align 4
  %conv5 = fptoui float %2 to i32
  %vecinit6 = insertelement <4 x i32> %vecinit3, i32 %conv5, i32 2
  %3 = load float, ptr %ptr, align 4
  %conv8 = fptoui float %3 to i32
  %vecinit9 = insertelement <4 x i32> %vecinit6, i32 %conv8, i32 3
  ret <4 x i32> %vecinit9
}

define <4 x i32> @fromDiffMemVarAConvftoui(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarAConvftoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 2
; P9BE-NEXT:    lfsux f0, r3, r4
; P9BE-NEXT:    lfs f1, 12(r3)
; P9BE-NEXT:    lfs f2, 4(r3)
; P9BE-NEXT:    xxmrghd vs1, vs2, vs1
; P9BE-NEXT:    xvcvdpsp v2, vs1
; P9BE-NEXT:    lfs f1, 8(r3)
; P9BE-NEXT:    xxmrghd vs0, vs0, vs1
; P9BE-NEXT:    xvcvdpsp v3, vs0
; P9BE-NEXT:    vmrgew v2, v3, v2
; P9BE-NEXT:    xvcvspuxws v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarAConvftoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 2
; P9LE-NEXT:    lfsux f0, r3, r4
; P9LE-NEXT:    lfs f1, 8(r3)
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    lfs f1, 12(r3)
; P9LE-NEXT:    xvcvdpsp v2, vs0
; P9LE-NEXT:    lfs f0, 4(r3)
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    xvcvdpsp v3, vs0
; P9LE-NEXT:    vmrgew v2, v3, v2
; P9LE-NEXT:    xvcvspuxws v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarAConvftoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 2
; P8BE-NEXT:    lfsux f0, r3, r4
; P8BE-NEXT:    lfs f1, 12(r3)
; P8BE-NEXT:    lfs f2, 4(r3)
; P8BE-NEXT:    xxmrghd vs1, vs2, vs1
; P8BE-NEXT:    lfs f2, 8(r3)
; P8BE-NEXT:    xvcvdpsp v2, vs1
; P8BE-NEXT:    xxmrghd vs0, vs0, vs2
; P8BE-NEXT:    xvcvdpsp v3, vs0
; P8BE-NEXT:    vmrgew v2, v3, v2
; P8BE-NEXT:    xvcvspuxws v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarAConvftoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 2
; P8LE-NEXT:    lfsux f0, r3, r4
; P8LE-NEXT:    lfs f1, 8(r3)
; P8LE-NEXT:    xxmrghd vs0, vs1, vs0
; P8LE-NEXT:    lfs f1, 4(r3)
; P8LE-NEXT:    lfs f2, 12(r3)
; P8LE-NEXT:    xvcvdpsp v2, vs0
; P8LE-NEXT:    xxmrghd vs1, vs2, vs1
; P8LE-NEXT:    xvcvdpsp v3, vs1
; P8LE-NEXT:    vmrgew v2, v3, v2
; P8LE-NEXT:    xvcvspuxws v2, v2
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds float, ptr %arr, i64 %idxprom
  %0 = load float, ptr %arrayidx, align 4
  %conv = fptoui float %0 to i32
  %vecinit = insertelement <4 x i32> undef, i32 %conv, i32 0
  %add = add nsw i32 %elem, 1
  %idxprom1 = sext i32 %add to i64
  %arrayidx2 = getelementptr inbounds float, ptr %arr, i64 %idxprom1
  %1 = load float, ptr %arrayidx2, align 4
  %conv3 = fptoui float %1 to i32
  %vecinit4 = insertelement <4 x i32> %vecinit, i32 %conv3, i32 1
  %add5 = add nsw i32 %elem, 2
  %idxprom6 = sext i32 %add5 to i64
  %arrayidx7 = getelementptr inbounds float, ptr %arr, i64 %idxprom6
  %2 = load float, ptr %arrayidx7, align 4
  %conv8 = fptoui float %2 to i32
  %vecinit9 = insertelement <4 x i32> %vecinit4, i32 %conv8, i32 2
  %add10 = add nsw i32 %elem, 3
  %idxprom11 = sext i32 %add10 to i64
  %arrayidx12 = getelementptr inbounds float, ptr %arr, i64 %idxprom11
  %3 = load float, ptr %arrayidx12, align 4
  %conv13 = fptoui float %3 to i32
  %vecinit14 = insertelement <4 x i32> %vecinit9, i32 %conv13, i32 3
  ret <4 x i32> %vecinit14
; FIXME: implement finding consecutive loads with pre-inc
}

define <4 x i32> @fromDiffMemVarDConvftoui(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarDConvftoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 2
; P9BE-NEXT:    lfsux f0, r3, r4
; P9BE-NEXT:    lfs f1, -12(r3)
; P9BE-NEXT:    lfs f2, -4(r3)
; P9BE-NEXT:    xxmrghd vs1, vs2, vs1
; P9BE-NEXT:    xvcvdpsp v2, vs1
; P9BE-NEXT:    lfs f1, -8(r3)
; P9BE-NEXT:    xxmrghd vs0, vs0, vs1
; P9BE-NEXT:    xvcvdpsp v3, vs0
; P9BE-NEXT:    vmrgew v2, v3, v2
; P9BE-NEXT:    xvcvspuxws v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarDConvftoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 2
; P9LE-NEXT:    lfsux f0, r3, r4
; P9LE-NEXT:    lfs f1, -8(r3)
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    lfs f1, -12(r3)
; P9LE-NEXT:    xvcvdpsp v2, vs0
; P9LE-NEXT:    lfs f0, -4(r3)
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    xvcvdpsp v3, vs0
; P9LE-NEXT:    vmrgew v2, v3, v2
; P9LE-NEXT:    xvcvspuxws v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarDConvftoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 2
; P8BE-NEXT:    lfsux f0, r3, r4
; P8BE-NEXT:    lfs f1, -12(r3)
; P8BE-NEXT:    lfs f2, -4(r3)
; P8BE-NEXT:    xxmrghd vs1, vs2, vs1
; P8BE-NEXT:    lfs f2, -8(r3)
; P8BE-NEXT:    xvcvdpsp v2, vs1
; P8BE-NEXT:    xxmrghd vs0, vs0, vs2
; P8BE-NEXT:    xvcvdpsp v3, vs0
; P8BE-NEXT:    vmrgew v2, v3, v2
; P8BE-NEXT:    xvcvspuxws v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarDConvftoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 2
; P8LE-NEXT:    lfsux f0, r3, r4
; P8LE-NEXT:    lfs f1, -8(r3)
; P8LE-NEXT:    xxmrghd vs0, vs1, vs0
; P8LE-NEXT:    lfs f1, -4(r3)
; P8LE-NEXT:    lfs f2, -12(r3)
; P8LE-NEXT:    xvcvdpsp v2, vs0
; P8LE-NEXT:    xxmrghd vs1, vs2, vs1
; P8LE-NEXT:    xvcvdpsp v3, vs1
; P8LE-NEXT:    vmrgew v2, v3, v2
; P8LE-NEXT:    xvcvspuxws v2, v2
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds float, ptr %arr, i64 %idxprom
  %0 = load float, ptr %arrayidx, align 4
  %conv = fptoui float %0 to i32
  %vecinit = insertelement <4 x i32> undef, i32 %conv, i32 0
  %sub = add nsw i32 %elem, -1
  %idxprom1 = sext i32 %sub to i64
  %arrayidx2 = getelementptr inbounds float, ptr %arr, i64 %idxprom1
  %1 = load float, ptr %arrayidx2, align 4
  %conv3 = fptoui float %1 to i32
  %vecinit4 = insertelement <4 x i32> %vecinit, i32 %conv3, i32 1
  %sub5 = add nsw i32 %elem, -2
  %idxprom6 = sext i32 %sub5 to i64
  %arrayidx7 = getelementptr inbounds float, ptr %arr, i64 %idxprom6
  %2 = load float, ptr %arrayidx7, align 4
  %conv8 = fptoui float %2 to i32
  %vecinit9 = insertelement <4 x i32> %vecinit4, i32 %conv8, i32 2
  %sub10 = add nsw i32 %elem, -3
  %idxprom11 = sext i32 %sub10 to i64
  %arrayidx12 = getelementptr inbounds float, ptr %arr, i64 %idxprom11
  %3 = load float, ptr %arrayidx12, align 4
  %conv13 = fptoui float %3 to i32
  %vecinit14 = insertelement <4 x i32> %vecinit9, i32 %conv13, i32 3
  ret <4 x i32> %vecinit14
; FIXME: implement finding consecutive loads with pre-inc
}

define <4 x i32> @spltRegValConvftoui(float %val) {
; P9BE-LABEL: spltRegValConvftoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xscvdpuxws f0, f1
; P9BE-NEXT:    xxspltw v2, vs0, 1
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltRegValConvftoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xscvdpuxws f0, f1
; P9LE-NEXT:    xxspltw v2, vs0, 1
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltRegValConvftoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xscvdpuxws f0, f1
; P8BE-NEXT:    xxspltw v2, vs0, 1
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltRegValConvftoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xscvdpuxws f0, f1
; P8LE-NEXT:    xxspltw v2, vs0, 1
; P8LE-NEXT:    blr
entry:
  %conv = fptoui float %val to i32
  %splat.splatinsert = insertelement <4 x i32> undef, i32 %conv, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> undef, <4 x i32> zeroinitializer
  ret <4 x i32> %splat.splat
}

define <4 x i32> @spltMemValConvftoui(ptr nocapture readonly %ptr) {
; P9BE-LABEL: spltMemValConvftoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lfiwzx f0, 0, r3
; P9BE-NEXT:    xvcvspuxws vs0, vs0
; P9BE-NEXT:    xxspltw v2, vs0, 1
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltMemValConvftoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lfiwzx f0, 0, r3
; P9LE-NEXT:    xvcvspuxws vs0, vs0
; P9LE-NEXT:    xxspltw v2, vs0, 1
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltMemValConvftoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lfsx f0, 0, r3
; P8BE-NEXT:    xscvdpuxws f0, f0
; P8BE-NEXT:    xxspltw v2, vs0, 1
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltMemValConvftoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lfsx f0, 0, r3
; P8LE-NEXT:    xscvdpuxws f0, f0
; P8LE-NEXT:    xxspltw v2, vs0, 1
; P8LE-NEXT:    blr
entry:
  %0 = load float, ptr %ptr, align 4
  %conv = fptoui float %0 to i32
  %splat.splatinsert = insertelement <4 x i32> undef, i32 %conv, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> undef, <4 x i32> zeroinitializer
  ret <4 x i32> %splat.splat
}

define <4 x i32> @spltCnstConvdtoui() {
; P9BE-LABEL: spltCnstConvdtoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    vspltisw v2, 4
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltCnstConvdtoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    vspltisw v2, 4
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltCnstConvdtoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    vspltisw v2, 4
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltCnstConvdtoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    vspltisw v2, 4
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> <i32 4, i32 4, i32 4, i32 4>
}

define <4 x i32> @fromRegsConvdtoui(double %a, double %b, double %c, double %d) {
; P9BE-LABEL: fromRegsConvdtoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxmrghd vs0, vs2, vs4
; P9BE-NEXT:    xvcvdpuxws v2, vs0
; P9BE-NEXT:    xxmrghd vs0, vs1, vs3
; P9BE-NEXT:    xvcvdpuxws v3, vs0
; P9BE-NEXT:    vmrgew v2, v3, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRegsConvdtoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxmrghd vs0, vs3, vs1
; P9LE-NEXT:    xvcvdpuxws v2, vs0
; P9LE-NEXT:    xxmrghd vs0, vs4, vs2
; P9LE-NEXT:    xvcvdpuxws v3, vs0
; P9LE-NEXT:    vmrgew v2, v3, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRegsConvdtoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxmrghd vs0, vs2, vs4
; P8BE-NEXT:    xxmrghd vs1, vs1, vs3
; P8BE-NEXT:    xvcvdpuxws v2, vs0
; P8BE-NEXT:    xvcvdpuxws v3, vs1
; P8BE-NEXT:    vmrgew v2, v3, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRegsConvdtoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxmrghd vs0, vs3, vs1
; P8LE-NEXT:    xxmrghd vs1, vs4, vs2
; P8LE-NEXT:    xvcvdpuxws v2, vs0
; P8LE-NEXT:    xvcvdpuxws v3, vs1
; P8LE-NEXT:    vmrgew v2, v3, v2
; P8LE-NEXT:    blr
entry:
  %conv = fptoui double %a to i32
  %vecinit = insertelement <4 x i32> undef, i32 %conv, i32 0
  %conv1 = fptoui double %b to i32
  %vecinit2 = insertelement <4 x i32> %vecinit, i32 %conv1, i32 1
  %conv3 = fptoui double %c to i32
  %vecinit4 = insertelement <4 x i32> %vecinit2, i32 %conv3, i32 2
  %conv5 = fptoui double %d to i32
  %vecinit6 = insertelement <4 x i32> %vecinit4, i32 %conv5, i32 3
  ret <4 x i32> %vecinit6
}

define <4 x i32> @fromDiffConstsConvdtoui() {
; P9BE-LABEL: fromDiffConstsConvdtoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    addis r3, r2, .LCPI57_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI57_0@toc@l
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffConstsConvdtoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addis r3, r2, .LCPI57_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI57_0@toc@l
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffConstsConvdtoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addis r3, r2, .LCPI57_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI57_0@toc@l
; P8BE-NEXT:    lxvw4x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffConstsConvdtoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r3, r2, .LCPI57_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI57_0@toc@l
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  ret <4 x i32> <i32 24, i32 234, i32 988, i32 422>
}

define <4 x i32> @fromDiffMemConsAConvdtoui(ptr nocapture readonly %ptr) {
; P9BE-LABEL: fromDiffMemConsAConvdtoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv vs0, 0(r3)
; P9BE-NEXT:    lxv vs1, 16(r3)
; P9BE-NEXT:    xxmrgld vs2, vs0, vs1
; P9BE-NEXT:    xxmrghd vs0, vs0, vs1
; P9BE-NEXT:    xvcvdpuxws v2, vs2
; P9BE-NEXT:    xvcvdpuxws v3, vs0
; P9BE-NEXT:    vmrgew v2, v3, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsAConvdtoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxv vs0, 0(r3)
; P9LE-NEXT:    lxv vs1, 16(r3)
; P9LE-NEXT:    xxmrgld vs2, vs1, vs0
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    xvcvdpuxws v2, vs2
; P9LE-NEXT:    xvcvdpuxws v3, vs0
; P9LE-NEXT:    vmrgew v2, v3, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsAConvdtoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    li r4, 16
; P8BE-NEXT:    lxvd2x vs0, 0, r3
; P8BE-NEXT:    lxvd2x vs1, r3, r4
; P8BE-NEXT:    xxmrgld vs2, vs0, vs1
; P8BE-NEXT:    xxmrghd vs0, vs0, vs1
; P8BE-NEXT:    xvcvdpuxws v2, vs2
; P8BE-NEXT:    xvcvdpuxws v3, vs0
; P8BE-NEXT:    vmrgew v2, v3, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsAConvdtoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    li r4, 16
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    lxvd2x vs1, r3, r4
; P8LE-NEXT:    xxswapd vs0, vs0
; P8LE-NEXT:    xxswapd vs1, vs1
; P8LE-NEXT:    xxmrgld vs2, vs1, vs0
; P8LE-NEXT:    xxmrghd vs0, vs1, vs0
; P8LE-NEXT:    xvcvdpuxws v2, vs2
; P8LE-NEXT:    xvcvdpuxws v3, vs0
; P8LE-NEXT:    vmrgew v2, v3, v2
; P8LE-NEXT:    blr
entry:
  %0 = load <2 x double>, ptr %ptr, align 8
  %1 = fptoui <2 x double> %0 to <2 x i32>
  %arrayidx4 = getelementptr inbounds double, ptr %ptr, i64 2
  %2 = load <2 x double>, ptr %arrayidx4, align 8
  %3 = fptoui <2 x double> %2 to <2 x i32>
  %vecinit9 = shufflevector <2 x i32> %1, <2 x i32> %3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i32> %vecinit9
}

define <4 x i32> @fromDiffMemConsDConvdtoui(ptr nocapture readonly %ptr) {
; P9BE-LABEL: fromDiffMemConsDConvdtoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lfd f0, 24(r3)
; P9BE-NEXT:    lfd f1, 16(r3)
; P9BE-NEXT:    lfd f2, 8(r3)
; P9BE-NEXT:    xxmrghd vs0, vs0, vs2
; P9BE-NEXT:    lfd f3, 0(r3)
; P9BE-NEXT:    xxmrghd vs1, vs1, vs3
; P9BE-NEXT:    xvcvdpuxws v2, vs1
; P9BE-NEXT:    xvcvdpuxws v3, vs0
; P9BE-NEXT:    vmrgew v2, v3, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsDConvdtoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lfd f0, 24(r3)
; P9LE-NEXT:    lfd f2, 8(r3)
; P9LE-NEXT:    xxmrghd vs0, vs2, vs0
; P9LE-NEXT:    lfd f1, 16(r3)
; P9LE-NEXT:    lfd f3, 0(r3)
; P9LE-NEXT:    xvcvdpuxws v2, vs0
; P9LE-NEXT:    xxmrghd vs0, vs3, vs1
; P9LE-NEXT:    xvcvdpuxws v3, vs0
; P9LE-NEXT:    vmrgew v2, v3, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsDConvdtoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lfd f0, 24(r3)
; P8BE-NEXT:    lfd f1, 16(r3)
; P8BE-NEXT:    lfd f2, 8(r3)
; P8BE-NEXT:    lfd f3, 0(r3)
; P8BE-NEXT:    xxmrghd vs1, vs1, vs3
; P8BE-NEXT:    xxmrghd vs0, vs0, vs2
; P8BE-NEXT:    xvcvdpuxws v2, vs1
; P8BE-NEXT:    xvcvdpuxws v3, vs0
; P8BE-NEXT:    vmrgew v2, v3, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsDConvdtoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lfd f0, 24(r3)
; P8LE-NEXT:    lfd f1, 16(r3)
; P8LE-NEXT:    lfd f2, 8(r3)
; P8LE-NEXT:    lfd f3, 0(r3)
; P8LE-NEXT:    xxmrghd vs0, vs2, vs0
; P8LE-NEXT:    xxmrghd vs1, vs3, vs1
; P8LE-NEXT:    xvcvdpuxws v2, vs0
; P8LE-NEXT:    xvcvdpuxws v3, vs1
; P8LE-NEXT:    vmrgew v2, v3, v2
; P8LE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds double, ptr %ptr, i64 3
  %0 = load double, ptr %arrayidx, align 8
  %conv = fptoui double %0 to i32
  %vecinit = insertelement <4 x i32> undef, i32 %conv, i32 0
  %arrayidx1 = getelementptr inbounds double, ptr %ptr, i64 2
  %1 = load double, ptr %arrayidx1, align 8
  %conv2 = fptoui double %1 to i32
  %vecinit3 = insertelement <4 x i32> %vecinit, i32 %conv2, i32 1
  %arrayidx4 = getelementptr inbounds double, ptr %ptr, i64 1
  %2 = load double, ptr %arrayidx4, align 8
  %conv5 = fptoui double %2 to i32
  %vecinit6 = insertelement <4 x i32> %vecinit3, i32 %conv5, i32 2
  %3 = load double, ptr %ptr, align 8
  %conv8 = fptoui double %3 to i32
  %vecinit9 = insertelement <4 x i32> %vecinit6, i32 %conv8, i32 3
  ret <4 x i32> %vecinit9
}

define <4 x i32> @fromDiffMemVarAConvdtoui(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarAConvdtoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 3
; P9BE-NEXT:    lfdux f0, r3, r4
; P9BE-NEXT:    lfd f1, 8(r3)
; P9BE-NEXT:    lfd f2, 16(r3)
; P9BE-NEXT:    lfd f3, 24(r3)
; P9BE-NEXT:    xxmrghd vs1, vs1, vs3
; P9BE-NEXT:    xxmrghd vs0, vs0, vs2
; P9BE-NEXT:    xvcvdpuxws v2, vs1
; P9BE-NEXT:    xvcvdpuxws v3, vs0
; P9BE-NEXT:    vmrgew v2, v3, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarAConvdtoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 3
; P9LE-NEXT:    lfdux f0, r3, r4
; P9LE-NEXT:    lfd f2, 16(r3)
; P9LE-NEXT:    lfd f1, 8(r3)
; P9LE-NEXT:    lfd f3, 24(r3)
; P9LE-NEXT:    xxmrghd vs0, vs2, vs0
; P9LE-NEXT:    xvcvdpuxws v2, vs0
; P9LE-NEXT:    xxmrghd vs0, vs3, vs1
; P9LE-NEXT:    xvcvdpuxws v3, vs0
; P9LE-NEXT:    vmrgew v2, v3, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarAConvdtoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 3
; P8BE-NEXT:    lfdux f0, r3, r4
; P8BE-NEXT:    lfd f1, 8(r3)
; P8BE-NEXT:    lfd f2, 16(r3)
; P8BE-NEXT:    lfd f3, 24(r3)
; P8BE-NEXT:    xxmrghd vs1, vs1, vs3
; P8BE-NEXT:    xxmrghd vs0, vs0, vs2
; P8BE-NEXT:    xvcvdpuxws v2, vs1
; P8BE-NEXT:    xvcvdpuxws v3, vs0
; P8BE-NEXT:    vmrgew v2, v3, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarAConvdtoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 3
; P8LE-NEXT:    lfdux f0, r3, r4
; P8LE-NEXT:    lfd f1, 8(r3)
; P8LE-NEXT:    lfd f2, 16(r3)
; P8LE-NEXT:    lfd f3, 24(r3)
; P8LE-NEXT:    xxmrghd vs0, vs2, vs0
; P8LE-NEXT:    xxmrghd vs1, vs3, vs1
; P8LE-NEXT:    xvcvdpuxws v2, vs0
; P8LE-NEXT:    xvcvdpuxws v3, vs1
; P8LE-NEXT:    vmrgew v2, v3, v2
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds double, ptr %arr, i64 %idxprom
  %0 = load double, ptr %arrayidx, align 8
  %conv = fptoui double %0 to i32
  %vecinit = insertelement <4 x i32> undef, i32 %conv, i32 0
  %add = add nsw i32 %elem, 1
  %idxprom1 = sext i32 %add to i64
  %arrayidx2 = getelementptr inbounds double, ptr %arr, i64 %idxprom1
  %1 = load double, ptr %arrayidx2, align 8
  %conv3 = fptoui double %1 to i32
  %vecinit4 = insertelement <4 x i32> %vecinit, i32 %conv3, i32 1
  %add5 = add nsw i32 %elem, 2
  %idxprom6 = sext i32 %add5 to i64
  %arrayidx7 = getelementptr inbounds double, ptr %arr, i64 %idxprom6
  %2 = load double, ptr %arrayidx7, align 8
  %conv8 = fptoui double %2 to i32
  %vecinit9 = insertelement <4 x i32> %vecinit4, i32 %conv8, i32 2
  %add10 = add nsw i32 %elem, 3
  %idxprom11 = sext i32 %add10 to i64
  %arrayidx12 = getelementptr inbounds double, ptr %arr, i64 %idxprom11
  %3 = load double, ptr %arrayidx12, align 8
  %conv13 = fptoui double %3 to i32
  %vecinit14 = insertelement <4 x i32> %vecinit9, i32 %conv13, i32 3
  ret <4 x i32> %vecinit14
}

define <4 x i32> @fromDiffMemVarDConvdtoui(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarDConvdtoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 3
; P9BE-NEXT:    lfdux f0, r3, r4
; P9BE-NEXT:    lfd f1, -8(r3)
; P9BE-NEXT:    lfd f2, -16(r3)
; P9BE-NEXT:    lfd f3, -24(r3)
; P9BE-NEXT:    xxmrghd vs1, vs1, vs3
; P9BE-NEXT:    xxmrghd vs0, vs0, vs2
; P9BE-NEXT:    xvcvdpuxws v2, vs1
; P9BE-NEXT:    xvcvdpuxws v3, vs0
; P9BE-NEXT:    vmrgew v2, v3, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarDConvdtoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 3
; P9LE-NEXT:    lfdux f0, r3, r4
; P9LE-NEXT:    lfd f2, -16(r3)
; P9LE-NEXT:    lfd f1, -8(r3)
; P9LE-NEXT:    lfd f3, -24(r3)
; P9LE-NEXT:    xxmrghd vs0, vs2, vs0
; P9LE-NEXT:    xvcvdpuxws v2, vs0
; P9LE-NEXT:    xxmrghd vs0, vs3, vs1
; P9LE-NEXT:    xvcvdpuxws v3, vs0
; P9LE-NEXT:    vmrgew v2, v3, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarDConvdtoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 3
; P8BE-NEXT:    lfdux f0, r3, r4
; P8BE-NEXT:    lfd f1, -8(r3)
; P8BE-NEXT:    lfd f2, -16(r3)
; P8BE-NEXT:    lfd f3, -24(r3)
; P8BE-NEXT:    xxmrghd vs1, vs1, vs3
; P8BE-NEXT:    xxmrghd vs0, vs0, vs2
; P8BE-NEXT:    xvcvdpuxws v2, vs1
; P8BE-NEXT:    xvcvdpuxws v3, vs0
; P8BE-NEXT:    vmrgew v2, v3, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarDConvdtoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 3
; P8LE-NEXT:    lfdux f0, r3, r4
; P8LE-NEXT:    lfd f1, -8(r3)
; P8LE-NEXT:    lfd f2, -16(r3)
; P8LE-NEXT:    lfd f3, -24(r3)
; P8LE-NEXT:    xxmrghd vs0, vs2, vs0
; P8LE-NEXT:    xxmrghd vs1, vs3, vs1
; P8LE-NEXT:    xvcvdpuxws v2, vs0
; P8LE-NEXT:    xvcvdpuxws v3, vs1
; P8LE-NEXT:    vmrgew v2, v3, v2
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds double, ptr %arr, i64 %idxprom
  %0 = load double, ptr %arrayidx, align 8
  %conv = fptoui double %0 to i32
  %vecinit = insertelement <4 x i32> undef, i32 %conv, i32 0
  %sub = add nsw i32 %elem, -1
  %idxprom1 = sext i32 %sub to i64
  %arrayidx2 = getelementptr inbounds double, ptr %arr, i64 %idxprom1
  %1 = load double, ptr %arrayidx2, align 8
  %conv3 = fptoui double %1 to i32
  %vecinit4 = insertelement <4 x i32> %vecinit, i32 %conv3, i32 1
  %sub5 = add nsw i32 %elem, -2
  %idxprom6 = sext i32 %sub5 to i64
  %arrayidx7 = getelementptr inbounds double, ptr %arr, i64 %idxprom6
  %2 = load double, ptr %arrayidx7, align 8
  %conv8 = fptoui double %2 to i32
  %vecinit9 = insertelement <4 x i32> %vecinit4, i32 %conv8, i32 2
  %sub10 = add nsw i32 %elem, -3
  %idxprom11 = sext i32 %sub10 to i64
  %arrayidx12 = getelementptr inbounds double, ptr %arr, i64 %idxprom11
  %3 = load double, ptr %arrayidx12, align 8
  %conv13 = fptoui double %3 to i32
  %vecinit14 = insertelement <4 x i32> %vecinit9, i32 %conv13, i32 3
  ret <4 x i32> %vecinit14
}

define <4 x i32> @spltRegValConvdtoui(double %val) {
; P9BE-LABEL: spltRegValConvdtoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xscvdpuxws f0, f1
; P9BE-NEXT:    xxspltw v2, vs0, 1
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltRegValConvdtoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xscvdpuxws f0, f1
; P9LE-NEXT:    xxspltw v2, vs0, 1
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltRegValConvdtoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xscvdpuxws f0, f1
; P8BE-NEXT:    xxspltw v2, vs0, 1
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltRegValConvdtoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xscvdpuxws f0, f1
; P8LE-NEXT:    xxspltw v2, vs0, 1
; P8LE-NEXT:    blr
entry:
  %conv = fptoui double %val to i32
  %splat.splatinsert = insertelement <4 x i32> undef, i32 %conv, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> undef, <4 x i32> zeroinitializer
  ret <4 x i32> %splat.splat
}

define <4 x i32> @spltMemValConvdtoui(ptr nocapture readonly %ptr) {
; P9BE-LABEL: spltMemValConvdtoui:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lfd f0, 0(r3)
; P9BE-NEXT:    xscvdpuxws f0, f0
; P9BE-NEXT:    xxspltw v2, vs0, 1
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltMemValConvdtoui:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lfd f0, 0(r3)
; P9LE-NEXT:    xscvdpuxws f0, f0
; P9LE-NEXT:    xxspltw v2, vs0, 1
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltMemValConvdtoui:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lfdx f0, 0, r3
; P8BE-NEXT:    xscvdpuxws f0, f0
; P8BE-NEXT:    xxspltw v2, vs0, 1
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltMemValConvdtoui:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lfdx f0, 0, r3
; P8LE-NEXT:    xscvdpuxws f0, f0
; P8LE-NEXT:    xxspltw v2, vs0, 1
; P8LE-NEXT:    blr
entry:
  %0 = load double, ptr %ptr, align 8
  %conv = fptoui double %0 to i32
  %splat.splatinsert = insertelement <4 x i32> undef, i32 %conv, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> undef, <4 x i32> zeroinitializer
  ret <4 x i32> %splat.splat
}

define <2 x i64> @allZeroll() {
; P9BE-LABEL: allZeroll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxlxor v2, v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: allZeroll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxlxor v2, v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: allZeroll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxlxor v2, v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: allZeroll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxlxor v2, v2, v2
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> zeroinitializer
}

define <2 x i64> @spltConst1ll() {
; P9BE-LABEL: spltConst1ll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    vspltisw v2, 1
; P9BE-NEXT:    vupklsw v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltConst1ll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    vspltisw v2, 1
; P9LE-NEXT:    vupklsw v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltConst1ll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    vspltisw v2, 1
; P8BE-NEXT:    vupklsw v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltConst1ll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    vspltisw v2, 1
; P8LE-NEXT:    vupklsw v2, v2
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> <i64 1, i64 1>
}

define <2 x i64> @spltConst16kll() {
; P9BE-LABEL: spltConst16kll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    addis r3, r2, .LCPI66_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI66_0@toc@l
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltConst16kll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addis r3, r2, .LCPI66_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI66_0@toc@l
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltConst16kll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addis r3, r2, .LCPI66_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI66_0@toc@l
; P8BE-NEXT:    lxvd2x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltConst16kll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r3, r2, .LCPI66_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI66_0@toc@l
; P8LE-NEXT:    lxvd2x v2, 0, r3
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> <i64 32767, i64 32767>
}

define <2 x i64> @spltConst32kll() {
; P9BE-LABEL: spltConst32kll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    addis r3, r2, .LCPI67_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI67_0@toc@l
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltConst32kll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addis r3, r2, .LCPI67_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI67_0@toc@l
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltConst32kll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addis r3, r2, .LCPI67_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI67_0@toc@l
; P8BE-NEXT:    lxvd2x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltConst32kll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r3, r2, .LCPI67_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI67_0@toc@l
; P8LE-NEXT:    lxvd2x v2, 0, r3
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> <i64 65535, i64 65535>
}

define <2 x i64> @fromRegsll(i64 %a, i64 %b) {
; P9BE-LABEL: fromRegsll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    mtvsrdd v2, r3, r4
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRegsll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    mtvsrdd v2, r4, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRegsll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    mtfprd f0, r4
; P8BE-NEXT:    mtfprd f1, r3
; P8BE-NEXT:    xxmrghd v2, vs1, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRegsll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    mtfprd f0, r3
; P8LE-NEXT:    mtfprd f1, r4
; P8LE-NEXT:    xxmrghd v2, vs1, vs0
; P8LE-NEXT:    blr
entry:
  %vecinit = insertelement <2 x i64> undef, i64 %a, i32 0
  %vecinit1 = insertelement <2 x i64> %vecinit, i64 %b, i32 1
  ret <2 x i64> %vecinit1
}

define <2 x i64> @fromDiffConstsll() {
; P9BE-LABEL: fromDiffConstsll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    addis r3, r2, .LCPI69_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI69_0@toc@l
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffConstsll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addis r3, r2, .LCPI69_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI69_0@toc@l
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffConstsll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addis r3, r2, .LCPI69_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI69_0@toc@l
; P8BE-NEXT:    lxvd2x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffConstsll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r3, r2, .LCPI69_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI69_0@toc@l
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> <i64 242, i64 -113>
}

define <2 x i64> @fromDiffMemConsAll(ptr nocapture readonly %arr) {
; P9BE-LABEL: fromDiffMemConsAll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsAll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsAll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lxvd2x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsAll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  %0 = load i64, ptr %arr, align 8
  %vecinit = insertelement <2 x i64> undef, i64 %0, i32 0
  %arrayidx1 = getelementptr inbounds i64, ptr %arr, i64 1
  %1 = load i64, ptr %arrayidx1, align 8
  %vecinit2 = insertelement <2 x i64> %vecinit, i64 %1, i32 1
  ret <2 x i64> %vecinit2
}

define <2 x i64> @fromDiffMemConsDll(ptr nocapture readonly %arr) {
; P9BE-LABEL: fromDiffMemConsDll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv v2, 16(r3)
; P9BE-NEXT:    xxswapd v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsDll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addi r3, r3, 16
; P9LE-NEXT:    lxvd2x v2, 0, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsDll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addi r3, r3, 16
; P8BE-NEXT:    lxvd2x v2, 0, r3
; P8BE-NEXT:    xxswapd v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsDll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addi r3, r3, 16
; P8LE-NEXT:    lxvd2x v2, 0, r3
; P8LE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds i64, ptr %arr, i64 3
  %0 = load i64, ptr %arrayidx, align 8
  %vecinit = insertelement <2 x i64> undef, i64 %0, i32 0
  %arrayidx1 = getelementptr inbounds i64, ptr %arr, i64 2
  %1 = load i64, ptr %arrayidx1, align 8
  %vecinit2 = insertelement <2 x i64> %vecinit, i64 %1, i32 1
  ret <2 x i64> %vecinit2
}

define <2 x i64> @fromDiffMemVarAll(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarAll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 3
; P9BE-NEXT:    lxvx v2, r3, r4
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarAll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 3
; P9LE-NEXT:    lxvx v2, r3, r4
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarAll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 3
; P8BE-NEXT:    lxvd2x v2, r3, r4
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarAll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 3
; P8LE-NEXT:    lxvd2x vs0, r3, r4
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds i64, ptr %arr, i64 %idxprom
  %0 = load i64, ptr %arrayidx, align 8
  %vecinit = insertelement <2 x i64> undef, i64 %0, i32 0
  %add = add nsw i32 %elem, 1
  %idxprom1 = sext i32 %add to i64
  %arrayidx2 = getelementptr inbounds i64, ptr %arr, i64 %idxprom1
  %1 = load i64, ptr %arrayidx2, align 8
  %vecinit3 = insertelement <2 x i64> %vecinit, i64 %1, i32 1
  ret <2 x i64> %vecinit3
}

define <2 x i64> @fromDiffMemVarDll(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarDll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 3
; P9BE-NEXT:    add r3, r3, r4
; P9BE-NEXT:    li r4, -8
; P9BE-NEXT:    lxvx v2, r3, r4
; P9BE-NEXT:    xxswapd v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarDll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 3
; P9LE-NEXT:    add r3, r3, r4
; P9LE-NEXT:    addi r3, r3, -8
; P9LE-NEXT:    lxvd2x v2, 0, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarDll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 3
; P8BE-NEXT:    add r3, r3, r4
; P8BE-NEXT:    addi r3, r3, -8
; P8BE-NEXT:    lxvd2x v2, 0, r3
; P8BE-NEXT:    xxswapd v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarDll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 3
; P8LE-NEXT:    add r3, r3, r4
; P8LE-NEXT:    addi r3, r3, -8
; P8LE-NEXT:    lxvd2x v2, 0, r3
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds i64, ptr %arr, i64 %idxprom
  %0 = load i64, ptr %arrayidx, align 8
  %vecinit = insertelement <2 x i64> undef, i64 %0, i32 0
  %sub = add nsw i32 %elem, -1
  %idxprom1 = sext i32 %sub to i64
  %arrayidx2 = getelementptr inbounds i64, ptr %arr, i64 %idxprom1
  %1 = load i64, ptr %arrayidx2, align 8
  %vecinit3 = insertelement <2 x i64> %vecinit, i64 %1, i32 1
  ret <2 x i64> %vecinit3
}

define <2 x i64> @fromRandMemConsll(ptr nocapture readonly %arr) {
; P9BE-LABEL: fromRandMemConsll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    ld r4, 32(r3)
; P9BE-NEXT:    ld r3, 144(r3)
; P9BE-NEXT:    mtvsrdd v2, r4, r3
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRandMemConsll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    ld r4, 32(r3)
; P9LE-NEXT:    ld r3, 144(r3)
; P9LE-NEXT:    mtvsrdd v2, r3, r4
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRandMemConsll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    ld r4, 32(r3)
; P8BE-NEXT:    ld r3, 144(r3)
; P8BE-NEXT:    mtfprd f0, r3
; P8BE-NEXT:    mtfprd f1, r4
; P8BE-NEXT:    xxmrghd v2, vs1, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRandMemConsll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    ld r4, 32(r3)
; P8LE-NEXT:    ld r3, 144(r3)
; P8LE-NEXT:    mtfprd f0, r4
; P8LE-NEXT:    mtfprd f1, r3
; P8LE-NEXT:    xxmrghd v2, vs1, vs0
; P8LE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds i64, ptr %arr, i64 4
  %0 = load i64, ptr %arrayidx, align 8
  %vecinit = insertelement <2 x i64> undef, i64 %0, i32 0
  %arrayidx1 = getelementptr inbounds i64, ptr %arr, i64 18
  %1 = load i64, ptr %arrayidx1, align 8
  %vecinit2 = insertelement <2 x i64> %vecinit, i64 %1, i32 1
  ret <2 x i64> %vecinit2
}

define <2 x i64> @fromRandMemVarll(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromRandMemVarll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 3
; P9BE-NEXT:    add r3, r3, r4
; P9BE-NEXT:    ld r4, 32(r3)
; P9BE-NEXT:    ld r3, 8(r3)
; P9BE-NEXT:    mtvsrdd v2, r4, r3
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRandMemVarll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 3
; P9LE-NEXT:    add r3, r3, r4
; P9LE-NEXT:    ld r4, 32(r3)
; P9LE-NEXT:    ld r3, 8(r3)
; P9LE-NEXT:    mtvsrdd v2, r3, r4
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRandMemVarll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 3
; P8BE-NEXT:    add r3, r3, r4
; P8BE-NEXT:    ld r4, 32(r3)
; P8BE-NEXT:    ld r3, 8(r3)
; P8BE-NEXT:    mtfprd f0, r3
; P8BE-NEXT:    mtfprd f1, r4
; P8BE-NEXT:    xxmrghd v2, vs1, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRandMemVarll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 3
; P8LE-NEXT:    add r3, r3, r4
; P8LE-NEXT:    ld r4, 32(r3)
; P8LE-NEXT:    ld r3, 8(r3)
; P8LE-NEXT:    mtfprd f0, r4
; P8LE-NEXT:    mtfprd f1, r3
; P8LE-NEXT:    xxmrghd v2, vs1, vs0
; P8LE-NEXT:    blr
entry:
  %add = add nsw i32 %elem, 4
  %idxprom = sext i32 %add to i64
  %arrayidx = getelementptr inbounds i64, ptr %arr, i64 %idxprom
  %0 = load i64, ptr %arrayidx, align 8
  %vecinit = insertelement <2 x i64> undef, i64 %0, i32 0
  %add1 = add nsw i32 %elem, 1
  %idxprom2 = sext i32 %add1 to i64
  %arrayidx3 = getelementptr inbounds i64, ptr %arr, i64 %idxprom2
  %1 = load i64, ptr %arrayidx3, align 8
  %vecinit4 = insertelement <2 x i64> %vecinit, i64 %1, i32 1
  ret <2 x i64> %vecinit4
}

define <2 x i64> @spltRegValll(i64 %val) {
; P9BE-LABEL: spltRegValll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    mtvsrdd v2, r3, r3
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltRegValll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    mtvsrdd v2, r3, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltRegValll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    mtfprd f0, r3
; P8BE-NEXT:    xxspltd v2, vs0, 0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltRegValll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    mtfprd f0, r3
; P8LE-NEXT:    xxspltd v2, vs0, 0
; P8LE-NEXT:    blr
entry:
  %splat.splatinsert = insertelement <2 x i64> undef, i64 %val, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %splat.splat
}

define <2 x i64> @spltMemValll(ptr nocapture readonly %ptr) {
; P9BE-LABEL: spltMemValll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxvdsx v2, 0, r3
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltMemValll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxvdsx v2, 0, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltMemValll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lxvdsx v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltMemValll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lxvdsx v2, 0, r3
; P8LE-NEXT:    blr
entry:
  %0 = load i64, ptr %ptr, align 8
  %splat.splatinsert = insertelement <2 x i64> undef, i64 %0, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %splat.splat
}

define <2 x i64> @spltCnstConvftoll() {
; P9BE-LABEL: spltCnstConvftoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    vspltisw v2, 4
; P9BE-NEXT:    vupklsw v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltCnstConvftoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    vspltisw v2, 4
; P9LE-NEXT:    vupklsw v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltCnstConvftoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    vspltisw v2, 4
; P8BE-NEXT:    vupklsw v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltCnstConvftoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    vspltisw v2, 4
; P8LE-NEXT:    vupklsw v2, v2
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> <i64 4, i64 4>
}

define <2 x i64> @fromRegsConvftoll(float %a, float %b) {
; P9BE-LABEL: fromRegsConvftoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxmrghd vs0, vs1, vs2
; P9BE-NEXT:    xvcvdpsxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRegsConvftoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxmrghd vs0, vs2, vs1
; P9LE-NEXT:    xvcvdpsxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRegsConvftoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxmrghd vs0, vs1, vs2
; P8BE-NEXT:    xvcvdpsxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRegsConvftoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxmrghd vs0, vs2, vs1
; P8LE-NEXT:    xvcvdpsxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %conv = fptosi float %a to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %conv1 = fptosi float %b to i64
  %vecinit2 = insertelement <2 x i64> %vecinit, i64 %conv1, i32 1
  ret <2 x i64> %vecinit2
}

define <2 x i64> @fromDiffConstsConvftoll() {
; P9BE-LABEL: fromDiffConstsConvftoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    addis r3, r2, .LCPI80_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI80_0@toc@l
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffConstsConvftoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addis r3, r2, .LCPI80_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI80_0@toc@l
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffConstsConvftoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addis r3, r2, .LCPI80_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI80_0@toc@l
; P8BE-NEXT:    lxvd2x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffConstsConvftoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r3, r2, .LCPI80_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI80_0@toc@l
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> <i64 24, i64 234>
}

define <2 x i64> @fromDiffMemConsAConvftoll(ptr nocapture readonly %ptr) {
; P9BE-LABEL: fromDiffMemConsAConvftoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lfs f0, 0(r3)
; P9BE-NEXT:    lfs f1, 4(r3)
; P9BE-NEXT:    xxmrghd vs0, vs0, vs1
; P9BE-NEXT:    xvcvdpsxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsAConvftoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lfs f0, 0(r3)
; P9LE-NEXT:    lfs f1, 4(r3)
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    xvcvdpsxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsAConvftoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lfs f0, 0(r3)
; P8BE-NEXT:    lfs f1, 4(r3)
; P8BE-NEXT:    xxmrghd vs0, vs0, vs1
; P8BE-NEXT:    xvcvdpsxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsAConvftoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lfs f0, 0(r3)
; P8LE-NEXT:    lfs f1, 4(r3)
; P8LE-NEXT:    xxmrghd vs0, vs1, vs0
; P8LE-NEXT:    xvcvdpsxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %0 = load float, ptr %ptr, align 4
  %conv = fptosi float %0 to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %arrayidx1 = getelementptr inbounds float, ptr %ptr, i64 1
  %1 = load float, ptr %arrayidx1, align 4
  %conv2 = fptosi float %1 to i64
  %vecinit3 = insertelement <2 x i64> %vecinit, i64 %conv2, i32 1
  ret <2 x i64> %vecinit3
}

define <2 x i64> @fromDiffMemConsDConvftoll(ptr nocapture readonly %ptr) {
; P9BE-LABEL: fromDiffMemConsDConvftoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lfs f0, 12(r3)
; P9BE-NEXT:    lfs f1, 8(r3)
; P9BE-NEXT:    xxmrghd vs0, vs0, vs1
; P9BE-NEXT:    xvcvdpsxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsDConvftoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lfs f0, 12(r3)
; P9LE-NEXT:    lfs f1, 8(r3)
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    xvcvdpsxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsDConvftoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lfs f0, 12(r3)
; P8BE-NEXT:    lfs f1, 8(r3)
; P8BE-NEXT:    xxmrghd vs0, vs0, vs1
; P8BE-NEXT:    xvcvdpsxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsDConvftoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lfs f0, 12(r3)
; P8LE-NEXT:    lfs f1, 8(r3)
; P8LE-NEXT:    xxmrghd vs0, vs1, vs0
; P8LE-NEXT:    xvcvdpsxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds float, ptr %ptr, i64 3
  %0 = load float, ptr %arrayidx, align 4
  %conv = fptosi float %0 to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %arrayidx1 = getelementptr inbounds float, ptr %ptr, i64 2
  %1 = load float, ptr %arrayidx1, align 4
  %conv2 = fptosi float %1 to i64
  %vecinit3 = insertelement <2 x i64> %vecinit, i64 %conv2, i32 1
  ret <2 x i64> %vecinit3
}

define <2 x i64> @fromDiffMemVarAConvftoll(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarAConvftoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 2
; P9BE-NEXT:    lfsux f0, r3, r4
; P9BE-NEXT:    lfs f1, 4(r3)
; P9BE-NEXT:    xxmrghd vs0, vs0, vs1
; P9BE-NEXT:    xvcvdpsxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarAConvftoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 2
; P9LE-NEXT:    lfsux f0, r3, r4
; P9LE-NEXT:    lfs f1, 4(r3)
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    xvcvdpsxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarAConvftoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 2
; P8BE-NEXT:    lfsux f0, r3, r4
; P8BE-NEXT:    lfs f1, 4(r3)
; P8BE-NEXT:    xxmrghd vs0, vs0, vs1
; P8BE-NEXT:    xvcvdpsxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarAConvftoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 2
; P8LE-NEXT:    lfsux f0, r3, r4
; P8LE-NEXT:    lfs f1, 4(r3)
; P8LE-NEXT:    xxmrghd vs0, vs1, vs0
; P8LE-NEXT:    xvcvdpsxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds float, ptr %arr, i64 %idxprom
  %0 = load float, ptr %arrayidx, align 4
  %conv = fptosi float %0 to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %add = add nsw i32 %elem, 1
  %idxprom1 = sext i32 %add to i64
  %arrayidx2 = getelementptr inbounds float, ptr %arr, i64 %idxprom1
  %1 = load float, ptr %arrayidx2, align 4
  %conv3 = fptosi float %1 to i64
  %vecinit4 = insertelement <2 x i64> %vecinit, i64 %conv3, i32 1
  ret <2 x i64> %vecinit4
}

define <2 x i64> @fromDiffMemVarDConvftoll(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarDConvftoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 2
; P9BE-NEXT:    lfsux f0, r3, r4
; P9BE-NEXT:    lfs f1, -4(r3)
; P9BE-NEXT:    xxmrghd vs0, vs0, vs1
; P9BE-NEXT:    xvcvdpsxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarDConvftoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 2
; P9LE-NEXT:    lfsux f0, r3, r4
; P9LE-NEXT:    lfs f1, -4(r3)
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    xvcvdpsxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarDConvftoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 2
; P8BE-NEXT:    lfsux f0, r3, r4
; P8BE-NEXT:    lfs f1, -4(r3)
; P8BE-NEXT:    xxmrghd vs0, vs0, vs1
; P8BE-NEXT:    xvcvdpsxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarDConvftoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 2
; P8LE-NEXT:    lfsux f0, r3, r4
; P8LE-NEXT:    lfs f1, -4(r3)
; P8LE-NEXT:    xxmrghd vs0, vs1, vs0
; P8LE-NEXT:    xvcvdpsxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds float, ptr %arr, i64 %idxprom
  %0 = load float, ptr %arrayidx, align 4
  %conv = fptosi float %0 to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %sub = add nsw i32 %elem, -1
  %idxprom1 = sext i32 %sub to i64
  %arrayidx2 = getelementptr inbounds float, ptr %arr, i64 %idxprom1
  %1 = load float, ptr %arrayidx2, align 4
  %conv3 = fptosi float %1 to i64
  %vecinit4 = insertelement <2 x i64> %vecinit, i64 %conv3, i32 1
  ret <2 x i64> %vecinit4
}

define <2 x i64> @spltRegValConvftoll(float %val) {
; P9BE-LABEL: spltRegValConvftoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xscvdpsxds f0, f1
; P9BE-NEXT:    xxspltd v2, f0, 0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltRegValConvftoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xscvdpsxds f0, f1
; P9LE-NEXT:    xxspltd v2, f0, 0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltRegValConvftoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xscvdpsxds f0, f1
; P8BE-NEXT:    xxspltd v2, f0, 0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltRegValConvftoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xscvdpsxds f0, f1
; P8LE-NEXT:    xxspltd v2, f0, 0
; P8LE-NEXT:    blr
entry:
  %conv = fptosi float %val to i64
  %splat.splatinsert = insertelement <2 x i64> undef, i64 %conv, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %splat.splat
}

define <2 x i64> @spltMemValConvftoll(ptr nocapture readonly %ptr) {
; P9BE-LABEL: spltMemValConvftoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lfs f0, 0(r3)
; P9BE-NEXT:    xscvdpsxds f0, f0
; P9BE-NEXT:    xxspltd v2, f0, 0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltMemValConvftoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lfs f0, 0(r3)
; P9LE-NEXT:    xscvdpsxds f0, f0
; P9LE-NEXT:    xxspltd v2, vs0, 0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltMemValConvftoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lfsx f0, 0, r3
; P8BE-NEXT:    xscvdpsxds f0, f0
; P8BE-NEXT:    xxspltd v2, f0, 0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltMemValConvftoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lfsx f0, 0, r3
; P8LE-NEXT:    xscvdpsxds f0, f0
; P8LE-NEXT:    xxspltd v2, vs0, 0
; P8LE-NEXT:    blr
entry:
  %0 = load float, ptr %ptr, align 4
  %conv = fptosi float %0 to i64
  %splat.splatinsert = insertelement <2 x i64> undef, i64 %conv, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %splat.splat
}

define <2 x i64> @spltCnstConvdtoll() {
; P9BE-LABEL: spltCnstConvdtoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    vspltisw v2, 4
; P9BE-NEXT:    vupklsw v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltCnstConvdtoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    vspltisw v2, 4
; P9LE-NEXT:    vupklsw v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltCnstConvdtoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    vspltisw v2, 4
; P8BE-NEXT:    vupklsw v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltCnstConvdtoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    vspltisw v2, 4
; P8LE-NEXT:    vupklsw v2, v2
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> <i64 4, i64 4>
}

define <2 x i64> @fromRegsConvdtoll(double %a, double %b) {
; P9BE-LABEL: fromRegsConvdtoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxmrghd vs0, vs1, vs2
; P9BE-NEXT:    xvcvdpsxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRegsConvdtoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxmrghd vs0, vs2, vs1
; P9LE-NEXT:    xvcvdpsxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRegsConvdtoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxmrghd vs0, vs1, vs2
; P8BE-NEXT:    xvcvdpsxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRegsConvdtoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxmrghd vs0, vs2, vs1
; P8LE-NEXT:    xvcvdpsxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %conv = fptosi double %a to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %conv1 = fptosi double %b to i64
  %vecinit2 = insertelement <2 x i64> %vecinit, i64 %conv1, i32 1
  ret <2 x i64> %vecinit2
}

define <2 x i64> @fromDiffConstsConvdtoll() {
; P9BE-LABEL: fromDiffConstsConvdtoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    addis r3, r2, .LCPI89_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI89_0@toc@l
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffConstsConvdtoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addis r3, r2, .LCPI89_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI89_0@toc@l
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffConstsConvdtoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addis r3, r2, .LCPI89_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI89_0@toc@l
; P8BE-NEXT:    lxvd2x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffConstsConvdtoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r3, r2, .LCPI89_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI89_0@toc@l
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> <i64 24, i64 234>
}

define <2 x i64> @fromDiffMemConsAConvdtoll(ptr nocapture readonly %ptr) {
; P9BE-LABEL: fromDiffMemConsAConvdtoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv vs0, 0(r3)
; P9BE-NEXT:    xvcvdpsxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsAConvdtoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxv vs0, 0(r3)
; P9LE-NEXT:    xvcvdpsxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsAConvdtoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lxvd2x vs0, 0, r3
; P8BE-NEXT:    xvcvdpsxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsAConvdtoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd vs0, vs0
; P8LE-NEXT:    xvcvdpsxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %0 = load <2 x double>, ptr %ptr, align 8
  %1 = fptosi <2 x double> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @fromDiffMemConsDConvdtoll(ptr nocapture readonly %ptr) {
; P9BE-LABEL: fromDiffMemConsDConvdtoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv vs0, 16(r3)
; P9BE-NEXT:    xxswapd vs0, vs0
; P9BE-NEXT:    xvcvdpsxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsDConvdtoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addi r3, r3, 16
; P9LE-NEXT:    lxvd2x vs0, 0, r3
; P9LE-NEXT:    xvcvdpsxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsDConvdtoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addi r3, r3, 16
; P8BE-NEXT:    lxvd2x vs0, 0, r3
; P8BE-NEXT:    xxswapd vs0, vs0
; P8BE-NEXT:    xvcvdpsxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsDConvdtoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addi r3, r3, 16
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xvcvdpsxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds double, ptr %ptr, i64 3
  %0 = load double, ptr %arrayidx, align 8
  %conv = fptosi double %0 to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %arrayidx1 = getelementptr inbounds double, ptr %ptr, i64 2
  %1 = load double, ptr %arrayidx1, align 8
  %conv2 = fptosi double %1 to i64
  %vecinit3 = insertelement <2 x i64> %vecinit, i64 %conv2, i32 1
  ret <2 x i64> %vecinit3
}

define <2 x i64> @fromDiffMemVarAConvdtoll(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarAConvdtoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 3
; P9BE-NEXT:    lxvx vs0, r3, r4
; P9BE-NEXT:    xvcvdpsxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarAConvdtoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 3
; P9LE-NEXT:    lxvx vs0, r3, r4
; P9LE-NEXT:    xvcvdpsxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarAConvdtoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 3
; P8BE-NEXT:    lxvd2x vs0, r3, r4
; P8BE-NEXT:    xvcvdpsxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarAConvdtoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 3
; P8LE-NEXT:    lxvd2x vs0, r3, r4
; P8LE-NEXT:    xxswapd vs0, vs0
; P8LE-NEXT:    xvcvdpsxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds double, ptr %arr, i64 %idxprom
  %0 = load double, ptr %arrayidx, align 8
  %conv = fptosi double %0 to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %add = add nsw i32 %elem, 1
  %idxprom1 = sext i32 %add to i64
  %arrayidx2 = getelementptr inbounds double, ptr %arr, i64 %idxprom1
  %1 = load double, ptr %arrayidx2, align 8
  %conv3 = fptosi double %1 to i64
  %vecinit4 = insertelement <2 x i64> %vecinit, i64 %conv3, i32 1
  ret <2 x i64> %vecinit4
}

define <2 x i64> @fromDiffMemVarDConvdtoll(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarDConvdtoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 3
; P9BE-NEXT:    add r3, r3, r4
; P9BE-NEXT:    li r4, -8
; P9BE-NEXT:    lxvx vs0, r3, r4
; P9BE-NEXT:    xxswapd vs0, vs0
; P9BE-NEXT:    xvcvdpsxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarDConvdtoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 3
; P9LE-NEXT:    add r3, r3, r4
; P9LE-NEXT:    addi r3, r3, -8
; P9LE-NEXT:    lxvd2x vs0, 0, r3
; P9LE-NEXT:    xvcvdpsxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarDConvdtoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 3
; P8BE-NEXT:    add r3, r3, r4
; P8BE-NEXT:    addi r3, r3, -8
; P8BE-NEXT:    lxvd2x vs0, 0, r3
; P8BE-NEXT:    xxswapd vs0, vs0
; P8BE-NEXT:    xvcvdpsxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarDConvdtoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 3
; P8LE-NEXT:    add r3, r3, r4
; P8LE-NEXT:    addi r3, r3, -8
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xvcvdpsxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds double, ptr %arr, i64 %idxprom
  %0 = load double, ptr %arrayidx, align 8
  %conv = fptosi double %0 to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %sub = add nsw i32 %elem, -1
  %idxprom1 = sext i32 %sub to i64
  %arrayidx2 = getelementptr inbounds double, ptr %arr, i64 %idxprom1
  %1 = load double, ptr %arrayidx2, align 8
  %conv3 = fptosi double %1 to i64
  %vecinit4 = insertelement <2 x i64> %vecinit, i64 %conv3, i32 1
  ret <2 x i64> %vecinit4
}

define <2 x i64> @spltRegValConvdtoll(double %val) {
; P9BE-LABEL: spltRegValConvdtoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xscvdpsxds f0, f1
; P9BE-NEXT:    xxspltd v2, vs0, 0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltRegValConvdtoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xscvdpsxds f0, f1
; P9LE-NEXT:    xxspltd v2, vs0, 0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltRegValConvdtoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xscvdpsxds f0, f1
; P8BE-NEXT:    xxspltd v2, vs0, 0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltRegValConvdtoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xscvdpsxds f0, f1
; P8LE-NEXT:    xxspltd v2, vs0, 0
; P8LE-NEXT:    blr
entry:
  %conv = fptosi double %val to i64
  %splat.splatinsert = insertelement <2 x i64> undef, i64 %conv, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %splat.splat
}

define <2 x i64> @spltMemValConvdtoll(ptr nocapture readonly %ptr) {
; P9BE-LABEL: spltMemValConvdtoll:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxvdsx vs0, 0, r3
; P9BE-NEXT:    xvcvdpsxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltMemValConvdtoll:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxvdsx vs0, 0, r3
; P9LE-NEXT:    xvcvdpsxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltMemValConvdtoll:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lxvdsx vs0, 0, r3
; P8BE-NEXT:    xvcvdpsxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltMemValConvdtoll:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lxvdsx vs0, 0, r3
; P8LE-NEXT:    xvcvdpsxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %0 = load double, ptr %ptr, align 8
  %conv = fptosi double %0 to i64
  %splat.splatinsert = insertelement <2 x i64> undef, i64 %conv, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %splat.splat
}

define <2 x i64> @allZeroull() {
; P9BE-LABEL: allZeroull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxlxor v2, v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: allZeroull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxlxor v2, v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: allZeroull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxlxor v2, v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: allZeroull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxlxor v2, v2, v2
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> zeroinitializer
}

define <2 x i64> @spltConst1ull() {
; P9BE-LABEL: spltConst1ull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    vspltisw v2, 1
; P9BE-NEXT:    vupklsw v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltConst1ull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    vspltisw v2, 1
; P9LE-NEXT:    vupklsw v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltConst1ull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    vspltisw v2, 1
; P8BE-NEXT:    vupklsw v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltConst1ull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    vspltisw v2, 1
; P8LE-NEXT:    vupklsw v2, v2
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> <i64 1, i64 1>
}

define <2 x i64> @spltConst16kull() {
; P9BE-LABEL: spltConst16kull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    addis r3, r2, .LCPI98_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI98_0@toc@l
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltConst16kull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addis r3, r2, .LCPI98_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI98_0@toc@l
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltConst16kull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addis r3, r2, .LCPI98_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI98_0@toc@l
; P8BE-NEXT:    lxvd2x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltConst16kull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r3, r2, .LCPI98_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI98_0@toc@l
; P8LE-NEXT:    lxvd2x v2, 0, r3
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> <i64 32767, i64 32767>
}

define <2 x i64> @spltConst32kull() {
; P9BE-LABEL: spltConst32kull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    addis r3, r2, .LCPI99_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI99_0@toc@l
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltConst32kull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addis r3, r2, .LCPI99_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI99_0@toc@l
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltConst32kull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addis r3, r2, .LCPI99_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI99_0@toc@l
; P8BE-NEXT:    lxvd2x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltConst32kull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r3, r2, .LCPI99_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI99_0@toc@l
; P8LE-NEXT:    lxvd2x v2, 0, r3
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> <i64 65535, i64 65535>
}

define <2 x i64> @fromRegsull(i64 %a, i64 %b) {
; P9BE-LABEL: fromRegsull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    mtvsrdd v2, r3, r4
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRegsull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    mtvsrdd v2, r4, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRegsull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    mtfprd f0, r4
; P8BE-NEXT:    mtfprd f1, r3
; P8BE-NEXT:    xxmrghd v2, vs1, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRegsull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    mtfprd f0, r3
; P8LE-NEXT:    mtfprd f1, r4
; P8LE-NEXT:    xxmrghd v2, vs1, vs0
; P8LE-NEXT:    blr
entry:
  %vecinit = insertelement <2 x i64> undef, i64 %a, i32 0
  %vecinit1 = insertelement <2 x i64> %vecinit, i64 %b, i32 1
  ret <2 x i64> %vecinit1
}

define <2 x i64> @fromDiffConstsull() {
; P9BE-LABEL: fromDiffConstsull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    addis r3, r2, .LCPI101_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI101_0@toc@l
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffConstsull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addis r3, r2, .LCPI101_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI101_0@toc@l
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffConstsull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addis r3, r2, .LCPI101_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI101_0@toc@l
; P8BE-NEXT:    lxvd2x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffConstsull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r3, r2, .LCPI101_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI101_0@toc@l
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> <i64 242, i64 -113>
}

define <2 x i64> @fromDiffMemConsAull(ptr nocapture readonly %arr) {
; P9BE-LABEL: fromDiffMemConsAull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsAull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsAull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lxvd2x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsAull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  %0 = load i64, ptr %arr, align 8
  %vecinit = insertelement <2 x i64> undef, i64 %0, i32 0
  %arrayidx1 = getelementptr inbounds i64, ptr %arr, i64 1
  %1 = load i64, ptr %arrayidx1, align 8
  %vecinit2 = insertelement <2 x i64> %vecinit, i64 %1, i32 1
  ret <2 x i64> %vecinit2
}

define <2 x i64> @fromDiffMemConsDull(ptr nocapture readonly %arr) {
; P9BE-LABEL: fromDiffMemConsDull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv v2, 16(r3)
; P9BE-NEXT:    xxswapd v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsDull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addi r3, r3, 16
; P9LE-NEXT:    lxvd2x v2, 0, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsDull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addi r3, r3, 16
; P8BE-NEXT:    lxvd2x v2, 0, r3
; P8BE-NEXT:    xxswapd v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsDull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addi r3, r3, 16
; P8LE-NEXT:    lxvd2x v2, 0, r3
; P8LE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds i64, ptr %arr, i64 3
  %0 = load i64, ptr %arrayidx, align 8
  %vecinit = insertelement <2 x i64> undef, i64 %0, i32 0
  %arrayidx1 = getelementptr inbounds i64, ptr %arr, i64 2
  %1 = load i64, ptr %arrayidx1, align 8
  %vecinit2 = insertelement <2 x i64> %vecinit, i64 %1, i32 1
  ret <2 x i64> %vecinit2
}

define <2 x i64> @fromDiffMemVarAull(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarAull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 3
; P9BE-NEXT:    lxvx v2, r3, r4
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarAull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 3
; P9LE-NEXT:    lxvx v2, r3, r4
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarAull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 3
; P8BE-NEXT:    lxvd2x v2, r3, r4
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarAull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 3
; P8LE-NEXT:    lxvd2x vs0, r3, r4
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds i64, ptr %arr, i64 %idxprom
  %0 = load i64, ptr %arrayidx, align 8
  %vecinit = insertelement <2 x i64> undef, i64 %0, i32 0
  %add = add nsw i32 %elem, 1
  %idxprom1 = sext i32 %add to i64
  %arrayidx2 = getelementptr inbounds i64, ptr %arr, i64 %idxprom1
  %1 = load i64, ptr %arrayidx2, align 8
  %vecinit3 = insertelement <2 x i64> %vecinit, i64 %1, i32 1
  ret <2 x i64> %vecinit3
}

define <2 x i64> @fromDiffMemVarDull(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarDull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 3
; P9BE-NEXT:    add r3, r3, r4
; P9BE-NEXT:    li r4, -8
; P9BE-NEXT:    lxvx v2, r3, r4
; P9BE-NEXT:    xxswapd v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarDull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 3
; P9LE-NEXT:    add r3, r3, r4
; P9LE-NEXT:    addi r3, r3, -8
; P9LE-NEXT:    lxvd2x v2, 0, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarDull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 3
; P8BE-NEXT:    add r3, r3, r4
; P8BE-NEXT:    addi r3, r3, -8
; P8BE-NEXT:    lxvd2x v2, 0, r3
; P8BE-NEXT:    xxswapd v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarDull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 3
; P8LE-NEXT:    add r3, r3, r4
; P8LE-NEXT:    addi r3, r3, -8
; P8LE-NEXT:    lxvd2x v2, 0, r3
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds i64, ptr %arr, i64 %idxprom
  %0 = load i64, ptr %arrayidx, align 8
  %vecinit = insertelement <2 x i64> undef, i64 %0, i32 0
  %sub = add nsw i32 %elem, -1
  %idxprom1 = sext i32 %sub to i64
  %arrayidx2 = getelementptr inbounds i64, ptr %arr, i64 %idxprom1
  %1 = load i64, ptr %arrayidx2, align 8
  %vecinit3 = insertelement <2 x i64> %vecinit, i64 %1, i32 1
  ret <2 x i64> %vecinit3
}

define <2 x i64> @fromRandMemConsull(ptr nocapture readonly %arr) {
; P9BE-LABEL: fromRandMemConsull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    ld r4, 32(r3)
; P9BE-NEXT:    ld r3, 144(r3)
; P9BE-NEXT:    mtvsrdd v2, r4, r3
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRandMemConsull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    ld r4, 32(r3)
; P9LE-NEXT:    ld r3, 144(r3)
; P9LE-NEXT:    mtvsrdd v2, r3, r4
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRandMemConsull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    ld r4, 32(r3)
; P8BE-NEXT:    ld r3, 144(r3)
; P8BE-NEXT:    mtfprd f0, r3
; P8BE-NEXT:    mtfprd f1, r4
; P8BE-NEXT:    xxmrghd v2, vs1, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRandMemConsull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    ld r4, 32(r3)
; P8LE-NEXT:    ld r3, 144(r3)
; P8LE-NEXT:    mtfprd f0, r4
; P8LE-NEXT:    mtfprd f1, r3
; P8LE-NEXT:    xxmrghd v2, vs1, vs0
; P8LE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds i64, ptr %arr, i64 4
  %0 = load i64, ptr %arrayidx, align 8
  %vecinit = insertelement <2 x i64> undef, i64 %0, i32 0
  %arrayidx1 = getelementptr inbounds i64, ptr %arr, i64 18
  %1 = load i64, ptr %arrayidx1, align 8
  %vecinit2 = insertelement <2 x i64> %vecinit, i64 %1, i32 1
  ret <2 x i64> %vecinit2
}

define <2 x i64> @fromRandMemVarull(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromRandMemVarull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 3
; P9BE-NEXT:    add r3, r3, r4
; P9BE-NEXT:    ld r4, 32(r3)
; P9BE-NEXT:    ld r3, 8(r3)
; P9BE-NEXT:    mtvsrdd v2, r4, r3
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRandMemVarull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 3
; P9LE-NEXT:    add r3, r3, r4
; P9LE-NEXT:    ld r4, 32(r3)
; P9LE-NEXT:    ld r3, 8(r3)
; P9LE-NEXT:    mtvsrdd v2, r3, r4
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRandMemVarull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 3
; P8BE-NEXT:    add r3, r3, r4
; P8BE-NEXT:    ld r4, 32(r3)
; P8BE-NEXT:    ld r3, 8(r3)
; P8BE-NEXT:    mtfprd f0, r3
; P8BE-NEXT:    mtfprd f1, r4
; P8BE-NEXT:    xxmrghd v2, vs1, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRandMemVarull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 3
; P8LE-NEXT:    add r3, r3, r4
; P8LE-NEXT:    ld r4, 32(r3)
; P8LE-NEXT:    ld r3, 8(r3)
; P8LE-NEXT:    mtfprd f0, r4
; P8LE-NEXT:    mtfprd f1, r3
; P8LE-NEXT:    xxmrghd v2, vs1, vs0
; P8LE-NEXT:    blr
entry:
  %add = add nsw i32 %elem, 4
  %idxprom = sext i32 %add to i64
  %arrayidx = getelementptr inbounds i64, ptr %arr, i64 %idxprom
  %0 = load i64, ptr %arrayidx, align 8
  %vecinit = insertelement <2 x i64> undef, i64 %0, i32 0
  %add1 = add nsw i32 %elem, 1
  %idxprom2 = sext i32 %add1 to i64
  %arrayidx3 = getelementptr inbounds i64, ptr %arr, i64 %idxprom2
  %1 = load i64, ptr %arrayidx3, align 8
  %vecinit4 = insertelement <2 x i64> %vecinit, i64 %1, i32 1
  ret <2 x i64> %vecinit4
}

define <2 x i64> @spltRegValull(i64 %val) {
; P9BE-LABEL: spltRegValull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    mtvsrdd v2, r3, r3
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltRegValull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    mtvsrdd v2, r3, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltRegValull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    mtfprd f0, r3
; P8BE-NEXT:    xxspltd v2, vs0, 0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltRegValull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    mtfprd f0, r3
; P8LE-NEXT:    xxspltd v2, vs0, 0
; P8LE-NEXT:    blr
entry:
  %splat.splatinsert = insertelement <2 x i64> undef, i64 %val, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %splat.splat
}

define <2 x i64> @spltMemValull(ptr nocapture readonly %ptr) {
; P9BE-LABEL: spltMemValull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxvdsx v2, 0, r3
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltMemValull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxvdsx v2, 0, r3
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltMemValull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lxvdsx v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltMemValull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lxvdsx v2, 0, r3
; P8LE-NEXT:    blr
entry:
  %0 = load i64, ptr %ptr, align 8
  %splat.splatinsert = insertelement <2 x i64> undef, i64 %0, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %splat.splat
}

define <2 x i64> @spltCnstConvftoull() {
; P9BE-LABEL: spltCnstConvftoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    vspltisw v2, 4
; P9BE-NEXT:    vupklsw v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltCnstConvftoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    vspltisw v2, 4
; P9LE-NEXT:    vupklsw v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltCnstConvftoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    vspltisw v2, 4
; P8BE-NEXT:    vupklsw v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltCnstConvftoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    vspltisw v2, 4
; P8LE-NEXT:    vupklsw v2, v2
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> <i64 4, i64 4>
}

define <2 x i64> @fromRegsConvftoull(float %a, float %b) {
; P9BE-LABEL: fromRegsConvftoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxmrghd vs0, vs1, vs2
; P9BE-NEXT:    xvcvdpuxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRegsConvftoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxmrghd vs0, vs2, vs1
; P9LE-NEXT:    xvcvdpuxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRegsConvftoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxmrghd vs0, vs1, vs2
; P8BE-NEXT:    xvcvdpuxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRegsConvftoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxmrghd vs0, vs2, vs1
; P8LE-NEXT:    xvcvdpuxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %conv = fptoui float %a to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %conv1 = fptoui float %b to i64
  %vecinit2 = insertelement <2 x i64> %vecinit, i64 %conv1, i32 1
  ret <2 x i64> %vecinit2
}

define <2 x i64> @fromDiffConstsConvftoull() {
; P9BE-LABEL: fromDiffConstsConvftoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    addis r3, r2, .LCPI112_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI112_0@toc@l
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffConstsConvftoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addis r3, r2, .LCPI112_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI112_0@toc@l
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffConstsConvftoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addis r3, r2, .LCPI112_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI112_0@toc@l
; P8BE-NEXT:    lxvd2x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffConstsConvftoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r3, r2, .LCPI112_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI112_0@toc@l
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> <i64 24, i64 234>
}

define <2 x i64> @fromDiffMemConsAConvftoull(ptr nocapture readonly %ptr) {
; P9BE-LABEL: fromDiffMemConsAConvftoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lfs f0, 0(r3)
; P9BE-NEXT:    lfs f1, 4(r3)
; P9BE-NEXT:    xxmrghd vs0, vs0, vs1
; P9BE-NEXT:    xvcvdpuxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsAConvftoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lfs f0, 0(r3)
; P9LE-NEXT:    lfs f1, 4(r3)
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    xvcvdpuxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsAConvftoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lfs f0, 0(r3)
; P8BE-NEXT:    lfs f1, 4(r3)
; P8BE-NEXT:    xxmrghd vs0, vs0, vs1
; P8BE-NEXT:    xvcvdpuxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsAConvftoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lfs f0, 0(r3)
; P8LE-NEXT:    lfs f1, 4(r3)
; P8LE-NEXT:    xxmrghd vs0, vs1, vs0
; P8LE-NEXT:    xvcvdpuxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %0 = load float, ptr %ptr, align 4
  %conv = fptoui float %0 to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %arrayidx1 = getelementptr inbounds float, ptr %ptr, i64 1
  %1 = load float, ptr %arrayidx1, align 4
  %conv2 = fptoui float %1 to i64
  %vecinit3 = insertelement <2 x i64> %vecinit, i64 %conv2, i32 1
  ret <2 x i64> %vecinit3
}

define <2 x i64> @fromDiffMemConsDConvftoull(ptr nocapture readonly %ptr) {
; P9BE-LABEL: fromDiffMemConsDConvftoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lfs f0, 12(r3)
; P9BE-NEXT:    lfs f1, 8(r3)
; P9BE-NEXT:    xxmrghd vs0, vs0, vs1
; P9BE-NEXT:    xvcvdpuxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsDConvftoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lfs f0, 12(r3)
; P9LE-NEXT:    lfs f1, 8(r3)
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    xvcvdpuxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsDConvftoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lfs f0, 12(r3)
; P8BE-NEXT:    lfs f1, 8(r3)
; P8BE-NEXT:    xxmrghd vs0, vs0, vs1
; P8BE-NEXT:    xvcvdpuxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsDConvftoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lfs f0, 12(r3)
; P8LE-NEXT:    lfs f1, 8(r3)
; P8LE-NEXT:    xxmrghd vs0, vs1, vs0
; P8LE-NEXT:    xvcvdpuxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds float, ptr %ptr, i64 3
  %0 = load float, ptr %arrayidx, align 4
  %conv = fptoui float %0 to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %arrayidx1 = getelementptr inbounds float, ptr %ptr, i64 2
  %1 = load float, ptr %arrayidx1, align 4
  %conv2 = fptoui float %1 to i64
  %vecinit3 = insertelement <2 x i64> %vecinit, i64 %conv2, i32 1
  ret <2 x i64> %vecinit3
}

define <2 x i64> @fromDiffMemVarAConvftoull(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarAConvftoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 2
; P9BE-NEXT:    lfsux f0, r3, r4
; P9BE-NEXT:    lfs f1, 4(r3)
; P9BE-NEXT:    xxmrghd vs0, vs0, vs1
; P9BE-NEXT:    xvcvdpuxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarAConvftoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 2
; P9LE-NEXT:    lfsux f0, r3, r4
; P9LE-NEXT:    lfs f1, 4(r3)
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    xvcvdpuxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarAConvftoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 2
; P8BE-NEXT:    lfsux f0, r3, r4
; P8BE-NEXT:    lfs f1, 4(r3)
; P8BE-NEXT:    xxmrghd vs0, vs0, vs1
; P8BE-NEXT:    xvcvdpuxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarAConvftoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 2
; P8LE-NEXT:    lfsux f0, r3, r4
; P8LE-NEXT:    lfs f1, 4(r3)
; P8LE-NEXT:    xxmrghd vs0, vs1, vs0
; P8LE-NEXT:    xvcvdpuxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds float, ptr %arr, i64 %idxprom
  %0 = load float, ptr %arrayidx, align 4
  %conv = fptoui float %0 to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %add = add nsw i32 %elem, 1
  %idxprom1 = sext i32 %add to i64
  %arrayidx2 = getelementptr inbounds float, ptr %arr, i64 %idxprom1
  %1 = load float, ptr %arrayidx2, align 4
  %conv3 = fptoui float %1 to i64
  %vecinit4 = insertelement <2 x i64> %vecinit, i64 %conv3, i32 1
  ret <2 x i64> %vecinit4
}

define <2 x i64> @fromDiffMemVarDConvftoull(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarDConvftoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 2
; P9BE-NEXT:    lfsux f0, r3, r4
; P9BE-NEXT:    lfs f1, -4(r3)
; P9BE-NEXT:    xxmrghd vs0, vs0, vs1
; P9BE-NEXT:    xvcvdpuxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarDConvftoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 2
; P9LE-NEXT:    lfsux f0, r3, r4
; P9LE-NEXT:    lfs f1, -4(r3)
; P9LE-NEXT:    xxmrghd vs0, vs1, vs0
; P9LE-NEXT:    xvcvdpuxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarDConvftoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 2
; P8BE-NEXT:    lfsux f0, r3, r4
; P8BE-NEXT:    lfs f1, -4(r3)
; P8BE-NEXT:    xxmrghd vs0, vs0, vs1
; P8BE-NEXT:    xvcvdpuxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarDConvftoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 2
; P8LE-NEXT:    lfsux f0, r3, r4
; P8LE-NEXT:    lfs f1, -4(r3)
; P8LE-NEXT:    xxmrghd vs0, vs1, vs0
; P8LE-NEXT:    xvcvdpuxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds float, ptr %arr, i64 %idxprom
  %0 = load float, ptr %arrayidx, align 4
  %conv = fptoui float %0 to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %sub = add nsw i32 %elem, -1
  %idxprom1 = sext i32 %sub to i64
  %arrayidx2 = getelementptr inbounds float, ptr %arr, i64 %idxprom1
  %1 = load float, ptr %arrayidx2, align 4
  %conv3 = fptoui float %1 to i64
  %vecinit4 = insertelement <2 x i64> %vecinit, i64 %conv3, i32 1
  ret <2 x i64> %vecinit4
}

define <2 x i64> @spltRegValConvftoull(float %val) {
; P9BE-LABEL: spltRegValConvftoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xscvdpuxds f0, f1
; P9BE-NEXT:    xxspltd v2, f0, 0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltRegValConvftoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xscvdpuxds f0, f1
; P9LE-NEXT:    xxspltd v2, f0, 0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltRegValConvftoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xscvdpuxds f0, f1
; P8BE-NEXT:    xxspltd v2, f0, 0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltRegValConvftoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xscvdpuxds f0, f1
; P8LE-NEXT:    xxspltd v2, f0, 0
; P8LE-NEXT:    blr
entry:
  %conv = fptoui float %val to i64
  %splat.splatinsert = insertelement <2 x i64> undef, i64 %conv, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %splat.splat
}

define <2 x i64> @spltMemValConvftoull(ptr nocapture readonly %ptr) {
; P9BE-LABEL: spltMemValConvftoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lfs f0, 0(r3)
; P9BE-NEXT:    xscvdpuxds f0, f0
; P9BE-NEXT:    xxspltd v2, f0, 0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltMemValConvftoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lfs f0, 0(r3)
; P9LE-NEXT:    xscvdpuxds f0, f0
; P9LE-NEXT:    xxspltd v2, vs0, 0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltMemValConvftoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lfsx f0, 0, r3
; P8BE-NEXT:    xscvdpuxds f0, f0
; P8BE-NEXT:    xxspltd v2, f0, 0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltMemValConvftoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lfsx f0, 0, r3
; P8LE-NEXT:    xscvdpuxds f0, f0
; P8LE-NEXT:    xxspltd v2, vs0, 0
; P8LE-NEXT:    blr
entry:
  %0 = load float, ptr %ptr, align 4
  %conv = fptoui float %0 to i64
  %splat.splatinsert = insertelement <2 x i64> undef, i64 %conv, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %splat.splat
}

define <2 x i64> @spltCnstConvdtoull() {
; P9BE-LABEL: spltCnstConvdtoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    vspltisw v2, 4
; P9BE-NEXT:    vupklsw v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltCnstConvdtoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    vspltisw v2, 4
; P9LE-NEXT:    vupklsw v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltCnstConvdtoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    vspltisw v2, 4
; P8BE-NEXT:    vupklsw v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltCnstConvdtoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    vspltisw v2, 4
; P8LE-NEXT:    vupklsw v2, v2
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> <i64 4, i64 4>
}

define <2 x i64> @fromRegsConvdtoull(double %a, double %b) {
; P9BE-LABEL: fromRegsConvdtoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxmrghd vs0, vs1, vs2
; P9BE-NEXT:    xvcvdpuxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromRegsConvdtoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxmrghd vs0, vs2, vs1
; P9LE-NEXT:    xvcvdpuxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromRegsConvdtoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxmrghd vs0, vs1, vs2
; P8BE-NEXT:    xvcvdpuxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromRegsConvdtoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxmrghd vs0, vs2, vs1
; P8LE-NEXT:    xvcvdpuxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %conv = fptoui double %a to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %conv1 = fptoui double %b to i64
  %vecinit2 = insertelement <2 x i64> %vecinit, i64 %conv1, i32 1
  ret <2 x i64> %vecinit2
}

define <2 x i64> @fromDiffConstsConvdtoull() {
; P9BE-LABEL: fromDiffConstsConvdtoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    addis r3, r2, .LCPI121_0@toc@ha
; P9BE-NEXT:    addi r3, r3, .LCPI121_0@toc@l
; P9BE-NEXT:    lxv v2, 0(r3)
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffConstsConvdtoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addis r3, r2, .LCPI121_0@toc@ha
; P9LE-NEXT:    addi r3, r3, .LCPI121_0@toc@l
; P9LE-NEXT:    lxv v2, 0(r3)
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffConstsConvdtoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addis r3, r2, .LCPI121_0@toc@ha
; P8BE-NEXT:    addi r3, r3, .LCPI121_0@toc@l
; P8BE-NEXT:    lxvd2x v2, 0, r3
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffConstsConvdtoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addis r3, r2, .LCPI121_0@toc@ha
; P8LE-NEXT:    addi r3, r3, .LCPI121_0@toc@l
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  ret <2 x i64> <i64 24, i64 234>
}

define <2 x i64> @fromDiffMemConsAConvdtoull(ptr nocapture readonly %ptr) {
; P9BE-LABEL: fromDiffMemConsAConvdtoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv vs0, 0(r3)
; P9BE-NEXT:    xvcvdpuxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsAConvdtoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxv vs0, 0(r3)
; P9LE-NEXT:    xvcvdpuxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsAConvdtoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lxvd2x vs0, 0, r3
; P8BE-NEXT:    xvcvdpuxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsAConvdtoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xxswapd vs0, vs0
; P8LE-NEXT:    xvcvdpuxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %0 = load <2 x double>, ptr %ptr, align 8
  %1 = fptoui <2 x double> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @fromDiffMemConsDConvdtoull(ptr nocapture readonly %ptr) {
; P9BE-LABEL: fromDiffMemConsDConvdtoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxv vs0, 16(r3)
; P9BE-NEXT:    xxswapd vs0, vs0
; P9BE-NEXT:    xvcvdpuxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemConsDConvdtoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    addi r3, r3, 16
; P9LE-NEXT:    lxvd2x vs0, 0, r3
; P9LE-NEXT:    xvcvdpuxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemConsDConvdtoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    addi r3, r3, 16
; P8BE-NEXT:    lxvd2x vs0, 0, r3
; P8BE-NEXT:    xxswapd vs0, vs0
; P8BE-NEXT:    xvcvdpuxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemConsDConvdtoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    addi r3, r3, 16
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xvcvdpuxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds double, ptr %ptr, i64 3
  %0 = load double, ptr %arrayidx, align 8
  %conv = fptoui double %0 to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %arrayidx1 = getelementptr inbounds double, ptr %ptr, i64 2
  %1 = load double, ptr %arrayidx1, align 8
  %conv2 = fptoui double %1 to i64
  %vecinit3 = insertelement <2 x i64> %vecinit, i64 %conv2, i32 1
  ret <2 x i64> %vecinit3
}

define <2 x i64> @fromDiffMemVarAConvdtoull(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarAConvdtoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 3
; P9BE-NEXT:    lxvx vs0, r3, r4
; P9BE-NEXT:    xvcvdpuxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarAConvdtoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 3
; P9LE-NEXT:    lxvx vs0, r3, r4
; P9LE-NEXT:    xvcvdpuxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarAConvdtoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 3
; P8BE-NEXT:    lxvd2x vs0, r3, r4
; P8BE-NEXT:    xvcvdpuxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarAConvdtoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 3
; P8LE-NEXT:    lxvd2x vs0, r3, r4
; P8LE-NEXT:    xxswapd vs0, vs0
; P8LE-NEXT:    xvcvdpuxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds double, ptr %arr, i64 %idxprom
  %0 = load double, ptr %arrayidx, align 8
  %conv = fptoui double %0 to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %add = add nsw i32 %elem, 1
  %idxprom1 = sext i32 %add to i64
  %arrayidx2 = getelementptr inbounds double, ptr %arr, i64 %idxprom1
  %1 = load double, ptr %arrayidx2, align 8
  %conv3 = fptoui double %1 to i64
  %vecinit4 = insertelement <2 x i64> %vecinit, i64 %conv3, i32 1
  ret <2 x i64> %vecinit4
}

define <2 x i64> @fromDiffMemVarDConvdtoull(ptr nocapture readonly %arr, i32 signext %elem) {
; P9BE-LABEL: fromDiffMemVarDConvdtoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi r4, r4, 3
; P9BE-NEXT:    add r3, r3, r4
; P9BE-NEXT:    li r4, -8
; P9BE-NEXT:    lxvx vs0, r3, r4
; P9BE-NEXT:    xxswapd vs0, vs0
; P9BE-NEXT:    xvcvdpuxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fromDiffMemVarDConvdtoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi r4, r4, 3
; P9LE-NEXT:    add r3, r3, r4
; P9LE-NEXT:    addi r3, r3, -8
; P9LE-NEXT:    lxvd2x vs0, 0, r3
; P9LE-NEXT:    xvcvdpuxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fromDiffMemVarDConvdtoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    sldi r4, r4, 3
; P8BE-NEXT:    add r3, r3, r4
; P8BE-NEXT:    addi r3, r3, -8
; P8BE-NEXT:    lxvd2x vs0, 0, r3
; P8BE-NEXT:    xxswapd vs0, vs0
; P8BE-NEXT:    xvcvdpuxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fromDiffMemVarDConvdtoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    sldi r4, r4, 3
; P8LE-NEXT:    add r3, r3, r4
; P8LE-NEXT:    addi r3, r3, -8
; P8LE-NEXT:    lxvd2x vs0, 0, r3
; P8LE-NEXT:    xvcvdpuxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %idxprom = sext i32 %elem to i64
  %arrayidx = getelementptr inbounds double, ptr %arr, i64 %idxprom
  %0 = load double, ptr %arrayidx, align 8
  %conv = fptoui double %0 to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %sub = add nsw i32 %elem, -1
  %idxprom1 = sext i32 %sub to i64
  %arrayidx2 = getelementptr inbounds double, ptr %arr, i64 %idxprom1
  %1 = load double, ptr %arrayidx2, align 8
  %conv3 = fptoui double %1 to i64
  %vecinit4 = insertelement <2 x i64> %vecinit, i64 %conv3, i32 1
  ret <2 x i64> %vecinit4
}

define <2 x i64> @spltRegValConvdtoull(double %val) {
; P9BE-LABEL: spltRegValConvdtoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xscvdpuxds f0, f1
; P9BE-NEXT:    xxspltd v2, vs0, 0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltRegValConvdtoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xscvdpuxds f0, f1
; P9LE-NEXT:    xxspltd v2, vs0, 0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltRegValConvdtoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xscvdpuxds f0, f1
; P8BE-NEXT:    xxspltd v2, vs0, 0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltRegValConvdtoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xscvdpuxds f0, f1
; P8LE-NEXT:    xxspltd v2, vs0, 0
; P8LE-NEXT:    blr
entry:
  %conv = fptoui double %val to i64
  %splat.splatinsert = insertelement <2 x i64> undef, i64 %conv, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %splat.splat
}

define <2 x i64> @spltMemValConvdtoull(ptr nocapture readonly %ptr) {
; P9BE-LABEL: spltMemValConvdtoull:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    lxvdsx vs0, 0, r3
; P9BE-NEXT:    xvcvdpuxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: spltMemValConvdtoull:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    lxvdsx vs0, 0, r3
; P9LE-NEXT:    xvcvdpuxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: spltMemValConvdtoull:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    lxvdsx vs0, 0, r3
; P8BE-NEXT:    xvcvdpuxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: spltMemValConvdtoull:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    lxvdsx vs0, 0, r3
; P8LE-NEXT:    xvcvdpuxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %0 = load double, ptr %ptr, align 8
  %conv = fptoui double %0 to i64
  %splat.splatinsert = insertelement <2 x i64> undef, i64 %conv, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %splat.splat
}

; Some additional patterns that come up in real code.
define dso_local <2 x double> @sint_to_fp_widen02(<4 x i32> %a) {
; P9BE-LABEL: sint_to_fp_widen02:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xvcvsxwdp v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: sint_to_fp_widen02:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxsldwi vs0, v2, v2, 1
; P9LE-NEXT:    xvcvsxwdp v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: sint_to_fp_widen02:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xvcvsxwdp v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: sint_to_fp_widen02:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxsldwi vs0, v2, v2, 1
; P8LE-NEXT:    xvcvsxwdp v2, vs0
; P8LE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 0
  %conv = sitofp i32 %vecext to double
  %vecinit = insertelement <2 x double> undef, double %conv, i32 0
  %vecext1 = extractelement <4 x i32> %a, i32 2
  %conv2 = sitofp i32 %vecext1 to double
  %vecinit3 = insertelement <2 x double> %vecinit, double %conv2, i32 1
  ret <2 x double> %vecinit3
}

define dso_local <2 x double> @sint_to_fp_widen13(<4 x i32> %a) {
; P9BE-LABEL: sint_to_fp_widen13:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxsldwi vs0, v2, v2, 1
; P9BE-NEXT:    xvcvsxwdp v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: sint_to_fp_widen13:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xvcvsxwdp v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: sint_to_fp_widen13:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxsldwi vs0, v2, v2, 1
; P8BE-NEXT:    xvcvsxwdp v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: sint_to_fp_widen13:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xvcvsxwdp v2, v2
; P8LE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 1
  %conv = sitofp i32 %vecext to double
  %vecinit = insertelement <2 x double> undef, double %conv, i32 0
  %vecext1 = extractelement <4 x i32> %a, i32 3
  %conv2 = sitofp i32 %vecext1 to double
  %vecinit3 = insertelement <2 x double> %vecinit, double %conv2, i32 1
  ret <2 x double> %vecinit3
}

define dso_local <2 x double> @uint_to_fp_widen02(<4 x i32> %a) {
; P9BE-LABEL: uint_to_fp_widen02:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xvcvuxwdp v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: uint_to_fp_widen02:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxsldwi vs0, v2, v2, 1
; P9LE-NEXT:    xvcvuxwdp v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: uint_to_fp_widen02:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xvcvuxwdp v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: uint_to_fp_widen02:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxsldwi vs0, v2, v2, 1
; P8LE-NEXT:    xvcvuxwdp v2, vs0
; P8LE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 0
  %conv = uitofp i32 %vecext to double
  %vecinit = insertelement <2 x double> undef, double %conv, i32 0
  %vecext1 = extractelement <4 x i32> %a, i32 2
  %conv2 = uitofp i32 %vecext1 to double
  %vecinit3 = insertelement <2 x double> %vecinit, double %conv2, i32 1
  ret <2 x double> %vecinit3
}

define dso_local <2 x double> @uint_to_fp_widen13(<4 x i32> %a) {
; P9BE-LABEL: uint_to_fp_widen13:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxsldwi vs0, v2, v2, 1
; P9BE-NEXT:    xvcvuxwdp v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: uint_to_fp_widen13:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xvcvuxwdp v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: uint_to_fp_widen13:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxsldwi vs0, v2, v2, 1
; P8BE-NEXT:    xvcvuxwdp v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: uint_to_fp_widen13:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xvcvuxwdp v2, v2
; P8LE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 1
  %conv = uitofp i32 %vecext to double
  %vecinit = insertelement <2 x double> undef, double %conv, i32 0
  %vecext1 = extractelement <4 x i32> %a, i32 3
  %conv2 = uitofp i32 %vecext1 to double
  %vecinit3 = insertelement <2 x double> %vecinit, double %conv2, i32 1
  ret <2 x double> %vecinit3
}

define dso_local <2 x double> @fp_extend01(<4 x float> %a) {
; P9BE-LABEL: fp_extend01:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxmrghw vs0, v2, v2
; P9BE-NEXT:    xvcvspdp v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fp_extend01:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxmrglw vs0, v2, v2
; P9LE-NEXT:    xvcvspdp v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fp_extend01:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxmrghw vs0, v2, v2
; P8BE-NEXT:    xvcvspdp v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fp_extend01:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxmrglw vs0, v2, v2
; P8LE-NEXT:    xvcvspdp v2, vs0
; P8LE-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %a, i32 0
  %conv = fpext float %vecext to double
  %vecinit = insertelement <2 x double> undef, double %conv, i32 0
  %vecext1 = extractelement <4 x float> %a, i32 1
  %conv2 = fpext float %vecext1 to double
  %vecinit3 = insertelement <2 x double> %vecinit, double %conv2, i32 1
  ret <2 x double> %vecinit3
}

define dso_local <2 x double> @fp_extend10(<4 x float> %a) {
; P9BE-LABEL: fp_extend10:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxmrghw vs0, v2, v2
; P9BE-NEXT:    xvcvspdp vs0, vs0
; P9BE-NEXT:    xxswapd v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fp_extend10:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxmrglw vs0, v2, v2
; P9LE-NEXT:    xvcvspdp vs0, vs0
; P9LE-NEXT:    xxswapd v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fp_extend10:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxmrghw vs0, v2, v2
; P8BE-NEXT:    xvcvspdp vs0, vs0
; P8BE-NEXT:    xxswapd v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fp_extend10:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxmrglw vs0, v2, v2
; P8LE-NEXT:    xvcvspdp vs0, vs0
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %a, i32 1
  %conv = fpext float %vecext to double
  %vecinit = insertelement <2 x double> undef, double %conv, i32 0
  %vecext1 = extractelement <4 x float> %a, i32 0
  %conv2 = fpext float %vecext1 to double
  %vecinit3 = insertelement <2 x double> %vecinit, double %conv2, i32 1
  ret <2 x double> %vecinit3
}

define dso_local <2 x double> @fp_extend02(<4 x float> %a) {
; P9BE-LABEL: fp_extend02:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xvcvspdp v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fp_extend02:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxsldwi vs0, v2, v2, 1
; P9LE-NEXT:    xvcvspdp v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fp_extend02:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xvcvspdp v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fp_extend02:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxsldwi vs0, v2, v2, 1
; P8LE-NEXT:    xvcvspdp v2, vs0
; P8LE-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %a, i32 0
  %conv = fpext float %vecext to double
  %vecinit = insertelement <2 x double> undef, double %conv, i32 0
  %vecext1 = extractelement <4 x float> %a, i32 2
  %conv2 = fpext float %vecext1 to double
  %vecinit3 = insertelement <2 x double> %vecinit, double %conv2, i32 1
  ret <2 x double> %vecinit3
}

define dso_local <2 x double> @fp_extend13(<4 x float> %a) {
; P9BE-LABEL: fp_extend13:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxsldwi vs0, v2, v2, 1
; P9BE-NEXT:    xvcvspdp v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fp_extend13:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xvcvspdp v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fp_extend13:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxsldwi vs0, v2, v2, 1
; P8BE-NEXT:    xvcvspdp v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fp_extend13:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xvcvspdp v2, v2
; P8LE-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %a, i32 1
  %conv = fpext float %vecext to double
  %vecinit = insertelement <2 x double> undef, double %conv, i32 0
  %vecext1 = extractelement <4 x float> %a, i32 3
  %conv2 = fpext float %vecext1 to double
  %vecinit3 = insertelement <2 x double> %vecinit, double %conv2, i32 1
  ret <2 x double> %vecinit3
}

define dso_local <2 x double> @fp_extend23(<4 x float> %a) {
; P9BE-LABEL: fp_extend23:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxmrglw vs0, v2, v2
; P9BE-NEXT:    xvcvspdp v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fp_extend23:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxmrghw vs0, v2, v2
; P9LE-NEXT:    xvcvspdp v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fp_extend23:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxmrglw vs0, v2, v2
; P8BE-NEXT:    xvcvspdp v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fp_extend23:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxmrghw vs0, v2, v2
; P8LE-NEXT:    xvcvspdp v2, vs0
; P8LE-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %a, i32 2
  %conv = fpext float %vecext to double
  %vecinit = insertelement <2 x double> undef, double %conv, i32 0
  %vecext1 = extractelement <4 x float> %a, i32 3
  %conv2 = fpext float %vecext1 to double
  %vecinit3 = insertelement <2 x double> %vecinit, double %conv2, i32 1
  ret <2 x double> %vecinit3
}

define dso_local <2 x double> @fp_extend32(<4 x float> %a) {
; P9BE-LABEL: fp_extend32:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxmrglw vs0, v2, v2
; P9BE-NEXT:    xvcvspdp vs0, vs0
; P9BE-NEXT:    xxswapd v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fp_extend32:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxmrghw vs0, v2, v2
; P9LE-NEXT:    xvcvspdp vs0, vs0
; P9LE-NEXT:    xxswapd v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fp_extend32:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxmrglw vs0, v2, v2
; P8BE-NEXT:    xvcvspdp vs0, vs0
; P8BE-NEXT:    xxswapd v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fp_extend32:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxmrghw vs0, v2, v2
; P8LE-NEXT:    xvcvspdp vs0, vs0
; P8LE-NEXT:    xxswapd v2, vs0
; P8LE-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %a, i32 3
  %conv = fpext float %vecext to double
  %vecinit = insertelement <2 x double> undef, double %conv, i32 0
  %vecext1 = extractelement <4 x float> %a, i32 2
  %conv2 = fpext float %vecext1 to double
  %vecinit3 = insertelement <2 x double> %vecinit, double %conv2, i32 1
  ret <2 x double> %vecinit3
}

define dso_local <2 x double> @fp_extend_two00(<4 x float> %a, <4 x float> %b) {
; P9BE-LABEL: fp_extend_two00:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxmrghd vs0, v2, v3
; P9BE-NEXT:    xvcvspdp v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fp_extend_two00:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxmrgld vs0, v3, v2
; P9LE-NEXT:    xxsldwi vs0, vs0, vs0, 1
; P9LE-NEXT:    xvcvspdp v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fp_extend_two00:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxmrghd vs0, v2, v3
; P8BE-NEXT:    xvcvspdp v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fp_extend_two00:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxmrgld vs0, v3, v2
; P8LE-NEXT:    xxsldwi vs0, vs0, vs0, 1
; P8LE-NEXT:    xvcvspdp v2, vs0
; P8LE-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %a, i32 0
  %conv = fpext float %vecext to double
  %vecinit = insertelement <2 x double> undef, double %conv, i32 0
  %vecext1 = extractelement <4 x float> %b, i32 0
  %conv2 = fpext float %vecext1 to double
  %vecinit3 = insertelement <2 x double> %vecinit, double %conv2, i32 1
  ret <2 x double> %vecinit3
}

define dso_local <2 x double> @fp_extend_two33(<4 x float> %a, <4 x float> %b) {
; P9BE-LABEL: fp_extend_two33:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxmrgld vs0, v2, v3
; P9BE-NEXT:    xxsldwi vs0, vs0, vs0, 1
; P9BE-NEXT:    xvcvspdp v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: fp_extend_two33:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxmrghd vs0, v3, v2
; P9LE-NEXT:    xvcvspdp v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: fp_extend_two33:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxmrgld vs0, v2, v3
; P8BE-NEXT:    xxsldwi vs0, vs0, vs0, 1
; P8BE-NEXT:    xvcvspdp v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: fp_extend_two33:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxmrghd vs0, v3, v2
; P8LE-NEXT:    xvcvspdp v2, vs0
; P8LE-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %a, i32 3
  %conv = fpext float %vecext to double
  %vecinit = insertelement <2 x double> undef, double %conv, i32 0
  %vecext1 = extractelement <4 x float> %b, i32 3
  %conv2 = fpext float %vecext1 to double
  %vecinit3 = insertelement <2 x double> %vecinit, double %conv2, i32 1
  ret <2 x double> %vecinit3
}

define dso_local <2 x i64> @test_xvcvspsxds13(<4 x float> %a) local_unnamed_addr {
; P9BE-LABEL: test_xvcvspsxds13:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxsldwi vs0, v2, v2, 1
; P9BE-NEXT:    xvcvspsxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: test_xvcvspsxds13:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xvcvspsxds v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: test_xvcvspsxds13:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxsldwi vs0, v2, v2, 1
; P8BE-NEXT:    xvcvspsxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: test_xvcvspsxds13:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xvcvspsxds v2, v2
; P8LE-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %a, i32 1
  %conv = fptosi float %vecext to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %vecext1 = extractelement <4 x float> %a, i32 3
  %conv2 = fptosi float %vecext1 to i64
  %vecinit3 = insertelement <2 x i64> %vecinit, i64 %conv2, i32 1
  ret <2 x i64> %vecinit3
}

define dso_local <2 x i64> @test_xvcvspuxds13(<4 x float> %a) local_unnamed_addr {
; P9BE-LABEL: test_xvcvspuxds13:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xxsldwi vs0, v2, v2, 1
; P9BE-NEXT:    xvcvspuxds v2, vs0
; P9BE-NEXT:    blr
;
; P9LE-LABEL: test_xvcvspuxds13:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xvcvspuxds v2, v2
; P9LE-NEXT:    blr
;
; P8BE-LABEL: test_xvcvspuxds13:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xxsldwi vs0, v2, v2, 1
; P8BE-NEXT:    xvcvspuxds v2, vs0
; P8BE-NEXT:    blr
;
; P8LE-LABEL: test_xvcvspuxds13:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xvcvspuxds v2, v2
; P8LE-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %a, i32 1
  %conv = fptoui float %vecext to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %vecext1 = extractelement <4 x float> %a, i32 3
  %conv2 = fptoui float %vecext1 to i64
  %vecinit3 = insertelement <2 x i64> %vecinit, i64 %conv2, i32 1
  ret <2 x i64> %vecinit3
}

define dso_local <2 x i64> @test_xvcvspsxds02(<4 x float> %a) local_unnamed_addr {
; P9BE-LABEL: test_xvcvspsxds02:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xvcvspsxds v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: test_xvcvspsxds02:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxsldwi vs0, v2, v2, 1
; P9LE-NEXT:    xvcvspsxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: test_xvcvspsxds02:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xvcvspsxds v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: test_xvcvspsxds02:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxsldwi vs0, v2, v2, 1
; P8LE-NEXT:    xvcvspsxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %a, i32 0
  %conv = fptosi float %vecext to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %vecext1 = extractelement <4 x float> %a, i32 2
  %conv2 = fptosi float %vecext1 to i64
  %vecinit3 = insertelement <2 x i64> %vecinit, i64 %conv2, i32 1
  ret <2 x i64> %vecinit3
}

define dso_local <2 x i64> @test_xvcvspuxds02(<4 x float> %a) local_unnamed_addr {
; P9BE-LABEL: test_xvcvspuxds02:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    xvcvspuxds v2, v2
; P9BE-NEXT:    blr
;
; P9LE-LABEL: test_xvcvspuxds02:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    xxsldwi vs0, v2, v2, 1
; P9LE-NEXT:    xvcvspuxds v2, vs0
; P9LE-NEXT:    blr
;
; P8BE-LABEL: test_xvcvspuxds02:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    xvcvspuxds v2, v2
; P8BE-NEXT:    blr
;
; P8LE-LABEL: test_xvcvspuxds02:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    xxsldwi vs0, v2, v2, 1
; P8LE-NEXT:    xvcvspuxds v2, vs0
; P8LE-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %a, i32 0
  %conv = fptoui float %vecext to i64
  %vecinit = insertelement <2 x i64> undef, i64 %conv, i32 0
  %vecext1 = extractelement <4 x float> %a, i32 2
  %conv2 = fptoui float %vecext1 to i64
  %vecinit3 = insertelement <2 x i64> %vecinit, i64 %conv2, i32 1
  ret <2 x i64> %vecinit3
}
