; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mcpu=ppc -mtriple=powerpc64-unknown-linux-gnu < %s | FileCheck %s

define i8 @atomicrmw_uinc_wrap_i8(ptr %ptr, i8 %val) {
; CHECK-LABEL: atomicrmw_uinc_wrap_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sync
; CHECK-NEXT:    rldicr 5, 3, 0, 61
; CHECK-NEXT:    not 3, 3
; CHECK-NEXT:    li 6, 255
; CHECK-NEXT:    lwz 7, 0(5)
; CHECK-NEXT:    rlwinm 3, 3, 3, 27, 28
; CHECK-NEXT:    slw 6, 6, 3
; CHECK-NEXT:    not 6, 6
; CHECK-NEXT:    clrlwi 4, 4, 24
; CHECK-NEXT:  .LBB0_1: # %atomicrmw.start
; CHECK-NEXT:    # =>This Loop Header: Depth=1
; CHECK-NEXT:    # Child Loop BB0_4 Depth 2
; CHECK-NEXT:    srw 8, 7, 3
; CHECK-NEXT:    clrlwi 9, 8, 24
; CHECK-NEXT:    cmplw 9, 4
; CHECK-NEXT:    li 9, 0
; CHECK-NEXT:    bge 0, .LBB0_3
; CHECK-NEXT:  # %bb.2: # %atomicrmw.start
; CHECK-NEXT:    #
; CHECK-NEXT:    addi 9, 8, 1
; CHECK-NEXT:  .LBB0_3: # %atomicrmw.start
; CHECK-NEXT:    #
; CHECK-NEXT:    clrlwi 8, 9, 24
; CHECK-NEXT:    slw 8, 8, 3
; CHECK-NEXT:    and 9, 7, 6
; CHECK-NEXT:    or 9, 9, 8
; CHECK-NEXT:  .LBB0_4: # %cmpxchg.start
; CHECK-NEXT:    # Parent Loop BB0_1 Depth=1
; CHECK-NEXT:    # => This Inner Loop Header: Depth=2
; CHECK-NEXT:    lwarx 8, 0, 5
; CHECK-NEXT:    cmplw 8, 7
; CHECK-NEXT:    bne- 0, .LBB0_7
; CHECK-NEXT:  # %bb.5: # %cmpxchg.fencedstore
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 9, 0, 5
; CHECK-NEXT:    creqv 20, 20, 20
; CHECK-NEXT:    bne- 0, .LBB0_4
; CHECK-NEXT:  # %bb.6: # %cmpxchg.end
; CHECK-NEXT:    #
; CHECK-NEXT:    mr 7, 8
; CHECK-NEXT:    bc 4, 20, .LBB0_1
; CHECK-NEXT:    b .LBB0_8
; CHECK-NEXT:  .LBB0_7: # %cmpxchg.nostore
; CHECK-NEXT:    #
; CHECK-NEXT:    mr 7, 8
; CHECK-NEXT:    b .LBB0_1
; CHECK-NEXT:  .LBB0_8: # %atomicrmw.end
; CHECK-NEXT:    srw 3, 8, 3
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    blr
  %result = atomicrmw uinc_wrap ptr %ptr, i8 %val seq_cst
  ret i8 %result
}

define i16 @atomicrmw_uinc_wrap_i16(ptr %ptr, i16 %val) {
; CHECK-LABEL: atomicrmw_uinc_wrap_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sync
; CHECK-NEXT:    rldicr 5, 3, 0, 61
; CHECK-NEXT:    clrlwi 3, 3, 30
; CHECK-NEXT:    lis 6, 0
; CHECK-NEXT:    xori 3, 3, 2
; CHECK-NEXT:    lwz 7, 0(5)
; CHECK-NEXT:    ori 6, 6, 65535
; CHECK-NEXT:    slwi 3, 3, 3
; CHECK-NEXT:    slw 6, 6, 3
; CHECK-NEXT:    not 6, 6
; CHECK-NEXT:    clrlwi 4, 4, 16
; CHECK-NEXT:  .LBB1_1: # %atomicrmw.start
; CHECK-NEXT:    # =>This Loop Header: Depth=1
; CHECK-NEXT:    # Child Loop BB1_4 Depth 2
; CHECK-NEXT:    srw 8, 7, 3
; CHECK-NEXT:    clrlwi 9, 8, 16
; CHECK-NEXT:    cmplw 9, 4
; CHECK-NEXT:    li 9, 0
; CHECK-NEXT:    bge 0, .LBB1_3
; CHECK-NEXT:  # %bb.2: # %atomicrmw.start
; CHECK-NEXT:    #
; CHECK-NEXT:    addi 9, 8, 1
; CHECK-NEXT:  .LBB1_3: # %atomicrmw.start
; CHECK-NEXT:    #
; CHECK-NEXT:    clrlwi 8, 9, 16
; CHECK-NEXT:    slw 8, 8, 3
; CHECK-NEXT:    and 9, 7, 6
; CHECK-NEXT:    or 9, 9, 8
; CHECK-NEXT:  .LBB1_4: # %cmpxchg.start
; CHECK-NEXT:    # Parent Loop BB1_1 Depth=1
; CHECK-NEXT:    # => This Inner Loop Header: Depth=2
; CHECK-NEXT:    lwarx 8, 0, 5
; CHECK-NEXT:    cmplw 8, 7
; CHECK-NEXT:    bne- 0, .LBB1_7
; CHECK-NEXT:  # %bb.5: # %cmpxchg.fencedstore
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 9, 0, 5
; CHECK-NEXT:    creqv 20, 20, 20
; CHECK-NEXT:    bne- 0, .LBB1_4
; CHECK-NEXT:  # %bb.6: # %cmpxchg.end
; CHECK-NEXT:    #
; CHECK-NEXT:    mr 7, 8
; CHECK-NEXT:    bc 4, 20, .LBB1_1
; CHECK-NEXT:    b .LBB1_8
; CHECK-NEXT:  .LBB1_7: # %cmpxchg.nostore
; CHECK-NEXT:    #
; CHECK-NEXT:    mr 7, 8
; CHECK-NEXT:    b .LBB1_1
; CHECK-NEXT:  .LBB1_8: # %atomicrmw.end
; CHECK-NEXT:    srw 3, 8, 3
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    blr
  %result = atomicrmw uinc_wrap ptr %ptr, i16 %val seq_cst
  ret i16 %result
}

define i32 @atomicrmw_uinc_wrap_i32(ptr %ptr, i32 %val) {
; CHECK-LABEL: atomicrmw_uinc_wrap_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sync
; CHECK-NEXT:    lwz 6, 0(3)
; CHECK-NEXT:  .LBB2_1: # %atomicrmw.start
; CHECK-NEXT:    # =>This Loop Header: Depth=1
; CHECK-NEXT:    # Child Loop BB2_3 Depth 2
; CHECK-NEXT:    cmplw 6, 4
; CHECK-NEXT:    li 7, 0
; CHECK-NEXT:    bge 0, .LBB2_3
; CHECK-NEXT:  # %bb.2: # %atomicrmw.start
; CHECK-NEXT:    #
; CHECK-NEXT:    addi 7, 6, 1
; CHECK-NEXT:  .LBB2_3: # %cmpxchg.start
; CHECK-NEXT:    # Parent Loop BB2_1 Depth=1
; CHECK-NEXT:    # => This Inner Loop Header: Depth=2
; CHECK-NEXT:    lwarx 5, 0, 3
; CHECK-NEXT:    cmplw 5, 6
; CHECK-NEXT:    bne- 0, .LBB2_6
; CHECK-NEXT:  # %bb.4: # %cmpxchg.fencedstore
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 7, 0, 3
; CHECK-NEXT:    creqv 20, 20, 20
; CHECK-NEXT:    bne- 0, .LBB2_3
; CHECK-NEXT:  # %bb.5: # %cmpxchg.end
; CHECK-NEXT:    #
; CHECK-NEXT:    mr 6, 5
; CHECK-NEXT:    bc 4, 20, .LBB2_1
; CHECK-NEXT:    b .LBB2_7
; CHECK-NEXT:  .LBB2_6: # %cmpxchg.nostore
; CHECK-NEXT:    #
; CHECK-NEXT:    mr 6, 5
; CHECK-NEXT:    b .LBB2_1
; CHECK-NEXT:  .LBB2_7: # %atomicrmw.end
; CHECK-NEXT:    mr 3, 5
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    blr
  %result = atomicrmw uinc_wrap ptr %ptr, i32 %val seq_cst
  ret i32 %result
}

define i64 @atomicrmw_uinc_wrap_i64(ptr %ptr, i64 %val) {
; CHECK-LABEL: atomicrmw_uinc_wrap_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sync
; CHECK-NEXT:    ld 6, 0(3)
; CHECK-NEXT:  .LBB3_1: # %atomicrmw.start
; CHECK-NEXT:    # =>This Loop Header: Depth=1
; CHECK-NEXT:    # Child Loop BB3_3 Depth 2
; CHECK-NEXT:    cmpld 6, 4
; CHECK-NEXT:    li 7, 0
; CHECK-NEXT:    bge 0, .LBB3_3
; CHECK-NEXT:  # %bb.2: # %atomicrmw.start
; CHECK-NEXT:    #
; CHECK-NEXT:    addi 7, 6, 1
; CHECK-NEXT:  .LBB3_3: # %cmpxchg.start
; CHECK-NEXT:    # Parent Loop BB3_1 Depth=1
; CHECK-NEXT:    # => This Inner Loop Header: Depth=2
; CHECK-NEXT:    ldarx 5, 0, 3
; CHECK-NEXT:    cmpld 5, 6
; CHECK-NEXT:    bne- 0, .LBB3_6
; CHECK-NEXT:  # %bb.4: # %cmpxchg.fencedstore
; CHECK-NEXT:    #
; CHECK-NEXT:    stdcx. 7, 0, 3
; CHECK-NEXT:    creqv 20, 20, 20
; CHECK-NEXT:    bne- 0, .LBB3_3
; CHECK-NEXT:  # %bb.5: # %cmpxchg.end
; CHECK-NEXT:    #
; CHECK-NEXT:    mr 6, 5
; CHECK-NEXT:    bc 4, 20, .LBB3_1
; CHECK-NEXT:    b .LBB3_7
; CHECK-NEXT:  .LBB3_6: # %cmpxchg.nostore
; CHECK-NEXT:    #
; CHECK-NEXT:    mr 6, 5
; CHECK-NEXT:    b .LBB3_1
; CHECK-NEXT:  .LBB3_7: # %atomicrmw.end
; CHECK-NEXT:    mr 3, 5
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    blr
  %result = atomicrmw uinc_wrap ptr %ptr, i64 %val seq_cst
  ret i64 %result
}

define i8 @atomicrmw_udec_wrap_i8(ptr %ptr, i8 %val) {
; CHECK-LABEL: atomicrmw_udec_wrap_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sync
; CHECK-NEXT:    rldicr 5, 3, 0, 61
; CHECK-NEXT:    not 3, 3
; CHECK-NEXT:    li 6, 255
; CHECK-NEXT:    lwz 8, 0(5)
; CHECK-NEXT:    rlwinm 3, 3, 3, 27, 28
; CHECK-NEXT:    slw 6, 6, 3
; CHECK-NEXT:    not 6, 6
; CHECK-NEXT:    clrlwi 7, 4, 24
; CHECK-NEXT:  .LBB4_1: # %atomicrmw.start
; CHECK-NEXT:    # =>This Loop Header: Depth=1
; CHECK-NEXT:    # Child Loop BB4_4 Depth 2
; CHECK-NEXT:    srw 9, 8, 3
; CHECK-NEXT:    andi. 10, 9, 255
; CHECK-NEXT:    cmplw 1, 10, 7
; CHECK-NEXT:    cror 20, 2, 5
; CHECK-NEXT:    mr 10, 4
; CHECK-NEXT:    bc 12, 20, .LBB4_3
; CHECK-NEXT:  # %bb.2: # %atomicrmw.start
; CHECK-NEXT:    #
; CHECK-NEXT:    addi 10, 9, -1
; CHECK-NEXT:  .LBB4_3: # %atomicrmw.start
; CHECK-NEXT:    #
; CHECK-NEXT:    clrlwi 9, 10, 24
; CHECK-NEXT:    slw 9, 9, 3
; CHECK-NEXT:    and 10, 8, 6
; CHECK-NEXT:    or 10, 10, 9
; CHECK-NEXT:  .LBB4_4: # %cmpxchg.start
; CHECK-NEXT:    # Parent Loop BB4_1 Depth=1
; CHECK-NEXT:    # => This Inner Loop Header: Depth=2
; CHECK-NEXT:    lwarx 9, 0, 5
; CHECK-NEXT:    cmplw 9, 8
; CHECK-NEXT:    bne- 0, .LBB4_7
; CHECK-NEXT:  # %bb.5: # %cmpxchg.fencedstore
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 10, 0, 5
; CHECK-NEXT:    creqv 20, 20, 20
; CHECK-NEXT:    bne- 0, .LBB4_4
; CHECK-NEXT:  # %bb.6: # %cmpxchg.end
; CHECK-NEXT:    #
; CHECK-NEXT:    mr 8, 9
; CHECK-NEXT:    bc 4, 20, .LBB4_1
; CHECK-NEXT:    b .LBB4_8
; CHECK-NEXT:  .LBB4_7: # %cmpxchg.nostore
; CHECK-NEXT:    #
; CHECK-NEXT:    mr 8, 9
; CHECK-NEXT:    b .LBB4_1
; CHECK-NEXT:  .LBB4_8: # %atomicrmw.end
; CHECK-NEXT:    srw 3, 9, 3
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    blr
  %result = atomicrmw udec_wrap ptr %ptr, i8 %val seq_cst
  ret i8 %result
}

define i16 @atomicrmw_udec_wrap_i16(ptr %ptr, i16 %val) {
; CHECK-LABEL: atomicrmw_udec_wrap_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sync
; CHECK-NEXT:    rldicr 5, 3, 0, 61
; CHECK-NEXT:    clrlwi 3, 3, 30
; CHECK-NEXT:    lis 6, 0
; CHECK-NEXT:    xori 3, 3, 2
; CHECK-NEXT:    lwz 8, 0(5)
; CHECK-NEXT:    ori 6, 6, 65535
; CHECK-NEXT:    slwi 3, 3, 3
; CHECK-NEXT:    slw 6, 6, 3
; CHECK-NEXT:    not 6, 6
; CHECK-NEXT:    clrlwi 7, 4, 16
; CHECK-NEXT:  .LBB5_1: # %atomicrmw.start
; CHECK-NEXT:    # =>This Loop Header: Depth=1
; CHECK-NEXT:    # Child Loop BB5_4 Depth 2
; CHECK-NEXT:    srw 9, 8, 3
; CHECK-NEXT:    andi. 10, 9, 65535
; CHECK-NEXT:    cmplw 1, 10, 7
; CHECK-NEXT:    cror 20, 2, 5
; CHECK-NEXT:    mr 10, 4
; CHECK-NEXT:    bc 12, 20, .LBB5_3
; CHECK-NEXT:  # %bb.2: # %atomicrmw.start
; CHECK-NEXT:    #
; CHECK-NEXT:    addi 10, 9, -1
; CHECK-NEXT:  .LBB5_3: # %atomicrmw.start
; CHECK-NEXT:    #
; CHECK-NEXT:    clrlwi 9, 10, 16
; CHECK-NEXT:    slw 9, 9, 3
; CHECK-NEXT:    and 10, 8, 6
; CHECK-NEXT:    or 10, 10, 9
; CHECK-NEXT:  .LBB5_4: # %cmpxchg.start
; CHECK-NEXT:    # Parent Loop BB5_1 Depth=1
; CHECK-NEXT:    # => This Inner Loop Header: Depth=2
; CHECK-NEXT:    lwarx 9, 0, 5
; CHECK-NEXT:    cmplw 9, 8
; CHECK-NEXT:    bne- 0, .LBB5_7
; CHECK-NEXT:  # %bb.5: # %cmpxchg.fencedstore
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 10, 0, 5
; CHECK-NEXT:    creqv 20, 20, 20
; CHECK-NEXT:    bne- 0, .LBB5_4
; CHECK-NEXT:  # %bb.6: # %cmpxchg.end
; CHECK-NEXT:    #
; CHECK-NEXT:    mr 8, 9
; CHECK-NEXT:    bc 4, 20, .LBB5_1
; CHECK-NEXT:    b .LBB5_8
; CHECK-NEXT:  .LBB5_7: # %cmpxchg.nostore
; CHECK-NEXT:    #
; CHECK-NEXT:    mr 8, 9
; CHECK-NEXT:    b .LBB5_1
; CHECK-NEXT:  .LBB5_8: # %atomicrmw.end
; CHECK-NEXT:    srw 3, 9, 3
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    blr
  %result = atomicrmw udec_wrap ptr %ptr, i16 %val seq_cst
  ret i16 %result
}

define i32 @atomicrmw_udec_wrap_i32(ptr %ptr, i32 %val) {
; CHECK-LABEL: atomicrmw_udec_wrap_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sync
; CHECK-NEXT:    lwz 6, 0(3)
; CHECK-NEXT:  .LBB6_1: # %atomicrmw.start
; CHECK-NEXT:    # =>This Loop Header: Depth=1
; CHECK-NEXT:    # Child Loop BB6_4 Depth 2
; CHECK-NEXT:    cmpwi 6, 0
; CHECK-NEXT:    mr 7, 4
; CHECK-NEXT:    bc 12, 2, .LBB6_4
; CHECK-NEXT:  # %bb.2: # %atomicrmw.start
; CHECK-NEXT:    #
; CHECK-NEXT:    cmplw 6, 4
; CHECK-NEXT:    mr 7, 4
; CHECK-NEXT:    bc 12, 1, .LBB6_4
; CHECK-NEXT:  # %bb.3: # %atomicrmw.start
; CHECK-NEXT:    #
; CHECK-NEXT:    addi 7, 6, -1
; CHECK-NEXT:  .LBB6_4: # %cmpxchg.start
; CHECK-NEXT:    # Parent Loop BB6_1 Depth=1
; CHECK-NEXT:    # => This Inner Loop Header: Depth=2
; CHECK-NEXT:    lwarx 5, 0, 3
; CHECK-NEXT:    cmplw 5, 6
; CHECK-NEXT:    bne- 0, .LBB6_7
; CHECK-NEXT:  # %bb.5: # %cmpxchg.fencedstore
; CHECK-NEXT:    #
; CHECK-NEXT:    stwcx. 7, 0, 3
; CHECK-NEXT:    creqv 20, 20, 20
; CHECK-NEXT:    bne- 0, .LBB6_4
; CHECK-NEXT:  # %bb.6: # %cmpxchg.end
; CHECK-NEXT:    #
; CHECK-NEXT:    mr 6, 5
; CHECK-NEXT:    bc 4, 20, .LBB6_1
; CHECK-NEXT:    b .LBB6_8
; CHECK-NEXT:  .LBB6_7: # %cmpxchg.nostore
; CHECK-NEXT:    #
; CHECK-NEXT:    mr 6, 5
; CHECK-NEXT:    b .LBB6_1
; CHECK-NEXT:  .LBB6_8: # %atomicrmw.end
; CHECK-NEXT:    mr 3, 5
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    blr
  %result = atomicrmw udec_wrap ptr %ptr, i32 %val seq_cst
  ret i32 %result
}

define i64 @atomicrmw_udec_wrap_i64(ptr %ptr, i64 %val) {
; CHECK-LABEL: atomicrmw_udec_wrap_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sync
; CHECK-NEXT:    ld 6, 0(3)
; CHECK-NEXT:  .LBB7_1: # %atomicrmw.start
; CHECK-NEXT:    # =>This Loop Header: Depth=1
; CHECK-NEXT:    # Child Loop BB7_4 Depth 2
; CHECK-NEXT:    cmpdi 6, 0
; CHECK-NEXT:    mr 7, 4
; CHECK-NEXT:    bc 12, 2, .LBB7_4
; CHECK-NEXT:  # %bb.2: # %atomicrmw.start
; CHECK-NEXT:    #
; CHECK-NEXT:    cmpld 6, 4
; CHECK-NEXT:    mr 7, 4
; CHECK-NEXT:    bc 12, 1, .LBB7_4
; CHECK-NEXT:  # %bb.3: # %atomicrmw.start
; CHECK-NEXT:    #
; CHECK-NEXT:    addi 7, 6, -1
; CHECK-NEXT:  .LBB7_4: # %cmpxchg.start
; CHECK-NEXT:    # Parent Loop BB7_1 Depth=1
; CHECK-NEXT:    # => This Inner Loop Header: Depth=2
; CHECK-NEXT:    ldarx 5, 0, 3
; CHECK-NEXT:    cmpld 5, 6
; CHECK-NEXT:    bne- 0, .LBB7_7
; CHECK-NEXT:  # %bb.5: # %cmpxchg.fencedstore
; CHECK-NEXT:    #
; CHECK-NEXT:    stdcx. 7, 0, 3
; CHECK-NEXT:    creqv 20, 20, 20
; CHECK-NEXT:    bne- 0, .LBB7_4
; CHECK-NEXT:  # %bb.6: # %cmpxchg.end
; CHECK-NEXT:    #
; CHECK-NEXT:    mr 6, 5
; CHECK-NEXT:    bc 4, 20, .LBB7_1
; CHECK-NEXT:    b .LBB7_8
; CHECK-NEXT:  .LBB7_7: # %cmpxchg.nostore
; CHECK-NEXT:    #
; CHECK-NEXT:    mr 6, 5
; CHECK-NEXT:    b .LBB7_1
; CHECK-NEXT:  .LBB7_8: # %atomicrmw.end
; CHECK-NEXT:    mr 3, 5
; CHECK-NEXT:    lwsync
; CHECK-NEXT:    blr
  %result = atomicrmw udec_wrap ptr %ptr, i64 %val seq_cst
  ret i64 %result
}
