; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=mipsel < %s | FileCheck %s
; RUN: llc -mtriple=mips -mcpu=mips32r6 -mattr=micromips -relocation-model=pic < %s -asm-show-inst | FileCheck %s -check-prefix=MMR6

@g1 = external global i32

define i32 @seteq0(i32 %a) {
; CHECK-LABEL: seteq0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    sltiu $2, $4, 1
;
; MMR6-LABEL: seteq0:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    sltiu $2, $4, 1 # <MCInst #[[#MCINST1:]] SLTiu_MM
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:A0>
; MMR6-NEXT:    # <MCOperand Imm:1>>
; MMR6-NEXT:    jrc $ra # <MCInst #[[#MCINST2:]] JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:RA>>
entry:
  %cmp = icmp eq i32 %a, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @setne0(i32 %a) {
; CHECK-LABEL: setne0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    sltu $2, $zero, $4
;
; MMR6-LABEL: setne0:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    sltu $2, $zero, $4 # <MCInst #[[#MCINST3:]] SLTu_MM
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:ZERO>
; MMR6-NEXT:    # <MCOperand Reg:A0>>
; MMR6-NEXT:    jrc $ra # <MCInst #[[#MCINST2]] JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:RA>>
entry:
  %cmp = icmp ne i32 %a, 0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define void @slti_beq0(i32 %a) {
; CHECK-LABEL: slti_beq0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    slti $1, $4, -32768
; CHECK-NEXT:    beqz $1, $BB2_2
; CHECK-NEXT:    nop
; CHECK-NEXT:  # %bb.1: # %if.then
; CHECK-NEXT:    lui $1, %hi(g1)
; CHECK-NEXT:    sw $4, %lo(g1)($1)
; CHECK-NEXT:  $BB2_2: # %if.end
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
;
; MMR6-LABEL: slti_beq0:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    lui $2, %hi(_gp_disp) # <MCInst #[[#MCINST4:]] LUi
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%hi(_gp_disp)>>
; MMR6-NEXT:    addiu $2, $2, %lo(_gp_disp) # <MCInst #[[#MCINST5:]] ADDiu
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%lo(_gp_disp)>>
; MMR6-NEXT:    addu $2, $2, $25 # <MCInst #[[#MCINST6:]] ADDu
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:T9>>
; MMR6-NEXT:    slti $1, $4, -32768 # <MCInst #[[#MCINST7:]] SLTi_MM
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Reg:A0>
; MMR6-NEXT:    # <MCOperand Imm:-32768>>
; MMR6-NEXT:    beqzc $1, $BB2_2 # <MCInst #[[#MCINST8:]] BEQZC_MMR6
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Expr:$BB2_2>>
; MMR6-NEXT:  # %bb.1: # %if.then
; MMR6-NEXT:    lw $2, %got(g1)($2) # <MCInst #[[#MCINST9:]] LW_MM
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%got(g1)>>
; MMR6-NEXT:    sw16 $4, 0($2) # <MCInst #[[#MCINST10:]] SW16_MM
; MMR6-NEXT:    # <MCOperand Reg:A0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Imm:0>>
; MMR6-NEXT:  $BB2_2: # %if.end
; MMR6-NEXT:    jrc $ra # <MCInst #[[#MCINST2]] JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:RA>>
entry:
  %cmp = icmp slt i32 %a, -32768
  br i1 %cmp, label %if.then, label %if.end

if.then:
  store i32 %a, ptr @g1, align 4
  br label %if.end

if.end:
  ret void
}

define void @slti_beq1(i32 %a) {
; CHECK-LABEL: slti_beq1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lui $1, 65535
; CHECK-NEXT:    ori $1, $1, 32766
; CHECK-NEXT:    slt $1, $1, $4
; CHECK-NEXT:    bnez $1, $BB3_2
; CHECK-NEXT:    nop
; CHECK-NEXT:  # %bb.1: # %if.then
; CHECK-NEXT:    lui $1, %hi(g1)
; CHECK-NEXT:    sw $4, %lo(g1)($1)
; CHECK-NEXT:  $BB3_2: # %if.end
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
;
; MMR6-LABEL: slti_beq1:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    lui $2, %hi(_gp_disp) # <MCInst #[[#MCINST4]] LUi
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%hi(_gp_disp)>>
; MMR6-NEXT:    addiu $2, $2, %lo(_gp_disp) # <MCInst #[[#MCINST5]] ADDiu
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%lo(_gp_disp)>>
; MMR6-NEXT:    addu $2, $2, $25 # <MCInst #[[#MCINST6]] ADDu
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:T9>>
; MMR6-NEXT:    lui $1, 65535 # <MCInst #[[#MCINST11:]] LUi_MM
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Imm:65535>>
; MMR6-NEXT:    ori $1, $1, 32766 # <MCInst #[[#MCINST12:]] ORi_MM
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Imm:32766>>
; MMR6-NEXT:    slt $1, $1, $4 # <MCInst #[[#MCINST13:]] SLT_MM
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Reg:A0>>
; MMR6-NEXT:    bnezc $1, $BB3_2 # <MCInst #[[#MCINST14:]] BNEZC_MMR6
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Expr:$BB3_2>>
; MMR6-NEXT:  # %bb.1: # %if.then
; MMR6-NEXT:    lw $2, %got(g1)($2) # <MCInst #[[#MCINST9]] LW_MM
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%got(g1)>>
; MMR6-NEXT:    sw16 $4, 0($2) # <MCInst #[[#MCINST10]] SW16_MM
; MMR6-NEXT:    # <MCOperand Reg:A0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Imm:0>>
; MMR6-NEXT:  $BB3_2: # %if.end
; MMR6-NEXT:    jrc $ra # <MCInst #[[#MCINST2]] JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:RA>>
entry:
  %cmp = icmp slt i32 %a, -32769
  br i1 %cmp, label %if.then, label %if.end

if.then:
  store i32 %a, ptr @g1, align 4
  br label %if.end

if.end:
  ret void
}

define void @slti_beq2(i32 %a) {
; CHECK-LABEL: slti_beq2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    slti $1, $4, 32767
; CHECK-NEXT:    beqz $1, $BB4_2
; CHECK-NEXT:    nop
; CHECK-NEXT:  # %bb.1: # %if.then
; CHECK-NEXT:    lui $1, %hi(g1)
; CHECK-NEXT:    sw $4, %lo(g1)($1)
; CHECK-NEXT:  $BB4_2: # %if.end
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
;
; MMR6-LABEL: slti_beq2:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    lui $2, %hi(_gp_disp) # <MCInst #[[#MCINST4]] LUi
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%hi(_gp_disp)>>
; MMR6-NEXT:    addiu $2, $2, %lo(_gp_disp) # <MCInst #[[#MCINST5]] ADDiu
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%lo(_gp_disp)>>
; MMR6-NEXT:    addu $2, $2, $25 # <MCInst #[[#MCINST6]] ADDu
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:T9>>
; MMR6-NEXT:    slti $1, $4, 32767 # <MCInst #[[#MCINST7]] SLTi_MM
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Reg:A0>
; MMR6-NEXT:    # <MCOperand Imm:32767>>
; MMR6-NEXT:    beqzc $1, $BB4_2 # <MCInst #[[#MCINST8]] BEQZC_MMR6
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Expr:$BB4_2>>
; MMR6-NEXT:  # %bb.1: # %if.then
; MMR6-NEXT:    lw $2, %got(g1)($2) # <MCInst #[[#MCINST9]] LW_MM
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%got(g1)>>
; MMR6-NEXT:    sw16 $4, 0($2) # <MCInst #[[#MCINST10]] SW16_MM
; MMR6-NEXT:    # <MCOperand Reg:A0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Imm:0>>
; MMR6-NEXT:  $BB4_2: # %if.end
; MMR6-NEXT:    jrc $ra # <MCInst #[[#MCINST2]] JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:RA>>
entry:
  %cmp = icmp slt i32 %a, 32767
  br i1 %cmp, label %if.then, label %if.end

if.then:
  store i32 %a, ptr @g1, align 4
  br label %if.end

if.end:
  ret void
}

define void @slti_beq3(i32 %a) {
; CHECK-LABEL: slti_beq3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $1, $zero, 32767
; CHECK-NEXT:    slt $1, $1, $4
; CHECK-NEXT:    bnez $1, $BB5_2
; CHECK-NEXT:    nop
; CHECK-NEXT:  # %bb.1: # %if.then
; CHECK-NEXT:    lui $1, %hi(g1)
; CHECK-NEXT:    sw $4, %lo(g1)($1)
; CHECK-NEXT:  $BB5_2: # %if.end
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
;
; MMR6-LABEL: slti_beq3:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    lui $2, %hi(_gp_disp) # <MCInst #[[#MCINST4]] LUi
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%hi(_gp_disp)>>
; MMR6-NEXT:    addiu $2, $2, %lo(_gp_disp) # <MCInst #[[#MCINST5]] ADDiu
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%lo(_gp_disp)>>
; MMR6-NEXT:    addu $2, $2, $25 # <MCInst #[[#MCINST6]] ADDu
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:T9>>
; MMR6-NEXT:    addiu $1, $zero, 32767 # <MCInst #[[#MCINST15:]] ADDiu_MM
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Reg:ZERO>
; MMR6-NEXT:    # <MCOperand Imm:32767>>
; MMR6-NEXT:    slt $1, $1, $4 # <MCInst #[[#MCINST13]] SLT_MM
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Reg:A0>>
; MMR6-NEXT:    bnezc $1, $BB5_2 # <MCInst #[[#MCINST14]] BNEZC_MMR6
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Expr:$BB5_2>>
; MMR6-NEXT:  # %bb.1: # %if.then
; MMR6-NEXT:    lw $2, %got(g1)($2) # <MCInst #[[#MCINST9]] LW_MM
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%got(g1)>>
; MMR6-NEXT:    sw16 $4, 0($2) # <MCInst #[[#MCINST10]] SW16_MM
; MMR6-NEXT:    # <MCOperand Reg:A0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Imm:0>>
; MMR6-NEXT:  $BB5_2: # %if.end
; MMR6-NEXT:    jrc $ra # <MCInst #[[#MCINST2]] JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:RA>>
entry:
  %cmp = icmp slt i32 %a, 32768
  br i1 %cmp, label %if.then, label %if.end

if.then:
  store i32 %a, ptr @g1, align 4
  br label %if.end

if.end:
  ret void
}

define void @sltiu_beq0(i32 %a) {
; CHECK-LABEL: sltiu_beq0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sltiu $1, $4, 32767
; CHECK-NEXT:    beqz $1, $BB6_2
; CHECK-NEXT:    nop
; CHECK-NEXT:  # %bb.1: # %if.then
; CHECK-NEXT:    lui $1, %hi(g1)
; CHECK-NEXT:    sw $4, %lo(g1)($1)
; CHECK-NEXT:  $BB6_2: # %if.end
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
;
; MMR6-LABEL: sltiu_beq0:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    lui $2, %hi(_gp_disp) # <MCInst #[[#MCINST4]] LUi
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%hi(_gp_disp)>>
; MMR6-NEXT:    addiu $2, $2, %lo(_gp_disp) # <MCInst #[[#MCINST5]] ADDiu
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%lo(_gp_disp)>>
; MMR6-NEXT:    addu $2, $2, $25 # <MCInst #[[#MCINST6]] ADDu
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:T9>>
; MMR6-NEXT:    sltiu $1, $4, 32767 # <MCInst #[[#MCINST1]] SLTiu_MM
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Reg:A0>
; MMR6-NEXT:    # <MCOperand Imm:32767>>
; MMR6-NEXT:    beqzc $1, $BB6_2 # <MCInst #[[#MCINST8]] BEQZC_MMR6
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Expr:$BB6_2>>
; MMR6-NEXT:  # %bb.1: # %if.then
; MMR6-NEXT:    lw $2, %got(g1)($2) # <MCInst #[[#MCINST9]] LW_MM
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%got(g1)>>
; MMR6-NEXT:    sw16 $4, 0($2) # <MCInst #[[#MCINST10]] SW16_MM
; MMR6-NEXT:    # <MCOperand Reg:A0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Imm:0>>
; MMR6-NEXT:  $BB6_2: # %if.end
; MMR6-NEXT:    jrc $ra # <MCInst #[[#MCINST2]] JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:RA>>
entry:
  %cmp = icmp ult i32 %a, 32767
  br i1 %cmp, label %if.then, label %if.end

if.then:
  store i32 %a, ptr @g1, align 4
  br label %if.end

if.end:
  ret void
}

define void @sltiu_beq1(i32 %a) {
; CHECK-LABEL: sltiu_beq1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $1, $zero, 32767
; CHECK-NEXT:    sltu $1, $1, $4
; CHECK-NEXT:    bnez $1, $BB7_2
; CHECK-NEXT:    nop
; CHECK-NEXT:  # %bb.1: # %if.then
; CHECK-NEXT:    lui $1, %hi(g1)
; CHECK-NEXT:    sw $4, %lo(g1)($1)
; CHECK-NEXT:  $BB7_2: # %if.end
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
;
; MMR6-LABEL: sltiu_beq1:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    lui $2, %hi(_gp_disp) # <MCInst #[[#MCINST4]] LUi
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%hi(_gp_disp)>>
; MMR6-NEXT:    addiu $2, $2, %lo(_gp_disp) # <MCInst #[[#MCINST5]] ADDiu
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%lo(_gp_disp)>>
; MMR6-NEXT:    addu $2, $2, $25 # <MCInst #[[#MCINST6]] ADDu
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:T9>>
; MMR6-NEXT:    addiu $1, $zero, 32767 # <MCInst #[[#MCINST15]] ADDiu_MM
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Reg:ZERO>
; MMR6-NEXT:    # <MCOperand Imm:32767>>
; MMR6-NEXT:    sltu $1, $1, $4 # <MCInst #[[#MCINST3]] SLTu_MM
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Reg:A0>>
; MMR6-NEXT:    bnezc $1, $BB7_2 # <MCInst #[[#MCINST14]] BNEZC_MMR6
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Expr:$BB7_2>>
; MMR6-NEXT:  # %bb.1: # %if.then
; MMR6-NEXT:    lw $2, %got(g1)($2) # <MCInst #[[#MCINST9]] LW_MM
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%got(g1)>>
; MMR6-NEXT:    sw16 $4, 0($2) # <MCInst #[[#MCINST10]] SW16_MM
; MMR6-NEXT:    # <MCOperand Reg:A0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Imm:0>>
; MMR6-NEXT:  $BB7_2: # %if.end
; MMR6-NEXT:    jrc $ra # <MCInst #[[#MCINST2]] JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:RA>>
entry:
  %cmp = icmp ult i32 %a, 32768
  br i1 %cmp, label %if.then, label %if.end

if.then:
  store i32 %a, ptr @g1, align 4
  br label %if.end

if.end:
  ret void
}

define void @sltiu_beq2(i32 %a) {
; CHECK-LABEL: sltiu_beq2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sltiu $1, $4, -32768
; CHECK-NEXT:    beqz $1, $BB8_2
; CHECK-NEXT:    nop
; CHECK-NEXT:  # %bb.1: # %if.then
; CHECK-NEXT:    lui $1, %hi(g1)
; CHECK-NEXT:    sw $4, %lo(g1)($1)
; CHECK-NEXT:  $BB8_2: # %if.end
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
;
; MMR6-LABEL: sltiu_beq2:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    lui $2, %hi(_gp_disp) # <MCInst #[[#MCINST4]] LUi
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%hi(_gp_disp)>>
; MMR6-NEXT:    addiu $2, $2, %lo(_gp_disp) # <MCInst #[[#MCINST5]] ADDiu
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%lo(_gp_disp)>>
; MMR6-NEXT:    addu $2, $2, $25 # <MCInst #[[#MCINST6]] ADDu
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:T9>>
; MMR6-NEXT:    sltiu $1, $4, -32768 # <MCInst #[[#MCINST1]] SLTiu_MM
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Reg:A0>
; MMR6-NEXT:    # <MCOperand Imm:-32768>>
; MMR6-NEXT:    beqzc $1, $BB8_2 # <MCInst #[[#MCINST8]] BEQZC_MMR6
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Expr:$BB8_2>>
; MMR6-NEXT:  # %bb.1: # %if.then
; MMR6-NEXT:    lw $2, %got(g1)($2) # <MCInst #[[#MCINST9]] LW_MM
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%got(g1)>>
; MMR6-NEXT:    sw16 $4, 0($2) # <MCInst #[[#MCINST10]] SW16_MM
; MMR6-NEXT:    # <MCOperand Reg:A0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Imm:0>>
; MMR6-NEXT:  $BB8_2: # %if.end
; MMR6-NEXT:    jrc $ra # <MCInst #[[#MCINST2]] JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:RA>>
entry:
  %cmp = icmp ult i32 %a, -32768
  br i1 %cmp, label %if.then, label %if.end

if.then:
  store i32 %a, ptr @g1, align 4
  br label %if.end

if.end:
  ret void
}

define void @sltiu_beq3(i32 %a) {
; CHECK-LABEL: sltiu_beq3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lui $1, 65535
; CHECK-NEXT:    ori $1, $1, 32766
; CHECK-NEXT:    sltu $1, $1, $4
; CHECK-NEXT:    bnez $1, $BB9_2
; CHECK-NEXT:    nop
; CHECK-NEXT:  # %bb.1: # %if.then
; CHECK-NEXT:    lui $1, %hi(g1)
; CHECK-NEXT:    sw $4, %lo(g1)($1)
; CHECK-NEXT:  $BB9_2: # %if.end
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
;
; MMR6-LABEL: sltiu_beq3:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    lui $2, %hi(_gp_disp) # <MCInst #[[#MCINST4]] LUi
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%hi(_gp_disp)>>
; MMR6-NEXT:    addiu $2, $2, %lo(_gp_disp) # <MCInst #[[#MCINST5]] ADDiu
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%lo(_gp_disp)>>
; MMR6-NEXT:    addu $2, $2, $25 # <MCInst #[[#MCINST6]] ADDu
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:T9>>
; MMR6-NEXT:    lui $1, 65535 # <MCInst #[[#MCINST11]] LUi_MM
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Imm:65535>>
; MMR6-NEXT:    ori $1, $1, 32766 # <MCInst #[[#MCINST12]] ORi_MM
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Imm:32766>>
; MMR6-NEXT:    sltu $1, $1, $4 # <MCInst #[[#MCINST3]] SLTu_MM
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Reg:A0>>
; MMR6-NEXT:    bnezc $1, $BB9_2 # <MCInst #[[#MCINST14]] BNEZC_MMR6
; MMR6-NEXT:    # <MCOperand Reg:AT>
; MMR6-NEXT:    # <MCOperand Expr:$BB9_2>>
; MMR6-NEXT:  # %bb.1: # %if.then
; MMR6-NEXT:    lw $2, %got(g1)($2) # <MCInst #[[#MCINST9]] LW_MM
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Expr:%got(g1)>>
; MMR6-NEXT:    sw16 $4, 0($2) # <MCInst #[[#MCINST10]] SW16_MM
; MMR6-NEXT:    # <MCOperand Reg:A0>
; MMR6-NEXT:    # <MCOperand Reg:V0>
; MMR6-NEXT:    # <MCOperand Imm:0>>
; MMR6-NEXT:  $BB9_2: # %if.end
; MMR6-NEXT:    jrc $ra # <MCInst #[[#MCINST2]] JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:RA>>
entry:
  %cmp = icmp ult i32 %a, -32769
  br i1 %cmp, label %if.then, label %if.end

if.then:
  store i32 %a, ptr @g1, align 4
  br label %if.end

if.end:
  ret void
}
