; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 6
; RUN: llc -mtriple=mips64 -mcpu=mips64   -verify-machineinstrs    -relocation-model=pic < %s | FileCheck %s -check-prefixes=ALL,ACC64,ACC64-TRAP
; RUN: llc -mtriple=mips64 -mcpu=mips64r2 -verify-machineinstrs    -relocation-model=pic < %s | FileCheck %s -check-prefixes=ALL,ACC64,ACC64-TRAP

; RUN: llc -mtriple=mips64 -mcpu=mips64   -mno-check-zero-division -relocation-model=pic < %s | FileCheck %s -check-prefixes=ALL,ACC64,NOCHECK
; RUN: llc -mtriple=mips64 -mcpu=mips64r2 -mno-check-zero-division -relocation-model=pic < %s | FileCheck %s -check-prefixes=ALL,ACC64,NOCHECK

; FileCheck Prefixes:
;   ALL - All targets
;   ACC64 - Same as ACC32 but only for 64-bit targets
;   GPR64 - Same as GPR32 but only for 64-bit targets
;   ACC64-TRAP - Same as TRAP and ACC64 combined
;   GPR64-TRAP - Same as TRAP and GPR64 combined
;   NOCHECK - Division by zero will not be detected


define i32 @inline_asm_div() {
; ACC64-TRAP-LABEL: inline_asm_div:
; ACC64-TRAP:       # %bb.0: # %entry
; ACC64-TRAP-NEXT:    addiu $2, $zero, 2
; ACC64-TRAP-NEXT:    addiu $3, $zero, 1
; ACC64-TRAP-NEXT:    #APP
; ACC64-TRAP-NEXT:    .set push
; ACC64-TRAP-NEXT:    .set at
; ACC64-TRAP-NEXT:    .set macro
; ACC64-TRAP-NEXT:    .set reorder
; ACC64-TRAP-EMPTY:
; ACC64-TRAP-NEXT:    div $zero, $2, $3
; ACC64-TRAP-NEXT:    bnez $3, .Ltmp0
; ACC64-TRAP-NEXT:    nop
; ACC64-TRAP-NEXT:    break 7
; ACC64-TRAP-NEXT:  .Ltmp0:
; ACC64-TRAP-NEXT:    mflo $2
; ACC64-TRAP-EMPTY:
; ACC64-TRAP-NEXT:    .set pop
; ACC64-TRAP-NEXT:    #NO_APP
; ACC64-TRAP-NEXT:    jr $ra
; ACC64-TRAP-NEXT:    nop
;
; NOCHECK-LABEL: inline_asm_div:
; NOCHECK:       # %bb.0: # %entry
; NOCHECK-NEXT:    addiu $2, $zero, 2
; NOCHECK-NEXT:    addiu $3, $zero, 1
; NOCHECK-NEXT:    #APP
; NOCHECK-NEXT:    .set push
; NOCHECK-NEXT:    .set at
; NOCHECK-NEXT:    .set macro
; NOCHECK-NEXT:    .set reorder
; NOCHECK-EMPTY:
; NOCHECK-NEXT:    div $zero, $2, $3
; NOCHECK-NEXT:    mflo $2
; NOCHECK-EMPTY:
; NOCHECK-NEXT:    .set pop
; NOCHECK-NEXT:    #NO_APP
; NOCHECK-NEXT:    jr $ra
; NOCHECK-NEXT:    nop
entry:
  %0 = tail call i32 asm sideeffect "div $0, $1, $2", "=r,r,r,~{hi},~{lo},~{$1}"(i32 2, i32 1)
  ret i32 %0
}

define i32 @inline_asm_rem() {
; ACC64-TRAP-LABEL: inline_asm_rem:
; ACC64-TRAP:       # %bb.0: # %entry
; ACC64-TRAP-NEXT:    addiu $2, $zero, 2
; ACC64-TRAP-NEXT:    addiu $3, $zero, 1
; ACC64-TRAP-NEXT:    #APP
; ACC64-TRAP-NEXT:    .set push
; ACC64-TRAP-NEXT:    .set at
; ACC64-TRAP-NEXT:    .set macro
; ACC64-TRAP-NEXT:    .set reorder
; ACC64-TRAP-EMPTY:
; ACC64-TRAP-NEXT:    div $zero, $2, $3
; ACC64-TRAP-NEXT:    bnez $3, .Ltmp1
; ACC64-TRAP-NEXT:    nop
; ACC64-TRAP-NEXT:    break 7
; ACC64-TRAP-NEXT:  .Ltmp1:
; ACC64-TRAP-NEXT:    mfhi $2
; ACC64-TRAP-EMPTY:
; ACC64-TRAP-NEXT:    .set pop
; ACC64-TRAP-NEXT:    #NO_APP
; ACC64-TRAP-NEXT:    jr $ra
; ACC64-TRAP-NEXT:    nop
;
; NOCHECK-LABEL: inline_asm_rem:
; NOCHECK:       # %bb.0: # %entry
; NOCHECK-NEXT:    addiu $2, $zero, 2
; NOCHECK-NEXT:    addiu $3, $zero, 1
; NOCHECK-NEXT:    #APP
; NOCHECK-NEXT:    .set push
; NOCHECK-NEXT:    .set at
; NOCHECK-NEXT:    .set macro
; NOCHECK-NEXT:    .set reorder
; NOCHECK-EMPTY:
; NOCHECK-NEXT:    div $zero, $2, $3
; NOCHECK-NEXT:    mfhi $2
; NOCHECK-EMPTY:
; NOCHECK-NEXT:    .set pop
; NOCHECK-NEXT:    #NO_APP
; NOCHECK-NEXT:    jr $ra
; NOCHECK-NEXT:    nop
entry:
  %0 = tail call i32 asm sideeffect "rem $0, $1, $2", "=r,r,r,~{hi},~{lo},~{$1}"(i32 2, i32 1)
  ret i32 %0
}

define i64 @inline_asm_ddiv() {
; ACC64-TRAP-LABEL: inline_asm_ddiv:
; ACC64-TRAP:       # %bb.0: # %entry
; ACC64-TRAP-NEXT:    daddiu $2, $zero, 2
; ACC64-TRAP-NEXT:    daddiu $3, $zero, 1
; ACC64-TRAP-NEXT:    #APP
; ACC64-TRAP-NEXT:    .set push
; ACC64-TRAP-NEXT:    .set at
; ACC64-TRAP-NEXT:    .set macro
; ACC64-TRAP-NEXT:    .set reorder
; ACC64-TRAP-EMPTY:
; ACC64-TRAP-NEXT:    ddiv $zero, $2, $3
; ACC64-TRAP-NEXT:    bne $3, $zero, .Ltmp2
; ACC64-TRAP-NEXT:    nop
; ACC64-TRAP-NEXT:    break 7
; ACC64-TRAP-NEXT:  .Ltmp2:
; ACC64-TRAP-NEXT:    mflo $2
; ACC64-TRAP-EMPTY:
; ACC64-TRAP-NEXT:    .set pop
; ACC64-TRAP-NEXT:    #NO_APP
; ACC64-TRAP-NEXT:    jr $ra
; ACC64-TRAP-NEXT:    nop
;
; NOCHECK-LABEL: inline_asm_ddiv:
; NOCHECK:       # %bb.0: # %entry
; NOCHECK-NEXT:    daddiu $2, $zero, 2
; NOCHECK-NEXT:    daddiu $3, $zero, 1
; NOCHECK-NEXT:    #APP
; NOCHECK-NEXT:    .set push
; NOCHECK-NEXT:    .set at
; NOCHECK-NEXT:    .set macro
; NOCHECK-NEXT:    .set reorder
; NOCHECK-EMPTY:
; NOCHECK-NEXT:    ddiv $zero, $2, $3
; NOCHECK-NEXT:    mflo $2
; NOCHECK-EMPTY:
; NOCHECK-NEXT:    .set pop
; NOCHECK-NEXT:    #NO_APP
; NOCHECK-NEXT:    jr $ra
; NOCHECK-NEXT:    nop
entry:
  %0 = tail call i64 asm sideeffect "ddiv $1, $2", "=r,r,r,~{hi},~{lo},~{$1}"(i64 2, i64 1)
  ret i64 %0
}

define i64 @inline_asm_drem() {
; ACC64-TRAP-LABEL: inline_asm_drem:
; ACC64-TRAP:       # %bb.0: # %entry
; ACC64-TRAP-NEXT:    daddiu $2, $zero, 2
; ACC64-TRAP-NEXT:    daddiu $3, $zero, 1
; ACC64-TRAP-NEXT:    #APP
; ACC64-TRAP-NEXT:    .set push
; ACC64-TRAP-NEXT:    .set at
; ACC64-TRAP-NEXT:    .set macro
; ACC64-TRAP-NEXT:    .set reorder
; ACC64-TRAP-EMPTY:
; ACC64-TRAP-NEXT:    ddiv $zero, $2, $3
; ACC64-TRAP-NEXT:    bne $3, $zero, .Ltmp3
; ACC64-TRAP-NEXT:    nop
; ACC64-TRAP-NEXT:    break 7
; ACC64-TRAP-NEXT:  .Ltmp3:
; ACC64-TRAP-NEXT:    mfhi $2
; ACC64-TRAP-EMPTY:
; ACC64-TRAP-NEXT:    .set pop
; ACC64-TRAP-NEXT:    #NO_APP
; ACC64-TRAP-NEXT:    jr $ra
; ACC64-TRAP-NEXT:    nop
;
; NOCHECK-LABEL: inline_asm_drem:
; NOCHECK:       # %bb.0: # %entry
; NOCHECK-NEXT:    daddiu $2, $zero, 2
; NOCHECK-NEXT:    daddiu $3, $zero, 1
; NOCHECK-NEXT:    #APP
; NOCHECK-NEXT:    .set push
; NOCHECK-NEXT:    .set at
; NOCHECK-NEXT:    .set macro
; NOCHECK-NEXT:    .set reorder
; NOCHECK-EMPTY:
; NOCHECK-NEXT:    ddiv $zero, $2, $3
; NOCHECK-NEXT:    mfhi $2
; NOCHECK-EMPTY:
; NOCHECK-NEXT:    .set pop
; NOCHECK-NEXT:    #NO_APP
; NOCHECK-NEXT:    jr $ra
; NOCHECK-NEXT:    nop
entry:
  %0 = tail call i64 asm sideeffect "drem $1, $2", "=r,r,r,~{hi},~{lo},~{$1}"(i64 2, i64 1)
  ret i64 %0
}

define i32 @inline_asm_divu() {
; ACC64-TRAP-LABEL: inline_asm_divu:
; ACC64-TRAP:       # %bb.0: # %entry
; ACC64-TRAP-NEXT:    addiu $2, $zero, 2
; ACC64-TRAP-NEXT:    addiu $3, $zero, 1
; ACC64-TRAP-NEXT:    #APP
; ACC64-TRAP-NEXT:    .set push
; ACC64-TRAP-NEXT:    .set at
; ACC64-TRAP-NEXT:    .set macro
; ACC64-TRAP-NEXT:    .set reorder
; ACC64-TRAP-EMPTY:
; ACC64-TRAP-NEXT:    divu $zero, $2, $3
; ACC64-TRAP-NEXT:    bnez $3, .Ltmp4
; ACC64-TRAP-NEXT:    nop
; ACC64-TRAP-NEXT:    break 7
; ACC64-TRAP-NEXT:  .Ltmp4:
; ACC64-TRAP-NEXT:    mflo $2
; ACC64-TRAP-EMPTY:
; ACC64-TRAP-NEXT:    .set pop
; ACC64-TRAP-NEXT:    #NO_APP
; ACC64-TRAP-NEXT:    jr $ra
; ACC64-TRAP-NEXT:    nop
;
; NOCHECK-LABEL: inline_asm_divu:
; NOCHECK:       # %bb.0: # %entry
; NOCHECK-NEXT:    addiu $2, $zero, 2
; NOCHECK-NEXT:    addiu $3, $zero, 1
; NOCHECK-NEXT:    #APP
; NOCHECK-NEXT:    .set push
; NOCHECK-NEXT:    .set at
; NOCHECK-NEXT:    .set macro
; NOCHECK-NEXT:    .set reorder
; NOCHECK-EMPTY:
; NOCHECK-NEXT:    divu $zero, $2, $3
; NOCHECK-NEXT:    mflo $2
; NOCHECK-EMPTY:
; NOCHECK-NEXT:    .set pop
; NOCHECK-NEXT:    #NO_APP
; NOCHECK-NEXT:    jr $ra
; NOCHECK-NEXT:    nop
entry:
  %0 = tail call i32 asm sideeffect "divu $0, $1, $2", "=r,r,r,~{hi},~{lo},~{$1}"(i32 2, i32 1)
  ret i32 %0
}

define i32 @inline_asm_remu() {
; ACC64-TRAP-LABEL: inline_asm_remu:
; ACC64-TRAP:       # %bb.0: # %entry
; ACC64-TRAP-NEXT:    addiu $2, $zero, 2
; ACC64-TRAP-NEXT:    addiu $3, $zero, 1
; ACC64-TRAP-NEXT:    #APP
; ACC64-TRAP-NEXT:    .set push
; ACC64-TRAP-NEXT:    .set at
; ACC64-TRAP-NEXT:    .set macro
; ACC64-TRAP-NEXT:    .set reorder
; ACC64-TRAP-EMPTY:
; ACC64-TRAP-NEXT:    divu $zero, $2, $3
; ACC64-TRAP-NEXT:    bnez $3, .Ltmp5
; ACC64-TRAP-NEXT:    nop
; ACC64-TRAP-NEXT:    break 7
; ACC64-TRAP-NEXT:  .Ltmp5:
; ACC64-TRAP-NEXT:    mfhi $2
; ACC64-TRAP-EMPTY:
; ACC64-TRAP-NEXT:    .set pop
; ACC64-TRAP-NEXT:    #NO_APP
; ACC64-TRAP-NEXT:    jr $ra
; ACC64-TRAP-NEXT:    nop
;
; NOCHECK-LABEL: inline_asm_remu:
; NOCHECK:       # %bb.0: # %entry
; NOCHECK-NEXT:    addiu $2, $zero, 2
; NOCHECK-NEXT:    addiu $3, $zero, 1
; NOCHECK-NEXT:    #APP
; NOCHECK-NEXT:    .set push
; NOCHECK-NEXT:    .set at
; NOCHECK-NEXT:    .set macro
; NOCHECK-NEXT:    .set reorder
; NOCHECK-EMPTY:
; NOCHECK-NEXT:    divu $zero, $2, $3
; NOCHECK-NEXT:    mfhi $2
; NOCHECK-EMPTY:
; NOCHECK-NEXT:    .set pop
; NOCHECK-NEXT:    #NO_APP
; NOCHECK-NEXT:    jr $ra
; NOCHECK-NEXT:    nop
entry:
  %0 = tail call i32 asm sideeffect "remu $0, $1, $2", "=r,r,r,~{hi},~{lo},~{$1}"(i32 2, i32 1)
  ret i32 %0
}

define i64 @inline_asm_ddivu() {
; ACC64-TRAP-LABEL: inline_asm_ddivu:
; ACC64-TRAP:       # %bb.0: # %entry
; ACC64-TRAP-NEXT:    daddiu $2, $zero, 2
; ACC64-TRAP-NEXT:    daddiu $3, $zero, 1
; ACC64-TRAP-NEXT:    #APP
; ACC64-TRAP-NEXT:    .set push
; ACC64-TRAP-NEXT:    .set at
; ACC64-TRAP-NEXT:    .set macro
; ACC64-TRAP-NEXT:    .set reorder
; ACC64-TRAP-EMPTY:
; ACC64-TRAP-NEXT:    ddivu $zero, $2, $3
; ACC64-TRAP-NEXT:    bne $3, $zero, .Ltmp6
; ACC64-TRAP-NEXT:    nop
; ACC64-TRAP-NEXT:    break 7
; ACC64-TRAP-NEXT:  .Ltmp6:
; ACC64-TRAP-NEXT:    mflo $2
; ACC64-TRAP-EMPTY:
; ACC64-TRAP-NEXT:    .set pop
; ACC64-TRAP-NEXT:    #NO_APP
; ACC64-TRAP-NEXT:    jr $ra
; ACC64-TRAP-NEXT:    nop
;
; NOCHECK-LABEL: inline_asm_ddivu:
; NOCHECK:       # %bb.0: # %entry
; NOCHECK-NEXT:    daddiu $2, $zero, 2
; NOCHECK-NEXT:    daddiu $3, $zero, 1
; NOCHECK-NEXT:    #APP
; NOCHECK-NEXT:    .set push
; NOCHECK-NEXT:    .set at
; NOCHECK-NEXT:    .set macro
; NOCHECK-NEXT:    .set reorder
; NOCHECK-EMPTY:
; NOCHECK-NEXT:    ddivu $zero, $2, $3
; NOCHECK-NEXT:    mflo $2
; NOCHECK-EMPTY:
; NOCHECK-NEXT:    .set pop
; NOCHECK-NEXT:    #NO_APP
; NOCHECK-NEXT:    jr $ra
; NOCHECK-NEXT:    nop
entry:
  %0 = tail call i64 asm sideeffect "ddivu $1, $2", "=r,r,r,~{hi},~{lo},~{$1}"(i64 2, i64 1)
  ret i64 %0
}

define i64 @inline_asm_dremu() {
; ACC64-TRAP-LABEL: inline_asm_dremu:
; ACC64-TRAP:       # %bb.0: # %entry
; ACC64-TRAP-NEXT:    daddiu $2, $zero, 2
; ACC64-TRAP-NEXT:    daddiu $3, $zero, 1
; ACC64-TRAP-NEXT:    #APP
; ACC64-TRAP-NEXT:    .set push
; ACC64-TRAP-NEXT:    .set at
; ACC64-TRAP-NEXT:    .set macro
; ACC64-TRAP-NEXT:    .set reorder
; ACC64-TRAP-EMPTY:
; ACC64-TRAP-NEXT:    ddivu $zero, $2, $3
; ACC64-TRAP-NEXT:    bne $3, $zero, .Ltmp7
; ACC64-TRAP-NEXT:    nop
; ACC64-TRAP-NEXT:    break 7
; ACC64-TRAP-NEXT:  .Ltmp7:
; ACC64-TRAP-NEXT:    mfhi $2
; ACC64-TRAP-EMPTY:
; ACC64-TRAP-NEXT:    .set pop
; ACC64-TRAP-NEXT:    #NO_APP
; ACC64-TRAP-NEXT:    jr $ra
; ACC64-TRAP-NEXT:    nop
;
; NOCHECK-LABEL: inline_asm_dremu:
; NOCHECK:       # %bb.0: # %entry
; NOCHECK-NEXT:    daddiu $2, $zero, 2
; NOCHECK-NEXT:    daddiu $3, $zero, 1
; NOCHECK-NEXT:    #APP
; NOCHECK-NEXT:    .set push
; NOCHECK-NEXT:    .set at
; NOCHECK-NEXT:    .set macro
; NOCHECK-NEXT:    .set reorder
; NOCHECK-EMPTY:
; NOCHECK-NEXT:    ddivu $zero, $2, $3
; NOCHECK-NEXT:    mfhi $2
; NOCHECK-EMPTY:
; NOCHECK-NEXT:    .set pop
; NOCHECK-NEXT:    #NO_APP
; NOCHECK-NEXT:    jr $ra
; NOCHECK-NEXT:    nop
entry:
  %0 = tail call i64 asm sideeffect "dremu $1, $2", "=r,r,r,~{hi},~{lo},~{$1}"(i64 2, i64 1)
  ret i64 %0
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; ACC64: {{.*}}
; ALL: {{.*}}
