; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC
;
;    #include <threads.h>
;    thread_local int gtl = 0;
;    int gsh = 0;
;
;    static int callee(int *thread_local_ptr, int *shared_ptr) {
;      return *thread_local_ptr + *shared_ptr;
;    }
;
;    void broker(int *, int (*callee)(int *, int *), int *);
;
;    void caller() {
;      broker(&gtl, callee, &gsh);
;    }
;
target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

@gtl = dso_local thread_local global i32 0, align 4
@gsh = dso_local global i32 0, align 4

;.
; CHECK: @gtl = dso_local thread_local global i32 0, align 4
; CHECK: @gsh = dso_local global i32 0, align 4
;.
define internal i32 @callee(ptr %thread_local_ptr, ptr %shared_ptr) {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(read)
; CHECK-LABEL: define {{[^@]+}}@callee
; CHECK-SAME: (ptr nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[THREAD_LOCAL_PTR:%.*]], ptr nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[SHARED_PTR:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP:%.*]] = load i32, ptr @gtl, align 4
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @gsh, align 4
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[ADD]]
;
entry:
  %tmp = load i32, ptr %thread_local_ptr, align 4
  %tmp1 = load i32, ptr %shared_ptr, align 4
  %add = add nsw i32 %tmp, %tmp1
  ret i32 %add
}

define dso_local void @caller() {
; TUNIT-LABEL: define {{[^@]+}}@caller() {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    call void @broker(ptr nocapture nofree nonnull readonly align 4 dereferenceable(4) undef, ptr noundef nonnull @callee, ptr nocapture nofree nonnull readonly align 4 dereferenceable(4) undef)
; TUNIT-NEXT:    ret void
;
; CGSCC-LABEL: define {{[^@]+}}@caller() {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    call void @broker(ptr nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) @gtl, ptr noundef nonnull @callee, ptr nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) @gsh)
; CGSCC-NEXT:    ret void
;
entry:
  call void @broker(ptr nonnull @gtl, ptr nonnull @callee, ptr nonnull @gsh)
  ret void
}

declare !callback !0 dso_local void @broker(ptr, ptr, ptr)

!1 = !{i64 1, i64 0, i64 2, i1 false}
!0 = !{!1}
;.
; TUNIT: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(read) }
;.
; CGSCC: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(read) }
;.
; TUNIT: [[META0:![0-9]+]] = !{[[META1:![0-9]+]]}
; TUNIT: [[META1]] = !{i64 1, i64 0, i64 2, i1 false}
;.
; CGSCC: [[META0:![0-9]+]] = !{[[META1:![0-9]+]]}
; CGSCC: [[META1]] = !{i64 1, i64 0, i64 2, i1 false}
;.
