// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv64 -target-feature +v -target-feature +xsfvcp -disable-O0-optnone -emit-llvm %s -o - | opt -S -passes=mem2reg | FileCheck --check-prefix=CHECK-RV64 %s

#include <sifive_vector.h>

#define p27_26 (0b11)
#define p24_20 (0b11111)
#define p11_7  (0b11111)

// CHECK-RV64-LABEL: @test_sf_vc_x_se_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e64m1.i64.i64.i64(i64 3, i64 31, i64 31, i64 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u64m1(uint64_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u64m1(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV64-LABEL: @test_sf_vc_x_se_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e64m2.i64.i64.i64(i64 3, i64 31, i64 31, i64 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u64m2(uint64_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u64m2(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV64-LABEL: @test_sf_vc_x_se_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e64m4.i64.i64.i64(i64 3, i64 31, i64 31, i64 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u64m4(uint64_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u64m4(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV64-LABEL: @test_sf_vc_x_se_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e64m8.i64.i64.i64(i64 3, i64 31, i64 31, i64 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u64m8(uint64_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u64m8(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.x.se.nxv1i64.i64.i64.i64(i64 3, i64 31, i64 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_sf_vc_v_x_se_u64m1(uint64_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u64m1(p27_26, p24_20, rs1, vl);
}

// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.x.se.nxv2i64.i64.i64.i64(i64 3, i64 31, i64 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_sf_vc_v_x_se_u64m2(uint64_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u64m2(p27_26, p24_20, rs1, vl);
}

// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.x.se.nxv4i64.i64.i64.i64(i64 3, i64 31, i64 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_sf_vc_v_x_se_u64m4(uint64_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u64m4(p27_26, p24_20, rs1, vl);
}

// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.x.se.nxv8i64.i64.i64.i64(i64 3, i64 31, i64 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_sf_vc_v_x_se_u64m8(uint64_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u64m8(p27_26, p24_20, rs1, vl);
}

// CHECK-RV64-LABEL: @test_sf_vc_v_x_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.x.nxv1i64.i64.i64.i64(i64 3, i64 31, i64 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_sf_vc_v_x_u64m1(uint64_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u64m1(p27_26, p24_20, rs1, vl);
}

// CHECK-RV64-LABEL: @test_sf_vc_v_x_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.x.nxv2i64.i64.i64.i64(i64 3, i64 31, i64 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_sf_vc_v_x_u64m2(uint64_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u64m2(p27_26, p24_20, rs1, vl);
}

// CHECK-RV64-LABEL: @test_sf_vc_v_x_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.x.nxv4i64.i64.i64.i64(i64 3, i64 31, i64 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_sf_vc_v_x_u64m4(uint64_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u64m4(p27_26, p24_20, rs1, vl);
}

// CHECK-RV64-LABEL: @test_sf_vc_v_x_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.x.nxv8i64.i64.i64.i64(i64 3, i64 31, i64 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_sf_vc_v_x_u64m8(uint64_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u64m8(p27_26, p24_20, rs1, vl);
}
