; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define <4 x i32> @test_v4i32_splatconst_pow2(<4 x i32> %a0) {
; CHECK-LABEL: @test_v4i32_splatconst_pow2(
; CHECK-NEXT:    [[TMP1:%.*]] = and <4 x i32> [[A0:%.*]], <i32 1, i32 1, i32 1, i32 1>
; CHECK-NEXT:    ret <4 x i32> [[TMP1]]
;
  %1 = urem <4 x i32> %a0, <i32 2, i32 2, i32 2, i32 2>
  ret <4 x i32> %1
}

define <4 x i32> @test_v4i32_const_pow2(<4 x i32> %a0) {
; CHECK-LABEL: @test_v4i32_const_pow2(
; CHECK-NEXT:    [[TMP1:%.*]] = and <4 x i32> [[A0:%.*]], <i32 0, i32 1, i32 3, i32 7>
; CHECK-NEXT:    ret <4 x i32> [[TMP1]]
;
  %1 = urem <4 x i32> %a0, <i32 1, i32 2, i32 4, i32 8>
  ret <4 x i32> %1
}

define <4 x i32> @test_v4i32_const_pow2_undef(<4 x i32> %a0) {
; CHECK-LABEL: @test_v4i32_const_pow2_undef(
; CHECK-NEXT:    ret <4 x i32> poison
;
  %1 = urem <4 x i32> %a0, <i32 1, i32 2, i32 4, i32 undef>
  ret <4 x i32> %1
}

define <4 x i32> @test_v4i32_one(<4 x i32> %a0) {
; CHECK-LABEL: @test_v4i32_one(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne <4 x i32> [[A0:%.*]], <i32 1, i32 1, i32 1, i32 1>
; CHECK-NEXT:    [[TMP2:%.*]] = zext <4 x i1> [[TMP1]] to <4 x i32>
; CHECK-NEXT:    ret <4 x i32> [[TMP2]]
;
  %1 = urem <4 x i32> <i32 1, i32 1, i32 1, i32 1>, %a0
  ret <4 x i32> %1
}

define <4 x i32> @test_v4i32_one_undef(<4 x i32> %a0) {
; CHECK-LABEL: @test_v4i32_one_undef(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne <4 x i32> [[A0:%.*]], <i32 1, i32 1, i32 1, i32 1>
; CHECK-NEXT:    [[TMP2:%.*]] = zext <4 x i1> [[TMP1]] to <4 x i32>
; CHECK-NEXT:    ret <4 x i32> [[TMP2]]
;
  %1 = urem <4 x i32> <i32 1, i32 1, i32 1, i32 undef>, %a0
  ret <4 x i32> %1
}

define <4 x i32> @test_v4i32_negconstsplat(<4 x i32> %a0) {
; CHECK-LABEL: @test_v4i32_negconstsplat(
; CHECK-NEXT:    [[A0_FR:%.*]] = freeze <4 x i32> [[A0:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult <4 x i32> [[A0_FR]], <i32 -3, i32 -3, i32 -3, i32 -3>
; CHECK-NEXT:    [[TMP2:%.*]] = add <4 x i32> [[A0_FR]], <i32 3, i32 3, i32 3, i32 3>
; CHECK-NEXT:    [[TMP3:%.*]] = select <4 x i1> [[TMP1]], <4 x i32> [[A0_FR]], <4 x i32> [[TMP2]]
; CHECK-NEXT:    ret <4 x i32> [[TMP3]]
;
  %1 = urem <4 x i32> %a0, <i32 -3, i32 -3, i32 -3, i32 -3>
  ret <4 x i32> %1
}

define <4 x i32> @test_v4i32_negconst(<4 x i32> %a0) {
; CHECK-LABEL: @test_v4i32_negconst(
; CHECK-NEXT:    [[A0_FR:%.*]] = freeze <4 x i32> [[A0:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult <4 x i32> [[A0_FR]], <i32 -3, i32 -5, i32 -7, i32 -9>
; CHECK-NEXT:    [[TMP2:%.*]] = add <4 x i32> [[A0_FR]], <i32 3, i32 5, i32 7, i32 9>
; CHECK-NEXT:    [[TMP3:%.*]] = select <4 x i1> [[TMP1]], <4 x i32> [[A0_FR]], <4 x i32> [[TMP2]]
; CHECK-NEXT:    ret <4 x i32> [[TMP3]]
;
  %1 = urem <4 x i32> %a0, <i32 -3, i32 -5, i32 -7, i32 -9>
  ret <4 x i32> %1
}

define <4 x i32> @test_v4i32_negconst_undef(<4 x i32> %a0) {
; CHECK-LABEL: @test_v4i32_negconst_undef(
; CHECK-NEXT:    ret <4 x i32> poison
;
  %1 = urem <4 x i32> %a0, <i32 -3, i32 -5, i32 -7, i32 undef>
  ret <4 x i32> %1
}
