; NOTE: Assertions have been autogenerated by update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s
target datalayout = "p:32:32"

; Check some past-the-end subtleties.

@opte_a = global i32 0
@opte_b = global i32 0

; Comparing base addresses of two distinct globals. Never equal.

define zeroext i1 @no_offsets() {
; CHECK-LABEL: @no_offsets(
; CHECK:         ret i1 false
;
  %t = icmp eq ptr @opte_a, @opte_b
  ret i1 %t
}

; Comparing past-the-end addresses of two distinct globals. Never equal.

define zeroext i1 @both_past_the_end() {
; CHECK-LABEL: @both_past_the_end(
; CHECK:         ret i1 icmp eq (ptr getelementptr inbounds (i32, ptr @opte_a, i32 1), ptr getelementptr inbounds (i32, ptr @opte_b, i32 1))
;
  %x = getelementptr i32, ptr @opte_a, i32 1
  %y = getelementptr i32, ptr @opte_b, i32 1
  %t = icmp eq ptr %x, %y
  ret i1 %t
  ; TODO: refine this
}

; Comparing past-the-end addresses of one global to the base address
; of another. Can't fold this.

define zeroext i1 @just_one_past_the_end() {
; CHECK-LABEL: @just_one_past_the_end(
; CHECK:         ret i1 icmp eq (ptr getelementptr inbounds (i32, ptr @opte_a, i32 1), ptr @opte_b)
;
  %x = getelementptr i32, ptr @opte_a, i32 1
  %t = icmp eq ptr %x, @opte_b
  ret i1 %t
}

; Comparing base addresses of two distinct allocas. Never equal.

define zeroext i1 @no_alloca_offsets() {
; CHECK-LABEL: @no_alloca_offsets(
; CHECK:         ret i1 false
;
  %m = alloca i32
  %n = alloca i32
  %t = icmp eq ptr %m, %n
  ret i1 %t
}

; Comparing past-the-end addresses of two distinct allocas. Never equal.

define zeroext i1 @both_past_the_end_alloca() {
; CHECK-LABEL: @both_past_the_end_alloca(
; CHECK:         [[M:%.*]] = alloca i32
; CHECK-NEXT:    [[N:%.*]] = alloca i32
; CHECK-NEXT:    [[X:%.*]] = getelementptr i32, ptr [[M]], i32 1
; CHECK-NEXT:    [[Y:%.*]] = getelementptr i32, ptr [[N]], i32 1
; CHECK-NEXT:    [[T:%.*]] = icmp eq ptr [[X]], [[Y]]
; CHECK-NEXT:    ret i1 [[T]]
;
  %m = alloca i32
  %n = alloca i32
  %x = getelementptr i32, ptr %m, i32 1
  %y = getelementptr i32, ptr %n, i32 1
  %t = icmp eq ptr %x, %y
  ret i1 %t
  ; TODO: refine this
}

; Comparing past-the-end addresses of one alloca to the base address
; of another. Can't fold this.

define zeroext i1 @just_one_past_the_end_alloca() {
; CHECK-LABEL: @just_one_past_the_end_alloca(
; CHECK:         [[M:%.*]] = alloca i32
; CHECK-NEXT:    [[N:%.*]] = alloca i32
; CHECK-NEXT:    [[X:%.*]] = getelementptr i32, ptr [[M]], i32 1
; CHECK-NEXT:    [[T:%.*]] = icmp eq ptr [[X]], [[N]]
; CHECK-NEXT:    ret i1 [[T]]
;
  %m = alloca i32
  %n = alloca i32
  %x = getelementptr i32, ptr %m, i32 1
  %t = icmp eq ptr %x, %n
  ret i1 %t
}
