; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -target-abi=ilp32 \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK
; RUN: llc -mtriple=riscv64 -mattr=+v -target-abi=lp64 \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK

define <vscale x 1 x i64> @vwmacc_vv_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, <vscale x 1 x i64> %vc) {
; CHECK-LABEL: vwmacc_vv_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vwmacc.vv v10, v8, v9
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
  %vd = sext <vscale x 1 x i32> %va to <vscale x 1 x i64>
  %ve = sext <vscale x 1 x i32> %vb to <vscale x 1 x i64>

  %x = mul <vscale x 1 x i64> %vd, %ve
  %y = add <vscale x 1 x i64> %x, %vc
  ret <vscale x 1 x i64> %y
}

define <vscale x 1 x i64> @vwmacc_vx_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i64> %vc) {
; CHECK-LABEL: vwmacc_vx_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vwmacc.vx v9, a0, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %vd = sext <vscale x 1 x i32> %va to <vscale x 1 x i64>
  %ve = sext <vscale x 1 x i32> %splat to <vscale x 1 x i64>

  %x = mul <vscale x 1 x i64> %vd, %ve
  %y = add <vscale x 1 x i64> %x, %vc
  ret <vscale x 1 x i64> %y
}

define <vscale x 1 x i64> @vwmaccu_vv_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, <vscale x 1 x i64> %vc) {
; CHECK-LABEL: vwmaccu_vv_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vwmaccu.vv v10, v8, v9
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
  %vd = zext <vscale x 1 x i32> %va to <vscale x 1 x i64>
  %ve = zext <vscale x 1 x i32> %vb to <vscale x 1 x i64>

  %x = mul <vscale x 1 x i64> %vd, %ve
  %y = add <vscale x 1 x i64> %x, %vc
  ret <vscale x 1 x i64> %y
}

define <vscale x 1 x i64> @vwmaccu_vx_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i64> %vc) {
; CHECK-LABEL: vwmaccu_vx_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vwmaccu.vx v9, a0, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %vd = zext <vscale x 1 x i32> %va to <vscale x 1 x i64>
  %ve = zext <vscale x 1 x i32> %splat to <vscale x 1 x i64>

  %x = mul <vscale x 1 x i64> %vd, %ve
  %y = add <vscale x 1 x i64> %x, %vc
  ret <vscale x 1 x i64> %y
}

define <vscale x 1 x i64> @vwmaccsu_vv_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, <vscale x 1 x i64> %vc) {
; CHECK-LABEL: vwmaccsu_vv_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vwmaccsu.vv v10, v9, v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
  %vd = zext <vscale x 1 x i32> %va to <vscale x 1 x i64>
  %ve = sext <vscale x 1 x i32> %vb to <vscale x 1 x i64>

  %x = mul <vscale x 1 x i64> %vd, %ve
  %y = add <vscale x 1 x i64> %x, %vc
  ret <vscale x 1 x i64> %y
}

define <vscale x 1 x i64> @vwmaccsu_vx_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i64> %vc) {
; CHECK-LABEL: vwmaccsu_vx_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vwmaccsu.vx v9, a0, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %vd = zext <vscale x 1 x i32> %va to <vscale x 1 x i64>
  %ve = sext <vscale x 1 x i32> %splat to <vscale x 1 x i64>

  %x = mul <vscale x 1 x i64> %vd, %ve
  %y = add <vscale x 1 x i64> %x, %vc
  ret <vscale x 1 x i64> %y
}

define <vscale x 1 x i64> @vwmaccus_vx_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i64> %vc) {
; CHECK-LABEL: vwmaccus_vx_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vwmaccus.vx v9, a0, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %vd = sext <vscale x 1 x i32> %va to <vscale x 1 x i64>
  %ve = zext <vscale x 1 x i32> %splat to <vscale x 1 x i64>

  %x = mul <vscale x 1 x i64> %vd, %ve
  %y = add <vscale x 1 x i64> %x, %vc
  ret <vscale x 1 x i64> %y
}

define <vscale x 2 x i64> @vwmacc_vv_nxv2i32(<vscale x 2 x i32> %va, <vscale x 2 x i32> %vb, <vscale x 2 x i64> %vc) {
; CHECK-LABEL: vwmacc_vv_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vwmacc.vv v10, v8, v9
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %vd = sext <vscale x 2 x i32> %va to <vscale x 2 x i64>
  %ve = sext <vscale x 2 x i32> %vb to <vscale x 2 x i64>

  %x = mul <vscale x 2 x i64> %vd, %ve
  %y = add <vscale x 2 x i64> %x, %vc
  ret <vscale x 2 x i64> %y
}

define <vscale x 2 x i64> @vwmacc_vx_nxv2i32(<vscale x 2 x i32> %va, i32 %b, <vscale x 2 x i64> %vc) {
; CHECK-LABEL: vwmacc_vx_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; CHECK-NEXT:    vwmacc.vx v10, a0, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %vd = sext <vscale x 2 x i32> %va to <vscale x 2 x i64>
  %ve = sext <vscale x 2 x i32> %splat to <vscale x 2 x i64>

  %x = mul <vscale x 2 x i64> %vd, %ve
  %y = add <vscale x 2 x i64> %x, %vc
  ret <vscale x 2 x i64> %y
}

define <vscale x 2 x i64> @vwmaccu_vv_nxv2i32(<vscale x 2 x i32> %va, <vscale x 2 x i32> %vb, <vscale x 2 x i64> %vc) {
; CHECK-LABEL: vwmaccu_vv_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vwmaccu.vv v10, v8, v9
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %vd = zext <vscale x 2 x i32> %va to <vscale x 2 x i64>
  %ve = zext <vscale x 2 x i32> %vb to <vscale x 2 x i64>

  %x = mul <vscale x 2 x i64> %vd, %ve
  %y = add <vscale x 2 x i64> %x, %vc
  ret <vscale x 2 x i64> %y
}

define <vscale x 2 x i64> @vwmaccu_vx_nxv2i32(<vscale x 2 x i32> %va, i32 %b, <vscale x 2 x i64> %vc) {
; CHECK-LABEL: vwmaccu_vx_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; CHECK-NEXT:    vwmaccu.vx v10, a0, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %vd = zext <vscale x 2 x i32> %va to <vscale x 2 x i64>
  %ve = zext <vscale x 2 x i32> %splat to <vscale x 2 x i64>

  %x = mul <vscale x 2 x i64> %vd, %ve
  %y = add <vscale x 2 x i64> %x, %vc
  ret <vscale x 2 x i64> %y
}

define <vscale x 2 x i64> @vwmaccsu_vv_nxv2i32(<vscale x 2 x i32> %va, <vscale x 2 x i32> %vb, <vscale x 2 x i64> %vc) {
; CHECK-LABEL: vwmaccsu_vv_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vwmaccsu.vv v10, v9, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %vd = zext <vscale x 2 x i32> %va to <vscale x 2 x i64>
  %ve = sext <vscale x 2 x i32> %vb to <vscale x 2 x i64>

  %x = mul <vscale x 2 x i64> %vd, %ve
  %y = add <vscale x 2 x i64> %x, %vc
  ret <vscale x 2 x i64> %y
}

define <vscale x 2 x i64> @vwmaccsu_vx_nxv2i32(<vscale x 2 x i32> %va, i32 %b, <vscale x 2 x i64> %vc) {
; CHECK-LABEL: vwmaccsu_vx_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; CHECK-NEXT:    vwmaccsu.vx v10, a0, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %vd = zext <vscale x 2 x i32> %va to <vscale x 2 x i64>
  %ve = sext <vscale x 2 x i32> %splat to <vscale x 2 x i64>

  %x = mul <vscale x 2 x i64> %vd, %ve
  %y = add <vscale x 2 x i64> %x, %vc
  ret <vscale x 2 x i64> %y
}

define <vscale x 2 x i64> @vwmaccus_vx_nxv2i32(<vscale x 2 x i32> %va, i32 %b, <vscale x 2 x i64> %vc) {
; CHECK-LABEL: vwmaccus_vx_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; CHECK-NEXT:    vwmaccus.vx v10, a0, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %vd = sext <vscale x 2 x i32> %va to <vscale x 2 x i64>
  %ve = zext <vscale x 2 x i32> %splat to <vscale x 2 x i64>

  %x = mul <vscale x 2 x i64> %vd, %ve
  %y = add <vscale x 2 x i64> %x, %vc
  ret <vscale x 2 x i64> %y
}

define <vscale x 4 x i64> @vwmacc_vv_nxv4i32(<vscale x 4 x i32> %va, <vscale x 4 x i32> %vb, <vscale x 4 x i64> %vc) {
; CHECK-LABEL: vwmacc_vv_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vwmacc.vv v12, v8, v10
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %vd = sext <vscale x 4 x i32> %va to <vscale x 4 x i64>
  %ve = sext <vscale x 4 x i32> %vb to <vscale x 4 x i64>

  %x = mul <vscale x 4 x i64> %vd, %ve
  %y = add <vscale x 4 x i64> %x, %vc
  ret <vscale x 4 x i64> %y
}

define <vscale x 4 x i64> @vwmacc_vx_nxv4i32(<vscale x 4 x i32> %va, i32 %b, <vscale x 4 x i64> %vc) {
; CHECK-LABEL: vwmacc_vx_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, mu
; CHECK-NEXT:    vwmacc.vx v12, a0, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %vd = sext <vscale x 4 x i32> %va to <vscale x 4 x i64>
  %ve = sext <vscale x 4 x i32> %splat to <vscale x 4 x i64>

  %x = mul <vscale x 4 x i64> %vd, %ve
  %y = add <vscale x 4 x i64> %x, %vc
  ret <vscale x 4 x i64> %y
}

define <vscale x 4 x i64> @vwmaccu_vv_nxv4i32(<vscale x 4 x i32> %va, <vscale x 4 x i32> %vb, <vscale x 4 x i64> %vc) {
; CHECK-LABEL: vwmaccu_vv_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vwmaccu.vv v12, v8, v10
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %vd = zext <vscale x 4 x i32> %va to <vscale x 4 x i64>
  %ve = zext <vscale x 4 x i32> %vb to <vscale x 4 x i64>

  %x = mul <vscale x 4 x i64> %vd, %ve
  %y = add <vscale x 4 x i64> %x, %vc
  ret <vscale x 4 x i64> %y
}

define <vscale x 4 x i64> @vwmaccu_vx_nxv4i32(<vscale x 4 x i32> %va, i32 %b, <vscale x 4 x i64> %vc) {
; CHECK-LABEL: vwmaccu_vx_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, mu
; CHECK-NEXT:    vwmaccu.vx v12, a0, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %vd = zext <vscale x 4 x i32> %va to <vscale x 4 x i64>
  %ve = zext <vscale x 4 x i32> %splat to <vscale x 4 x i64>

  %x = mul <vscale x 4 x i64> %vd, %ve
  %y = add <vscale x 4 x i64> %x, %vc
  ret <vscale x 4 x i64> %y
}

define <vscale x 4 x i64> @vwmaccsu_vv_nxv4i32(<vscale x 4 x i32> %va, <vscale x 4 x i32> %vb, <vscale x 4 x i64> %vc) {
; CHECK-LABEL: vwmaccsu_vv_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vwmaccsu.vv v12, v10, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %vd = zext <vscale x 4 x i32> %va to <vscale x 4 x i64>
  %ve = sext <vscale x 4 x i32> %vb to <vscale x 4 x i64>

  %x = mul <vscale x 4 x i64> %vd, %ve
  %y = add <vscale x 4 x i64> %x, %vc
  ret <vscale x 4 x i64> %y
}

define <vscale x 4 x i64> @vwmaccsu_vx_nxv4i32(<vscale x 4 x i32> %va, i32 %b, <vscale x 4 x i64> %vc) {
; CHECK-LABEL: vwmaccsu_vx_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, mu
; CHECK-NEXT:    vwmaccsu.vx v12, a0, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %vd = zext <vscale x 4 x i32> %va to <vscale x 4 x i64>
  %ve = sext <vscale x 4 x i32> %splat to <vscale x 4 x i64>

  %x = mul <vscale x 4 x i64> %vd, %ve
  %y = add <vscale x 4 x i64> %x, %vc
  ret <vscale x 4 x i64> %y
}

define <vscale x 4 x i64> @vwmaccus_vx_nxv4i32(<vscale x 4 x i32> %va, i32 %b, <vscale x 4 x i64> %vc) {
; CHECK-LABEL: vwmaccus_vx_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, mu
; CHECK-NEXT:    vwmaccus.vx v12, a0, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %vd = sext <vscale x 4 x i32> %va to <vscale x 4 x i64>
  %ve = zext <vscale x 4 x i32> %splat to <vscale x 4 x i64>

  %x = mul <vscale x 4 x i64> %vd, %ve
  %y = add <vscale x 4 x i64> %x, %vc
  ret <vscale x 4 x i64> %y
}

define <vscale x 8 x i64> @vwmacc_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, <vscale x 8 x i64> %vc) {
; CHECK-LABEL: vwmacc_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vwmacc.vv v16, v8, v12
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %vd = sext <vscale x 8 x i32> %va to <vscale x 8 x i64>
  %ve = sext <vscale x 8 x i32> %vb to <vscale x 8 x i64>

  %x = mul <vscale x 8 x i64> %vd, %ve
  %y = add <vscale x 8 x i64> %x, %vc
  ret <vscale x 8 x i64> %y
}

define <vscale x 8 x i64> @vwmacc_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i64> %vc) {
; CHECK-LABEL: vwmacc_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, mu
; CHECK-NEXT:    vwmacc.vx v16, a0, v8
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vd = sext <vscale x 8 x i32> %va to <vscale x 8 x i64>
  %ve = sext <vscale x 8 x i32> %splat to <vscale x 8 x i64>

  %x = mul <vscale x 8 x i64> %vd, %ve
  %y = add <vscale x 8 x i64> %x, %vc
  ret <vscale x 8 x i64> %y
}

define <vscale x 8 x i64> @vwmaccu_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, <vscale x 8 x i64> %vc) {
; CHECK-LABEL: vwmaccu_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vwmaccu.vv v16, v8, v12
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %vd = zext <vscale x 8 x i32> %va to <vscale x 8 x i64>
  %ve = zext <vscale x 8 x i32> %vb to <vscale x 8 x i64>

  %x = mul <vscale x 8 x i64> %vd, %ve
  %y = add <vscale x 8 x i64> %x, %vc
  ret <vscale x 8 x i64> %y
}

define <vscale x 8 x i64> @vwmaccu_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i64> %vc) {
; CHECK-LABEL: vwmaccu_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, mu
; CHECK-NEXT:    vwmaccu.vx v16, a0, v8
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vd = zext <vscale x 8 x i32> %va to <vscale x 8 x i64>
  %ve = zext <vscale x 8 x i32> %splat to <vscale x 8 x i64>

  %x = mul <vscale x 8 x i64> %vd, %ve
  %y = add <vscale x 8 x i64> %x, %vc
  ret <vscale x 8 x i64> %y
}

define <vscale x 8 x i64> @vwmaccsu_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, <vscale x 8 x i64> %vc) {
; CHECK-LABEL: vwmaccsu_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vwmaccsu.vv v16, v12, v8
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %vd = zext <vscale x 8 x i32> %va to <vscale x 8 x i64>
  %ve = sext <vscale x 8 x i32> %vb to <vscale x 8 x i64>

  %x = mul <vscale x 8 x i64> %vd, %ve
  %y = add <vscale x 8 x i64> %x, %vc
  ret <vscale x 8 x i64> %y
}

define <vscale x 8 x i64> @vwmaccsu_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i64> %vc) {
; CHECK-LABEL: vwmaccsu_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, mu
; CHECK-NEXT:    vwmaccsu.vx v16, a0, v8
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vd = zext <vscale x 8 x i32> %va to <vscale x 8 x i64>
  %ve = sext <vscale x 8 x i32> %splat to <vscale x 8 x i64>

  %x = mul <vscale x 8 x i64> %vd, %ve
  %y = add <vscale x 8 x i64> %x, %vc
  ret <vscale x 8 x i64> %y
}

define <vscale x 8 x i64> @vwmaccus_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i64> %vc) {
; CHECK-LABEL: vwmaccus_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, mu
; CHECK-NEXT:    vwmaccus.vx v16, a0, v8
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vd = sext <vscale x 8 x i32> %va to <vscale x 8 x i64>
  %ve = zext <vscale x 8 x i32> %splat to <vscale x 8 x i64>

  %x = mul <vscale x 8 x i64> %vd, %ve
  %y = add <vscale x 8 x i64> %x, %vc
  ret <vscale x 8 x i64> %y
}
