/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

#include "include/support.h"
#include "include/paritycommand.h"
#include "include/message.h"

class LWCommandFor: public LWCommandSegment {
	
LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	g_return_val_if_fail (argc == 1, NULL);
	g_return_val_if_fail (context->instrPtr->next != NULL, NULL);

	if (FALSE == args[0]->isVariable())
		throw new LWMessage (LW_ERROR_LValueIsNotVariable);

	g_queue_push_head (context->stack, (gpointer) args[0]);

	return NULL;
}

const gchar *getName (void)
{
	return "for2";
}	

gchar *getHint ()
{
	return _("For");
}

void checkArgument (guint n, LWValue *value)
{
	if (n == 0)
		if (FALSE == value->isVariable())
			throw new LWMessage (LW_ERROR_NeedVariableAsArgument);
}

void checkArgc (guint n)
{
	if (n != 1) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}

gboolean matchNextCondition (LWCommand *cmd)
{
	(void) cmd;
	return TRUE;
}

gboolean matchWith (LWCommand *cmd)
{
	if (cmd == NULL)
		throw new LWMessage (LW_ERROR_ForButWhereIsToOrDownto);
	
	if (g_ascii_strcasecmp (cmd->getName(), "to"))
		if (g_ascii_strcasecmp (cmd->getName(), "downto"))
			throw new LWMessage (LW_ERROR_ForButWhereIsToOrDownto);
	
	match();
	
	return TRUE;
}

};

LWSymbol *new_LWCommandFor()
{
	return new LWCommandFor();
}
