/* Copyright 2017 R. Thomas
 * Copyright 2017 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_MSVCR120_DLL_LOOKUP_H_
#define LIEF_PE_MSVCR120_DLL_LOOKUP_H_

#include <map>

namespace LIEF {
namespace PE {

static const std::map<uint32_t, const char*> msvcr120_dll_lookup {
    { 0x0145, "$I10_OUTPUT"                                                                                                       },
    { 0x0001, "??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z"                                                              },
    { 0x0002, "??0?$_SpinWait@$0A@@details@Concurrency@@QAE@P6AXXZ@Z"                                                             },
    { 0x0003, "??0SchedulerPolicy@Concurrency@@QAA@IZZ"                                                                           },
    { 0x0004, "??0SchedulerPolicy@Concurrency@@QAE@ABV01@@Z"                                                                      },
    { 0x0005, "??0SchedulerPolicy@Concurrency@@QAE@XZ"                                                                            },
    { 0x0006, "??0_Cancellation_beacon@details@Concurrency@@QAE@XZ"                                                               },
    { 0x0007, "??0_Condition_variable@details@Concurrency@@QAE@XZ"                                                                },
    { 0x0008, "??0_Context@details@Concurrency@@QAE@PAVContext@2@@Z"                                                              },
    { 0x0009, "??0_Interruption_exception@details@Concurrency@@QAE@PBD@Z"                                                         },
    { 0x000a, "??0_Interruption_exception@details@Concurrency@@QAE@XZ"                                                            },
    { 0x000b, "??0_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ"                                                          },
    { 0x000c, "??0_NonReentrantPPLLock@details@Concurrency@@QAE@XZ"                                                               },
    { 0x000d, "??0_ReaderWriterLock@details@Concurrency@@QAE@XZ"                                                                  },
    { 0x000e, "??0_ReentrantBlockingLock@details@Concurrency@@QAE@XZ"                                                             },
    { 0x000f, "??0_ReentrantLock@details@Concurrency@@QAE@XZ"                                                                     },
    { 0x0010, "??0_ReentrantPPLLock@details@Concurrency@@QAE@XZ"                                                                  },
    { 0x0011, "??0_Scheduler@details@Concurrency@@QAE@PAVScheduler@2@@Z"                                                          },
    { 0x0012, "??0_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z"                                           },
    { 0x0013, "??0_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z"                                              },
    { 0x0014, "??0_SpinLock@details@Concurrency@@QAE@ACJ@Z"                                                                       },
    { 0x0015, "??0_StructuredTaskCollection@details@Concurrency@@QAE@PAV_CancellationTokenState@12@@Z"                            },
    { 0x0016, "??0_TaskCollection@details@Concurrency@@QAE@PAV_CancellationTokenState@12@@Z"                                      },
    { 0x0017, "??0_TaskCollection@details@Concurrency@@QAE@XZ"                                                                    },
    { 0x0018, "??0_Timer@details@Concurrency@@IAE@I_N@Z"                                                                          },
    { 0x0019, "??0__non_rtti_object@std@@QAE@ABV01@@Z"                                                                            },
    { 0x001a, "??0__non_rtti_object@std@@QAE@PBD@Z"                                                                               },
    { 0x001b, "??0bad_cast@std@@AAE@PBQBD@Z"                                                                                      },
    { 0x001c, "??0bad_cast@std@@QAE@ABV01@@Z"                                                                                     },
    { 0x001d, "??0bad_cast@std@@QAE@PBD@Z"                                                                                        },
    { 0x001e, "??0bad_target@Concurrency@@QAE@PBD@Z"                                                                              },
    { 0x001f, "??0bad_target@Concurrency@@QAE@XZ"                                                                                 },
    { 0x0020, "??0bad_typeid@std@@QAE@ABV01@@Z"                                                                                   },
    { 0x0021, "??0bad_typeid@std@@QAE@PBD@Z"                                                                                      },
    { 0x0022, "??0context_self_unblock@Concurrency@@QAE@PBD@Z"                                                                    },
    { 0x0023, "??0context_self_unblock@Concurrency@@QAE@XZ"                                                                       },
    { 0x0024, "??0context_unblock_unbalanced@Concurrency@@QAE@PBD@Z"                                                              },
    { 0x0025, "??0context_unblock_unbalanced@Concurrency@@QAE@XZ"                                                                 },
    { 0x0026, "??0critical_section@Concurrency@@QAE@XZ"                                                                           },
    { 0x0027, "??0default_scheduler_exists@Concurrency@@QAE@PBD@Z"                                                                },
    { 0x0028, "??0default_scheduler_exists@Concurrency@@QAE@XZ"                                                                   },
    { 0x0029, "??0event@Concurrency@@QAE@XZ"                                                                                      },
    { 0x002a, "??0exception@std@@QAE@ABQBD@Z"                                                                                     },
    { 0x002b, "??0exception@std@@QAE@ABQBDH@Z"                                                                                    },
    { 0x002c, "??0exception@std@@QAE@ABV01@@Z"                                                                                    },
    { 0x002d, "??0exception@std@@QAE@XZ"                                                                                          },
    { 0x002e, "??0improper_lock@Concurrency@@QAE@PBD@Z"                                                                           },
    { 0x002f, "??0improper_lock@Concurrency@@QAE@XZ"                                                                              },
    { 0x0030, "??0improper_scheduler_attach@Concurrency@@QAE@PBD@Z"                                                               },
    { 0x0031, "??0improper_scheduler_attach@Concurrency@@QAE@XZ"                                                                  },
    { 0x0032, "??0improper_scheduler_detach@Concurrency@@QAE@PBD@Z"                                                               },
    { 0x0033, "??0improper_scheduler_detach@Concurrency@@QAE@XZ"                                                                  },
    { 0x0034, "??0improper_scheduler_reference@Concurrency@@QAE@PBD@Z"                                                            },
    { 0x0035, "??0improper_scheduler_reference@Concurrency@@QAE@XZ"                                                               },
    { 0x0036, "??0invalid_link_target@Concurrency@@QAE@PBD@Z"                                                                     },
    { 0x0037, "??0invalid_link_target@Concurrency@@QAE@XZ"                                                                        },
    { 0x0038, "??0invalid_multiple_scheduling@Concurrency@@QAE@PBD@Z"                                                             },
    { 0x0039, "??0invalid_multiple_scheduling@Concurrency@@QAE@XZ"                                                                },
    { 0x003a, "??0invalid_operation@Concurrency@@QAE@PBD@Z"                                                                       },
    { 0x003b, "??0invalid_operation@Concurrency@@QAE@XZ"                                                                          },
    { 0x003c, "??0invalid_oversubscribe_operation@Concurrency@@QAE@PBD@Z"                                                         },
    { 0x003d, "??0invalid_oversubscribe_operation@Concurrency@@QAE@XZ"                                                            },
    { 0x003e, "??0invalid_scheduler_policy_key@Concurrency@@QAE@PBD@Z"                                                            },
    { 0x003f, "??0invalid_scheduler_policy_key@Concurrency@@QAE@XZ"                                                               },
    { 0x0040, "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@PBD@Z"                                           },
    { 0x0041, "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@XZ"                                              },
    { 0x0042, "??0invalid_scheduler_policy_value@Concurrency@@QAE@PBD@Z"                                                          },
    { 0x0043, "??0invalid_scheduler_policy_value@Concurrency@@QAE@XZ"                                                             },
    { 0x0044, "??0message_not_found@Concurrency@@QAE@PBD@Z"                                                                       },
    { 0x0045, "??0message_not_found@Concurrency@@QAE@XZ"                                                                          },
    { 0x0046, "??0missing_wait@Concurrency@@QAE@PBD@Z"                                                                            },
    { 0x0047, "??0missing_wait@Concurrency@@QAE@XZ"                                                                               },
    { 0x0048, "??0nested_scheduler_missing_detach@Concurrency@@QAE@PBD@Z"                                                         },
    { 0x0049, "??0nested_scheduler_missing_detach@Concurrency@@QAE@XZ"                                                            },
    { 0x004a, "??0operation_timed_out@Concurrency@@QAE@PBD@Z"                                                                     },
    { 0x004b, "??0operation_timed_out@Concurrency@@QAE@XZ"                                                                        },
    { 0x004c, "??0reader_writer_lock@Concurrency@@QAE@XZ"                                                                         },
    { 0x004d, "??0scheduler_not_attached@Concurrency@@QAE@PBD@Z"                                                                  },
    { 0x004e, "??0scheduler_not_attached@Concurrency@@QAE@XZ"                                                                     },
    { 0x004f, "??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z"                                                       },
    { 0x0050, "??0scheduler_resource_allocation_error@Concurrency@@QAE@PBDJ@Z"                                                    },
    { 0x0051, "??0scheduler_worker_creation_error@Concurrency@@QAE@J@Z"                                                           },
    { 0x0052, "??0scheduler_worker_creation_error@Concurrency@@QAE@PBDJ@Z"                                                        },
    { 0x0053, "??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z"                                                         },
    { 0x0054, "??0scoped_lock@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"                                                       },
    { 0x0055, "??0scoped_lock_read@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"                                                  },
    { 0x0056, "??0task_canceled@Concurrency@@QAE@PBD@Z"                                                                           },
    { 0x0057, "??0task_canceled@Concurrency@@QAE@XZ"                                                                              },
    { 0x0058, "??0unsupported_os@Concurrency@@QAE@PBD@Z"                                                                          },
    { 0x0059, "??0unsupported_os@Concurrency@@QAE@XZ"                                                                             },
    { 0x005a, "??1SchedulerPolicy@Concurrency@@QAE@XZ"                                                                            },
    { 0x005b, "??1_Cancellation_beacon@details@Concurrency@@QAE@XZ"                                                               },
    { 0x005c, "??1_Condition_variable@details@Concurrency@@QAE@XZ"                                                                },
    { 0x005d, "??1_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ"                                                          },
    { 0x005e, "??1_ReentrantBlockingLock@details@Concurrency@@QAE@XZ"                                                             },
    { 0x005f, "??1_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@XZ"                                                  },
    { 0x0060, "??1_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@XZ"                                                     },
    { 0x0061, "??1_SpinLock@details@Concurrency@@QAE@XZ"                                                                          },
    { 0x0062, "??1_StructuredTaskCollection@details@Concurrency@@QAE@XZ"                                                          },
    { 0x0063, "??1_TaskCollection@details@Concurrency@@QAE@XZ"                                                                    },
    { 0x0064, "??1_Timer@details@Concurrency@@MAE@XZ"                                                                             },
    { 0x0065, "??1__non_rtti_object@std@@UAE@XZ"                                                                                  },
    { 0x0066, "??1bad_cast@std@@UAE@XZ"                                                                                           },
    { 0x0067, "??1bad_typeid@std@@UAE@XZ"                                                                                         },
    { 0x0068, "??1critical_section@Concurrency@@QAE@XZ"                                                                           },
    { 0x0069, "??1event@Concurrency@@QAE@XZ"                                                                                      },
    { 0x006a, "??1exception@std@@UAE@XZ"                                                                                          },
    { 0x006b, "??1reader_writer_lock@Concurrency@@QAE@XZ"                                                                         },
    { 0x006c, "??1scoped_lock@critical_section@Concurrency@@QAE@XZ"                                                               },
    { 0x006d, "??1scoped_lock@reader_writer_lock@Concurrency@@QAE@XZ"                                                             },
    { 0x006e, "??1scoped_lock_read@reader_writer_lock@Concurrency@@QAE@XZ"                                                        },
    { 0x006f, "??1type_info@@UAE@XZ"                                                                                              },
    { 0x0070, "??2@YAPAXI@Z"                                                                                                      },
    { 0x0071, "??2@YAPAXIHPBDH@Z"                                                                                                 },
    { 0x0072, "??3@YAXPAX@Z"                                                                                                      },
    { 0x0073, "??3@YAXPAXHPBDH@Z"                                                                                                 },
    { 0x0074, "??4?$_SpinWait@$00@details@Concurrency@@QAEAAV012@ABV012@@Z"                                                       },
    { 0x0075, "??4?$_SpinWait@$0A@@details@Concurrency@@QAEAAV012@ABV012@@Z"                                                      },
    { 0x0076, "??4SchedulerPolicy@Concurrency@@QAEAAV01@ABV01@@Z"                                                                 },
    { 0x0077, "??4__non_rtti_object@std@@QAEAAV01@ABV01@@Z"                                                                       },
    { 0x0078, "??4bad_cast@std@@QAEAAV01@ABV01@@Z"                                                                                },
    { 0x0079, "??4bad_typeid@std@@QAEAAV01@ABV01@@Z"                                                                              },
    { 0x007a, "??4exception@std@@QAEAAV01@ABV01@@Z"                                                                               },
    { 0x007b, "??8type_info@@QBE_NABV0@@Z"                                                                                        },
    { 0x007c, "??9type_info@@QBE_NABV0@@Z"                                                                                        },
    { 0x007d, "??_7__non_rtti_object@std@@6B@"                                                                                    },
    { 0x007e, "??_7bad_cast@std@@6B@"                                                                                             },
    { 0x007f, "??_7bad_typeid@std@@6B@"                                                                                           },
    { 0x0080, "??_7exception@std@@6B@"                                                                                            },
    { 0x0081, "??_F?$_SpinWait@$00@details@Concurrency@@QAEXXZ"                                                                   },
    { 0x0082, "??_F?$_SpinWait@$0A@@details@Concurrency@@QAEXXZ"                                                                  },
    { 0x0083, "??_F_Context@details@Concurrency@@QAEXXZ"                                                                          },
    { 0x0084, "??_F_Scheduler@details@Concurrency@@QAEXXZ"                                                                        },
    { 0x0085, "??_Fbad_cast@std@@QAEXXZ"                                                                                          },
    { 0x0086, "??_Fbad_typeid@std@@QAEXXZ"                                                                                        },
    { 0x0087, "??_U@YAPAXI@Z"                                                                                                     },
    { 0x0088, "??_U@YAPAXIHPBDH@Z"                                                                                                },
    { 0x0089, "??_V@YAXPAX@Z"                                                                                                     },
    { 0x008a, "??_V@YAXPAXHPBDH@Z"                                                                                                },
    { 0x008b, "?Alloc@Concurrency@@YAPAXI@Z"                                                                                      },
    { 0x008c, "?Block@Context@Concurrency@@SAXXZ"                                                                                 },
    { 0x008d, "?CaptureCallstack@platform@details@Concurrency@@YAIPAPAXII@Z"                                                      },
    { 0x008e, "?Create@CurrentScheduler@Concurrency@@SAXABVSchedulerPolicy@2@@Z"                                                  },
    { 0x008f, "?Create@Scheduler@Concurrency@@SAPAV12@ABVSchedulerPolicy@2@@Z"                                                    },
    { 0x0090, "?CreateResourceManager@Concurrency@@YAPAUIResourceManager@1@XZ"                                                    },
    { 0x0091, "?CreateScheduleGroup@CurrentScheduler@Concurrency@@SAPAVScheduleGroup@2@AAVlocation@2@@Z"                          },
    { 0x0092, "?CreateScheduleGroup@CurrentScheduler@Concurrency@@SAPAVScheduleGroup@2@XZ"                                        },
    { 0x0093, "?CurrentContext@Context@Concurrency@@SAPAV12@XZ"                                                                   },
    { 0x0094, "?Detach@CurrentScheduler@Concurrency@@SAXXZ"                                                                       },
    { 0x0095, "?DisableTracing@Concurrency@@YAJXZ"                                                                                },
    { 0x0096, "?EnableTracing@Concurrency@@YAJXZ"                                                                                 },
    { 0x0097, "?Free@Concurrency@@YAXPAX@Z"                                                                                       },
    { 0x0098, "?Get@CurrentScheduler@Concurrency@@SAPAVScheduler@2@XZ"                                                            },
    { 0x0099, "?GetCurrentThreadId@platform@details@Concurrency@@YAJXZ"                                                           },
    { 0x009a, "?GetExecutionContextId@Concurrency@@YAIXZ"                                                                         },
    { 0x009b, "?GetNumberOfVirtualProcessors@CurrentScheduler@Concurrency@@SAIXZ"                                                 },
    { 0x009c, "?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ"                                                  },
    { 0x009d, "?GetPolicy@CurrentScheduler@Concurrency@@SA?AVSchedulerPolicy@2@XZ"                                                },
    { 0x009e, "?GetPolicyValue@SchedulerPolicy@Concurrency@@QBEIW4PolicyElementKey@2@@Z"                                          },
    { 0x009f, "?GetProcessorCount@Concurrency@@YAIXZ"                                                                             },
    { 0x00a0, "?GetProcessorNodeCount@Concurrency@@YAIXZ"                                                                         },
    { 0x00a1, "?GetSchedulerId@Concurrency@@YAIXZ"                                                                                },
    { 0x00a2, "?GetSharedTimerQueue@details@Concurrency@@YAPAXXZ"                                                                 },
    { 0x00a3, "?Id@Context@Concurrency@@SAIXZ"                                                                                    },
    { 0x00a4, "?Id@CurrentScheduler@Concurrency@@SAIXZ"                                                                           },
    { 0x00a5, "?IsAvailableLocation@CurrentScheduler@Concurrency@@SA_NABVlocation@2@@Z"                                           },
    { 0x00a6, "?IsCurrentTaskCollectionCanceling@Context@Concurrency@@SA_NXZ"                                                     },
    { 0x00a7, "?Log2@details@Concurrency@@YAKI@Z"                                                                                 },
    { 0x00a8, "?Oversubscribe@Context@Concurrency@@SAX_N@Z"                                                                       },
    { 0x00a9, "?RegisterShutdownEvent@CurrentScheduler@Concurrency@@SAXPAX@Z"                                                     },
    { 0x00aa, "?ResetDefaultSchedulerPolicy@Scheduler@Concurrency@@SAXXZ"                                                         },
    { 0x00ab, "?ScheduleGroupId@Context@Concurrency@@SAIXZ"                                                                       },
    { 0x00ac, "?ScheduleTask@CurrentScheduler@Concurrency@@SAXP6AXPAX@Z0@Z"                                                       },
    { 0x00ad, "?ScheduleTask@CurrentScheduler@Concurrency@@SAXP6AXPAX@Z0AAVlocation@2@@Z"                                         },
    { 0x00ae, "?SetConcurrencyLimits@SchedulerPolicy@Concurrency@@QAEXII@Z"                                                       },
    { 0x00af, "?SetDefaultSchedulerPolicy@Scheduler@Concurrency@@SAXABVSchedulerPolicy@2@@Z"                                      },
    { 0x00b0, "?SetPolicyValue@SchedulerPolicy@Concurrency@@QAEIW4PolicyElementKey@2@I@Z"                                         },
    { 0x00b1, "?VirtualProcessorId@Context@Concurrency@@SAIXZ"                                                                    },
    { 0x00b2, "?Yield@Context@Concurrency@@SAXXZ"                                                                                 },
    { 0x00b3, "?_Abort@_StructuredTaskCollection@details@Concurrency@@AAEXXZ"                                                     },
    { 0x00b4, "?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ"                                                   },
    { 0x00b5, "?_Acquire@_NonReentrantPPLLock@details@Concurrency@@QAEXPAX@Z"                                                     },
    { 0x00b6, "?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ"                                                      },
    { 0x00b7, "?_Acquire@_ReentrantLock@details@Concurrency@@QAEXXZ"                                                              },
    { 0x00b8, "?_Acquire@_ReentrantPPLLock@details@Concurrency@@QAEXPAX@Z"                                                        },
    { 0x00b9, "?_AcquireRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ"                                                       },
    { 0x00ba, "?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"                                                      },
    { 0x00bb, "?_Cancel@_StructuredTaskCollection@details@Concurrency@@QAEXXZ"                                                    },
    { 0x00bc, "?_Cancel@_TaskCollection@details@Concurrency@@QAEXXZ"                                                              },
    { 0x00bd, "?_CheckTaskCollection@_UnrealizedChore@details@Concurrency@@IAEXXZ"                                                },
    { 0x00be, "?_CleanupToken@_StructuredTaskCollection@details@Concurrency@@AAEXXZ"                                              },
    { 0x00bf, "?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z"                                                               },
    { 0x00c0, "?_ConcRT_Trace@details@Concurrency@@YAXHPB_WZZ"                                                                    },
    { 0x00c1, "?_Confirm_cancel@_Cancellation_beacon@details@Concurrency@@QAE_NXZ"                                                },
    { 0x00c2, "?_Copy_str@exception@std@@AAEXPBD@Z"                                                                               },
    { 0x00c3, "?_CurrentContext@_Context@details@Concurrency@@SA?AV123@XZ"                                                        },
    { 0x00c4, "?_Current_node@location@Concurrency@@SA?AV12@XZ"                                                                   },
    { 0x00c5, "?_Destroy@_AsyncTaskCollection@details@Concurrency@@EAEXXZ"                                                        },
    { 0x00c6, "?_DoYield@?$_SpinWait@$00@details@Concurrency@@IAEXXZ"                                                             },
    { 0x00c7, "?_DoYield@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ"                                                            },
    { 0x00c8, "?_Get@_CurrentScheduler@details@Concurrency@@SA?AV_Scheduler@23@XZ"                                                },
    { 0x00c9, "?_GetConcRTTraceInfo@Concurrency@@YAPBU_CONCRT_TRACE_INFO@details@1@XZ"                                            },
    { 0x00ca, "?_GetConcurrency@details@Concurrency@@YAIXZ"                                                                       },
    { 0x00cb, "?_GetCurrentInlineDepth@_StackGuard@details@Concurrency@@CAAAIXZ"                                                  },
    { 0x00cc, "?_GetNumberOfVirtualProcessors@_CurrentScheduler@details@Concurrency@@SAIXZ"                                       },
    { 0x00cd, "?_GetScheduler@_Scheduler@details@Concurrency@@QAEPAVScheduler@3@XZ"                                               },
    { 0x00ce, "?_Id@_CurrentScheduler@details@Concurrency@@SAIXZ"                                                                 },
    { 0x00cf, "?_IsCanceling@_StructuredTaskCollection@details@Concurrency@@QAE_NXZ"                                              },
    { 0x00d0, "?_IsCanceling@_TaskCollection@details@Concurrency@@QAE_NXZ"                                                        },
    { 0x00d1, "?_IsSynchronouslyBlocked@_Context@details@Concurrency@@QBE_NXZ"                                                    },
    { 0x00d2, "?_Name_base@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z"                                                          },
    { 0x00d3, "?_Name_base_internal@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z"                                                 },
    { 0x00d4, "?_NewCollection@_AsyncTaskCollection@details@Concurrency@@SAPAV123@PAV_CancellationTokenState@23@@Z"               },
    { 0x00d5, "?_NumberOfSpins@?$_SpinWait@$00@details@Concurrency@@IAEKXZ"                                                       },
    { 0x00d6, "?_NumberOfSpins@?$_SpinWait@$0A@@details@Concurrency@@IAEKXZ"                                                      },
    { 0x00d7, "?_Oversubscribe@_Context@details@Concurrency@@SAX_N@Z"                                                             },
    { 0x00d8, "?_Reference@_Scheduler@details@Concurrency@@QAEIXZ"                                                                },
    { 0x00d9, "?_Release@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ"                                                   },
    { 0x00da, "?_Release@_NonReentrantPPLLock@details@Concurrency@@QAEXXZ"                                                        },
    { 0x00db, "?_Release@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ"                                                      },
    { 0x00dc, "?_Release@_ReentrantLock@details@Concurrency@@QAEXXZ"                                                              },
    { 0x00dd, "?_Release@_ReentrantPPLLock@details@Concurrency@@QAEXXZ"                                                           },
    { 0x00de, "?_Release@_Scheduler@details@Concurrency@@QAEIXZ"                                                                  },
    { 0x00df, "?_ReleaseRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ"                                                       },
    { 0x00e0, "?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"                                                      },
    { 0x00e1, "?_ReportUnobservedException@details@Concurrency@@YAXXZ"                                                            },
    { 0x00e2, "?_Reset@?$_SpinWait@$00@details@Concurrency@@IAEXXZ"                                                               },
    { 0x00e3, "?_Reset@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ"                                                              },
    { 0x00e4, "?_RunAndWait@_StructuredTaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z" },
    { 0x00e5, "?_RunAndWait@_TaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z"       },
    { 0x00e6, "?_Schedule@_StructuredTaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"                           },
    { 0x00e7, "?_Schedule@_StructuredTaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@PAVlocation@3@@Z"             },
    { 0x00e8, "?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"                                     },
    { 0x00e9, "?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@PAVlocation@3@@Z"                       },
    { 0x00ea, "?_ScheduleTask@_CurrentScheduler@details@Concurrency@@SAXP6AXPAX@Z0@Z"                                             },
    { 0x00eb, "?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z"                                                       },
    { 0x00ec, "?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z"                                                      },
    { 0x00ed, "?_SetUnobservedExceptionHandler@details@Concurrency@@YAXP6AXXZ@Z"                                                  },
    { 0x00ee, "?_ShouldSpinAgain@?$_SpinWait@$00@details@Concurrency@@IAE_NXZ"                                                    },
    { 0x00ef, "?_ShouldSpinAgain@?$_SpinWait@$0A@@details@Concurrency@@IAE_NXZ"                                                   },
    { 0x00f0, "?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"                                                           },
    { 0x00f1, "?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QAE_NXZ"                                                          },
    { 0x00f2, "?_SpinYield@Context@Concurrency@@SAXXZ"                                                                            },
    { 0x00f3, "?_Start@_Timer@details@Concurrency@@IAEXXZ"                                                                        },
    { 0x00f4, "?_Stop@_Timer@details@Concurrency@@IAEXXZ"                                                                         },
    { 0x00f5, "?_Tidy@exception@std@@AAEXXZ"                                                                                      },
    { 0x00f6, "?_Trace_agents@Concurrency@@YAXW4Agents_EventType@1@_JZZ"                                                          },
    { 0x00f7, "?_Trace_ppl_function@Concurrency@@YAXABU_GUID@@EW4ConcRT_EventType@1@@Z"                                           },
    { 0x00f8, "?_TryAcquire@_NonReentrantBlockingLock@details@Concurrency@@QAE_NXZ"                                               },
    { 0x00f9, "?_TryAcquire@_ReentrantBlockingLock@details@Concurrency@@QAE_NXZ"                                                  },
    { 0x00fa, "?_TryAcquire@_ReentrantLock@details@Concurrency@@QAE_NXZ"                                                          },
    { 0x00fb, "?_TryAcquireWrite@_ReaderWriterLock@details@Concurrency@@QAE_NXZ"                                                  },
    { 0x00fc, "?_Type_info_dtor@type_info@@CAXPAV1@@Z"                                                                            },
    { 0x00fd, "?_Type_info_dtor_internal@type_info@@CAXPAV1@@Z"                                                                   },
    { 0x00fe, "?_UnderlyingYield@details@Concurrency@@YAXXZ"                                                                      },
    { 0x00ff, "?_ValidateExecute@@YAHP6GHXZ@Z"                                                                                    },
    { 0x0100, "?_ValidateRead@@YAHPBXI@Z"                                                                                         },
    { 0x0101, "?_ValidateWrite@@YAHPAXI@Z"                                                                                        },
    { 0x0102, "?_Value@_SpinCount@details@Concurrency@@SAIXZ"                                                                     },
    { 0x0103, "?_Yield@_Context@details@Concurrency@@SAXXZ"                                                                       },
    { 0x0104, "?__ExceptionPtrAssign@@YAXPAXPBX@Z"                                                                                },
    { 0x0105, "?__ExceptionPtrCompare@@YA_NPBX0@Z"                                                                                },
    { 0x0106, "?__ExceptionPtrCopy@@YAXPAXPBX@Z"                                                                                  },
    { 0x0107, "?__ExceptionPtrCopyException@@YAXPAXPBX1@Z"                                                                        },
    { 0x0108, "?__ExceptionPtrCreate@@YAXPAX@Z"                                                                                   },
    { 0x0109, "?__ExceptionPtrCurrentException@@YAXPAX@Z"                                                                         },
    { 0x010a, "?__ExceptionPtrDestroy@@YAXPAX@Z"                                                                                  },
    { 0x010b, "?__ExceptionPtrRethrow@@YAXPBX@Z"                                                                                  },
    { 0x010c, "?__ExceptionPtrSwap@@YAXPAX0@Z"                                                                                    },
    { 0x010d, "?__ExceptionPtrToBool@@YA_NPBX@Z"                                                                                  },
    { 0x010f, "?_inconsistency@@YAXXZ"                                                                                            },
    { 0x0110, "?_invalid_parameter@@YAXPBG00II@Z"                                                                                 },
    { 0x0111, "?_is_exception_typeof@@YAHABVtype_info@@PAU_EXCEPTION_POINTERS@@@Z"                                                },
    { 0x0112, "?_name_internal_method@type_info@@QBEPBDPAU__type_info_node@@@Z"                                                   },
    { 0x0113, "?_open@@YAHPBDHH@Z"                                                                                                },
    { 0x0114, "?_query_new_handler@@YAP6AHI@ZXZ"                                                                                  },
    { 0x0115, "?_query_new_mode@@YAHXZ"                                                                                           },
    { 0x0116, "?_set_new_handler@@YAP6AHI@ZH@Z"                                                                                   },
    { 0x0117, "?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z"                                                                             },
    { 0x0118, "?_set_new_mode@@YAHH@Z"                                                                                            },
    { 0x0119, "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZH@Z"                                                         },
    { 0x011a, "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z"                                                  },
    { 0x011b, "?_sopen@@YAHPBDHHH@Z"                                                                                              },
    { 0x011c, "?_type_info_dtor_internal_method@type_info@@QAEXXZ"                                                                },
    { 0x011d, "?_wopen@@YAHPB_WHH@Z"                                                                                              },
    { 0x011e, "?_wsopen@@YAHPB_WHHH@Z"                                                                                            },
    { 0x011f, "?before@type_info@@QBE_NABV1@@Z"                                                                                   },
    { 0x0120, "?current@location@Concurrency@@SA?AV12@XZ"                                                                         },
    { 0x0121, "?from_numa_node@location@Concurrency@@SA?AV12@G@Z"                                                                 },
    { 0x0122, "?get_error_code@scheduler_resource_allocation_error@Concurrency@@QBEJXZ"                                           },
    { 0x0123, "?lock@critical_section@Concurrency@@QAEXXZ"                                                                        },
    { 0x0124, "?lock@reader_writer_lock@Concurrency@@QAEXXZ"                                                                      },
    { 0x0125, "?lock_read@reader_writer_lock@Concurrency@@QAEXXZ"                                                                 },
    { 0x0126, "?name@type_info@@QBEPBDPAU__type_info_node@@@Z"                                                                    },
    { 0x0127, "?native_handle@critical_section@Concurrency@@QAEAAV12@XZ"                                                          },
    { 0x0128, "?notify_all@_Condition_variable@details@Concurrency@@QAEXXZ"                                                       },
    { 0x0129, "?notify_one@_Condition_variable@details@Concurrency@@QAEXXZ"                                                       },
    { 0x012a, "?raw_name@type_info@@QBEPBDXZ"                                                                                     },
    { 0x012b, "?reset@event@Concurrency@@QAEXXZ"                                                                                  },
    { 0x012c, "?set@event@Concurrency@@QAEXXZ"                                                                                    },
    { 0x012d, "?set_new_handler@@YAP6AXXZP6AXXZ@Z"                                                                                },
    { 0x012e, "?set_task_execution_resources@Concurrency@@YAXGPAU_GROUP_AFFINITY@@@Z"                                             },
    { 0x012f, "?set_task_execution_resources@Concurrency@@YAXK@Z"                                                                 },
    { 0x0130, "?set_terminate@@YAP6AXXZH@Z"                                                                                       },
    { 0x0131, "?set_terminate@@YAP6AXXZP6AXXZ@Z"                                                                                  },
    { 0x0132, "?set_unexpected@@YAP6AXXZH@Z"                                                                                      },
    { 0x0133, "?set_unexpected@@YAP6AXXZP6AXXZ@Z"                                                                                 },
    { 0x0134, "?swprintf@@YAHPAGIPBGZZ"                                                                                           },
    { 0x0135, "?swprintf@@YAHPA_WIPB_WZZ"                                                                                         },
    { 0x0136, "?terminate@@YAXXZ"                                                                                                 },
    { 0x0137, "?try_lock@critical_section@Concurrency@@QAE_NXZ"                                                                   },
    { 0x0138, "?try_lock@reader_writer_lock@Concurrency@@QAE_NXZ"                                                                 },
    { 0x0139, "?try_lock_for@critical_section@Concurrency@@QAE_NI@Z"                                                              },
    { 0x013a, "?try_lock_read@reader_writer_lock@Concurrency@@QAE_NXZ"                                                            },
    { 0x013b, "?unexpected@@YAXXZ"                                                                                                },
    { 0x013c, "?unlock@critical_section@Concurrency@@QAEXXZ"                                                                      },
    { 0x013d, "?unlock@reader_writer_lock@Concurrency@@QAEXXZ"                                                                    },
    { 0x013e, "?vswprintf@@YAHPA_WIPB_WPAD@Z"                                                                                     },
    { 0x013f, "?wait@Concurrency@@YAXI@Z"                                                                                         },
    { 0x0140, "?wait@_Condition_variable@details@Concurrency@@QAEXAAVcritical_section@3@@Z"                                       },
    { 0x0141, "?wait@event@Concurrency@@QAEII@Z"                                                                                  },
    { 0x0142, "?wait_for@_Condition_variable@details@Concurrency@@QAE_NAAVcritical_section@3@I@Z"                                 },
    { 0x0143, "?wait_for_multiple@event@Concurrency@@SAIPAPAV12@I_NI@Z"                                                           },
    { 0x0144, "?what@exception@std@@UBEPBDXZ"                                                                                     },
    { 0x0146, "_CIacos"                                                                                                           },
    { 0x0147, "_CIasin"                                                                                                           },
    { 0x0148, "_CIatan"                                                                                                           },
    { 0x0149, "_CIatan2"                                                                                                          },
    { 0x014a, "_CIcos"                                                                                                            },
    { 0x014b, "_CIcosh"                                                                                                           },
    { 0x014c, "_CIexp"                                                                                                            },
    { 0x014d, "_CIfmod"                                                                                                           },
    { 0x014e, "_CIlog"                                                                                                            },
    { 0x014f, "_CIlog10"                                                                                                          },
    { 0x0150, "_CIpow"                                                                                                            },
    { 0x0151, "_CIsin"                                                                                                            },
    { 0x0152, "_CIsinh"                                                                                                           },
    { 0x0153, "_CIsqrt"                                                                                                           },
    { 0x0154, "_CItan"                                                                                                            },
    { 0x0155, "_CItanh"                                                                                                           },
    { 0x0156, "_CRT_RTC_INIT"                                                                                                     },
    { 0x0157, "_CRT_RTC_INITW"                                                                                                    },
    { 0x0158, "_Cbuild"                                                                                                           },
    { 0x0159, "_CreateFrameInfo"                                                                                                  },
    { 0x015a, "_CxxThrowException"                                                                                                },
    { 0x015b, "_EH_prolog"                                                                                                        },
    { 0x015c, "_FCbuild"                                                                                                          },
    { 0x015d, "_FindAndUnlinkFrame"                                                                                               },
    { 0x015e, "_Getdays"                                                                                                          },
    { 0x015f, "_Getmonths"                                                                                                        },
    { 0x0160, "_Gettnames"                                                                                                        },
    { 0x0161, "_HUGE"                                                                                                             },
    { 0x0162, "_IsExceptionObjectToBeDestroyed"                                                                                   },
    { 0x0163, "_LCbuild"                                                                                                          },
    { 0x0164, "_NLG_Dispatch2"                                                                                                    },
    { 0x0165, "_NLG_Return"                                                                                                       },
    { 0x0166, "_NLG_Return2"                                                                                                      },
    { 0x0167, "_SetWinRTOutOfMemoryExceptionCallback"                                                                             },
    { 0x0168, "_Strftime"                                                                                                         },
    { 0x0169, "_W_Getdays"                                                                                                        },
    { 0x016a, "_W_Getmonths"                                                                                                      },
    { 0x016b, "_W_Gettnames"                                                                                                      },
    { 0x016c, "_Wcsftime"                                                                                                         },
    { 0x016d, "_XcptFilter"                                                                                                       },
    { 0x016e, "__AdjustPointer"                                                                                                   },
    { 0x016f, "__BuildCatchObject"                                                                                                },
    { 0x0170, "__BuildCatchObjectHelper"                                                                                          },
    { 0x0171, "__CppXcptFilter"                                                                                                   },
    { 0x0172, "__CxxDetectRethrow"                                                                                                },
    { 0x0173, "__CxxExceptionFilter"                                                                                              },
    { 0x0174, "__CxxFrameHandler"                                                                                                 },
    { 0x0175, "__CxxFrameHandler2"                                                                                                },
    { 0x0176, "__CxxFrameHandler3"                                                                                                },
    { 0x0177, "__CxxLongjmpUnwind"                                                                                                },
    { 0x0178, "__CxxQueryExceptionSize"                                                                                           },
    { 0x0179, "__CxxRegisterExceptionObject"                                                                                      },
    { 0x017a, "__CxxUnregisterExceptionObject"                                                                                    },
    { 0x017b, "__DestructExceptionObject"                                                                                         },
    { 0x017c, "__FrameUnwindFilter"                                                                                               },
    { 0x017d, "__GetPlatformExceptionInfo"                                                                                        },
    { 0x017e, "__RTCastToVoid"                                                                                                    },
    { 0x017f, "__RTDynamicCast"                                                                                                   },
    { 0x0180, "__RTtypeid"                                                                                                        },
    { 0x0181, "__STRINGTOLD"                                                                                                      },
    { 0x0182, "__STRINGTOLD_L"                                                                                                    },
    { 0x0183, "__TypeMatch"                                                                                                       },
    { 0x0184, "___lc_codepage_func"                                                                                               },
    { 0x0185, "___lc_collate_cp_func"                                                                                             },
    { 0x0186, "___lc_locale_name_func"                                                                                            },
    { 0x0187, "___mb_cur_max_func"                                                                                                },
    { 0x0188, "___mb_cur_max_l_func"                                                                                              },
    { 0x0189, "___setlc_active_func"                                                                                              },
    { 0x018a, "___unguarded_readlc_active_add_func"                                                                               },
    { 0x018b, "__argc"                                                                                                            },
    { 0x018c, "__argv"                                                                                                            },
    { 0x018d, "__badioinfo"                                                                                                       },
    { 0x018e, "__clean_type_info_names_internal"                                                                                  },
    { 0x018f, "__control87_2"                                                                                                     },
    { 0x0190, "__create_locale"                                                                                                   },
    { 0x0191, "__crtCompareStringA"                                                                                               },
    { 0x0192, "__crtCompareStringEx"                                                                                              },
    { 0x0193, "__crtCompareStringW"                                                                                               },
    { 0x0194, "__crtCreateEventExW"                                                                                               },
    { 0x0195, "__crtCreateSemaphoreExW"                                                                                           },
    { 0x0196, "__crtCreateSymbolicLinkW"                                                                                          },
    { 0x0197, "__crtEnumSystemLocalesEx"                                                                                          },
    { 0x0198, "__crtFlsAlloc"                                                                                                     },
    { 0x0199, "__crtFlsFree"                                                                                                      },
    { 0x019a, "__crtFlsGetValue"                                                                                                  },
    { 0x019b, "__crtFlsSetValue"                                                                                                  },
    { 0x019c, "__crtGetDateFormatEx"                                                                                              },
    { 0x019d, "__crtGetFileInformationByHandleEx"                                                                                 },
    { 0x019e, "__crtGetLocaleInfoEx"                                                                                              },
    { 0x019f, "__crtGetShowWindowMode"                                                                                            },
    { 0x01a0, "__crtGetTickCount64"                                                                                               },
    { 0x01a1, "__crtGetTimeFormatEx"                                                                                              },
    { 0x01a2, "__crtGetUserDefaultLocaleName"                                                                                     },
    { 0x01a3, "__crtInitializeCriticalSectionEx"                                                                                  },
    { 0x01a4, "__crtIsPackagedApp"                                                                                                },
    { 0x01a5, "__crtIsValidLocaleName"                                                                                            },
    { 0x01a6, "__crtLCMapStringA"                                                                                                 },
    { 0x01a7, "__crtLCMapStringEx"                                                                                                },
    { 0x01a8, "__crtLCMapStringW"                                                                                                 },
    { 0x01a9, "__crtSetFileInformationByHandle"                                                                                   },
    { 0x01aa, "__crtSetThreadStackGuarantee"                                                                                      },
    { 0x01ab, "__crtSetUnhandledExceptionFilter"                                                                                  },
    { 0x01ac, "__crtSleep"                                                                                                        },
    { 0x01ad, "__crtTerminateProcess"                                                                                             },
    { 0x01ae, "__crtUnhandledException"                                                                                           },
    { 0x01af, "__daylight"                                                                                                        },
    { 0x01b0, "__dllonexit"                                                                                                       },
    { 0x01b1, "__doserrno"                                                                                                        },
    { 0x01b2, "__dstbias"                                                                                                         },
    { 0x01b3, "__fpecode"                                                                                                         },
    { 0x01b4, "__free_locale"                                                                                                     },
    { 0x01b5, "__get_current_locale"                                                                                              },
    { 0x01b6, "__get_flsindex"                                                                                                    },
    { 0x01b7, "__get_tlsindex"                                                                                                    },
    { 0x01b8, "__getmainargs"                                                                                                     },
    { 0x01b9, "__initenv"                                                                                                         },
    { 0x01ba, "__iob_func"                                                                                                        },
    { 0x01bb, "__isascii"                                                                                                         },
    { 0x01bc, "__iscsym"                                                                                                          },
    { 0x01bd, "__iscsymf"                                                                                                         },
    { 0x01be, "__iswcsym"                                                                                                         },
    { 0x01bf, "__iswcsymf"                                                                                                        },
    { 0x01c0, "__lconv"                                                                                                           },
    { 0x01c1, "__lconv_init"                                                                                                      },
    { 0x01c2, "__libm_sse2_acos"                                                                                                  },
    { 0x01c3, "__libm_sse2_acosf"                                                                                                 },
    { 0x01c4, "__libm_sse2_asin"                                                                                                  },
    { 0x01c5, "__libm_sse2_asinf"                                                                                                 },
    { 0x01c6, "__libm_sse2_atan"                                                                                                  },
    { 0x01c7, "__libm_sse2_atan2"                                                                                                 },
    { 0x01c8, "__libm_sse2_atanf"                                                                                                 },
    { 0x01c9, "__libm_sse2_cos"                                                                                                   },
    { 0x01ca, "__libm_sse2_cosf"                                                                                                  },
    { 0x01cb, "__libm_sse2_exp"                                                                                                   },
    { 0x01cc, "__libm_sse2_expf"                                                                                                  },
    { 0x01cd, "__libm_sse2_log"                                                                                                   },
    { 0x01ce, "__libm_sse2_log10"                                                                                                 },
    { 0x01cf, "__libm_sse2_log10f"                                                                                                },
    { 0x01d0, "__libm_sse2_logf"                                                                                                  },
    { 0x01d1, "__libm_sse2_pow"                                                                                                   },
    { 0x01d2, "__libm_sse2_powf"                                                                                                  },
    { 0x01d3, "__libm_sse2_sin"                                                                                                   },
    { 0x01d4, "__libm_sse2_sinf"                                                                                                  },
    { 0x01d5, "__libm_sse2_tan"                                                                                                   },
    { 0x01d6, "__libm_sse2_tanf"                                                                                                  },
    { 0x01d7, "__mb_cur_max"                                                                                                      },
    { 0x01d8, "__p___argc"                                                                                                        },
    { 0x01d9, "__p___argv"                                                                                                        },
    { 0x01da, "__p___initenv"                                                                                                     },
    { 0x01db, "__p___mb_cur_max"                                                                                                  },
    { 0x01dc, "__p___wargv"                                                                                                       },
    { 0x01dd, "__p___winitenv"                                                                                                    },
    { 0x01de, "__p__acmdln"                                                                                                       },
    { 0x01df, "__p__commode"                                                                                                      },
    { 0x01e0, "__p__daylight"                                                                                                     },
    { 0x01e1, "__p__dstbias"                                                                                                      },
    { 0x01e2, "__p__environ"                                                                                                      },
    { 0x01e3, "__p__fmode"                                                                                                        },
    { 0x01e4, "__p__iob"                                                                                                          },
    { 0x01e5, "__p__mbcasemap"                                                                                                    },
    { 0x01e6, "__p__mbctype"                                                                                                      },
    { 0x01e7, "__p__pctype"                                                                                                       },
    { 0x01e8, "__p__pgmptr"                                                                                                       },
    { 0x01e9, "__p__pwctype"                                                                                                      },
    { 0x01ea, "__p__timezone"                                                                                                     },
    { 0x01eb, "__p__tzname"                                                                                                       },
    { 0x01ec, "__p__wcmdln"                                                                                                       },
    { 0x01ed, "__p__wenviron"                                                                                                     },
    { 0x01ee, "__p__wpgmptr"                                                                                                      },
    { 0x01ef, "__pctype_func"                                                                                                     },
    { 0x01f0, "__pioinfo"                                                                                                         },
    { 0x01f1, "__pwctype_func"                                                                                                    },
    { 0x01f2, "__pxcptinfoptrs"                                                                                                   },
    { 0x01f3, "__report_gsfailure"                                                                                                },
    { 0x01f4, "__set_app_type"                                                                                                    },
    { 0x01f5, "__setlc_active"                                                                                                    },
    { 0x01f6, "__setusermatherr"                                                                                                  },
    { 0x01f7, "__strncnt"                                                                                                         },
    { 0x01f8, "__swprintf_l"                                                                                                      },
    { 0x01f9, "__sys_errlist"                                                                                                     },
    { 0x01fa, "__sys_nerr"                                                                                                        },
    { 0x01fb, "__threadhandle"                                                                                                    },
    { 0x01fc, "__threadid"                                                                                                        },
    { 0x01fd, "__timezone"                                                                                                        },
    { 0x01fe, "__toascii"                                                                                                         },
    { 0x01ff, "__tzname"                                                                                                          },
    { 0x0200, "__unDName"                                                                                                         },
    { 0x0201, "__unDNameEx"                                                                                                       },
    { 0x0202, "__unDNameHelper"                                                                                                   },
    { 0x010e, "__uncaught_exception"                                                                                              },
    { 0x0203, "__unguarded_readlc_active"                                                                                         },
    { 0x0204, "__vswprintf_l"                                                                                                     },
    { 0x0205, "__wargv"                                                                                                           },
    { 0x0206, "__wcserror"                                                                                                        },
    { 0x0207, "__wcserror_s"                                                                                                      },
    { 0x0208, "__wcsncnt"                                                                                                         },
    { 0x0209, "__wgetmainargs"                                                                                                    },
    { 0x020a, "__winitenv"                                                                                                        },
    { 0x020b, "_abnormal_termination"                                                                                             },
    { 0x020c, "_abs64"                                                                                                            },
    { 0x020d, "_access"                                                                                                           },
    { 0x020e, "_access_s"                                                                                                         },
    { 0x020f, "_acmdln"                                                                                                           },
    { 0x0210, "_aligned_free"                                                                                                     },
    { 0x0211, "_aligned_malloc"                                                                                                   },
    { 0x0212, "_aligned_msize"                                                                                                    },
    { 0x0213, "_aligned_offset_malloc"                                                                                            },
    { 0x0214, "_aligned_offset_realloc"                                                                                           },
    { 0x0215, "_aligned_offset_recalloc"                                                                                          },
    { 0x0216, "_aligned_realloc"                                                                                                  },
    { 0x0217, "_aligned_recalloc"                                                                                                 },
    { 0x0218, "_amsg_exit"                                                                                                        },
    { 0x0219, "_assert"                                                                                                           },
    { 0x021a, "_atodbl"                                                                                                           },
    { 0x021b, "_atodbl_l"                                                                                                         },
    { 0x021c, "_atof_l"                                                                                                           },
    { 0x021d, "_atoflt"                                                                                                           },
    { 0x021e, "_atoflt_l"                                                                                                         },
    { 0x021f, "_atoi64"                                                                                                           },
    { 0x0220, "_atoi64_l"                                                                                                         },
    { 0x0221, "_atoi_l"                                                                                                           },
    { 0x0222, "_atol_l"                                                                                                           },
    { 0x0223, "_atoldbl"                                                                                                          },
    { 0x0224, "_atoldbl_l"                                                                                                        },
    { 0x0225, "_atoll_l"                                                                                                          },
    { 0x0226, "_beep"                                                                                                             },
    { 0x0227, "_beginthread"                                                                                                      },
    { 0x0228, "_beginthreadex"                                                                                                    },
    { 0x0229, "_byteswap_uint64"                                                                                                  },
    { 0x022a, "_byteswap_ulong"                                                                                                   },
    { 0x022b, "_byteswap_ushort"                                                                                                  },
    { 0x022c, "_c_exit"                                                                                                           },
    { 0x022d, "_cabs"                                                                                                             },
    { 0x022e, "_callnewh"                                                                                                         },
    { 0x022f, "_calloc_crt"                                                                                                       },
    { 0x0230, "_cexit"                                                                                                            },
    { 0x0231, "_cgets"                                                                                                            },
    { 0x0232, "_cgets_s"                                                                                                          },
    { 0x0233, "_cgetws"                                                                                                           },
    { 0x0234, "_cgetws_s"                                                                                                         },
    { 0x0235, "_chdir"                                                                                                            },
    { 0x0236, "_chdrive"                                                                                                          },
    { 0x0237, "_chgsign"                                                                                                          },
    { 0x0238, "_chgsignf"                                                                                                         },
    { 0x0239, "_chkesp"                                                                                                           },
    { 0x023a, "_chmod"                                                                                                            },
    { 0x023b, "_chsize"                                                                                                           },
    { 0x023c, "_chsize_s"                                                                                                         },
    { 0x023d, "_clearfp"                                                                                                          },
    { 0x023e, "_close"                                                                                                            },
    { 0x023f, "_commit"                                                                                                           },
    { 0x0240, "_commode"                                                                                                          },
    { 0x0241, "_configthreadlocale"                                                                                               },
    { 0x0242, "_control87"                                                                                                        },
    { 0x0243, "_controlfp"                                                                                                        },
    { 0x0244, "_controlfp_s"                                                                                                      },
    { 0x0245, "_copysign"                                                                                                         },
    { 0x0246, "_copysignf"                                                                                                        },
    { 0x0247, "_cprintf"                                                                                                          },
    { 0x0248, "_cprintf_l"                                                                                                        },
    { 0x0249, "_cprintf_p"                                                                                                        },
    { 0x024a, "_cprintf_p_l"                                                                                                      },
    { 0x024b, "_cprintf_s"                                                                                                        },
    { 0x024c, "_cprintf_s_l"                                                                                                      },
    { 0x024d, "_cputs"                                                                                                            },
    { 0x024e, "_cputws"                                                                                                           },
    { 0x024f, "_creat"                                                                                                            },
    { 0x0250, "_create_locale"                                                                                                    },
    { 0x0251, "_crt_debugger_hook"                                                                                                },
    { 0x0252, "_cscanf"                                                                                                           },
    { 0x0253, "_cscanf_l"                                                                                                         },
    { 0x0254, "_cscanf_s"                                                                                                         },
    { 0x0255, "_cscanf_s_l"                                                                                                       },
    { 0x0256, "_ctime32"                                                                                                          },
    { 0x0257, "_ctime32_s"                                                                                                        },
    { 0x0258, "_ctime64"                                                                                                          },
    { 0x0259, "_ctime64_s"                                                                                                        },
    { 0x025a, "_cwait"                                                                                                            },
    { 0x025b, "_cwprintf"                                                                                                         },
    { 0x025c, "_cwprintf_l"                                                                                                       },
    { 0x025d, "_cwprintf_p"                                                                                                       },
    { 0x025e, "_cwprintf_p_l"                                                                                                     },
    { 0x025f, "_cwprintf_s"                                                                                                       },
    { 0x0260, "_cwprintf_s_l"                                                                                                     },
    { 0x0261, "_cwscanf"                                                                                                          },
    { 0x0262, "_cwscanf_l"                                                                                                        },
    { 0x0263, "_cwscanf_s"                                                                                                        },
    { 0x0264, "_cwscanf_s_l"                                                                                                      },
    { 0x0265, "_daylight"                                                                                                         },
    { 0x0266, "_dclass"                                                                                                           },
    { 0x0267, "_difftime32"                                                                                                       },
    { 0x0268, "_difftime64"                                                                                                       },
    { 0x0269, "_dosmaperr"                                                                                                        },
    { 0x026a, "_dpcomp"                                                                                                           },
    { 0x026b, "_dsign"                                                                                                            },
    { 0x026c, "_dstbias"                                                                                                          },
    { 0x026d, "_dtest"                                                                                                            },
    { 0x026e, "_dup"                                                                                                              },
    { 0x026f, "_dup2"                                                                                                             },
    { 0x0270, "_dupenv_s"                                                                                                         },
    { 0x0271, "_ecvt"                                                                                                             },
    { 0x0272, "_ecvt_s"                                                                                                           },
    { 0x0273, "_endthread"                                                                                                        },
    { 0x0274, "_endthreadex"                                                                                                      },
    { 0x0275, "_environ"                                                                                                          },
    { 0x0276, "_eof"                                                                                                              },
    { 0x0277, "_errno"                                                                                                            },
    { 0x0278, "_except1"                                                                                                          },
    { 0x0279, "_except_handler2"                                                                                                  },
    { 0x027a, "_except_handler3"                                                                                                  },
    { 0x027b, "_except_handler4_common"                                                                                           },
    { 0x027c, "_execl"                                                                                                            },
    { 0x027d, "_execle"                                                                                                           },
    { 0x027e, "_execlp"                                                                                                           },
    { 0x027f, "_execlpe"                                                                                                          },
    { 0x0280, "_execv"                                                                                                            },
    { 0x0281, "_execve"                                                                                                           },
    { 0x0282, "_execvp"                                                                                                           },
    { 0x0283, "_execvpe"                                                                                                          },
    { 0x0284, "_exit"                                                                                                             },
    { 0x0285, "_expand"                                                                                                           },
    { 0x0286, "_fclose_nolock"                                                                                                    },
    { 0x0287, "_fcloseall"                                                                                                        },
    { 0x0288, "_fcvt"                                                                                                             },
    { 0x0289, "_fcvt_s"                                                                                                           },
    { 0x028a, "_fdclass"                                                                                                          },
    { 0x028b, "_fdopen"                                                                                                           },
    { 0x028c, "_fdpcomp"                                                                                                          },
    { 0x028d, "_fdsign"                                                                                                           },
    { 0x028e, "_fdtest"                                                                                                           },
    { 0x028f, "_fflush_nolock"                                                                                                    },
    { 0x0290, "_fgetchar"                                                                                                         },
    { 0x0291, "_fgetwc_nolock"                                                                                                    },
    { 0x0292, "_fgetwchar"                                                                                                        },
    { 0x0293, "_filbuf"                                                                                                           },
    { 0x0294, "_filelength"                                                                                                       },
    { 0x0295, "_filelengthi64"                                                                                                    },
    { 0x0296, "_fileno"                                                                                                           },
    { 0x0297, "_findclose"                                                                                                        },
    { 0x0298, "_findfirst32"                                                                                                      },
    { 0x0299, "_findfirst32i64"                                                                                                   },
    { 0x029a, "_findfirst64"                                                                                                      },
    { 0x029b, "_findfirst64i32"                                                                                                   },
    { 0x029c, "_findnext32"                                                                                                       },
    { 0x029d, "_findnext32i64"                                                                                                    },
    { 0x029e, "_findnext64"                                                                                                       },
    { 0x029f, "_findnext64i32"                                                                                                    },
    { 0x02a0, "_finite"                                                                                                           },
    { 0x02a1, "_flsbuf"                                                                                                           },
    { 0x02a2, "_flushall"                                                                                                         },
    { 0x02a3, "_fmode"                                                                                                            },
    { 0x02a4, "_fpclass"                                                                                                          },
    { 0x02a5, "_fpieee_flt"                                                                                                       },
    { 0x02a6, "_fpreset"                                                                                                          },
    { 0x02a7, "_fprintf_l"                                                                                                        },
    { 0x02a8, "_fprintf_p"                                                                                                        },
    { 0x02a9, "_fprintf_p_l"                                                                                                      },
    { 0x02aa, "_fprintf_s_l"                                                                                                      },
    { 0x02ab, "_fputchar"                                                                                                         },
    { 0x02ac, "_fputwc_nolock"                                                                                                    },
    { 0x02ad, "_fputwchar"                                                                                                        },
    { 0x02ae, "_fread_nolock"                                                                                                     },
    { 0x02af, "_fread_nolock_s"                                                                                                   },
    { 0x02b0, "_free_locale"                                                                                                      },
    { 0x02b1, "_freea"                                                                                                            },
    { 0x02b2, "_freea_s"                                                                                                          },
    { 0x02b3, "_freefls"                                                                                                          },
    { 0x02b4, "_fscanf_l"                                                                                                         },
    { 0x02b5, "_fscanf_s_l"                                                                                                       },
    { 0x02b6, "_fseek_nolock"                                                                                                     },
    { 0x02b7, "_fseeki64"                                                                                                         },
    { 0x02b8, "_fseeki64_nolock"                                                                                                  },
    { 0x02b9, "_fsopen"                                                                                                           },
    { 0x02ba, "_fstat32"                                                                                                          },
    { 0x02bb, "_fstat32i64"                                                                                                       },
    { 0x02bc, "_fstat64"                                                                                                          },
    { 0x02bd, "_fstat64i32"                                                                                                       },
    { 0x02be, "_ftell_nolock"                                                                                                     },
    { 0x02bf, "_ftelli64"                                                                                                         },
    { 0x02c0, "_ftelli64_nolock"                                                                                                  },
    { 0x02c1, "_ftime32"                                                                                                          },
    { 0x02c2, "_ftime32_s"                                                                                                        },
    { 0x02c3, "_ftime64"                                                                                                          },
    { 0x02c4, "_ftime64_s"                                                                                                        },
    { 0x02c5, "_ftol"                                                                                                             },
    { 0x02c6, "_fullpath"                                                                                                         },
    { 0x02c7, "_futime32"                                                                                                         },
    { 0x02c8, "_futime64"                                                                                                         },
    { 0x02c9, "_fwprintf_l"                                                                                                       },
    { 0x02ca, "_fwprintf_p"                                                                                                       },
    { 0x02cb, "_fwprintf_p_l"                                                                                                     },
    { 0x02cc, "_fwprintf_s_l"                                                                                                     },
    { 0x02cd, "_fwrite_nolock"                                                                                                    },
    { 0x02ce, "_fwscanf_l"                                                                                                        },
    { 0x02cf, "_fwscanf_s_l"                                                                                                      },
    { 0x02d0, "_gcvt"                                                                                                             },
    { 0x02d1, "_gcvt_s"                                                                                                           },
    { 0x02d2, "_get_current_locale"                                                                                               },
    { 0x02d3, "_get_daylight"                                                                                                     },
    { 0x02d4, "_get_doserrno"                                                                                                     },
    { 0x02d5, "_get_dstbias"                                                                                                      },
    { 0x02d6, "_get_errno"                                                                                                        },
    { 0x02d7, "_get_fmode"                                                                                                        },
    { 0x02d8, "_get_heap_handle"                                                                                                  },
    { 0x02d9, "_get_invalid_parameter_handler"                                                                                    },
    { 0x02da, "_get_osfhandle"                                                                                                    },
    { 0x02db, "_get_output_format"                                                                                                },
    { 0x02dc, "_get_pgmptr"                                                                                                       },
    { 0x02dd, "_get_printf_count_output"                                                                                          },
    { 0x02de, "_get_purecall_handler"                                                                                             },
    { 0x02df, "_get_terminate"                                                                                                    },
    { 0x02e0, "_get_timezone"                                                                                                     },
    { 0x02e1, "_get_tzname"                                                                                                       },
    { 0x02e2, "_get_unexpected"                                                                                                   },
    { 0x02e3, "_get_wpgmptr"                                                                                                      },
    { 0x02e4, "_getc_nolock"                                                                                                      },
    { 0x02e5, "_getch"                                                                                                            },
    { 0x02e6, "_getch_nolock"                                                                                                     },
    { 0x02e7, "_getche"                                                                                                           },
    { 0x02e8, "_getche_nolock"                                                                                                    },
    { 0x02e9, "_getcwd"                                                                                                           },
    { 0x02ea, "_getdcwd"                                                                                                          },
    { 0x02eb, "_getdiskfree"                                                                                                      },
    { 0x02ec, "_getdllprocaddr"                                                                                                   },
    { 0x02ed, "_getdrive"                                                                                                         },
    { 0x02ee, "_getdrives"                                                                                                        },
    { 0x02ef, "_getmaxstdio"                                                                                                      },
    { 0x02f0, "_getmbcp"                                                                                                          },
    { 0x02f1, "_getpid"                                                                                                           },
    { 0x02f2, "_getptd"                                                                                                           },
    { 0x02f3, "_getsystime"                                                                                                       },
    { 0x02f4, "_getw"                                                                                                             },
    { 0x02f5, "_getwch"                                                                                                           },
    { 0x02f6, "_getwch_nolock"                                                                                                    },
    { 0x02f7, "_getwche"                                                                                                          },
    { 0x02f8, "_getwche_nolock"                                                                                                   },
    { 0x02f9, "_getws"                                                                                                            },
    { 0x02fa, "_getws_s"                                                                                                          },
    { 0x02fb, "_global_unwind2"                                                                                                   },
    { 0x02fc, "_gmtime32"                                                                                                         },
    { 0x02fd, "_gmtime32_s"                                                                                                       },
    { 0x02fe, "_gmtime64"                                                                                                         },
    { 0x02ff, "_gmtime64_s"                                                                                                       },
    { 0x0300, "_heapadd"                                                                                                          },
    { 0x0301, "_heapchk"                                                                                                          },
    { 0x0302, "_heapmin"                                                                                                          },
    { 0x0303, "_heapset"                                                                                                          },
    { 0x0304, "_heapused"                                                                                                         },
    { 0x0305, "_heapwalk"                                                                                                         },
    { 0x0306, "_hypot"                                                                                                            },
    { 0x0307, "_hypotf"                                                                                                           },
    { 0x0308, "_i64toa"                                                                                                           },
    { 0x0309, "_i64toa_s"                                                                                                         },
    { 0x030a, "_i64tow"                                                                                                           },
    { 0x030b, "_i64tow_s"                                                                                                         },
    { 0x030c, "_initptd"                                                                                                          },
    { 0x030d, "_initterm"                                                                                                         },
    { 0x030e, "_initterm_e"                                                                                                       },
    { 0x030f, "_inp"                                                                                                              },
    { 0x0310, "_inpd"                                                                                                             },
    { 0x0311, "_inpw"                                                                                                             },
    { 0x0312, "_invalid_parameter"                                                                                                },
    { 0x0313, "_invalid_parameter_noinfo"                                                                                         },
    { 0x0314, "_invalid_parameter_noinfo_noreturn"                                                                                },
    { 0x0315, "_invoke_watson"                                                                                                    },
    { 0x0316, "_iob"                                                                                                              },
    { 0x0317, "_isalnum_l"                                                                                                        },
    { 0x0318, "_isalpha_l"                                                                                                        },
    { 0x0319, "_isatty"                                                                                                           },
    { 0x031a, "_isblank_l"                                                                                                        },
    { 0x031b, "_iscntrl_l"                                                                                                        },
    { 0x031c, "_isctype"                                                                                                          },
    { 0x031d, "_isctype_l"                                                                                                        },
    { 0x031e, "_isdigit_l"                                                                                                        },
    { 0x031f, "_isgraph_l"                                                                                                        },
    { 0x0320, "_isleadbyte_l"                                                                                                     },
    { 0x0321, "_islower_l"                                                                                                        },
    { 0x0322, "_ismbbalnum"                                                                                                       },
    { 0x0323, "_ismbbalnum_l"                                                                                                     },
    { 0x0324, "_ismbbalpha"                                                                                                       },
    { 0x0325, "_ismbbalpha_l"                                                                                                     },
    { 0x0326, "_ismbbblank"                                                                                                       },
    { 0x0327, "_ismbbblank_l"                                                                                                     },
    { 0x0328, "_ismbbgraph"                                                                                                       },
    { 0x0329, "_ismbbgraph_l"                                                                                                     },
    { 0x032a, "_ismbbkalnum"                                                                                                      },
    { 0x032b, "_ismbbkalnum_l"                                                                                                    },
    { 0x032c, "_ismbbkana"                                                                                                        },
    { 0x032d, "_ismbbkana_l"                                                                                                      },
    { 0x032e, "_ismbbkprint"                                                                                                      },
    { 0x032f, "_ismbbkprint_l"                                                                                                    },
    { 0x0330, "_ismbbkpunct"                                                                                                      },
    { 0x0331, "_ismbbkpunct_l"                                                                                                    },
    { 0x0332, "_ismbblead"                                                                                                        },
    { 0x0333, "_ismbblead_l"                                                                                                      },
    { 0x0334, "_ismbbprint"                                                                                                       },
    { 0x0335, "_ismbbprint_l"                                                                                                     },
    { 0x0336, "_ismbbpunct"                                                                                                       },
    { 0x0337, "_ismbbpunct_l"                                                                                                     },
    { 0x0338, "_ismbbtrail"                                                                                                       },
    { 0x0339, "_ismbbtrail_l"                                                                                                     },
    { 0x033a, "_ismbcalnum"                                                                                                       },
    { 0x033b, "_ismbcalnum_l"                                                                                                     },
    { 0x033c, "_ismbcalpha"                                                                                                       },
    { 0x033d, "_ismbcalpha_l"                                                                                                     },
    { 0x033e, "_ismbcblank"                                                                                                       },
    { 0x033f, "_ismbcblank_l"                                                                                                     },
    { 0x0340, "_ismbcdigit"                                                                                                       },
    { 0x0341, "_ismbcdigit_l"                                                                                                     },
    { 0x0342, "_ismbcgraph"                                                                                                       },
    { 0x0343, "_ismbcgraph_l"                                                                                                     },
    { 0x0344, "_ismbchira"                                                                                                        },
    { 0x0345, "_ismbchira_l"                                                                                                      },
    { 0x0346, "_ismbckata"                                                                                                        },
    { 0x0347, "_ismbckata_l"                                                                                                      },
    { 0x0348, "_ismbcl0"                                                                                                          },
    { 0x0349, "_ismbcl0_l"                                                                                                        },
    { 0x034a, "_ismbcl1"                                                                                                          },
    { 0x034b, "_ismbcl1_l"                                                                                                        },
    { 0x034c, "_ismbcl2"                                                                                                          },
    { 0x034d, "_ismbcl2_l"                                                                                                        },
    { 0x034e, "_ismbclegal"                                                                                                       },
    { 0x034f, "_ismbclegal_l"                                                                                                     },
    { 0x0350, "_ismbclower"                                                                                                       },
    { 0x0351, "_ismbclower_l"                                                                                                     },
    { 0x0352, "_ismbcprint"                                                                                                       },
    { 0x0353, "_ismbcprint_l"                                                                                                     },
    { 0x0354, "_ismbcpunct"                                                                                                       },
    { 0x0355, "_ismbcpunct_l"                                                                                                     },
    { 0x0356, "_ismbcspace"                                                                                                       },
    { 0x0357, "_ismbcspace_l"                                                                                                     },
    { 0x0358, "_ismbcsymbol"                                                                                                      },
    { 0x0359, "_ismbcsymbol_l"                                                                                                    },
    { 0x035a, "_ismbcupper"                                                                                                       },
    { 0x035b, "_ismbcupper_l"                                                                                                     },
    { 0x035c, "_ismbslead"                                                                                                        },
    { 0x035d, "_ismbslead_l"                                                                                                      },
    { 0x035e, "_ismbstrail"                                                                                                       },
    { 0x035f, "_ismbstrail_l"                                                                                                     },
    { 0x0360, "_isnan"                                                                                                            },
    { 0x0361, "_isprint_l"                                                                                                        },
    { 0x0362, "_ispunct_l"                                                                                                        },
    { 0x0363, "_isspace_l"                                                                                                        },
    { 0x0364, "_isupper_l"                                                                                                        },
    { 0x0365, "_iswalnum_l"                                                                                                       },
    { 0x0366, "_iswalpha_l"                                                                                                       },
    { 0x0367, "_iswblank_l"                                                                                                       },
    { 0x0368, "_iswcntrl_l"                                                                                                       },
    { 0x0369, "_iswcsym_l"                                                                                                        },
    { 0x036a, "_iswcsymf_l"                                                                                                       },
    { 0x036b, "_iswctype_l"                                                                                                       },
    { 0x036c, "_iswdigit_l"                                                                                                       },
    { 0x036d, "_iswgraph_l"                                                                                                       },
    { 0x036e, "_iswlower_l"                                                                                                       },
    { 0x036f, "_iswprint_l"                                                                                                       },
    { 0x0370, "_iswpunct_l"                                                                                                       },
    { 0x0371, "_iswspace_l"                                                                                                       },
    { 0x0372, "_iswupper_l"                                                                                                       },
    { 0x0373, "_iswxdigit_l"                                                                                                      },
    { 0x0374, "_isxdigit_l"                                                                                                       },
    { 0x0375, "_itoa"                                                                                                             },
    { 0x0376, "_itoa_s"                                                                                                           },
    { 0x0377, "_itow"                                                                                                             },
    { 0x0378, "_itow_s"                                                                                                           },
    { 0x0379, "_j0"                                                                                                               },
    { 0x037a, "_j1"                                                                                                               },
    { 0x037b, "_jn"                                                                                                               },
    { 0x037c, "_kbhit"                                                                                                            },
    { 0x037d, "_ldclass"                                                                                                          },
    { 0x037e, "_ldpcomp"                                                                                                          },
    { 0x037f, "_ldsign"                                                                                                           },
    { 0x0380, "_ldtest"                                                                                                           },
    { 0x0381, "_lfind"                                                                                                            },
    { 0x0382, "_lfind_s"                                                                                                          },
    { 0x0383, "_libm_sse2_acos_precise"                                                                                           },
    { 0x0384, "_libm_sse2_asin_precise"                                                                                           },
    { 0x0385, "_libm_sse2_atan_precise"                                                                                           },
    { 0x0386, "_libm_sse2_cos_precise"                                                                                            },
    { 0x0387, "_libm_sse2_exp_precise"                                                                                            },
    { 0x0388, "_libm_sse2_log10_precise"                                                                                          },
    { 0x0389, "_libm_sse2_log_precise"                                                                                            },
    { 0x038a, "_libm_sse2_pow_precise"                                                                                            },
    { 0x038b, "_libm_sse2_sin_precise"                                                                                            },
    { 0x038c, "_libm_sse2_sqrt_precise"                                                                                           },
    { 0x038d, "_libm_sse2_tan_precise"                                                                                            },
    { 0x038e, "_loaddll"                                                                                                          },
    { 0x038f, "_local_unwind2"                                                                                                    },
    { 0x0390, "_local_unwind4"                                                                                                    },
    { 0x0391, "_localtime32"                                                                                                      },
    { 0x0392, "_localtime32_s"                                                                                                    },
    { 0x0393, "_localtime64"                                                                                                      },
    { 0x0394, "_localtime64_s"                                                                                                    },
    { 0x0395, "_lock"                                                                                                             },
    { 0x0396, "_lock_file"                                                                                                        },
    { 0x0397, "_locking"                                                                                                          },
    { 0x0398, "_logb"                                                                                                             },
    { 0x0399, "_longjmpex"                                                                                                        },
    { 0x039a, "_lrotl"                                                                                                            },
    { 0x039b, "_lrotr"                                                                                                            },
    { 0x039c, "_lsearch"                                                                                                          },
    { 0x039d, "_lsearch_s"                                                                                                        },
    { 0x039e, "_lseek"                                                                                                            },
    { 0x039f, "_lseeki64"                                                                                                         },
    { 0x03a0, "_ltoa"                                                                                                             },
    { 0x03a1, "_ltoa_s"                                                                                                           },
    { 0x03a2, "_ltow"                                                                                                             },
    { 0x03a3, "_ltow_s"                                                                                                           },
    { 0x03a4, "_makepath"                                                                                                         },
    { 0x03a5, "_makepath_s"                                                                                                       },
    { 0x03a6, "_malloc_crt"                                                                                                       },
    { 0x03a7, "_mbbtombc"                                                                                                         },
    { 0x03a8, "_mbbtombc_l"                                                                                                       },
    { 0x03a9, "_mbbtype"                                                                                                          },
    { 0x03aa, "_mbbtype_l"                                                                                                        },
    { 0x03ab, "_mbcasemap"                                                                                                        },
    { 0x03ac, "_mbccpy"                                                                                                           },
    { 0x03ad, "_mbccpy_l"                                                                                                         },
    { 0x03ae, "_mbccpy_s"                                                                                                         },
    { 0x03af, "_mbccpy_s_l"                                                                                                       },
    { 0x03b0, "_mbcjistojms"                                                                                                      },
    { 0x03b1, "_mbcjistojms_l"                                                                                                    },
    { 0x03b2, "_mbcjmstojis"                                                                                                      },
    { 0x03b3, "_mbcjmstojis_l"                                                                                                    },
    { 0x03b4, "_mbclen"                                                                                                           },
    { 0x03b5, "_mbclen_l"                                                                                                         },
    { 0x03b6, "_mbctohira"                                                                                                        },
    { 0x03b7, "_mbctohira_l"                                                                                                      },
    { 0x03b8, "_mbctokata"                                                                                                        },
    { 0x03b9, "_mbctokata_l"                                                                                                      },
    { 0x03ba, "_mbctolower"                                                                                                       },
    { 0x03bb, "_mbctolower_l"                                                                                                     },
    { 0x03bc, "_mbctombb"                                                                                                         },
    { 0x03bd, "_mbctombb_l"                                                                                                       },
    { 0x03be, "_mbctoupper"                                                                                                       },
    { 0x03bf, "_mbctoupper_l"                                                                                                     },
    { 0x03c0, "_mbctype"                                                                                                          },
    { 0x03c1, "_mblen_l"                                                                                                          },
    { 0x03c2, "_mbsbtype"                                                                                                         },
    { 0x03c3, "_mbsbtype_l"                                                                                                       },
    { 0x03c4, "_mbscat_s"                                                                                                         },
    { 0x03c5, "_mbscat_s_l"                                                                                                       },
    { 0x03c6, "_mbschr"                                                                                                           },
    { 0x03c7, "_mbschr_l"                                                                                                         },
    { 0x03c8, "_mbscmp"                                                                                                           },
    { 0x03c9, "_mbscmp_l"                                                                                                         },
    { 0x03ca, "_mbscoll"                                                                                                          },
    { 0x03cb, "_mbscoll_l"                                                                                                        },
    { 0x03cc, "_mbscpy_s"                                                                                                         },
    { 0x03cd, "_mbscpy_s_l"                                                                                                       },
    { 0x03ce, "_mbscspn"                                                                                                          },
    { 0x03cf, "_mbscspn_l"                                                                                                        },
    { 0x03d0, "_mbsdec"                                                                                                           },
    { 0x03d1, "_mbsdec_l"                                                                                                         },
    { 0x03d2, "_mbsicmp"                                                                                                          },
    { 0x03d3, "_mbsicmp_l"                                                                                                        },
    { 0x03d4, "_mbsicoll"                                                                                                         },
    { 0x03d5, "_mbsicoll_l"                                                                                                       },
    { 0x03d6, "_mbsinc"                                                                                                           },
    { 0x03d7, "_mbsinc_l"                                                                                                         },
    { 0x03d8, "_mbslen"                                                                                                           },
    { 0x03d9, "_mbslen_l"                                                                                                         },
    { 0x03da, "_mbslwr"                                                                                                           },
    { 0x03db, "_mbslwr_l"                                                                                                         },
    { 0x03dc, "_mbslwr_s"                                                                                                         },
    { 0x03dd, "_mbslwr_s_l"                                                                                                       },
    { 0x03de, "_mbsnbcat"                                                                                                         },
    { 0x03df, "_mbsnbcat_l"                                                                                                       },
    { 0x03e0, "_mbsnbcat_s"                                                                                                       },
    { 0x03e1, "_mbsnbcat_s_l"                                                                                                     },
    { 0x03e2, "_mbsnbcmp"                                                                                                         },
    { 0x03e3, "_mbsnbcmp_l"                                                                                                       },
    { 0x03e4, "_mbsnbcnt"                                                                                                         },
    { 0x03e5, "_mbsnbcnt_l"                                                                                                       },
    { 0x03e6, "_mbsnbcoll"                                                                                                        },
    { 0x03e7, "_mbsnbcoll_l"                                                                                                      },
    { 0x03e8, "_mbsnbcpy"                                                                                                         },
    { 0x03e9, "_mbsnbcpy_l"                                                                                                       },
    { 0x03ea, "_mbsnbcpy_s"                                                                                                       },
    { 0x03eb, "_mbsnbcpy_s_l"                                                                                                     },
    { 0x03ec, "_mbsnbicmp"                                                                                                        },
    { 0x03ed, "_mbsnbicmp_l"                                                                                                      },
    { 0x03ee, "_mbsnbicoll"                                                                                                       },
    { 0x03ef, "_mbsnbicoll_l"                                                                                                     },
    { 0x03f0, "_mbsnbset"                                                                                                         },
    { 0x03f1, "_mbsnbset_l"                                                                                                       },
    { 0x03f2, "_mbsnbset_s"                                                                                                       },
    { 0x03f3, "_mbsnbset_s_l"                                                                                                     },
    { 0x03f4, "_mbsncat"                                                                                                          },
    { 0x03f5, "_mbsncat_l"                                                                                                        },
    { 0x03f6, "_mbsncat_s"                                                                                                        },
    { 0x03f7, "_mbsncat_s_l"                                                                                                      },
    { 0x03f8, "_mbsnccnt"                                                                                                         },
    { 0x03f9, "_mbsnccnt_l"                                                                                                       },
    { 0x03fa, "_mbsncmp"                                                                                                          },
    { 0x03fb, "_mbsncmp_l"                                                                                                        },
    { 0x03fc, "_mbsncoll"                                                                                                         },
    { 0x03fd, "_mbsncoll_l"                                                                                                       },
    { 0x03fe, "_mbsncpy"                                                                                                          },
    { 0x03ff, "_mbsncpy_l"                                                                                                        },
    { 0x0400, "_mbsncpy_s"                                                                                                        },
    { 0x0401, "_mbsncpy_s_l"                                                                                                      },
    { 0x0402, "_mbsnextc"                                                                                                         },
    { 0x0403, "_mbsnextc_l"                                                                                                       },
    { 0x0404, "_mbsnicmp"                                                                                                         },
    { 0x0405, "_mbsnicmp_l"                                                                                                       },
    { 0x0406, "_mbsnicoll"                                                                                                        },
    { 0x0407, "_mbsnicoll_l"                                                                                                      },
    { 0x0408, "_mbsninc"                                                                                                          },
    { 0x0409, "_mbsninc_l"                                                                                                        },
    { 0x040a, "_mbsnlen"                                                                                                          },
    { 0x040b, "_mbsnlen_l"                                                                                                        },
    { 0x040c, "_mbsnset"                                                                                                          },
    { 0x040d, "_mbsnset_l"                                                                                                        },
    { 0x040e, "_mbsnset_s"                                                                                                        },
    { 0x040f, "_mbsnset_s_l"                                                                                                      },
    { 0x0410, "_mbspbrk"                                                                                                          },
    { 0x0411, "_mbspbrk_l"                                                                                                        },
    { 0x0412, "_mbsrchr"                                                                                                          },
    { 0x0413, "_mbsrchr_l"                                                                                                        },
    { 0x0414, "_mbsrev"                                                                                                           },
    { 0x0415, "_mbsrev_l"                                                                                                         },
    { 0x0416, "_mbsset"                                                                                                           },
    { 0x0417, "_mbsset_l"                                                                                                         },
    { 0x0418, "_mbsset_s"                                                                                                         },
    { 0x0419, "_mbsset_s_l"                                                                                                       },
    { 0x041a, "_mbsspn"                                                                                                           },
    { 0x041b, "_mbsspn_l"                                                                                                         },
    { 0x041c, "_mbsspnp"                                                                                                          },
    { 0x041d, "_mbsspnp_l"                                                                                                        },
    { 0x041e, "_mbsstr"                                                                                                           },
    { 0x041f, "_mbsstr_l"                                                                                                         },
    { 0x0420, "_mbstok"                                                                                                           },
    { 0x0421, "_mbstok_l"                                                                                                         },
    { 0x0422, "_mbstok_s"                                                                                                         },
    { 0x0423, "_mbstok_s_l"                                                                                                       },
    { 0x0424, "_mbstowcs_l"                                                                                                       },
    { 0x0425, "_mbstowcs_s_l"                                                                                                     },
    { 0x0426, "_mbstrlen"                                                                                                         },
    { 0x0427, "_mbstrlen_l"                                                                                                       },
    { 0x0428, "_mbstrnlen"                                                                                                        },
    { 0x0429, "_mbstrnlen_l"                                                                                                      },
    { 0x042a, "_mbsupr"                                                                                                           },
    { 0x042b, "_mbsupr_l"                                                                                                         },
    { 0x042c, "_mbsupr_s"                                                                                                         },
    { 0x042d, "_mbsupr_s_l"                                                                                                       },
    { 0x042e, "_mbtowc_l"                                                                                                         },
    { 0x042f, "_memccpy"                                                                                                          },
    { 0x0430, "_memicmp"                                                                                                          },
    { 0x0431, "_memicmp_l"                                                                                                        },
    { 0x0432, "_mkdir"                                                                                                            },
    { 0x0433, "_mkgmtime32"                                                                                                       },
    { 0x0434, "_mkgmtime64"                                                                                                       },
    { 0x0435, "_mktemp"                                                                                                           },
    { 0x0436, "_mktemp_s"                                                                                                         },
    { 0x0437, "_mktime32"                                                                                                         },
    { 0x0438, "_mktime64"                                                                                                         },
    { 0x0439, "_msize"                                                                                                            },
    { 0x043a, "_nextafter"                                                                                                        },
    { 0x043b, "_onexit"                                                                                                           },
    { 0x043c, "_open"                                                                                                             },
    { 0x043d, "_open_osfhandle"                                                                                                   },
    { 0x043e, "_outp"                                                                                                             },
    { 0x043f, "_outpd"                                                                                                            },
    { 0x0440, "_outpw"                                                                                                            },
    { 0x0441, "_pclose"                                                                                                           },
    { 0x0442, "_pctype"                                                                                                           },
    { 0x0443, "_pgmptr"                                                                                                           },
    { 0x0444, "_pipe"                                                                                                             },
    { 0x0445, "_popen"                                                                                                            },
    { 0x0446, "_printf_l"                                                                                                         },
    { 0x0447, "_printf_p"                                                                                                         },
    { 0x0448, "_printf_p_l"                                                                                                       },
    { 0x0449, "_printf_s_l"                                                                                                       },
    { 0x044a, "_purecall"                                                                                                         },
    { 0x044b, "_putch"                                                                                                            },
    { 0x044c, "_putch_nolock"                                                                                                     },
    { 0x044d, "_putenv"                                                                                                           },
    { 0x044e, "_putenv_s"                                                                                                         },
    { 0x044f, "_putw"                                                                                                             },
    { 0x0450, "_putwch"                                                                                                           },
    { 0x0451, "_putwch_nolock"                                                                                                    },
    { 0x0452, "_putws"                                                                                                            },
    { 0x0453, "_pwctype"                                                                                                          },
    { 0x0454, "_read"                                                                                                             },
    { 0x0455, "_realloc_crt"                                                                                                      },
    { 0x0456, "_recalloc"                                                                                                         },
    { 0x0457, "_recalloc_crt"                                                                                                     },
    { 0x0458, "_resetstkoflw"                                                                                                     },
    { 0x0459, "_rmdir"                                                                                                            },
    { 0x045a, "_rmtmp"                                                                                                            },
    { 0x045b, "_rotl"                                                                                                             },
    { 0x045c, "_rotl64"                                                                                                           },
    { 0x045d, "_rotr"                                                                                                             },
    { 0x045e, "_rotr64"                                                                                                           },
    { 0x045f, "_scalb"                                                                                                            },
    { 0x0460, "_scanf_l"                                                                                                          },
    { 0x0461, "_scanf_s_l"                                                                                                        },
    { 0x0462, "_scprintf"                                                                                                         },
    { 0x0463, "_scprintf_l"                                                                                                       },
    { 0x0464, "_scprintf_p"                                                                                                       },
    { 0x0465, "_scprintf_p_l"                                                                                                     },
    { 0x0466, "_scwprintf"                                                                                                        },
    { 0x0467, "_scwprintf_l"                                                                                                      },
    { 0x0468, "_scwprintf_p"                                                                                                      },
    { 0x0469, "_scwprintf_p_l"                                                                                                    },
    { 0x046a, "_searchenv"                                                                                                        },
    { 0x046b, "_searchenv_s"                                                                                                      },
    { 0x046d, "_seh_longjmp_unwind"                                                                                               },
    { 0x046c, "_seh_longjmp_unwind4"                                                                                              },
    { 0x046e, "_set_SSE2_enable"                                                                                                  },
    { 0x046f, "_set_abort_behavior"                                                                                               },
    { 0x0470, "_set_controlfp"                                                                                                    },
    { 0x0471, "_set_doserrno"                                                                                                     },
    { 0x0472, "_set_errno"                                                                                                        },
    { 0x0473, "_set_error_mode"                                                                                                   },
    { 0x0474, "_set_fmode"                                                                                                        },
    { 0x0475, "_set_invalid_parameter_handler"                                                                                    },
    { 0x0476, "_set_malloc_crt_max_wait"                                                                                          },
    { 0x0477, "_set_output_format"                                                                                                },
    { 0x0478, "_set_printf_count_output"                                                                                          },
    { 0x0479, "_set_purecall_handler"                                                                                             },
    { 0x047a, "_seterrormode"                                                                                                     },
    { 0x047b, "_setjmp"                                                                                                           },
    { 0x047c, "_setjmp3"                                                                                                          },
    { 0x047d, "_setmaxstdio"                                                                                                      },
    { 0x047e, "_setmbcp"                                                                                                          },
    { 0x047f, "_setmode"                                                                                                          },
    { 0x0480, "_setsystime"                                                                                                       },
    { 0x0481, "_sleep"                                                                                                            },
    { 0x0482, "_snprintf"                                                                                                         },
    { 0x0483, "_snprintf_c"                                                                                                       },
    { 0x0484, "_snprintf_c_l"                                                                                                     },
    { 0x0485, "_snprintf_l"                                                                                                       },
    { 0x0486, "_snprintf_s"                                                                                                       },
    { 0x0487, "_snprintf_s_l"                                                                                                     },
    { 0x0488, "_snscanf"                                                                                                          },
    { 0x0489, "_snscanf_l"                                                                                                        },
    { 0x048a, "_snscanf_s"                                                                                                        },
    { 0x048b, "_snscanf_s_l"                                                                                                      },
    { 0x048c, "_snwprintf"                                                                                                        },
    { 0x048d, "_snwprintf_l"                                                                                                      },
    { 0x048e, "_snwprintf_s"                                                                                                      },
    { 0x048f, "_snwprintf_s_l"                                                                                                    },
    { 0x0490, "_snwscanf"                                                                                                         },
    { 0x0491, "_snwscanf_l"                                                                                                       },
    { 0x0492, "_snwscanf_s"                                                                                                       },
    { 0x0493, "_snwscanf_s_l"                                                                                                     },
    { 0x0494, "_sopen"                                                                                                            },
    { 0x0495, "_sopen_s"                                                                                                          },
    { 0x0496, "_spawnl"                                                                                                           },
    { 0x0497, "_spawnle"                                                                                                          },
    { 0x0498, "_spawnlp"                                                                                                          },
    { 0x0499, "_spawnlpe"                                                                                                         },
    { 0x049a, "_spawnv"                                                                                                           },
    { 0x049b, "_spawnve"                                                                                                          },
    { 0x049c, "_spawnvp"                                                                                                          },
    { 0x049d, "_spawnvpe"                                                                                                         },
    { 0x049e, "_splitpath"                                                                                                        },
    { 0x049f, "_splitpath_s"                                                                                                      },
    { 0x04a0, "_sprintf_l"                                                                                                        },
    { 0x04a1, "_sprintf_p"                                                                                                        },
    { 0x04a2, "_sprintf_p_l"                                                                                                      },
    { 0x04a3, "_sprintf_s_l"                                                                                                      },
    { 0x04a4, "_sscanf_l"                                                                                                         },
    { 0x04a5, "_sscanf_s_l"                                                                                                       },
    { 0x04a6, "_stat32"                                                                                                           },
    { 0x04a7, "_stat32i64"                                                                                                        },
    { 0x04a8, "_stat64"                                                                                                           },
    { 0x04a9, "_stat64i32"                                                                                                        },
    { 0x04aa, "_statusfp"                                                                                                         },
    { 0x04ab, "_statusfp2"                                                                                                        },
    { 0x04ac, "_strcoll_l"                                                                                                        },
    { 0x04ad, "_strdate"                                                                                                          },
    { 0x04ae, "_strdate_s"                                                                                                        },
    { 0x04af, "_strdup"                                                                                                           },
    { 0x04b0, "_strerror"                                                                                                         },
    { 0x04b1, "_strerror_s"                                                                                                       },
    { 0x04b2, "_strftime_l"                                                                                                       },
    { 0x04b3, "_stricmp"                                                                                                          },
    { 0x04b4, "_stricmp_l"                                                                                                        },
    { 0x04b5, "_stricoll"                                                                                                         },
    { 0x04b6, "_stricoll_l"                                                                                                       },
    { 0x04b7, "_strlwr"                                                                                                           },
    { 0x04b8, "_strlwr_l"                                                                                                         },
    { 0x04b9, "_strlwr_s"                                                                                                         },
    { 0x04ba, "_strlwr_s_l"                                                                                                       },
    { 0x04bb, "_strncoll"                                                                                                         },
    { 0x04bc, "_strncoll_l"                                                                                                       },
    { 0x04bd, "_strnicmp"                                                                                                         },
    { 0x04be, "_strnicmp_l"                                                                                                       },
    { 0x04bf, "_strnicoll"                                                                                                        },
    { 0x04c0, "_strnicoll_l"                                                                                                      },
    { 0x04c1, "_strnset"                                                                                                          },
    { 0x04c2, "_strnset_s"                                                                                                        },
    { 0x04c3, "_strrev"                                                                                                           },
    { 0x04c4, "_strset"                                                                                                           },
    { 0x04c5, "_strset_s"                                                                                                         },
    { 0x04c6, "_strtime"                                                                                                          },
    { 0x04c7, "_strtime_s"                                                                                                        },
    { 0x04c8, "_strtod_l"                                                                                                         },
    { 0x04c9, "_strtof_l"                                                                                                         },
    { 0x04ca, "_strtoi64"                                                                                                         },
    { 0x04cb, "_strtoi64_l"                                                                                                       },
    { 0x04cc, "_strtoimax_l"                                                                                                      },
    { 0x04cd, "_strtol_l"                                                                                                         },
    { 0x04ce, "_strtold_l"                                                                                                        },
    { 0x04cf, "_strtoll_l"                                                                                                        },
    { 0x04d0, "_strtoui64"                                                                                                        },
    { 0x04d1, "_strtoui64_l"                                                                                                      },
    { 0x04d2, "_strtoul_l"                                                                                                        },
    { 0x04d3, "_strtoull_l"                                                                                                       },
    { 0x04d4, "_strtoumax_l"                                                                                                      },
    { 0x04d5, "_strupr"                                                                                                           },
    { 0x04d6, "_strupr_l"                                                                                                         },
    { 0x04d7, "_strupr_s"                                                                                                         },
    { 0x04d8, "_strupr_s_l"                                                                                                       },
    { 0x04d9, "_strxfrm_l"                                                                                                        },
    { 0x04da, "_swab"                                                                                                             },
    { 0x04db, "_swprintf"                                                                                                         },
    { 0x04dc, "_swprintf_c"                                                                                                       },
    { 0x04dd, "_swprintf_c_l"                                                                                                     },
    { 0x04de, "_swprintf_p"                                                                                                       },
    { 0x04df, "_swprintf_p_l"                                                                                                     },
    { 0x04e0, "_swprintf_s_l"                                                                                                     },
    { 0x04e1, "_swscanf_l"                                                                                                        },
    { 0x04e2, "_swscanf_s_l"                                                                                                      },
    { 0x04e3, "_sys_errlist"                                                                                                      },
    { 0x04e4, "_sys_nerr"                                                                                                         },
    { 0x04e5, "_tell"                                                                                                             },
    { 0x04e6, "_telli64"                                                                                                          },
    { 0x04e7, "_tempnam"                                                                                                          },
    { 0x04e8, "_time32"                                                                                                           },
    { 0x04e9, "_time64"                                                                                                           },
    { 0x04ea, "_timezone"                                                                                                         },
    { 0x04eb, "_tolower"                                                                                                          },
    { 0x04ec, "_tolower_l"                                                                                                        },
    { 0x04ed, "_toupper"                                                                                                          },
    { 0x04ee, "_toupper_l"                                                                                                        },
    { 0x04ef, "_towlower_l"                                                                                                       },
    { 0x04f0, "_towupper_l"                                                                                                       },
    { 0x04f1, "_tzname"                                                                                                           },
    { 0x04f2, "_tzset"                                                                                                            },
    { 0x04f3, "_ui64toa"                                                                                                          },
    { 0x04f4, "_ui64toa_s"                                                                                                        },
    { 0x04f5, "_ui64tow"                                                                                                          },
    { 0x04f6, "_ui64tow_s"                                                                                                        },
    { 0x04f7, "_ultoa"                                                                                                            },
    { 0x04f8, "_ultoa_s"                                                                                                          },
    { 0x04f9, "_ultow"                                                                                                            },
    { 0x04fa, "_ultow_s"                                                                                                          },
    { 0x04fb, "_umask"                                                                                                            },
    { 0x04fc, "_umask_s"                                                                                                          },
    { 0x04fd, "_ungetc_nolock"                                                                                                    },
    { 0x04fe, "_ungetch"                                                                                                          },
    { 0x04ff, "_ungetch_nolock"                                                                                                   },
    { 0x0500, "_ungetwc_nolock"                                                                                                   },
    { 0x0501, "_ungetwch"                                                                                                         },
    { 0x0502, "_ungetwch_nolock"                                                                                                  },
    { 0x0503, "_unlink"                                                                                                           },
    { 0x0504, "_unloaddll"                                                                                                        },
    { 0x0505, "_unlock"                                                                                                           },
    { 0x0506, "_unlock_file"                                                                                                      },
    { 0x0507, "_utime32"                                                                                                          },
    { 0x0508, "_utime64"                                                                                                          },
    { 0x0509, "_vacopy"                                                                                                           },
    { 0x050a, "_vcprintf"                                                                                                         },
    { 0x050b, "_vcprintf_l"                                                                                                       },
    { 0x050c, "_vcprintf_p"                                                                                                       },
    { 0x050d, "_vcprintf_p_l"                                                                                                     },
    { 0x050e, "_vcprintf_s"                                                                                                       },
    { 0x050f, "_vcprintf_s_l"                                                                                                     },
    { 0x0510, "_vcwprintf"                                                                                                        },
    { 0x0511, "_vcwprintf_l"                                                                                                      },
    { 0x0512, "_vcwprintf_p"                                                                                                      },
    { 0x0513, "_vcwprintf_p_l"                                                                                                    },
    { 0x0514, "_vcwprintf_s"                                                                                                      },
    { 0x0515, "_vcwprintf_s_l"                                                                                                    },
    { 0x0516, "_vfprintf_l"                                                                                                       },
    { 0x0517, "_vfprintf_p"                                                                                                       },
    { 0x0518, "_vfprintf_p_l"                                                                                                     },
    { 0x0519, "_vfprintf_s_l"                                                                                                     },
    { 0x051a, "_vfwprintf_l"                                                                                                      },
    { 0x051b, "_vfwprintf_p"                                                                                                      },
    { 0x051c, "_vfwprintf_p_l"                                                                                                    },
    { 0x051d, "_vfwprintf_s_l"                                                                                                    },
    { 0x051e, "_vprintf_l"                                                                                                        },
    { 0x051f, "_vprintf_p"                                                                                                        },
    { 0x0520, "_vprintf_p_l"                                                                                                      },
    { 0x0521, "_vprintf_s_l"                                                                                                      },
    { 0x0522, "_vscprintf"                                                                                                        },
    { 0x0523, "_vscprintf_l"                                                                                                      },
    { 0x0524, "_vscprintf_p"                                                                                                      },
    { 0x0525, "_vscprintf_p_l"                                                                                                    },
    { 0x0526, "_vscwprintf"                                                                                                       },
    { 0x0527, "_vscwprintf_l"                                                                                                     },
    { 0x0528, "_vscwprintf_p"                                                                                                     },
    { 0x0529, "_vscwprintf_p_l"                                                                                                   },
    { 0x052a, "_vsnprintf"                                                                                                        },
    { 0x052b, "_vsnprintf_c"                                                                                                      },
    { 0x052c, "_vsnprintf_c_l"                                                                                                    },
    { 0x052d, "_vsnprintf_l"                                                                                                      },
    { 0x052e, "_vsnprintf_s"                                                                                                      },
    { 0x052f, "_vsnprintf_s_l"                                                                                                    },
    { 0x0530, "_vsnwprintf"                                                                                                       },
    { 0x0531, "_vsnwprintf_l"                                                                                                     },
    { 0x0532, "_vsnwprintf_s"                                                                                                     },
    { 0x0533, "_vsnwprintf_s_l"                                                                                                   },
    { 0x0534, "_vsprintf_l"                                                                                                       },
    { 0x0535, "_vsprintf_p"                                                                                                       },
    { 0x0536, "_vsprintf_p_l"                                                                                                     },
    { 0x0537, "_vsprintf_s_l"                                                                                                     },
    { 0x0538, "_vswprintf"                                                                                                        },
    { 0x0539, "_vswprintf_c"                                                                                                      },
    { 0x053a, "_vswprintf_c_l"                                                                                                    },
    { 0x053b, "_vswprintf_l"                                                                                                      },
    { 0x053c, "_vswprintf_p"                                                                                                      },
    { 0x053d, "_vswprintf_p_l"                                                                                                    },
    { 0x053e, "_vswprintf_s_l"                                                                                                    },
    { 0x053f, "_vwprintf_l"                                                                                                       },
    { 0x0540, "_vwprintf_p"                                                                                                       },
    { 0x0541, "_vwprintf_p_l"                                                                                                     },
    { 0x0542, "_vwprintf_s_l"                                                                                                     },
    { 0x0543, "_waccess"                                                                                                          },
    { 0x0544, "_waccess_s"                                                                                                        },
    { 0x0545, "_wasctime"                                                                                                         },
    { 0x0546, "_wasctime_s"                                                                                                       },
    { 0x0547, "_wassert"                                                                                                          },
    { 0x0548, "_wchdir"                                                                                                           },
    { 0x0549, "_wchmod"                                                                                                           },
    { 0x054a, "_wcmdln"                                                                                                           },
    { 0x054b, "_wcreat"                                                                                                           },
    { 0x054c, "_wcreate_locale"                                                                                                   },
    { 0x054d, "_wcscoll_l"                                                                                                        },
    { 0x054e, "_wcsdup"                                                                                                           },
    { 0x054f, "_wcserror"                                                                                                         },
    { 0x0550, "_wcserror_s"                                                                                                       },
    { 0x0551, "_wcsftime_l"                                                                                                       },
    { 0x0552, "_wcsicmp"                                                                                                          },
    { 0x0553, "_wcsicmp_l"                                                                                                        },
    { 0x0554, "_wcsicoll"                                                                                                         },
    { 0x0555, "_wcsicoll_l"                                                                                                       },
    { 0x0556, "_wcslwr"                                                                                                           },
    { 0x0557, "_wcslwr_l"                                                                                                         },
    { 0x0558, "_wcslwr_s"                                                                                                         },
    { 0x0559, "_wcslwr_s_l"                                                                                                       },
    { 0x055a, "_wcsncoll"                                                                                                         },
    { 0x055b, "_wcsncoll_l"                                                                                                       },
    { 0x055c, "_wcsnicmp"                                                                                                         },
    { 0x055d, "_wcsnicmp_l"                                                                                                       },
    { 0x055e, "_wcsnicoll"                                                                                                        },
    { 0x055f, "_wcsnicoll_l"                                                                                                      },
    { 0x0560, "_wcsnset"                                                                                                          },
    { 0x0561, "_wcsnset_s"                                                                                                        },
    { 0x0562, "_wcsrev"                                                                                                           },
    { 0x0563, "_wcsset"                                                                                                           },
    { 0x0564, "_wcsset_s"                                                                                                         },
    { 0x0565, "_wcstod_l"                                                                                                         },
    { 0x0566, "_wcstof_l"                                                                                                         },
    { 0x0567, "_wcstoi64"                                                                                                         },
    { 0x0568, "_wcstoi64_l"                                                                                                       },
    { 0x0569, "_wcstoimax_l"                                                                                                      },
    { 0x056a, "_wcstol_l"                                                                                                         },
    { 0x056b, "_wcstold_l"                                                                                                        },
    { 0x056c, "_wcstoll_l"                                                                                                        },
    { 0x056d, "_wcstombs_l"                                                                                                       },
    { 0x056e, "_wcstombs_s_l"                                                                                                     },
    { 0x056f, "_wcstoui64"                                                                                                        },
    { 0x0570, "_wcstoui64_l"                                                                                                      },
    { 0x0571, "_wcstoul_l"                                                                                                        },
    { 0x0572, "_wcstoull_l"                                                                                                       },
    { 0x0573, "_wcstoumax_l"                                                                                                      },
    { 0x0574, "_wcsupr"                                                                                                           },
    { 0x0575, "_wcsupr_l"                                                                                                         },
    { 0x0576, "_wcsupr_s"                                                                                                         },
    { 0x0577, "_wcsupr_s_l"                                                                                                       },
    { 0x0578, "_wcsxfrm_l"                                                                                                        },
    { 0x0579, "_wctime32"                                                                                                         },
    { 0x057a, "_wctime32_s"                                                                                                       },
    { 0x057b, "_wctime64"                                                                                                         },
    { 0x057c, "_wctime64_s"                                                                                                       },
    { 0x057d, "_wctomb_l"                                                                                                         },
    { 0x057e, "_wctomb_s_l"                                                                                                       },
    { 0x057f, "_wctype"                                                                                                           },
    { 0x0580, "_wdupenv_s"                                                                                                        },
    { 0x0581, "_wenviron"                                                                                                         },
    { 0x0582, "_wexecl"                                                                                                           },
    { 0x0583, "_wexecle"                                                                                                          },
    { 0x0584, "_wexeclp"                                                                                                          },
    { 0x0585, "_wexeclpe"                                                                                                         },
    { 0x0586, "_wexecv"                                                                                                           },
    { 0x0587, "_wexecve"                                                                                                          },
    { 0x0588, "_wexecvp"                                                                                                          },
    { 0x0589, "_wexecvpe"                                                                                                         },
    { 0x058a, "_wfdopen"                                                                                                          },
    { 0x058b, "_wfindfirst32"                                                                                                     },
    { 0x058c, "_wfindfirst32i64"                                                                                                  },
    { 0x058d, "_wfindfirst64"                                                                                                     },
    { 0x058e, "_wfindfirst64i32"                                                                                                  },
    { 0x058f, "_wfindnext32"                                                                                                      },
    { 0x0590, "_wfindnext32i64"                                                                                                   },
    { 0x0591, "_wfindnext64"                                                                                                      },
    { 0x0592, "_wfindnext64i32"                                                                                                   },
    { 0x0593, "_wfopen"                                                                                                           },
    { 0x0594, "_wfopen_s"                                                                                                         },
    { 0x0595, "_wfreopen"                                                                                                         },
    { 0x0596, "_wfreopen_s"                                                                                                       },
    { 0x0597, "_wfsopen"                                                                                                          },
    { 0x0598, "_wfullpath"                                                                                                        },
    { 0x0599, "_wgetcwd"                                                                                                          },
    { 0x059a, "_wgetdcwd"                                                                                                         },
    { 0x059b, "_wgetenv"                                                                                                          },
    { 0x059c, "_wgetenv_s"                                                                                                        },
    { 0x059d, "_wmakepath"                                                                                                        },
    { 0x059e, "_wmakepath_s"                                                                                                      },
    { 0x059f, "_wmkdir"                                                                                                           },
    { 0x05a0, "_wmktemp"                                                                                                          },
    { 0x05a1, "_wmktemp_s"                                                                                                        },
    { 0x05a2, "_wopen"                                                                                                            },
    { 0x05a3, "_wperror"                                                                                                          },
    { 0x05a4, "_wpgmptr"                                                                                                          },
    { 0x05a5, "_wpopen"                                                                                                           },
    { 0x05a6, "_wprintf_l"                                                                                                        },
    { 0x05a7, "_wprintf_p"                                                                                                        },
    { 0x05a8, "_wprintf_p_l"                                                                                                      },
    { 0x05a9, "_wprintf_s_l"                                                                                                      },
    { 0x05aa, "_wputenv"                                                                                                          },
    { 0x05ab, "_wputenv_s"                                                                                                        },
    { 0x05ac, "_wremove"                                                                                                          },
    { 0x05ad, "_wrename"                                                                                                          },
    { 0x05ae, "_write"                                                                                                            },
    { 0x05af, "_wrmdir"                                                                                                           },
    { 0x05b0, "_wscanf_l"                                                                                                         },
    { 0x05b1, "_wscanf_s_l"                                                                                                       },
    { 0x05b2, "_wsearchenv"                                                                                                       },
    { 0x05b3, "_wsearchenv_s"                                                                                                     },
    { 0x05b4, "_wsetlocale"                                                                                                       },
    { 0x05b5, "_wsopen"                                                                                                           },
    { 0x05b6, "_wsopen_s"                                                                                                         },
    { 0x05b7, "_wspawnl"                                                                                                          },
    { 0x05b8, "_wspawnle"                                                                                                         },
    { 0x05b9, "_wspawnlp"                                                                                                         },
    { 0x05ba, "_wspawnlpe"                                                                                                        },
    { 0x05bb, "_wspawnv"                                                                                                          },
    { 0x05bc, "_wspawnve"                                                                                                         },
    { 0x05bd, "_wspawnvp"                                                                                                         },
    { 0x05be, "_wspawnvpe"                                                                                                        },
    { 0x05bf, "_wsplitpath"                                                                                                       },
    { 0x05c0, "_wsplitpath_s"                                                                                                     },
    { 0x05c1, "_wstat32"                                                                                                          },
    { 0x05c2, "_wstat32i64"                                                                                                       },
    { 0x05c3, "_wstat64"                                                                                                          },
    { 0x05c4, "_wstat64i32"                                                                                                       },
    { 0x05c5, "_wstrdate"                                                                                                         },
    { 0x05c6, "_wstrdate_s"                                                                                                       },
    { 0x05c7, "_wstrtime"                                                                                                         },
    { 0x05c8, "_wstrtime_s"                                                                                                       },
    { 0x05c9, "_wsystem"                                                                                                          },
    { 0x05ca, "_wtempnam"                                                                                                         },
    { 0x05cb, "_wtmpnam"                                                                                                          },
    { 0x05cc, "_wtmpnam_s"                                                                                                        },
    { 0x05cd, "_wtof"                                                                                                             },
    { 0x05ce, "_wtof_l"                                                                                                           },
    { 0x05cf, "_wtoi"                                                                                                             },
    { 0x05d0, "_wtoi64"                                                                                                           },
    { 0x05d1, "_wtoi64_l"                                                                                                         },
    { 0x05d2, "_wtoi_l"                                                                                                           },
    { 0x05d3, "_wtol"                                                                                                             },
    { 0x05d4, "_wtol_l"                                                                                                           },
    { 0x05d5, "_wtoll"                                                                                                            },
    { 0x05d6, "_wtoll_l"                                                                                                          },
    { 0x05d7, "_wunlink"                                                                                                          },
    { 0x05d8, "_wutime32"                                                                                                         },
    { 0x05d9, "_wutime64"                                                                                                         },
    { 0x05da, "_y0"                                                                                                               },
    { 0x05db, "_y1"                                                                                                               },
    { 0x05dc, "_yn"                                                                                                               },
    { 0x05dd, "abort"                                                                                                             },
    { 0x05de, "abs"                                                                                                               },
    { 0x05df, "acos"                                                                                                              },
    { 0x05e0, "acosh"                                                                                                             },
    { 0x05e1, "acoshf"                                                                                                            },
    { 0x05e2, "acoshl"                                                                                                            },
    { 0x05e3, "asctime"                                                                                                           },
    { 0x05e4, "asctime_s"                                                                                                         },
    { 0x05e5, "asin"                                                                                                              },
    { 0x05e6, "asinh"                                                                                                             },
    { 0x05e7, "asinhf"                                                                                                            },
    { 0x05e8, "asinhl"                                                                                                            },
    { 0x05e9, "atan"                                                                                                              },
    { 0x05ea, "atan2"                                                                                                             },
    { 0x05eb, "atanh"                                                                                                             },
    { 0x05ec, "atanhf"                                                                                                            },
    { 0x05ed, "atanhl"                                                                                                            },
    { 0x05ee, "atexit"                                                                                                            },
    { 0x05ef, "atof"                                                                                                              },
    { 0x05f0, "atoi"                                                                                                              },
    { 0x05f1, "atol"                                                                                                              },
    { 0x05f2, "atoll"                                                                                                             },
    { 0x05f3, "bsearch"                                                                                                           },
    { 0x05f4, "bsearch_s"                                                                                                         },
    { 0x05f5, "btowc"                                                                                                             },
    { 0x05f6, "cabs"                                                                                                              },
    { 0x05f7, "cabsf"                                                                                                             },
    { 0x05f8, "cabsl"                                                                                                             },
    { 0x05f9, "cacos"                                                                                                             },
    { 0x05fa, "cacosf"                                                                                                            },
    { 0x05fb, "cacosh"                                                                                                            },
    { 0x05fc, "cacoshf"                                                                                                           },
    { 0x05fd, "cacoshl"                                                                                                           },
    { 0x05fe, "cacosl"                                                                                                            },
    { 0x05ff, "calloc"                                                                                                            },
    { 0x0600, "carg"                                                                                                              },
    { 0x0601, "cargf"                                                                                                             },
    { 0x0602, "cargl"                                                                                                             },
    { 0x0603, "casin"                                                                                                             },
    { 0x0604, "casinf"                                                                                                            },
    { 0x0605, "casinh"                                                                                                            },
    { 0x0606, "casinhf"                                                                                                           },
    { 0x0607, "casinhl"                                                                                                           },
    { 0x0608, "casinl"                                                                                                            },
    { 0x0609, "catan"                                                                                                             },
    { 0x060a, "catanf"                                                                                                            },
    { 0x060b, "catanh"                                                                                                            },
    { 0x060c, "catanhf"                                                                                                           },
    { 0x060d, "catanhl"                                                                                                           },
    { 0x060e, "catanl"                                                                                                            },
    { 0x060f, "cbrt"                                                                                                              },
    { 0x0610, "cbrtf"                                                                                                             },
    { 0x0611, "cbrtl"                                                                                                             },
    { 0x0612, "ccos"                                                                                                              },
    { 0x0613, "ccosf"                                                                                                             },
    { 0x0614, "ccosh"                                                                                                             },
    { 0x0615, "ccoshf"                                                                                                            },
    { 0x0616, "ccoshl"                                                                                                            },
    { 0x0617, "ccosl"                                                                                                             },
    { 0x0618, "ceil"                                                                                                              },
    { 0x0619, "cexp"                                                                                                              },
    { 0x061a, "cexpf"                                                                                                             },
    { 0x061b, "cexpl"                                                                                                             },
    { 0x061c, "cimag"                                                                                                             },
    { 0x061d, "cimagf"                                                                                                            },
    { 0x061e, "cimagl"                                                                                                            },
    { 0x061f, "clearerr"                                                                                                          },
    { 0x0620, "clearerr_s"                                                                                                        },
    { 0x0621, "clock"                                                                                                             },
    { 0x0622, "clog"                                                                                                              },
    { 0x0623, "clog10"                                                                                                            },
    { 0x0624, "clog10f"                                                                                                           },
    { 0x0625, "clog10l"                                                                                                           },
    { 0x0626, "clogf"                                                                                                             },
    { 0x0627, "clogl"                                                                                                             },
    { 0x0628, "conj"                                                                                                              },
    { 0x0629, "conjf"                                                                                                             },
    { 0x062a, "conjl"                                                                                                             },
    { 0x062b, "copysign"                                                                                                          },
    { 0x062c, "copysignf"                                                                                                         },
    { 0x062d, "copysignl"                                                                                                         },
    { 0x062e, "cos"                                                                                                               },
    { 0x062f, "cosh"                                                                                                              },
    { 0x0630, "cpow"                                                                                                              },
    { 0x0631, "cpowf"                                                                                                             },
    { 0x0632, "cpowl"                                                                                                             },
    { 0x0633, "cproj"                                                                                                             },
    { 0x0634, "cprojf"                                                                                                            },
    { 0x0635, "cprojl"                                                                                                            },
    { 0x0636, "creal"                                                                                                             },
    { 0x0637, "crealf"                                                                                                            },
    { 0x0638, "creall"                                                                                                            },
    { 0x0639, "csin"                                                                                                              },
    { 0x063a, "csinf"                                                                                                             },
    { 0x063b, "csinh"                                                                                                             },
    { 0x063c, "csinhf"                                                                                                            },
    { 0x063d, "csinhl"                                                                                                            },
    { 0x063e, "csinl"                                                                                                             },
    { 0x063f, "csqrt"                                                                                                             },
    { 0x0640, "csqrtf"                                                                                                            },
    { 0x0641, "csqrtl"                                                                                                            },
    { 0x0642, "ctan"                                                                                                              },
    { 0x0643, "ctanf"                                                                                                             },
    { 0x0644, "ctanh"                                                                                                             },
    { 0x0645, "ctanhf"                                                                                                            },
    { 0x0646, "ctanhl"                                                                                                            },
    { 0x0647, "ctanl"                                                                                                             },
    { 0x0648, "div"                                                                                                               },
    { 0x0649, "erf"                                                                                                               },
    { 0x064a, "erfc"                                                                                                              },
    { 0x064b, "erfcf"                                                                                                             },
    { 0x064c, "erfcl"                                                                                                             },
    { 0x064d, "erff"                                                                                                              },
    { 0x064e, "erfl"                                                                                                              },
    { 0x064f, "exit"                                                                                                              },
    { 0x0650, "exp"                                                                                                               },
    { 0x0651, "exp2"                                                                                                              },
    { 0x0652, "exp2f"                                                                                                             },
    { 0x0653, "exp2l"                                                                                                             },
    { 0x0654, "expm1"                                                                                                             },
    { 0x0655, "expm1f"                                                                                                            },
    { 0x0656, "expm1l"                                                                                                            },
    { 0x0657, "fabs"                                                                                                              },
    { 0x0658, "fclose"                                                                                                            },
    { 0x0659, "fdim"                                                                                                              },
    { 0x065a, "fdimf"                                                                                                             },
    { 0x065b, "fdiml"                                                                                                             },
    { 0x065c, "feclearexcept"                                                                                                     },
    { 0x065d, "fegetenv"                                                                                                          },
    { 0x065e, "fegetexceptflag"                                                                                                   },
    { 0x065f, "fegetround"                                                                                                        },
    { 0x0660, "feholdexcept"                                                                                                      },
    { 0x0661, "feof"                                                                                                              },
    { 0x0662, "feraiseexcept"                                                                                                     },
    { 0x0663, "ferror"                                                                                                            },
    { 0x0664, "fesetenv"                                                                                                          },
    { 0x0665, "fesetexceptflag"                                                                                                   },
    { 0x0666, "fesetround"                                                                                                        },
    { 0x0667, "fetestexcept"                                                                                                      },
    { 0x0668, "feupdateenv"                                                                                                       },
    { 0x0669, "fflush"                                                                                                            },
    { 0x066a, "fgetc"                                                                                                             },
    { 0x066b, "fgetpos"                                                                                                           },
    { 0x066c, "fgets"                                                                                                             },
    { 0x066d, "fgetwc"                                                                                                            },
    { 0x066e, "fgetws"                                                                                                            },
    { 0x066f, "floor"                                                                                                             },
    { 0x0670, "fma"                                                                                                               },
    { 0x0671, "fmaf"                                                                                                              },
    { 0x0672, "fmal"                                                                                                              },
    { 0x0673, "fmax"                                                                                                              },
    { 0x0674, "fmaxf"                                                                                                             },
    { 0x0675, "fmaxl"                                                                                                             },
    { 0x0676, "fmin"                                                                                                              },
    { 0x0677, "fminf"                                                                                                             },
    { 0x0678, "fminl"                                                                                                             },
    { 0x0679, "fmod"                                                                                                              },
    { 0x067a, "fopen"                                                                                                             },
    { 0x067b, "fopen_s"                                                                                                           },
    { 0x067c, "fprintf"                                                                                                           },
    { 0x067d, "fprintf_s"                                                                                                         },
    { 0x067e, "fputc"                                                                                                             },
    { 0x067f, "fputs"                                                                                                             },
    { 0x0680, "fputwc"                                                                                                            },
    { 0x0681, "fputws"                                                                                                            },
    { 0x0682, "fread"                                                                                                             },
    { 0x0683, "fread_s"                                                                                                           },
    { 0x0684, "free"                                                                                                              },
    { 0x0685, "freopen"                                                                                                           },
    { 0x0686, "freopen_s"                                                                                                         },
    { 0x0687, "frexp"                                                                                                             },
    { 0x0688, "fscanf"                                                                                                            },
    { 0x0689, "fscanf_s"                                                                                                          },
    { 0x068a, "fseek"                                                                                                             },
    { 0x068b, "fsetpos"                                                                                                           },
    { 0x068c, "ftell"                                                                                                             },
    { 0x068d, "fwprintf"                                                                                                          },
    { 0x068e, "fwprintf_s"                                                                                                        },
    { 0x068f, "fwrite"                                                                                                            },
    { 0x0690, "fwscanf"                                                                                                           },
    { 0x0691, "fwscanf_s"                                                                                                         },
    { 0x0692, "getc"                                                                                                              },
    { 0x0693, "getchar"                                                                                                           },
    { 0x0694, "getenv"                                                                                                            },
    { 0x0695, "getenv_s"                                                                                                          },
    { 0x0696, "gets"                                                                                                              },
    { 0x0697, "gets_s"                                                                                                            },
    { 0x0698, "getwc"                                                                                                             },
    { 0x0699, "getwchar"                                                                                                          },
    { 0x069a, "ilogb"                                                                                                             },
    { 0x069b, "ilogbf"                                                                                                            },
    { 0x069c, "ilogbl"                                                                                                            },
    { 0x069d, "imaxabs"                                                                                                           },
    { 0x069e, "imaxdiv"                                                                                                           },
    { 0x069f, "is_wctype"                                                                                                         },
    { 0x06a0, "isalnum"                                                                                                           },
    { 0x06a1, "isalpha"                                                                                                           },
    { 0x06a2, "isblank"                                                                                                           },
    { 0x06a3, "iscntrl"                                                                                                           },
    { 0x06a4, "isdigit"                                                                                                           },
    { 0x06a5, "isgraph"                                                                                                           },
    { 0x06a6, "isleadbyte"                                                                                                        },
    { 0x06a7, "islower"                                                                                                           },
    { 0x06a8, "isprint"                                                                                                           },
    { 0x06a9, "ispunct"                                                                                                           },
    { 0x06aa, "isspace"                                                                                                           },
    { 0x06ab, "isupper"                                                                                                           },
    { 0x06ac, "iswalnum"                                                                                                          },
    { 0x06ad, "iswalpha"                                                                                                          },
    { 0x06ae, "iswascii"                                                                                                          },
    { 0x06af, "iswblank"                                                                                                          },
    { 0x06b0, "iswcntrl"                                                                                                          },
    { 0x06b1, "iswctype"                                                                                                          },
    { 0x06b2, "iswdigit"                                                                                                          },
    { 0x06b3, "iswgraph"                                                                                                          },
    { 0x06b4, "iswlower"                                                                                                          },
    { 0x06b5, "iswprint"                                                                                                          },
    { 0x06b6, "iswpunct"                                                                                                          },
    { 0x06b7, "iswspace"                                                                                                          },
    { 0x06b8, "iswupper"                                                                                                          },
    { 0x06b9, "iswxdigit"                                                                                                         },
    { 0x06ba, "isxdigit"                                                                                                          },
    { 0x06bb, "labs"                                                                                                              },
    { 0x06bc, "ldexp"                                                                                                             },
    { 0x06bd, "ldiv"                                                                                                              },
    { 0x06be, "lgamma"                                                                                                            },
    { 0x06bf, "lgammaf"                                                                                                           },
    { 0x06c0, "lgammal"                                                                                                           },
    { 0x06c1, "llabs"                                                                                                             },
    { 0x06c2, "lldiv"                                                                                                             },
    { 0x06c3, "llrint"                                                                                                            },
    { 0x06c4, "llrintf"                                                                                                           },
    { 0x06c5, "llrintl"                                                                                                           },
    { 0x06c6, "llround"                                                                                                           },
    { 0x06c7, "llroundf"                                                                                                          },
    { 0x06c8, "llroundl"                                                                                                          },
    { 0x06c9, "localeconv"                                                                                                        },
    { 0x06ca, "log"                                                                                                               },
    { 0x06cb, "log10"                                                                                                             },
    { 0x06cc, "log1p"                                                                                                             },
    { 0x06cd, "log1pf"                                                                                                            },
    { 0x06ce, "log1pl"                                                                                                            },
    { 0x06cf, "log2"                                                                                                              },
    { 0x06d0, "log2f"                                                                                                             },
    { 0x06d1, "log2l"                                                                                                             },
    { 0x06d2, "logb"                                                                                                              },
    { 0x06d3, "logbf"                                                                                                             },
    { 0x06d4, "logbl"                                                                                                             },
    { 0x06d5, "longjmp"                                                                                                           },
    { 0x06d6, "lrint"                                                                                                             },
    { 0x06d7, "lrintf"                                                                                                            },
    { 0x06d8, "lrintl"                                                                                                            },
    { 0x06d9, "lround"                                                                                                            },
    { 0x06da, "lroundf"                                                                                                           },
    { 0x06db, "lroundl"                                                                                                           },
    { 0x06dc, "malloc"                                                                                                            },
    { 0x06dd, "mblen"                                                                                                             },
    { 0x06de, "mbrlen"                                                                                                            },
    { 0x06df, "mbrtowc"                                                                                                           },
    { 0x06e0, "mbsrtowcs"                                                                                                         },
    { 0x06e1, "mbsrtowcs_s"                                                                                                       },
    { 0x06e2, "mbstowcs"                                                                                                          },
    { 0x06e3, "mbstowcs_s"                                                                                                        },
    { 0x06e4, "mbtowc"                                                                                                            },
    { 0x06e5, "memchr"                                                                                                            },
    { 0x06e6, "memcmp"                                                                                                            },
    { 0x06e7, "memcpy"                                                                                                            },
    { 0x06e8, "memcpy_s"                                                                                                          },
    { 0x06e9, "memmove"                                                                                                           },
    { 0x06ea, "memmove_s"                                                                                                         },
    { 0x06eb, "memset"                                                                                                            },
    { 0x06ec, "modf"                                                                                                              },
    { 0x06ed, "nan"                                                                                                               },
    { 0x06ee, "nanf"                                                                                                              },
    { 0x06ef, "nanl"                                                                                                              },
    { 0x06f0, "nearbyint"                                                                                                         },
    { 0x06f1, "nearbyintf"                                                                                                        },
    { 0x06f2, "nearbyintl"                                                                                                        },
    { 0x06f3, "nextafter"                                                                                                         },
    { 0x06f4, "nextafterf"                                                                                                        },
    { 0x06f5, "nextafterl"                                                                                                        },
    { 0x06f6, "nexttoward"                                                                                                        },
    { 0x06f7, "nexttowardf"                                                                                                       },
    { 0x06f8, "nexttowardl"                                                                                                       },
    { 0x06f9, "norm"                                                                                                              },
    { 0x06fa, "normf"                                                                                                             },
    { 0x06fb, "norml"                                                                                                             },
    { 0x06fc, "perror"                                                                                                            },
    { 0x06fd, "pow"                                                                                                               },
    { 0x06fe, "printf"                                                                                                            },
    { 0x06ff, "printf_s"                                                                                                          },
    { 0x0700, "putc"                                                                                                              },
    { 0x0701, "putchar"                                                                                                           },
    { 0x0702, "puts"                                                                                                              },
    { 0x0703, "putwc"                                                                                                             },
    { 0x0704, "putwchar"                                                                                                          },
    { 0x0705, "qsort"                                                                                                             },
    { 0x0706, "qsort_s"                                                                                                           },
    { 0x0707, "raise"                                                                                                             },
    { 0x0708, "rand"                                                                                                              },
    { 0x0709, "rand_s"                                                                                                            },
    { 0x070a, "realloc"                                                                                                           },
    { 0x070b, "remainder"                                                                                                         },
    { 0x070c, "remainderf"                                                                                                        },
    { 0x070d, "remainderl"                                                                                                        },
    { 0x070e, "remove"                                                                                                            },
    { 0x070f, "remquo"                                                                                                            },
    { 0x0710, "remquof"                                                                                                           },
    { 0x0711, "remquol"                                                                                                           },
    { 0x0712, "rename"                                                                                                            },
    { 0x0713, "rewind"                                                                                                            },
    { 0x0714, "rint"                                                                                                              },
    { 0x0715, "rintf"                                                                                                             },
    { 0x0716, "rintl"                                                                                                             },
    { 0x0717, "round"                                                                                                             },
    { 0x0718, "roundf"                                                                                                            },
    { 0x0719, "roundl"                                                                                                            },
    { 0x071a, "scalbln"                                                                                                           },
    { 0x071b, "scalblnf"                                                                                                          },
    { 0x071c, "scalblnl"                                                                                                          },
    { 0x071d, "scalbn"                                                                                                            },
    { 0x071e, "scalbnf"                                                                                                           },
    { 0x071f, "scalbnl"                                                                                                           },
    { 0x0720, "scanf"                                                                                                             },
    { 0x0721, "scanf_s"                                                                                                           },
    { 0x0722, "setbuf"                                                                                                            },
    { 0x0723, "setlocale"                                                                                                         },
    { 0x0724, "setvbuf"                                                                                                           },
    { 0x0725, "signal"                                                                                                            },
    { 0x0726, "sin"                                                                                                               },
    { 0x0727, "sinh"                                                                                                              },
    { 0x0728, "sprintf"                                                                                                           },
    { 0x0729, "sprintf_s"                                                                                                         },
    { 0x072a, "sqrt"                                                                                                              },
    { 0x072b, "srand"                                                                                                             },
    { 0x072c, "sscanf"                                                                                                            },
    { 0x072d, "sscanf_s"                                                                                                          },
    { 0x072e, "strcat"                                                                                                            },
    { 0x072f, "strcat_s"                                                                                                          },
    { 0x0730, "strchr"                                                                                                            },
    { 0x0731, "strcmp"                                                                                                            },
    { 0x0732, "strcoll"                                                                                                           },
    { 0x0733, "strcpy"                                                                                                            },
    { 0x0734, "strcpy_s"                                                                                                          },
    { 0x0735, "strcspn"                                                                                                           },
    { 0x0736, "strerror"                                                                                                          },
    { 0x0737, "strerror_s"                                                                                                        },
    { 0x0738, "strftime"                                                                                                          },
    { 0x0739, "strlen"                                                                                                            },
    { 0x073a, "strncat"                                                                                                           },
    { 0x073b, "strncat_s"                                                                                                         },
    { 0x073c, "strncmp"                                                                                                           },
    { 0x073d, "strncpy"                                                                                                           },
    { 0x073e, "strncpy_s"                                                                                                         },
    { 0x073f, "strnlen"                                                                                                           },
    { 0x0740, "strpbrk"                                                                                                           },
    { 0x0741, "strrchr"                                                                                                           },
    { 0x0742, "strspn"                                                                                                            },
    { 0x0743, "strstr"                                                                                                            },
    { 0x0744, "strtod"                                                                                                            },
    { 0x0745, "strtof"                                                                                                            },
    { 0x0746, "strtoimax"                                                                                                         },
    { 0x0747, "strtok"                                                                                                            },
    { 0x0748, "strtok_s"                                                                                                          },
    { 0x0749, "strtol"                                                                                                            },
    { 0x074a, "strtold"                                                                                                           },
    { 0x074b, "strtoll"                                                                                                           },
    { 0x074c, "strtoul"                                                                                                           },
    { 0x074d, "strtoull"                                                                                                          },
    { 0x074e, "strtoumax"                                                                                                         },
    { 0x074f, "strxfrm"                                                                                                           },
    { 0x0750, "swprintf_s"                                                                                                        },
    { 0x0751, "swscanf"                                                                                                           },
    { 0x0752, "swscanf_s"                                                                                                         },
    { 0x0753, "system"                                                                                                            },
    { 0x0754, "tan"                                                                                                               },
    { 0x0755, "tanh"                                                                                                              },
    { 0x0756, "tgamma"                                                                                                            },
    { 0x0757, "tgammaf"                                                                                                           },
    { 0x0758, "tgammal"                                                                                                           },
    { 0x0759, "tmpfile"                                                                                                           },
    { 0x075a, "tmpfile_s"                                                                                                         },
    { 0x075b, "tmpnam"                                                                                                            },
    { 0x075c, "tmpnam_s"                                                                                                          },
    { 0x075d, "tolower"                                                                                                           },
    { 0x075e, "toupper"                                                                                                           },
    { 0x075f, "towctrans"                                                                                                         },
    { 0x0760, "towlower"                                                                                                          },
    { 0x0761, "towupper"                                                                                                          },
    { 0x0762, "trunc"                                                                                                             },
    { 0x0763, "truncf"                                                                                                            },
    { 0x0764, "truncl"                                                                                                            },
    { 0x0765, "ungetc"                                                                                                            },
    { 0x0766, "ungetwc"                                                                                                           },
    { 0x0767, "vfprintf"                                                                                                          },
    { 0x0768, "vfprintf_s"                                                                                                        },
    { 0x0769, "vfscanf"                                                                                                           },
    { 0x076a, "vfscanf_s"                                                                                                         },
    { 0x076b, "vfwprintf"                                                                                                         },
    { 0x076c, "vfwprintf_s"                                                                                                       },
    { 0x076d, "vfwscanf"                                                                                                          },
    { 0x076e, "vfwscanf_s"                                                                                                        },
    { 0x076f, "vprintf"                                                                                                           },
    { 0x0770, "vprintf_s"                                                                                                         },
    { 0x0771, "vscanf"                                                                                                            },
    { 0x0772, "vscanf_s"                                                                                                          },
    { 0x0773, "vsprintf"                                                                                                          },
    { 0x0774, "vsprintf_s"                                                                                                        },
    { 0x0775, "vsscanf"                                                                                                           },
    { 0x0776, "vsscanf_s"                                                                                                         },
    { 0x0777, "vswprintf_s"                                                                                                       },
    { 0x0778, "vswscanf"                                                                                                          },
    { 0x0779, "vswscanf_s"                                                                                                        },
    { 0x077a, "vwprintf"                                                                                                          },
    { 0x077b, "vwprintf_s"                                                                                                        },
    { 0x077c, "vwscanf"                                                                                                           },
    { 0x077d, "vwscanf_s"                                                                                                         },
    { 0x077e, "wcrtomb"                                                                                                           },
    { 0x077f, "wcrtomb_s"                                                                                                         },
    { 0x0780, "wcscat"                                                                                                            },
    { 0x0781, "wcscat_s"                                                                                                          },
    { 0x0782, "wcschr"                                                                                                            },
    { 0x0783, "wcscmp"                                                                                                            },
    { 0x0784, "wcscoll"                                                                                                           },
    { 0x0785, "wcscpy"                                                                                                            },
    { 0x0786, "wcscpy_s"                                                                                                          },
    { 0x0787, "wcscspn"                                                                                                           },
    { 0x0788, "wcsftime"                                                                                                          },
    { 0x0789, "wcslen"                                                                                                            },
    { 0x078a, "wcsncat"                                                                                                           },
    { 0x078b, "wcsncat_s"                                                                                                         },
    { 0x078c, "wcsncmp"                                                                                                           },
    { 0x078d, "wcsncpy"                                                                                                           },
    { 0x078e, "wcsncpy_s"                                                                                                         },
    { 0x078f, "wcsnlen"                                                                                                           },
    { 0x0790, "wcspbrk"                                                                                                           },
    { 0x0791, "wcsrchr"                                                                                                           },
    { 0x0792, "wcsrtombs"                                                                                                         },
    { 0x0793, "wcsrtombs_s"                                                                                                       },
    { 0x0794, "wcsspn"                                                                                                            },
    { 0x0795, "wcsstr"                                                                                                            },
    { 0x0796, "wcstod"                                                                                                            },
    { 0x0797, "wcstof"                                                                                                            },
    { 0x0798, "wcstoimax"                                                                                                         },
    { 0x0799, "wcstok"                                                                                                            },
    { 0x079a, "wcstok_s"                                                                                                          },
    { 0x079b, "wcstol"                                                                                                            },
    { 0x079c, "wcstold"                                                                                                           },
    { 0x079d, "wcstoll"                                                                                                           },
    { 0x079e, "wcstombs"                                                                                                          },
    { 0x079f, "wcstombs_s"                                                                                                        },
    { 0x07a0, "wcstoul"                                                                                                           },
    { 0x07a1, "wcstoull"                                                                                                          },
    { 0x07a2, "wcstoumax"                                                                                                         },
    { 0x07a3, "wcsxfrm"                                                                                                           },
    { 0x07a4, "wctob"                                                                                                             },
    { 0x07a5, "wctomb"                                                                                                            },
    { 0x07a6, "wctomb_s"                                                                                                          },
    { 0x07a7, "wctrans"                                                                                                           },
    { 0x07a8, "wctype"                                                                                                            },
    { 0x07a9, "wmemcpy_s"                                                                                                         },
    { 0x07aa, "wmemmove_s"                                                                                                        },
    { 0x07ab, "wprintf"                                                                                                           },
    { 0x07ac, "wprintf_s"                                                                                                         },
    { 0x07ad, "wscanf"                                                                                                            },
    { 0x07ae, "wscanf_s"                                                                                                          },
};


}
}

#endif

