/* SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only */
/* Copyright (c) 2025 Brett A C Sheffield <bacs@librecast.net> */

/* process cmdline options and args, verify that state is set correctly */

#include "test.h"
#include "testnet.h"
#include <state.h>

/* -i => interface */
static int test_state_interface_short(char *ifname, unsigned int ifx)
{
	char *argv[] = { "lcagent", "-i", NULL, NULL };
	int argc = sizeof argv / sizeof argv[0] - 1;
	state_t state = {0};
	int rc;

	/* try -i with missing IFNAME */
	errno = 0;
	rc = state_parse_args(&state, argc - 1, argv);
	test_assert(errno == EINVAL, "state_parse_args() errno set");
	test_assert(rc == -1, "interface (-i)");

	/* again with IFNAME set correctly */
	argv[2] = ifname;
	rc = state_parse_args(&state, argc, argv);
	test_assert(rc == 0, "interface (-i)");
	test_assert(state.ifx == ifx, "state: interface index set");

	return test_status;
}

int main(void)
{
	char name[] = "state_parse_arg() - options requiring network";
	char ifname[IFNAMSIZ];
	unsigned int ifx;

	test_name(name);

	ifx = get_multicast_if();
	if (!ifx) return (test_status = TEST_WARN);
	if (!test_assert(if_indextoname(ifx, ifname) != NULL, "if_indextoname()"))
		return test_status;

	if (test_state_interface_short(ifname, ifx)) return test_status;

	return test_status;
}
