// $Id: gc_migration.h,v 1.5 2018/01/03 21:32:55 mkkuhner Exp $

/*
Copyright 2002-2005 Mary K. Kuhner, Peter Beerli, and Joseph Felsenstein

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

*/

/* Authors: Mary Kuhner, Jon Yamato, and Joseph Felsenstein */


#ifndef GC_MIGRATION_H
#define GC_MIGRATION_H

#include "wx/string.h"
#include "gc_creation_info.h"
#include "gc_phase.h"
#include "gc_quantum.h"
#include "gc_types.h"

class GCStructures;

class gcMigration : public GCQuantum
{
    friend class GCStructures;

  private:
    bool                        m_blessed;  // true if user has edited m_nPanels

    bool                        m_hasFrom;
    size_t                      m_fromId;

    bool                        m_hasTo;
    size_t                      m_toId;

    double                      m_startValue;
    migration_method            m_method;
    migration_profile           m_profile;
    migration_constraint        m_constraint;

    gcCreationInfo              m_creationInfo;  //JRM this doing anything?

    void   SetCreationInfo(const gcCreationInfo &);

  public:

    gcMigration();
    ~gcMigration();

    void        SetBlessed(bool blessed);
    bool        GetBlessed()            const;

    bool        HasFrom()             const;
    void        SetFromId(size_t id);
    size_t      GetFromId()           const;
    wxString    GetFromIdString()     const;

    bool        HasTo()                const;
    void        SetToId(size_t id);
    size_t      GetToId()              const;
    wxString    GetToIdString()        const;

    void        SetStartValue(double val);
    double      GetStartValue()          const;
    wxString    GetStartValueString()    const;

    void                 SetMethod(migration_method val);
    migration_method     GetMethod()          const;
    wxString             GetMethodString()    const;

    void                 SetProfile(migration_profile val);
    migration_profile    GetProfile()          const;
    wxString             GetProfileAsString()    const;

    void                 SetConstraint(migration_constraint val);
    migration_constraint GetConstraint()          const;
    wxString             GetConstraintString()    const;


    void        DebugDump(wxString prefix=wxEmptyString) const;

};

#endif  // GC_MIGRATION_H

//____________________________________________________________________________________
