#!/usr/bin/perl -w

use strict;

# usage:
# samtools sort *.bam | bedtools genomecov -ibam stdin | ./bedToTemplate.pl

my $header = '';
my $cov = 0.0;
my $depth = 0.0;
my @info = ();

if(defined(my $line = <STDIN>)) {
	chomp $line;
	@info = split(" ", $line);
	$header = $info[0];
	$cov = 1 - $info[4];
}
while(defined(my $line = <STDIN>)) {
	chomp $line;
	@info = split(" ", $line);
	if($info[0] eq $header) {
		$depth += $info[1] * $info[4];
	} else {
		print sprintf("%s\t%f\t%f\n", $header, $cov, $depth) if($cov > 0);
		$header = $info[0];
		$cov = 1.0 - $info[4];
		$depth = 0.0;
	}
}
print sprintf("%s\t%f\t%f\n", $header, $cov, $depth) if($cov > 0 && $header ne "genome");
