/**
 * Copyright (C) 2009 Michael Pyne <mpyne@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DBUS_COLLECTION_PROXY_H
#define DBUS_COLLECTION_PROXY_H

#include <QObject>
#include <QStringList> // Required for Q_CLASSINFO ?

class PlaylistCollection;

class DBusCollectionProxy : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.kde.juk.collection")

public:
    DBusCollectionProxy (QObject *parent, PlaylistCollection *collection);
    ~DBusCollectionProxy();

public slots: // Expose to D-Bus
    void openFile(const QString &file);
    void openFile(const QStringList &files);
    void openFile(const QString &playlist, const QString &file);
    void openFile(const QString &playlist, const QStringList &files);

    QString visiblePlaylist();
    QString playingPlaylist();
    QStringList playlists();
    QStringList playlistTracks(const QString &playlist);
    QString trackProperty(const QString &file, const QString &property);

    void createPlaylist(const QString &name);
    void setPlaylist(const QString &name);
    void remove();
    void removeTrack(const QString &playlist, const QStringList &files);

    /**
     * Returns the path to the cover art for the given file.  Returns the empty
     * string if the track has no cover art.  Some tracks have embedded cover
     * art -- in this case JuK returns the path to a temporary file with the
     * extracted cover art.
     */
    QString trackCover(const QString &track);

private:
    PlaylistCollection *m_collection;
    QString m_lastCover;
};

#endif /* DBUS_COLLECTION_PROXY_H */

// vim: set et sw=4 tw=0 sta:
