/*=========================================================================

  Program:   ITK-SNAP
  Module:    $RCSfile: Filename.cxx,v $
  Language:  C++
  Date:      $Date: 2010/10/18 11:25:44 $
  Version:   $Revision: 1.12 $
  Copyright (c) 2011 Paul A. Yushkevich

  This file is part of ITK-SNAP

  ITK-SNAP is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.

=========================================================================*/

#ifndef QTRADIOBUTTONCOUPLING_H
#define QTRADIOBUTTONCOUPLING_H

#include <QtCheckableWidgetGroupCoupling.h>
#include <QRadioButton>
#include <map>

/**
  Create a coupling between a widget containing a set of radio buttons
  and a set of values of type TAtomic (true/false, enum, integer, etc).
  The mapping of values to button widgets is provided in the third parameter.
  */
template <class TAtomic>
void makeRadioGroupCoupling(
    QWidget *parentWidget,
    std::map<TAtomic, QAbstractButton *> buttonMap,
    AbstractPropertyModel<TAtomic> *model)
{
  makeCheckableWidgetGroupCoupling(parentWidget, buttonMap, model);
}


/**
  Create a coupling between a widget containing a set of radio buttons
  and an enum. The values of the enum must be 0,1,2,... The order of the
  radio button widgets in the parent widget *w should match the order of
  the enum entries. This method only fits specific situations, in other
  cases see the more general version above
  */
template <class TAtomic>
void makeRadioGroupCoupling(
    QWidget *w, AbstractPropertyModel<TAtomic> *model)
{
  const QObjectList &kids = w->children();
  std::map<TAtomic, QAbstractButton *> buttonMap;
  int iwidget = 0;
  for(QObjectList::const_iterator it = kids.begin(); it != kids.end(); ++it)
    {
    QAbstractButton *qab = dynamic_cast<QAbstractButton *>(*it);
    if(qab)
      buttonMap[static_cast<TAtomic>(iwidget++)] = qab;
    }
  makeCheckableWidgetGroupCoupling(w, buttonMap, model);
}

/**
  Really simple mode - you have two radio buttons and a boolean model
 */
inline void makeRadioGroupCoupling(
    QAbstractButton *w_True, QAbstractButton *w_False, AbstractPropertyModel<bool> *model)
{
  std::map<bool, QAbstractButton *> buttonMap;
  buttonMap[true] = w_True;
  buttonMap[false] = w_False;
  makeCheckableWidgetGroupCoupling(w_True->parentWidget(), buttonMap, model);
}

#endif // QTRADIOBUTTONCOUPLING_H
