#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from django.urls import reverse
from django.utils.translation import ugettext_lazy as _

from horizon import tabs


class OverviewTab(tabs.Tab):
    name = _("Overview")
    slug = "overview"
    template_name = "project/vg_snapshots/_detail_overview.html"

    def get_context_data(self, request):
        vg_snapshot = self.tab_group.kwargs['vg_snapshot']
        return {"vg_snapshot": vg_snapshot}

    def get_redirect_url(self):
        return reverse('horizon:project:vg_snapshots:index')


class DetailTabs(tabs.TabGroup):
    slug = "vg_snapshots_details"
    tabs = (OverviewTab,)
