/*
 *    (c) Copyright 2015 Hewlett-Packard Development Company, L.P.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function () {
  'use strict';

  /**
   * @ngdoc overview
   * @name horizon.framework.util.bind-scope
   * @description
   *
   * # horizon.framework.util.bind-scope
   *
   * This utility widget supports binding the scope where the directive is
   * instantiated with the transcluded content. This is useful when trying
   * to display transcluded content using the `ngRepeat` scope.
   *
   * | Directives                                                               |
   * |--------------------------------------------------------------------------|
   * | {@link horizon.framework.util.bind-scope.directive:bindScope `bindScope`}          |
   *
   */
  angular
    .module('horizon.framework.util.bind-scope', []);

})();
