{-# LANGUAGE ForeignFunctionInterface #-}

-- Copyright © 2012  Clint Adams

-- This program is free software: you can redistribute it and/or
-- modify it under the terms of the GNU Lesser General Public
-- License as published by the Free Software Foundation, either
-- version 3 of the License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
-- Lesser General Public License for more details.
--
-- You should have received a copy of the GNU Lesser General Public
-- License along with this program.  If not, see
-- <http://www.gnu.org/licenses/>.

#include <bindings.dsl.h>
#include <sane/sane.h>

module Bindings.SANE where
#strict_import

#num SANE_CURRENT_MAJOR
#num SANE_CURRENT_MINOR

#cinline SANE_VERSION_CODE , <SANE_Int> -> <SANE_Int> -> <SANE_Int> -> <SANE_Int>

#cinline SANE_VERSION_MAJOR , <SANE_Int> -> <SANE_Int>
#cinline SANE_VERSION_MINOR , <SANE_Int> -> <SANE_Int>
#cinline SANE_VERSION_BUILD , <SANE_Int> -> <SANE_Int>

#num SANE_FALSE
#num SANE_TRUE

#integral_t SANE_Byte
#integral_t SANE_Word
#integral_t SANE_Bool
#integral_t SANE_Int
#synonym_t SANE_Char , CChar
#synonym_t SANE_String , CString
#synonym_t SANE_String_Const , CString
#synonym_t SANE_Handle, Ptr ()
#integral_t SANE_Fixed

#num SANE_FIXED_SCALE_SHIFT
#cinline SANE_FIX , CDouble -> <SANE_Fixed>
#cinline SANE_UNFIX , <SANE_Fixed> -> CDouble

#integral_t SANE_Status
#num SANE_STATUS_GOOD
#num SANE_STATUS_UNSUPPORTED
#num SANE_STATUS_CANCELLED
#num SANE_STATUS_DEVICE_BUSY
#num SANE_STATUS_INVAL
#num SANE_STATUS_EOF
#num SANE_STATUS_JAMMED
#num SANE_STATUS_NO_DOCS
#num SANE_STATUS_COVER_OPEN
#num SANE_STATUS_IO_ERROR
#num SANE_STATUS_NO_MEM
#num SANE_STATUS_ACCESS_DENIED

#integral_t SANE_Value_Type
#num SANE_TYPE_BOOL
#num SANE_TYPE_INT
#num SANE_TYPE_FIXED
#num SANE_TYPE_STRING
#num SANE_TYPE_BUTTON
#num SANE_TYPE_GROUP

#integral_t SANE_Unit
#num SANE_UNIT_NONE
#num SANE_UNIT_PIXEL
#num SANE_UNIT_BIT
#num SANE_UNIT_MM
#num SANE_UNIT_DPI
#num SANE_UNIT_PERCENT
#num SANE_UNIT_MICROSECOND

#starttype SANE_Device
#field name , <SANE_String_Const>
#field vendor , <SANE_String_Const>
#field model , <SANE_String_Const>
#field type , <SANE_String_Const>
#stoptype

#num SANE_CAP_SOFT_SELECT
#num SANE_CAP_HARD_SELECT
#num SANE_CAP_SOFT_DETECT
#num SANE_CAP_EMULATED
#num SANE_CAP_AUTOMATIC
#num SANE_CAP_INACTIVE
#num SANE_CAP_ADVANCED

#cinline SANE_OPTION_IS_ACTIVE , CInt -> CInt
#cinline SANE_OPTION_IS_SETTABLE , CInt -> CInt

#num SANE_INFO_INEXACT
#num SANE_INFO_RELOAD_OPTIONS
#num SANE_INFO_RELOAD_PARAMS

#integral_t SANE_Constraint_Type
#num SANE_CONSTRAINT_NONE
#num SANE_CONSTRAINT_RANGE
#num SANE_CONSTRAINT_WORD_LIST
#num SANE_CONSTRAINT_STRING_LIST

#starttype SANE_Range
#field min , <SANE_Word>
#field max , <SANE_Word>
#field quant , <SANE_Word>
#stoptype

#starttype SANE_Option_Descriptor
#field name , <SANE_String_Const>
#field title , <SANE_String_Const>
#field desc , <SANE_String_Const>
#field type , <SANE_Value_Type>
#field unit , <SANE_Unit>
#field size , <SANE_Int>
#field cap , <SANE_Int>
#field constraint_type , <SANE_Constraint_Type>
#union_field constraint.string_list , Ptr <SANE_String_Const>
#union_field constraint.word_list , Ptr <SANE_Word>
#union_field constraint.range , Ptr <SANE_Range>
#stoptype

#integral_t SANE_Action
#num SANE_ACTION_GET_VALUE
#num SANE_ACTION_SET_VALUE
#num SANE_ACTION_SET_AUTO

#integral_t SANE_Frame
#num SANE_FRAME_GRAY
#num SANE_FRAME_RGB
#num SANE_FRAME_RED
#num SANE_FRAME_GREEN
#num SANE_FRAME_BLUE

#starttype SANE_Parameters
#field format , <SANE_Frame>
#field last_frame , <SANE_Bool>
#field bytes_per_line , <SANE_Int>
#field pixels_per_line , <SANE_Int>
#field lines , <SANE_Int>
#field depth , <SANE_Int>
#stoptype

#opaque_t struct SANE_Auth_Data

#num SANE_MAX_USERNAME_LEN
#num SANE_MAX_PASSWORD_LEN

#callback SANE_Auth_Callback , <SANE_String_Const> -> Ptr <SANE_Char> -> Ptr <SANE_Char> -> IO ()

#ccall sane_init , Ptr <SANE_Int> -> <SANE_Auth_Callback> -> IO <SANE_Status>
#ccall sane_exit , IO ()
#ccall sane_get_devices , Ptr (Ptr (Ptr <SANE_Device>)) -> <SANE_Bool> -> IO <SANE_Status>
#ccall sane_open , <SANE_String_Const> -> Ptr <SANE_Handle> -> IO <SANE_Status>
#ccall sane_close , <SANE_Handle> -> IO ()
#ccall sane_get_option_descriptor , <SANE_Handle> -> <SANE_Int> -> IO (Ptr <SANE_Option_Descriptor>)
#ccall sane_control_option , <SANE_Handle> -> <SANE_Int> -> <SANE_Action> -> Ptr () -> Ptr <SANE_Int> -> IO <SANE_Status>
#ccall sane_get_parameters , <SANE_Handle> -> Ptr <SANE_Parameters> -> IO <SANE_Status>
#ccall sane_start , <SANE_Handle> -> IO <SANE_Status>
#ccall sane_read , <SANE_Handle> -> Ptr <SANE_Byte> -> <SANE_Int> -> Ptr <SANE_Int> -> IO <SANE_Status>
#ccall sane_cancel , <SANE_Handle> -> IO ()
#ccall sane_set_io_mode , <SANE_Handle> -> <SANE_Bool> -> IO <SANE_Status>
#ccall sane_get_select_fd , <SANE_Handle> -> Ptr <SANE_Int> -> IO <SANE_Status>
#ccall sane_strstatus , <SANE_Status> -> IO <SANE_String_Const>

