/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// WriteRequestWrites struct for WriteRequestWrites
type WriteRequestWrites struct {
	TupleKeys []TupleKey `json:"tuple_keys" yaml:"tuple_keys"`
	// On 'error' ( or unspecified ), the API returns an error if an identical tuple already exists. On 'ignore', identical writes are treated as no-ops (matching on user, relation, object, and RelationshipCondition).
	OnDuplicate *string `json:"on_duplicate,omitempty" yaml:"on_duplicate,omitempty"`
}

// NewWriteRequestWrites instantiates a new WriteRequestWrites object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewWriteRequestWrites(tupleKeys []TupleKey) *WriteRequestWrites {
	this := WriteRequestWrites{}
	this.TupleKeys = tupleKeys
	var onDuplicate = "error"
	this.OnDuplicate = &onDuplicate
	return &this
}

// NewWriteRequestWritesWithDefaults instantiates a new WriteRequestWrites object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewWriteRequestWritesWithDefaults() *WriteRequestWrites {
	this := WriteRequestWrites{}
	var onDuplicate = "error"
	this.OnDuplicate = &onDuplicate
	return &this
}

// GetTupleKeys returns the TupleKeys field value
func (o *WriteRequestWrites) GetTupleKeys() []TupleKey {
	if o == nil {
		var ret []TupleKey
		return ret
	}

	return o.TupleKeys
}

// GetTupleKeysOk returns a tuple with the TupleKeys field value
// and a boolean to check if the value has been set.
func (o *WriteRequestWrites) GetTupleKeysOk() (*[]TupleKey, bool) {
	if o == nil {
		return nil, false
	}
	return &o.TupleKeys, true
}

// SetTupleKeys sets field value
func (o *WriteRequestWrites) SetTupleKeys(v []TupleKey) {
	o.TupleKeys = v
}

// GetOnDuplicate returns the OnDuplicate field value if set, zero value otherwise.
func (o *WriteRequestWrites) GetOnDuplicate() string {
	if o == nil || o.OnDuplicate == nil {
		var ret string
		return ret
	}
	return *o.OnDuplicate
}

// GetOnDuplicateOk returns a tuple with the OnDuplicate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *WriteRequestWrites) GetOnDuplicateOk() (*string, bool) {
	if o == nil || o.OnDuplicate == nil {
		return nil, false
	}
	return o.OnDuplicate, true
}

// HasOnDuplicate returns a boolean if a field has been set.
func (o *WriteRequestWrites) HasOnDuplicate() bool {
	if o != nil && o.OnDuplicate != nil {
		return true
	}

	return false
}

// SetOnDuplicate gets a reference to the given string and assigns it to the OnDuplicate field.
func (o *WriteRequestWrites) SetOnDuplicate(v string) {
	o.OnDuplicate = &v
}

func (o WriteRequestWrites) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["tuple_keys"] = o.TupleKeys
	if o.OnDuplicate != nil {
		toSerialize["on_duplicate"] = o.OnDuplicate
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableWriteRequestWrites struct {
	value *WriteRequestWrites
	isSet bool
}

func (v NullableWriteRequestWrites) Get() *WriteRequestWrites {
	return v.value
}

func (v *NullableWriteRequestWrites) Set(val *WriteRequestWrites) {
	v.value = val
	v.isSet = true
}

func (v NullableWriteRequestWrites) IsSet() bool {
	return v.isSet
}

func (v *NullableWriteRequestWrites) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableWriteRequestWrites(val *WriteRequestWrites) *NullableWriteRequestWrites {
	return &NullableWriteRequestWrites{value: val, isSet: true}
}

func (v NullableWriteRequestWrites) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableWriteRequestWrites) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
