// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfrontkeyvaluestore

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opDeleteKey = "DeleteKey"

// DeleteKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKey for more information on using the DeleteKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteKeyRequest method.
//	req, resp := client.DeleteKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/DeleteKey
func (c *CloudFrontKeyValueStore) DeleteKeyRequest(input *DeleteKeyInput) (req *request.Request, output *DeleteKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteKey,
		HTTPMethod: "DELETE",
		HTTPPath:   "/key-value-stores/{KvsARN}/keys/{Key}",
	}

	if input == nil {
		input = &DeleteKeyInput{}
	}

	output = &DeleteKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteKey API operation for Amazon CloudFront KeyValueStore.
//
// Deletes the key value pair specified by the key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront KeyValueStore's
// API operation DeleteKey for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Resource is not in expected state.
//
//   - ValidationException
//     Validation failed.
//
//   - InternalServerException
//     Internal server error.
//
//   - ServiceQuotaExceededException
//     Limit exceeded.
//
//   - ResourceNotFoundException
//     Resource was not found.
//
//   - AccessDeniedException
//     Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/DeleteKey
func (c *CloudFrontKeyValueStore) DeleteKey(input *DeleteKeyInput) (*DeleteKeyOutput, error) {
	req, out := c.DeleteKeyRequest(input)
	return out, req.Send()
}

// DeleteKeyWithContext is the same as DeleteKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFrontKeyValueStore) DeleteKeyWithContext(ctx aws.Context, input *DeleteKeyInput, opts ...request.Option) (*DeleteKeyOutput, error) {
	req, out := c.DeleteKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeKeyValueStore = "DescribeKeyValueStore"

// DescribeKeyValueStoreRequest generates a "aws/request.Request" representing the
// client's request for the DescribeKeyValueStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeKeyValueStore for more information on using the DescribeKeyValueStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeKeyValueStoreRequest method.
//	req, resp := client.DescribeKeyValueStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/DescribeKeyValueStore
func (c *CloudFrontKeyValueStore) DescribeKeyValueStoreRequest(input *DescribeKeyValueStoreInput) (req *request.Request, output *DescribeKeyValueStoreOutput) {
	op := &request.Operation{
		Name:       opDescribeKeyValueStore,
		HTTPMethod: "GET",
		HTTPPath:   "/key-value-stores/{KvsARN}",
	}

	if input == nil {
		input = &DescribeKeyValueStoreInput{}
	}

	output = &DescribeKeyValueStoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeKeyValueStore API operation for Amazon CloudFront KeyValueStore.
//
// Returns metadata information about Key Value Store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront KeyValueStore's
// API operation DescribeKeyValueStore for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Resource is not in expected state.
//
//   - InternalServerException
//     Internal server error.
//
//   - ResourceNotFoundException
//     Resource was not found.
//
//   - AccessDeniedException
//     Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/DescribeKeyValueStore
func (c *CloudFrontKeyValueStore) DescribeKeyValueStore(input *DescribeKeyValueStoreInput) (*DescribeKeyValueStoreOutput, error) {
	req, out := c.DescribeKeyValueStoreRequest(input)
	return out, req.Send()
}

// DescribeKeyValueStoreWithContext is the same as DescribeKeyValueStore with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeKeyValueStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFrontKeyValueStore) DescribeKeyValueStoreWithContext(ctx aws.Context, input *DescribeKeyValueStoreInput, opts ...request.Option) (*DescribeKeyValueStoreOutput, error) {
	req, out := c.DescribeKeyValueStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKey = "GetKey"

// GetKeyRequest generates a "aws/request.Request" representing the
// client's request for the GetKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKey for more information on using the GetKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKeyRequest method.
//	req, resp := client.GetKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/GetKey
func (c *CloudFrontKeyValueStore) GetKeyRequest(input *GetKeyInput) (req *request.Request, output *GetKeyOutput) {
	op := &request.Operation{
		Name:       opGetKey,
		HTTPMethod: "GET",
		HTTPPath:   "/key-value-stores/{KvsARN}/keys/{Key}",
	}

	if input == nil {
		input = &GetKeyInput{}
	}

	output = &GetKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKey API operation for Amazon CloudFront KeyValueStore.
//
// Returns a key value pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront KeyValueStore's
// API operation GetKey for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Resource is not in expected state.
//
//   - InternalServerException
//     Internal server error.
//
//   - ResourceNotFoundException
//     Resource was not found.
//
//   - AccessDeniedException
//     Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/GetKey
func (c *CloudFrontKeyValueStore) GetKey(input *GetKeyInput) (*GetKeyOutput, error) {
	req, out := c.GetKeyRequest(input)
	return out, req.Send()
}

// GetKeyWithContext is the same as GetKey with the addition of
// the ability to pass a context and additional request options.
//
// See GetKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFrontKeyValueStore) GetKeyWithContext(ctx aws.Context, input *GetKeyInput, opts ...request.Option) (*GetKeyOutput, error) {
	req, out := c.GetKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListKeys = "ListKeys"

// ListKeysRequest generates a "aws/request.Request" representing the
// client's request for the ListKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKeys for more information on using the ListKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKeysRequest method.
//	req, resp := client.ListKeysRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/ListKeys
func (c *CloudFrontKeyValueStore) ListKeysRequest(input *ListKeysInput) (req *request.Request, output *ListKeysOutput) {
	op := &request.Operation{
		Name:       opListKeys,
		HTTPMethod: "GET",
		HTTPPath:   "/key-value-stores/{KvsARN}/keys",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKeysInput{}
	}

	output = &ListKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKeys API operation for Amazon CloudFront KeyValueStore.
//
// Returns a list of key value pairs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront KeyValueStore's
// API operation ListKeys for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Resource is not in expected state.
//
//   - ValidationException
//     Validation failed.
//
//   - InternalServerException
//     Internal server error.
//
//   - ResourceNotFoundException
//     Resource was not found.
//
//   - AccessDeniedException
//     Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/ListKeys
func (c *CloudFrontKeyValueStore) ListKeys(input *ListKeysInput) (*ListKeysOutput, error) {
	req, out := c.ListKeysRequest(input)
	return out, req.Send()
}

// ListKeysWithContext is the same as ListKeys with the addition of
// the ability to pass a context and additional request options.
//
// See ListKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFrontKeyValueStore) ListKeysWithContext(ctx aws.Context, input *ListKeysInput, opts ...request.Option) (*ListKeysOutput, error) {
	req, out := c.ListKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKeysPages iterates over the pages of a ListKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListKeys operation.
//	pageNum := 0
//	err := client.ListKeysPages(params,
//	    func(page *cloudfrontkeyvaluestore.ListKeysOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFrontKeyValueStore) ListKeysPages(input *ListKeysInput, fn func(*ListKeysOutput, bool) bool) error {
	return c.ListKeysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKeysPagesWithContext same as ListKeysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFrontKeyValueStore) ListKeysPagesWithContext(ctx aws.Context, input *ListKeysInput, fn func(*ListKeysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKeysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKeysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKeysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutKey = "PutKey"

// PutKeyRequest generates a "aws/request.Request" representing the
// client's request for the PutKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutKey for more information on using the PutKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutKeyRequest method.
//	req, resp := client.PutKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/PutKey
func (c *CloudFrontKeyValueStore) PutKeyRequest(input *PutKeyInput) (req *request.Request, output *PutKeyOutput) {
	op := &request.Operation{
		Name:       opPutKey,
		HTTPMethod: "PUT",
		HTTPPath:   "/key-value-stores/{KvsARN}/keys/{Key}",
	}

	if input == nil {
		input = &PutKeyInput{}
	}

	output = &PutKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutKey API operation for Amazon CloudFront KeyValueStore.
//
// Creates a new key value pair or replaces the value of an existing key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront KeyValueStore's
// API operation PutKey for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Resource is not in expected state.
//
//   - ValidationException
//     Validation failed.
//
//   - InternalServerException
//     Internal server error.
//
//   - ServiceQuotaExceededException
//     Limit exceeded.
//
//   - ResourceNotFoundException
//     Resource was not found.
//
//   - AccessDeniedException
//     Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/PutKey
func (c *CloudFrontKeyValueStore) PutKey(input *PutKeyInput) (*PutKeyOutput, error) {
	req, out := c.PutKeyRequest(input)
	return out, req.Send()
}

// PutKeyWithContext is the same as PutKey with the addition of
// the ability to pass a context and additional request options.
//
// See PutKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFrontKeyValueStore) PutKeyWithContext(ctx aws.Context, input *PutKeyInput, opts ...request.Option) (*PutKeyOutput, error) {
	req, out := c.PutKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateKeys = "UpdateKeys"

// UpdateKeysRequest generates a "aws/request.Request" representing the
// client's request for the UpdateKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateKeys for more information on using the UpdateKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateKeysRequest method.
//	req, resp := client.UpdateKeysRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/UpdateKeys
func (c *CloudFrontKeyValueStore) UpdateKeysRequest(input *UpdateKeysInput) (req *request.Request, output *UpdateKeysOutput) {
	op := &request.Operation{
		Name:       opUpdateKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/key-value-stores/{KvsARN}/keys",
	}

	if input == nil {
		input = &UpdateKeysInput{}
	}

	output = &UpdateKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateKeys API operation for Amazon CloudFront KeyValueStore.
//
// Puts or Deletes multiple key value pairs in a single, all-or-nothing operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront KeyValueStore's
// API operation UpdateKeys for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Resource is not in expected state.
//
//   - ValidationException
//     Validation failed.
//
//   - InternalServerException
//     Internal server error.
//
//   - ServiceQuotaExceededException
//     Limit exceeded.
//
//   - ResourceNotFoundException
//     Resource was not found.
//
//   - AccessDeniedException
//     Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/UpdateKeys
func (c *CloudFrontKeyValueStore) UpdateKeys(input *UpdateKeysInput) (*UpdateKeysOutput, error) {
	req, out := c.UpdateKeysRequest(input)
	return out, req.Send()
}

// UpdateKeysWithContext is the same as UpdateKeys with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFrontKeyValueStore) UpdateKeysWithContext(ctx aws.Context, input *UpdateKeysInput, opts ...request.Option) (*UpdateKeysOutput, error) {
	req, out := c.UpdateKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access denied.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Resource is not in expected state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteKeyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The current version (ETag) of the Key Value Store that you are deleting keys
	// from, which you can get using DescribeKeyValueStore.
	//
	// IfMatch is a required field
	IfMatch *string `location:"header" locationName:"If-Match" type:"string" required:"true"`

	// The key to delete.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Key Value Store.
	//
	// KvsARN is a required field
	KvsARN *string `location:"uri" locationName:"KvsARN" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKeyInput"}
	if s.IfMatch == nil {
		invalidParams.Add(request.NewErrParamRequired("IfMatch"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.KvsARN == nil {
		invalidParams.Add(request.NewErrParamRequired("KvsARN"))
	}
	if s.KvsARN != nil && len(*s.KvsARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KvsARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIfMatch sets the IfMatch field's value.
func (s *DeleteKeyInput) SetIfMatch(v string) *DeleteKeyInput {
	s.IfMatch = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DeleteKeyInput) SetKey(v string) *DeleteKeyInput {
	s.Key = &v
	return s
}

// SetKvsARN sets the KvsARN field's value.
func (s *DeleteKeyInput) SetKvsARN(v string) *DeleteKeyInput {
	s.KvsARN = &v
	return s
}

// Metadata information about a Key Value Store.
type DeleteKeyOutput struct {
	_ struct{} `type:"structure"`

	// The current version identifier of the Key Value Store after the successful
	// delete.
	//
	// ETag is a required field
	ETag *string `location:"header" locationName:"ETag" type:"string" required:"true"`

	// Number of key value pairs in the Key Value Store after the successful delete.
	//
	// ItemCount is a required field
	ItemCount *int64 `type:"integer" required:"true"`

	// Total size of the Key Value Store after the successful delete, in bytes.
	//
	// TotalSizeInBytes is a required field
	TotalSizeInBytes *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *DeleteKeyOutput) SetETag(v string) *DeleteKeyOutput {
	s.ETag = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *DeleteKeyOutput) SetItemCount(v int64) *DeleteKeyOutput {
	s.ItemCount = &v
	return s
}

// SetTotalSizeInBytes sets the TotalSizeInBytes field's value.
func (s *DeleteKeyOutput) SetTotalSizeInBytes(v int64) *DeleteKeyOutput {
	s.TotalSizeInBytes = &v
	return s
}

// List item for keys to delete.
type DeleteKeyRequestListItem struct {
	_ struct{} `type:"structure"`

	// The key of the key value pair to be deleted.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyRequestListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyRequestListItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKeyRequestListItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKeyRequestListItem"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *DeleteKeyRequestListItem) SetKey(v string) *DeleteKeyRequestListItem {
	s.Key = &v
	return s
}

type DescribeKeyValueStoreInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the Key Value Store.
	//
	// KvsARN is a required field
	KvsARN *string `location:"uri" locationName:"KvsARN" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeyValueStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeyValueStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeKeyValueStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeKeyValueStoreInput"}
	if s.KvsARN == nil {
		invalidParams.Add(request.NewErrParamRequired("KvsARN"))
	}
	if s.KvsARN != nil && len(*s.KvsARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KvsARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKvsARN sets the KvsARN field's value.
func (s *DescribeKeyValueStoreInput) SetKvsARN(v string) *DescribeKeyValueStoreInput {
	s.KvsARN = &v
	return s
}

// Metadata information about a Key Value Store.
type DescribeKeyValueStoreOutput struct {
	_ struct{} `type:"structure"`

	// Date and time when the Key Value Store was created.
	//
	// Created is a required field
	Created *time.Time `type:"timestamp" required:"true"`

	// The version identifier for the current version of the Key Value Store.
	//
	// ETag is a required field
	ETag *string `location:"header" locationName:"ETag" type:"string" required:"true"`

	// Number of key value pairs in the Key Value Store.
	//
	// ItemCount is a required field
	ItemCount *int64 `type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the Key Value Store.
	//
	// KvsARN is a required field
	KvsARN *string `min:"1" type:"string" required:"true"`

	// Date and time when the key value pairs in the Key Value Store was last modified.
	LastModified *time.Time `type:"timestamp"`

	// Total size of the Key Value Store in bytes.
	//
	// TotalSizeInBytes is a required field
	TotalSizeInBytes *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeyValueStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeyValueStoreOutput) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *DescribeKeyValueStoreOutput) SetCreated(v time.Time) *DescribeKeyValueStoreOutput {
	s.Created = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *DescribeKeyValueStoreOutput) SetETag(v string) *DescribeKeyValueStoreOutput {
	s.ETag = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *DescribeKeyValueStoreOutput) SetItemCount(v int64) *DescribeKeyValueStoreOutput {
	s.ItemCount = &v
	return s
}

// SetKvsARN sets the KvsARN field's value.
func (s *DescribeKeyValueStoreOutput) SetKvsARN(v string) *DescribeKeyValueStoreOutput {
	s.KvsARN = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *DescribeKeyValueStoreOutput) SetLastModified(v time.Time) *DescribeKeyValueStoreOutput {
	s.LastModified = &v
	return s
}

// SetTotalSizeInBytes sets the TotalSizeInBytes field's value.
func (s *DescribeKeyValueStoreOutput) SetTotalSizeInBytes(v int64) *DescribeKeyValueStoreOutput {
	s.TotalSizeInBytes = &v
	return s
}

type GetKeyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The key to get.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Key Value Store.
	//
	// KvsARN is a required field
	KvsARN *string `location:"uri" locationName:"KvsARN" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKeyInput"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.KvsARN == nil {
		invalidParams.Add(request.NewErrParamRequired("KvsARN"))
	}
	if s.KvsARN != nil && len(*s.KvsARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KvsARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *GetKeyInput) SetKey(v string) *GetKeyInput {
	s.Key = &v
	return s
}

// SetKvsARN sets the KvsARN field's value.
func (s *GetKeyInput) SetKvsARN(v string) *GetKeyInput {
	s.KvsARN = &v
	return s
}

// A key value pair.
type GetKeyOutput struct {
	_ struct{} `type:"structure"`

	// Number of key value pairs in the Key Value Store.
	//
	// ItemCount is a required field
	ItemCount *int64 `type:"integer" required:"true"`

	// The key of the key value pair.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Total size of the Key Value Store in bytes.
	//
	// TotalSizeInBytes is a required field
	TotalSizeInBytes *int64 `type:"long" required:"true"`

	// The value of the key value pair.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetKeyOutput's
	// String and GoString methods.
	//
	// Value is a required field
	Value *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyOutput) GoString() string {
	return s.String()
}

// SetItemCount sets the ItemCount field's value.
func (s *GetKeyOutput) SetItemCount(v int64) *GetKeyOutput {
	s.ItemCount = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetKeyOutput) SetKey(v string) *GetKeyOutput {
	s.Key = &v
	return s
}

// SetTotalSizeInBytes sets the TotalSizeInBytes field's value.
func (s *GetKeyOutput) SetTotalSizeInBytes(v int64) *GetKeyOutput {
	s.TotalSizeInBytes = &v
	return s
}

// SetValue sets the Value field's value.
func (s *GetKeyOutput) SetValue(v string) *GetKeyOutput {
	s.Value = &v
	return s
}

// Internal server error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListKeysInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the Key Value Store.
	//
	// KvsARN is a required field
	KvsARN *string `location:"uri" locationName:"KvsARN" min:"1" type:"string" required:"true"`

	// Maximum number of results that are returned per call. The default is 10 and
	// maximum allowed page is 50.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// If nextToken is returned in the response, there are more results available.
	// Make the next call using the returned token to retrieve the next page.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKeysInput"}
	if s.KvsARN == nil {
		invalidParams.Add(request.NewErrParamRequired("KvsARN"))
	}
	if s.KvsARN != nil && len(*s.KvsARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KvsARN", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKvsARN sets the KvsARN field's value.
func (s *ListKeysInput) SetKvsARN(v string) *ListKeysInput {
	s.KvsARN = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKeysInput) SetMaxResults(v int64) *ListKeysInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKeysInput) SetNextToken(v string) *ListKeysInput {
	s.NextToken = &v
	return s
}

type ListKeysOutput struct {
	_ struct{} `type:"structure"`

	// Key value pairs
	Items []*ListKeysResponseListItem `type:"list"`

	// If nextToken is returned in the response, there are more results available.
	// Make the next call using the returned token to retrieve the next page.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListKeysOutput) SetItems(v []*ListKeysResponseListItem) *ListKeysOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKeysOutput) SetNextToken(v string) *ListKeysOutput {
	s.NextToken = &v
	return s
}

// A key value pair.
type ListKeysResponseListItem struct {
	_ struct{} `type:"structure"`

	// The key of the key value pair.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the key value pair.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListKeysResponseListItem's
	// String and GoString methods.
	//
	// Value is a required field
	Value *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysResponseListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysResponseListItem) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ListKeysResponseListItem) SetKey(v string) *ListKeysResponseListItem {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ListKeysResponseListItem) SetValue(v string) *ListKeysResponseListItem {
	s.Value = &v
	return s
}

// A key value pair.
type PutKeyInput struct {
	_ struct{} `type:"structure"`

	// The current version (ETag) of the Key Value Store that you are putting keys
	// into, which you can get using DescribeKeyValueStore.
	//
	// IfMatch is a required field
	IfMatch *string `location:"header" locationName:"If-Match" type:"string" required:"true"`

	// The key to put.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Key Value Store.
	//
	// KvsARN is a required field
	KvsARN *string `location:"uri" locationName:"KvsARN" min:"1" type:"string" required:"true"`

	// The value to put.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PutKeyInput's
	// String and GoString methods.
	//
	// Value is a required field
	Value *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutKeyInput"}
	if s.IfMatch == nil {
		invalidParams.Add(request.NewErrParamRequired("IfMatch"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.KvsARN == nil {
		invalidParams.Add(request.NewErrParamRequired("KvsARN"))
	}
	if s.KvsARN != nil && len(*s.KvsARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KvsARN", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIfMatch sets the IfMatch field's value.
func (s *PutKeyInput) SetIfMatch(v string) *PutKeyInput {
	s.IfMatch = &v
	return s
}

// SetKey sets the Key field's value.
func (s *PutKeyInput) SetKey(v string) *PutKeyInput {
	s.Key = &v
	return s
}

// SetKvsARN sets the KvsARN field's value.
func (s *PutKeyInput) SetKvsARN(v string) *PutKeyInput {
	s.KvsARN = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PutKeyInput) SetValue(v string) *PutKeyInput {
	s.Value = &v
	return s
}

// Metadata information about a Key Value Store.
type PutKeyOutput struct {
	_ struct{} `type:"structure"`

	// The current version identifier of the Key Value Store after the successful
	// put.
	//
	// ETag is a required field
	ETag *string `location:"header" locationName:"ETag" type:"string" required:"true"`

	// Number of key value pairs in the Key Value Store after the successful put.
	//
	// ItemCount is a required field
	ItemCount *int64 `type:"integer" required:"true"`

	// Total size of the Key Value Store after the successful put, in bytes.
	//
	// TotalSizeInBytes is a required field
	TotalSizeInBytes *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKeyOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *PutKeyOutput) SetETag(v string) *PutKeyOutput {
	s.ETag = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *PutKeyOutput) SetItemCount(v int64) *PutKeyOutput {
	s.ItemCount = &v
	return s
}

// SetTotalSizeInBytes sets the TotalSizeInBytes field's value.
func (s *PutKeyOutput) SetTotalSizeInBytes(v int64) *PutKeyOutput {
	s.TotalSizeInBytes = &v
	return s
}

// List item for key value pair to put.
type PutKeyRequestListItem struct {
	_ struct{} `type:"structure"`

	// The key of the key value pair list item to put.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value for the key value pair to put.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PutKeyRequestListItem's
	// String and GoString methods.
	//
	// Value is a required field
	Value *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKeyRequestListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKeyRequestListItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutKeyRequestListItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutKeyRequestListItem"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *PutKeyRequestListItem) SetKey(v string) *PutKeyRequestListItem {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PutKeyRequestListItem) SetValue(v string) *PutKeyRequestListItem {
	s.Value = &v
	return s
}

// Resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Limit exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateKeysInput struct {
	_ struct{} `type:"structure"`

	// List of keys to delete.
	Deletes []*DeleteKeyRequestListItem `type:"list"`

	// The current version (ETag) of the Key Value Store that you are updating keys
	// of, which you can get using DescribeKeyValueStore.
	//
	// IfMatch is a required field
	IfMatch *string `location:"header" locationName:"If-Match" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Key Value Store.
	//
	// KvsARN is a required field
	KvsARN *string `location:"uri" locationName:"KvsARN" min:"1" type:"string" required:"true"`

	// List of key value pairs to put.
	Puts []*PutKeyRequestListItem `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKeysInput"}
	if s.IfMatch == nil {
		invalidParams.Add(request.NewErrParamRequired("IfMatch"))
	}
	if s.KvsARN == nil {
		invalidParams.Add(request.NewErrParamRequired("KvsARN"))
	}
	if s.KvsARN != nil && len(*s.KvsARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KvsARN", 1))
	}
	if s.Deletes != nil {
		for i, v := range s.Deletes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Deletes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Puts != nil {
		for i, v := range s.Puts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Puts", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeletes sets the Deletes field's value.
func (s *UpdateKeysInput) SetDeletes(v []*DeleteKeyRequestListItem) *UpdateKeysInput {
	s.Deletes = v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *UpdateKeysInput) SetIfMatch(v string) *UpdateKeysInput {
	s.IfMatch = &v
	return s
}

// SetKvsARN sets the KvsARN field's value.
func (s *UpdateKeysInput) SetKvsARN(v string) *UpdateKeysInput {
	s.KvsARN = &v
	return s
}

// SetPuts sets the Puts field's value.
func (s *UpdateKeysInput) SetPuts(v []*PutKeyRequestListItem) *UpdateKeysInput {
	s.Puts = v
	return s
}

// Metadata information about a Key Value Store.
type UpdateKeysOutput struct {
	_ struct{} `type:"structure"`

	// The current version identifier of the Key Value Store after the successful
	// update.
	//
	// ETag is a required field
	ETag *string `location:"header" locationName:"ETag" type:"string" required:"true"`

	// Number of key value pairs in the Key Value Store after the successful update.
	//
	// ItemCount is a required field
	ItemCount *int64 `type:"integer" required:"true"`

	// Total size of the Key Value Store after the successful update, in bytes.
	//
	// TotalSizeInBytes is a required field
	TotalSizeInBytes *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKeysOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *UpdateKeysOutput) SetETag(v string) *UpdateKeysOutput {
	s.ETag = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *UpdateKeysOutput) SetItemCount(v int64) *UpdateKeysOutput {
	s.ItemCount = &v
	return s
}

// SetTotalSizeInBytes sets the TotalSizeInBytes field's value.
func (s *UpdateKeysOutput) SetTotalSizeInBytes(v int64) *UpdateKeysOutput {
	s.TotalSizeInBytes = &v
	return s
}

// Validation failed.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}
