// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ivschatiface provides an interface to enable mocking the Amazon Interactive Video Service Chat service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ivschatiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/ivschat"
)

// IvschatAPI provides an interface to enable mocking the
// ivschat.Ivschat service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Interactive Video Service Chat.
//	func myFunc(svc ivschatiface.IvschatAPI) bool {
//	    // Make svc.CreateChatToken request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := ivschat.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockIvschatClient struct {
//	    ivschatiface.IvschatAPI
//	}
//	func (m *mockIvschatClient) CreateChatToken(input *ivschat.CreateChatTokenInput) (*ivschat.CreateChatTokenOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockIvschatClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type IvschatAPI interface {
	CreateChatToken(*ivschat.CreateChatTokenInput) (*ivschat.CreateChatTokenOutput, error)
	CreateChatTokenWithContext(aws.Context, *ivschat.CreateChatTokenInput, ...request.Option) (*ivschat.CreateChatTokenOutput, error)
	CreateChatTokenRequest(*ivschat.CreateChatTokenInput) (*request.Request, *ivschat.CreateChatTokenOutput)

	CreateRoom(*ivschat.CreateRoomInput) (*ivschat.CreateRoomOutput, error)
	CreateRoomWithContext(aws.Context, *ivschat.CreateRoomInput, ...request.Option) (*ivschat.CreateRoomOutput, error)
	CreateRoomRequest(*ivschat.CreateRoomInput) (*request.Request, *ivschat.CreateRoomOutput)

	DeleteMessage(*ivschat.DeleteMessageInput) (*ivschat.DeleteMessageOutput, error)
	DeleteMessageWithContext(aws.Context, *ivschat.DeleteMessageInput, ...request.Option) (*ivschat.DeleteMessageOutput, error)
	DeleteMessageRequest(*ivschat.DeleteMessageInput) (*request.Request, *ivschat.DeleteMessageOutput)

	DeleteRoom(*ivschat.DeleteRoomInput) (*ivschat.DeleteRoomOutput, error)
	DeleteRoomWithContext(aws.Context, *ivschat.DeleteRoomInput, ...request.Option) (*ivschat.DeleteRoomOutput, error)
	DeleteRoomRequest(*ivschat.DeleteRoomInput) (*request.Request, *ivschat.DeleteRoomOutput)

	DisconnectUser(*ivschat.DisconnectUserInput) (*ivschat.DisconnectUserOutput, error)
	DisconnectUserWithContext(aws.Context, *ivschat.DisconnectUserInput, ...request.Option) (*ivschat.DisconnectUserOutput, error)
	DisconnectUserRequest(*ivschat.DisconnectUserInput) (*request.Request, *ivschat.DisconnectUserOutput)

	GetRoom(*ivschat.GetRoomInput) (*ivschat.GetRoomOutput, error)
	GetRoomWithContext(aws.Context, *ivschat.GetRoomInput, ...request.Option) (*ivschat.GetRoomOutput, error)
	GetRoomRequest(*ivschat.GetRoomInput) (*request.Request, *ivschat.GetRoomOutput)

	ListRooms(*ivschat.ListRoomsInput) (*ivschat.ListRoomsOutput, error)
	ListRoomsWithContext(aws.Context, *ivschat.ListRoomsInput, ...request.Option) (*ivschat.ListRoomsOutput, error)
	ListRoomsRequest(*ivschat.ListRoomsInput) (*request.Request, *ivschat.ListRoomsOutput)

	ListRoomsPages(*ivschat.ListRoomsInput, func(*ivschat.ListRoomsOutput, bool) bool) error
	ListRoomsPagesWithContext(aws.Context, *ivschat.ListRoomsInput, func(*ivschat.ListRoomsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*ivschat.ListTagsForResourceInput) (*ivschat.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *ivschat.ListTagsForResourceInput, ...request.Option) (*ivschat.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*ivschat.ListTagsForResourceInput) (*request.Request, *ivschat.ListTagsForResourceOutput)

	SendEvent(*ivschat.SendEventInput) (*ivschat.SendEventOutput, error)
	SendEventWithContext(aws.Context, *ivschat.SendEventInput, ...request.Option) (*ivschat.SendEventOutput, error)
	SendEventRequest(*ivschat.SendEventInput) (*request.Request, *ivschat.SendEventOutput)

	TagResource(*ivschat.TagResourceInput) (*ivschat.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *ivschat.TagResourceInput, ...request.Option) (*ivschat.TagResourceOutput, error)
	TagResourceRequest(*ivschat.TagResourceInput) (*request.Request, *ivschat.TagResourceOutput)

	UntagResource(*ivschat.UntagResourceInput) (*ivschat.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *ivschat.UntagResourceInput, ...request.Option) (*ivschat.UntagResourceOutput, error)
	UntagResourceRequest(*ivschat.UntagResourceInput) (*request.Request, *ivschat.UntagResourceOutput)

	UpdateRoom(*ivschat.UpdateRoomInput) (*ivschat.UpdateRoomOutput, error)
	UpdateRoomWithContext(aws.Context, *ivschat.UpdateRoomInput, ...request.Option) (*ivschat.UpdateRoomOutput, error)
	UpdateRoomRequest(*ivschat.UpdateRoomInput) (*request.Request, *ivschat.UpdateRoomOutput)
}

var _ IvschatAPI = (*ivschat.Ivschat)(nil)
