// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptInboundCrossClusterSearchConnection = "AcceptInboundCrossClusterSearchConnection"

// AcceptInboundCrossClusterSearchConnectionRequest generates a "aws/request.Request" representing the
// client's request for the AcceptInboundCrossClusterSearchConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptInboundCrossClusterSearchConnection for more information on using the AcceptInboundCrossClusterSearchConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptInboundCrossClusterSearchConnectionRequest method.
//	req, resp := client.AcceptInboundCrossClusterSearchConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) AcceptInboundCrossClusterSearchConnectionRequest(input *AcceptInboundCrossClusterSearchConnectionInput) (req *request.Request, output *AcceptInboundCrossClusterSearchConnectionOutput) {
	op := &request.Operation{
		Name:       opAcceptInboundCrossClusterSearchConnection,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-01-01/es/ccs/inboundConnection/{ConnectionId}/accept",
	}

	if input == nil {
		input = &AcceptInboundCrossClusterSearchConnectionInput{}
	}

	output = &AcceptInboundCrossClusterSearchConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptInboundCrossClusterSearchConnection API operation for Amazon Elasticsearch Service.
//
// Allows the destination domain owner to accept an inbound cross-cluster search
// connection request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation AcceptInboundCrossClusterSearchConnection for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - LimitExceededException
//     An exception for trying to create more than allowed resources or sub-resources.
//     Gives http status code of 409.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access a not supported operation.
//     Gives http status code of 409.
func (c *ElasticsearchService) AcceptInboundCrossClusterSearchConnection(input *AcceptInboundCrossClusterSearchConnectionInput) (*AcceptInboundCrossClusterSearchConnectionOutput, error) {
	req, out := c.AcceptInboundCrossClusterSearchConnectionRequest(input)
	return out, req.Send()
}

// AcceptInboundCrossClusterSearchConnectionWithContext is the same as AcceptInboundCrossClusterSearchConnection with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptInboundCrossClusterSearchConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) AcceptInboundCrossClusterSearchConnectionWithContext(ctx aws.Context, input *AcceptInboundCrossClusterSearchConnectionInput, opts ...request.Option) (*AcceptInboundCrossClusterSearchConnectionOutput, error) {
	req, out := c.AcceptInboundCrossClusterSearchConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddTags = "AddTags"

// AddTagsRequest generates a "aws/request.Request" representing the
// client's request for the AddTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTags for more information on using the AddTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddTagsRequest method.
//	req, resp := client.AddTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/tags",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	output = &AddTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTags API operation for Amazon Elasticsearch Service.
//
// Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive
// key value pairs. An Elasticsearch domain may have up to 10 tags. See Tagging
// Amazon Elasticsearch Service Domains for more information. (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation AddTags for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - LimitExceededException
//     An exception for trying to create more than allowed resources or sub-resources.
//     Gives http status code of 409.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
func (c *ElasticsearchService) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	return out, req.Send()
}

// AddTagsWithContext is the same as AddTags with the addition of
// the ability to pass a context and additional request options.
//
// See AddTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) AddTagsWithContext(ctx aws.Context, input *AddTagsInput, opts ...request.Option) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociatePackage = "AssociatePackage"

// AssociatePackageRequest generates a "aws/request.Request" representing the
// client's request for the AssociatePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociatePackage for more information on using the AssociatePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociatePackageRequest method.
//	req, resp := client.AssociatePackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) AssociatePackageRequest(input *AssociatePackageInput) (req *request.Request, output *AssociatePackageOutput) {
	op := &request.Operation{
		Name:       opAssociatePackage,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/packages/associate/{PackageID}/{DomainName}",
	}

	if input == nil {
		input = &AssociatePackageInput{}
	}

	output = &AssociatePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociatePackage API operation for Amazon Elasticsearch Service.
//
// Associates a package with an Amazon ES domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation AssociatePackage for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - AccessDeniedException
//     An error occurred because user does not have permissions to access the resource.
//     Returns HTTP status code 403.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
//
//   - ConflictException
//     An error occurred because the client attempts to remove a resource that is
//     currently in use. Returns HTTP status code 409.
func (c *ElasticsearchService) AssociatePackage(input *AssociatePackageInput) (*AssociatePackageOutput, error) {
	req, out := c.AssociatePackageRequest(input)
	return out, req.Send()
}

// AssociatePackageWithContext is the same as AssociatePackage with the addition of
// the ability to pass a context and additional request options.
//
// See AssociatePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) AssociatePackageWithContext(ctx aws.Context, input *AssociatePackageInput, opts ...request.Option) (*AssociatePackageOutput, error) {
	req, out := c.AssociatePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelElasticsearchServiceSoftwareUpdate = "CancelElasticsearchServiceSoftwareUpdate"

// CancelElasticsearchServiceSoftwareUpdateRequest generates a "aws/request.Request" representing the
// client's request for the CancelElasticsearchServiceSoftwareUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelElasticsearchServiceSoftwareUpdate for more information on using the CancelElasticsearchServiceSoftwareUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelElasticsearchServiceSoftwareUpdateRequest method.
//	req, resp := client.CancelElasticsearchServiceSoftwareUpdateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) CancelElasticsearchServiceSoftwareUpdateRequest(input *CancelElasticsearchServiceSoftwareUpdateInput) (req *request.Request, output *CancelElasticsearchServiceSoftwareUpdateOutput) {
	op := &request.Operation{
		Name:       opCancelElasticsearchServiceSoftwareUpdate,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/serviceSoftwareUpdate/cancel",
	}

	if input == nil {
		input = &CancelElasticsearchServiceSoftwareUpdateInput{}
	}

	output = &CancelElasticsearchServiceSoftwareUpdateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelElasticsearchServiceSoftwareUpdate API operation for Amazon Elasticsearch Service.
//
// Cancels a scheduled service software update for an Amazon ES domain. You
// can only perform this operation before the AutomatedUpdateDate and when the
// UpdateStatus is in the PENDING_UPDATE state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation CancelElasticsearchServiceSoftwareUpdate for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) CancelElasticsearchServiceSoftwareUpdate(input *CancelElasticsearchServiceSoftwareUpdateInput) (*CancelElasticsearchServiceSoftwareUpdateOutput, error) {
	req, out := c.CancelElasticsearchServiceSoftwareUpdateRequest(input)
	return out, req.Send()
}

// CancelElasticsearchServiceSoftwareUpdateWithContext is the same as CancelElasticsearchServiceSoftwareUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See CancelElasticsearchServiceSoftwareUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) CancelElasticsearchServiceSoftwareUpdateWithContext(ctx aws.Context, input *CancelElasticsearchServiceSoftwareUpdateInput, opts ...request.Option) (*CancelElasticsearchServiceSoftwareUpdateOutput, error) {
	req, out := c.CancelElasticsearchServiceSoftwareUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateElasticsearchDomain = "CreateElasticsearchDomain"

// CreateElasticsearchDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateElasticsearchDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateElasticsearchDomain for more information on using the CreateElasticsearchDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateElasticsearchDomainRequest method.
//	req, resp := client.CreateElasticsearchDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) CreateElasticsearchDomainRequest(input *CreateElasticsearchDomainInput) (req *request.Request, output *CreateElasticsearchDomainOutput) {
	op := &request.Operation{
		Name:       opCreateElasticsearchDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/domain",
	}

	if input == nil {
		input = &CreateElasticsearchDomainInput{}
	}

	output = &CreateElasticsearchDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateElasticsearchDomain API operation for Amazon Elasticsearch Service.
//
// Creates a new Elasticsearch domain. For more information, see Creating Elasticsearch
// Domains (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains)
// in the Amazon Elasticsearch Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation CreateElasticsearchDomain for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access a not supported operation.
//     Gives http status code of 409.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - InvalidTypeException
//     An exception for trying to create or access sub-resource that is either invalid
//     or not supported. Gives http status code of 409.
//
//   - LimitExceededException
//     An exception for trying to create more than allowed resources or sub-resources.
//     Gives http status code of 409.
//
//   - ResourceAlreadyExistsException
//     An exception for creating a resource that already exists. Gives http status
//     code of 400.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) CreateElasticsearchDomain(input *CreateElasticsearchDomainInput) (*CreateElasticsearchDomainOutput, error) {
	req, out := c.CreateElasticsearchDomainRequest(input)
	return out, req.Send()
}

// CreateElasticsearchDomainWithContext is the same as CreateElasticsearchDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateElasticsearchDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) CreateElasticsearchDomainWithContext(ctx aws.Context, input *CreateElasticsearchDomainInput, opts ...request.Option) (*CreateElasticsearchDomainOutput, error) {
	req, out := c.CreateElasticsearchDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOutboundCrossClusterSearchConnection = "CreateOutboundCrossClusterSearchConnection"

// CreateOutboundCrossClusterSearchConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateOutboundCrossClusterSearchConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOutboundCrossClusterSearchConnection for more information on using the CreateOutboundCrossClusterSearchConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateOutboundCrossClusterSearchConnectionRequest method.
//	req, resp := client.CreateOutboundCrossClusterSearchConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) CreateOutboundCrossClusterSearchConnectionRequest(input *CreateOutboundCrossClusterSearchConnectionInput) (req *request.Request, output *CreateOutboundCrossClusterSearchConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateOutboundCrossClusterSearchConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/ccs/outboundConnection",
	}

	if input == nil {
		input = &CreateOutboundCrossClusterSearchConnectionInput{}
	}

	output = &CreateOutboundCrossClusterSearchConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOutboundCrossClusterSearchConnection API operation for Amazon Elasticsearch Service.
//
// Creates a new cross-cluster search connection from a source domain to a destination
// domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation CreateOutboundCrossClusterSearchConnection for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     An exception for trying to create more than allowed resources or sub-resources.
//     Gives http status code of 409.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceAlreadyExistsException
//     An exception for creating a resource that already exists. Gives http status
//     code of 400.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access a not supported operation.
//     Gives http status code of 409.
func (c *ElasticsearchService) CreateOutboundCrossClusterSearchConnection(input *CreateOutboundCrossClusterSearchConnectionInput) (*CreateOutboundCrossClusterSearchConnectionOutput, error) {
	req, out := c.CreateOutboundCrossClusterSearchConnectionRequest(input)
	return out, req.Send()
}

// CreateOutboundCrossClusterSearchConnectionWithContext is the same as CreateOutboundCrossClusterSearchConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOutboundCrossClusterSearchConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) CreateOutboundCrossClusterSearchConnectionWithContext(ctx aws.Context, input *CreateOutboundCrossClusterSearchConnectionInput, opts ...request.Option) (*CreateOutboundCrossClusterSearchConnectionOutput, error) {
	req, out := c.CreateOutboundCrossClusterSearchConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePackage = "CreatePackage"

// CreatePackageRequest generates a "aws/request.Request" representing the
// client's request for the CreatePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePackage for more information on using the CreatePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePackageRequest method.
//	req, resp := client.CreatePackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) CreatePackageRequest(input *CreatePackageInput) (req *request.Request, output *CreatePackageOutput) {
	op := &request.Operation{
		Name:       opCreatePackage,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/packages",
	}

	if input == nil {
		input = &CreatePackageInput{}
	}

	output = &CreatePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePackage API operation for Amazon Elasticsearch Service.
//
// Create a package for use with Amazon ES domains.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation CreatePackage for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - LimitExceededException
//     An exception for trying to create more than allowed resources or sub-resources.
//     Gives http status code of 409.
//
//   - InvalidTypeException
//     An exception for trying to create or access sub-resource that is either invalid
//     or not supported. Gives http status code of 409.
//
//   - ResourceAlreadyExistsException
//     An exception for creating a resource that already exists. Gives http status
//     code of 400.
//
//   - AccessDeniedException
//     An error occurred because user does not have permissions to access the resource.
//     Returns HTTP status code 403.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) CreatePackage(input *CreatePackageInput) (*CreatePackageOutput, error) {
	req, out := c.CreatePackageRequest(input)
	return out, req.Send()
}

// CreatePackageWithContext is the same as CreatePackage with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) CreatePackageWithContext(ctx aws.Context, input *CreatePackageInput, opts ...request.Option) (*CreatePackageOutput, error) {
	req, out := c.CreatePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteElasticsearchDomain = "DeleteElasticsearchDomain"

// DeleteElasticsearchDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteElasticsearchDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteElasticsearchDomain for more information on using the DeleteElasticsearchDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteElasticsearchDomainRequest method.
//	req, resp := client.DeleteElasticsearchDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DeleteElasticsearchDomainRequest(input *DeleteElasticsearchDomainInput) (req *request.Request, output *DeleteElasticsearchDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteElasticsearchDomain,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}",
	}

	if input == nil {
		input = &DeleteElasticsearchDomainInput{}
	}

	output = &DeleteElasticsearchDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteElasticsearchDomain API operation for Amazon Elasticsearch Service.
//
// Permanently deletes the specified Elasticsearch domain and all of its data.
// Once a domain is deleted, it cannot be recovered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DeleteElasticsearchDomain for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) DeleteElasticsearchDomain(input *DeleteElasticsearchDomainInput) (*DeleteElasticsearchDomainOutput, error) {
	req, out := c.DeleteElasticsearchDomainRequest(input)
	return out, req.Send()
}

// DeleteElasticsearchDomainWithContext is the same as DeleteElasticsearchDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteElasticsearchDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DeleteElasticsearchDomainWithContext(ctx aws.Context, input *DeleteElasticsearchDomainInput, opts ...request.Option) (*DeleteElasticsearchDomainOutput, error) {
	req, out := c.DeleteElasticsearchDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteElasticsearchServiceRole = "DeleteElasticsearchServiceRole"

// DeleteElasticsearchServiceRoleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteElasticsearchServiceRole operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteElasticsearchServiceRole for more information on using the DeleteElasticsearchServiceRole
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteElasticsearchServiceRoleRequest method.
//	req, resp := client.DeleteElasticsearchServiceRoleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DeleteElasticsearchServiceRoleRequest(input *DeleteElasticsearchServiceRoleInput) (req *request.Request, output *DeleteElasticsearchServiceRoleOutput) {
	op := &request.Operation{
		Name:       opDeleteElasticsearchServiceRole,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-01-01/es/role",
	}

	if input == nil {
		input = &DeleteElasticsearchServiceRoleInput{}
	}

	output = &DeleteElasticsearchServiceRoleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteElasticsearchServiceRole API operation for Amazon Elasticsearch Service.
//
// Deletes the service-linked role that Elasticsearch Service uses to manage
// and maintain VPC domains. Role deletion will fail if any existing VPC domains
// use the role. You must delete any such Elasticsearch domains before deleting
// the role. See Deleting Elasticsearch Service Role (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr)
// in VPC Endpoints for Amazon Elasticsearch Service Domains.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DeleteElasticsearchServiceRole for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) DeleteElasticsearchServiceRole(input *DeleteElasticsearchServiceRoleInput) (*DeleteElasticsearchServiceRoleOutput, error) {
	req, out := c.DeleteElasticsearchServiceRoleRequest(input)
	return out, req.Send()
}

// DeleteElasticsearchServiceRoleWithContext is the same as DeleteElasticsearchServiceRole with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteElasticsearchServiceRole for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DeleteElasticsearchServiceRoleWithContext(ctx aws.Context, input *DeleteElasticsearchServiceRoleInput, opts ...request.Option) (*DeleteElasticsearchServiceRoleOutput, error) {
	req, out := c.DeleteElasticsearchServiceRoleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInboundCrossClusterSearchConnection = "DeleteInboundCrossClusterSearchConnection"

// DeleteInboundCrossClusterSearchConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInboundCrossClusterSearchConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInboundCrossClusterSearchConnection for more information on using the DeleteInboundCrossClusterSearchConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInboundCrossClusterSearchConnectionRequest method.
//	req, resp := client.DeleteInboundCrossClusterSearchConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DeleteInboundCrossClusterSearchConnectionRequest(input *DeleteInboundCrossClusterSearchConnectionInput) (req *request.Request, output *DeleteInboundCrossClusterSearchConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteInboundCrossClusterSearchConnection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-01-01/es/ccs/inboundConnection/{ConnectionId}",
	}

	if input == nil {
		input = &DeleteInboundCrossClusterSearchConnectionInput{}
	}

	output = &DeleteInboundCrossClusterSearchConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInboundCrossClusterSearchConnection API operation for Amazon Elasticsearch Service.
//
// Allows the destination domain owner to delete an existing inbound cross-cluster
// search connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DeleteInboundCrossClusterSearchConnection for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access a not supported operation.
//     Gives http status code of 409.
func (c *ElasticsearchService) DeleteInboundCrossClusterSearchConnection(input *DeleteInboundCrossClusterSearchConnectionInput) (*DeleteInboundCrossClusterSearchConnectionOutput, error) {
	req, out := c.DeleteInboundCrossClusterSearchConnectionRequest(input)
	return out, req.Send()
}

// DeleteInboundCrossClusterSearchConnectionWithContext is the same as DeleteInboundCrossClusterSearchConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInboundCrossClusterSearchConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DeleteInboundCrossClusterSearchConnectionWithContext(ctx aws.Context, input *DeleteInboundCrossClusterSearchConnectionInput, opts ...request.Option) (*DeleteInboundCrossClusterSearchConnectionOutput, error) {
	req, out := c.DeleteInboundCrossClusterSearchConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOutboundCrossClusterSearchConnection = "DeleteOutboundCrossClusterSearchConnection"

// DeleteOutboundCrossClusterSearchConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOutboundCrossClusterSearchConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOutboundCrossClusterSearchConnection for more information on using the DeleteOutboundCrossClusterSearchConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteOutboundCrossClusterSearchConnectionRequest method.
//	req, resp := client.DeleteOutboundCrossClusterSearchConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DeleteOutboundCrossClusterSearchConnectionRequest(input *DeleteOutboundCrossClusterSearchConnectionInput) (req *request.Request, output *DeleteOutboundCrossClusterSearchConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteOutboundCrossClusterSearchConnection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-01-01/es/ccs/outboundConnection/{ConnectionId}",
	}

	if input == nil {
		input = &DeleteOutboundCrossClusterSearchConnectionInput{}
	}

	output = &DeleteOutboundCrossClusterSearchConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteOutboundCrossClusterSearchConnection API operation for Amazon Elasticsearch Service.
//
// Allows the source domain owner to delete an existing outbound cross-cluster
// search connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DeleteOutboundCrossClusterSearchConnection for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access a not supported operation.
//     Gives http status code of 409.
func (c *ElasticsearchService) DeleteOutboundCrossClusterSearchConnection(input *DeleteOutboundCrossClusterSearchConnectionInput) (*DeleteOutboundCrossClusterSearchConnectionOutput, error) {
	req, out := c.DeleteOutboundCrossClusterSearchConnectionRequest(input)
	return out, req.Send()
}

// DeleteOutboundCrossClusterSearchConnectionWithContext is the same as DeleteOutboundCrossClusterSearchConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOutboundCrossClusterSearchConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DeleteOutboundCrossClusterSearchConnectionWithContext(ctx aws.Context, input *DeleteOutboundCrossClusterSearchConnectionInput, opts ...request.Option) (*DeleteOutboundCrossClusterSearchConnectionOutput, error) {
	req, out := c.DeleteOutboundCrossClusterSearchConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePackage = "DeletePackage"

// DeletePackageRequest generates a "aws/request.Request" representing the
// client's request for the DeletePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePackage for more information on using the DeletePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePackageRequest method.
//	req, resp := client.DeletePackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DeletePackageRequest(input *DeletePackageInput) (req *request.Request, output *DeletePackageOutput) {
	op := &request.Operation{
		Name:       opDeletePackage,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-01-01/packages/{PackageID}",
	}

	if input == nil {
		input = &DeletePackageInput{}
	}

	output = &DeletePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePackage API operation for Amazon Elasticsearch Service.
//
// Delete the package.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DeletePackage for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - AccessDeniedException
//     An error occurred because user does not have permissions to access the resource.
//     Returns HTTP status code 403.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
//
//   - ConflictException
//     An error occurred because the client attempts to remove a resource that is
//     currently in use. Returns HTTP status code 409.
func (c *ElasticsearchService) DeletePackage(input *DeletePackageInput) (*DeletePackageOutput, error) {
	req, out := c.DeletePackageRequest(input)
	return out, req.Send()
}

// DeletePackageWithContext is the same as DeletePackage with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DeletePackageWithContext(ctx aws.Context, input *DeletePackageInput, opts ...request.Option) (*DeletePackageOutput, error) {
	req, out := c.DeletePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomainAutoTunes = "DescribeDomainAutoTunes"

// DescribeDomainAutoTunesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomainAutoTunes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomainAutoTunes for more information on using the DescribeDomainAutoTunes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDomainAutoTunesRequest method.
//	req, resp := client.DescribeDomainAutoTunesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DescribeDomainAutoTunesRequest(input *DescribeDomainAutoTunesInput) (req *request.Request, output *DescribeDomainAutoTunesOutput) {
	op := &request.Operation{
		Name:       opDescribeDomainAutoTunes,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}/autoTunes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDomainAutoTunesInput{}
	}

	output = &DescribeDomainAutoTunesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomainAutoTunes API operation for Amazon Elasticsearch Service.
//
// Provides scheduled Auto-Tune action details for the Elasticsearch domain,
// such as Auto-Tune action type, description, severity, and scheduled date.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeDomainAutoTunes for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) DescribeDomainAutoTunes(input *DescribeDomainAutoTunesInput) (*DescribeDomainAutoTunesOutput, error) {
	req, out := c.DescribeDomainAutoTunesRequest(input)
	return out, req.Send()
}

// DescribeDomainAutoTunesWithContext is the same as DescribeDomainAutoTunes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomainAutoTunes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeDomainAutoTunesWithContext(ctx aws.Context, input *DescribeDomainAutoTunesInput, opts ...request.Option) (*DescribeDomainAutoTunesOutput, error) {
	req, out := c.DescribeDomainAutoTunesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDomainAutoTunesPages iterates over the pages of a DescribeDomainAutoTunes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDomainAutoTunes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeDomainAutoTunes operation.
//	pageNum := 0
//	err := client.DescribeDomainAutoTunesPages(params,
//	    func(page *elasticsearchservice.DescribeDomainAutoTunesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ElasticsearchService) DescribeDomainAutoTunesPages(input *DescribeDomainAutoTunesInput, fn func(*DescribeDomainAutoTunesOutput, bool) bool) error {
	return c.DescribeDomainAutoTunesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDomainAutoTunesPagesWithContext same as DescribeDomainAutoTunesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeDomainAutoTunesPagesWithContext(ctx aws.Context, input *DescribeDomainAutoTunesInput, fn func(*DescribeDomainAutoTunesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDomainAutoTunesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDomainAutoTunesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDomainAutoTunesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDomainChangeProgress = "DescribeDomainChangeProgress"

// DescribeDomainChangeProgressRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomainChangeProgress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomainChangeProgress for more information on using the DescribeDomainChangeProgress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDomainChangeProgressRequest method.
//	req, resp := client.DescribeDomainChangeProgressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DescribeDomainChangeProgressRequest(input *DescribeDomainChangeProgressInput) (req *request.Request, output *DescribeDomainChangeProgressOutput) {
	op := &request.Operation{
		Name:       opDescribeDomainChangeProgress,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}/progress",
	}

	if input == nil {
		input = &DescribeDomainChangeProgressInput{}
	}

	output = &DescribeDomainChangeProgressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomainChangeProgress API operation for Amazon Elasticsearch Service.
//
// Returns information about the current blue/green deployment happening on
// a domain, including a change ID, status, and progress stages.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeDomainChangeProgress for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) DescribeDomainChangeProgress(input *DescribeDomainChangeProgressInput) (*DescribeDomainChangeProgressOutput, error) {
	req, out := c.DescribeDomainChangeProgressRequest(input)
	return out, req.Send()
}

// DescribeDomainChangeProgressWithContext is the same as DescribeDomainChangeProgress with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomainChangeProgress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeDomainChangeProgressWithContext(ctx aws.Context, input *DescribeDomainChangeProgressInput, opts ...request.Option) (*DescribeDomainChangeProgressOutput, error) {
	req, out := c.DescribeDomainChangeProgressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeElasticsearchDomain = "DescribeElasticsearchDomain"

// DescribeElasticsearchDomainRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticsearchDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeElasticsearchDomain for more information on using the DescribeElasticsearchDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeElasticsearchDomainRequest method.
//	req, resp := client.DescribeElasticsearchDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DescribeElasticsearchDomainRequest(input *DescribeElasticsearchDomainInput) (req *request.Request, output *DescribeElasticsearchDomainOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticsearchDomain,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}",
	}

	if input == nil {
		input = &DescribeElasticsearchDomainInput{}
	}

	output = &DescribeElasticsearchDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticsearchDomain API operation for Amazon Elasticsearch Service.
//
// Returns domain configuration information about the specified Elasticsearch
// domain, including the domain ID, domain endpoint, and domain ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeElasticsearchDomain for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) DescribeElasticsearchDomain(input *DescribeElasticsearchDomainInput) (*DescribeElasticsearchDomainOutput, error) {
	req, out := c.DescribeElasticsearchDomainRequest(input)
	return out, req.Send()
}

// DescribeElasticsearchDomainWithContext is the same as DescribeElasticsearchDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeElasticsearchDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeElasticsearchDomainWithContext(ctx aws.Context, input *DescribeElasticsearchDomainInput, opts ...request.Option) (*DescribeElasticsearchDomainOutput, error) {
	req, out := c.DescribeElasticsearchDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeElasticsearchDomainConfig = "DescribeElasticsearchDomainConfig"

// DescribeElasticsearchDomainConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticsearchDomainConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeElasticsearchDomainConfig for more information on using the DescribeElasticsearchDomainConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeElasticsearchDomainConfigRequest method.
//	req, resp := client.DescribeElasticsearchDomainConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DescribeElasticsearchDomainConfigRequest(input *DescribeElasticsearchDomainConfigInput) (req *request.Request, output *DescribeElasticsearchDomainConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticsearchDomainConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}/config",
	}

	if input == nil {
		input = &DescribeElasticsearchDomainConfigInput{}
	}

	output = &DescribeElasticsearchDomainConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticsearchDomainConfig API operation for Amazon Elasticsearch Service.
//
// Provides cluster configuration information about the specified Elasticsearch
// domain, such as the state, creation date, update version, and update date
// for cluster options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeElasticsearchDomainConfig for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) DescribeElasticsearchDomainConfig(input *DescribeElasticsearchDomainConfigInput) (*DescribeElasticsearchDomainConfigOutput, error) {
	req, out := c.DescribeElasticsearchDomainConfigRequest(input)
	return out, req.Send()
}

// DescribeElasticsearchDomainConfigWithContext is the same as DescribeElasticsearchDomainConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeElasticsearchDomainConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeElasticsearchDomainConfigWithContext(ctx aws.Context, input *DescribeElasticsearchDomainConfigInput, opts ...request.Option) (*DescribeElasticsearchDomainConfigOutput, error) {
	req, out := c.DescribeElasticsearchDomainConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeElasticsearchDomains = "DescribeElasticsearchDomains"

// DescribeElasticsearchDomainsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticsearchDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeElasticsearchDomains for more information on using the DescribeElasticsearchDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeElasticsearchDomainsRequest method.
//	req, resp := client.DescribeElasticsearchDomainsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DescribeElasticsearchDomainsRequest(input *DescribeElasticsearchDomainsInput) (req *request.Request, output *DescribeElasticsearchDomainsOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticsearchDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/domain-info",
	}

	if input == nil {
		input = &DescribeElasticsearchDomainsInput{}
	}

	output = &DescribeElasticsearchDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticsearchDomains API operation for Amazon Elasticsearch Service.
//
// Returns domain configuration information about the specified Elasticsearch
// domains, including the domain ID, domain endpoint, and domain ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeElasticsearchDomains for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) DescribeElasticsearchDomains(input *DescribeElasticsearchDomainsInput) (*DescribeElasticsearchDomainsOutput, error) {
	req, out := c.DescribeElasticsearchDomainsRequest(input)
	return out, req.Send()
}

// DescribeElasticsearchDomainsWithContext is the same as DescribeElasticsearchDomains with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeElasticsearchDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeElasticsearchDomainsWithContext(ctx aws.Context, input *DescribeElasticsearchDomainsInput, opts ...request.Option) (*DescribeElasticsearchDomainsOutput, error) {
	req, out := c.DescribeElasticsearchDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeElasticsearchInstanceTypeLimits = "DescribeElasticsearchInstanceTypeLimits"

// DescribeElasticsearchInstanceTypeLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticsearchInstanceTypeLimits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeElasticsearchInstanceTypeLimits for more information on using the DescribeElasticsearchInstanceTypeLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeElasticsearchInstanceTypeLimitsRequest method.
//	req, resp := client.DescribeElasticsearchInstanceTypeLimitsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DescribeElasticsearchInstanceTypeLimitsRequest(input *DescribeElasticsearchInstanceTypeLimitsInput) (req *request.Request, output *DescribeElasticsearchInstanceTypeLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticsearchInstanceTypeLimits,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/instanceTypeLimits/{ElasticsearchVersion}/{InstanceType}",
	}

	if input == nil {
		input = &DescribeElasticsearchInstanceTypeLimitsInput{}
	}

	output = &DescribeElasticsearchInstanceTypeLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticsearchInstanceTypeLimits API operation for Amazon Elasticsearch Service.
//
// Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion.
// When modifying existing Domain, specify the DomainName to know what Limits
// are supported for modifying.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeElasticsearchInstanceTypeLimits for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - InvalidTypeException
//     An exception for trying to create or access sub-resource that is either invalid
//     or not supported. Gives http status code of 409.
//
//   - LimitExceededException
//     An exception for trying to create more than allowed resources or sub-resources.
//     Gives http status code of 409.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) DescribeElasticsearchInstanceTypeLimits(input *DescribeElasticsearchInstanceTypeLimitsInput) (*DescribeElasticsearchInstanceTypeLimitsOutput, error) {
	req, out := c.DescribeElasticsearchInstanceTypeLimitsRequest(input)
	return out, req.Send()
}

// DescribeElasticsearchInstanceTypeLimitsWithContext is the same as DescribeElasticsearchInstanceTypeLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeElasticsearchInstanceTypeLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeElasticsearchInstanceTypeLimitsWithContext(ctx aws.Context, input *DescribeElasticsearchInstanceTypeLimitsInput, opts ...request.Option) (*DescribeElasticsearchInstanceTypeLimitsOutput, error) {
	req, out := c.DescribeElasticsearchInstanceTypeLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInboundCrossClusterSearchConnections = "DescribeInboundCrossClusterSearchConnections"

// DescribeInboundCrossClusterSearchConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInboundCrossClusterSearchConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInboundCrossClusterSearchConnections for more information on using the DescribeInboundCrossClusterSearchConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInboundCrossClusterSearchConnectionsRequest method.
//	req, resp := client.DescribeInboundCrossClusterSearchConnectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DescribeInboundCrossClusterSearchConnectionsRequest(input *DescribeInboundCrossClusterSearchConnectionsInput) (req *request.Request, output *DescribeInboundCrossClusterSearchConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeInboundCrossClusterSearchConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/ccs/inboundConnection/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInboundCrossClusterSearchConnectionsInput{}
	}

	output = &DescribeInboundCrossClusterSearchConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInboundCrossClusterSearchConnections API operation for Amazon Elasticsearch Service.
//
// Lists all the inbound cross-cluster search connections for a destination
// domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeInboundCrossClusterSearchConnections for usage and error information.
//
// Returned Error Types:
//
//   - InvalidPaginationTokenException
//     The request processing has failed because of invalid pagination token provided
//     by customer. Returns an HTTP status code of 400.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access a not supported operation.
//     Gives http status code of 409.
func (c *ElasticsearchService) DescribeInboundCrossClusterSearchConnections(input *DescribeInboundCrossClusterSearchConnectionsInput) (*DescribeInboundCrossClusterSearchConnectionsOutput, error) {
	req, out := c.DescribeInboundCrossClusterSearchConnectionsRequest(input)
	return out, req.Send()
}

// DescribeInboundCrossClusterSearchConnectionsWithContext is the same as DescribeInboundCrossClusterSearchConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInboundCrossClusterSearchConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeInboundCrossClusterSearchConnectionsWithContext(ctx aws.Context, input *DescribeInboundCrossClusterSearchConnectionsInput, opts ...request.Option) (*DescribeInboundCrossClusterSearchConnectionsOutput, error) {
	req, out := c.DescribeInboundCrossClusterSearchConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInboundCrossClusterSearchConnectionsPages iterates over the pages of a DescribeInboundCrossClusterSearchConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInboundCrossClusterSearchConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeInboundCrossClusterSearchConnections operation.
//	pageNum := 0
//	err := client.DescribeInboundCrossClusterSearchConnectionsPages(params,
//	    func(page *elasticsearchservice.DescribeInboundCrossClusterSearchConnectionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ElasticsearchService) DescribeInboundCrossClusterSearchConnectionsPages(input *DescribeInboundCrossClusterSearchConnectionsInput, fn func(*DescribeInboundCrossClusterSearchConnectionsOutput, bool) bool) error {
	return c.DescribeInboundCrossClusterSearchConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInboundCrossClusterSearchConnectionsPagesWithContext same as DescribeInboundCrossClusterSearchConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeInboundCrossClusterSearchConnectionsPagesWithContext(ctx aws.Context, input *DescribeInboundCrossClusterSearchConnectionsInput, fn func(*DescribeInboundCrossClusterSearchConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInboundCrossClusterSearchConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInboundCrossClusterSearchConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInboundCrossClusterSearchConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeOutboundCrossClusterSearchConnections = "DescribeOutboundCrossClusterSearchConnections"

// DescribeOutboundCrossClusterSearchConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOutboundCrossClusterSearchConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOutboundCrossClusterSearchConnections for more information on using the DescribeOutboundCrossClusterSearchConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeOutboundCrossClusterSearchConnectionsRequest method.
//	req, resp := client.DescribeOutboundCrossClusterSearchConnectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DescribeOutboundCrossClusterSearchConnectionsRequest(input *DescribeOutboundCrossClusterSearchConnectionsInput) (req *request.Request, output *DescribeOutboundCrossClusterSearchConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeOutboundCrossClusterSearchConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/ccs/outboundConnection/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOutboundCrossClusterSearchConnectionsInput{}
	}

	output = &DescribeOutboundCrossClusterSearchConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOutboundCrossClusterSearchConnections API operation for Amazon Elasticsearch Service.
//
// Lists all the outbound cross-cluster search connections for a source domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeOutboundCrossClusterSearchConnections for usage and error information.
//
// Returned Error Types:
//
//   - InvalidPaginationTokenException
//     The request processing has failed because of invalid pagination token provided
//     by customer. Returns an HTTP status code of 400.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access a not supported operation.
//     Gives http status code of 409.
func (c *ElasticsearchService) DescribeOutboundCrossClusterSearchConnections(input *DescribeOutboundCrossClusterSearchConnectionsInput) (*DescribeOutboundCrossClusterSearchConnectionsOutput, error) {
	req, out := c.DescribeOutboundCrossClusterSearchConnectionsRequest(input)
	return out, req.Send()
}

// DescribeOutboundCrossClusterSearchConnectionsWithContext is the same as DescribeOutboundCrossClusterSearchConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOutboundCrossClusterSearchConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeOutboundCrossClusterSearchConnectionsWithContext(ctx aws.Context, input *DescribeOutboundCrossClusterSearchConnectionsInput, opts ...request.Option) (*DescribeOutboundCrossClusterSearchConnectionsOutput, error) {
	req, out := c.DescribeOutboundCrossClusterSearchConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOutboundCrossClusterSearchConnectionsPages iterates over the pages of a DescribeOutboundCrossClusterSearchConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOutboundCrossClusterSearchConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeOutboundCrossClusterSearchConnections operation.
//	pageNum := 0
//	err := client.DescribeOutboundCrossClusterSearchConnectionsPages(params,
//	    func(page *elasticsearchservice.DescribeOutboundCrossClusterSearchConnectionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ElasticsearchService) DescribeOutboundCrossClusterSearchConnectionsPages(input *DescribeOutboundCrossClusterSearchConnectionsInput, fn func(*DescribeOutboundCrossClusterSearchConnectionsOutput, bool) bool) error {
	return c.DescribeOutboundCrossClusterSearchConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOutboundCrossClusterSearchConnectionsPagesWithContext same as DescribeOutboundCrossClusterSearchConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeOutboundCrossClusterSearchConnectionsPagesWithContext(ctx aws.Context, input *DescribeOutboundCrossClusterSearchConnectionsInput, fn func(*DescribeOutboundCrossClusterSearchConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOutboundCrossClusterSearchConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOutboundCrossClusterSearchConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOutboundCrossClusterSearchConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePackages = "DescribePackages"

// DescribePackagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribePackages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePackages for more information on using the DescribePackages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePackagesRequest method.
//	req, resp := client.DescribePackagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DescribePackagesRequest(input *DescribePackagesInput) (req *request.Request, output *DescribePackagesOutput) {
	op := &request.Operation{
		Name:       opDescribePackages,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/packages/describe",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePackagesInput{}
	}

	output = &DescribePackagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePackages API operation for Amazon Elasticsearch Service.
//
// Describes all packages available to Amazon ES. Includes options for filtering,
// limiting the number of results, and pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribePackages for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - AccessDeniedException
//     An error occurred because user does not have permissions to access the resource.
//     Returns HTTP status code 403.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) DescribePackages(input *DescribePackagesInput) (*DescribePackagesOutput, error) {
	req, out := c.DescribePackagesRequest(input)
	return out, req.Send()
}

// DescribePackagesWithContext is the same as DescribePackages with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePackages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribePackagesWithContext(ctx aws.Context, input *DescribePackagesInput, opts ...request.Option) (*DescribePackagesOutput, error) {
	req, out := c.DescribePackagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePackagesPages iterates over the pages of a DescribePackages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePackages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribePackages operation.
//	pageNum := 0
//	err := client.DescribePackagesPages(params,
//	    func(page *elasticsearchservice.DescribePackagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ElasticsearchService) DescribePackagesPages(input *DescribePackagesInput, fn func(*DescribePackagesOutput, bool) bool) error {
	return c.DescribePackagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePackagesPagesWithContext same as DescribePackagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribePackagesPagesWithContext(ctx aws.Context, input *DescribePackagesInput, fn func(*DescribePackagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePackagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePackagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePackagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReservedElasticsearchInstanceOfferings = "DescribeReservedElasticsearchInstanceOfferings"

// DescribeReservedElasticsearchInstanceOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedElasticsearchInstanceOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedElasticsearchInstanceOfferings for more information on using the DescribeReservedElasticsearchInstanceOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReservedElasticsearchInstanceOfferingsRequest method.
//	req, resp := client.DescribeReservedElasticsearchInstanceOfferingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DescribeReservedElasticsearchInstanceOfferingsRequest(input *DescribeReservedElasticsearchInstanceOfferingsInput) (req *request.Request, output *DescribeReservedElasticsearchInstanceOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedElasticsearchInstanceOfferings,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/reservedInstanceOfferings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedElasticsearchInstanceOfferingsInput{}
	}

	output = &DescribeReservedElasticsearchInstanceOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedElasticsearchInstanceOfferings API operation for Amazon Elasticsearch Service.
//
// Lists available reserved Elasticsearch instance offerings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeReservedElasticsearchInstanceOfferings for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access a not supported operation.
//     Gives http status code of 409.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
func (c *ElasticsearchService) DescribeReservedElasticsearchInstanceOfferings(input *DescribeReservedElasticsearchInstanceOfferingsInput) (*DescribeReservedElasticsearchInstanceOfferingsOutput, error) {
	req, out := c.DescribeReservedElasticsearchInstanceOfferingsRequest(input)
	return out, req.Send()
}

// DescribeReservedElasticsearchInstanceOfferingsWithContext is the same as DescribeReservedElasticsearchInstanceOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedElasticsearchInstanceOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeReservedElasticsearchInstanceOfferingsWithContext(ctx aws.Context, input *DescribeReservedElasticsearchInstanceOfferingsInput, opts ...request.Option) (*DescribeReservedElasticsearchInstanceOfferingsOutput, error) {
	req, out := c.DescribeReservedElasticsearchInstanceOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedElasticsearchInstanceOfferingsPages iterates over the pages of a DescribeReservedElasticsearchInstanceOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedElasticsearchInstanceOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeReservedElasticsearchInstanceOfferings operation.
//	pageNum := 0
//	err := client.DescribeReservedElasticsearchInstanceOfferingsPages(params,
//	    func(page *elasticsearchservice.DescribeReservedElasticsearchInstanceOfferingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ElasticsearchService) DescribeReservedElasticsearchInstanceOfferingsPages(input *DescribeReservedElasticsearchInstanceOfferingsInput, fn func(*DescribeReservedElasticsearchInstanceOfferingsOutput, bool) bool) error {
	return c.DescribeReservedElasticsearchInstanceOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedElasticsearchInstanceOfferingsPagesWithContext same as DescribeReservedElasticsearchInstanceOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeReservedElasticsearchInstanceOfferingsPagesWithContext(ctx aws.Context, input *DescribeReservedElasticsearchInstanceOfferingsInput, fn func(*DescribeReservedElasticsearchInstanceOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedElasticsearchInstanceOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedElasticsearchInstanceOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReservedElasticsearchInstanceOfferingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReservedElasticsearchInstances = "DescribeReservedElasticsearchInstances"

// DescribeReservedElasticsearchInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedElasticsearchInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedElasticsearchInstances for more information on using the DescribeReservedElasticsearchInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReservedElasticsearchInstancesRequest method.
//	req, resp := client.DescribeReservedElasticsearchInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DescribeReservedElasticsearchInstancesRequest(input *DescribeReservedElasticsearchInstancesInput) (req *request.Request, output *DescribeReservedElasticsearchInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedElasticsearchInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/reservedInstances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedElasticsearchInstancesInput{}
	}

	output = &DescribeReservedElasticsearchInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedElasticsearchInstances API operation for Amazon Elasticsearch Service.
//
// Returns information about reserved Elasticsearch instances for this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeReservedElasticsearchInstances for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access a not supported operation.
//     Gives http status code of 409.
func (c *ElasticsearchService) DescribeReservedElasticsearchInstances(input *DescribeReservedElasticsearchInstancesInput) (*DescribeReservedElasticsearchInstancesOutput, error) {
	req, out := c.DescribeReservedElasticsearchInstancesRequest(input)
	return out, req.Send()
}

// DescribeReservedElasticsearchInstancesWithContext is the same as DescribeReservedElasticsearchInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedElasticsearchInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeReservedElasticsearchInstancesWithContext(ctx aws.Context, input *DescribeReservedElasticsearchInstancesInput, opts ...request.Option) (*DescribeReservedElasticsearchInstancesOutput, error) {
	req, out := c.DescribeReservedElasticsearchInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedElasticsearchInstancesPages iterates over the pages of a DescribeReservedElasticsearchInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedElasticsearchInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeReservedElasticsearchInstances operation.
//	pageNum := 0
//	err := client.DescribeReservedElasticsearchInstancesPages(params,
//	    func(page *elasticsearchservice.DescribeReservedElasticsearchInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ElasticsearchService) DescribeReservedElasticsearchInstancesPages(input *DescribeReservedElasticsearchInstancesInput, fn func(*DescribeReservedElasticsearchInstancesOutput, bool) bool) error {
	return c.DescribeReservedElasticsearchInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedElasticsearchInstancesPagesWithContext same as DescribeReservedElasticsearchInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeReservedElasticsearchInstancesPagesWithContext(ctx aws.Context, input *DescribeReservedElasticsearchInstancesInput, fn func(*DescribeReservedElasticsearchInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedElasticsearchInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedElasticsearchInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReservedElasticsearchInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDissociatePackage = "DissociatePackage"

// DissociatePackageRequest generates a "aws/request.Request" representing the
// client's request for the DissociatePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DissociatePackage for more information on using the DissociatePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DissociatePackageRequest method.
//	req, resp := client.DissociatePackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) DissociatePackageRequest(input *DissociatePackageInput) (req *request.Request, output *DissociatePackageOutput) {
	op := &request.Operation{
		Name:       opDissociatePackage,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/packages/dissociate/{PackageID}/{DomainName}",
	}

	if input == nil {
		input = &DissociatePackageInput{}
	}

	output = &DissociatePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DissociatePackage API operation for Amazon Elasticsearch Service.
//
// Dissociates a package from the Amazon ES domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DissociatePackage for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - AccessDeniedException
//     An error occurred because user does not have permissions to access the resource.
//     Returns HTTP status code 403.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
//
//   - ConflictException
//     An error occurred because the client attempts to remove a resource that is
//     currently in use. Returns HTTP status code 409.
func (c *ElasticsearchService) DissociatePackage(input *DissociatePackageInput) (*DissociatePackageOutput, error) {
	req, out := c.DissociatePackageRequest(input)
	return out, req.Send()
}

// DissociatePackageWithContext is the same as DissociatePackage with the addition of
// the ability to pass a context and additional request options.
//
// See DissociatePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DissociatePackageWithContext(ctx aws.Context, input *DissociatePackageInput, opts ...request.Option) (*DissociatePackageOutput, error) {
	req, out := c.DissociatePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCompatibleElasticsearchVersions = "GetCompatibleElasticsearchVersions"

// GetCompatibleElasticsearchVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetCompatibleElasticsearchVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCompatibleElasticsearchVersions for more information on using the GetCompatibleElasticsearchVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCompatibleElasticsearchVersionsRequest method.
//	req, resp := client.GetCompatibleElasticsearchVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) GetCompatibleElasticsearchVersionsRequest(input *GetCompatibleElasticsearchVersionsInput) (req *request.Request, output *GetCompatibleElasticsearchVersionsOutput) {
	op := &request.Operation{
		Name:       opGetCompatibleElasticsearchVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/compatibleVersions",
	}

	if input == nil {
		input = &GetCompatibleElasticsearchVersionsInput{}
	}

	output = &GetCompatibleElasticsearchVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCompatibleElasticsearchVersions API operation for Amazon Elasticsearch Service.
//
// Returns a list of upgrade compatible Elastisearch versions. You can optionally
// pass a DomainName to get all upgrade compatible Elasticsearch versions for
// that specific domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation GetCompatibleElasticsearchVersions for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access a not supported operation.
//     Gives http status code of 409.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
func (c *ElasticsearchService) GetCompatibleElasticsearchVersions(input *GetCompatibleElasticsearchVersionsInput) (*GetCompatibleElasticsearchVersionsOutput, error) {
	req, out := c.GetCompatibleElasticsearchVersionsRequest(input)
	return out, req.Send()
}

// GetCompatibleElasticsearchVersionsWithContext is the same as GetCompatibleElasticsearchVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetCompatibleElasticsearchVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) GetCompatibleElasticsearchVersionsWithContext(ctx aws.Context, input *GetCompatibleElasticsearchVersionsInput, opts ...request.Option) (*GetCompatibleElasticsearchVersionsOutput, error) {
	req, out := c.GetCompatibleElasticsearchVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPackageVersionHistory = "GetPackageVersionHistory"

// GetPackageVersionHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetPackageVersionHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPackageVersionHistory for more information on using the GetPackageVersionHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPackageVersionHistoryRequest method.
//	req, resp := client.GetPackageVersionHistoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) GetPackageVersionHistoryRequest(input *GetPackageVersionHistoryInput) (req *request.Request, output *GetPackageVersionHistoryOutput) {
	op := &request.Operation{
		Name:       opGetPackageVersionHistory,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/packages/{PackageID}/history",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetPackageVersionHistoryInput{}
	}

	output = &GetPackageVersionHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPackageVersionHistory API operation for Amazon Elasticsearch Service.
//
// Returns a list of versions of the package, along with their creation time
// and commit message.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation GetPackageVersionHistory for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - AccessDeniedException
//     An error occurred because user does not have permissions to access the resource.
//     Returns HTTP status code 403.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) GetPackageVersionHistory(input *GetPackageVersionHistoryInput) (*GetPackageVersionHistoryOutput, error) {
	req, out := c.GetPackageVersionHistoryRequest(input)
	return out, req.Send()
}

// GetPackageVersionHistoryWithContext is the same as GetPackageVersionHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetPackageVersionHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) GetPackageVersionHistoryWithContext(ctx aws.Context, input *GetPackageVersionHistoryInput, opts ...request.Option) (*GetPackageVersionHistoryOutput, error) {
	req, out := c.GetPackageVersionHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetPackageVersionHistoryPages iterates over the pages of a GetPackageVersionHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetPackageVersionHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetPackageVersionHistory operation.
//	pageNum := 0
//	err := client.GetPackageVersionHistoryPages(params,
//	    func(page *elasticsearchservice.GetPackageVersionHistoryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ElasticsearchService) GetPackageVersionHistoryPages(input *GetPackageVersionHistoryInput, fn func(*GetPackageVersionHistoryOutput, bool) bool) error {
	return c.GetPackageVersionHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetPackageVersionHistoryPagesWithContext same as GetPackageVersionHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) GetPackageVersionHistoryPagesWithContext(ctx aws.Context, input *GetPackageVersionHistoryInput, fn func(*GetPackageVersionHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetPackageVersionHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetPackageVersionHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetPackageVersionHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetUpgradeHistory = "GetUpgradeHistory"

// GetUpgradeHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetUpgradeHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUpgradeHistory for more information on using the GetUpgradeHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetUpgradeHistoryRequest method.
//	req, resp := client.GetUpgradeHistoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) GetUpgradeHistoryRequest(input *GetUpgradeHistoryInput) (req *request.Request, output *GetUpgradeHistoryOutput) {
	op := &request.Operation{
		Name:       opGetUpgradeHistory,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/upgradeDomain/{DomainName}/history",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetUpgradeHistoryInput{}
	}

	output = &GetUpgradeHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUpgradeHistory API operation for Amazon Elasticsearch Service.
//
// Retrieves the complete history of the last 10 upgrades that were performed
// on the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation GetUpgradeHistory for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access a not supported operation.
//     Gives http status code of 409.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
func (c *ElasticsearchService) GetUpgradeHistory(input *GetUpgradeHistoryInput) (*GetUpgradeHistoryOutput, error) {
	req, out := c.GetUpgradeHistoryRequest(input)
	return out, req.Send()
}

// GetUpgradeHistoryWithContext is the same as GetUpgradeHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetUpgradeHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) GetUpgradeHistoryWithContext(ctx aws.Context, input *GetUpgradeHistoryInput, opts ...request.Option) (*GetUpgradeHistoryOutput, error) {
	req, out := c.GetUpgradeHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetUpgradeHistoryPages iterates over the pages of a GetUpgradeHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetUpgradeHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetUpgradeHistory operation.
//	pageNum := 0
//	err := client.GetUpgradeHistoryPages(params,
//	    func(page *elasticsearchservice.GetUpgradeHistoryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ElasticsearchService) GetUpgradeHistoryPages(input *GetUpgradeHistoryInput, fn func(*GetUpgradeHistoryOutput, bool) bool) error {
	return c.GetUpgradeHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetUpgradeHistoryPagesWithContext same as GetUpgradeHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) GetUpgradeHistoryPagesWithContext(ctx aws.Context, input *GetUpgradeHistoryInput, fn func(*GetUpgradeHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetUpgradeHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetUpgradeHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetUpgradeHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetUpgradeStatus = "GetUpgradeStatus"

// GetUpgradeStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetUpgradeStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUpgradeStatus for more information on using the GetUpgradeStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetUpgradeStatusRequest method.
//	req, resp := client.GetUpgradeStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) GetUpgradeStatusRequest(input *GetUpgradeStatusInput) (req *request.Request, output *GetUpgradeStatusOutput) {
	op := &request.Operation{
		Name:       opGetUpgradeStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/upgradeDomain/{DomainName}/status",
	}

	if input == nil {
		input = &GetUpgradeStatusInput{}
	}

	output = &GetUpgradeStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUpgradeStatus API operation for Amazon Elasticsearch Service.
//
// Retrieves the latest status of the last upgrade or upgrade eligibility check
// that was performed on the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation GetUpgradeStatus for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access a not supported operation.
//     Gives http status code of 409.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
func (c *ElasticsearchService) GetUpgradeStatus(input *GetUpgradeStatusInput) (*GetUpgradeStatusOutput, error) {
	req, out := c.GetUpgradeStatusRequest(input)
	return out, req.Send()
}

// GetUpgradeStatusWithContext is the same as GetUpgradeStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetUpgradeStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) GetUpgradeStatusWithContext(ctx aws.Context, input *GetUpgradeStatusInput, opts ...request.Option) (*GetUpgradeStatusOutput, error) {
	req, out := c.GetUpgradeStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomainNames = "ListDomainNames"

// ListDomainNamesRequest generates a "aws/request.Request" representing the
// client's request for the ListDomainNames operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomainNames for more information on using the ListDomainNames
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDomainNamesRequest method.
//	req, resp := client.ListDomainNamesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) ListDomainNamesRequest(input *ListDomainNamesInput) (req *request.Request, output *ListDomainNamesOutput) {
	op := &request.Operation{
		Name:       opListDomainNames,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/domain",
	}

	if input == nil {
		input = &ListDomainNamesInput{}
	}

	output = &ListDomainNamesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomainNames API operation for Amazon Elasticsearch Service.
//
// Returns the name of all Elasticsearch domains owned by the current user's
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation ListDomainNames for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) ListDomainNames(input *ListDomainNamesInput) (*ListDomainNamesOutput, error) {
	req, out := c.ListDomainNamesRequest(input)
	return out, req.Send()
}

// ListDomainNamesWithContext is the same as ListDomainNames with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainNames for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListDomainNamesWithContext(ctx aws.Context, input *ListDomainNamesInput, opts ...request.Option) (*ListDomainNamesOutput, error) {
	req, out := c.ListDomainNamesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomainsForPackage = "ListDomainsForPackage"

// ListDomainsForPackageRequest generates a "aws/request.Request" representing the
// client's request for the ListDomainsForPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomainsForPackage for more information on using the ListDomainsForPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDomainsForPackageRequest method.
//	req, resp := client.ListDomainsForPackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) ListDomainsForPackageRequest(input *ListDomainsForPackageInput) (req *request.Request, output *ListDomainsForPackageOutput) {
	op := &request.Operation{
		Name:       opListDomainsForPackage,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/packages/{PackageID}/domains",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsForPackageInput{}
	}

	output = &ListDomainsForPackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomainsForPackage API operation for Amazon Elasticsearch Service.
//
// Lists all Amazon ES domains associated with the package.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation ListDomainsForPackage for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - AccessDeniedException
//     An error occurred because user does not have permissions to access the resource.
//     Returns HTTP status code 403.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) ListDomainsForPackage(input *ListDomainsForPackageInput) (*ListDomainsForPackageOutput, error) {
	req, out := c.ListDomainsForPackageRequest(input)
	return out, req.Send()
}

// ListDomainsForPackageWithContext is the same as ListDomainsForPackage with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainsForPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListDomainsForPackageWithContext(ctx aws.Context, input *ListDomainsForPackageInput, opts ...request.Option) (*ListDomainsForPackageOutput, error) {
	req, out := c.ListDomainsForPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDomainsForPackagePages iterates over the pages of a ListDomainsForPackage operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomainsForPackage method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDomainsForPackage operation.
//	pageNum := 0
//	err := client.ListDomainsForPackagePages(params,
//	    func(page *elasticsearchservice.ListDomainsForPackageOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ElasticsearchService) ListDomainsForPackagePages(input *ListDomainsForPackageInput, fn func(*ListDomainsForPackageOutput, bool) bool) error {
	return c.ListDomainsForPackagePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDomainsForPackagePagesWithContext same as ListDomainsForPackagePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListDomainsForPackagePagesWithContext(ctx aws.Context, input *ListDomainsForPackageInput, fn func(*ListDomainsForPackageOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDomainsForPackageInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDomainsForPackageRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDomainsForPackageOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListElasticsearchInstanceTypes = "ListElasticsearchInstanceTypes"

// ListElasticsearchInstanceTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListElasticsearchInstanceTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListElasticsearchInstanceTypes for more information on using the ListElasticsearchInstanceTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListElasticsearchInstanceTypesRequest method.
//	req, resp := client.ListElasticsearchInstanceTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) ListElasticsearchInstanceTypesRequest(input *ListElasticsearchInstanceTypesInput) (req *request.Request, output *ListElasticsearchInstanceTypesOutput) {
	op := &request.Operation{
		Name:       opListElasticsearchInstanceTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/instanceTypes/{ElasticsearchVersion}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListElasticsearchInstanceTypesInput{}
	}

	output = &ListElasticsearchInstanceTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListElasticsearchInstanceTypes API operation for Amazon Elasticsearch Service.
//
// # List all Elasticsearch instance types that are supported for given ElasticsearchVersion
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation ListElasticsearchInstanceTypes for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) ListElasticsearchInstanceTypes(input *ListElasticsearchInstanceTypesInput) (*ListElasticsearchInstanceTypesOutput, error) {
	req, out := c.ListElasticsearchInstanceTypesRequest(input)
	return out, req.Send()
}

// ListElasticsearchInstanceTypesWithContext is the same as ListElasticsearchInstanceTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListElasticsearchInstanceTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListElasticsearchInstanceTypesWithContext(ctx aws.Context, input *ListElasticsearchInstanceTypesInput, opts ...request.Option) (*ListElasticsearchInstanceTypesOutput, error) {
	req, out := c.ListElasticsearchInstanceTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListElasticsearchInstanceTypesPages iterates over the pages of a ListElasticsearchInstanceTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListElasticsearchInstanceTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListElasticsearchInstanceTypes operation.
//	pageNum := 0
//	err := client.ListElasticsearchInstanceTypesPages(params,
//	    func(page *elasticsearchservice.ListElasticsearchInstanceTypesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ElasticsearchService) ListElasticsearchInstanceTypesPages(input *ListElasticsearchInstanceTypesInput, fn func(*ListElasticsearchInstanceTypesOutput, bool) bool) error {
	return c.ListElasticsearchInstanceTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListElasticsearchInstanceTypesPagesWithContext same as ListElasticsearchInstanceTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListElasticsearchInstanceTypesPagesWithContext(ctx aws.Context, input *ListElasticsearchInstanceTypesInput, fn func(*ListElasticsearchInstanceTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListElasticsearchInstanceTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListElasticsearchInstanceTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListElasticsearchInstanceTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListElasticsearchVersions = "ListElasticsearchVersions"

// ListElasticsearchVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListElasticsearchVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListElasticsearchVersions for more information on using the ListElasticsearchVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListElasticsearchVersionsRequest method.
//	req, resp := client.ListElasticsearchVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) ListElasticsearchVersionsRequest(input *ListElasticsearchVersionsInput) (req *request.Request, output *ListElasticsearchVersionsOutput) {
	op := &request.Operation{
		Name:       opListElasticsearchVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListElasticsearchVersionsInput{}
	}

	output = &ListElasticsearchVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListElasticsearchVersions API operation for Amazon Elasticsearch Service.
//
// # List all supported Elasticsearch versions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation ListElasticsearchVersions for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) ListElasticsearchVersions(input *ListElasticsearchVersionsInput) (*ListElasticsearchVersionsOutput, error) {
	req, out := c.ListElasticsearchVersionsRequest(input)
	return out, req.Send()
}

// ListElasticsearchVersionsWithContext is the same as ListElasticsearchVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListElasticsearchVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListElasticsearchVersionsWithContext(ctx aws.Context, input *ListElasticsearchVersionsInput, opts ...request.Option) (*ListElasticsearchVersionsOutput, error) {
	req, out := c.ListElasticsearchVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListElasticsearchVersionsPages iterates over the pages of a ListElasticsearchVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListElasticsearchVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListElasticsearchVersions operation.
//	pageNum := 0
//	err := client.ListElasticsearchVersionsPages(params,
//	    func(page *elasticsearchservice.ListElasticsearchVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ElasticsearchService) ListElasticsearchVersionsPages(input *ListElasticsearchVersionsInput, fn func(*ListElasticsearchVersionsOutput, bool) bool) error {
	return c.ListElasticsearchVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListElasticsearchVersionsPagesWithContext same as ListElasticsearchVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListElasticsearchVersionsPagesWithContext(ctx aws.Context, input *ListElasticsearchVersionsInput, fn func(*ListElasticsearchVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListElasticsearchVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListElasticsearchVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListElasticsearchVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPackagesForDomain = "ListPackagesForDomain"

// ListPackagesForDomainRequest generates a "aws/request.Request" representing the
// client's request for the ListPackagesForDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPackagesForDomain for more information on using the ListPackagesForDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPackagesForDomainRequest method.
//	req, resp := client.ListPackagesForDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) ListPackagesForDomainRequest(input *ListPackagesForDomainInput) (req *request.Request, output *ListPackagesForDomainOutput) {
	op := &request.Operation{
		Name:       opListPackagesForDomain,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/domain/{DomainName}/packages",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPackagesForDomainInput{}
	}

	output = &ListPackagesForDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPackagesForDomain API operation for Amazon Elasticsearch Service.
//
// Lists all packages associated with the Amazon ES domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation ListPackagesForDomain for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - AccessDeniedException
//     An error occurred because user does not have permissions to access the resource.
//     Returns HTTP status code 403.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) ListPackagesForDomain(input *ListPackagesForDomainInput) (*ListPackagesForDomainOutput, error) {
	req, out := c.ListPackagesForDomainRequest(input)
	return out, req.Send()
}

// ListPackagesForDomainWithContext is the same as ListPackagesForDomain with the addition of
// the ability to pass a context and additional request options.
//
// See ListPackagesForDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListPackagesForDomainWithContext(ctx aws.Context, input *ListPackagesForDomainInput, opts ...request.Option) (*ListPackagesForDomainOutput, error) {
	req, out := c.ListPackagesForDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPackagesForDomainPages iterates over the pages of a ListPackagesForDomain operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPackagesForDomain method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPackagesForDomain operation.
//	pageNum := 0
//	err := client.ListPackagesForDomainPages(params,
//	    func(page *elasticsearchservice.ListPackagesForDomainOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ElasticsearchService) ListPackagesForDomainPages(input *ListPackagesForDomainInput, fn func(*ListPackagesForDomainOutput, bool) bool) error {
	return c.ListPackagesForDomainPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPackagesForDomainPagesWithContext same as ListPackagesForDomainPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListPackagesForDomainPagesWithContext(ctx aws.Context, input *ListPackagesForDomainInput, fn func(*ListPackagesForDomainOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPackagesForDomainInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPackagesForDomainRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPackagesForDomainOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsRequest method.
//	req, resp := client.ListTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/tags/",
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for Amazon Elasticsearch Service.
//
// Returns all tags for the given Elasticsearch domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation ListTags for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
func (c *ElasticsearchService) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPurchaseReservedElasticsearchInstanceOffering = "PurchaseReservedElasticsearchInstanceOffering"

// PurchaseReservedElasticsearchInstanceOfferingRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseReservedElasticsearchInstanceOffering operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PurchaseReservedElasticsearchInstanceOffering for more information on using the PurchaseReservedElasticsearchInstanceOffering
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PurchaseReservedElasticsearchInstanceOfferingRequest method.
//	req, resp := client.PurchaseReservedElasticsearchInstanceOfferingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) PurchaseReservedElasticsearchInstanceOfferingRequest(input *PurchaseReservedElasticsearchInstanceOfferingInput) (req *request.Request, output *PurchaseReservedElasticsearchInstanceOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseReservedElasticsearchInstanceOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/purchaseReservedInstanceOffering",
	}

	if input == nil {
		input = &PurchaseReservedElasticsearchInstanceOfferingInput{}
	}

	output = &PurchaseReservedElasticsearchInstanceOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseReservedElasticsearchInstanceOffering API operation for Amazon Elasticsearch Service.
//
// Allows you to purchase reserved Elasticsearch instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation PurchaseReservedElasticsearchInstanceOffering for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - ResourceAlreadyExistsException
//     An exception for creating a resource that already exists. Gives http status
//     code of 400.
//
//   - LimitExceededException
//     An exception for trying to create more than allowed resources or sub-resources.
//     Gives http status code of 409.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access a not supported operation.
//     Gives http status code of 409.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
func (c *ElasticsearchService) PurchaseReservedElasticsearchInstanceOffering(input *PurchaseReservedElasticsearchInstanceOfferingInput) (*PurchaseReservedElasticsearchInstanceOfferingOutput, error) {
	req, out := c.PurchaseReservedElasticsearchInstanceOfferingRequest(input)
	return out, req.Send()
}

// PurchaseReservedElasticsearchInstanceOfferingWithContext is the same as PurchaseReservedElasticsearchInstanceOffering with the addition of
// the ability to pass a context and additional request options.
//
// See PurchaseReservedElasticsearchInstanceOffering for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) PurchaseReservedElasticsearchInstanceOfferingWithContext(ctx aws.Context, input *PurchaseReservedElasticsearchInstanceOfferingInput, opts ...request.Option) (*PurchaseReservedElasticsearchInstanceOfferingOutput, error) {
	req, out := c.PurchaseReservedElasticsearchInstanceOfferingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectInboundCrossClusterSearchConnection = "RejectInboundCrossClusterSearchConnection"

// RejectInboundCrossClusterSearchConnectionRequest generates a "aws/request.Request" representing the
// client's request for the RejectInboundCrossClusterSearchConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectInboundCrossClusterSearchConnection for more information on using the RejectInboundCrossClusterSearchConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RejectInboundCrossClusterSearchConnectionRequest method.
//	req, resp := client.RejectInboundCrossClusterSearchConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) RejectInboundCrossClusterSearchConnectionRequest(input *RejectInboundCrossClusterSearchConnectionInput) (req *request.Request, output *RejectInboundCrossClusterSearchConnectionOutput) {
	op := &request.Operation{
		Name:       opRejectInboundCrossClusterSearchConnection,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-01-01/es/ccs/inboundConnection/{ConnectionId}/reject",
	}

	if input == nil {
		input = &RejectInboundCrossClusterSearchConnectionInput{}
	}

	output = &RejectInboundCrossClusterSearchConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RejectInboundCrossClusterSearchConnection API operation for Amazon Elasticsearch Service.
//
// Allows the destination domain owner to reject an inbound cross-cluster search
// connection request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation RejectInboundCrossClusterSearchConnection for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access a not supported operation.
//     Gives http status code of 409.
func (c *ElasticsearchService) RejectInboundCrossClusterSearchConnection(input *RejectInboundCrossClusterSearchConnectionInput) (*RejectInboundCrossClusterSearchConnectionOutput, error) {
	req, out := c.RejectInboundCrossClusterSearchConnectionRequest(input)
	return out, req.Send()
}

// RejectInboundCrossClusterSearchConnectionWithContext is the same as RejectInboundCrossClusterSearchConnection with the addition of
// the ability to pass a context and additional request options.
//
// See RejectInboundCrossClusterSearchConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) RejectInboundCrossClusterSearchConnectionWithContext(ctx aws.Context, input *RejectInboundCrossClusterSearchConnectionInput, opts ...request.Option) (*RejectInboundCrossClusterSearchConnectionOutput, error) {
	req, out := c.RejectInboundCrossClusterSearchConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTags for more information on using the RemoveTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveTagsRequest method.
//	req, resp := client.RemoveTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) RemoveTagsRequest(input *RemoveTagsInput) (req *request.Request, output *RemoveTagsOutput) {
	op := &request.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/tags-removal",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	output = &RemoveTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTags API operation for Amazon Elasticsearch Service.
//
// Removes the specified set of tags from the specified Elasticsearch domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation RemoveTags for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
func (c *ElasticsearchService) RemoveTags(input *RemoveTagsInput) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	return out, req.Send()
}

// RemoveTagsWithContext is the same as RemoveTags with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) RemoveTagsWithContext(ctx aws.Context, input *RemoveTagsInput, opts ...request.Option) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartElasticsearchServiceSoftwareUpdate = "StartElasticsearchServiceSoftwareUpdate"

// StartElasticsearchServiceSoftwareUpdateRequest generates a "aws/request.Request" representing the
// client's request for the StartElasticsearchServiceSoftwareUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartElasticsearchServiceSoftwareUpdate for more information on using the StartElasticsearchServiceSoftwareUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartElasticsearchServiceSoftwareUpdateRequest method.
//	req, resp := client.StartElasticsearchServiceSoftwareUpdateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) StartElasticsearchServiceSoftwareUpdateRequest(input *StartElasticsearchServiceSoftwareUpdateInput) (req *request.Request, output *StartElasticsearchServiceSoftwareUpdateOutput) {
	op := &request.Operation{
		Name:       opStartElasticsearchServiceSoftwareUpdate,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/serviceSoftwareUpdate/start",
	}

	if input == nil {
		input = &StartElasticsearchServiceSoftwareUpdateInput{}
	}

	output = &StartElasticsearchServiceSoftwareUpdateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartElasticsearchServiceSoftwareUpdate API operation for Amazon Elasticsearch Service.
//
// Schedules a service software update for an Amazon ES domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation StartElasticsearchServiceSoftwareUpdate for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) StartElasticsearchServiceSoftwareUpdate(input *StartElasticsearchServiceSoftwareUpdateInput) (*StartElasticsearchServiceSoftwareUpdateOutput, error) {
	req, out := c.StartElasticsearchServiceSoftwareUpdateRequest(input)
	return out, req.Send()
}

// StartElasticsearchServiceSoftwareUpdateWithContext is the same as StartElasticsearchServiceSoftwareUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See StartElasticsearchServiceSoftwareUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) StartElasticsearchServiceSoftwareUpdateWithContext(ctx aws.Context, input *StartElasticsearchServiceSoftwareUpdateInput, opts ...request.Option) (*StartElasticsearchServiceSoftwareUpdateOutput, error) {
	req, out := c.StartElasticsearchServiceSoftwareUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateElasticsearchDomainConfig = "UpdateElasticsearchDomainConfig"

// UpdateElasticsearchDomainConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateElasticsearchDomainConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateElasticsearchDomainConfig for more information on using the UpdateElasticsearchDomainConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateElasticsearchDomainConfigRequest method.
//	req, resp := client.UpdateElasticsearchDomainConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) UpdateElasticsearchDomainConfigRequest(input *UpdateElasticsearchDomainConfigInput) (req *request.Request, output *UpdateElasticsearchDomainConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateElasticsearchDomainConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}/config",
	}

	if input == nil {
		input = &UpdateElasticsearchDomainConfigInput{}
	}

	output = &UpdateElasticsearchDomainConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateElasticsearchDomainConfig API operation for Amazon Elasticsearch Service.
//
// Modifies the cluster configuration of the specified Elasticsearch domain,
// setting as setting the instance type and the number of instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation UpdateElasticsearchDomainConfig for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - InvalidTypeException
//     An exception for trying to create or access sub-resource that is either invalid
//     or not supported. Gives http status code of 409.
//
//   - LimitExceededException
//     An exception for trying to create more than allowed resources or sub-resources.
//     Gives http status code of 409.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) UpdateElasticsearchDomainConfig(input *UpdateElasticsearchDomainConfigInput) (*UpdateElasticsearchDomainConfigOutput, error) {
	req, out := c.UpdateElasticsearchDomainConfigRequest(input)
	return out, req.Send()
}

// UpdateElasticsearchDomainConfigWithContext is the same as UpdateElasticsearchDomainConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateElasticsearchDomainConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) UpdateElasticsearchDomainConfigWithContext(ctx aws.Context, input *UpdateElasticsearchDomainConfigInput, opts ...request.Option) (*UpdateElasticsearchDomainConfigOutput, error) {
	req, out := c.UpdateElasticsearchDomainConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePackage = "UpdatePackage"

// UpdatePackageRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePackage for more information on using the UpdatePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePackageRequest method.
//	req, resp := client.UpdatePackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) UpdatePackageRequest(input *UpdatePackageInput) (req *request.Request, output *UpdatePackageOutput) {
	op := &request.Operation{
		Name:       opUpdatePackage,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/packages/update",
	}

	if input == nil {
		input = &UpdatePackageInput{}
	}

	output = &UpdatePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePackage API operation for Amazon Elasticsearch Service.
//
// Updates a package for use with Amazon ES domains.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation UpdatePackage for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
//
//   - LimitExceededException
//     An exception for trying to create more than allowed resources or sub-resources.
//     Gives http status code of 409.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - AccessDeniedException
//     An error occurred because user does not have permissions to access the resource.
//     Returns HTTP status code 403.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
func (c *ElasticsearchService) UpdatePackage(input *UpdatePackageInput) (*UpdatePackageOutput, error) {
	req, out := c.UpdatePackageRequest(input)
	return out, req.Send()
}

// UpdatePackageWithContext is the same as UpdatePackage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) UpdatePackageWithContext(ctx aws.Context, input *UpdatePackageInput, opts ...request.Option) (*UpdatePackageOutput, error) {
	req, out := c.UpdatePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpgradeElasticsearchDomain = "UpgradeElasticsearchDomain"

// UpgradeElasticsearchDomainRequest generates a "aws/request.Request" representing the
// client's request for the UpgradeElasticsearchDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpgradeElasticsearchDomain for more information on using the UpgradeElasticsearchDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpgradeElasticsearchDomainRequest method.
//	req, resp := client.UpgradeElasticsearchDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *ElasticsearchService) UpgradeElasticsearchDomainRequest(input *UpgradeElasticsearchDomainInput) (req *request.Request, output *UpgradeElasticsearchDomainOutput) {
	op := &request.Operation{
		Name:       opUpgradeElasticsearchDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/upgradeDomain",
	}

	if input == nil {
		input = &UpgradeElasticsearchDomainInput{}
	}

	output = &UpgradeElasticsearchDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpgradeElasticsearchDomain API operation for Amazon Elasticsearch Service.
//
// Allows you to either upgrade your domain or perform an Upgrade eligibility
// check to a compatible Elasticsearch version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation UpgradeElasticsearchDomain for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that does not exist. Gives
//     http status code of 400.
//
//   - ResourceAlreadyExistsException
//     An exception for creating a resource that already exists. Gives http status
//     code of 400.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access a not supported operation.
//     Gives http status code of 409.
//
//   - ValidationException
//     An exception for missing / invalid input fields. Gives http status code of
//     400.
//
//   - InternalException
//     The request processing has failed because of an unknown error, exception
//     or failure (the failure is internal to the service) . Gives http status code
//     of 500.
func (c *ElasticsearchService) UpgradeElasticsearchDomain(input *UpgradeElasticsearchDomainInput) (*UpgradeElasticsearchDomainOutput, error) {
	req, out := c.UpgradeElasticsearchDomainRequest(input)
	return out, req.Send()
}

// UpgradeElasticsearchDomainWithContext is the same as UpgradeElasticsearchDomain with the addition of
// the ability to pass a context and additional request options.
//
// See UpgradeElasticsearchDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) UpgradeElasticsearchDomainWithContext(ctx aws.Context, input *UpgradeElasticsearchDomainInput, opts ...request.Option) (*UpgradeElasticsearchDomainOutput, error) {
	req, out := c.UpgradeElasticsearchDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Container for the parameters to the AcceptInboundCrossClusterSearchConnection
// operation.
type AcceptInboundCrossClusterSearchConnectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The id of the inbound connection that you want to accept.
	//
	// CrossClusterSearchConnectionId is a required field
	CrossClusterSearchConnectionId *string `location:"uri" locationName:"ConnectionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInboundCrossClusterSearchConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInboundCrossClusterSearchConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptInboundCrossClusterSearchConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptInboundCrossClusterSearchConnectionInput"}
	if s.CrossClusterSearchConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CrossClusterSearchConnectionId"))
	}
	if s.CrossClusterSearchConnectionId != nil && len(*s.CrossClusterSearchConnectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CrossClusterSearchConnectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrossClusterSearchConnectionId sets the CrossClusterSearchConnectionId field's value.
func (s *AcceptInboundCrossClusterSearchConnectionInput) SetCrossClusterSearchConnectionId(v string) *AcceptInboundCrossClusterSearchConnectionInput {
	s.CrossClusterSearchConnectionId = &v
	return s
}

// The result of a AcceptInboundCrossClusterSearchConnection operation. Contains
// details of accepted inbound connection.
type AcceptInboundCrossClusterSearchConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the InboundCrossClusterSearchConnection of accepted inbound connection.
	CrossClusterSearchConnection *InboundCrossClusterSearchConnection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInboundCrossClusterSearchConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInboundCrossClusterSearchConnectionOutput) GoString() string {
	return s.String()
}

// SetCrossClusterSearchConnection sets the CrossClusterSearchConnection field's value.
func (s *AcceptInboundCrossClusterSearchConnectionOutput) SetCrossClusterSearchConnection(v *InboundCrossClusterSearchConnection) *AcceptInboundCrossClusterSearchConnectionOutput {
	s.CrossClusterSearchConnection = v
	return s
}

// An error occurred because user does not have permissions to access the resource.
// Returns HTTP status code 403.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configured access rules for the domain's document and search endpoints,
// and the current status of those rules.
type AccessPoliciesStatus struct {
	_ struct{} `type:"structure"`

	// The access policy configured for the Elasticsearch domain. Access policies
	// may be resource-based, IP-based, or IAM-based. See Configuring Access Policies
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-access-policies)for
	// more information.
	//
	// Options is a required field
	Options *string `type:"string" required:"true"`

	// The status of the access policy for the Elasticsearch domain. See OptionStatus
	// for the status information that's included.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPoliciesStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPoliciesStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AccessPoliciesStatus) SetOptions(v string) *AccessPoliciesStatus {
	s.Options = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccessPoliciesStatus) SetStatus(v *OptionStatus) *AccessPoliciesStatus {
	s.Status = v
	return s
}

// Container for the parameters to the AddTags operation. Specify the tags that
// you want to attach to the Elasticsearch domain.
type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// Specify the ARN for which you want to add the tags.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// List of Tag that need to be added for the Elasticsearch domain.
	//
	// TagList is a required field
	TagList []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.TagList == nil {
		invalidParams.Add(request.NewErrParamRequired("TagList"))
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *AddTagsInput) SetARN(v string) *AddTagsInput {
	s.ARN = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *AddTagsInput) SetTagList(v []*Tag) *AddTagsInput {
	s.TagList = v
	return s
}

type AddTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// List of limits that are specific to a given InstanceType and for each of
// it's InstanceRole .
type AdditionalLimit struct {
	_ struct{} `type:"structure"`

	// Name of Additional Limit is specific to a given InstanceType and for each
	// of it's InstanceRole etc. Attributes and their details:
	//    * MaximumNumberOfDataNodesSupported
	//
	//    * MaximumNumberOfDataNodesWithoutMasterNode
	LimitName *string `type:"string"`

	// Value for given AdditionalLimit$LimitName .
	LimitValues []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalLimit) GoString() string {
	return s.String()
}

// SetLimitName sets the LimitName field's value.
func (s *AdditionalLimit) SetLimitName(v string) *AdditionalLimit {
	s.LimitName = &v
	return s
}

// SetLimitValues sets the LimitValues field's value.
func (s *AdditionalLimit) SetLimitValues(v []*string) *AdditionalLimit {
	s.LimitValues = v
	return s
}

// Status of the advanced options for the specified Elasticsearch domain. Currently,
// the following advanced options are available:
//
//   - Option to allow references to indices in an HTTP request body. Must
//     be false when configuring access to individual sub-resources. By default,
//     the value is true. See Configuration Advanced Options for more information.
//
//   - Option to specify the percentage of heap space that is allocated to
//     field data. By default, this setting is unbounded.
//
// For more information, see Configuring Advanced Options (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options).
type AdvancedOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the status of advanced options for the specified Elasticsearch
	// domain.
	//
	// Options is a required field
	Options map[string]*string `type:"map" required:"true"`

	// Specifies the status of OptionStatus for advanced options for the specified
	// Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AdvancedOptionsStatus) SetOptions(v map[string]*string) *AdvancedOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AdvancedOptionsStatus) SetStatus(v *OptionStatus) *AdvancedOptionsStatus {
	s.Status = v
	return s
}

// Specifies the advanced security configuration: whether advanced security
// is enabled, whether the internal database option is enabled.
type AdvancedSecurityOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the Anonymous Auth Disable Date when Anonymous Auth is enabled.
	AnonymousAuthDisableDate *time.Time `type:"timestamp"`

	// True if Anonymous auth is enabled. Anonymous auth can be enabled only when
	// AdvancedSecurity is enabled on existing domains.
	AnonymousAuthEnabled *bool `type:"boolean"`

	// True if advanced security is enabled.
	Enabled *bool `type:"boolean"`

	// True if the internal user database is enabled.
	InternalUserDatabaseEnabled *bool `type:"boolean"`

	// Describes the SAML application configured for a domain.
	SAMLOptions *SAMLOptionsOutput `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptions) GoString() string {
	return s.String()
}

// SetAnonymousAuthDisableDate sets the AnonymousAuthDisableDate field's value.
func (s *AdvancedSecurityOptions) SetAnonymousAuthDisableDate(v time.Time) *AdvancedSecurityOptions {
	s.AnonymousAuthDisableDate = &v
	return s
}

// SetAnonymousAuthEnabled sets the AnonymousAuthEnabled field's value.
func (s *AdvancedSecurityOptions) SetAnonymousAuthEnabled(v bool) *AdvancedSecurityOptions {
	s.AnonymousAuthEnabled = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AdvancedSecurityOptions) SetEnabled(v bool) *AdvancedSecurityOptions {
	s.Enabled = &v
	return s
}

// SetInternalUserDatabaseEnabled sets the InternalUserDatabaseEnabled field's value.
func (s *AdvancedSecurityOptions) SetInternalUserDatabaseEnabled(v bool) *AdvancedSecurityOptions {
	s.InternalUserDatabaseEnabled = &v
	return s
}

// SetSAMLOptions sets the SAMLOptions field's value.
func (s *AdvancedSecurityOptions) SetSAMLOptions(v *SAMLOptionsOutput) *AdvancedSecurityOptions {
	s.SAMLOptions = v
	return s
}

// Specifies the advanced security configuration: whether advanced security
// is enabled, whether the internal database option is enabled, master username
// and password (if internal database is enabled), and master user ARN (if IAM
// is enabled).
type AdvancedSecurityOptionsInput struct {
	_ struct{} `type:"structure"`

	// True if Anonymous auth is enabled. Anonymous auth can be enabled only when
	// AdvancedSecurity is enabled on existing domains.
	AnonymousAuthEnabled *bool `type:"boolean"`

	// True if advanced security is enabled.
	Enabled *bool `type:"boolean"`

	// True if the internal user database is enabled.
	InternalUserDatabaseEnabled *bool `type:"boolean"`

	// Credentials for the master user: username and password, ARN, or both.
	MasterUserOptions *MasterUserOptions `type:"structure"`

	// Specifies the SAML application configuration for the domain.
	SAMLOptions *SAMLOptionsInput `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdvancedSecurityOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdvancedSecurityOptionsInput"}
	if s.MasterUserOptions != nil {
		if err := s.MasterUserOptions.Validate(); err != nil {
			invalidParams.AddNested("MasterUserOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.SAMLOptions != nil {
		if err := s.SAMLOptions.Validate(); err != nil {
			invalidParams.AddNested("SAMLOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnonymousAuthEnabled sets the AnonymousAuthEnabled field's value.
func (s *AdvancedSecurityOptionsInput) SetAnonymousAuthEnabled(v bool) *AdvancedSecurityOptionsInput {
	s.AnonymousAuthEnabled = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AdvancedSecurityOptionsInput) SetEnabled(v bool) *AdvancedSecurityOptionsInput {
	s.Enabled = &v
	return s
}

// SetInternalUserDatabaseEnabled sets the InternalUserDatabaseEnabled field's value.
func (s *AdvancedSecurityOptionsInput) SetInternalUserDatabaseEnabled(v bool) *AdvancedSecurityOptionsInput {
	s.InternalUserDatabaseEnabled = &v
	return s
}

// SetMasterUserOptions sets the MasterUserOptions field's value.
func (s *AdvancedSecurityOptionsInput) SetMasterUserOptions(v *MasterUserOptions) *AdvancedSecurityOptionsInput {
	s.MasterUserOptions = v
	return s
}

// SetSAMLOptions sets the SAMLOptions field's value.
func (s *AdvancedSecurityOptionsInput) SetSAMLOptions(v *SAMLOptionsInput) *AdvancedSecurityOptionsInput {
	s.SAMLOptions = v
	return s
}

// Specifies the status of advanced security options for the specified Elasticsearch
// domain.
type AdvancedSecurityOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies advanced security options for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *AdvancedSecurityOptions `type:"structure" required:"true"`

	// Status of the advanced security options for the specified Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AdvancedSecurityOptionsStatus) SetOptions(v *AdvancedSecurityOptions) *AdvancedSecurityOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AdvancedSecurityOptionsStatus) SetStatus(v *OptionStatus) *AdvancedSecurityOptionsStatus {
	s.Status = v
	return s
}

// Container for request parameters to AssociatePackage operation.
type AssociatePackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Name of the domain that you want to associate the package with.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Internal ID of the package that you want to associate with a domain. Use
	// DescribePackages to find this value.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociatePackageInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageID != nil && len(*s.PackageID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *AssociatePackageInput) SetDomainName(v string) *AssociatePackageInput {
	s.DomainName = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *AssociatePackageInput) SetPackageID(v string) *AssociatePackageInput {
	s.PackageID = &v
	return s
}

// Container for response returned by AssociatePackage operation.
type AssociatePackageOutput struct {
	_ struct{} `type:"structure"`

	// DomainPackageDetails
	DomainPackageDetails *DomainPackageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePackageOutput) GoString() string {
	return s.String()
}

// SetDomainPackageDetails sets the DomainPackageDetails field's value.
func (s *AssociatePackageOutput) SetDomainPackageDetails(v *DomainPackageDetails) *AssociatePackageOutput {
	s.DomainPackageDetails = v
	return s
}

// Specifies Auto-Tune type and Auto-Tune action details.
type AutoTune struct {
	_ struct{} `type:"structure"`

	// Specifies details of the Auto-Tune action. See the Developer Guide (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	AutoTuneDetails *AutoTuneDetails `type:"structure"`

	// Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION.
	AutoTuneType *string `type:"string" enum:"AutoTuneType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTune) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTune) GoString() string {
	return s.String()
}

// SetAutoTuneDetails sets the AutoTuneDetails field's value.
func (s *AutoTune) SetAutoTuneDetails(v *AutoTuneDetails) *AutoTune {
	s.AutoTuneDetails = v
	return s
}

// SetAutoTuneType sets the AutoTuneType field's value.
func (s *AutoTune) SetAutoTuneType(v string) *AutoTune {
	s.AutoTuneType = &v
	return s
}

// Specifies details of the Auto-Tune action. See the Developer Guide (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
// for more information.
type AutoTuneDetails struct {
	_ struct{} `type:"structure"`

	// Specifies details of the scheduled Auto-Tune action. See the Developer Guide
	// (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	ScheduledAutoTuneDetails *ScheduledAutoTuneDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneDetails) GoString() string {
	return s.String()
}

// SetScheduledAutoTuneDetails sets the ScheduledAutoTuneDetails field's value.
func (s *AutoTuneDetails) SetScheduledAutoTuneDetails(v *ScheduledAutoTuneDetails) *AutoTuneDetails {
	s.ScheduledAutoTuneDetails = v
	return s
}

// Specifies Auto-Tune maitenance schedule. See the Developer Guide (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
// for more information.
type AutoTuneMaintenanceSchedule struct {
	_ struct{} `type:"structure"`

	// Specifies cron expression for a recurring maintenance schedule. See the Developer
	// Guide (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	CronExpressionForRecurrence *string `type:"string"`

	// Specifies maintenance schedule duration: duration value and duration unit.
	// See the Developer Guide (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	Duration *Duration `type:"structure"`

	// Specifies timestamp at which Auto-Tune maintenance schedule start.
	StartAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneMaintenanceSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneMaintenanceSchedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoTuneMaintenanceSchedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoTuneMaintenanceSchedule"}
	if s.Duration != nil {
		if err := s.Duration.Validate(); err != nil {
			invalidParams.AddNested("Duration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCronExpressionForRecurrence sets the CronExpressionForRecurrence field's value.
func (s *AutoTuneMaintenanceSchedule) SetCronExpressionForRecurrence(v string) *AutoTuneMaintenanceSchedule {
	s.CronExpressionForRecurrence = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *AutoTuneMaintenanceSchedule) SetDuration(v *Duration) *AutoTuneMaintenanceSchedule {
	s.Duration = v
	return s
}

// SetStartAt sets the StartAt field's value.
func (s *AutoTuneMaintenanceSchedule) SetStartAt(v time.Time) *AutoTuneMaintenanceSchedule {
	s.StartAt = &v
	return s
}

// Specifies the Auto-Tune options: the Auto-Tune desired state for the domain,
// rollback state when disabling Auto-Tune options and list of maintenance schedules.
type AutoTuneOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.
	DesiredState *string `type:"string" enum:"AutoTuneDesiredState"`

	// Specifies list of maitenance schedules. See the Developer Guide (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	MaintenanceSchedules []*AutoTuneMaintenanceSchedule `type:"list"`

	// Specifies the rollback state while disabling Auto-Tune for the domain. Valid
	// values are NO_ROLLBACK, DEFAULT_ROLLBACK.
	RollbackOnDisable *string `type:"string" enum:"RollbackOnDisable"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoTuneOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoTuneOptions"}
	if s.MaintenanceSchedules != nil {
		for i, v := range s.MaintenanceSchedules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MaintenanceSchedules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredState sets the DesiredState field's value.
func (s *AutoTuneOptions) SetDesiredState(v string) *AutoTuneOptions {
	s.DesiredState = &v
	return s
}

// SetMaintenanceSchedules sets the MaintenanceSchedules field's value.
func (s *AutoTuneOptions) SetMaintenanceSchedules(v []*AutoTuneMaintenanceSchedule) *AutoTuneOptions {
	s.MaintenanceSchedules = v
	return s
}

// SetRollbackOnDisable sets the RollbackOnDisable field's value.
func (s *AutoTuneOptions) SetRollbackOnDisable(v string) *AutoTuneOptions {
	s.RollbackOnDisable = &v
	return s
}

// Specifies the Auto-Tune options: the Auto-Tune desired state for the domain
// and list of maintenance schedules.
type AutoTuneOptionsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.
	DesiredState *string `type:"string" enum:"AutoTuneDesiredState"`

	// Specifies list of maitenance schedules. See the Developer Guide (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	MaintenanceSchedules []*AutoTuneMaintenanceSchedule `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoTuneOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoTuneOptionsInput"}
	if s.MaintenanceSchedules != nil {
		for i, v := range s.MaintenanceSchedules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MaintenanceSchedules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredState sets the DesiredState field's value.
func (s *AutoTuneOptionsInput) SetDesiredState(v string) *AutoTuneOptionsInput {
	s.DesiredState = &v
	return s
}

// SetMaintenanceSchedules sets the MaintenanceSchedules field's value.
func (s *AutoTuneOptionsInput) SetMaintenanceSchedules(v []*AutoTuneMaintenanceSchedule) *AutoTuneOptionsInput {
	s.MaintenanceSchedules = v
	return s
}

// Specifies the Auto-Tune options: the Auto-Tune desired state for the domain
// and list of maintenance schedules.
type AutoTuneOptionsOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the error message while enabling or disabling the Auto-Tune.
	ErrorMessage *string `type:"string"`

	// Specifies the AutoTuneState for the Elasticsearch domain.
	State *string `type:"string" enum:"AutoTuneState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsOutput) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *AutoTuneOptionsOutput) SetErrorMessage(v string) *AutoTuneOptionsOutput {
	s.ErrorMessage = &v
	return s
}

// SetState sets the State field's value.
func (s *AutoTuneOptionsOutput) SetState(v string) *AutoTuneOptionsOutput {
	s.State = &v
	return s
}

// Specifies the status of Auto-Tune options for the specified Elasticsearch
// domain.
type AutoTuneOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies Auto-Tune options for the specified Elasticsearch domain.
	Options *AutoTuneOptions `type:"structure"`

	// Specifies Status of the Auto-Tune options for the specified Elasticsearch
	// domain.
	Status *AutoTuneStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AutoTuneOptionsStatus) SetOptions(v *AutoTuneOptions) *AutoTuneOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AutoTuneOptionsStatus) SetStatus(v *AutoTuneStatus) *AutoTuneOptionsStatus {
	s.Status = v
	return s
}

// Provides the current status of the Auto-Tune options.
type AutoTuneStatus struct {
	_ struct{} `type:"structure"`

	// Timestamp which tells Auto-Tune options creation date .
	//
	// CreationDate is a required field
	CreationDate *time.Time `type:"timestamp" required:"true"`

	// Specifies the error message while enabling or disabling the Auto-Tune options.
	ErrorMessage *string `type:"string"`

	// Indicates whether the Elasticsearch domain is being deleted.
	PendingDeletion *bool `type:"boolean"`

	// Specifies the AutoTuneState for the Elasticsearch domain.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"AutoTuneState"`

	// Timestamp which tells Auto-Tune options last updated time.
	//
	// UpdateDate is a required field
	UpdateDate *time.Time `type:"timestamp" required:"true"`

	// Specifies the Auto-Tune options latest version.
	UpdateVersion *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneStatus) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *AutoTuneStatus) SetCreationDate(v time.Time) *AutoTuneStatus {
	s.CreationDate = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *AutoTuneStatus) SetErrorMessage(v string) *AutoTuneStatus {
	s.ErrorMessage = &v
	return s
}

// SetPendingDeletion sets the PendingDeletion field's value.
func (s *AutoTuneStatus) SetPendingDeletion(v bool) *AutoTuneStatus {
	s.PendingDeletion = &v
	return s
}

// SetState sets the State field's value.
func (s *AutoTuneStatus) SetState(v string) *AutoTuneStatus {
	s.State = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *AutoTuneStatus) SetUpdateDate(v time.Time) *AutoTuneStatus {
	s.UpdateDate = &v
	return s
}

// SetUpdateVersion sets the UpdateVersion field's value.
func (s *AutoTuneStatus) SetUpdateVersion(v int64) *AutoTuneStatus {
	s.UpdateVersion = &v
	return s
}

// An error occurred while processing the request.
type BaseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A description of the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BaseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BaseException) GoString() string {
	return s.String()
}

func newErrorBaseException(v protocol.ResponseMetadata) error {
	return &BaseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BaseException) Code() string {
	return "BaseException"
}

// Message returns the exception's message.
func (s *BaseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BaseException) OrigErr() error {
	return nil
}

func (s *BaseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BaseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BaseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Container for the parameters to the CancelElasticsearchServiceSoftwareUpdate
// operation. Specifies the name of the Elasticsearch domain that you wish to
// cancel a service software update on.
type CancelElasticsearchServiceSoftwareUpdateInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that you want to stop the latest service software
	// update on.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelElasticsearchServiceSoftwareUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelElasticsearchServiceSoftwareUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelElasticsearchServiceSoftwareUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelElasticsearchServiceSoftwareUpdateInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *CancelElasticsearchServiceSoftwareUpdateInput) SetDomainName(v string) *CancelElasticsearchServiceSoftwareUpdateInput {
	s.DomainName = &v
	return s
}

// The result of a CancelElasticsearchServiceSoftwareUpdate operation. Contains
// the status of the update.
type CancelElasticsearchServiceSoftwareUpdateOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the Elasticsearch service software update.
	ServiceSoftwareOptions *ServiceSoftwareOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelElasticsearchServiceSoftwareUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelElasticsearchServiceSoftwareUpdateOutput) GoString() string {
	return s.String()
}

// SetServiceSoftwareOptions sets the ServiceSoftwareOptions field's value.
func (s *CancelElasticsearchServiceSoftwareUpdateOutput) SetServiceSoftwareOptions(v *ServiceSoftwareOptions) *CancelElasticsearchServiceSoftwareUpdateOutput {
	s.ServiceSoftwareOptions = v
	return s
}

// Specifies change details of the domain configuration change.
type ChangeProgressDetails struct {
	_ struct{} `type:"structure"`

	// The unique change identifier associated with a specific domain configuration
	// change.
	ChangeId *string `type:"string"`

	// Contains an optional message associated with the domain configuration change.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeProgressDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeProgressDetails) GoString() string {
	return s.String()
}

// SetChangeId sets the ChangeId field's value.
func (s *ChangeProgressDetails) SetChangeId(v string) *ChangeProgressDetails {
	s.ChangeId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ChangeProgressDetails) SetMessage(v string) *ChangeProgressDetails {
	s.Message = &v
	return s
}

// A progress stage details of a specific domain configuration change.
type ChangeProgressStage struct {
	_ struct{} `type:"structure"`

	// The description of the progress stage.
	Description *string `type:"string"`

	// The last updated timestamp of the progress stage.
	LastUpdated *time.Time `type:"timestamp"`

	// The name of the specific progress stage.
	Name *string `min:"1" type:"string"`

	// The overall status of a specific progress stage.
	Status *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeProgressStage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeProgressStage) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ChangeProgressStage) SetDescription(v string) *ChangeProgressStage {
	s.Description = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *ChangeProgressStage) SetLastUpdated(v time.Time) *ChangeProgressStage {
	s.LastUpdated = &v
	return s
}

// SetName sets the Name field's value.
func (s *ChangeProgressStage) SetName(v string) *ChangeProgressStage {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChangeProgressStage) SetStatus(v string) *ChangeProgressStage {
	s.Status = &v
	return s
}

// The progress details of a specific domain configuration change.
type ChangeProgressStatusDetails struct {
	_ struct{} `type:"structure"`

	// The unique change identifier associated with a specific domain configuration
	// change.
	ChangeId *string `type:"string"`

	// The specific stages that the domain is going through to perform the configuration
	// change.
	ChangeProgressStages []*ChangeProgressStage `type:"list"`

	// The list of properties involved in the domain configuration change that are
	// completed.
	CompletedProperties []*string `type:"list"`

	// The list of properties involved in the domain configuration change that are
	// still in pending.
	PendingProperties []*string `type:"list"`

	// The time at which the configuration change is made on the domain.
	StartTime *time.Time `type:"timestamp"`

	// The overall status of the domain configuration change. This field can take
	// the following values: PENDING, PROCESSING, COMPLETED and FAILED
	Status *string `type:"string" enum:"OverallChangeStatus"`

	// The total number of stages required for the configuration change.
	TotalNumberOfStages *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeProgressStatusDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeProgressStatusDetails) GoString() string {
	return s.String()
}

// SetChangeId sets the ChangeId field's value.
func (s *ChangeProgressStatusDetails) SetChangeId(v string) *ChangeProgressStatusDetails {
	s.ChangeId = &v
	return s
}

// SetChangeProgressStages sets the ChangeProgressStages field's value.
func (s *ChangeProgressStatusDetails) SetChangeProgressStages(v []*ChangeProgressStage) *ChangeProgressStatusDetails {
	s.ChangeProgressStages = v
	return s
}

// SetCompletedProperties sets the CompletedProperties field's value.
func (s *ChangeProgressStatusDetails) SetCompletedProperties(v []*string) *ChangeProgressStatusDetails {
	s.CompletedProperties = v
	return s
}

// SetPendingProperties sets the PendingProperties field's value.
func (s *ChangeProgressStatusDetails) SetPendingProperties(v []*string) *ChangeProgressStatusDetails {
	s.PendingProperties = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ChangeProgressStatusDetails) SetStartTime(v time.Time) *ChangeProgressStatusDetails {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChangeProgressStatusDetails) SetStatus(v string) *ChangeProgressStatusDetails {
	s.Status = &v
	return s
}

// SetTotalNumberOfStages sets the TotalNumberOfStages field's value.
func (s *ChangeProgressStatusDetails) SetTotalNumberOfStages(v int64) *ChangeProgressStatusDetails {
	s.TotalNumberOfStages = &v
	return s
}

// Options to specify the Cognito user and identity pools for Kibana authentication.
// For more information, see Amazon Cognito Authentication for Kibana (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html).
type CognitoOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the option to enable Cognito for Kibana authentication.
	Enabled *bool `type:"boolean"`

	// Specifies the Cognito identity pool ID for Kibana authentication.
	IdentityPoolId *string `min:"1" type:"string"`

	// Specifies the role ARN that provides Elasticsearch permissions for accessing
	// Cognito resources.
	RoleArn *string `min:"20" type:"string"`

	// Specifies the Cognito user pool ID for Kibana authentication.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CognitoOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CognitoOptions"}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CognitoOptions) SetEnabled(v bool) *CognitoOptions {
	s.Enabled = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *CognitoOptions) SetIdentityPoolId(v string) *CognitoOptions {
	s.IdentityPoolId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CognitoOptions) SetRoleArn(v string) *CognitoOptions {
	s.RoleArn = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *CognitoOptions) SetUserPoolId(v string) *CognitoOptions {
	s.UserPoolId = &v
	return s
}

// Status of the Cognito options for the specified Elasticsearch domain.
type CognitoOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the Cognito options for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *CognitoOptions `type:"structure" required:"true"`

	// Specifies the status of the Cognito options for the specified Elasticsearch
	// domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *CognitoOptionsStatus) SetOptions(v *CognitoOptions) *CognitoOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CognitoOptionsStatus) SetStatus(v *OptionStatus) *CognitoOptionsStatus {
	s.Status = v
	return s
}

// Specifies the configuration for cold storage options such as enabled
type ColdStorageOptions struct {
	_ struct{} `type:"structure"`

	// Enable cold storage option. Accepted values true or false
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColdStorageOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColdStorageOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColdStorageOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColdStorageOptions"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *ColdStorageOptions) SetEnabled(v bool) *ColdStorageOptions {
	s.Enabled = &v
	return s
}

// A map from an ElasticsearchVersion to a list of compatible ElasticsearchVersion
// s to which the domain can be upgraded.
type CompatibleVersionsMap struct {
	_ struct{} `type:"structure"`

	// The current version of Elasticsearch on which a domain is.
	SourceVersion *string `type:"string"`

	// List of supported elastic search versions.
	TargetVersions []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompatibleVersionsMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompatibleVersionsMap) GoString() string {
	return s.String()
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *CompatibleVersionsMap) SetSourceVersion(v string) *CompatibleVersionsMap {
	s.SourceVersion = &v
	return s
}

// SetTargetVersions sets the TargetVersions field's value.
func (s *CompatibleVersionsMap) SetTargetVersions(v []*string) *CompatibleVersionsMap {
	s.TargetVersions = v
	return s
}

// An error occurred because the client attempts to remove a resource that is
// currently in use. Returns HTTP status code 409.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateElasticsearchDomainInput struct {
	_ struct{} `type:"structure"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// Option to allow references to indices in an HTTP request body. Must be false
	// when configuring access to individual sub-resources. By default, the value
	// is true. See Configuration Advanced Options (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions map[string]*string `type:"map"`

	// Specifies advanced security options.
	AdvancedSecurityOptions *AdvancedSecurityOptionsInput `type:"structure"`

	// Specifies Auto-Tune options.
	AutoTuneOptions *AutoTuneOptionsInput `type:"structure"`

	// Options to specify the Cognito user and identity pools for Kibana authentication.
	// For more information, see Amazon Cognito Authentication for Kibana (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html).
	CognitoOptions *CognitoOptions `type:"structure"`

	// Options to specify configuration that will be applied to the domain endpoint.
	DomainEndpointOptions *DomainEndpointOptions `type:"structure"`

	// The name of the Elasticsearch domain that you are creating. Domain names
	// are unique across the domains owned by an account within an AWS region. Domain
	// names must start with a lowercase letter and can contain the following characters:
	// a-z (lowercase), 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// Options to enable, disable and specify the type and size of EBS storage volumes.
	EBSOptions *EBSOptions `type:"structure"`

	// Configuration options for an Elasticsearch domain. Specifies the instance
	// type and number of instances in the domain cluster.
	ElasticsearchClusterConfig *ElasticsearchClusterConfig `type:"structure"`

	// String of format X.Y to specify version for the Elasticsearch domain eg.
	// "1.5" or "2.3". For more information, see Creating Elasticsearch Domains
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains)
	// in the Amazon Elasticsearch Service Developer Guide.
	ElasticsearchVersion *string `type:"string"`

	// Specifies the Encryption At Rest Options.
	EncryptionAtRestOptions *EncryptionAtRestOptions `type:"structure"`

	// Map of LogType and LogPublishingOption, each containing options to publish
	// a given type of Elasticsearch log.
	LogPublishingOptions map[string]*LogPublishingOption `type:"map"`

	// Specifies the NodeToNodeEncryptionOptions.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptions `type:"structure"`

	// Option to set time, in UTC format, of the daily automated snapshot. Default
	// value is 0 hours.
	SnapshotOptions *SnapshotOptions `type:"structure"`

	// A list of Tag added during domain creation.
	TagList []*Tag `type:"list"`

	// Options to specify the subnets and security groups for VPC endpoint. For
	// more information, see Creating a VPC (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc)
	// in VPC Endpoints for Amazon Elasticsearch Service Domains
	VPCOptions *VPCOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateElasticsearchDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateElasticsearchDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateElasticsearchDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateElasticsearchDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.AdvancedSecurityOptions != nil {
		if err := s.AdvancedSecurityOptions.Validate(); err != nil {
			invalidParams.AddNested("AdvancedSecurityOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.AutoTuneOptions != nil {
		if err := s.AutoTuneOptions.Validate(); err != nil {
			invalidParams.AddNested("AutoTuneOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.CognitoOptions != nil {
		if err := s.CognitoOptions.Validate(); err != nil {
			invalidParams.AddNested("CognitoOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.DomainEndpointOptions != nil {
		if err := s.DomainEndpointOptions.Validate(); err != nil {
			invalidParams.AddNested("DomainEndpointOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.ElasticsearchClusterConfig != nil {
		if err := s.ElasticsearchClusterConfig.Validate(); err != nil {
			invalidParams.AddNested("ElasticsearchClusterConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionAtRestOptions != nil {
		if err := s.EncryptionAtRestOptions.Validate(); err != nil {
			invalidParams.AddNested("EncryptionAtRestOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *CreateElasticsearchDomainInput) SetAccessPolicies(v string) *CreateElasticsearchDomainInput {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *CreateElasticsearchDomainInput) SetAdvancedOptions(v map[string]*string) *CreateElasticsearchDomainInput {
	s.AdvancedOptions = v
	return s
}

// SetAdvancedSecurityOptions sets the AdvancedSecurityOptions field's value.
func (s *CreateElasticsearchDomainInput) SetAdvancedSecurityOptions(v *AdvancedSecurityOptionsInput) *CreateElasticsearchDomainInput {
	s.AdvancedSecurityOptions = v
	return s
}

// SetAutoTuneOptions sets the AutoTuneOptions field's value.
func (s *CreateElasticsearchDomainInput) SetAutoTuneOptions(v *AutoTuneOptionsInput) *CreateElasticsearchDomainInput {
	s.AutoTuneOptions = v
	return s
}

// SetCognitoOptions sets the CognitoOptions field's value.
func (s *CreateElasticsearchDomainInput) SetCognitoOptions(v *CognitoOptions) *CreateElasticsearchDomainInput {
	s.CognitoOptions = v
	return s
}

// SetDomainEndpointOptions sets the DomainEndpointOptions field's value.
func (s *CreateElasticsearchDomainInput) SetDomainEndpointOptions(v *DomainEndpointOptions) *CreateElasticsearchDomainInput {
	s.DomainEndpointOptions = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateElasticsearchDomainInput) SetDomainName(v string) *CreateElasticsearchDomainInput {
	s.DomainName = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *CreateElasticsearchDomainInput) SetEBSOptions(v *EBSOptions) *CreateElasticsearchDomainInput {
	s.EBSOptions = v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *CreateElasticsearchDomainInput) SetElasticsearchClusterConfig(v *ElasticsearchClusterConfig) *CreateElasticsearchDomainInput {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *CreateElasticsearchDomainInput) SetElasticsearchVersion(v string) *CreateElasticsearchDomainInput {
	s.ElasticsearchVersion = &v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *CreateElasticsearchDomainInput) SetEncryptionAtRestOptions(v *EncryptionAtRestOptions) *CreateElasticsearchDomainInput {
	s.EncryptionAtRestOptions = v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *CreateElasticsearchDomainInput) SetLogPublishingOptions(v map[string]*LogPublishingOption) *CreateElasticsearchDomainInput {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *CreateElasticsearchDomainInput) SetNodeToNodeEncryptionOptions(v *NodeToNodeEncryptionOptions) *CreateElasticsearchDomainInput {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *CreateElasticsearchDomainInput) SetSnapshotOptions(v *SnapshotOptions) *CreateElasticsearchDomainInput {
	s.SnapshotOptions = v
	return s
}

// SetTagList sets the TagList field's value.
func (s *CreateElasticsearchDomainInput) SetTagList(v []*Tag) *CreateElasticsearchDomainInput {
	s.TagList = v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *CreateElasticsearchDomainInput) SetVPCOptions(v *VPCOptions) *CreateElasticsearchDomainInput {
	s.VPCOptions = v
	return s
}

// The result of a CreateElasticsearchDomain operation. Contains the status
// of the newly created Elasticsearch domain.
type CreateElasticsearchDomainOutput struct {
	_ struct{} `type:"structure"`

	// The status of the newly created Elasticsearch domain.
	DomainStatus *ElasticsearchDomainStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateElasticsearchDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateElasticsearchDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *CreateElasticsearchDomainOutput) SetDomainStatus(v *ElasticsearchDomainStatus) *CreateElasticsearchDomainOutput {
	s.DomainStatus = v
	return s
}

// Container for the parameters to the CreateOutboundCrossClusterSearchConnection
// operation.
type CreateOutboundCrossClusterSearchConnectionInput struct {
	_ struct{} `type:"structure"`

	// Specifies the connection alias that will be used by the customer for this
	// connection.
	//
	// ConnectionAlias is a required field
	ConnectionAlias *string `type:"string" required:"true"`

	// Specifies the DomainInformation for the destination Elasticsearch domain.
	//
	// DestinationDomainInfo is a required field
	DestinationDomainInfo *DomainInformation `type:"structure" required:"true"`

	// Specifies the DomainInformation for the source Elasticsearch domain.
	//
	// SourceDomainInfo is a required field
	SourceDomainInfo *DomainInformation `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOutboundCrossClusterSearchConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOutboundCrossClusterSearchConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOutboundCrossClusterSearchConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOutboundCrossClusterSearchConnectionInput"}
	if s.ConnectionAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionAlias"))
	}
	if s.DestinationDomainInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationDomainInfo"))
	}
	if s.SourceDomainInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDomainInfo"))
	}
	if s.DestinationDomainInfo != nil {
		if err := s.DestinationDomainInfo.Validate(); err != nil {
			invalidParams.AddNested("DestinationDomainInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceDomainInfo != nil {
		if err := s.SourceDomainInfo.Validate(); err != nil {
			invalidParams.AddNested("SourceDomainInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionAlias sets the ConnectionAlias field's value.
func (s *CreateOutboundCrossClusterSearchConnectionInput) SetConnectionAlias(v string) *CreateOutboundCrossClusterSearchConnectionInput {
	s.ConnectionAlias = &v
	return s
}

// SetDestinationDomainInfo sets the DestinationDomainInfo field's value.
func (s *CreateOutboundCrossClusterSearchConnectionInput) SetDestinationDomainInfo(v *DomainInformation) *CreateOutboundCrossClusterSearchConnectionInput {
	s.DestinationDomainInfo = v
	return s
}

// SetSourceDomainInfo sets the SourceDomainInfo field's value.
func (s *CreateOutboundCrossClusterSearchConnectionInput) SetSourceDomainInfo(v *DomainInformation) *CreateOutboundCrossClusterSearchConnectionInput {
	s.SourceDomainInfo = v
	return s
}

// The result of a CreateOutboundCrossClusterSearchConnection request. Contains
// the details of the newly created cross-cluster search connection.
type CreateOutboundCrossClusterSearchConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the connection alias provided during the create connection request.
	ConnectionAlias *string `type:"string"`

	// Specifies the OutboundCrossClusterSearchConnectionStatus for the newly created
	// connection.
	ConnectionStatus *OutboundCrossClusterSearchConnectionStatus `type:"structure"`

	// Unique id for the created outbound connection, which is used for subsequent
	// operations on connection.
	CrossClusterSearchConnectionId *string `type:"string"`

	// Specifies the DomainInformation for the destination Elasticsearch domain.
	DestinationDomainInfo *DomainInformation `type:"structure"`

	// Specifies the DomainInformation for the source Elasticsearch domain.
	SourceDomainInfo *DomainInformation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOutboundCrossClusterSearchConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOutboundCrossClusterSearchConnectionOutput) GoString() string {
	return s.String()
}

// SetConnectionAlias sets the ConnectionAlias field's value.
func (s *CreateOutboundCrossClusterSearchConnectionOutput) SetConnectionAlias(v string) *CreateOutboundCrossClusterSearchConnectionOutput {
	s.ConnectionAlias = &v
	return s
}

// SetConnectionStatus sets the ConnectionStatus field's value.
func (s *CreateOutboundCrossClusterSearchConnectionOutput) SetConnectionStatus(v *OutboundCrossClusterSearchConnectionStatus) *CreateOutboundCrossClusterSearchConnectionOutput {
	s.ConnectionStatus = v
	return s
}

// SetCrossClusterSearchConnectionId sets the CrossClusterSearchConnectionId field's value.
func (s *CreateOutboundCrossClusterSearchConnectionOutput) SetCrossClusterSearchConnectionId(v string) *CreateOutboundCrossClusterSearchConnectionOutput {
	s.CrossClusterSearchConnectionId = &v
	return s
}

// SetDestinationDomainInfo sets the DestinationDomainInfo field's value.
func (s *CreateOutboundCrossClusterSearchConnectionOutput) SetDestinationDomainInfo(v *DomainInformation) *CreateOutboundCrossClusterSearchConnectionOutput {
	s.DestinationDomainInfo = v
	return s
}

// SetSourceDomainInfo sets the SourceDomainInfo field's value.
func (s *CreateOutboundCrossClusterSearchConnectionOutput) SetSourceDomainInfo(v *DomainInformation) *CreateOutboundCrossClusterSearchConnectionOutput {
	s.SourceDomainInfo = v
	return s
}

// Container for request parameters to CreatePackage operation.
type CreatePackageInput struct {
	_ struct{} `type:"structure"`

	// Description of the package.
	PackageDescription *string `type:"string"`

	// Unique identifier for the package.
	//
	// PackageName is a required field
	PackageName *string `min:"3" type:"string" required:"true"`

	// The customer S3 location PackageSource for importing the package.
	//
	// PackageSource is a required field
	PackageSource *PackageSource `type:"structure" required:"true"`

	// Type of package. Currently supports only TXT-DICTIONARY.
	//
	// PackageType is a required field
	PackageType *string `type:"string" required:"true" enum:"PackageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePackageInput"}
	if s.PackageName == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageName"))
	}
	if s.PackageName != nil && len(*s.PackageName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("PackageName", 3))
	}
	if s.PackageSource == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageSource"))
	}
	if s.PackageType == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageType"))
	}
	if s.PackageSource != nil {
		if err := s.PackageSource.Validate(); err != nil {
			invalidParams.AddNested("PackageSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPackageDescription sets the PackageDescription field's value.
func (s *CreatePackageInput) SetPackageDescription(v string) *CreatePackageInput {
	s.PackageDescription = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *CreatePackageInput) SetPackageName(v string) *CreatePackageInput {
	s.PackageName = &v
	return s
}

// SetPackageSource sets the PackageSource field's value.
func (s *CreatePackageInput) SetPackageSource(v *PackageSource) *CreatePackageInput {
	s.PackageSource = v
	return s
}

// SetPackageType sets the PackageType field's value.
func (s *CreatePackageInput) SetPackageType(v string) *CreatePackageInput {
	s.PackageType = &v
	return s
}

// Container for response returned by CreatePackage operation.
type CreatePackageOutput struct {
	_ struct{} `type:"structure"`

	// Information about the package PackageDetails.
	PackageDetails *PackageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageOutput) GoString() string {
	return s.String()
}

// SetPackageDetails sets the PackageDetails field's value.
func (s *CreatePackageOutput) SetPackageDetails(v *PackageDetails) *CreatePackageOutput {
	s.PackageDetails = v
	return s
}

// Container for the parameters to the DeleteElasticsearchDomain operation.
// Specifies the name of the Elasticsearch domain that you want to delete.
type DeleteElasticsearchDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the Elasticsearch domain that you want to permanently delete.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteElasticsearchDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteElasticsearchDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteElasticsearchDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteElasticsearchDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteElasticsearchDomainInput) SetDomainName(v string) *DeleteElasticsearchDomainInput {
	s.DomainName = &v
	return s
}

// The result of a DeleteElasticsearchDomain request. Contains the status of
// the pending deletion, or no status if the domain and all of its resources
// have been deleted.
type DeleteElasticsearchDomainOutput struct {
	_ struct{} `type:"structure"`

	// The status of the Elasticsearch domain being deleted.
	DomainStatus *ElasticsearchDomainStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteElasticsearchDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteElasticsearchDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *DeleteElasticsearchDomainOutput) SetDomainStatus(v *ElasticsearchDomainStatus) *DeleteElasticsearchDomainOutput {
	s.DomainStatus = v
	return s
}

type DeleteElasticsearchServiceRoleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteElasticsearchServiceRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteElasticsearchServiceRoleInput) GoString() string {
	return s.String()
}

type DeleteElasticsearchServiceRoleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteElasticsearchServiceRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteElasticsearchServiceRoleOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DeleteInboundCrossClusterSearchConnection
// operation.
type DeleteInboundCrossClusterSearchConnectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The id of the inbound connection that you want to permanently delete.
	//
	// CrossClusterSearchConnectionId is a required field
	CrossClusterSearchConnectionId *string `location:"uri" locationName:"ConnectionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInboundCrossClusterSearchConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInboundCrossClusterSearchConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInboundCrossClusterSearchConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInboundCrossClusterSearchConnectionInput"}
	if s.CrossClusterSearchConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CrossClusterSearchConnectionId"))
	}
	if s.CrossClusterSearchConnectionId != nil && len(*s.CrossClusterSearchConnectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CrossClusterSearchConnectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrossClusterSearchConnectionId sets the CrossClusterSearchConnectionId field's value.
func (s *DeleteInboundCrossClusterSearchConnectionInput) SetCrossClusterSearchConnectionId(v string) *DeleteInboundCrossClusterSearchConnectionInput {
	s.CrossClusterSearchConnectionId = &v
	return s
}

// The result of a DeleteInboundCrossClusterSearchConnection operation. Contains
// details of deleted inbound connection.
type DeleteInboundCrossClusterSearchConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the InboundCrossClusterSearchConnection of deleted inbound connection.
	CrossClusterSearchConnection *InboundCrossClusterSearchConnection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInboundCrossClusterSearchConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInboundCrossClusterSearchConnectionOutput) GoString() string {
	return s.String()
}

// SetCrossClusterSearchConnection sets the CrossClusterSearchConnection field's value.
func (s *DeleteInboundCrossClusterSearchConnectionOutput) SetCrossClusterSearchConnection(v *InboundCrossClusterSearchConnection) *DeleteInboundCrossClusterSearchConnectionOutput {
	s.CrossClusterSearchConnection = v
	return s
}

// Container for the parameters to the DeleteOutboundCrossClusterSearchConnection
// operation.
type DeleteOutboundCrossClusterSearchConnectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The id of the outbound connection that you want to permanently delete.
	//
	// CrossClusterSearchConnectionId is a required field
	CrossClusterSearchConnectionId *string `location:"uri" locationName:"ConnectionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutboundCrossClusterSearchConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutboundCrossClusterSearchConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOutboundCrossClusterSearchConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOutboundCrossClusterSearchConnectionInput"}
	if s.CrossClusterSearchConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CrossClusterSearchConnectionId"))
	}
	if s.CrossClusterSearchConnectionId != nil && len(*s.CrossClusterSearchConnectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CrossClusterSearchConnectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrossClusterSearchConnectionId sets the CrossClusterSearchConnectionId field's value.
func (s *DeleteOutboundCrossClusterSearchConnectionInput) SetCrossClusterSearchConnectionId(v string) *DeleteOutboundCrossClusterSearchConnectionInput {
	s.CrossClusterSearchConnectionId = &v
	return s
}

// The result of a DeleteOutboundCrossClusterSearchConnection operation. Contains
// details of deleted outbound connection.
type DeleteOutboundCrossClusterSearchConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the OutboundCrossClusterSearchConnection of deleted outbound connection.
	CrossClusterSearchConnection *OutboundCrossClusterSearchConnection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutboundCrossClusterSearchConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutboundCrossClusterSearchConnectionOutput) GoString() string {
	return s.String()
}

// SetCrossClusterSearchConnection sets the CrossClusterSearchConnection field's value.
func (s *DeleteOutboundCrossClusterSearchConnectionOutput) SetCrossClusterSearchConnection(v *OutboundCrossClusterSearchConnection) *DeleteOutboundCrossClusterSearchConnectionOutput {
	s.CrossClusterSearchConnection = v
	return s
}

// Container for request parameters to DeletePackage operation.
type DeletePackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Internal ID of the package that you want to delete. Use DescribePackages
	// to find this value.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePackageInput"}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageID != nil && len(*s.PackageID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPackageID sets the PackageID field's value.
func (s *DeletePackageInput) SetPackageID(v string) *DeletePackageInput {
	s.PackageID = &v
	return s
}

// Container for response parameters to DeletePackage operation.
type DeletePackageOutput struct {
	_ struct{} `type:"structure"`

	// PackageDetails
	PackageDetails *PackageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageOutput) GoString() string {
	return s.String()
}

// SetPackageDetails sets the PackageDetails field's value.
func (s *DeletePackageOutput) SetPackageDetails(v *PackageDetails) *DeletePackageOutput {
	s.PackageDetails = v
	return s
}

// Container for the parameters to the DescribeDomainAutoTunes operation.
type DescribeDomainAutoTunesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the domain name for which you want Auto-Tune action details.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults *int64 `type:"integer"`

	// NextToken is sent in case the earlier API call results contain the NextToken.
	// It is used for pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainAutoTunesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainAutoTunesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainAutoTunesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainAutoTunesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeDomainAutoTunesInput) SetDomainName(v string) *DescribeDomainAutoTunesInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDomainAutoTunesInput) SetMaxResults(v int64) *DescribeDomainAutoTunesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDomainAutoTunesInput) SetNextToken(v string) *DescribeDomainAutoTunesInput {
	s.NextToken = &v
	return s
}

// The result of DescribeDomainAutoTunes request. See the Developer Guide (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
// for more information.
type DescribeDomainAutoTunesOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the list of setting adjustments that Auto-Tune has made to the
	// domain. See the Developer Guide (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	AutoTunes []*AutoTune `type:"list"`

	// Specifies an identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainAutoTunesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainAutoTunesOutput) GoString() string {
	return s.String()
}

// SetAutoTunes sets the AutoTunes field's value.
func (s *DescribeDomainAutoTunesOutput) SetAutoTunes(v []*AutoTune) *DescribeDomainAutoTunesOutput {
	s.AutoTunes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDomainAutoTunesOutput) SetNextToken(v string) *DescribeDomainAutoTunesOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the DescribeDomainChangeProgress operation.
// Specifies the domain name and optional change specific identity for which
// you want progress information.
type DescribeDomainChangeProgressInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The specific change ID for which you want to get progress information. This
	// is an optional parameter. If omitted, the service returns information about
	// the most recent configuration change.
	ChangeId *string `location:"querystring" locationName:"changeid" type:"string"`

	// The domain you want to get the progress information about.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainChangeProgressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainChangeProgressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainChangeProgressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainChangeProgressInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeId sets the ChangeId field's value.
func (s *DescribeDomainChangeProgressInput) SetChangeId(v string) *DescribeDomainChangeProgressInput {
	s.ChangeId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeDomainChangeProgressInput) SetDomainName(v string) *DescribeDomainChangeProgressInput {
	s.DomainName = &v
	return s
}

// The result of a DescribeDomainChangeProgress request. Contains the progress
// information of the requested domain change.
type DescribeDomainChangeProgressOutput struct {
	_ struct{} `type:"structure"`

	// Progress information for the configuration change that is requested in the
	// DescribeDomainChangeProgress request.
	ChangeProgressStatus *ChangeProgressStatusDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainChangeProgressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainChangeProgressOutput) GoString() string {
	return s.String()
}

// SetChangeProgressStatus sets the ChangeProgressStatus field's value.
func (s *DescribeDomainChangeProgressOutput) SetChangeProgressStatus(v *ChangeProgressStatusDetails) *DescribeDomainChangeProgressOutput {
	s.ChangeProgressStatus = v
	return s
}

// Container for the parameters to the DescribeElasticsearchDomainConfig operation.
// Specifies the domain name for which you want configuration information.
type DescribeElasticsearchDomainConfigInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Elasticsearch domain that you want to get information about.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeElasticsearchDomainConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeElasticsearchDomainConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchDomainConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeElasticsearchDomainConfigInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeElasticsearchDomainConfigInput) SetDomainName(v string) *DescribeElasticsearchDomainConfigInput {
	s.DomainName = &v
	return s
}

// The result of a DescribeElasticsearchDomainConfig request. Contains the configuration
// information of the requested domain.
type DescribeElasticsearchDomainConfigOutput struct {
	_ struct{} `type:"structure"`

	// The configuration information of the domain requested in the DescribeElasticsearchDomainConfig
	// request.
	//
	// DomainConfig is a required field
	DomainConfig *ElasticsearchDomainConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeElasticsearchDomainConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeElasticsearchDomainConfigOutput) GoString() string {
	return s.String()
}

// SetDomainConfig sets the DomainConfig field's value.
func (s *DescribeElasticsearchDomainConfigOutput) SetDomainConfig(v *ElasticsearchDomainConfig) *DescribeElasticsearchDomainConfigOutput {
	s.DomainConfig = v
	return s
}

// Container for the parameters to the DescribeElasticsearchDomain operation.
type DescribeElasticsearchDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the Elasticsearch domain for which you want information.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeElasticsearchDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeElasticsearchDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeElasticsearchDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeElasticsearchDomainInput) SetDomainName(v string) *DescribeElasticsearchDomainInput {
	s.DomainName = &v
	return s
}

// The result of a DescribeElasticsearchDomain request. Contains the status
// of the domain specified in the request.
type DescribeElasticsearchDomainOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the Elasticsearch domain.
	//
	// DomainStatus is a required field
	DomainStatus *ElasticsearchDomainStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeElasticsearchDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeElasticsearchDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *DescribeElasticsearchDomainOutput) SetDomainStatus(v *ElasticsearchDomainStatus) *DescribeElasticsearchDomainOutput {
	s.DomainStatus = v
	return s
}

// Container for the parameters to the DescribeElasticsearchDomains operation.
// By default, the API returns the status of all Elasticsearch domains.
type DescribeElasticsearchDomainsInput struct {
	_ struct{} `type:"structure"`

	// The Elasticsearch domains for which you want information.
	//
	// DomainNames is a required field
	DomainNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeElasticsearchDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeElasticsearchDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeElasticsearchDomainsInput"}
	if s.DomainNames == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainNames sets the DomainNames field's value.
func (s *DescribeElasticsearchDomainsInput) SetDomainNames(v []*string) *DescribeElasticsearchDomainsInput {
	s.DomainNames = v
	return s
}

// The result of a DescribeElasticsearchDomains request. Contains the status
// of the specified domains or all domains owned by the account.
type DescribeElasticsearchDomainsOutput struct {
	_ struct{} `type:"structure"`

	// The status of the domains requested in the DescribeElasticsearchDomains request.
	//
	// DomainStatusList is a required field
	DomainStatusList []*ElasticsearchDomainStatus `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeElasticsearchDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeElasticsearchDomainsOutput) GoString() string {
	return s.String()
}

// SetDomainStatusList sets the DomainStatusList field's value.
func (s *DescribeElasticsearchDomainsOutput) SetDomainStatusList(v []*ElasticsearchDomainStatus) *DescribeElasticsearchDomainsOutput {
	s.DomainStatusList = v
	return s
}

// Container for the parameters to DescribeElasticsearchInstanceTypeLimits operation.
type DescribeElasticsearchInstanceTypeLimitsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// DomainName represents the name of the Domain that we are trying to modify.
	// This should be present only if we are querying for Elasticsearch Limits for
	// existing domain.
	DomainName *string `location:"querystring" locationName:"domainName" min:"3" type:"string"`

	// Version of Elasticsearch for which Limits are needed.
	//
	// ElasticsearchVersion is a required field
	ElasticsearchVersion *string `location:"uri" locationName:"ElasticsearchVersion" type:"string" required:"true"`

	// The instance type for an Elasticsearch cluster for which Elasticsearch Limits
	// are needed.
	//
	// InstanceType is a required field
	InstanceType *string `location:"uri" locationName:"InstanceType" type:"string" required:"true" enum:"ESPartitionInstanceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeElasticsearchInstanceTypeLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeElasticsearchInstanceTypeLimitsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchInstanceTypeLimitsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeElasticsearchInstanceTypeLimitsInput"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.ElasticsearchVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ElasticsearchVersion"))
	}
	if s.ElasticsearchVersion != nil && len(*s.ElasticsearchVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ElasticsearchVersion", 1))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeElasticsearchInstanceTypeLimitsInput) SetDomainName(v string) *DescribeElasticsearchInstanceTypeLimitsInput {
	s.DomainName = &v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *DescribeElasticsearchInstanceTypeLimitsInput) SetElasticsearchVersion(v string) *DescribeElasticsearchInstanceTypeLimitsInput {
	s.ElasticsearchVersion = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *DescribeElasticsearchInstanceTypeLimitsInput) SetInstanceType(v string) *DescribeElasticsearchInstanceTypeLimitsInput {
	s.InstanceType = &v
	return s
}

// Container for the parameters received from DescribeElasticsearchInstanceTypeLimits
// operation.
type DescribeElasticsearchInstanceTypeLimitsOutput struct {
	_ struct{} `type:"structure"`

	// Map of Role of the Instance and Limits that are applicable. Role performed
	// by given Instance in Elasticsearch can be one of the following:
	//    * data: If the given InstanceType is used as data node
	//
	//    * master: If the given InstanceType is used as master node
	//
	//    * ultra_warm: If the given InstanceType is used as warm node
	LimitsByRole map[string]*Limits `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeElasticsearchInstanceTypeLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeElasticsearchInstanceTypeLimitsOutput) GoString() string {
	return s.String()
}

// SetLimitsByRole sets the LimitsByRole field's value.
func (s *DescribeElasticsearchInstanceTypeLimitsOutput) SetLimitsByRole(v map[string]*Limits) *DescribeElasticsearchInstanceTypeLimitsOutput {
	s.LimitsByRole = v
	return s
}

// Container for the parameters to the DescribeInboundCrossClusterSearchConnections
// operation.
type DescribeInboundCrossClusterSearchConnectionsInput struct {
	_ struct{} `type:"structure"`

	// A list of filters used to match properties for inbound cross-cluster search
	// connection. Available Filter names for this operation are:
	//    * cross-cluster-search-connection-id
	//
	//    * source-domain-info.domain-name
	//
	//    * source-domain-info.owner-id
	//
	//    * source-domain-info.region
	//
	//    * destination-domain-info.domain-name
	Filters []*Filter `type:"list"`

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults *int64 `type:"integer"`

	// NextToken is sent in case the earlier API call results contain the NextToken.
	// It is used for pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInboundCrossClusterSearchConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInboundCrossClusterSearchConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInboundCrossClusterSearchConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInboundCrossClusterSearchConnectionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeInboundCrossClusterSearchConnectionsInput) SetFilters(v []*Filter) *DescribeInboundCrossClusterSearchConnectionsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeInboundCrossClusterSearchConnectionsInput) SetMaxResults(v int64) *DescribeInboundCrossClusterSearchConnectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInboundCrossClusterSearchConnectionsInput) SetNextToken(v string) *DescribeInboundCrossClusterSearchConnectionsInput {
	s.NextToken = &v
	return s
}

// The result of a DescribeInboundCrossClusterSearchConnections request. Contains
// the list of connections matching the filter criteria.
type DescribeInboundCrossClusterSearchConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// Consists of list of InboundCrossClusterSearchConnection matching the specified
	// filter criteria.
	CrossClusterSearchConnections []*InboundCrossClusterSearchConnection `type:"list"`

	// If more results are available and NextToken is present, make the next request
	// to the same API with the received NextToken to paginate the remaining results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInboundCrossClusterSearchConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInboundCrossClusterSearchConnectionsOutput) GoString() string {
	return s.String()
}

// SetCrossClusterSearchConnections sets the CrossClusterSearchConnections field's value.
func (s *DescribeInboundCrossClusterSearchConnectionsOutput) SetCrossClusterSearchConnections(v []*InboundCrossClusterSearchConnection) *DescribeInboundCrossClusterSearchConnectionsOutput {
	s.CrossClusterSearchConnections = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInboundCrossClusterSearchConnectionsOutput) SetNextToken(v string) *DescribeInboundCrossClusterSearchConnectionsOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the DescribeOutboundCrossClusterSearchConnections
// operation.
type DescribeOutboundCrossClusterSearchConnectionsInput struct {
	_ struct{} `type:"structure"`

	// A list of filters used to match properties for outbound cross-cluster search
	// connection. Available Filter names for this operation are:
	//    * cross-cluster-search-connection-id
	//
	//    * destination-domain-info.domain-name
	//
	//    * destination-domain-info.owner-id
	//
	//    * destination-domain-info.region
	//
	//    * source-domain-info.domain-name
	Filters []*Filter `type:"list"`

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults *int64 `type:"integer"`

	// NextToken is sent in case the earlier API call results contain the NextToken.
	// It is used for pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOutboundCrossClusterSearchConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOutboundCrossClusterSearchConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOutboundCrossClusterSearchConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOutboundCrossClusterSearchConnectionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeOutboundCrossClusterSearchConnectionsInput) SetFilters(v []*Filter) *DescribeOutboundCrossClusterSearchConnectionsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeOutboundCrossClusterSearchConnectionsInput) SetMaxResults(v int64) *DescribeOutboundCrossClusterSearchConnectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOutboundCrossClusterSearchConnectionsInput) SetNextToken(v string) *DescribeOutboundCrossClusterSearchConnectionsInput {
	s.NextToken = &v
	return s
}

// The result of a DescribeOutboundCrossClusterSearchConnections request. Contains
// the list of connections matching the filter criteria.
type DescribeOutboundCrossClusterSearchConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// Consists of list of OutboundCrossClusterSearchConnection matching the specified
	// filter criteria.
	CrossClusterSearchConnections []*OutboundCrossClusterSearchConnection `type:"list"`

	// If more results are available and NextToken is present, make the next request
	// to the same API with the received NextToken to paginate the remaining results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOutboundCrossClusterSearchConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOutboundCrossClusterSearchConnectionsOutput) GoString() string {
	return s.String()
}

// SetCrossClusterSearchConnections sets the CrossClusterSearchConnections field's value.
func (s *DescribeOutboundCrossClusterSearchConnectionsOutput) SetCrossClusterSearchConnections(v []*OutboundCrossClusterSearchConnection) *DescribeOutboundCrossClusterSearchConnectionsOutput {
	s.CrossClusterSearchConnections = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOutboundCrossClusterSearchConnectionsOutput) SetNextToken(v string) *DescribeOutboundCrossClusterSearchConnectionsOutput {
	s.NextToken = &v
	return s
}

// Filter to apply in DescribePackage response.
type DescribePackagesFilter struct {
	_ struct{} `type:"structure"`

	// Any field from PackageDetails.
	Name *string `type:"string" enum:"DescribePackagesFilterName"`

	// A list of values for the specified field.
	Value []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesFilter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DescribePackagesFilter) SetName(v string) *DescribePackagesFilter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DescribePackagesFilter) SetValue(v []*string) *DescribePackagesFilter {
	s.Value = v
	return s
}

// Container for request parameters to DescribePackage operation.
type DescribePackagesInput struct {
	_ struct{} `type:"structure"`

	// Only returns packages that match the DescribePackagesFilterList values.
	Filters []*DescribePackagesFilter `type:"list"`

	// Limits results to a maximum number of packages.
	MaxResults *int64 `type:"integer"`

	// Used for pagination. Only necessary if a previous API call includes a non-null
	// NextToken value. If provided, returns results for the next page.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesInput) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *DescribePackagesInput) SetFilters(v []*DescribePackagesFilter) *DescribePackagesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribePackagesInput) SetMaxResults(v int64) *DescribePackagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePackagesInput) SetNextToken(v string) *DescribePackagesInput {
	s.NextToken = &v
	return s
}

// Container for response returned by DescribePackages operation.
type DescribePackagesOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	// List of PackageDetails objects.
	PackageDetailsList []*PackageDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePackagesOutput) SetNextToken(v string) *DescribePackagesOutput {
	s.NextToken = &v
	return s
}

// SetPackageDetailsList sets the PackageDetailsList field's value.
func (s *DescribePackagesOutput) SetPackageDetailsList(v []*PackageDetails) *DescribePackagesOutput {
	s.PackageDetailsList = v
	return s
}

// Container for parameters to DescribeReservedElasticsearchInstanceOfferings
type DescribeReservedElasticsearchInstanceOfferingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// NextToken should be sent in case if earlier API call produced result containing
	// NextToken. It is used for pagination.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The offering identifier filter value. Use this parameter to show only the
	// available offering that matches the specified reservation identifier.
	ReservedElasticsearchInstanceOfferingId *string `location:"querystring" locationName:"offeringId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedElasticsearchInstanceOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedElasticsearchInstanceOfferingsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeReservedElasticsearchInstanceOfferingsInput) SetMaxResults(v int64) *DescribeReservedElasticsearchInstanceOfferingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReservedElasticsearchInstanceOfferingsInput) SetNextToken(v string) *DescribeReservedElasticsearchInstanceOfferingsInput {
	s.NextToken = &v
	return s
}

// SetReservedElasticsearchInstanceOfferingId sets the ReservedElasticsearchInstanceOfferingId field's value.
func (s *DescribeReservedElasticsearchInstanceOfferingsInput) SetReservedElasticsearchInstanceOfferingId(v string) *DescribeReservedElasticsearchInstanceOfferingsInput {
	s.ReservedElasticsearchInstanceOfferingId = &v
	return s
}

// Container for results from DescribeReservedElasticsearchInstanceOfferings
type DescribeReservedElasticsearchInstanceOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`

	// List of reserved Elasticsearch instance offerings
	ReservedElasticsearchInstanceOfferings []*ReservedElasticsearchInstanceOffering `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedElasticsearchInstanceOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedElasticsearchInstanceOfferingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReservedElasticsearchInstanceOfferingsOutput) SetNextToken(v string) *DescribeReservedElasticsearchInstanceOfferingsOutput {
	s.NextToken = &v
	return s
}

// SetReservedElasticsearchInstanceOfferings sets the ReservedElasticsearchInstanceOfferings field's value.
func (s *DescribeReservedElasticsearchInstanceOfferingsOutput) SetReservedElasticsearchInstanceOfferings(v []*ReservedElasticsearchInstanceOffering) *DescribeReservedElasticsearchInstanceOfferingsOutput {
	s.ReservedElasticsearchInstanceOfferings = v
	return s
}

// Container for parameters to DescribeReservedElasticsearchInstances
type DescribeReservedElasticsearchInstancesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// NextToken should be sent in case if earlier API call produced result containing
	// NextToken. It is used for pagination.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The reserved instance identifier filter value. Use this parameter to show
	// only the reservation that matches the specified reserved Elasticsearch instance
	// ID.
	ReservedElasticsearchInstanceId *string `location:"querystring" locationName:"reservationId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedElasticsearchInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedElasticsearchInstancesInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeReservedElasticsearchInstancesInput) SetMaxResults(v int64) *DescribeReservedElasticsearchInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReservedElasticsearchInstancesInput) SetNextToken(v string) *DescribeReservedElasticsearchInstancesInput {
	s.NextToken = &v
	return s
}

// SetReservedElasticsearchInstanceId sets the ReservedElasticsearchInstanceId field's value.
func (s *DescribeReservedElasticsearchInstancesInput) SetReservedElasticsearchInstanceId(v string) *DescribeReservedElasticsearchInstancesInput {
	s.ReservedElasticsearchInstanceId = &v
	return s
}

// Container for results from DescribeReservedElasticsearchInstances
type DescribeReservedElasticsearchInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`

	// List of reserved Elasticsearch instances.
	ReservedElasticsearchInstances []*ReservedElasticsearchInstance `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedElasticsearchInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedElasticsearchInstancesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReservedElasticsearchInstancesOutput) SetNextToken(v string) *DescribeReservedElasticsearchInstancesOutput {
	s.NextToken = &v
	return s
}

// SetReservedElasticsearchInstances sets the ReservedElasticsearchInstances field's value.
func (s *DescribeReservedElasticsearchInstancesOutput) SetReservedElasticsearchInstances(v []*ReservedElasticsearchInstance) *DescribeReservedElasticsearchInstancesOutput {
	s.ReservedElasticsearchInstances = v
	return s
}

// An error occured because the client wanted to access a not supported operation.
// Gives http status code of 409.
type DisabledOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisabledOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisabledOperationException) GoString() string {
	return s.String()
}

func newErrorDisabledOperationException(v protocol.ResponseMetadata) error {
	return &DisabledOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DisabledOperationException) Code() string {
	return "DisabledOperationException"
}

// Message returns the exception's message.
func (s *DisabledOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DisabledOperationException) OrigErr() error {
	return nil
}

func (s *DisabledOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DisabledOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DisabledOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Container for request parameters to DissociatePackage operation.
type DissociatePackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Name of the domain that you want to associate the package with.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Internal ID of the package that you want to associate with a domain. Use
	// DescribePackages to find this value.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DissociatePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DissociatePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DissociatePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DissociatePackageInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageID != nil && len(*s.PackageID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DissociatePackageInput) SetDomainName(v string) *DissociatePackageInput {
	s.DomainName = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *DissociatePackageInput) SetPackageID(v string) *DissociatePackageInput {
	s.PackageID = &v
	return s
}

// Container for response returned by DissociatePackage operation.
type DissociatePackageOutput struct {
	_ struct{} `type:"structure"`

	// DomainPackageDetails
	DomainPackageDetails *DomainPackageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DissociatePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DissociatePackageOutput) GoString() string {
	return s.String()
}

// SetDomainPackageDetails sets the DomainPackageDetails field's value.
func (s *DissociatePackageOutput) SetDomainPackageDetails(v *DomainPackageDetails) *DissociatePackageOutput {
	s.DomainPackageDetails = v
	return s
}

// Options to configure endpoint for the Elasticsearch domain.
type DomainEndpointOptions struct {
	_ struct{} `type:"structure"`

	// Specify the fully qualified domain for your custom endpoint.
	CustomEndpoint *string `min:"1" type:"string"`

	// Specify ACM certificate ARN for your custom endpoint.
	CustomEndpointCertificateArn *string `type:"string"`

	// Specify if custom endpoint should be enabled for the Elasticsearch domain.
	CustomEndpointEnabled *bool `type:"boolean"`

	// Specify if only HTTPS endpoint should be enabled for the Elasticsearch domain.
	EnforceHTTPS *bool `type:"boolean"`

	// Specify the TLS security policy that needs to be applied to the HTTPS endpoint
	// of Elasticsearch domain. It can be one of the following values:
	//    * Policy-Min-TLS-1-0-2019-07: TLS security policy which supports TLSv1.0
	//    and higher.
	//
	//    * Policy-Min-TLS-1-2-2019-07: TLS security policy which supports only
	//    TLSv1.2
	TLSSecurityPolicy *string `type:"string" enum:"TLSSecurityPolicy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainEndpointOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainEndpointOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DomainEndpointOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DomainEndpointOptions"}
	if s.CustomEndpoint != nil && len(*s.CustomEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomEndpoint", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomEndpoint sets the CustomEndpoint field's value.
func (s *DomainEndpointOptions) SetCustomEndpoint(v string) *DomainEndpointOptions {
	s.CustomEndpoint = &v
	return s
}

// SetCustomEndpointCertificateArn sets the CustomEndpointCertificateArn field's value.
func (s *DomainEndpointOptions) SetCustomEndpointCertificateArn(v string) *DomainEndpointOptions {
	s.CustomEndpointCertificateArn = &v
	return s
}

// SetCustomEndpointEnabled sets the CustomEndpointEnabled field's value.
func (s *DomainEndpointOptions) SetCustomEndpointEnabled(v bool) *DomainEndpointOptions {
	s.CustomEndpointEnabled = &v
	return s
}

// SetEnforceHTTPS sets the EnforceHTTPS field's value.
func (s *DomainEndpointOptions) SetEnforceHTTPS(v bool) *DomainEndpointOptions {
	s.EnforceHTTPS = &v
	return s
}

// SetTLSSecurityPolicy sets the TLSSecurityPolicy field's value.
func (s *DomainEndpointOptions) SetTLSSecurityPolicy(v string) *DomainEndpointOptions {
	s.TLSSecurityPolicy = &v
	return s
}

// The configured endpoint options for the domain and their current status.
type DomainEndpointOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Options to configure endpoint for the Elasticsearch domain.
	//
	// Options is a required field
	Options *DomainEndpointOptions `type:"structure" required:"true"`

	// The status of the endpoint options for the Elasticsearch domain. See OptionStatus
	// for the status information that's included.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainEndpointOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainEndpointOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *DomainEndpointOptionsStatus) SetOptions(v *DomainEndpointOptions) *DomainEndpointOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DomainEndpointOptionsStatus) SetStatus(v *OptionStatus) *DomainEndpointOptionsStatus {
	s.Status = v
	return s
}

type DomainInfo struct {
	_ struct{} `type:"structure"`

	// Specifies the DomainName.
	DomainName *string `min:"3" type:"string"`

	// Specifies the EngineType of the domain.
	EngineType *string `type:"string" enum:"EngineType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainInfo) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *DomainInfo) SetDomainName(v string) *DomainInfo {
	s.DomainName = &v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *DomainInfo) SetEngineType(v string) *DomainInfo {
	s.EngineType = &v
	return s
}

type DomainInformation struct {
	_ struct{} `type:"structure"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	OwnerId *string `min:"12" type:"string"`

	Region *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainInformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DomainInformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DomainInformation"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.OwnerId != nil && len(*s.OwnerId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("OwnerId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DomainInformation) SetDomainName(v string) *DomainInformation {
	s.DomainName = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *DomainInformation) SetOwnerId(v string) *DomainInformation {
	s.OwnerId = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *DomainInformation) SetRegion(v string) *DomainInformation {
	s.Region = &v
	return s
}

// Information on a package that is associated with a domain.
type DomainPackageDetails struct {
	_ struct{} `type:"structure"`

	// Name of the domain you've associated a package with.
	DomainName *string `min:"3" type:"string"`

	// State of the association. Values are ASSOCIATING/ASSOCIATION_FAILED/ACTIVE/DISSOCIATING/DISSOCIATION_FAILED.
	DomainPackageStatus *string `type:"string" enum:"DomainPackageStatus"`

	// Additional information if the package is in an error state. Null otherwise.
	ErrorDetails *ErrorDetails `type:"structure"`

	// Timestamp of the most-recent update to the association status.
	LastUpdated *time.Time `type:"timestamp"`

	// Internal ID of the package.
	PackageID *string `type:"string"`

	// User specified name of the package.
	PackageName *string `min:"3" type:"string"`

	// Currently supports only TXT-DICTIONARY.
	PackageType *string `type:"string" enum:"PackageType"`

	PackageVersion *string `type:"string"`

	// The relative path on Amazon ES nodes, which can be used as synonym_path when
	// the package is synonym file.
	ReferencePath *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainPackageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainPackageDetails) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *DomainPackageDetails) SetDomainName(v string) *DomainPackageDetails {
	s.DomainName = &v
	return s
}

// SetDomainPackageStatus sets the DomainPackageStatus field's value.
func (s *DomainPackageDetails) SetDomainPackageStatus(v string) *DomainPackageDetails {
	s.DomainPackageStatus = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *DomainPackageDetails) SetErrorDetails(v *ErrorDetails) *DomainPackageDetails {
	s.ErrorDetails = v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *DomainPackageDetails) SetLastUpdated(v time.Time) *DomainPackageDetails {
	s.LastUpdated = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *DomainPackageDetails) SetPackageID(v string) *DomainPackageDetails {
	s.PackageID = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *DomainPackageDetails) SetPackageName(v string) *DomainPackageDetails {
	s.PackageName = &v
	return s
}

// SetPackageType sets the PackageType field's value.
func (s *DomainPackageDetails) SetPackageType(v string) *DomainPackageDetails {
	s.PackageType = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *DomainPackageDetails) SetPackageVersion(v string) *DomainPackageDetails {
	s.PackageVersion = &v
	return s
}

// SetReferencePath sets the ReferencePath field's value.
func (s *DomainPackageDetails) SetReferencePath(v string) *DomainPackageDetails {
	s.ReferencePath = &v
	return s
}

type DryRunResults struct {
	_ struct{} `type:"structure"`

	// Specifies the deployment mechanism through which the update shall be applied
	// on the domain. Possible responses are Blue/Green (The update will require
	// a blue/green deployment.) DynamicUpdate (The update can be applied in-place
	// without a Blue/Green deployment required.) Undetermined (The domain is undergoing
	// an update which needs to complete before the deployment type can be predicted.)
	// None (The configuration change matches the current configuration and will
	// not result in any update.)
	DeploymentType *string `min:"2" type:"string"`

	// Contains an optional message associated with the DryRunResults.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DryRunResults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DryRunResults) GoString() string {
	return s.String()
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *DryRunResults) SetDeploymentType(v string) *DryRunResults {
	s.DeploymentType = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DryRunResults) SetMessage(v string) *DryRunResults {
	s.Message = &v
	return s
}

// Specifies maintenance schedule duration: duration value and duration unit.
// See the Developer Guide (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
// for more information.
type Duration struct {
	_ struct{} `type:"structure"`

	// Specifies the unit of a maintenance schedule duration. Valid value is HOURS.
	// See the Developer Guide (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	Unit *string `type:"string" enum:"TimeUnit"`

	// Integer to specify the value of a maintenance schedule duration. See the
	// Developer Guide (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	Value *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Duration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Duration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Duration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Duration"}
	if s.Value != nil && *s.Value < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUnit sets the Unit field's value.
func (s *Duration) SetUnit(v string) *Duration {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Duration) SetValue(v int64) *Duration {
	s.Value = &v
	return s
}

// Options to enable, disable, and specify the properties of EBS storage volumes.
// For more information, see Configuring EBS-based Storage (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs).
type EBSOptions struct {
	_ struct{} `type:"structure"`

	// Specifies whether EBS-based storage is enabled.
	EBSEnabled *bool `type:"boolean"`

	// Specifies the IOPS for Provisioned IOPS And GP3 EBS volume (SSD).
	Iops *int64 `type:"integer"`

	// Specifies the Throughput for GP3 EBS volume (SSD).
	Throughput *int64 `type:"integer"`

	// Integer to specify the size of an EBS volume.
	VolumeSize *int64 `type:"integer"`

	// Specifies the volume type for EBS-based storage.
	VolumeType *string `type:"string" enum:"VolumeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EBSOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EBSOptions) GoString() string {
	return s.String()
}

// SetEBSEnabled sets the EBSEnabled field's value.
func (s *EBSOptions) SetEBSEnabled(v bool) *EBSOptions {
	s.EBSEnabled = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *EBSOptions) SetIops(v int64) *EBSOptions {
	s.Iops = &v
	return s
}

// SetThroughput sets the Throughput field's value.
func (s *EBSOptions) SetThroughput(v int64) *EBSOptions {
	s.Throughput = &v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *EBSOptions) SetVolumeSize(v int64) *EBSOptions {
	s.VolumeSize = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *EBSOptions) SetVolumeType(v string) *EBSOptions {
	s.VolumeType = &v
	return s
}

// Status of the EBS options for the specified Elasticsearch domain.
type EBSOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the EBS options for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *EBSOptions `type:"structure" required:"true"`

	// Specifies the status of the EBS options for the specified Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EBSOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EBSOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *EBSOptionsStatus) SetOptions(v *EBSOptions) *EBSOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *EBSOptionsStatus) SetStatus(v *OptionStatus) *EBSOptionsStatus {
	s.Status = v
	return s
}

// Specifies the configuration for the domain cluster, such as the type and
// number of instances.
type ElasticsearchClusterConfig struct {
	_ struct{} `type:"structure"`

	// Specifies the ColdStorageOptions config for Elasticsearch Domain
	ColdStorageOptions *ColdStorageOptions `type:"structure"`

	// Total number of dedicated master nodes, active and on standby, for the cluster.
	DedicatedMasterCount *int64 `type:"integer"`

	// A boolean value to indicate whether a dedicated master node is enabled. See
	// About Dedicated Master Nodes (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes)
	// for more information.
	DedicatedMasterEnabled *bool `type:"boolean"`

	// The instance type for a dedicated master node.
	DedicatedMasterType *string `type:"string" enum:"ESPartitionInstanceType"`

	// The number of instances in the specified domain cluster.
	InstanceCount *int64 `type:"integer"`

	// The instance type for an Elasticsearch cluster. UltraWarm instance types
	// are not supported for data instances.
	InstanceType *string `type:"string" enum:"ESPartitionInstanceType"`

	// The number of warm nodes in the cluster.
	WarmCount *int64 `type:"integer"`

	// True to enable warm storage.
	WarmEnabled *bool `type:"boolean"`

	// The instance type for the Elasticsearch cluster's warm nodes.
	WarmType *string `type:"string" enum:"ESWarmPartitionInstanceType"`

	// Specifies the zone awareness configuration for a domain when zone awareness
	// is enabled.
	ZoneAwarenessConfig *ZoneAwarenessConfig `type:"structure"`

	// A boolean value to indicate whether zone awareness is enabled. See About
	// Zone Awareness (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness)
	// for more information.
	ZoneAwarenessEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchClusterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchClusterConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchClusterConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElasticsearchClusterConfig"}
	if s.ColdStorageOptions != nil {
		if err := s.ColdStorageOptions.Validate(); err != nil {
			invalidParams.AddNested("ColdStorageOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColdStorageOptions sets the ColdStorageOptions field's value.
func (s *ElasticsearchClusterConfig) SetColdStorageOptions(v *ColdStorageOptions) *ElasticsearchClusterConfig {
	s.ColdStorageOptions = v
	return s
}

// SetDedicatedMasterCount sets the DedicatedMasterCount field's value.
func (s *ElasticsearchClusterConfig) SetDedicatedMasterCount(v int64) *ElasticsearchClusterConfig {
	s.DedicatedMasterCount = &v
	return s
}

// SetDedicatedMasterEnabled sets the DedicatedMasterEnabled field's value.
func (s *ElasticsearchClusterConfig) SetDedicatedMasterEnabled(v bool) *ElasticsearchClusterConfig {
	s.DedicatedMasterEnabled = &v
	return s
}

// SetDedicatedMasterType sets the DedicatedMasterType field's value.
func (s *ElasticsearchClusterConfig) SetDedicatedMasterType(v string) *ElasticsearchClusterConfig {
	s.DedicatedMasterType = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *ElasticsearchClusterConfig) SetInstanceCount(v int64) *ElasticsearchClusterConfig {
	s.InstanceCount = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ElasticsearchClusterConfig) SetInstanceType(v string) *ElasticsearchClusterConfig {
	s.InstanceType = &v
	return s
}

// SetWarmCount sets the WarmCount field's value.
func (s *ElasticsearchClusterConfig) SetWarmCount(v int64) *ElasticsearchClusterConfig {
	s.WarmCount = &v
	return s
}

// SetWarmEnabled sets the WarmEnabled field's value.
func (s *ElasticsearchClusterConfig) SetWarmEnabled(v bool) *ElasticsearchClusterConfig {
	s.WarmEnabled = &v
	return s
}

// SetWarmType sets the WarmType field's value.
func (s *ElasticsearchClusterConfig) SetWarmType(v string) *ElasticsearchClusterConfig {
	s.WarmType = &v
	return s
}

// SetZoneAwarenessConfig sets the ZoneAwarenessConfig field's value.
func (s *ElasticsearchClusterConfig) SetZoneAwarenessConfig(v *ZoneAwarenessConfig) *ElasticsearchClusterConfig {
	s.ZoneAwarenessConfig = v
	return s
}

// SetZoneAwarenessEnabled sets the ZoneAwarenessEnabled field's value.
func (s *ElasticsearchClusterConfig) SetZoneAwarenessEnabled(v bool) *ElasticsearchClusterConfig {
	s.ZoneAwarenessEnabled = &v
	return s
}

// Specifies the configuration status for the specified Elasticsearch domain.
type ElasticsearchClusterConfigStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the cluster configuration for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *ElasticsearchClusterConfig `type:"structure" required:"true"`

	// Specifies the status of the configuration for the specified Elasticsearch
	// domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchClusterConfigStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchClusterConfigStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *ElasticsearchClusterConfigStatus) SetOptions(v *ElasticsearchClusterConfig) *ElasticsearchClusterConfigStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ElasticsearchClusterConfigStatus) SetStatus(v *OptionStatus) *ElasticsearchClusterConfigStatus {
	s.Status = v
	return s
}

// The configuration of an Elasticsearch domain.
type ElasticsearchDomainConfig struct {
	_ struct{} `type:"structure"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *AccessPoliciesStatus `type:"structure"`

	// Specifies the AdvancedOptions for the domain. See Configuring Advanced Options
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions *AdvancedOptionsStatus `type:"structure"`

	// Specifies AdvancedSecurityOptions for the domain.
	AdvancedSecurityOptions *AdvancedSecurityOptionsStatus `type:"structure"`

	// Specifies AutoTuneOptions for the domain.
	AutoTuneOptions *AutoTuneOptionsStatus `type:"structure"`

	// Specifies change details of the domain configuration change.
	ChangeProgressDetails *ChangeProgressDetails `type:"structure"`

	// The CognitoOptions for the specified domain. For more information, see Amazon
	// Cognito Authentication for Kibana (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html).
	CognitoOptions *CognitoOptionsStatus `type:"structure"`

	// Specifies the DomainEndpointOptions for the Elasticsearch domain.
	DomainEndpointOptions *DomainEndpointOptionsStatus `type:"structure"`

	// Specifies the EBSOptions for the Elasticsearch domain.
	EBSOptions *EBSOptionsStatus `type:"structure"`

	// Specifies the ElasticsearchClusterConfig for the Elasticsearch domain.
	ElasticsearchClusterConfig *ElasticsearchClusterConfigStatus `type:"structure"`

	// String of format X.Y to specify version for the Elasticsearch domain.
	ElasticsearchVersion *ElasticsearchVersionStatus `type:"structure"`

	// Specifies the EncryptionAtRestOptions for the Elasticsearch domain.
	EncryptionAtRestOptions *EncryptionAtRestOptionsStatus `type:"structure"`

	// Log publishing options for the given domain.
	LogPublishingOptions *LogPublishingOptionsStatus `type:"structure"`

	// Specifies the NodeToNodeEncryptionOptions for the Elasticsearch domain.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptionsStatus `type:"structure"`

	// Specifies the SnapshotOptions for the Elasticsearch domain.
	SnapshotOptions *SnapshotOptionsStatus `type:"structure"`

	// The VPCOptions for the specified domain. For more information, see VPC Endpoints
	// for Amazon Elasticsearch Service Domains (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html).
	VPCOptions *VPCDerivedInfoStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchDomainConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchDomainConfig) GoString() string {
	return s.String()
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *ElasticsearchDomainConfig) SetAccessPolicies(v *AccessPoliciesStatus) *ElasticsearchDomainConfig {
	s.AccessPolicies = v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *ElasticsearchDomainConfig) SetAdvancedOptions(v *AdvancedOptionsStatus) *ElasticsearchDomainConfig {
	s.AdvancedOptions = v
	return s
}

// SetAdvancedSecurityOptions sets the AdvancedSecurityOptions field's value.
func (s *ElasticsearchDomainConfig) SetAdvancedSecurityOptions(v *AdvancedSecurityOptionsStatus) *ElasticsearchDomainConfig {
	s.AdvancedSecurityOptions = v
	return s
}

// SetAutoTuneOptions sets the AutoTuneOptions field's value.
func (s *ElasticsearchDomainConfig) SetAutoTuneOptions(v *AutoTuneOptionsStatus) *ElasticsearchDomainConfig {
	s.AutoTuneOptions = v
	return s
}

// SetChangeProgressDetails sets the ChangeProgressDetails field's value.
func (s *ElasticsearchDomainConfig) SetChangeProgressDetails(v *ChangeProgressDetails) *ElasticsearchDomainConfig {
	s.ChangeProgressDetails = v
	return s
}

// SetCognitoOptions sets the CognitoOptions field's value.
func (s *ElasticsearchDomainConfig) SetCognitoOptions(v *CognitoOptionsStatus) *ElasticsearchDomainConfig {
	s.CognitoOptions = v
	return s
}

// SetDomainEndpointOptions sets the DomainEndpointOptions field's value.
func (s *ElasticsearchDomainConfig) SetDomainEndpointOptions(v *DomainEndpointOptionsStatus) *ElasticsearchDomainConfig {
	s.DomainEndpointOptions = v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *ElasticsearchDomainConfig) SetEBSOptions(v *EBSOptionsStatus) *ElasticsearchDomainConfig {
	s.EBSOptions = v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *ElasticsearchDomainConfig) SetElasticsearchClusterConfig(v *ElasticsearchClusterConfigStatus) *ElasticsearchDomainConfig {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *ElasticsearchDomainConfig) SetElasticsearchVersion(v *ElasticsearchVersionStatus) *ElasticsearchDomainConfig {
	s.ElasticsearchVersion = v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *ElasticsearchDomainConfig) SetEncryptionAtRestOptions(v *EncryptionAtRestOptionsStatus) *ElasticsearchDomainConfig {
	s.EncryptionAtRestOptions = v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *ElasticsearchDomainConfig) SetLogPublishingOptions(v *LogPublishingOptionsStatus) *ElasticsearchDomainConfig {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *ElasticsearchDomainConfig) SetNodeToNodeEncryptionOptions(v *NodeToNodeEncryptionOptionsStatus) *ElasticsearchDomainConfig {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *ElasticsearchDomainConfig) SetSnapshotOptions(v *SnapshotOptionsStatus) *ElasticsearchDomainConfig {
	s.SnapshotOptions = v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *ElasticsearchDomainConfig) SetVPCOptions(v *VPCDerivedInfoStatus) *ElasticsearchDomainConfig {
	s.VPCOptions = v
	return s
}

// The current status of an Elasticsearch domain.
type ElasticsearchDomainStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) of an Elasticsearch domain. See Identifiers
	// for IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
	// in Using AWS Identity and Access Management for more information.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// Specifies the status of the AdvancedOptions
	AdvancedOptions map[string]*string `type:"map"`

	// The current status of the Elasticsearch domain's advanced security options.
	AdvancedSecurityOptions *AdvancedSecurityOptions `type:"structure"`

	// The current status of the Elasticsearch domain's Auto-Tune options.
	AutoTuneOptions *AutoTuneOptionsOutput `type:"structure"`

	// Specifies change details of the domain configuration change.
	ChangeProgressDetails *ChangeProgressDetails `type:"structure"`

	// The CognitoOptions for the specified domain. For more information, see Amazon
	// Cognito Authentication for Kibana (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html).
	CognitoOptions *CognitoOptions `type:"structure"`

	// The domain creation status. True if the creation of an Elasticsearch domain
	// is complete. False if domain creation is still in progress.
	Created *bool `type:"boolean"`

	// The domain deletion status. True if a delete request has been received for
	// the domain but resource cleanup is still in progress. False if the domain
	// has not been deleted. Once domain deletion is complete, the status of the
	// domain is no longer returned.
	Deleted *bool `type:"boolean"`

	// The current status of the Elasticsearch domain's endpoint options.
	DomainEndpointOptions *DomainEndpointOptions `type:"structure"`

	// The unique identifier for the specified Elasticsearch domain.
	//
	// DomainId is a required field
	DomainId *string `min:"1" type:"string" required:"true"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// The EBSOptions for the specified domain. See Configuring EBS-based Storage
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs)
	// for more information.
	EBSOptions *EBSOptions `type:"structure"`

	// The type and number of instances in the domain cluster.
	//
	// ElasticsearchClusterConfig is a required field
	ElasticsearchClusterConfig *ElasticsearchClusterConfig `type:"structure" required:"true"`

	ElasticsearchVersion *string `type:"string"`

	// Specifies the status of the EncryptionAtRestOptions.
	EncryptionAtRestOptions *EncryptionAtRestOptions `type:"structure"`

	// The Elasticsearch domain endpoint that you use to submit index and search
	// requests.
	Endpoint *string `type:"string"`

	// Map containing the Elasticsearch domain endpoints used to submit index and
	// search requests. Example key, value: 'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com'.
	Endpoints map[string]*string `type:"map"`

	// Log publishing options for the given domain.
	LogPublishingOptions map[string]*LogPublishingOption `type:"map"`

	// Specifies the status of the NodeToNodeEncryptionOptions.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptions `type:"structure"`

	// The status of the Elasticsearch domain configuration. True if Amazon Elasticsearch
	// Service is processing configuration changes. False if the configuration is
	// active.
	Processing *bool `type:"boolean"`

	// The current status of the Elasticsearch domain's service software.
	ServiceSoftwareOptions *ServiceSoftwareOptions `type:"structure"`

	// Specifies the status of the SnapshotOptions
	SnapshotOptions *SnapshotOptions `type:"structure"`

	// The status of an Elasticsearch domain version upgrade. True if Amazon Elasticsearch
	// Service is undergoing a version upgrade. False if the configuration is active.
	UpgradeProcessing *bool `type:"boolean"`

	// The VPCOptions for the specified domain. For more information, see VPC Endpoints
	// for Amazon Elasticsearch Service Domains (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html).
	VPCOptions *VPCDerivedInfo `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchDomainStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchDomainStatus) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *ElasticsearchDomainStatus) SetARN(v string) *ElasticsearchDomainStatus {
	s.ARN = &v
	return s
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *ElasticsearchDomainStatus) SetAccessPolicies(v string) *ElasticsearchDomainStatus {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *ElasticsearchDomainStatus) SetAdvancedOptions(v map[string]*string) *ElasticsearchDomainStatus {
	s.AdvancedOptions = v
	return s
}

// SetAdvancedSecurityOptions sets the AdvancedSecurityOptions field's value.
func (s *ElasticsearchDomainStatus) SetAdvancedSecurityOptions(v *AdvancedSecurityOptions) *ElasticsearchDomainStatus {
	s.AdvancedSecurityOptions = v
	return s
}

// SetAutoTuneOptions sets the AutoTuneOptions field's value.
func (s *ElasticsearchDomainStatus) SetAutoTuneOptions(v *AutoTuneOptionsOutput) *ElasticsearchDomainStatus {
	s.AutoTuneOptions = v
	return s
}

// SetChangeProgressDetails sets the ChangeProgressDetails field's value.
func (s *ElasticsearchDomainStatus) SetChangeProgressDetails(v *ChangeProgressDetails) *ElasticsearchDomainStatus {
	s.ChangeProgressDetails = v
	return s
}

// SetCognitoOptions sets the CognitoOptions field's value.
func (s *ElasticsearchDomainStatus) SetCognitoOptions(v *CognitoOptions) *ElasticsearchDomainStatus {
	s.CognitoOptions = v
	return s
}

// SetCreated sets the Created field's value.
func (s *ElasticsearchDomainStatus) SetCreated(v bool) *ElasticsearchDomainStatus {
	s.Created = &v
	return s
}

// SetDeleted sets the Deleted field's value.
func (s *ElasticsearchDomainStatus) SetDeleted(v bool) *ElasticsearchDomainStatus {
	s.Deleted = &v
	return s
}

// SetDomainEndpointOptions sets the DomainEndpointOptions field's value.
func (s *ElasticsearchDomainStatus) SetDomainEndpointOptions(v *DomainEndpointOptions) *ElasticsearchDomainStatus {
	s.DomainEndpointOptions = v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *ElasticsearchDomainStatus) SetDomainId(v string) *ElasticsearchDomainStatus {
	s.DomainId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *ElasticsearchDomainStatus) SetDomainName(v string) *ElasticsearchDomainStatus {
	s.DomainName = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *ElasticsearchDomainStatus) SetEBSOptions(v *EBSOptions) *ElasticsearchDomainStatus {
	s.EBSOptions = v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *ElasticsearchDomainStatus) SetElasticsearchClusterConfig(v *ElasticsearchClusterConfig) *ElasticsearchDomainStatus {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *ElasticsearchDomainStatus) SetElasticsearchVersion(v string) *ElasticsearchDomainStatus {
	s.ElasticsearchVersion = &v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *ElasticsearchDomainStatus) SetEncryptionAtRestOptions(v *EncryptionAtRestOptions) *ElasticsearchDomainStatus {
	s.EncryptionAtRestOptions = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *ElasticsearchDomainStatus) SetEndpoint(v string) *ElasticsearchDomainStatus {
	s.Endpoint = &v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *ElasticsearchDomainStatus) SetEndpoints(v map[string]*string) *ElasticsearchDomainStatus {
	s.Endpoints = v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *ElasticsearchDomainStatus) SetLogPublishingOptions(v map[string]*LogPublishingOption) *ElasticsearchDomainStatus {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *ElasticsearchDomainStatus) SetNodeToNodeEncryptionOptions(v *NodeToNodeEncryptionOptions) *ElasticsearchDomainStatus {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetProcessing sets the Processing field's value.
func (s *ElasticsearchDomainStatus) SetProcessing(v bool) *ElasticsearchDomainStatus {
	s.Processing = &v
	return s
}

// SetServiceSoftwareOptions sets the ServiceSoftwareOptions field's value.
func (s *ElasticsearchDomainStatus) SetServiceSoftwareOptions(v *ServiceSoftwareOptions) *ElasticsearchDomainStatus {
	s.ServiceSoftwareOptions = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *ElasticsearchDomainStatus) SetSnapshotOptions(v *SnapshotOptions) *ElasticsearchDomainStatus {
	s.SnapshotOptions = v
	return s
}

// SetUpgradeProcessing sets the UpgradeProcessing field's value.
func (s *ElasticsearchDomainStatus) SetUpgradeProcessing(v bool) *ElasticsearchDomainStatus {
	s.UpgradeProcessing = &v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *ElasticsearchDomainStatus) SetVPCOptions(v *VPCDerivedInfo) *ElasticsearchDomainStatus {
	s.VPCOptions = v
	return s
}

// Status of the Elasticsearch version options for the specified Elasticsearch
// domain.
type ElasticsearchVersionStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the Elasticsearch version for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *string `type:"string" required:"true"`

	// Specifies the status of the Elasticsearch version options for the specified
	// Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchVersionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchVersionStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *ElasticsearchVersionStatus) SetOptions(v string) *ElasticsearchVersionStatus {
	s.Options = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ElasticsearchVersionStatus) SetStatus(v *OptionStatus) *ElasticsearchVersionStatus {
	s.Status = v
	return s
}

// Specifies the Encryption At Rest Options.
type EncryptionAtRestOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the option to enable Encryption At Rest.
	Enabled *bool `type:"boolean"`

	// Specifies the KMS Key ID for Encryption At Rest options.
	KmsKeyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionAtRestOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionAtRestOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionAtRestOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionAtRestOptions"}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *EncryptionAtRestOptions) SetEnabled(v bool) *EncryptionAtRestOptions {
	s.Enabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *EncryptionAtRestOptions) SetKmsKeyId(v string) *EncryptionAtRestOptions {
	s.KmsKeyId = &v
	return s
}

// Status of the Encryption At Rest options for the specified Elasticsearch
// domain.
type EncryptionAtRestOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the Encryption At Rest options for the specified Elasticsearch
	// domain.
	//
	// Options is a required field
	Options *EncryptionAtRestOptions `type:"structure" required:"true"`

	// Specifies the status of the Encryption At Rest options for the specified
	// Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionAtRestOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionAtRestOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *EncryptionAtRestOptionsStatus) SetOptions(v *EncryptionAtRestOptions) *EncryptionAtRestOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *EncryptionAtRestOptionsStatus) SetStatus(v *OptionStatus) *EncryptionAtRestOptionsStatus {
	s.Status = v
	return s
}

type ErrorDetails struct {
	_ struct{} `type:"structure"`

	ErrorMessage *string `type:"string"`

	ErrorType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorDetails) SetErrorMessage(v string) *ErrorDetails {
	s.ErrorMessage = &v
	return s
}

// SetErrorType sets the ErrorType field's value.
func (s *ErrorDetails) SetErrorType(v string) *ErrorDetails {
	s.ErrorType = &v
	return s
}

// A filter used to limit results when describing inbound or outbound cross-cluster
// search connections. Multiple values can be specified per filter. A cross-cluster
// search connection must match at least one of the specified values for it
// to be returned from an operation.
type Filter struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the filter.
	Name *string `min:"1" type:"string"`

	// Contains one or more values for the filter.
	Values []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

// Container for request parameters to GetCompatibleElasticsearchVersions operation.
type GetCompatibleElasticsearchVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	DomainName *string `location:"querystring" locationName:"domainName" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompatibleElasticsearchVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompatibleElasticsearchVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCompatibleElasticsearchVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCompatibleElasticsearchVersionsInput"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetCompatibleElasticsearchVersionsInput) SetDomainName(v string) *GetCompatibleElasticsearchVersionsInput {
	s.DomainName = &v
	return s
}

// Container for response returned by GetCompatibleElasticsearchVersions operation.
type GetCompatibleElasticsearchVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A map of compatible Elasticsearch versions returned as part of the GetCompatibleElasticsearchVersions
	// operation.
	CompatibleElasticsearchVersions []*CompatibleVersionsMap `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompatibleElasticsearchVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompatibleElasticsearchVersionsOutput) GoString() string {
	return s.String()
}

// SetCompatibleElasticsearchVersions sets the CompatibleElasticsearchVersions field's value.
func (s *GetCompatibleElasticsearchVersionsOutput) SetCompatibleElasticsearchVersions(v []*CompatibleVersionsMap) *GetCompatibleElasticsearchVersionsOutput {
	s.CompatibleElasticsearchVersions = v
	return s
}

// Container for request parameters to GetPackageVersionHistory operation.
type GetPackageVersionHistoryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Limits results to a maximum number of versions.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Used for pagination. Only necessary if a previous API call includes a non-null
	// NextToken value. If provided, returns results for the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Returns an audit history of versions of the package.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPackageVersionHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPackageVersionHistoryInput"}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageID != nil && len(*s.PackageID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetPackageVersionHistoryInput) SetMaxResults(v int64) *GetPackageVersionHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetPackageVersionHistoryInput) SetNextToken(v string) *GetPackageVersionHistoryInput {
	s.NextToken = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *GetPackageVersionHistoryInput) SetPackageID(v string) *GetPackageVersionHistoryInput {
	s.PackageID = &v
	return s
}

// Container for response returned by GetPackageVersionHistory operation.
type GetPackageVersionHistoryOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	PackageID *string `type:"string"`

	// List of PackageVersionHistory objects.
	PackageVersionHistoryList []*PackageVersionHistory `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionHistoryOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetPackageVersionHistoryOutput) SetNextToken(v string) *GetPackageVersionHistoryOutput {
	s.NextToken = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *GetPackageVersionHistoryOutput) SetPackageID(v string) *GetPackageVersionHistoryOutput {
	s.PackageID = &v
	return s
}

// SetPackageVersionHistoryList sets the PackageVersionHistoryList field's value.
func (s *GetPackageVersionHistoryOutput) SetPackageVersionHistoryList(v []*PackageVersionHistory) *GetPackageVersionHistoryOutput {
	s.PackageVersionHistoryList = v
	return s
}

// Container for request parameters to GetUpgradeHistory operation.
type GetUpgradeHistoryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Set this value to limit the number of results returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Paginated APIs accepts NextToken input to returns next page results and provides
	// a NextToken output in the response which can be used by the client to retrieve
	// more results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUpgradeHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUpgradeHistoryInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetUpgradeHistoryInput) SetDomainName(v string) *GetUpgradeHistoryInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetUpgradeHistoryInput) SetMaxResults(v int64) *GetUpgradeHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetUpgradeHistoryInput) SetNextToken(v string) *GetUpgradeHistoryInput {
	s.NextToken = &v
	return s
}

// Container for response returned by GetUpgradeHistory operation.
type GetUpgradeHistoryOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token that needs to be supplied to the next call to get the next
	// page of results
	NextToken *string `type:"string"`

	// A list of UpgradeHistory objects corresponding to each Upgrade or Upgrade
	// Eligibility Check performed on a domain returned as part of GetUpgradeHistoryResponse
	// object.
	UpgradeHistories []*UpgradeHistory `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeHistoryOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetUpgradeHistoryOutput) SetNextToken(v string) *GetUpgradeHistoryOutput {
	s.NextToken = &v
	return s
}

// SetUpgradeHistories sets the UpgradeHistories field's value.
func (s *GetUpgradeHistoryOutput) SetUpgradeHistories(v []*UpgradeHistory) *GetUpgradeHistoryOutput {
	s.UpgradeHistories = v
	return s
}

// Container for request parameters to GetUpgradeStatus operation.
type GetUpgradeStatusInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUpgradeStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUpgradeStatusInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetUpgradeStatusInput) SetDomainName(v string) *GetUpgradeStatusInput {
	s.DomainName = &v
	return s
}

// Container for response returned by GetUpgradeStatus operation.
type GetUpgradeStatusOutput struct {
	_ struct{} `type:"structure"`

	// One of 4 statuses that a step can go through returned as part of the GetUpgradeStatusResponse
	// object. The status can take one of the following values:
	//    * In Progress
	//
	//    * Succeeded
	//
	//    * Succeeded with Issues
	//
	//    * Failed
	StepStatus *string `type:"string" enum:"UpgradeStatus"`

	// A string that describes the update briefly
	UpgradeName *string `type:"string"`

	// Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does
	// through:
	//    * PreUpgradeCheck
	//
	//    * Snapshot
	//
	//    * Upgrade
	UpgradeStep *string `type:"string" enum:"UpgradeStep"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeStatusOutput) GoString() string {
	return s.String()
}

// SetStepStatus sets the StepStatus field's value.
func (s *GetUpgradeStatusOutput) SetStepStatus(v string) *GetUpgradeStatusOutput {
	s.StepStatus = &v
	return s
}

// SetUpgradeName sets the UpgradeName field's value.
func (s *GetUpgradeStatusOutput) SetUpgradeName(v string) *GetUpgradeStatusOutput {
	s.UpgradeName = &v
	return s
}

// SetUpgradeStep sets the UpgradeStep field's value.
func (s *GetUpgradeStatusOutput) SetUpgradeStep(v string) *GetUpgradeStatusOutput {
	s.UpgradeStep = &v
	return s
}

// Specifies details of an inbound connection.
type InboundCrossClusterSearchConnection struct {
	_ struct{} `type:"structure"`

	// Specifies the InboundCrossClusterSearchConnectionStatus for the outbound
	// connection.
	ConnectionStatus *InboundCrossClusterSearchConnectionStatus `type:"structure"`

	// Specifies the connection id for the inbound cross-cluster search connection.
	CrossClusterSearchConnectionId *string `type:"string"`

	// Specifies the DomainInformation for the destination Elasticsearch domain.
	DestinationDomainInfo *DomainInformation `type:"structure"`

	// Specifies the DomainInformation for the source Elasticsearch domain.
	SourceDomainInfo *DomainInformation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InboundCrossClusterSearchConnection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InboundCrossClusterSearchConnection) GoString() string {
	return s.String()
}

// SetConnectionStatus sets the ConnectionStatus field's value.
func (s *InboundCrossClusterSearchConnection) SetConnectionStatus(v *InboundCrossClusterSearchConnectionStatus) *InboundCrossClusterSearchConnection {
	s.ConnectionStatus = v
	return s
}

// SetCrossClusterSearchConnectionId sets the CrossClusterSearchConnectionId field's value.
func (s *InboundCrossClusterSearchConnection) SetCrossClusterSearchConnectionId(v string) *InboundCrossClusterSearchConnection {
	s.CrossClusterSearchConnectionId = &v
	return s
}

// SetDestinationDomainInfo sets the DestinationDomainInfo field's value.
func (s *InboundCrossClusterSearchConnection) SetDestinationDomainInfo(v *DomainInformation) *InboundCrossClusterSearchConnection {
	s.DestinationDomainInfo = v
	return s
}

// SetSourceDomainInfo sets the SourceDomainInfo field's value.
func (s *InboundCrossClusterSearchConnection) SetSourceDomainInfo(v *DomainInformation) *InboundCrossClusterSearchConnection {
	s.SourceDomainInfo = v
	return s
}

// Specifies the coonection status of an inbound cross-cluster search connection.
type InboundCrossClusterSearchConnectionStatus struct {
	_ struct{} `type:"structure"`

	// Specifies verbose information for the inbound connection status.
	Message *string `type:"string"`

	// The state code for inbound connection. This can be one of the following:
	//
	//    * PENDING_ACCEPTANCE: Inbound connection is not yet accepted by destination
	//    domain owner.
	//
	//    * APPROVED: Inbound connection is pending acceptance by destination domain
	//    owner.
	//
	//    * REJECTING: Inbound connection rejection is in process.
	//
	//    * REJECTED: Inbound connection is rejected.
	//
	//    * DELETING: Inbound connection deletion is in progress.
	//
	//    * DELETED: Inbound connection is deleted and cannot be used further.
	StatusCode *string `type:"string" enum:"InboundCrossClusterSearchConnectionStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InboundCrossClusterSearchConnectionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InboundCrossClusterSearchConnectionStatus) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *InboundCrossClusterSearchConnectionStatus) SetMessage(v string) *InboundCrossClusterSearchConnectionStatus {
	s.Message = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *InboundCrossClusterSearchConnectionStatus) SetStatusCode(v string) *InboundCrossClusterSearchConnectionStatus {
	s.StatusCode = &v
	return s
}

// InstanceCountLimits represents the limits on number of instances that be
// created in Amazon Elasticsearch for given InstanceType.
type InstanceCountLimits struct {
	_ struct{} `type:"structure"`

	// Maximum number of Instances that can be instantiated for given InstanceType.
	MaximumInstanceCount *int64 `type:"integer"`

	// Minimum number of Instances that can be instantiated for given InstanceType.
	MinimumInstanceCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceCountLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceCountLimits) GoString() string {
	return s.String()
}

// SetMaximumInstanceCount sets the MaximumInstanceCount field's value.
func (s *InstanceCountLimits) SetMaximumInstanceCount(v int64) *InstanceCountLimits {
	s.MaximumInstanceCount = &v
	return s
}

// SetMinimumInstanceCount sets the MinimumInstanceCount field's value.
func (s *InstanceCountLimits) SetMinimumInstanceCount(v int64) *InstanceCountLimits {
	s.MinimumInstanceCount = &v
	return s
}

// InstanceLimits represents the list of instance related attributes that are
// available for given InstanceType.
type InstanceLimits struct {
	_ struct{} `type:"structure"`

	// InstanceCountLimits represents the limits on number of instances that be
	// created in Amazon Elasticsearch for given InstanceType.
	InstanceCountLimits *InstanceCountLimits `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceLimits) GoString() string {
	return s.String()
}

// SetInstanceCountLimits sets the InstanceCountLimits field's value.
func (s *InstanceLimits) SetInstanceCountLimits(v *InstanceCountLimits) *InstanceLimits {
	s.InstanceCountLimits = v
	return s
}

// The request processing has failed because of an unknown error, exception
// or failure (the failure is internal to the service) . Gives http status code
// of 500.
type InternalException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) GoString() string {
	return s.String()
}

func newErrorInternalException(v protocol.ResponseMetadata) error {
	return &InternalException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalException) Code() string {
	return "InternalException"
}

// Message returns the exception's message.
func (s *InternalException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalException) OrigErr() error {
	return nil
}

func (s *InternalException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request processing has failed because of invalid pagination token provided
// by customer. Returns an HTTP status code of 400.
type InvalidPaginationTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPaginationTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPaginationTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidPaginationTokenException(v protocol.ResponseMetadata) error {
	return &InvalidPaginationTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPaginationTokenException) Code() string {
	return "InvalidPaginationTokenException"
}

// Message returns the exception's message.
func (s *InvalidPaginationTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPaginationTokenException) OrigErr() error {
	return nil
}

func (s *InvalidPaginationTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPaginationTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPaginationTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An exception for trying to create or access sub-resource that is either invalid
// or not supported. Gives http status code of 409.
type InvalidTypeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTypeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTypeException) GoString() string {
	return s.String()
}

func newErrorInvalidTypeException(v protocol.ResponseMetadata) error {
	return &InvalidTypeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTypeException) Code() string {
	return "InvalidTypeException"
}

// Message returns the exception's message.
func (s *InvalidTypeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTypeException) OrigErr() error {
	return nil
}

func (s *InvalidTypeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTypeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTypeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An exception for trying to create more than allowed resources or sub-resources.
// Gives http status code of 409.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Limits for given InstanceType and for each of it's role. Limits contains
// following StorageTypes, InstanceLimits and AdditionalLimits
type Limits struct {
	_ struct{} `type:"structure"`

	// List of additional limits that are specific to a given InstanceType and for
	// each of it's InstanceRole .
	AdditionalLimits []*AdditionalLimit `type:"list"`

	// InstanceLimits represents the list of instance related attributes that are
	// available for given InstanceType.
	InstanceLimits *InstanceLimits `type:"structure"`

	// StorageType represents the list of storage related types and attributes that
	// are available for given InstanceType.
	StorageTypes []*StorageType `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Limits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Limits) GoString() string {
	return s.String()
}

// SetAdditionalLimits sets the AdditionalLimits field's value.
func (s *Limits) SetAdditionalLimits(v []*AdditionalLimit) *Limits {
	s.AdditionalLimits = v
	return s
}

// SetInstanceLimits sets the InstanceLimits field's value.
func (s *Limits) SetInstanceLimits(v *InstanceLimits) *Limits {
	s.InstanceLimits = v
	return s
}

// SetStorageTypes sets the StorageTypes field's value.
func (s *Limits) SetStorageTypes(v []*StorageType) *Limits {
	s.StorageTypes = v
	return s
}

// Container for the parameters to the ListDomainNames operation.
type ListDomainNamesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Optional parameter to filter the output by domain engine type. Acceptable
	// values are 'Elasticsearch' and 'OpenSearch'.
	EngineType *string `location:"querystring" locationName:"engineType" type:"string" enum:"EngineType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainNamesInput) GoString() string {
	return s.String()
}

// SetEngineType sets the EngineType field's value.
func (s *ListDomainNamesInput) SetEngineType(v string) *ListDomainNamesInput {
	s.EngineType = &v
	return s
}

// The result of a ListDomainNames operation. Contains the names of all domains
// owned by this account and their respective engine types.
type ListDomainNamesOutput struct {
	_ struct{} `type:"structure"`

	// List of domain names and respective engine types.
	DomainNames []*DomainInfo `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainNamesOutput) GoString() string {
	return s.String()
}

// SetDomainNames sets the DomainNames field's value.
func (s *ListDomainNamesOutput) SetDomainNames(v []*DomainInfo) *ListDomainNamesOutput {
	s.DomainNames = v
	return s
}

// Container for request parameters to ListDomainsForPackage operation.
type ListDomainsForPackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Limits results to a maximum number of domains.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Used for pagination. Only necessary if a previous API call includes a non-null
	// NextToken value. If provided, returns results for the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The package for which to list domains.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsForPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsForPackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainsForPackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainsForPackageInput"}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageID != nil && len(*s.PackageID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDomainsForPackageInput) SetMaxResults(v int64) *ListDomainsForPackageInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsForPackageInput) SetNextToken(v string) *ListDomainsForPackageInput {
	s.NextToken = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *ListDomainsForPackageInput) SetPackageID(v string) *ListDomainsForPackageInput {
	s.PackageID = &v
	return s
}

// Container for response parameters to ListDomainsForPackage operation.
type ListDomainsForPackageOutput struct {
	_ struct{} `type:"structure"`

	// List of DomainPackageDetails objects.
	DomainPackageDetailsList []*DomainPackageDetails `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsForPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsForPackageOutput) GoString() string {
	return s.String()
}

// SetDomainPackageDetailsList sets the DomainPackageDetailsList field's value.
func (s *ListDomainsForPackageOutput) SetDomainPackageDetailsList(v []*DomainPackageDetails) *ListDomainsForPackageOutput {
	s.DomainPackageDetailsList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsForPackageOutput) SetNextToken(v string) *ListDomainsForPackageOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the ListElasticsearchInstanceTypes operation.
type ListElasticsearchInstanceTypesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// DomainName represents the name of the Domain that we are trying to modify.
	// This should be present only if we are querying for list of available Elasticsearch
	// instance types when modifying existing domain.
	DomainName *string `location:"querystring" locationName:"domainName" min:"3" type:"string"`

	// Version of Elasticsearch for which list of supported elasticsearch instance
	// types are needed.
	//
	// ElasticsearchVersion is a required field
	ElasticsearchVersion *string `location:"uri" locationName:"ElasticsearchVersion" type:"string" required:"true"`

	// Set this value to limit the number of results returned. Value provided must
	// be greater than 30 else it wont be honored.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// NextToken should be sent in case if earlier API call produced result containing
	// NextToken. It is used for pagination.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListElasticsearchInstanceTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListElasticsearchInstanceTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListElasticsearchInstanceTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListElasticsearchInstanceTypesInput"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.ElasticsearchVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ElasticsearchVersion"))
	}
	if s.ElasticsearchVersion != nil && len(*s.ElasticsearchVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ElasticsearchVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListElasticsearchInstanceTypesInput) SetDomainName(v string) *ListElasticsearchInstanceTypesInput {
	s.DomainName = &v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *ListElasticsearchInstanceTypesInput) SetElasticsearchVersion(v string) *ListElasticsearchInstanceTypesInput {
	s.ElasticsearchVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListElasticsearchInstanceTypesInput) SetMaxResults(v int64) *ListElasticsearchInstanceTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListElasticsearchInstanceTypesInput) SetNextToken(v string) *ListElasticsearchInstanceTypesInput {
	s.NextToken = &v
	return s
}

// Container for the parameters returned by ListElasticsearchInstanceTypes operation.
type ListElasticsearchInstanceTypesOutput struct {
	_ struct{} `type:"structure"`

	// List of instance types supported by Amazon Elasticsearch service for given
	// ElasticsearchVersion
	ElasticsearchInstanceTypes []*string `type:"list" enum:"ESPartitionInstanceType"`

	// In case if there are more results available NextToken would be present, make
	// further request to the same API with received NextToken to paginate remaining
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListElasticsearchInstanceTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListElasticsearchInstanceTypesOutput) GoString() string {
	return s.String()
}

// SetElasticsearchInstanceTypes sets the ElasticsearchInstanceTypes field's value.
func (s *ListElasticsearchInstanceTypesOutput) SetElasticsearchInstanceTypes(v []*string) *ListElasticsearchInstanceTypesOutput {
	s.ElasticsearchInstanceTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListElasticsearchInstanceTypesOutput) SetNextToken(v string) *ListElasticsearchInstanceTypesOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the ListElasticsearchVersions operation.
// Use MaxResults to control the maximum number of results to retrieve in a
// single call.
//
// Use NextToken in response to retrieve more results. If the received response
// does not contain a NextToken, then there are no more results to retrieve.
type ListElasticsearchVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Set this value to limit the number of results returned. Value provided must
	// be greater than 10 else it wont be honored.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Paginated APIs accepts NextToken input to returns next page results and provides
	// a NextToken output in the response which can be used by the client to retrieve
	// more results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListElasticsearchVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListElasticsearchVersionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListElasticsearchVersionsInput) SetMaxResults(v int64) *ListElasticsearchVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListElasticsearchVersionsInput) SetNextToken(v string) *ListElasticsearchVersionsInput {
	s.NextToken = &v
	return s
}

// Container for the parameters for response received from ListElasticsearchVersions
// operation.
type ListElasticsearchVersionsOutput struct {
	_ struct{} `type:"structure"`

	// List of supported elastic search versions.
	ElasticsearchVersions []*string `type:"list"`

	// Paginated APIs accepts NextToken input to returns next page results and provides
	// a NextToken output in the response which can be used by the client to retrieve
	// more results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListElasticsearchVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListElasticsearchVersionsOutput) GoString() string {
	return s.String()
}

// SetElasticsearchVersions sets the ElasticsearchVersions field's value.
func (s *ListElasticsearchVersionsOutput) SetElasticsearchVersions(v []*string) *ListElasticsearchVersionsOutput {
	s.ElasticsearchVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListElasticsearchVersionsOutput) SetNextToken(v string) *ListElasticsearchVersionsOutput {
	s.NextToken = &v
	return s
}

// Container for request parameters to ListPackagesForDomain operation.
type ListPackagesForDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain for which you want to list associated packages.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Limits results to a maximum number of packages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Used for pagination. Only necessary if a previous API call includes a non-null
	// NextToken value. If provided, returns results for the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesForDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesForDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPackagesForDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPackagesForDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListPackagesForDomainInput) SetDomainName(v string) *ListPackagesForDomainInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPackagesForDomainInput) SetMaxResults(v int64) *ListPackagesForDomainInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackagesForDomainInput) SetNextToken(v string) *ListPackagesForDomainInput {
	s.NextToken = &v
	return s
}

// Container for response parameters to ListPackagesForDomain operation.
type ListPackagesForDomainOutput struct {
	_ struct{} `type:"structure"`

	// List of DomainPackageDetails objects.
	DomainPackageDetailsList []*DomainPackageDetails `type:"list"`

	// Pagination token that needs to be supplied to the next call to get the next
	// page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesForDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesForDomainOutput) GoString() string {
	return s.String()
}

// SetDomainPackageDetailsList sets the DomainPackageDetailsList field's value.
func (s *ListPackagesForDomainOutput) SetDomainPackageDetailsList(v []*DomainPackageDetails) *ListPackagesForDomainOutput {
	s.DomainPackageDetailsList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackagesForDomainOutput) SetNextToken(v string) *ListPackagesForDomainOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the ListTags operation. Specify the ARN for
// the Elasticsearch domain to which the tags are attached that you want to
// view are attached.
type ListTagsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Specify the ARN for the Elasticsearch domain to which the tags are attached
	// that you want to view.
	//
	// ARN is a required field
	ARN *string `location:"querystring" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *ListTagsInput) SetARN(v string) *ListTagsInput {
	s.ARN = &v
	return s
}

// The result of a ListTags operation. Contains tags for all requested Elasticsearch
// domains.
type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// List of Tag for the requested Elasticsearch domain.
	TagList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsOutput) SetTagList(v []*Tag) *ListTagsOutput {
	s.TagList = v
	return s
}

// Log Publishing option that is set for given domain. Attributes and their
// details:
//
//   - CloudWatchLogsLogGroupArn: ARN of the Cloudwatch log group to which
//     log needs to be published.
//
//   - Enabled: Whether the log publishing for given log type is enabled or
//     not
type LogPublishingOption struct {
	_ struct{} `type:"structure"`

	// ARN of the Cloudwatch log group to which log needs to be published.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies whether given log publishing option is enabled or not.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogPublishingOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogPublishingOption) GoString() string {
	return s.String()
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *LogPublishingOption) SetCloudWatchLogsLogGroupArn(v string) *LogPublishingOption {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *LogPublishingOption) SetEnabled(v bool) *LogPublishingOption {
	s.Enabled = &v
	return s
}

// The configured log publishing options for the domain and their current status.
type LogPublishingOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The log publishing options configured for the Elasticsearch domain.
	Options map[string]*LogPublishingOption `type:"map"`

	// The status of the log publishing options for the Elasticsearch domain. See
	// OptionStatus for the status information that's included.
	Status *OptionStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogPublishingOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogPublishingOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *LogPublishingOptionsStatus) SetOptions(v map[string]*LogPublishingOption) *LogPublishingOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *LogPublishingOptionsStatus) SetStatus(v *OptionStatus) *LogPublishingOptionsStatus {
	s.Status = v
	return s
}

// Credentials for the master user: username and password, ARN, or both.
type MasterUserOptions struct {
	_ struct{} `type:"structure"`

	// ARN for the master user (if IAM is enabled).
	MasterUserARN *string `type:"string"`

	// The master user's username, which is stored in the Amazon Elasticsearch Service
	// domain's internal database.
	//
	// MasterUserName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by MasterUserOptions's
	// String and GoString methods.
	MasterUserName *string `min:"1" type:"string" sensitive:"true"`

	// The master user's password, which is stored in the Amazon Elasticsearch Service
	// domain's internal database.
	//
	// MasterUserPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by MasterUserOptions's
	// String and GoString methods.
	MasterUserPassword *string `min:"8" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MasterUserOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MasterUserOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MasterUserOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MasterUserOptions"}
	if s.MasterUserName != nil && len(*s.MasterUserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MasterUserName", 1))
	}
	if s.MasterUserPassword != nil && len(*s.MasterUserPassword) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("MasterUserPassword", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMasterUserARN sets the MasterUserARN field's value.
func (s *MasterUserOptions) SetMasterUserARN(v string) *MasterUserOptions {
	s.MasterUserARN = &v
	return s
}

// SetMasterUserName sets the MasterUserName field's value.
func (s *MasterUserOptions) SetMasterUserName(v string) *MasterUserOptions {
	s.MasterUserName = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *MasterUserOptions) SetMasterUserPassword(v string) *MasterUserOptions {
	s.MasterUserPassword = &v
	return s
}

// Specifies the node-to-node encryption options.
type NodeToNodeEncryptionOptions struct {
	_ struct{} `type:"structure"`

	// Specify true to enable node-to-node encryption.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeToNodeEncryptionOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeToNodeEncryptionOptions) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *NodeToNodeEncryptionOptions) SetEnabled(v bool) *NodeToNodeEncryptionOptions {
	s.Enabled = &v
	return s
}

// Status of the node-to-node encryption options for the specified Elasticsearch
// domain.
type NodeToNodeEncryptionOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the node-to-node encryption options for the specified Elasticsearch
	// domain.
	//
	// Options is a required field
	Options *NodeToNodeEncryptionOptions `type:"structure" required:"true"`

	// Specifies the status of the node-to-node encryption options for the specified
	// Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeToNodeEncryptionOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeToNodeEncryptionOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *NodeToNodeEncryptionOptionsStatus) SetOptions(v *NodeToNodeEncryptionOptions) *NodeToNodeEncryptionOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *NodeToNodeEncryptionOptionsStatus) SetStatus(v *OptionStatus) *NodeToNodeEncryptionOptionsStatus {
	s.Status = v
	return s
}

// Provides the current status of the entity.
type OptionStatus struct {
	_ struct{} `type:"structure"`

	// Timestamp which tells the creation date for the entity.
	//
	// CreationDate is a required field
	CreationDate *time.Time `type:"timestamp" required:"true"`

	// Indicates whether the Elasticsearch domain is being deleted.
	PendingDeletion *bool `type:"boolean"`

	// Provides the OptionState for the Elasticsearch domain.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"OptionState"`

	// Timestamp which tells the last updated time for the entity.
	//
	// UpdateDate is a required field
	UpdateDate *time.Time `type:"timestamp" required:"true"`

	// Specifies the latest version for the entity.
	UpdateVersion *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptionStatus) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *OptionStatus) SetCreationDate(v time.Time) *OptionStatus {
	s.CreationDate = &v
	return s
}

// SetPendingDeletion sets the PendingDeletion field's value.
func (s *OptionStatus) SetPendingDeletion(v bool) *OptionStatus {
	s.PendingDeletion = &v
	return s
}

// SetState sets the State field's value.
func (s *OptionStatus) SetState(v string) *OptionStatus {
	s.State = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *OptionStatus) SetUpdateDate(v time.Time) *OptionStatus {
	s.UpdateDate = &v
	return s
}

// SetUpdateVersion sets the UpdateVersion field's value.
func (s *OptionStatus) SetUpdateVersion(v int64) *OptionStatus {
	s.UpdateVersion = &v
	return s
}

// Specifies details of an outbound connection.
type OutboundCrossClusterSearchConnection struct {
	_ struct{} `type:"structure"`

	// Specifies the connection alias for the outbound cross-cluster search connection.
	ConnectionAlias *string `type:"string"`

	// Specifies the OutboundCrossClusterSearchConnectionStatus for the outbound
	// connection.
	ConnectionStatus *OutboundCrossClusterSearchConnectionStatus `type:"structure"`

	// Specifies the connection id for the outbound cross-cluster search connection.
	CrossClusterSearchConnectionId *string `type:"string"`

	// Specifies the DomainInformation for the destination Elasticsearch domain.
	DestinationDomainInfo *DomainInformation `type:"structure"`

	// Specifies the DomainInformation for the source Elasticsearch domain.
	SourceDomainInfo *DomainInformation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutboundCrossClusterSearchConnection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutboundCrossClusterSearchConnection) GoString() string {
	return s.String()
}

// SetConnectionAlias sets the ConnectionAlias field's value.
func (s *OutboundCrossClusterSearchConnection) SetConnectionAlias(v string) *OutboundCrossClusterSearchConnection {
	s.ConnectionAlias = &v
	return s
}

// SetConnectionStatus sets the ConnectionStatus field's value.
func (s *OutboundCrossClusterSearchConnection) SetConnectionStatus(v *OutboundCrossClusterSearchConnectionStatus) *OutboundCrossClusterSearchConnection {
	s.ConnectionStatus = v
	return s
}

// SetCrossClusterSearchConnectionId sets the CrossClusterSearchConnectionId field's value.
func (s *OutboundCrossClusterSearchConnection) SetCrossClusterSearchConnectionId(v string) *OutboundCrossClusterSearchConnection {
	s.CrossClusterSearchConnectionId = &v
	return s
}

// SetDestinationDomainInfo sets the DestinationDomainInfo field's value.
func (s *OutboundCrossClusterSearchConnection) SetDestinationDomainInfo(v *DomainInformation) *OutboundCrossClusterSearchConnection {
	s.DestinationDomainInfo = v
	return s
}

// SetSourceDomainInfo sets the SourceDomainInfo field's value.
func (s *OutboundCrossClusterSearchConnection) SetSourceDomainInfo(v *DomainInformation) *OutboundCrossClusterSearchConnection {
	s.SourceDomainInfo = v
	return s
}

// Specifies the connection status of an outbound cross-cluster search connection.
type OutboundCrossClusterSearchConnectionStatus struct {
	_ struct{} `type:"structure"`

	// Specifies verbose information for the outbound connection status.
	Message *string `type:"string"`

	// The state code for outbound connection. This can be one of the following:
	//
	//    * VALIDATING: The outbound connection request is being validated.
	//
	//    * VALIDATION_FAILED: Validation failed for the connection request.
	//
	//    * PENDING_ACCEPTANCE: Outbound connection request is validated and is
	//    not yet accepted by destination domain owner.
	//
	//    * PROVISIONING: Outbound connection request is in process.
	//
	//    * ACTIVE: Outbound connection is active and ready to use.
	//
	//    * REJECTED: Outbound connection request is rejected by destination domain
	//    owner.
	//
	//    * DELETING: Outbound connection deletion is in progress.
	//
	//    * DELETED: Outbound connection is deleted and cannot be used further.
	StatusCode *string `type:"string" enum:"OutboundCrossClusterSearchConnectionStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutboundCrossClusterSearchConnectionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutboundCrossClusterSearchConnectionStatus) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *OutboundCrossClusterSearchConnectionStatus) SetMessage(v string) *OutboundCrossClusterSearchConnectionStatus {
	s.Message = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *OutboundCrossClusterSearchConnectionStatus) SetStatusCode(v string) *OutboundCrossClusterSearchConnectionStatus {
	s.StatusCode = &v
	return s
}

// Basic information about a package.
type PackageDetails struct {
	_ struct{} `type:"structure"`

	AvailablePackageVersion *string `type:"string"`

	// Timestamp which tells creation date of the package.
	CreatedAt *time.Time `type:"timestamp"`

	// Additional information if the package is in an error state. Null otherwise.
	ErrorDetails *ErrorDetails `type:"structure"`

	LastUpdatedAt *time.Time `type:"timestamp"`

	// User-specified description of the package.
	PackageDescription *string `type:"string"`

	// Internal ID of the package.
	PackageID *string `type:"string"`

	// User specified name of the package.
	PackageName *string `min:"3" type:"string"`

	// Current state of the package. Values are COPYING/COPY_FAILED/AVAILABLE/DELETING/DELETE_FAILED
	PackageStatus *string `type:"string" enum:"PackageStatus"`

	// Currently supports only TXT-DICTIONARY.
	PackageType *string `type:"string" enum:"PackageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageDetails) GoString() string {
	return s.String()
}

// SetAvailablePackageVersion sets the AvailablePackageVersion field's value.
func (s *PackageDetails) SetAvailablePackageVersion(v string) *PackageDetails {
	s.AvailablePackageVersion = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *PackageDetails) SetCreatedAt(v time.Time) *PackageDetails {
	s.CreatedAt = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *PackageDetails) SetErrorDetails(v *ErrorDetails) *PackageDetails {
	s.ErrorDetails = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *PackageDetails) SetLastUpdatedAt(v time.Time) *PackageDetails {
	s.LastUpdatedAt = &v
	return s
}

// SetPackageDescription sets the PackageDescription field's value.
func (s *PackageDetails) SetPackageDescription(v string) *PackageDetails {
	s.PackageDescription = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *PackageDetails) SetPackageID(v string) *PackageDetails {
	s.PackageID = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *PackageDetails) SetPackageName(v string) *PackageDetails {
	s.PackageName = &v
	return s
}

// SetPackageStatus sets the PackageStatus field's value.
func (s *PackageDetails) SetPackageStatus(v string) *PackageDetails {
	s.PackageStatus = &v
	return s
}

// SetPackageType sets the PackageType field's value.
func (s *PackageDetails) SetPackageType(v string) *PackageDetails {
	s.PackageType = &v
	return s
}

// The S3 location for importing the package specified as S3BucketName and S3Key
type PackageSource struct {
	_ struct{} `type:"structure"`

	// Name of the bucket containing the package.
	S3BucketName *string `min:"3" type:"string"`

	// Key (file name) of the package.
	S3Key *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PackageSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PackageSource"}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *PackageSource) SetS3BucketName(v string) *PackageSource {
	s.S3BucketName = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *PackageSource) SetS3Key(v string) *PackageSource {
	s.S3Key = &v
	return s
}

// Details of a package version.
type PackageVersionHistory struct {
	_ struct{} `type:"structure"`

	// A message associated with the version.
	CommitMessage *string `type:"string"`

	// Timestamp which tells creation time of the package version.
	CreatedAt *time.Time `type:"timestamp"`

	// Version of the package.
	PackageVersion *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionHistory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionHistory) GoString() string {
	return s.String()
}

// SetCommitMessage sets the CommitMessage field's value.
func (s *PackageVersionHistory) SetCommitMessage(v string) *PackageVersionHistory {
	s.CommitMessage = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *PackageVersionHistory) SetCreatedAt(v time.Time) *PackageVersionHistory {
	s.CreatedAt = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *PackageVersionHistory) SetPackageVersion(v string) *PackageVersionHistory {
	s.PackageVersion = &v
	return s
}

// Container for parameters to PurchaseReservedElasticsearchInstanceOffering
type PurchaseReservedElasticsearchInstanceOfferingInput struct {
	_ struct{} `type:"structure"`

	// The number of Elasticsearch instances to reserve.
	InstanceCount *int64 `min:"1" type:"integer"`

	// A customer-specified identifier to track this reservation.
	//
	// ReservationName is a required field
	ReservationName *string `min:"5" type:"string" required:"true"`

	// The ID of the reserved Elasticsearch instance offering to purchase.
	//
	// ReservedElasticsearchInstanceOfferingId is a required field
	ReservedElasticsearchInstanceOfferingId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseReservedElasticsearchInstanceOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseReservedElasticsearchInstanceOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PurchaseReservedElasticsearchInstanceOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PurchaseReservedElasticsearchInstanceOfferingInput"}
	if s.InstanceCount != nil && *s.InstanceCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("InstanceCount", 1))
	}
	if s.ReservationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservationName"))
	}
	if s.ReservationName != nil && len(*s.ReservationName) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ReservationName", 5))
	}
	if s.ReservedElasticsearchInstanceOfferingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservedElasticsearchInstanceOfferingId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *PurchaseReservedElasticsearchInstanceOfferingInput) SetInstanceCount(v int64) *PurchaseReservedElasticsearchInstanceOfferingInput {
	s.InstanceCount = &v
	return s
}

// SetReservationName sets the ReservationName field's value.
func (s *PurchaseReservedElasticsearchInstanceOfferingInput) SetReservationName(v string) *PurchaseReservedElasticsearchInstanceOfferingInput {
	s.ReservationName = &v
	return s
}

// SetReservedElasticsearchInstanceOfferingId sets the ReservedElasticsearchInstanceOfferingId field's value.
func (s *PurchaseReservedElasticsearchInstanceOfferingInput) SetReservedElasticsearchInstanceOfferingId(v string) *PurchaseReservedElasticsearchInstanceOfferingInput {
	s.ReservedElasticsearchInstanceOfferingId = &v
	return s
}

// Represents the output of a PurchaseReservedElasticsearchInstanceOffering
// operation.
type PurchaseReservedElasticsearchInstanceOfferingOutput struct {
	_ struct{} `type:"structure"`

	// The customer-specified identifier used to track this reservation.
	ReservationName *string `min:"5" type:"string"`

	// Details of the reserved Elasticsearch instance which was purchased.
	ReservedElasticsearchInstanceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseReservedElasticsearchInstanceOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseReservedElasticsearchInstanceOfferingOutput) GoString() string {
	return s.String()
}

// SetReservationName sets the ReservationName field's value.
func (s *PurchaseReservedElasticsearchInstanceOfferingOutput) SetReservationName(v string) *PurchaseReservedElasticsearchInstanceOfferingOutput {
	s.ReservationName = &v
	return s
}

// SetReservedElasticsearchInstanceId sets the ReservedElasticsearchInstanceId field's value.
func (s *PurchaseReservedElasticsearchInstanceOfferingOutput) SetReservedElasticsearchInstanceId(v string) *PurchaseReservedElasticsearchInstanceOfferingOutput {
	s.ReservedElasticsearchInstanceId = &v
	return s
}

// Contains the specific price and frequency of a recurring charges for a reserved
// Elasticsearch instance, or for a reserved Elasticsearch instance offering.
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The monetary amount of the recurring charge.
	RecurringChargeAmount *float64 `type:"double"`

	// The frequency of the recurring charge.
	RecurringChargeFrequency *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecurringCharge) GoString() string {
	return s.String()
}

// SetRecurringChargeAmount sets the RecurringChargeAmount field's value.
func (s *RecurringCharge) SetRecurringChargeAmount(v float64) *RecurringCharge {
	s.RecurringChargeAmount = &v
	return s
}

// SetRecurringChargeFrequency sets the RecurringChargeFrequency field's value.
func (s *RecurringCharge) SetRecurringChargeFrequency(v string) *RecurringCharge {
	s.RecurringChargeFrequency = &v
	return s
}

// Container for the parameters to the RejectInboundCrossClusterSearchConnection
// operation.
type RejectInboundCrossClusterSearchConnectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The id of the inbound connection that you want to reject.
	//
	// CrossClusterSearchConnectionId is a required field
	CrossClusterSearchConnectionId *string `location:"uri" locationName:"ConnectionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectInboundCrossClusterSearchConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectInboundCrossClusterSearchConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectInboundCrossClusterSearchConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectInboundCrossClusterSearchConnectionInput"}
	if s.CrossClusterSearchConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CrossClusterSearchConnectionId"))
	}
	if s.CrossClusterSearchConnectionId != nil && len(*s.CrossClusterSearchConnectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CrossClusterSearchConnectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrossClusterSearchConnectionId sets the CrossClusterSearchConnectionId field's value.
func (s *RejectInboundCrossClusterSearchConnectionInput) SetCrossClusterSearchConnectionId(v string) *RejectInboundCrossClusterSearchConnectionInput {
	s.CrossClusterSearchConnectionId = &v
	return s
}

// The result of a RejectInboundCrossClusterSearchConnection operation. Contains
// details of rejected inbound connection.
type RejectInboundCrossClusterSearchConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the InboundCrossClusterSearchConnection of rejected inbound connection.
	CrossClusterSearchConnection *InboundCrossClusterSearchConnection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectInboundCrossClusterSearchConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectInboundCrossClusterSearchConnectionOutput) GoString() string {
	return s.String()
}

// SetCrossClusterSearchConnection sets the CrossClusterSearchConnection field's value.
func (s *RejectInboundCrossClusterSearchConnectionOutput) SetCrossClusterSearchConnection(v *InboundCrossClusterSearchConnection) *RejectInboundCrossClusterSearchConnectionOutput {
	s.CrossClusterSearchConnection = v
	return s
}

// Container for the parameters to the RemoveTags operation. Specify the ARN
// for the Elasticsearch domain from which you want to remove the specified
// TagKey.
type RemoveTagsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN for the Elasticsearch domain from which you want to delete
	// the specified tags.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// Specifies the TagKey list which you want to remove from the Elasticsearch
	// domain.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *RemoveTagsInput) SetARN(v string) *RemoveTagsInput {
	s.ARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsInput) SetTagKeys(v []*string) *RemoveTagsInput {
	s.TagKeys = v
	return s
}

type RemoveTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsOutput) GoString() string {
	return s.String()
}

// Details of a reserved Elasticsearch instance.
type ReservedElasticsearchInstance struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved Elasticsearch instance offering.
	CurrencyCode *string `type:"string"`

	// The duration, in seconds, for which the Elasticsearch instance is reserved.
	Duration *int64 `type:"integer"`

	// The number of Elasticsearch instances that have been reserved.
	ElasticsearchInstanceCount *int64 `type:"integer"`

	// The Elasticsearch instance type offered by the reserved instance offering.
	ElasticsearchInstanceType *string `type:"string" enum:"ESPartitionInstanceType"`

	// The upfront fixed charge you will paid to purchase the specific reserved
	// Elasticsearch instance offering.
	FixedPrice *float64 `type:"double"`

	// The payment option as defined in the reserved Elasticsearch instance offering.
	PaymentOption *string `type:"string" enum:"ReservedElasticsearchInstancePaymentOption"`

	// The charge to your account regardless of whether you are creating any domains
	// using the instance offering.
	RecurringCharges []*RecurringCharge `type:"list"`

	// The customer-specified identifier to track this reservation.
	ReservationName *string `min:"5" type:"string"`

	// The unique identifier for the reservation.
	ReservedElasticsearchInstanceId *string `type:"string"`

	// The offering identifier.
	ReservedElasticsearchInstanceOfferingId *string `type:"string"`

	// The time the reservation started.
	StartTime *time.Time `type:"timestamp"`

	// The state of the reserved Elasticsearch instance.
	State *string `type:"string"`

	// The rate you are charged for each hour for the domain that is using this
	// reserved instance.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservedElasticsearchInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservedElasticsearchInstance) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservedElasticsearchInstance) SetCurrencyCode(v string) *ReservedElasticsearchInstance {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ReservedElasticsearchInstance) SetDuration(v int64) *ReservedElasticsearchInstance {
	s.Duration = &v
	return s
}

// SetElasticsearchInstanceCount sets the ElasticsearchInstanceCount field's value.
func (s *ReservedElasticsearchInstance) SetElasticsearchInstanceCount(v int64) *ReservedElasticsearchInstance {
	s.ElasticsearchInstanceCount = &v
	return s
}

// SetElasticsearchInstanceType sets the ElasticsearchInstanceType field's value.
func (s *ReservedElasticsearchInstance) SetElasticsearchInstanceType(v string) *ReservedElasticsearchInstance {
	s.ElasticsearchInstanceType = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *ReservedElasticsearchInstance) SetFixedPrice(v float64) *ReservedElasticsearchInstance {
	s.FixedPrice = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *ReservedElasticsearchInstance) SetPaymentOption(v string) *ReservedElasticsearchInstance {
	s.PaymentOption = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *ReservedElasticsearchInstance) SetRecurringCharges(v []*RecurringCharge) *ReservedElasticsearchInstance {
	s.RecurringCharges = v
	return s
}

// SetReservationName sets the ReservationName field's value.
func (s *ReservedElasticsearchInstance) SetReservationName(v string) *ReservedElasticsearchInstance {
	s.ReservationName = &v
	return s
}

// SetReservedElasticsearchInstanceId sets the ReservedElasticsearchInstanceId field's value.
func (s *ReservedElasticsearchInstance) SetReservedElasticsearchInstanceId(v string) *ReservedElasticsearchInstance {
	s.ReservedElasticsearchInstanceId = &v
	return s
}

// SetReservedElasticsearchInstanceOfferingId sets the ReservedElasticsearchInstanceOfferingId field's value.
func (s *ReservedElasticsearchInstance) SetReservedElasticsearchInstanceOfferingId(v string) *ReservedElasticsearchInstance {
	s.ReservedElasticsearchInstanceOfferingId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ReservedElasticsearchInstance) SetStartTime(v time.Time) *ReservedElasticsearchInstance {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *ReservedElasticsearchInstance) SetState(v string) *ReservedElasticsearchInstance {
	s.State = &v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *ReservedElasticsearchInstance) SetUsagePrice(v float64) *ReservedElasticsearchInstance {
	s.UsagePrice = &v
	return s
}

// Details of a reserved Elasticsearch instance offering.
type ReservedElasticsearchInstanceOffering struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved Elasticsearch instance offering.
	CurrencyCode *string `type:"string"`

	// The duration, in seconds, for which the offering will reserve the Elasticsearch
	// instance.
	Duration *int64 `type:"integer"`

	// The Elasticsearch instance type offered by the reserved instance offering.
	ElasticsearchInstanceType *string `type:"string" enum:"ESPartitionInstanceType"`

	// The upfront fixed charge you will pay to purchase the specific reserved Elasticsearch
	// instance offering.
	FixedPrice *float64 `type:"double"`

	// Payment option for the reserved Elasticsearch instance offering
	PaymentOption *string `type:"string" enum:"ReservedElasticsearchInstancePaymentOption"`

	// The charge to your account regardless of whether you are creating any domains
	// using the instance offering.
	RecurringCharges []*RecurringCharge `type:"list"`

	// The Elasticsearch reserved instance offering identifier.
	ReservedElasticsearchInstanceOfferingId *string `type:"string"`

	// The rate you are charged for each hour the domain that is using the offering
	// is running.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservedElasticsearchInstanceOffering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservedElasticsearchInstanceOffering) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservedElasticsearchInstanceOffering) SetCurrencyCode(v string) *ReservedElasticsearchInstanceOffering {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ReservedElasticsearchInstanceOffering) SetDuration(v int64) *ReservedElasticsearchInstanceOffering {
	s.Duration = &v
	return s
}

// SetElasticsearchInstanceType sets the ElasticsearchInstanceType field's value.
func (s *ReservedElasticsearchInstanceOffering) SetElasticsearchInstanceType(v string) *ReservedElasticsearchInstanceOffering {
	s.ElasticsearchInstanceType = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *ReservedElasticsearchInstanceOffering) SetFixedPrice(v float64) *ReservedElasticsearchInstanceOffering {
	s.FixedPrice = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *ReservedElasticsearchInstanceOffering) SetPaymentOption(v string) *ReservedElasticsearchInstanceOffering {
	s.PaymentOption = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *ReservedElasticsearchInstanceOffering) SetRecurringCharges(v []*RecurringCharge) *ReservedElasticsearchInstanceOffering {
	s.RecurringCharges = v
	return s
}

// SetReservedElasticsearchInstanceOfferingId sets the ReservedElasticsearchInstanceOfferingId field's value.
func (s *ReservedElasticsearchInstanceOffering) SetReservedElasticsearchInstanceOfferingId(v string) *ReservedElasticsearchInstanceOffering {
	s.ReservedElasticsearchInstanceOfferingId = &v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *ReservedElasticsearchInstanceOffering) SetUsagePrice(v float64) *ReservedElasticsearchInstanceOffering {
	s.UsagePrice = &v
	return s
}

// An exception for creating a resource that already exists. Gives http status
// code of 400.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An exception for accessing or deleting a resource that does not exist. Gives
// http status code of 400.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the SAML Identity Provider's information.
type SAMLIdp struct {
	_ struct{} `type:"structure"`

	// The unique Entity ID of the application in SAML Identity Provider.
	//
	// EntityId is a required field
	EntityId *string `min:"8" type:"string" required:"true"`

	// The Metadata of the SAML application in xml format.
	//
	// MetadataContent is a required field
	MetadataContent *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLIdp) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLIdp) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SAMLIdp) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SAMLIdp"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 8))
	}
	if s.MetadataContent == nil {
		invalidParams.Add(request.NewErrParamRequired("MetadataContent"))
	}
	if s.MetadataContent != nil && len(*s.MetadataContent) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetadataContent", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *SAMLIdp) SetEntityId(v string) *SAMLIdp {
	s.EntityId = &v
	return s
}

// SetMetadataContent sets the MetadataContent field's value.
func (s *SAMLIdp) SetMetadataContent(v string) *SAMLIdp {
	s.MetadataContent = &v
	return s
}

// Specifies the SAML application configuration for the domain.
type SAMLOptionsInput struct {
	_ struct{} `type:"structure"`

	// True if SAML is enabled.
	Enabled *bool `type:"boolean"`

	// Specifies the SAML Identity Provider's information.
	Idp *SAMLIdp `type:"structure"`

	// The backend role to which the SAML master user is mapped to.
	MasterBackendRole *string `min:"1" type:"string"`

	// The SAML master username, which is stored in the Amazon Elasticsearch Service
	// domain's internal database.
	//
	// MasterUserName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SAMLOptionsInput's
	// String and GoString methods.
	MasterUserName *string `min:"1" type:"string" sensitive:"true"`

	// The key to use for matching the SAML Roles attribute.
	RolesKey *string `type:"string"`

	// The duration, in minutes, after which a user session becomes inactive. Acceptable
	// values are between 1 and 1440, and the default value is 60.
	SessionTimeoutMinutes *int64 `type:"integer"`

	// The key to use for matching the SAML Subject attribute.
	SubjectKey *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SAMLOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SAMLOptionsInput"}
	if s.MasterBackendRole != nil && len(*s.MasterBackendRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MasterBackendRole", 1))
	}
	if s.MasterUserName != nil && len(*s.MasterUserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MasterUserName", 1))
	}
	if s.Idp != nil {
		if err := s.Idp.Validate(); err != nil {
			invalidParams.AddNested("Idp", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *SAMLOptionsInput) SetEnabled(v bool) *SAMLOptionsInput {
	s.Enabled = &v
	return s
}

// SetIdp sets the Idp field's value.
func (s *SAMLOptionsInput) SetIdp(v *SAMLIdp) *SAMLOptionsInput {
	s.Idp = v
	return s
}

// SetMasterBackendRole sets the MasterBackendRole field's value.
func (s *SAMLOptionsInput) SetMasterBackendRole(v string) *SAMLOptionsInput {
	s.MasterBackendRole = &v
	return s
}

// SetMasterUserName sets the MasterUserName field's value.
func (s *SAMLOptionsInput) SetMasterUserName(v string) *SAMLOptionsInput {
	s.MasterUserName = &v
	return s
}

// SetRolesKey sets the RolesKey field's value.
func (s *SAMLOptionsInput) SetRolesKey(v string) *SAMLOptionsInput {
	s.RolesKey = &v
	return s
}

// SetSessionTimeoutMinutes sets the SessionTimeoutMinutes field's value.
func (s *SAMLOptionsInput) SetSessionTimeoutMinutes(v int64) *SAMLOptionsInput {
	s.SessionTimeoutMinutes = &v
	return s
}

// SetSubjectKey sets the SubjectKey field's value.
func (s *SAMLOptionsInput) SetSubjectKey(v string) *SAMLOptionsInput {
	s.SubjectKey = &v
	return s
}

// Describes the SAML application configured for the domain.
type SAMLOptionsOutput struct {
	_ struct{} `type:"structure"`

	// True if SAML is enabled.
	Enabled *bool `type:"boolean"`

	// Describes the SAML Identity Provider's information.
	Idp *SAMLIdp `type:"structure"`

	// The key used for matching the SAML Roles attribute.
	RolesKey *string `type:"string"`

	// The duration, in minutes, after which a user session becomes inactive.
	SessionTimeoutMinutes *int64 `type:"integer"`

	// The key used for matching the SAML Subject attribute.
	SubjectKey *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLOptionsOutput) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *SAMLOptionsOutput) SetEnabled(v bool) *SAMLOptionsOutput {
	s.Enabled = &v
	return s
}

// SetIdp sets the Idp field's value.
func (s *SAMLOptionsOutput) SetIdp(v *SAMLIdp) *SAMLOptionsOutput {
	s.Idp = v
	return s
}

// SetRolesKey sets the RolesKey field's value.
func (s *SAMLOptionsOutput) SetRolesKey(v string) *SAMLOptionsOutput {
	s.RolesKey = &v
	return s
}

// SetSessionTimeoutMinutes sets the SessionTimeoutMinutes field's value.
func (s *SAMLOptionsOutput) SetSessionTimeoutMinutes(v int64) *SAMLOptionsOutput {
	s.SessionTimeoutMinutes = &v
	return s
}

// SetSubjectKey sets the SubjectKey field's value.
func (s *SAMLOptionsOutput) SetSubjectKey(v string) *SAMLOptionsOutput {
	s.SubjectKey = &v
	return s
}

// Specifies details of the scheduled Auto-Tune action. See the Developer Guide
// (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
// for more information.
type ScheduledAutoTuneDetails struct {
	_ struct{} `type:"structure"`

	// Specifies Auto-Tune action description.
	Action *string `type:"string"`

	// Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and
	// JVM_YOUNG_GEN_TUNING.
	ActionType *string `type:"string" enum:"ScheduledAutoTuneActionType"`

	// Specifies timestamp for the Auto-Tune action scheduled for the domain.
	Date *time.Time `type:"timestamp"`

	// Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH.
	Severity *string `type:"string" enum:"ScheduledAutoTuneSeverityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledAutoTuneDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledAutoTuneDetails) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ScheduledAutoTuneDetails) SetAction(v string) *ScheduledAutoTuneDetails {
	s.Action = &v
	return s
}

// SetActionType sets the ActionType field's value.
func (s *ScheduledAutoTuneDetails) SetActionType(v string) *ScheduledAutoTuneDetails {
	s.ActionType = &v
	return s
}

// SetDate sets the Date field's value.
func (s *ScheduledAutoTuneDetails) SetDate(v time.Time) *ScheduledAutoTuneDetails {
	s.Date = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ScheduledAutoTuneDetails) SetSeverity(v string) *ScheduledAutoTuneDetails {
	s.Severity = &v
	return s
}

// The current options of an Elasticsearch domain service software options.
type ServiceSoftwareOptions struct {
	_ struct{} `type:"structure"`

	// Timestamp, in Epoch time, until which you can manually request a service
	// software update. After this date, we automatically update your service software.
	AutomatedUpdateDate *time.Time `type:"timestamp"`

	// True if you are able to cancel your service software version update. False
	// if you are not able to cancel your service software version.
	Cancellable *bool `type:"boolean"`

	// The current service software version that is present on the domain.
	CurrentVersion *string `type:"string"`

	// The description of the UpdateStatus.
	Description *string `type:"string"`

	// The new service software version if one is available.
	NewVersion *string `type:"string"`

	// True if a service software is never automatically updated. False if a service
	// software is automatically updated after AutomatedUpdateDate.
	OptionalDeployment *bool `type:"boolean"`

	// True if you are able to update you service software version. False if you
	// are not able to update your service software version.
	UpdateAvailable *bool `type:"boolean"`

	// The status of your service software update. This field can take the following
	// values: ELIGIBLE, PENDING_UPDATE, IN_PROGRESS, COMPLETED, and NOT_ELIGIBLE.
	UpdateStatus *string `type:"string" enum:"DeploymentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSoftwareOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSoftwareOptions) GoString() string {
	return s.String()
}

// SetAutomatedUpdateDate sets the AutomatedUpdateDate field's value.
func (s *ServiceSoftwareOptions) SetAutomatedUpdateDate(v time.Time) *ServiceSoftwareOptions {
	s.AutomatedUpdateDate = &v
	return s
}

// SetCancellable sets the Cancellable field's value.
func (s *ServiceSoftwareOptions) SetCancellable(v bool) *ServiceSoftwareOptions {
	s.Cancellable = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *ServiceSoftwareOptions) SetCurrentVersion(v string) *ServiceSoftwareOptions {
	s.CurrentVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ServiceSoftwareOptions) SetDescription(v string) *ServiceSoftwareOptions {
	s.Description = &v
	return s
}

// SetNewVersion sets the NewVersion field's value.
func (s *ServiceSoftwareOptions) SetNewVersion(v string) *ServiceSoftwareOptions {
	s.NewVersion = &v
	return s
}

// SetOptionalDeployment sets the OptionalDeployment field's value.
func (s *ServiceSoftwareOptions) SetOptionalDeployment(v bool) *ServiceSoftwareOptions {
	s.OptionalDeployment = &v
	return s
}

// SetUpdateAvailable sets the UpdateAvailable field's value.
func (s *ServiceSoftwareOptions) SetUpdateAvailable(v bool) *ServiceSoftwareOptions {
	s.UpdateAvailable = &v
	return s
}

// SetUpdateStatus sets the UpdateStatus field's value.
func (s *ServiceSoftwareOptions) SetUpdateStatus(v string) *ServiceSoftwareOptions {
	s.UpdateStatus = &v
	return s
}

// Specifies the time, in UTC format, when the service takes a daily automated
// snapshot of the specified Elasticsearch domain. Default value is 0 hours.
type SnapshotOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the time, in UTC format, when the service takes a daily automated
	// snapshot of the specified Elasticsearch domain. Default value is 0 hours.
	AutomatedSnapshotStartHour *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotOptions) GoString() string {
	return s.String()
}

// SetAutomatedSnapshotStartHour sets the AutomatedSnapshotStartHour field's value.
func (s *SnapshotOptions) SetAutomatedSnapshotStartHour(v int64) *SnapshotOptions {
	s.AutomatedSnapshotStartHour = &v
	return s
}

// Status of a daily automated snapshot.
type SnapshotOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the daily snapshot options specified for the Elasticsearch domain.
	//
	// Options is a required field
	Options *SnapshotOptions `type:"structure" required:"true"`

	// Specifies the status of a daily automated snapshot.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *SnapshotOptionsStatus) SetOptions(v *SnapshotOptions) *SnapshotOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *SnapshotOptionsStatus) SetStatus(v *OptionStatus) *SnapshotOptionsStatus {
	s.Status = v
	return s
}

// Container for the parameters to the StartElasticsearchServiceSoftwareUpdate
// operation. Specifies the name of the Elasticsearch domain that you wish to
// schedule a service software update on.
type StartElasticsearchServiceSoftwareUpdateInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that you want to update to the latest service software.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartElasticsearchServiceSoftwareUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartElasticsearchServiceSoftwareUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartElasticsearchServiceSoftwareUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartElasticsearchServiceSoftwareUpdateInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *StartElasticsearchServiceSoftwareUpdateInput) SetDomainName(v string) *StartElasticsearchServiceSoftwareUpdateInput {
	s.DomainName = &v
	return s
}

// The result of a StartElasticsearchServiceSoftwareUpdate operation. Contains
// the status of the update.
type StartElasticsearchServiceSoftwareUpdateOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the Elasticsearch service software update.
	ServiceSoftwareOptions *ServiceSoftwareOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartElasticsearchServiceSoftwareUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartElasticsearchServiceSoftwareUpdateOutput) GoString() string {
	return s.String()
}

// SetServiceSoftwareOptions sets the ServiceSoftwareOptions field's value.
func (s *StartElasticsearchServiceSoftwareUpdateOutput) SetServiceSoftwareOptions(v *ServiceSoftwareOptions) *StartElasticsearchServiceSoftwareUpdateOutput {
	s.ServiceSoftwareOptions = v
	return s
}

// StorageTypes represents the list of storage related types and their attributes
// that are available for given InstanceType.
type StorageType struct {
	_ struct{} `type:"structure"`

	// SubType of the given storage type. List of available sub-storage options:
	// For "instance" storageType we wont have any storageSubType, in case of "ebs"
	// storageType we will have following valid storageSubTypes standard gp2 gp3
	// io1 Refer VolumeType for more information regarding above EBS storage options.
	StorageSubTypeName *string `type:"string"`

	// List of limits that are applicable for given storage type.
	StorageTypeLimits []*StorageTypeLimit `type:"list"`

	// Type of the storage. List of available storage options: instance Inbuilt
	// storage available for the given Instance ebs Elastic block storage that would
	// be attached to the given Instance
	StorageTypeName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageType) GoString() string {
	return s.String()
}

// SetStorageSubTypeName sets the StorageSubTypeName field's value.
func (s *StorageType) SetStorageSubTypeName(v string) *StorageType {
	s.StorageSubTypeName = &v
	return s
}

// SetStorageTypeLimits sets the StorageTypeLimits field's value.
func (s *StorageType) SetStorageTypeLimits(v []*StorageTypeLimit) *StorageType {
	s.StorageTypeLimits = v
	return s
}

// SetStorageTypeName sets the StorageTypeName field's value.
func (s *StorageType) SetStorageTypeName(v string) *StorageType {
	s.StorageTypeName = &v
	return s
}

// Limits that are applicable for given storage type.
type StorageTypeLimit struct {
	_ struct{} `type:"structure"`

	// Name of storage limits that are applicable for given storage type. If StorageType
	// is ebs, following storage options are applicable MinimumVolumeSize Minimum
	// amount of volume size that is applicable for given storage type.It can be
	// empty if it is not applicable. MaximumVolumeSize Maximum amount of volume
	// size that is applicable for given storage type.It can be empty if it is not
	// applicable. MaximumIops Maximum amount of Iops that is applicable for given
	// storage type.It can be empty if it is not applicable. MinimumIops Minimum
	// amount of Iops that is applicable for given storage type.It can be empty
	// if it is not applicable. MaximumThroughput Maximum amount of Throughput that
	// is applicable for given storage type.It can be empty if it is not applicable.
	// MinimumThroughput Minimum amount of Throughput that is applicable for given
	// storage type.It can be empty if it is not applicable.
	LimitName *string `type:"string"`

	// Values for the StorageTypeLimit$LimitName .
	LimitValues []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageTypeLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageTypeLimit) GoString() string {
	return s.String()
}

// SetLimitName sets the LimitName field's value.
func (s *StorageTypeLimit) SetLimitName(v string) *StorageTypeLimit {
	s.LimitName = &v
	return s
}

// SetLimitValues sets the LimitValues field's value.
func (s *StorageTypeLimit) SetLimitValues(v []*string) *StorageTypeLimit {
	s.LimitValues = v
	return s
}

// Specifies a key value pair for a resource tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// Specifies the TagKey, the name of the tag. Tag keys must be unique for the
	// Elasticsearch domain to which they are attached.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Specifies the TagValue, the value assigned to the corresponding tag key.
	// Tag values can be null and do not have to be unique in a tag set. For example,
	// you can have a key value pair in a tag set of project : Trinity and cost-center
	// : Trinity
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Container for the parameters to the UpdateElasticsearchDomain operation.
// Specifies the type and number of instances in the domain cluster.
type UpdateElasticsearchDomainConfigInput struct {
	_ struct{} `type:"structure"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// Modifies the advanced option to allow references to indices in an HTTP request
	// body. Must be false when configuring access to individual sub-resources.
	// By default, the value is true. See Configuration Advanced Options (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions map[string]*string `type:"map"`

	// Specifies advanced security options.
	AdvancedSecurityOptions *AdvancedSecurityOptionsInput `type:"structure"`

	// Specifies Auto-Tune options.
	AutoTuneOptions *AutoTuneOptions `type:"structure"`

	// Options to specify the Cognito user and identity pools for Kibana authentication.
	// For more information, see Amazon Cognito Authentication for Kibana (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html).
	CognitoOptions *CognitoOptions `type:"structure"`

	// Options to specify configuration that will be applied to the domain endpoint.
	DomainEndpointOptions *DomainEndpointOptions `type:"structure"`

	// The name of the Elasticsearch domain that you are updating.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// This flag, when set to True, specifies whether the UpdateElasticsearchDomain
	// request should return the results of validation checks without actually applying
	// the change. This flag, when set to True, specifies the deployment mechanism
	// through which the update shall be applied on the domain. This will not actually
	// perform the Update.
	DryRun *bool `type:"boolean"`

	// Specify the type and size of the EBS volume that you want to use.
	EBSOptions *EBSOptions `type:"structure"`

	// The type and number of instances to instantiate for the domain cluster.
	ElasticsearchClusterConfig *ElasticsearchClusterConfig `type:"structure"`

	// Specifies the Encryption At Rest Options.
	EncryptionAtRestOptions *EncryptionAtRestOptions `type:"structure"`

	// Map of LogType and LogPublishingOption, each containing options to publish
	// a given type of Elasticsearch log.
	LogPublishingOptions map[string]*LogPublishingOption `type:"map"`

	// Specifies the NodeToNodeEncryptionOptions.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptions `type:"structure"`

	// Option to set the time, in UTC format, for the daily automated snapshot.
	// Default value is 0 hours.
	SnapshotOptions *SnapshotOptions `type:"structure"`

	// Options to specify the subnets and security groups for VPC endpoint. For
	// more information, see Creating a VPC (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc)
	// in VPC Endpoints for Amazon Elasticsearch Service Domains
	VPCOptions *VPCOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateElasticsearchDomainConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateElasticsearchDomainConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateElasticsearchDomainConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateElasticsearchDomainConfigInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.AdvancedSecurityOptions != nil {
		if err := s.AdvancedSecurityOptions.Validate(); err != nil {
			invalidParams.AddNested("AdvancedSecurityOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.AutoTuneOptions != nil {
		if err := s.AutoTuneOptions.Validate(); err != nil {
			invalidParams.AddNested("AutoTuneOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.CognitoOptions != nil {
		if err := s.CognitoOptions.Validate(); err != nil {
			invalidParams.AddNested("CognitoOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.DomainEndpointOptions != nil {
		if err := s.DomainEndpointOptions.Validate(); err != nil {
			invalidParams.AddNested("DomainEndpointOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.ElasticsearchClusterConfig != nil {
		if err := s.ElasticsearchClusterConfig.Validate(); err != nil {
			invalidParams.AddNested("ElasticsearchClusterConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionAtRestOptions != nil {
		if err := s.EncryptionAtRestOptions.Validate(); err != nil {
			invalidParams.AddNested("EncryptionAtRestOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetAccessPolicies(v string) *UpdateElasticsearchDomainConfigInput {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetAdvancedOptions(v map[string]*string) *UpdateElasticsearchDomainConfigInput {
	s.AdvancedOptions = v
	return s
}

// SetAdvancedSecurityOptions sets the AdvancedSecurityOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetAdvancedSecurityOptions(v *AdvancedSecurityOptionsInput) *UpdateElasticsearchDomainConfigInput {
	s.AdvancedSecurityOptions = v
	return s
}

// SetAutoTuneOptions sets the AutoTuneOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetAutoTuneOptions(v *AutoTuneOptions) *UpdateElasticsearchDomainConfigInput {
	s.AutoTuneOptions = v
	return s
}

// SetCognitoOptions sets the CognitoOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetCognitoOptions(v *CognitoOptions) *UpdateElasticsearchDomainConfigInput {
	s.CognitoOptions = v
	return s
}

// SetDomainEndpointOptions sets the DomainEndpointOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetDomainEndpointOptions(v *DomainEndpointOptions) *UpdateElasticsearchDomainConfigInput {
	s.DomainEndpointOptions = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetDomainName(v string) *UpdateElasticsearchDomainConfigInput {
	s.DomainName = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetDryRun(v bool) *UpdateElasticsearchDomainConfigInput {
	s.DryRun = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetEBSOptions(v *EBSOptions) *UpdateElasticsearchDomainConfigInput {
	s.EBSOptions = v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetElasticsearchClusterConfig(v *ElasticsearchClusterConfig) *UpdateElasticsearchDomainConfigInput {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetEncryptionAtRestOptions(v *EncryptionAtRestOptions) *UpdateElasticsearchDomainConfigInput {
	s.EncryptionAtRestOptions = v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetLogPublishingOptions(v map[string]*LogPublishingOption) *UpdateElasticsearchDomainConfigInput {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetNodeToNodeEncryptionOptions(v *NodeToNodeEncryptionOptions) *UpdateElasticsearchDomainConfigInput {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetSnapshotOptions(v *SnapshotOptions) *UpdateElasticsearchDomainConfigInput {
	s.SnapshotOptions = v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetVPCOptions(v *VPCOptions) *UpdateElasticsearchDomainConfigInput {
	s.VPCOptions = v
	return s
}

// The result of an UpdateElasticsearchDomain request. Contains the status of
// the Elasticsearch domain being updated.
type UpdateElasticsearchDomainConfigOutput struct {
	_ struct{} `type:"structure"`

	// The status of the updated Elasticsearch domain.
	//
	// DomainConfig is a required field
	DomainConfig *ElasticsearchDomainConfig `type:"structure" required:"true"`

	// Contains result of DryRun.
	DryRunResults *DryRunResults `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateElasticsearchDomainConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateElasticsearchDomainConfigOutput) GoString() string {
	return s.String()
}

// SetDomainConfig sets the DomainConfig field's value.
func (s *UpdateElasticsearchDomainConfigOutput) SetDomainConfig(v *ElasticsearchDomainConfig) *UpdateElasticsearchDomainConfigOutput {
	s.DomainConfig = v
	return s
}

// SetDryRunResults sets the DryRunResults field's value.
func (s *UpdateElasticsearchDomainConfigOutput) SetDryRunResults(v *DryRunResults) *UpdateElasticsearchDomainConfigOutput {
	s.DryRunResults = v
	return s
}

// Container for request parameters to UpdatePackage operation.
type UpdatePackageInput struct {
	_ struct{} `type:"structure"`

	// An info message for the new version which will be shown as part of GetPackageVersionHistoryResponse.
	CommitMessage *string `type:"string"`

	// New description of the package.
	PackageDescription *string `type:"string"`

	// Unique identifier for the package.
	//
	// PackageID is a required field
	PackageID *string `type:"string" required:"true"`

	// The S3 location for importing the package specified as S3BucketName and S3Key
	//
	// PackageSource is a required field
	PackageSource *PackageSource `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePackageInput"}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageSource == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageSource"))
	}
	if s.PackageSource != nil {
		if err := s.PackageSource.Validate(); err != nil {
			invalidParams.AddNested("PackageSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommitMessage sets the CommitMessage field's value.
func (s *UpdatePackageInput) SetCommitMessage(v string) *UpdatePackageInput {
	s.CommitMessage = &v
	return s
}

// SetPackageDescription sets the PackageDescription field's value.
func (s *UpdatePackageInput) SetPackageDescription(v string) *UpdatePackageInput {
	s.PackageDescription = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *UpdatePackageInput) SetPackageID(v string) *UpdatePackageInput {
	s.PackageID = &v
	return s
}

// SetPackageSource sets the PackageSource field's value.
func (s *UpdatePackageInput) SetPackageSource(v *PackageSource) *UpdatePackageInput {
	s.PackageSource = v
	return s
}

// Container for response returned by UpdatePackage operation.
type UpdatePackageOutput struct {
	_ struct{} `type:"structure"`

	// Information about the package PackageDetails.
	PackageDetails *PackageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackageOutput) GoString() string {
	return s.String()
}

// SetPackageDetails sets the PackageDetails field's value.
func (s *UpdatePackageOutput) SetPackageDetails(v *PackageDetails) *UpdatePackageOutput {
	s.PackageDetails = v
	return s
}

// Container for request parameters to UpgradeElasticsearchDomain operation.
type UpgradeElasticsearchDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// This flag, when set to True, indicates that an Upgrade Eligibility Check
	// needs to be performed. This will not actually perform the Upgrade.
	PerformCheckOnly *bool `type:"boolean"`

	// The version of Elasticsearch that you intend to upgrade the domain to.
	//
	// TargetVersion is a required field
	TargetVersion *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeElasticsearchDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeElasticsearchDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpgradeElasticsearchDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpgradeElasticsearchDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.TargetVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *UpgradeElasticsearchDomainInput) SetDomainName(v string) *UpgradeElasticsearchDomainInput {
	s.DomainName = &v
	return s
}

// SetPerformCheckOnly sets the PerformCheckOnly field's value.
func (s *UpgradeElasticsearchDomainInput) SetPerformCheckOnly(v bool) *UpgradeElasticsearchDomainInput {
	s.PerformCheckOnly = &v
	return s
}

// SetTargetVersion sets the TargetVersion field's value.
func (s *UpgradeElasticsearchDomainInput) SetTargetVersion(v string) *UpgradeElasticsearchDomainInput {
	s.TargetVersion = &v
	return s
}

// Container for response returned by UpgradeElasticsearchDomain operation.
type UpgradeElasticsearchDomainOutput struct {
	_ struct{} `type:"structure"`

	// Specifies change details of the domain configuration change.
	ChangeProgressDetails *ChangeProgressDetails `type:"structure"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	DomainName *string `min:"3" type:"string"`

	// This flag, when set to True, indicates that an Upgrade Eligibility Check
	// needs to be performed. This will not actually perform the Upgrade.
	PerformCheckOnly *bool `type:"boolean"`

	// The version of Elasticsearch that you intend to upgrade the domain to.
	TargetVersion *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeElasticsearchDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeElasticsearchDomainOutput) GoString() string {
	return s.String()
}

// SetChangeProgressDetails sets the ChangeProgressDetails field's value.
func (s *UpgradeElasticsearchDomainOutput) SetChangeProgressDetails(v *ChangeProgressDetails) *UpgradeElasticsearchDomainOutput {
	s.ChangeProgressDetails = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpgradeElasticsearchDomainOutput) SetDomainName(v string) *UpgradeElasticsearchDomainOutput {
	s.DomainName = &v
	return s
}

// SetPerformCheckOnly sets the PerformCheckOnly field's value.
func (s *UpgradeElasticsearchDomainOutput) SetPerformCheckOnly(v bool) *UpgradeElasticsearchDomainOutput {
	s.PerformCheckOnly = &v
	return s
}

// SetTargetVersion sets the TargetVersion field's value.
func (s *UpgradeElasticsearchDomainOutput) SetTargetVersion(v string) *UpgradeElasticsearchDomainOutput {
	s.TargetVersion = &v
	return s
}

// History of the last 10 Upgrades and Upgrade Eligibility Checks.
type UpgradeHistory struct {
	_ struct{} `type:"structure"`

	// UTC Timestamp at which the Upgrade API call was made in "yyyy-MM-ddTHH:mm:ssZ"
	// format.
	StartTimestamp *time.Time `type:"timestamp"`

	// A list of UpgradeStepItem s representing information about each step performed
	// as pard of a specific Upgrade or Upgrade Eligibility Check.
	StepsList []*UpgradeStepItem `type:"list"`

	// A string that describes the update briefly
	UpgradeName *string `type:"string"`

	// The overall status of the update. The status can take one of the following
	// values:
	//    * In Progress
	//
	//    * Succeeded
	//
	//    * Succeeded with Issues
	//
	//    * Failed
	UpgradeStatus *string `type:"string" enum:"UpgradeStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeHistory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeHistory) GoString() string {
	return s.String()
}

// SetStartTimestamp sets the StartTimestamp field's value.
func (s *UpgradeHistory) SetStartTimestamp(v time.Time) *UpgradeHistory {
	s.StartTimestamp = &v
	return s
}

// SetStepsList sets the StepsList field's value.
func (s *UpgradeHistory) SetStepsList(v []*UpgradeStepItem) *UpgradeHistory {
	s.StepsList = v
	return s
}

// SetUpgradeName sets the UpgradeName field's value.
func (s *UpgradeHistory) SetUpgradeName(v string) *UpgradeHistory {
	s.UpgradeName = &v
	return s
}

// SetUpgradeStatus sets the UpgradeStatus field's value.
func (s *UpgradeHistory) SetUpgradeStatus(v string) *UpgradeHistory {
	s.UpgradeStatus = &v
	return s
}

// Represents a single step of the Upgrade or Upgrade Eligibility Check workflow.
type UpgradeStepItem struct {
	_ struct{} `type:"structure"`

	// A list of strings containing detailed information about the errors encountered
	// in a particular step.
	Issues []*string `type:"list"`

	// The Floating point value representing progress percentage of a particular
	// step.
	ProgressPercent *float64 `type:"double"`

	// Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does
	// through:
	//    * PreUpgradeCheck
	//
	//    * Snapshot
	//
	//    * Upgrade
	UpgradeStep *string `type:"string" enum:"UpgradeStep"`

	// The status of a particular step during an upgrade. The status can take one
	// of the following values:
	//    * In Progress
	//
	//    * Succeeded
	//
	//    * Succeeded with Issues
	//
	//    * Failed
	UpgradeStepStatus *string `type:"string" enum:"UpgradeStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeStepItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeStepItem) GoString() string {
	return s.String()
}

// SetIssues sets the Issues field's value.
func (s *UpgradeStepItem) SetIssues(v []*string) *UpgradeStepItem {
	s.Issues = v
	return s
}

// SetProgressPercent sets the ProgressPercent field's value.
func (s *UpgradeStepItem) SetProgressPercent(v float64) *UpgradeStepItem {
	s.ProgressPercent = &v
	return s
}

// SetUpgradeStep sets the UpgradeStep field's value.
func (s *UpgradeStepItem) SetUpgradeStep(v string) *UpgradeStepItem {
	s.UpgradeStep = &v
	return s
}

// SetUpgradeStepStatus sets the UpgradeStepStatus field's value.
func (s *UpgradeStepItem) SetUpgradeStepStatus(v string) *UpgradeStepItem {
	s.UpgradeStepStatus = &v
	return s
}

// Options to specify the subnets and security groups for VPC endpoint. For
// more information, see VPC Endpoints for Amazon Elasticsearch Service Domains
// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html).
type VPCDerivedInfo struct {
	_ struct{} `type:"structure"`

	// The availability zones for the Elasticsearch domain. Exists only if the domain
	// was created with VPCOptions.
	AvailabilityZones []*string `type:"list"`

	// Specifies the security groups for VPC endpoint.
	SecurityGroupIds []*string `type:"list"`

	// Specifies the subnets for VPC endpoint.
	SubnetIds []*string `type:"list"`

	// The VPC Id for the Elasticsearch domain. Exists only if the domain was created
	// with VPCOptions.
	VPCId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCDerivedInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCDerivedInfo) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *VPCDerivedInfo) SetAvailabilityZones(v []*string) *VPCDerivedInfo {
	s.AvailabilityZones = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VPCDerivedInfo) SetSecurityGroupIds(v []*string) *VPCDerivedInfo {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VPCDerivedInfo) SetSubnetIds(v []*string) *VPCDerivedInfo {
	s.SubnetIds = v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *VPCDerivedInfo) SetVPCId(v string) *VPCDerivedInfo {
	s.VPCId = &v
	return s
}

// Status of the VPC options for the specified Elasticsearch domain.
type VPCDerivedInfoStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the VPC options for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *VPCDerivedInfo `type:"structure" required:"true"`

	// Specifies the status of the VPC options for the specified Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCDerivedInfoStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCDerivedInfoStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *VPCDerivedInfoStatus) SetOptions(v *VPCDerivedInfo) *VPCDerivedInfoStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *VPCDerivedInfoStatus) SetStatus(v *OptionStatus) *VPCDerivedInfoStatus {
	s.Status = v
	return s
}

// Options to specify the subnets and security groups for VPC endpoint. For
// more information, see VPC Endpoints for Amazon Elasticsearch Service Domains
// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html).
type VPCOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the security groups for VPC endpoint.
	SecurityGroupIds []*string `type:"list"`

	// Specifies the subnets for VPC endpoint.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCOptions) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VPCOptions) SetSecurityGroupIds(v []*string) *VPCOptions {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VPCOptions) SetSubnetIds(v []*string) *VPCOptions {
	s.SubnetIds = v
	return s
}

// An exception for missing / invalid input fields. Gives http status code of
// 400.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the zone awareness configuration for the domain cluster, such as
// the number of availability zones.
type ZoneAwarenessConfig struct {
	_ struct{} `type:"structure"`

	// An integer value to indicate the number of availability zones for a domain
	// when zone awareness is enabled. This should be equal to number of subnets
	// if VPC endpoints is enabled
	AvailabilityZoneCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZoneAwarenessConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZoneAwarenessConfig) GoString() string {
	return s.String()
}

// SetAvailabilityZoneCount sets the AvailabilityZoneCount field's value.
func (s *ZoneAwarenessConfig) SetAvailabilityZoneCount(v int64) *ZoneAwarenessConfig {
	s.AvailabilityZoneCount = &v
	return s
}

// Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.
const (
	// AutoTuneDesiredStateEnabled is a AutoTuneDesiredState enum value
	AutoTuneDesiredStateEnabled = "ENABLED"

	// AutoTuneDesiredStateDisabled is a AutoTuneDesiredState enum value
	AutoTuneDesiredStateDisabled = "DISABLED"
)

// AutoTuneDesiredState_Values returns all elements of the AutoTuneDesiredState enum
func AutoTuneDesiredState_Values() []string {
	return []string{
		AutoTuneDesiredStateEnabled,
		AutoTuneDesiredStateDisabled,
	}
}

// Specifies the Auto-Tune state for the Elasticsearch domain. For valid states
// see the Developer Guide (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html).
const (
	// AutoTuneStateEnabled is a AutoTuneState enum value
	AutoTuneStateEnabled = "ENABLED"

	// AutoTuneStateDisabled is a AutoTuneState enum value
	AutoTuneStateDisabled = "DISABLED"

	// AutoTuneStateEnableInProgress is a AutoTuneState enum value
	AutoTuneStateEnableInProgress = "ENABLE_IN_PROGRESS"

	// AutoTuneStateDisableInProgress is a AutoTuneState enum value
	AutoTuneStateDisableInProgress = "DISABLE_IN_PROGRESS"

	// AutoTuneStateDisabledAndRollbackScheduled is a AutoTuneState enum value
	AutoTuneStateDisabledAndRollbackScheduled = "DISABLED_AND_ROLLBACK_SCHEDULED"

	// AutoTuneStateDisabledAndRollbackInProgress is a AutoTuneState enum value
	AutoTuneStateDisabledAndRollbackInProgress = "DISABLED_AND_ROLLBACK_IN_PROGRESS"

	// AutoTuneStateDisabledAndRollbackComplete is a AutoTuneState enum value
	AutoTuneStateDisabledAndRollbackComplete = "DISABLED_AND_ROLLBACK_COMPLETE"

	// AutoTuneStateDisabledAndRollbackError is a AutoTuneState enum value
	AutoTuneStateDisabledAndRollbackError = "DISABLED_AND_ROLLBACK_ERROR"

	// AutoTuneStateError is a AutoTuneState enum value
	AutoTuneStateError = "ERROR"
)

// AutoTuneState_Values returns all elements of the AutoTuneState enum
func AutoTuneState_Values() []string {
	return []string{
		AutoTuneStateEnabled,
		AutoTuneStateDisabled,
		AutoTuneStateEnableInProgress,
		AutoTuneStateDisableInProgress,
		AutoTuneStateDisabledAndRollbackScheduled,
		AutoTuneStateDisabledAndRollbackInProgress,
		AutoTuneStateDisabledAndRollbackComplete,
		AutoTuneStateDisabledAndRollbackError,
		AutoTuneStateError,
	}
}

// Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION.
const (
	// AutoTuneTypeScheduledAction is a AutoTuneType enum value
	AutoTuneTypeScheduledAction = "SCHEDULED_ACTION"
)

// AutoTuneType_Values returns all elements of the AutoTuneType enum
func AutoTuneType_Values() []string {
	return []string{
		AutoTuneTypeScheduledAction,
	}
}

const (
	// DeploymentStatusPendingUpdate is a DeploymentStatus enum value
	DeploymentStatusPendingUpdate = "PENDING_UPDATE"

	// DeploymentStatusInProgress is a DeploymentStatus enum value
	DeploymentStatusInProgress = "IN_PROGRESS"

	// DeploymentStatusCompleted is a DeploymentStatus enum value
	DeploymentStatusCompleted = "COMPLETED"

	// DeploymentStatusNotEligible is a DeploymentStatus enum value
	DeploymentStatusNotEligible = "NOT_ELIGIBLE"

	// DeploymentStatusEligible is a DeploymentStatus enum value
	DeploymentStatusEligible = "ELIGIBLE"
)

// DeploymentStatus_Values returns all elements of the DeploymentStatus enum
func DeploymentStatus_Values() []string {
	return []string{
		DeploymentStatusPendingUpdate,
		DeploymentStatusInProgress,
		DeploymentStatusCompleted,
		DeploymentStatusNotEligible,
		DeploymentStatusEligible,
	}
}

const (
	// DescribePackagesFilterNamePackageId is a DescribePackagesFilterName enum value
	DescribePackagesFilterNamePackageId = "PackageID"

	// DescribePackagesFilterNamePackageName is a DescribePackagesFilterName enum value
	DescribePackagesFilterNamePackageName = "PackageName"

	// DescribePackagesFilterNamePackageStatus is a DescribePackagesFilterName enum value
	DescribePackagesFilterNamePackageStatus = "PackageStatus"
)

// DescribePackagesFilterName_Values returns all elements of the DescribePackagesFilterName enum
func DescribePackagesFilterName_Values() []string {
	return []string{
		DescribePackagesFilterNamePackageId,
		DescribePackagesFilterNamePackageName,
		DescribePackagesFilterNamePackageStatus,
	}
}

const (
	// DomainPackageStatusAssociating is a DomainPackageStatus enum value
	DomainPackageStatusAssociating = "ASSOCIATING"

	// DomainPackageStatusAssociationFailed is a DomainPackageStatus enum value
	DomainPackageStatusAssociationFailed = "ASSOCIATION_FAILED"

	// DomainPackageStatusActive is a DomainPackageStatus enum value
	DomainPackageStatusActive = "ACTIVE"

	// DomainPackageStatusDissociating is a DomainPackageStatus enum value
	DomainPackageStatusDissociating = "DISSOCIATING"

	// DomainPackageStatusDissociationFailed is a DomainPackageStatus enum value
	DomainPackageStatusDissociationFailed = "DISSOCIATION_FAILED"
)

// DomainPackageStatus_Values returns all elements of the DomainPackageStatus enum
func DomainPackageStatus_Values() []string {
	return []string{
		DomainPackageStatusAssociating,
		DomainPackageStatusAssociationFailed,
		DomainPackageStatusActive,
		DomainPackageStatusDissociating,
		DomainPackageStatusDissociationFailed,
	}
}

const (
	// ESPartitionInstanceTypeM3MediumElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM3MediumElasticsearch = "m3.medium.elasticsearch"

	// ESPartitionInstanceTypeM3LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM3LargeElasticsearch = "m3.large.elasticsearch"

	// ESPartitionInstanceTypeM3XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM3XlargeElasticsearch = "m3.xlarge.elasticsearch"

	// ESPartitionInstanceTypeM32xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM32xlargeElasticsearch = "m3.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeM4LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM4LargeElasticsearch = "m4.large.elasticsearch"

	// ESPartitionInstanceTypeM4XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM4XlargeElasticsearch = "m4.xlarge.elasticsearch"

	// ESPartitionInstanceTypeM42xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM42xlargeElasticsearch = "m4.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeM44xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM44xlargeElasticsearch = "m4.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeM410xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM410xlargeElasticsearch = "m4.10xlarge.elasticsearch"

	// ESPartitionInstanceTypeM5LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM5LargeElasticsearch = "m5.large.elasticsearch"

	// ESPartitionInstanceTypeM5XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM5XlargeElasticsearch = "m5.xlarge.elasticsearch"

	// ESPartitionInstanceTypeM52xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM52xlargeElasticsearch = "m5.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeM54xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM54xlargeElasticsearch = "m5.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeM512xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM512xlargeElasticsearch = "m5.12xlarge.elasticsearch"

	// ESPartitionInstanceTypeR5LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR5LargeElasticsearch = "r5.large.elasticsearch"

	// ESPartitionInstanceTypeR5XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR5XlargeElasticsearch = "r5.xlarge.elasticsearch"

	// ESPartitionInstanceTypeR52xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR52xlargeElasticsearch = "r5.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeR54xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR54xlargeElasticsearch = "r5.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeR512xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR512xlargeElasticsearch = "r5.12xlarge.elasticsearch"

	// ESPartitionInstanceTypeC5LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC5LargeElasticsearch = "c5.large.elasticsearch"

	// ESPartitionInstanceTypeC5XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC5XlargeElasticsearch = "c5.xlarge.elasticsearch"

	// ESPartitionInstanceTypeC52xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC52xlargeElasticsearch = "c5.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeC54xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC54xlargeElasticsearch = "c5.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeC59xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC59xlargeElasticsearch = "c5.9xlarge.elasticsearch"

	// ESPartitionInstanceTypeC518xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC518xlargeElasticsearch = "c5.18xlarge.elasticsearch"

	// ESPartitionInstanceTypeUltrawarm1MediumElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeUltrawarm1MediumElasticsearch = "ultrawarm1.medium.elasticsearch"

	// ESPartitionInstanceTypeUltrawarm1LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeUltrawarm1LargeElasticsearch = "ultrawarm1.large.elasticsearch"

	// ESPartitionInstanceTypeT2MicroElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeT2MicroElasticsearch = "t2.micro.elasticsearch"

	// ESPartitionInstanceTypeT2SmallElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeT2SmallElasticsearch = "t2.small.elasticsearch"

	// ESPartitionInstanceTypeT2MediumElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeT2MediumElasticsearch = "t2.medium.elasticsearch"

	// ESPartitionInstanceTypeR3LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR3LargeElasticsearch = "r3.large.elasticsearch"

	// ESPartitionInstanceTypeR3XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR3XlargeElasticsearch = "r3.xlarge.elasticsearch"

	// ESPartitionInstanceTypeR32xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR32xlargeElasticsearch = "r3.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeR34xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR34xlargeElasticsearch = "r3.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeR38xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR38xlargeElasticsearch = "r3.8xlarge.elasticsearch"

	// ESPartitionInstanceTypeI2XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI2XlargeElasticsearch = "i2.xlarge.elasticsearch"

	// ESPartitionInstanceTypeI22xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI22xlargeElasticsearch = "i2.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeD2XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeD2XlargeElasticsearch = "d2.xlarge.elasticsearch"

	// ESPartitionInstanceTypeD22xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeD22xlargeElasticsearch = "d2.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeD24xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeD24xlargeElasticsearch = "d2.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeD28xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeD28xlargeElasticsearch = "d2.8xlarge.elasticsearch"

	// ESPartitionInstanceTypeC4LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC4LargeElasticsearch = "c4.large.elasticsearch"

	// ESPartitionInstanceTypeC4XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC4XlargeElasticsearch = "c4.xlarge.elasticsearch"

	// ESPartitionInstanceTypeC42xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC42xlargeElasticsearch = "c4.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeC44xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC44xlargeElasticsearch = "c4.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeC48xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC48xlargeElasticsearch = "c4.8xlarge.elasticsearch"

	// ESPartitionInstanceTypeR4LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR4LargeElasticsearch = "r4.large.elasticsearch"

	// ESPartitionInstanceTypeR4XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR4XlargeElasticsearch = "r4.xlarge.elasticsearch"

	// ESPartitionInstanceTypeR42xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR42xlargeElasticsearch = "r4.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeR44xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR44xlargeElasticsearch = "r4.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeR48xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR48xlargeElasticsearch = "r4.8xlarge.elasticsearch"

	// ESPartitionInstanceTypeR416xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR416xlargeElasticsearch = "r4.16xlarge.elasticsearch"

	// ESPartitionInstanceTypeI3LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI3LargeElasticsearch = "i3.large.elasticsearch"

	// ESPartitionInstanceTypeI3XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI3XlargeElasticsearch = "i3.xlarge.elasticsearch"

	// ESPartitionInstanceTypeI32xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI32xlargeElasticsearch = "i3.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeI34xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI34xlargeElasticsearch = "i3.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeI38xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI38xlargeElasticsearch = "i3.8xlarge.elasticsearch"

	// ESPartitionInstanceTypeI316xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI316xlargeElasticsearch = "i3.16xlarge.elasticsearch"
)

// ESPartitionInstanceType_Values returns all elements of the ESPartitionInstanceType enum
func ESPartitionInstanceType_Values() []string {
	return []string{
		ESPartitionInstanceTypeM3MediumElasticsearch,
		ESPartitionInstanceTypeM3LargeElasticsearch,
		ESPartitionInstanceTypeM3XlargeElasticsearch,
		ESPartitionInstanceTypeM32xlargeElasticsearch,
		ESPartitionInstanceTypeM4LargeElasticsearch,
		ESPartitionInstanceTypeM4XlargeElasticsearch,
		ESPartitionInstanceTypeM42xlargeElasticsearch,
		ESPartitionInstanceTypeM44xlargeElasticsearch,
		ESPartitionInstanceTypeM410xlargeElasticsearch,
		ESPartitionInstanceTypeM5LargeElasticsearch,
		ESPartitionInstanceTypeM5XlargeElasticsearch,
		ESPartitionInstanceTypeM52xlargeElasticsearch,
		ESPartitionInstanceTypeM54xlargeElasticsearch,
		ESPartitionInstanceTypeM512xlargeElasticsearch,
		ESPartitionInstanceTypeR5LargeElasticsearch,
		ESPartitionInstanceTypeR5XlargeElasticsearch,
		ESPartitionInstanceTypeR52xlargeElasticsearch,
		ESPartitionInstanceTypeR54xlargeElasticsearch,
		ESPartitionInstanceTypeR512xlargeElasticsearch,
		ESPartitionInstanceTypeC5LargeElasticsearch,
		ESPartitionInstanceTypeC5XlargeElasticsearch,
		ESPartitionInstanceTypeC52xlargeElasticsearch,
		ESPartitionInstanceTypeC54xlargeElasticsearch,
		ESPartitionInstanceTypeC59xlargeElasticsearch,
		ESPartitionInstanceTypeC518xlargeElasticsearch,
		ESPartitionInstanceTypeUltrawarm1MediumElasticsearch,
		ESPartitionInstanceTypeUltrawarm1LargeElasticsearch,
		ESPartitionInstanceTypeT2MicroElasticsearch,
		ESPartitionInstanceTypeT2SmallElasticsearch,
		ESPartitionInstanceTypeT2MediumElasticsearch,
		ESPartitionInstanceTypeR3LargeElasticsearch,
		ESPartitionInstanceTypeR3XlargeElasticsearch,
		ESPartitionInstanceTypeR32xlargeElasticsearch,
		ESPartitionInstanceTypeR34xlargeElasticsearch,
		ESPartitionInstanceTypeR38xlargeElasticsearch,
		ESPartitionInstanceTypeI2XlargeElasticsearch,
		ESPartitionInstanceTypeI22xlargeElasticsearch,
		ESPartitionInstanceTypeD2XlargeElasticsearch,
		ESPartitionInstanceTypeD22xlargeElasticsearch,
		ESPartitionInstanceTypeD24xlargeElasticsearch,
		ESPartitionInstanceTypeD28xlargeElasticsearch,
		ESPartitionInstanceTypeC4LargeElasticsearch,
		ESPartitionInstanceTypeC4XlargeElasticsearch,
		ESPartitionInstanceTypeC42xlargeElasticsearch,
		ESPartitionInstanceTypeC44xlargeElasticsearch,
		ESPartitionInstanceTypeC48xlargeElasticsearch,
		ESPartitionInstanceTypeR4LargeElasticsearch,
		ESPartitionInstanceTypeR4XlargeElasticsearch,
		ESPartitionInstanceTypeR42xlargeElasticsearch,
		ESPartitionInstanceTypeR44xlargeElasticsearch,
		ESPartitionInstanceTypeR48xlargeElasticsearch,
		ESPartitionInstanceTypeR416xlargeElasticsearch,
		ESPartitionInstanceTypeI3LargeElasticsearch,
		ESPartitionInstanceTypeI3XlargeElasticsearch,
		ESPartitionInstanceTypeI32xlargeElasticsearch,
		ESPartitionInstanceTypeI34xlargeElasticsearch,
		ESPartitionInstanceTypeI38xlargeElasticsearch,
		ESPartitionInstanceTypeI316xlargeElasticsearch,
	}
}

const (
	// ESWarmPartitionInstanceTypeUltrawarm1MediumElasticsearch is a ESWarmPartitionInstanceType enum value
	ESWarmPartitionInstanceTypeUltrawarm1MediumElasticsearch = "ultrawarm1.medium.elasticsearch"

	// ESWarmPartitionInstanceTypeUltrawarm1LargeElasticsearch is a ESWarmPartitionInstanceType enum value
	ESWarmPartitionInstanceTypeUltrawarm1LargeElasticsearch = "ultrawarm1.large.elasticsearch"
)

// ESWarmPartitionInstanceType_Values returns all elements of the ESWarmPartitionInstanceType enum
func ESWarmPartitionInstanceType_Values() []string {
	return []string{
		ESWarmPartitionInstanceTypeUltrawarm1MediumElasticsearch,
		ESWarmPartitionInstanceTypeUltrawarm1LargeElasticsearch,
	}
}

const (
	// EngineTypeOpenSearch is a EngineType enum value
	EngineTypeOpenSearch = "OpenSearch"

	// EngineTypeElasticsearch is a EngineType enum value
	EngineTypeElasticsearch = "Elasticsearch"
)

// EngineType_Values returns all elements of the EngineType enum
func EngineType_Values() []string {
	return []string{
		EngineTypeOpenSearch,
		EngineTypeElasticsearch,
	}
}

const (
	// InboundCrossClusterSearchConnectionStatusCodePendingAcceptance is a InboundCrossClusterSearchConnectionStatusCode enum value
	InboundCrossClusterSearchConnectionStatusCodePendingAcceptance = "PENDING_ACCEPTANCE"

	// InboundCrossClusterSearchConnectionStatusCodeApproved is a InboundCrossClusterSearchConnectionStatusCode enum value
	InboundCrossClusterSearchConnectionStatusCodeApproved = "APPROVED"

	// InboundCrossClusterSearchConnectionStatusCodeRejecting is a InboundCrossClusterSearchConnectionStatusCode enum value
	InboundCrossClusterSearchConnectionStatusCodeRejecting = "REJECTING"

	// InboundCrossClusterSearchConnectionStatusCodeRejected is a InboundCrossClusterSearchConnectionStatusCode enum value
	InboundCrossClusterSearchConnectionStatusCodeRejected = "REJECTED"

	// InboundCrossClusterSearchConnectionStatusCodeDeleting is a InboundCrossClusterSearchConnectionStatusCode enum value
	InboundCrossClusterSearchConnectionStatusCodeDeleting = "DELETING"

	// InboundCrossClusterSearchConnectionStatusCodeDeleted is a InboundCrossClusterSearchConnectionStatusCode enum value
	InboundCrossClusterSearchConnectionStatusCodeDeleted = "DELETED"
)

// InboundCrossClusterSearchConnectionStatusCode_Values returns all elements of the InboundCrossClusterSearchConnectionStatusCode enum
func InboundCrossClusterSearchConnectionStatusCode_Values() []string {
	return []string{
		InboundCrossClusterSearchConnectionStatusCodePendingAcceptance,
		InboundCrossClusterSearchConnectionStatusCodeApproved,
		InboundCrossClusterSearchConnectionStatusCodeRejecting,
		InboundCrossClusterSearchConnectionStatusCodeRejected,
		InboundCrossClusterSearchConnectionStatusCodeDeleting,
		InboundCrossClusterSearchConnectionStatusCodeDeleted,
	}
}

// Type of Log File, it can be one of the following:
//
//   - INDEX_SLOW_LOGS: Index slow logs contain insert requests that took more
//     time than configured index query log threshold to execute.
//
//   - SEARCH_SLOW_LOGS: Search slow logs contain search queries that took
//     more time than configured search query log threshold to execute.
//
//   - ES_APPLICATION_LOGS: Elasticsearch application logs contain information
//     about errors and warnings raised during the operation of the service and
//     can be useful for troubleshooting.
//
//   - AUDIT_LOGS: Audit logs contain records of user requests for access from
//     the domain.
const (
	// LogTypeIndexSlowLogs is a LogType enum value
	LogTypeIndexSlowLogs = "INDEX_SLOW_LOGS"

	// LogTypeSearchSlowLogs is a LogType enum value
	LogTypeSearchSlowLogs = "SEARCH_SLOW_LOGS"

	// LogTypeEsApplicationLogs is a LogType enum value
	LogTypeEsApplicationLogs = "ES_APPLICATION_LOGS"

	// LogTypeAuditLogs is a LogType enum value
	LogTypeAuditLogs = "AUDIT_LOGS"
)

// LogType_Values returns all elements of the LogType enum
func LogType_Values() []string {
	return []string{
		LogTypeIndexSlowLogs,
		LogTypeSearchSlowLogs,
		LogTypeEsApplicationLogs,
		LogTypeAuditLogs,
	}
}

// The state of a requested change. One of the following:
//
//   - Processing: The request change is still in-process.
//
//   - Active: The request change is processed and deployed to the Elasticsearch
//     domain.
const (
	// OptionStateRequiresIndexDocuments is a OptionState enum value
	OptionStateRequiresIndexDocuments = "RequiresIndexDocuments"

	// OptionStateProcessing is a OptionState enum value
	OptionStateProcessing = "Processing"

	// OptionStateActive is a OptionState enum value
	OptionStateActive = "Active"
)

// OptionState_Values returns all elements of the OptionState enum
func OptionState_Values() []string {
	return []string{
		OptionStateRequiresIndexDocuments,
		OptionStateProcessing,
		OptionStateActive,
	}
}

const (
	// OutboundCrossClusterSearchConnectionStatusCodePendingAcceptance is a OutboundCrossClusterSearchConnectionStatusCode enum value
	OutboundCrossClusterSearchConnectionStatusCodePendingAcceptance = "PENDING_ACCEPTANCE"

	// OutboundCrossClusterSearchConnectionStatusCodeValidating is a OutboundCrossClusterSearchConnectionStatusCode enum value
	OutboundCrossClusterSearchConnectionStatusCodeValidating = "VALIDATING"

	// OutboundCrossClusterSearchConnectionStatusCodeValidationFailed is a OutboundCrossClusterSearchConnectionStatusCode enum value
	OutboundCrossClusterSearchConnectionStatusCodeValidationFailed = "VALIDATION_FAILED"

	// OutboundCrossClusterSearchConnectionStatusCodeProvisioning is a OutboundCrossClusterSearchConnectionStatusCode enum value
	OutboundCrossClusterSearchConnectionStatusCodeProvisioning = "PROVISIONING"

	// OutboundCrossClusterSearchConnectionStatusCodeActive is a OutboundCrossClusterSearchConnectionStatusCode enum value
	OutboundCrossClusterSearchConnectionStatusCodeActive = "ACTIVE"

	// OutboundCrossClusterSearchConnectionStatusCodeRejected is a OutboundCrossClusterSearchConnectionStatusCode enum value
	OutboundCrossClusterSearchConnectionStatusCodeRejected = "REJECTED"

	// OutboundCrossClusterSearchConnectionStatusCodeDeleting is a OutboundCrossClusterSearchConnectionStatusCode enum value
	OutboundCrossClusterSearchConnectionStatusCodeDeleting = "DELETING"

	// OutboundCrossClusterSearchConnectionStatusCodeDeleted is a OutboundCrossClusterSearchConnectionStatusCode enum value
	OutboundCrossClusterSearchConnectionStatusCodeDeleted = "DELETED"
)

// OutboundCrossClusterSearchConnectionStatusCode_Values returns all elements of the OutboundCrossClusterSearchConnectionStatusCode enum
func OutboundCrossClusterSearchConnectionStatusCode_Values() []string {
	return []string{
		OutboundCrossClusterSearchConnectionStatusCodePendingAcceptance,
		OutboundCrossClusterSearchConnectionStatusCodeValidating,
		OutboundCrossClusterSearchConnectionStatusCodeValidationFailed,
		OutboundCrossClusterSearchConnectionStatusCodeProvisioning,
		OutboundCrossClusterSearchConnectionStatusCodeActive,
		OutboundCrossClusterSearchConnectionStatusCodeRejected,
		OutboundCrossClusterSearchConnectionStatusCodeDeleting,
		OutboundCrossClusterSearchConnectionStatusCodeDeleted,
	}
}

// The overall status value of the domain configuration change.
const (
	// OverallChangeStatusPending is a OverallChangeStatus enum value
	OverallChangeStatusPending = "PENDING"

	// OverallChangeStatusProcessing is a OverallChangeStatus enum value
	OverallChangeStatusProcessing = "PROCESSING"

	// OverallChangeStatusCompleted is a OverallChangeStatus enum value
	OverallChangeStatusCompleted = "COMPLETED"

	// OverallChangeStatusFailed is a OverallChangeStatus enum value
	OverallChangeStatusFailed = "FAILED"
)

// OverallChangeStatus_Values returns all elements of the OverallChangeStatus enum
func OverallChangeStatus_Values() []string {
	return []string{
		OverallChangeStatusPending,
		OverallChangeStatusProcessing,
		OverallChangeStatusCompleted,
		OverallChangeStatusFailed,
	}
}

const (
	// PackageStatusCopying is a PackageStatus enum value
	PackageStatusCopying = "COPYING"

	// PackageStatusCopyFailed is a PackageStatus enum value
	PackageStatusCopyFailed = "COPY_FAILED"

	// PackageStatusValidating is a PackageStatus enum value
	PackageStatusValidating = "VALIDATING"

	// PackageStatusValidationFailed is a PackageStatus enum value
	PackageStatusValidationFailed = "VALIDATION_FAILED"

	// PackageStatusAvailable is a PackageStatus enum value
	PackageStatusAvailable = "AVAILABLE"

	// PackageStatusDeleting is a PackageStatus enum value
	PackageStatusDeleting = "DELETING"

	// PackageStatusDeleted is a PackageStatus enum value
	PackageStatusDeleted = "DELETED"

	// PackageStatusDeleteFailed is a PackageStatus enum value
	PackageStatusDeleteFailed = "DELETE_FAILED"
)

// PackageStatus_Values returns all elements of the PackageStatus enum
func PackageStatus_Values() []string {
	return []string{
		PackageStatusCopying,
		PackageStatusCopyFailed,
		PackageStatusValidating,
		PackageStatusValidationFailed,
		PackageStatusAvailable,
		PackageStatusDeleting,
		PackageStatusDeleted,
		PackageStatusDeleteFailed,
	}
}

const (
	// PackageTypeTxtDictionary is a PackageType enum value
	PackageTypeTxtDictionary = "TXT-DICTIONARY"
)

// PackageType_Values returns all elements of the PackageType enum
func PackageType_Values() []string {
	return []string{
		PackageTypeTxtDictionary,
	}
}

const (
	// ReservedElasticsearchInstancePaymentOptionAllUpfront is a ReservedElasticsearchInstancePaymentOption enum value
	ReservedElasticsearchInstancePaymentOptionAllUpfront = "ALL_UPFRONT"

	// ReservedElasticsearchInstancePaymentOptionPartialUpfront is a ReservedElasticsearchInstancePaymentOption enum value
	ReservedElasticsearchInstancePaymentOptionPartialUpfront = "PARTIAL_UPFRONT"

	// ReservedElasticsearchInstancePaymentOptionNoUpfront is a ReservedElasticsearchInstancePaymentOption enum value
	ReservedElasticsearchInstancePaymentOptionNoUpfront = "NO_UPFRONT"
)

// ReservedElasticsearchInstancePaymentOption_Values returns all elements of the ReservedElasticsearchInstancePaymentOption enum
func ReservedElasticsearchInstancePaymentOption_Values() []string {
	return []string{
		ReservedElasticsearchInstancePaymentOptionAllUpfront,
		ReservedElasticsearchInstancePaymentOptionPartialUpfront,
		ReservedElasticsearchInstancePaymentOptionNoUpfront,
	}
}

// Specifies the rollback state while disabling Auto-Tune for the domain. Valid
// values are NO_ROLLBACK, DEFAULT_ROLLBACK.
const (
	// RollbackOnDisableNoRollback is a RollbackOnDisable enum value
	RollbackOnDisableNoRollback = "NO_ROLLBACK"

	// RollbackOnDisableDefaultRollback is a RollbackOnDisable enum value
	RollbackOnDisableDefaultRollback = "DEFAULT_ROLLBACK"
)

// RollbackOnDisable_Values returns all elements of the RollbackOnDisable enum
func RollbackOnDisable_Values() []string {
	return []string{
		RollbackOnDisableNoRollback,
		RollbackOnDisableDefaultRollback,
	}
}

// Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and
// JVM_YOUNG_GEN_TUNING.
const (
	// ScheduledAutoTuneActionTypeJvmHeapSizeTuning is a ScheduledAutoTuneActionType enum value
	ScheduledAutoTuneActionTypeJvmHeapSizeTuning = "JVM_HEAP_SIZE_TUNING"

	// ScheduledAutoTuneActionTypeJvmYoungGenTuning is a ScheduledAutoTuneActionType enum value
	ScheduledAutoTuneActionTypeJvmYoungGenTuning = "JVM_YOUNG_GEN_TUNING"
)

// ScheduledAutoTuneActionType_Values returns all elements of the ScheduledAutoTuneActionType enum
func ScheduledAutoTuneActionType_Values() []string {
	return []string{
		ScheduledAutoTuneActionTypeJvmHeapSizeTuning,
		ScheduledAutoTuneActionTypeJvmYoungGenTuning,
	}
}

// Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH.
const (
	// ScheduledAutoTuneSeverityTypeLow is a ScheduledAutoTuneSeverityType enum value
	ScheduledAutoTuneSeverityTypeLow = "LOW"

	// ScheduledAutoTuneSeverityTypeMedium is a ScheduledAutoTuneSeverityType enum value
	ScheduledAutoTuneSeverityTypeMedium = "MEDIUM"

	// ScheduledAutoTuneSeverityTypeHigh is a ScheduledAutoTuneSeverityType enum value
	ScheduledAutoTuneSeverityTypeHigh = "HIGH"
)

// ScheduledAutoTuneSeverityType_Values returns all elements of the ScheduledAutoTuneSeverityType enum
func ScheduledAutoTuneSeverityType_Values() []string {
	return []string{
		ScheduledAutoTuneSeverityTypeLow,
		ScheduledAutoTuneSeverityTypeMedium,
		ScheduledAutoTuneSeverityTypeHigh,
	}
}

const (
	// TLSSecurityPolicyPolicyMinTls10201907 is a TLSSecurityPolicy enum value
	TLSSecurityPolicyPolicyMinTls10201907 = "Policy-Min-TLS-1-0-2019-07"

	// TLSSecurityPolicyPolicyMinTls12201907 is a TLSSecurityPolicy enum value
	TLSSecurityPolicyPolicyMinTls12201907 = "Policy-Min-TLS-1-2-2019-07"
)

// TLSSecurityPolicy_Values returns all elements of the TLSSecurityPolicy enum
func TLSSecurityPolicy_Values() []string {
	return []string{
		TLSSecurityPolicyPolicyMinTls10201907,
		TLSSecurityPolicyPolicyMinTls12201907,
	}
}

// Specifies the unit of a maintenance schedule duration. Valid value is HOUR.
// See the Developer Guide (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
// for more information.
const (
	// TimeUnitHours is a TimeUnit enum value
	TimeUnitHours = "HOURS"
)

// TimeUnit_Values returns all elements of the TimeUnit enum
func TimeUnit_Values() []string {
	return []string{
		TimeUnitHours,
	}
}

const (
	// UpgradeStatusInProgress is a UpgradeStatus enum value
	UpgradeStatusInProgress = "IN_PROGRESS"

	// UpgradeStatusSucceeded is a UpgradeStatus enum value
	UpgradeStatusSucceeded = "SUCCEEDED"

	// UpgradeStatusSucceededWithIssues is a UpgradeStatus enum value
	UpgradeStatusSucceededWithIssues = "SUCCEEDED_WITH_ISSUES"

	// UpgradeStatusFailed is a UpgradeStatus enum value
	UpgradeStatusFailed = "FAILED"
)

// UpgradeStatus_Values returns all elements of the UpgradeStatus enum
func UpgradeStatus_Values() []string {
	return []string{
		UpgradeStatusInProgress,
		UpgradeStatusSucceeded,
		UpgradeStatusSucceededWithIssues,
		UpgradeStatusFailed,
	}
}

const (
	// UpgradeStepPreUpgradeCheck is a UpgradeStep enum value
	UpgradeStepPreUpgradeCheck = "PRE_UPGRADE_CHECK"

	// UpgradeStepSnapshot is a UpgradeStep enum value
	UpgradeStepSnapshot = "SNAPSHOT"

	// UpgradeStepUpgrade is a UpgradeStep enum value
	UpgradeStepUpgrade = "UPGRADE"
)

// UpgradeStep_Values returns all elements of the UpgradeStep enum
func UpgradeStep_Values() []string {
	return []string{
		UpgradeStepPreUpgradeCheck,
		UpgradeStepSnapshot,
		UpgradeStepUpgrade,
	}
}

// The type of EBS volume, standard, gp2, gp3 or io1. See Configuring EBS-based
// Storage (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs)for
// more information.
const (
	// VolumeTypeStandard is a VolumeType enum value
	VolumeTypeStandard = "standard"

	// VolumeTypeGp2 is a VolumeType enum value
	VolumeTypeGp2 = "gp2"

	// VolumeTypeIo1 is a VolumeType enum value
	VolumeTypeIo1 = "io1"

	// VolumeTypeGp3 is a VolumeType enum value
	VolumeTypeGp3 = "gp3"
)

// VolumeType_Values returns all elements of the VolumeType enum
func VolumeType_Values() []string {
	return []string{
		VolumeTypeStandard,
		VolumeTypeGp2,
		VolumeTypeIo1,
		VolumeTypeGp3,
	}
}
