// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Generates a temporary session URL and authorization code(bearer token) that you
// can use to embed an Amazon QuickSight read-only dashboard in your website or
// application. Before you use this command, make sure that you have configured the
// dashboards and permissions.
//
// Currently, you can use GetDashboardEmbedURL only from the server, not from the
// user's browser. The following rules apply to the generated URL:
//
//   - They must be used together.
//
//   - They can be used one time only.
//
//   - They are valid for 5 minutes after you run this command.
//
//   - You are charged only when the URL is used or there is interaction with
//     Amazon QuickSight.
//
//   - The resulting user session is valid for 15 minutes (default) up to 10 hours
//     (maximum). You can use the optional SessionLifetimeInMinutes parameter to
//     customize session duration.
//
// For more information, see [Embedding Analytics Using GetDashboardEmbedUrl] in the Amazon QuickSight User Guide.
//
// For more information about the high-level steps for embedding and for an
// interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal].
//
// [Amazon QuickSight Developer Portal]: https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html
// [Embedding Analytics Using GetDashboardEmbedUrl]: https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-deprecated.html
func (c *Client) GetDashboardEmbedUrl(ctx context.Context, params *GetDashboardEmbedUrlInput, optFns ...func(*Options)) (*GetDashboardEmbedUrlOutput, error) {
	if params == nil {
		params = &GetDashboardEmbedUrlInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDashboardEmbedUrl", params, optFns, c.addOperationGetDashboardEmbedUrlMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDashboardEmbedUrlOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDashboardEmbedUrlInput struct {

	// The ID for the Amazon Web Services account that contains the dashboard that
	// you're embedding.
	//
	// This member is required.
	AwsAccountId *string

	// The ID for the dashboard, also added to the Identity and Access Management
	// (IAM) policy.
	//
	// This member is required.
	DashboardId *string

	// The authentication method that the user uses to sign in.
	//
	// This member is required.
	IdentityType types.EmbeddingIdentityType

	// A list of one or more dashboard IDs that you want anonymous users to have
	// tempporary access to. Currently, the IdentityType parameter must be set to
	// ANONYMOUS because other identity types authenticate as Amazon QuickSight or IAM
	// users. For example, if you set " --dashboard-id dash_id1 --dashboard-id dash_id2
	// dash_id3 identity-type ANONYMOUS ", the session can access all three dashboards.
	AdditionalDashboardIds []string

	// The Amazon QuickSight namespace that contains the dashboard IDs in this
	// request. If you're not using a custom namespace, set Namespace = default .
	Namespace *string

	// Remove the reset button on the embedded dashboard. The default is FALSE, which
	// enables the reset button.
	ResetDisabled bool

	// How many minutes the session is valid. The session lifetime must be 15-600
	// minutes.
	SessionLifetimeInMinutes *int64

	// Adds persistence of state for the user session in an embedded dashboard.
	// Persistence applies to the sheet and the parameter settings. These are control
	// settings that the dashboard subscriber (Amazon QuickSight reader) chooses while
	// viewing the dashboard. If this is set to TRUE , the settings are the same when
	// the subscriber reopens the same dashboard URL. The state is stored in Amazon
	// QuickSight, not in a browser cookie. If this is set to FALSE, the state of the
	// user session is not persisted. The default is FALSE .
	StatePersistenceEnabled bool

	// Remove the undo/redo button on the embedded dashboard. The default is FALSE,
	// which enables the undo/redo button.
	UndoRedoDisabled bool

	// The Amazon QuickSight user's Amazon Resource Name (ARN), for use with QUICKSIGHT
	// identity type. You can use this for any Amazon QuickSight users in your account
	// (readers, authors, or admins) authenticated as one of the following:
	//
	//   - Active Directory (AD) users or group members
	//
	//   - Invited nonfederated users
	//
	//   - IAM users and IAM role-based sessions authenticated through Federated
	//   Single Sign-On using SAML, OpenID Connect, or IAM federation.
	//
	// Omit this parameter for users in the third group – IAM users and IAM role-based
	// sessions.
	UserArn *string

	noSmithyDocumentSerde
}

// Output returned from the GetDashboardEmbedUrl operation.
type GetDashboardEmbedUrlOutput struct {

	// A single-use URL that you can put into your server-side webpage to embed your
	// dashboard. This URL is valid for 5 minutes. The API operation provides the URL
	// with an auth_code value that enables one (and only one) sign-on to a user
	// session that is valid for 10 hours.
	EmbedUrl *string

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The HTTP status of the request.
	Status int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDashboardEmbedUrlMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetDashboardEmbedUrl{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetDashboardEmbedUrl{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetDashboardEmbedUrl"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetDashboardEmbedUrlValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDashboardEmbedUrl(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetDashboardEmbedUrl(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetDashboardEmbedUrl",
	}
}
