// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Deletes a transit gateway attachment from a Network Firewall. Either the
// firewall owner or the transit gateway owner can delete the attachment.
//
// After you delete a transit gateway attachment, raffic will no longer flow
// through the firewall endpoints.
//
// After you initiate the delete operation, use DescribeFirewall to monitor the deletion status.
func (c *Client) DeleteNetworkFirewallTransitGatewayAttachment(ctx context.Context, params *DeleteNetworkFirewallTransitGatewayAttachmentInput, optFns ...func(*Options)) (*DeleteNetworkFirewallTransitGatewayAttachmentOutput, error) {
	if params == nil {
		params = &DeleteNetworkFirewallTransitGatewayAttachmentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteNetworkFirewallTransitGatewayAttachment", params, optFns, c.addOperationDeleteNetworkFirewallTransitGatewayAttachmentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteNetworkFirewallTransitGatewayAttachmentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteNetworkFirewallTransitGatewayAttachmentInput struct {

	// Required. The unique identifier of the transit gateway attachment to delete.
	//
	// This member is required.
	TransitGatewayAttachmentId *string

	noSmithyDocumentSerde
}

type DeleteNetworkFirewallTransitGatewayAttachmentOutput struct {

	// The ID of the transit gateway attachment that was deleted.
	//
	// This member is required.
	TransitGatewayAttachmentId *string

	// The current status of the transit gateway attachment deletion process.
	//
	// Valid values are:
	//
	//   - CREATING - The attachment is being created
	//
	//   - DELETING - The attachment is being deleted
	//
	//   - DELETED - The attachment has been deleted
	//
	//   - FAILED - The attachment creation has failed and cannot be recovered
	//
	//   - ERROR - The attachment is in an error state that might be recoverable
	//
	//   - READY - The attachment is active and processing traffic
	//
	//   - PENDING_ACCEPTANCE - The attachment is waiting to be accepted
	//
	//   - REJECTING - The attachment is in the process of being rejected
	//
	//   - REJECTED - The attachment has been rejected
	//
	// This member is required.
	TransitGatewayAttachmentStatus types.TransitGatewayAttachmentStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteNetworkFirewallTransitGatewayAttachmentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDeleteNetworkFirewallTransitGatewayAttachment{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDeleteNetworkFirewallTransitGatewayAttachment{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteNetworkFirewallTransitGatewayAttachment"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDeleteNetworkFirewallTransitGatewayAttachmentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteNetworkFirewallTransitGatewayAttachment(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteNetworkFirewallTransitGatewayAttachment(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteNetworkFirewallTransitGatewayAttachment",
	}
}
