// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the Availability Zones, Local Zones, and Wavelength Zones that are
// available to you.
//
// For more information about Availability Zones, Local Zones, and Wavelength
// Zones, see [Regions and zones]in the Amazon EC2 User Guide.
//
// The order of the elements in the response, including those within nested
// structures, might vary. Applications should not assume the elements appear in a
// particular order.
//
// [Regions and zones]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html
func (c *Client) DescribeAvailabilityZones(ctx context.Context, params *DescribeAvailabilityZonesInput, optFns ...func(*Options)) (*DescribeAvailabilityZonesOutput, error) {
	if params == nil {
		params = &DescribeAvailabilityZonesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeAvailabilityZones", params, optFns, c.addOperationDescribeAvailabilityZonesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeAvailabilityZonesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeAvailabilityZonesInput struct {

	// Include all Availability Zones, Local Zones, and Wavelength Zones regardless of
	// your opt-in status.
	//
	// If you do not use this parameter, the results include only the zones for the
	// Regions where you have chosen the option to opt in.
	AllAvailabilityZones *bool

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The filters.
	//
	//   - group-long-name - The long name of the zone group for the Availability Zone
	//   (for example, US West (Oregon) 1 ), the Local Zone (for example, for Zone
	//   group us-west-2-lax-1 , it is US West (Los Angeles) , or the Wavelength Zone
	//   (for example, for Zone group us-east-1-wl1 , it is US East (Verizon) .
	//
	//   - group-name - The name of the zone group for the Availability Zone (for
	//   example, us-east-1-zg-1 ), the Local Zone (for example, us-west-2-lax-1 ), or
	//   the Wavelength Zone (for example, us-east-1-wl1 ).
	//
	//   - message - The Zone message.
	//
	//   - opt-in-status - The opt-in status ( opted-in | not-opted-in |
	//   opt-in-not-required ).
	//
	//   - parent-zone-id - The ID of the zone that handles some of the Local Zone and
	//   Wavelength Zone control plane operations, such as API calls.
	//
	//   - parent-zone-name - The ID of the zone that handles some of the Local Zone
	//   and Wavelength Zone control plane operations, such as API calls.
	//
	//   - region-name - The name of the Region for the Zone (for example, us-east-1 ).
	//
	//   - state - The state of the Availability Zone, the Local Zone, or the
	//   Wavelength Zone ( available | unavailable | constrained ).
	//
	//   - zone-id - The ID of the Availability Zone (for example, use1-az1 ), the
	//   Local Zone (for example, usw2-lax1-az1 ), or the Wavelength Zone (for example,
	//   us-east-1-wl1-bos-wlz-1 ).
	//
	//   - zone-name - The name of the Availability Zone (for example, us-east-1a ),
	//   the Local Zone (for example, us-west-2-lax-1a ), or the Wavelength Zone (for
	//   example, us-east-1-wl1-bos-wlz-1 ).
	//
	//   - zone-type - The type of zone ( availability-zone | local-zone |
	//   wavelength-zone ).
	Filters []types.Filter

	// The IDs of the Availability Zones, Local Zones, and Wavelength Zones.
	ZoneIds []string

	// The names of the Availability Zones, Local Zones, and Wavelength Zones.
	ZoneNames []string

	noSmithyDocumentSerde
}

type DescribeAvailabilityZonesOutput struct {

	// Information about the Availability Zones, Local Zones, and Wavelength Zones.
	AvailabilityZones []types.AvailabilityZone

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeAvailabilityZonesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeAvailabilityZones{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeAvailabilityZones{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeAvailabilityZones"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeAvailabilityZones(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeAvailabilityZones(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeAvailabilityZones",
	}
}
