// Code generated by smithy-go-codegen DO NOT EDIT.

package licensemanagerlinuxsubscriptions

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/licensemanagerlinuxsubscriptions/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Get details for a Bring Your Own License (BYOL) subscription that's registered
// to your account.
func (c *Client) GetRegisteredSubscriptionProvider(ctx context.Context, params *GetRegisteredSubscriptionProviderInput, optFns ...func(*Options)) (*GetRegisteredSubscriptionProviderOutput, error) {
	if params == nil {
		params = &GetRegisteredSubscriptionProviderInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetRegisteredSubscriptionProvider", params, optFns, c.addOperationGetRegisteredSubscriptionProviderMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetRegisteredSubscriptionProviderOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetRegisteredSubscriptionProviderInput struct {

	// The Amazon Resource Name (ARN) of the BYOL registration resource to get details
	// for.
	//
	// This member is required.
	SubscriptionProviderArn *string

	noSmithyDocumentSerde
}

type GetRegisteredSubscriptionProviderOutput struct {

	// The timestamp from the last time License Manager retrieved subscription details
	// from your registered third-party Linux subscription provider.
	LastSuccessfulDataRetrievalTime *string

	// The Amazon Resource Name (ARN) of the third-party access secret stored in
	// Secrets Manager for the BYOL registration resource specified in the request.
	SecretArn *string

	// The Amazon Resource Name (ARN) for the BYOL registration resource specified in
	// the request.
	SubscriptionProviderArn *string

	// The subscription provider for the BYOL registration resource specified in the
	// request.
	SubscriptionProviderSource types.SubscriptionProviderSource

	// The status of the Linux subscription provider access token from the last
	// successful subscription data request.
	SubscriptionProviderStatus types.SubscriptionProviderStatus

	// The detailed message from your subscription provider token status.
	SubscriptionProviderStatusMessage *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetRegisteredSubscriptionProviderMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetRegisteredSubscriptionProvider{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetRegisteredSubscriptionProvider{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetRegisteredSubscriptionProvider"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetRegisteredSubscriptionProviderValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetRegisteredSubscriptionProvider(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetRegisteredSubscriptionProvider(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetRegisteredSubscriptionProvider",
	}
}
