// Code generated by smithy-go-codegen DO NOT EDIT.

package elasticloadbalancingv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes all trust stores for a given account by trust store arn’s or name.
func (c *Client) DescribeTrustStores(ctx context.Context, params *DescribeTrustStoresInput, optFns ...func(*Options)) (*DescribeTrustStoresOutput, error) {
	if params == nil {
		params = &DescribeTrustStoresInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeTrustStores", params, optFns, c.addOperationDescribeTrustStoresMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeTrustStoresOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeTrustStoresInput struct {

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string

	// The names of the trust stores.
	Names []string

	// The maximum number of results to return with this call.
	PageSize *int32

	// The Amazon Resource Name (ARN) of the trust store.
	TrustStoreArns []string

	noSmithyDocumentSerde
}

type DescribeTrustStoresOutput struct {

	// If there are additional results, this is the marker for the next set of
	// results. Otherwise, this is null.
	NextMarker *string

	// Information about the trust stores.
	TrustStores []types.TrustStore

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeTrustStoresMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDescribeTrustStores{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDescribeTrustStores{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeTrustStores"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeTrustStores(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeTrustStoresAPIClient is a client that implements the
// DescribeTrustStores operation.
type DescribeTrustStoresAPIClient interface {
	DescribeTrustStores(context.Context, *DescribeTrustStoresInput, ...func(*Options)) (*DescribeTrustStoresOutput, error)
}

var _ DescribeTrustStoresAPIClient = (*Client)(nil)

// DescribeTrustStoresPaginatorOptions is the paginator options for
// DescribeTrustStores
type DescribeTrustStoresPaginatorOptions struct {
	// The maximum number of results to return with this call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeTrustStoresPaginator is a paginator for DescribeTrustStores
type DescribeTrustStoresPaginator struct {
	options   DescribeTrustStoresPaginatorOptions
	client    DescribeTrustStoresAPIClient
	params    *DescribeTrustStoresInput
	nextToken *string
	firstPage bool
}

// NewDescribeTrustStoresPaginator returns a new DescribeTrustStoresPaginator
func NewDescribeTrustStoresPaginator(client DescribeTrustStoresAPIClient, params *DescribeTrustStoresInput, optFns ...func(*DescribeTrustStoresPaginatorOptions)) *DescribeTrustStoresPaginator {
	if params == nil {
		params = &DescribeTrustStoresInput{}
	}

	options := DescribeTrustStoresPaginatorOptions{}
	if params.PageSize != nil {
		options.Limit = *params.PageSize
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeTrustStoresPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeTrustStoresPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeTrustStores page.
func (p *DescribeTrustStoresPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeTrustStoresOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.PageSize = limit

	result, err := p.client.DescribeTrustStores(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextMarker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeTrustStores(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeTrustStores",
	}
}
