// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package forge

import (
	"os"

	"code.forgejo.org/f3/gof3/v3/kind"
)

const (
	ComplianceNameForkedPullRequest   = "forked_pull_request"
	ComplianceNameNoBranchPullRequest = "no_branch_pull_request"
)

type Base struct {
	name string
}

func (o *Base) GetName() string           { return o.name }
func (o *Base) SetName(name string)       { o.name = name }
func (o *Base) GetNonTestUsers() []string { return []string{} }

func (o *Base) GetKindExceptions() []kind.Kind { return nil }
func (o *Base) GetNameExceptions() []string    { return nil }

func (o *Base) DeleteAfterCompliance() bool {
	return os.Getenv("GOF3_TEST_COMPLIANCE_CLEANUP") != "false"
}
