// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

type Project struct {
	Common
	Name          string       `json:"name"`
	IsPrivate     bool         `json:"is_private"`
	IsMirror      bool         `json:"is_mirror"`
	Description   string       `json:"description"`
	DefaultBranch string       `json:"default_branch"`
	Forked        *Reference   `json:"forked"`
	HasWiki       bool         `json:"has_wiki"`
	Topics        []*Reference `json:"topics"`
}

func (o Project) Project(other Project) bool {
	return o.Equal(other.Common) &&
		o.Name == other.Name &&
		o.IsPrivate == other.IsPrivate &&
		o.IsMirror == other.IsMirror &&
		o.Description == other.Description &&
		o.DefaultBranch == other.DefaultBranch &&
		nilOrEqual(o.Forked, other.Forked) &&
		o.HasWiki == other.HasWiki &&
		arrayEqual(o.Topics, other.Topics)
}

func (o *Project) GetName() string {
	return o.Name
}

func (o *Project) GetReferences() References {
	references := o.Common.GetReferences()
	if !o.Forked.IsNil() {
		references = append(references, o.Forked)
	}
	for _, topic := range o.Topics {
		references = append(references, topic)
	}
	return references
}

func (o *Project) Clone() Interface {
	clone := &Project{}
	*clone = *o
	return clone
}
