// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import (
	"context"

	"code.forgejo.org/f3/gof3/v3/tree/generic"
)

type PullRequestDriverInterface interface {
	GetPullRequestHead(ctx context.Context) string
	GetPullRequestRef() string
}

type PullRequestNodeDriverProxyInterface interface {
	PullRequestDriverInterface
}

type PullRequestNodeInterface interface {
	generic.NodeInterface
	PullRequestNodeDriverProxyInterface
}

type pullRequestNode struct {
	generic.Node
}

func (o *pullRequestNode) GetPullRequestHead(ctx context.Context) string {
	return o.GetDriver().(PullRequestDriverInterface).GetPullRequestHead(ctx)
}

func (o *pullRequestNode) GetPullRequestRef() string {
	return o.GetDriver().(PullRequestDriverInterface).GetPullRequestRef()
}

func newPullRequestNode(ctx context.Context, tree generic.TreeInterface) generic.NodeInterface {
	node := &pullRequestNode{}
	return node.Init(node)
}
