// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// Copyright twenty-panda <twenty-panda@posteo.com>
// SPDX-License-Identifier: MIT

package http

import (
	"net/http"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestImplementation(t *testing.T) {
	i := Implementation{}

	{
		newClient := i.GetNewMigrationHTTPClient()
		assert.NotNil(t, newClient)
		client := newClient()
		assert.Nil(t, client.Transport.(*http.Transport).TLSClientConfig)
		assert.Nil(t, client.Transport.(*http.Transport).Proxy)
	}

	{
		i.SetSkipTLSVerify(true)
		proxy := "https://example.com"
		i.SetProxy(proxy)

		newClient := i.GetNewMigrationHTTPClient()
		assert.NotNil(t, newClient)
		client := newClient()
		assert.NotNil(t, client.Transport.(*http.Transport).TLSClientConfig)
		assert.True(t, client.Transport.(*http.Transport).TLSClientConfig.InsecureSkipVerify)
		assert.NotNil(t, client.Transport.(*http.Transport).Proxy)
		proxyURL, err := client.Transport.(*http.Transport).Proxy(nil)
		assert.NoError(t, err)
		assert.Equal(t, proxy, proxyURL.String())
	}
}
