// Copyright limiting-factor <limiting-factor@posteo.com>
// SPDX-License-Identifier: MIT

package f3

import (
	"time"
)

type equalConstraint[T any] interface {
	Equal(T) bool
	*T
}

func nilOrEqual[P any, T equalConstraint[P]](a, b T) bool {
	return (a == nil && b == nil) ||
		(a != nil && b != nil && a.Equal(*b))
}

func arrayEqual[P any, T equalConstraint[P]](a, b []T) bool {
	if len(a) != len(b) {
		return false
	}

	for i := 0; i < len(a); i++ {
		if !nilOrEqual(a[i], b[i]) {
			return false
		}
	}

	return true
}

func nilOrEqualTimeToDate(a, b *time.Time) bool {
	return (a == nil && b == nil) ||
		(a != nil && b != nil && a.Format(time.DateOnly) == b.Format(time.DateOnly))
}
