//////////////////////////////////////////////////////////////////////////////////////////
//                               ___            _     ___                               //
//                               |   |   \/    | ) |  |                                 //
//                           O-  |-  |   |  -  |   |  |-  -O                            //
//                               |   |_  |     |   |  |_                                //
//                                                                                      //
//////////////////////////////////////////////////////////////////////////////////////////

// SPDX-FileCopyrightText: Simon Schneegans <code@simonschneegans.de>
// SPDX-License-Identifier: MIT

// This file contains a mapping from key names to key symbols. It is based on the
// following file from libxkbcommon:
// https://raw.github.com/xkbcommon/libxkbcommon/master/src/ks_tables.h
// Commit: 003fdee1378382d4fef77089f5f4652cd2422c6a
export const NameToKeysym = {
  '0': 0x00000030,
  '1': 0x00000031,
  '2': 0x00000032,
  '3': 0x00000033,
  '3270_AltCursor': 0x0000fd10,
  '3270_Attn': 0x0000fd0e,
  '3270_BackTab': 0x0000fd05,
  '3270_ChangeScreen': 0x0000fd19,
  '3270_Copy': 0x0000fd15,
  '3270_CursorBlink': 0x0000fd0f,
  '3270_CursorSelect': 0x0000fd1c,
  '3270_DeleteWord': 0x0000fd1a,
  '3270_Duplicate': 0x0000fd01,
  '3270_Enter': 0x0000fd1e,
  '3270_EraseEOF': 0x0000fd06,
  '3270_EraseInput': 0x0000fd07,
  '3270_ExSelect': 0x0000fd1b,
  '3270_FieldMark': 0x0000fd02,
  '3270_Ident': 0x0000fd13,
  '3270_Jump': 0x0000fd12,
  '3270_KeyClick': 0x0000fd11,
  '3270_Left2': 0x0000fd04,
  '3270_PA1': 0x0000fd0a,
  '3270_PA2': 0x0000fd0b,
  '3270_PA3': 0x0000fd0c,
  '3270_Play': 0x0000fd16,
  '3270_PrintScreen': 0x0000fd1d,
  '3270_Quit': 0x0000fd09,
  '3270_Record': 0x0000fd18,
  '3270_Reset': 0x0000fd08,
  '3270_Right2': 0x0000fd03,
  '3270_Rule': 0x0000fd14,
  '3270_Setup': 0x0000fd17,
  '3270_Test': 0x0000fd0d,
  '4': 0x00000034,
  '5': 0x00000035,
  '6': 0x00000036,
  '7': 0x00000037,
  '8': 0x00000038,
  '9': 0x00000039,
  'A': 0x00000041,
  'a': 0x00000061,
  'Aacute': 0x000000c1,
  'aacute': 0x000000e1,
  'Abelowdot': 0x01001ea0,
  'abelowdot': 0x01001ea1,
  'abovedot': 0x000001ff,
  'Abreve': 0x000001c3,
  'abreve': 0x000001e3,
  'Abreveacute': 0x01001eae,
  'abreveacute': 0x01001eaf,
  'Abrevebelowdot': 0x01001eb6,
  'abrevebelowdot': 0x01001eb7,
  'Abrevegrave': 0x01001eb0,
  'abrevegrave': 0x01001eb1,
  'Abrevehook': 0x01001eb2,
  'abrevehook': 0x01001eb3,
  'Abrevetilde': 0x01001eb4,
  'abrevetilde': 0x01001eb5,
  'AccessX_Enable': 0x0000fe70,
  'AccessX_Feedback_Enable': 0x0000fe71,
  'Acircumflex': 0x000000c2,
  'acircumflex': 0x000000e2,
  'Acircumflexacute': 0x01001ea4,
  'acircumflexacute': 0x01001ea5,
  'Acircumflexbelowdot': 0x01001eac,
  'acircumflexbelowdot': 0x01001ead,
  'Acircumflexgrave': 0x01001ea6,
  'acircumflexgrave': 0x01001ea7,
  'Acircumflexhook': 0x01001ea8,
  'acircumflexhook': 0x01001ea9,
  'Acircumflextilde': 0x01001eaa,
  'acircumflextilde': 0x01001eab,
  'acute': 0x000000b4,
  'Adiaeresis': 0x000000c4,
  'adiaeresis': 0x000000e4,
  'AE': 0x000000c6,
  'ae': 0x000000e6,
  'Agrave': 0x000000c0,
  'agrave': 0x000000e0,
  'Ahook': 0x01001ea2,
  'ahook': 0x01001ea3,
  'Alt_L': 0x0000ffe9,
  'Alt_R': 0x0000ffea,
  'Amacron': 0x000003c0,
  'amacron': 0x000003e0,
  'ampersand': 0x00000026,
  'Aogonek': 0x000001a1,
  'aogonek': 0x000001b1,
  'apostrophe': 0x00000027,
  'approxeq': 0x01002248,
  'approximate': 0x000008c8,
  'Arabic_0': 0x01000660,
  'Arabic_1': 0x01000661,
  'Arabic_2': 0x01000662,
  'Arabic_3': 0x01000663,
  'Arabic_4': 0x01000664,
  'Arabic_5': 0x01000665,
  'Arabic_6': 0x01000666,
  'Arabic_7': 0x01000667,
  'Arabic_8': 0x01000668,
  'Arabic_9': 0x01000669,
  'Arabic_ain': 0x000005d9,
  'Arabic_alef': 0x000005c7,
  'Arabic_alefmaksura': 0x000005e9,
  'Arabic_beh': 0x000005c8,
  'Arabic_comma': 0x000005ac,
  'Arabic_dad': 0x000005d6,
  'Arabic_dal': 0x000005cf,
  'Arabic_damma': 0x000005ef,
  'Arabic_dammatan': 0x000005ec,
  'Arabic_ddal': 0x01000688,
  'Arabic_farsi_yeh': 0x010006cc,
  'Arabic_fatha': 0x000005ee,
  'Arabic_fathatan': 0x000005eb,
  'Arabic_feh': 0x000005e1,
  'Arabic_fullstop': 0x010006d4,
  'Arabic_gaf': 0x010006af,
  'Arabic_ghain': 0x000005da,
  'Arabic_ha': 0x000005e7,
  'Arabic_hah': 0x000005cd,
  'Arabic_hamza': 0x000005c1,
  'Arabic_hamza_above': 0x01000654,
  'Arabic_hamza_below': 0x01000655,
  'Arabic_hamzaonalef': 0x000005c3,
  'Arabic_hamzaonwaw': 0x000005c4,
  'Arabic_hamzaonyeh': 0x000005c6,
  'Arabic_hamzaunderalef': 0x000005c5,
  'Arabic_heh': 0x000005e7,
  'Arabic_heh_doachashmee': 0x010006be,
  'Arabic_heh_goal': 0x010006c1,
  'Arabic_jeem': 0x000005cc,
  'Arabic_jeh': 0x01000698,
  'Arabic_kaf': 0x000005e3,
  'Arabic_kasra': 0x000005f0,
  'Arabic_kasratan': 0x000005ed,
  'Arabic_keheh': 0x010006a9,
  'Arabic_khah': 0x000005ce,
  'Arabic_lam': 0x000005e4,
  'Arabic_madda_above': 0x01000653,
  'Arabic_maddaonalef': 0x000005c2,
  'Arabic_meem': 0x000005e5,
  'Arabic_noon': 0x000005e6,
  'Arabic_noon_ghunna': 0x010006ba,
  'Arabic_peh': 0x0100067e,
  'Arabic_percent': 0x0100066a,
  'Arabic_qaf': 0x000005e2,
  'Arabic_question_mark': 0x000005bf,
  'Arabic_ra': 0x000005d1,
  'Arabic_rreh': 0x01000691,
  'Arabic_sad': 0x000005d5,
  'Arabic_seen': 0x000005d3,
  'Arabic_semicolon': 0x000005bb,
  'Arabic_shadda': 0x000005f1,
  'Arabic_sheen': 0x000005d4,
  'Arabic_sukun': 0x000005f2,
  'Arabic_superscript_alef': 0x01000670,
  'Arabic_switch': 0x0000ff7e,
  'Arabic_tah': 0x000005d7,
  'Arabic_tatweel': 0x000005e0,
  'Arabic_tcheh': 0x01000686,
  'Arabic_teh': 0x000005ca,
  'Arabic_tehmarbuta': 0x000005c9,
  'Arabic_thal': 0x000005d0,
  'Arabic_theh': 0x000005cb,
  'Arabic_tteh': 0x01000679,
  'Arabic_veh': 0x010006a4,
  'Arabic_waw': 0x000005e8,
  'Arabic_yeh': 0x000005ea,
  'Arabic_yeh_baree': 0x010006d2,
  'Arabic_zah': 0x000005d8,
  'Arabic_zain': 0x000005d2,
  'Aring': 0x000000c5,
  'aring': 0x000000e5,
  'Armenian_accent': 0x0100055b,
  'Armenian_amanak': 0x0100055c,
  'Armenian_apostrophe': 0x0100055a,
  'Armenian_AT': 0x01000538,
  'Armenian_at': 0x01000568,
  'Armenian_AYB': 0x01000531,
  'Armenian_ayb': 0x01000561,
  'Armenian_BEN': 0x01000532,
  'Armenian_ben': 0x01000562,
  'Armenian_but': 0x0100055d,
  'Armenian_CHA': 0x01000549,
  'Armenian_cha': 0x01000579,
  'Armenian_DA': 0x01000534,
  'Armenian_da': 0x01000564,
  'Armenian_DZA': 0x01000541,
  'Armenian_dza': 0x01000571,
  'Armenian_E': 0x01000537,
  'Armenian_e': 0x01000567,
  'Armenian_exclam': 0x0100055c,
  'Armenian_FE': 0x01000556,
  'Armenian_fe': 0x01000586,
  'Armenian_full_stop': 0x01000589,
  'Armenian_GHAT': 0x01000542,
  'Armenian_ghat': 0x01000572,
  'Armenian_GIM': 0x01000533,
  'Armenian_gim': 0x01000563,
  'Armenian_HI': 0x01000545,
  'Armenian_hi': 0x01000575,
  'Armenian_HO': 0x01000540,
  'Armenian_ho': 0x01000570,
  'Armenian_hyphen': 0x0100058a,
  'Armenian_INI': 0x0100053b,
  'Armenian_ini': 0x0100056b,
  'Armenian_JE': 0x0100054b,
  'Armenian_je': 0x0100057b,
  'Armenian_KE': 0x01000554,
  'Armenian_ke': 0x01000584,
  'Armenian_KEN': 0x0100053f,
  'Armenian_ken': 0x0100056f,
  'Armenian_KHE': 0x0100053d,
  'Armenian_khe': 0x0100056d,
  'Armenian_ligature_ew': 0x01000587,
  'Armenian_LYUN': 0x0100053c,
  'Armenian_lyun': 0x0100056c,
  'Armenian_MEN': 0x01000544,
  'Armenian_men': 0x01000574,
  'Armenian_NU': 0x01000546,
  'Armenian_nu': 0x01000576,
  'Armenian_O': 0x01000555,
  'Armenian_o': 0x01000585,
  'Armenian_paruyk': 0x0100055e,
  'Armenian_PE': 0x0100054a,
  'Armenian_pe': 0x0100057a,
  'Armenian_PYUR': 0x01000553,
  'Armenian_pyur': 0x01000583,
  'Armenian_question': 0x0100055e,
  'Armenian_RA': 0x0100054c,
  'Armenian_ra': 0x0100057c,
  'Armenian_RE': 0x01000550,
  'Armenian_re': 0x01000580,
  'Armenian_SE': 0x0100054d,
  'Armenian_se': 0x0100057d,
  'Armenian_separation_mark': 0x0100055d,
  'Armenian_SHA': 0x01000547,
  'Armenian_sha': 0x01000577,
  'Armenian_shesht': 0x0100055b,
  'Armenian_TCHE': 0x01000543,
  'Armenian_tche': 0x01000573,
  'Armenian_TO': 0x01000539,
  'Armenian_to': 0x01000569,
  'Armenian_TSA': 0x0100053e,
  'Armenian_tsa': 0x0100056e,
  'Armenian_TSO': 0x01000551,
  'Armenian_tso': 0x01000581,
  'Armenian_TYUN': 0x0100054f,
  'Armenian_tyun': 0x0100057f,
  'Armenian_verjaket': 0x01000589,
  'Armenian_VEV': 0x0100054e,
  'Armenian_vev': 0x0100057e,
  'Armenian_VO': 0x01000548,
  'Armenian_vo': 0x01000578,
  'Armenian_VYUN': 0x01000552,
  'Armenian_vyun': 0x01000582,
  'Armenian_YECH': 0x01000535,
  'Armenian_yech': 0x01000565,
  'Armenian_yentamna': 0x0100058a,
  'Armenian_ZA': 0x01000536,
  'Armenian_za': 0x01000566,
  'Armenian_ZHE': 0x0100053a,
  'Armenian_zhe': 0x0100056a,
  'asciicircum': 0x0000005e,
  'asciitilde': 0x0000007e,
  'asterisk': 0x0000002a,
  'at': 0x00000040,
  'Atilde': 0x000000c3,
  'atilde': 0x000000e3,
  'AudibleBell_Enable': 0x0000fe7a,
  'B': 0x00000042,
  'b': 0x00000062,
  'Babovedot': 0x01001e02,
  'babovedot': 0x01001e03,
  'backslash': 0x0000005c,
  'BackSpace': 0x0000ff08,
  'BackTab': 0x1000ff74,
  'ballotcross': 0x00000af4,
  'bar': 0x0000007c,
  'because': 0x01002235,
  'Begin': 0x0000ff58,
  'blank': 0x000009df,
  'block': 0x100000fc,
  'botintegral': 0x000008a5,
  'botleftparens': 0x000008ac,
  'botleftsqbracket': 0x000008a8,
  'botleftsummation': 0x000008b2,
  'botrightparens': 0x000008ae,
  'botrightsqbracket': 0x000008aa,
  'botrightsummation': 0x000008b6,
  'bott': 0x000009f6,
  'botvertsummationconnector': 0x000008b4,
  'BounceKeys_Enable': 0x0000fe74,
  'braceleft': 0x0000007b,
  'braceright': 0x0000007d,
  'bracketleft': 0x0000005b,
  'bracketright': 0x0000005d,
  'braille_blank': 0x01002800,
  'braille_dot_1': 0x0000fff1,
  'braille_dot_10': 0x0000fffa,
  'braille_dot_2': 0x0000fff2,
  'braille_dot_3': 0x0000fff3,
  'braille_dot_4': 0x0000fff4,
  'braille_dot_5': 0x0000fff5,
  'braille_dot_6': 0x0000fff6,
  'braille_dot_7': 0x0000fff7,
  'braille_dot_8': 0x0000fff8,
  'braille_dot_9': 0x0000fff9,
  'braille_dots_1': 0x01002801,
  'braille_dots_12': 0x01002803,
  'braille_dots_123': 0x01002807,
  'braille_dots_1234': 0x0100280f,
  'braille_dots_12345': 0x0100281f,
  'braille_dots_123456': 0x0100283f,
  'braille_dots_1234567': 0x0100287f,
  'braille_dots_12345678': 0x010028ff,
  'braille_dots_1234568': 0x010028bf,
  'braille_dots_123457': 0x0100285f,
  'braille_dots_1234578': 0x010028df,
  'braille_dots_123458': 0x0100289f,
  'braille_dots_12346': 0x0100282f,
  'braille_dots_123467': 0x0100286f,
  'braille_dots_1234678': 0x010028ef,
  'braille_dots_123468': 0x010028af,
  'braille_dots_12347': 0x0100284f,
  'braille_dots_123478': 0x010028cf,
  'braille_dots_12348': 0x0100288f,
  'braille_dots_1235': 0x01002817,
  'braille_dots_12356': 0x01002837,
  'braille_dots_123567': 0x01002877,
  'braille_dots_1235678': 0x010028f7,
  'braille_dots_123568': 0x010028b7,
  'braille_dots_12357': 0x01002857,
  'braille_dots_123578': 0x010028d7,
  'braille_dots_12358': 0x01002897,
  'braille_dots_1236': 0x01002827,
  'braille_dots_12367': 0x01002867,
  'braille_dots_123678': 0x010028e7,
  'braille_dots_12368': 0x010028a7,
  'braille_dots_1237': 0x01002847,
  'braille_dots_12378': 0x010028c7,
  'braille_dots_1238': 0x01002887,
  'braille_dots_124': 0x0100280b,
  'braille_dots_1245': 0x0100281b,
  'braille_dots_12456': 0x0100283b,
  'braille_dots_124567': 0x0100287b,
  'braille_dots_1245678': 0x010028fb,
  'braille_dots_124568': 0x010028bb,
  'braille_dots_12457': 0x0100285b,
  'braille_dots_124578': 0x010028db,
  'braille_dots_12458': 0x0100289b,
  'braille_dots_1246': 0x0100282b,
  'braille_dots_12467': 0x0100286b,
  'braille_dots_124678': 0x010028eb,
  'braille_dots_12468': 0x010028ab,
  'braille_dots_1247': 0x0100284b,
  'braille_dots_12478': 0x010028cb,
  'braille_dots_1248': 0x0100288b,
  'braille_dots_125': 0x01002813,
  'braille_dots_1256': 0x01002833,
  'braille_dots_12567': 0x01002873,
  'braille_dots_125678': 0x010028f3,
  'braille_dots_12568': 0x010028b3,
  'braille_dots_1257': 0x01002853,
  'braille_dots_12578': 0x010028d3,
  'braille_dots_1258': 0x01002893,
  'braille_dots_126': 0x01002823,
  'braille_dots_1267': 0x01002863,
  'braille_dots_12678': 0x010028e3,
  'braille_dots_1268': 0x010028a3,
  'braille_dots_127': 0x01002843,
  'braille_dots_1278': 0x010028c3,
  'braille_dots_128': 0x01002883,
  'braille_dots_13': 0x01002805,
  'braille_dots_134': 0x0100280d,
  'braille_dots_1345': 0x0100281d,
  'braille_dots_13456': 0x0100283d,
  'braille_dots_134567': 0x0100287d,
  'braille_dots_1345678': 0x010028fd,
  'braille_dots_134568': 0x010028bd,
  'braille_dots_13457': 0x0100285d,
  'braille_dots_134578': 0x010028dd,
  'braille_dots_13458': 0x0100289d,
  'braille_dots_1346': 0x0100282d,
  'braille_dots_13467': 0x0100286d,
  'braille_dots_134678': 0x010028ed,
  'braille_dots_13468': 0x010028ad,
  'braille_dots_1347': 0x0100284d,
  'braille_dots_13478': 0x010028cd,
  'braille_dots_1348': 0x0100288d,
  'braille_dots_135': 0x01002815,
  'braille_dots_1356': 0x01002835,
  'braille_dots_13567': 0x01002875,
  'braille_dots_135678': 0x010028f5,
  'braille_dots_13568': 0x010028b5,
  'braille_dots_1357': 0x01002855,
  'braille_dots_13578': 0x010028d5,
  'braille_dots_1358': 0x01002895,
  'braille_dots_136': 0x01002825,
  'braille_dots_1367': 0x01002865,
  'braille_dots_13678': 0x010028e5,
  'braille_dots_1368': 0x010028a5,
  'braille_dots_137': 0x01002845,
  'braille_dots_1378': 0x010028c5,
  'braille_dots_138': 0x01002885,
  'braille_dots_14': 0x01002809,
  'braille_dots_145': 0x01002819,
  'braille_dots_1456': 0x01002839,
  'braille_dots_14567': 0x01002879,
  'braille_dots_145678': 0x010028f9,
  'braille_dots_14568': 0x010028b9,
  'braille_dots_1457': 0x01002859,
  'braille_dots_14578': 0x010028d9,
  'braille_dots_1458': 0x01002899,
  'braille_dots_146': 0x01002829,
  'braille_dots_1467': 0x01002869,
  'braille_dots_14678': 0x010028e9,
  'braille_dots_1468': 0x010028a9,
  'braille_dots_147': 0x01002849,
  'braille_dots_1478': 0x010028c9,
  'braille_dots_148': 0x01002889,
  'braille_dots_15': 0x01002811,
  'braille_dots_156': 0x01002831,
  'braille_dots_1567': 0x01002871,
  'braille_dots_15678': 0x010028f1,
  'braille_dots_1568': 0x010028b1,
  'braille_dots_157': 0x01002851,
  'braille_dots_1578': 0x010028d1,
  'braille_dots_158': 0x01002891,
  'braille_dots_16': 0x01002821,
  'braille_dots_167': 0x01002861,
  'braille_dots_1678': 0x010028e1,
  'braille_dots_168': 0x010028a1,
  'braille_dots_17': 0x01002841,
  'braille_dots_178': 0x010028c1,
  'braille_dots_18': 0x01002881,
  'braille_dots_2': 0x01002802,
  'braille_dots_23': 0x01002806,
  'braille_dots_234': 0x0100280e,
  'braille_dots_2345': 0x0100281e,
  'braille_dots_23456': 0x0100283e,
  'braille_dots_234567': 0x0100287e,
  'braille_dots_2345678': 0x010028fe,
  'braille_dots_234568': 0x010028be,
  'braille_dots_23457': 0x0100285e,
  'braille_dots_234578': 0x010028de,
  'braille_dots_23458': 0x0100289e,
  'braille_dots_2346': 0x0100282e,
  'braille_dots_23467': 0x0100286e,
  'braille_dots_234678': 0x010028ee,
  'braille_dots_23468': 0x010028ae,
  'braille_dots_2347': 0x0100284e,
  'braille_dots_23478': 0x010028ce,
  'braille_dots_2348': 0x0100288e,
  'braille_dots_235': 0x01002816,
  'braille_dots_2356': 0x01002836,
  'braille_dots_23567': 0x01002876,
  'braille_dots_235678': 0x010028f6,
  'braille_dots_23568': 0x010028b6,
  'braille_dots_2357': 0x01002856,
  'braille_dots_23578': 0x010028d6,
  'braille_dots_2358': 0x01002896,
  'braille_dots_236': 0x01002826,
  'braille_dots_2367': 0x01002866,
  'braille_dots_23678': 0x010028e6,
  'braille_dots_2368': 0x010028a6,
  'braille_dots_237': 0x01002846,
  'braille_dots_2378': 0x010028c6,
  'braille_dots_238': 0x01002886,
  'braille_dots_24': 0x0100280a,
  'braille_dots_245': 0x0100281a,
  'braille_dots_2456': 0x0100283a,
  'braille_dots_24567': 0x0100287a,
  'braille_dots_245678': 0x010028fa,
  'braille_dots_24568': 0x010028ba,
  'braille_dots_2457': 0x0100285a,
  'braille_dots_24578': 0x010028da,
  'braille_dots_2458': 0x0100289a,
  'braille_dots_246': 0x0100282a,
  'braille_dots_2467': 0x0100286a,
  'braille_dots_24678': 0x010028ea,
  'braille_dots_2468': 0x010028aa,
  'braille_dots_247': 0x0100284a,
  'braille_dots_2478': 0x010028ca,
  'braille_dots_248': 0x0100288a,
  'braille_dots_25': 0x01002812,
  'braille_dots_256': 0x01002832,
  'braille_dots_2567': 0x01002872,
  'braille_dots_25678': 0x010028f2,
  'braille_dots_2568': 0x010028b2,
  'braille_dots_257': 0x01002852,
  'braille_dots_2578': 0x010028d2,
  'braille_dots_258': 0x01002892,
  'braille_dots_26': 0x01002822,
  'braille_dots_267': 0x01002862,
  'braille_dots_2678': 0x010028e2,
  'braille_dots_268': 0x010028a2,
  'braille_dots_27': 0x01002842,
  'braille_dots_278': 0x010028c2,
  'braille_dots_28': 0x01002882,
  'braille_dots_3': 0x01002804,
  'braille_dots_34': 0x0100280c,
  'braille_dots_345': 0x0100281c,
  'braille_dots_3456': 0x0100283c,
  'braille_dots_34567': 0x0100287c,
  'braille_dots_345678': 0x010028fc,
  'braille_dots_34568': 0x010028bc,
  'braille_dots_3457': 0x0100285c,
  'braille_dots_34578': 0x010028dc,
  'braille_dots_3458': 0x0100289c,
  'braille_dots_346': 0x0100282c,
  'braille_dots_3467': 0x0100286c,
  'braille_dots_34678': 0x010028ec,
  'braille_dots_3468': 0x010028ac,
  'braille_dots_347': 0x0100284c,
  'braille_dots_3478': 0x010028cc,
  'braille_dots_348': 0x0100288c,
  'braille_dots_35': 0x01002814,
  'braille_dots_356': 0x01002834,
  'braille_dots_3567': 0x01002874,
  'braille_dots_35678': 0x010028f4,
  'braille_dots_3568': 0x010028b4,
  'braille_dots_357': 0x01002854,
  'braille_dots_3578': 0x010028d4,
  'braille_dots_358': 0x01002894,
  'braille_dots_36': 0x01002824,
  'braille_dots_367': 0x01002864,
  'braille_dots_3678': 0x010028e4,
  'braille_dots_368': 0x010028a4,
  'braille_dots_37': 0x01002844,
  'braille_dots_378': 0x010028c4,
  'braille_dots_38': 0x01002884,
  'braille_dots_4': 0x01002808,
  'braille_dots_45': 0x01002818,
  'braille_dots_456': 0x01002838,
  'braille_dots_4567': 0x01002878,
  'braille_dots_45678': 0x010028f8,
  'braille_dots_4568': 0x010028b8,
  'braille_dots_457': 0x01002858,
  'braille_dots_4578': 0x010028d8,
  'braille_dots_458': 0x01002898,
  'braille_dots_46': 0x01002828,
  'braille_dots_467': 0x01002868,
  'braille_dots_4678': 0x010028e8,
  'braille_dots_468': 0x010028a8,
  'braille_dots_47': 0x01002848,
  'braille_dots_478': 0x010028c8,
  'braille_dots_48': 0x01002888,
  'braille_dots_5': 0x01002810,
  'braille_dots_56': 0x01002830,
  'braille_dots_567': 0x01002870,
  'braille_dots_5678': 0x010028f0,
  'braille_dots_568': 0x010028b0,
  'braille_dots_57': 0x01002850,
  'braille_dots_578': 0x010028d0,
  'braille_dots_58': 0x01002890,
  'braille_dots_6': 0x01002820,
  'braille_dots_67': 0x01002860,
  'braille_dots_678': 0x010028e0,
  'braille_dots_68': 0x010028a0,
  'braille_dots_7': 0x01002840,
  'braille_dots_78': 0x010028c0,
  'braille_dots_8': 0x01002880,
  'Break': 0x0000ff6b,
  'breve': 0x000001a2,
  'brokenbar': 0x000000a6,
  'Byelorussian_shortu': 0x000006ae,
  'Byelorussian_SHORTU': 0x000006be,
  'C': 0x00000043,
  'c': 0x00000063,
  'c_h': 0x0000fea3,
  'C_h': 0x0000fea4,
  'C_H': 0x0000fea5,
  'Cabovedot': 0x000002c5,
  'cabovedot': 0x000002e5,
  'Cacute': 0x000001c6,
  'cacute': 0x000001e6,
  'Cancel': 0x0000ff69,
  'Caps_Lock': 0x0000ffe5,
  'careof': 0x00000ab8,
  'caret': 0x00000afc,
  'caron': 0x000001b7,
  'Ccaron': 0x000001c8,
  'ccaron': 0x000001e8,
  'Ccedilla': 0x000000c7,
  'ccedilla': 0x000000e7,
  'Ccircumflex': 0x000002c6,
  'ccircumflex': 0x000002e6,
  'cedilla': 0x000000b8,
  'cent': 0x000000a2,
  'ch': 0x0000fea0,
  'Ch': 0x0000fea1,
  'CH': 0x0000fea2,
  'checkerboard': 0x000009e1,
  'checkmark': 0x00000af3,
  'circle': 0x00000bcf,
  'Clear': 0x0000ff0b,
  'ClearLine': 0x1000ff6f,
  'club': 0x00000aec,
  'Codeinput': 0x0000ff37,
  'colon': 0x0000003a,
  'ColonSign': 0x010020a1,
  'combining_acute': 0x01000301,
  'combining_belowdot': 0x01000323,
  'combining_grave': 0x01000300,
  'combining_hook': 0x01000309,
  'combining_tilde': 0x01000303,
  'comma': 0x0000002c,
  'containsas': 0x0100220b,
  'Control_L': 0x0000ffe3,
  'Control_R': 0x0000ffe4,
  'copyright': 0x000000a9,
  'cr': 0x000009e4,
  'crossinglines': 0x000009ee,
  'CruzeiroSign': 0x010020a2,
  'cuberoot': 0x0100221b,
  'currency': 0x000000a4,
  'cursor': 0x00000aff,
  'Cyrillic_a': 0x000006c1,
  'Cyrillic_A': 0x000006e1,
  'Cyrillic_be': 0x000006c2,
  'Cyrillic_BE': 0x000006e2,
  'Cyrillic_che': 0x000006de,
  'Cyrillic_CHE': 0x000006fe,
  'Cyrillic_CHE_descender': 0x010004b6,
  'Cyrillic_che_descender': 0x010004b7,
  'Cyrillic_CHE_vertstroke': 0x010004b8,
  'Cyrillic_che_vertstroke': 0x010004b9,
  'Cyrillic_de': 0x000006c4,
  'Cyrillic_DE': 0x000006e4,
  'Cyrillic_dzhe': 0x000006af,
  'Cyrillic_DZHE': 0x000006bf,
  'Cyrillic_e': 0x000006dc,
  'Cyrillic_E': 0x000006fc,
  'Cyrillic_ef': 0x000006c6,
  'Cyrillic_EF': 0x000006e6,
  'Cyrillic_el': 0x000006cc,
  'Cyrillic_EL': 0x000006ec,
  'Cyrillic_em': 0x000006cd,
  'Cyrillic_EM': 0x000006ed,
  'Cyrillic_en': 0x000006ce,
  'Cyrillic_EN': 0x000006ee,
  'Cyrillic_EN_descender': 0x010004a2,
  'Cyrillic_en_descender': 0x010004a3,
  'Cyrillic_er': 0x000006d2,
  'Cyrillic_ER': 0x000006f2,
  'Cyrillic_es': 0x000006d3,
  'Cyrillic_ES': 0x000006f3,
  'Cyrillic_ghe': 0x000006c7,
  'Cyrillic_GHE': 0x000006e7,
  'Cyrillic_GHE_bar': 0x01000492,
  'Cyrillic_ghe_bar': 0x01000493,
  'Cyrillic_ha': 0x000006c8,
  'Cyrillic_HA': 0x000006e8,
  'Cyrillic_HA_descender': 0x010004b2,
  'Cyrillic_ha_descender': 0x010004b3,
  'Cyrillic_hardsign': 0x000006df,
  'Cyrillic_HARDSIGN': 0x000006ff,
  'Cyrillic_i': 0x000006c9,
  'Cyrillic_I': 0x000006e9,
  'Cyrillic_I_macron': 0x010004e2,
  'Cyrillic_i_macron': 0x010004e3,
  'Cyrillic_ie': 0x000006c5,
  'Cyrillic_IE': 0x000006e5,
  'Cyrillic_io': 0x000006a3,
  'Cyrillic_IO': 0x000006b3,
  'Cyrillic_je': 0x000006a8,
  'Cyrillic_JE': 0x000006b8,
  'Cyrillic_ka': 0x000006cb,
  'Cyrillic_KA': 0x000006eb,
  'Cyrillic_KA_descender': 0x0100049a,
  'Cyrillic_ka_descender': 0x0100049b,
  'Cyrillic_KA_vertstroke': 0x0100049c,
  'Cyrillic_ka_vertstroke': 0x0100049d,
  'Cyrillic_lje': 0x000006a9,
  'Cyrillic_LJE': 0x000006b9,
  'Cyrillic_nje': 0x000006aa,
  'Cyrillic_NJE': 0x000006ba,
  'Cyrillic_o': 0x000006cf,
  'Cyrillic_O': 0x000006ef,
  'Cyrillic_O_bar': 0x010004e8,
  'Cyrillic_o_bar': 0x010004e9,
  'Cyrillic_pe': 0x000006d0,
  'Cyrillic_PE': 0x000006f0,
  'Cyrillic_SCHWA': 0x010004d8,
  'Cyrillic_schwa': 0x010004d9,
  'Cyrillic_sha': 0x000006db,
  'Cyrillic_SHA': 0x000006fb,
  'Cyrillic_shcha': 0x000006dd,
  'Cyrillic_SHCHA': 0x000006fd,
  'Cyrillic_SHHA': 0x010004ba,
  'Cyrillic_shha': 0x010004bb,
  'Cyrillic_shorti': 0x000006ca,
  'Cyrillic_SHORTI': 0x000006ea,
  'Cyrillic_softsign': 0x000006d8,
  'Cyrillic_SOFTSIGN': 0x000006f8,
  'Cyrillic_te': 0x000006d4,
  'Cyrillic_TE': 0x000006f4,
  'Cyrillic_tse': 0x000006c3,
  'Cyrillic_TSE': 0x000006e3,
  'Cyrillic_u': 0x000006d5,
  'Cyrillic_U': 0x000006f5,
  'Cyrillic_U_macron': 0x010004ee,
  'Cyrillic_u_macron': 0x010004ef,
  'Cyrillic_U_straight': 0x010004ae,
  'Cyrillic_u_straight': 0x010004af,
  'Cyrillic_U_straight_bar': 0x010004b0,
  'Cyrillic_u_straight_bar': 0x010004b1,
  'Cyrillic_ve': 0x000006d7,
  'Cyrillic_VE': 0x000006f7,
  'Cyrillic_ya': 0x000006d1,
  'Cyrillic_YA': 0x000006f1,
  'Cyrillic_yeru': 0x000006d9,
  'Cyrillic_YERU': 0x000006f9,
  'Cyrillic_yu': 0x000006c0,
  'Cyrillic_YU': 0x000006e0,
  'Cyrillic_ze': 0x000006da,
  'Cyrillic_ZE': 0x000006fa,
  'Cyrillic_zhe': 0x000006d6,
  'Cyrillic_ZHE': 0x000006f6,
  'Cyrillic_ZHE_descender': 0x01000496,
  'Cyrillic_zhe_descender': 0x01000497,
  'D': 0x00000044,
  'd': 0x00000064,
  'Dabovedot': 0x01001e0a,
  'dabovedot': 0x01001e0b,
  'Dacute_accent': 0x1000fe27,
  'dagger': 0x00000af1,
  'Dcaron': 0x000001cf,
  'dcaron': 0x000001ef,
  'Dcedilla_accent': 0x1000fe2c,
  'Dcircumflex_accent': 0x1000fe5e,
  'Ddiaeresis': 0x1000fe22,
  'dead_a': 0x0000fe80,
  'dead_A': 0x0000fe81,
  'dead_abovecomma': 0x0000fe64,
  'dead_abovedot': 0x0000fe56,
  'dead_abovereversedcomma': 0x0000fe65,
  'dead_abovering': 0x0000fe58,
  'dead_aboveverticalline': 0x0000fe91,
  'dead_acute': 0x0000fe51,
  'dead_belowbreve': 0x0000fe6b,
  'dead_belowcircumflex': 0x0000fe69,
  'dead_belowcomma': 0x0000fe6e,
  'dead_belowdiaeresis': 0x0000fe6c,
  'dead_belowdot': 0x0000fe60,
  'dead_belowmacron': 0x0000fe68,
  'dead_belowring': 0x0000fe67,
  'dead_belowtilde': 0x0000fe6a,
  'dead_belowverticalline': 0x0000fe92,
  'dead_breve': 0x0000fe55,
  'dead_capital_schwa': 0x0000fe8b,
  'dead_caron': 0x0000fe5a,
  'dead_cedilla': 0x0000fe5b,
  'dead_circumflex': 0x0000fe52,
  'dead_currency': 0x0000fe6f,
  'dead_dasia': 0x0000fe65,
  'dead_diaeresis': 0x0000fe57,
  'dead_doubleacute': 0x0000fe59,
  'dead_doublegrave': 0x0000fe66,
  'dead_e': 0x0000fe82,
  'dead_E': 0x0000fe83,
  'dead_grave': 0x0000fe50,
  'dead_greek': 0x0000fe8c,
  'dead_hook': 0x0000fe61,
  'dead_horn': 0x0000fe62,
  'dead_i': 0x0000fe84,
  'dead_I': 0x0000fe85,
  'dead_invertedbreve': 0x0000fe6d,
  'dead_iota': 0x0000fe5d,
  'dead_longsolidusoverlay': 0x0000fe93,
  'dead_lowline': 0x0000fe90,
  'dead_macron': 0x0000fe54,
  'dead_o': 0x0000fe86,
  'dead_O': 0x0000fe87,
  'dead_ogonek': 0x0000fe5c,
  'dead_perispomeni': 0x0000fe53,
  'dead_psili': 0x0000fe64,
  'dead_semivoiced_sound': 0x0000fe5f,
  'dead_small_schwa': 0x0000fe8a,
  'dead_stroke': 0x0000fe63,
  'dead_tilde': 0x0000fe53,
  'dead_u': 0x0000fe88,
  'dead_U': 0x0000fe89,
  'dead_voiced_sound': 0x0000fe5e,
  'decimalpoint': 0x00000abd,
  'degree': 0x000000b0,
  'Delete': 0x0000ffff,
  'DeleteChar': 0x1000ff73,
  'DeleteLine': 0x1000ff71,
  'Dgrave_accent': 0x1000fe60,
  'diaeresis': 0x000000a8,
  'diamond': 0x00000aed,
  'digitspace': 0x00000aa5,
  'dintegral': 0x0100222c,
  'division': 0x000000f7,
  'dollar': 0x00000024,
  'DongSign': 0x010020ab,
  'doubbaselinedot': 0x00000aaf,
  'doubleacute': 0x000001bd,
  'doubledagger': 0x00000af2,
  'doublelowquotemark': 0x00000afe,
  'Down': 0x0000ff54,
  'downarrow': 0x000008fe,
  'downcaret': 0x00000ba8,
  'downshoe': 0x00000bd6,
  'downstile': 0x00000bc4,
  'downtack': 0x00000bc2,
  'DRemove': 0x1000ff00,
  'Dring_accent': 0x1000feb0,
  'Dstroke': 0x000001d0,
  'dstroke': 0x000001f0,
  'Dtilde': 0x1000fe7e,
  'E': 0x00000045,
  'e': 0x00000065,
  'Eabovedot': 0x000003cc,
  'eabovedot': 0x000003ec,
  'Eacute': 0x000000c9,
  'eacute': 0x000000e9,
  'Ebelowdot': 0x01001eb8,
  'ebelowdot': 0x01001eb9,
  'Ecaron': 0x000001cc,
  'ecaron': 0x000001ec,
  'Ecircumflex': 0x000000ca,
  'ecircumflex': 0x000000ea,
  'Ecircumflexacute': 0x01001ebe,
  'ecircumflexacute': 0x01001ebf,
  'Ecircumflexbelowdot': 0x01001ec6,
  'ecircumflexbelowdot': 0x01001ec7,
  'Ecircumflexgrave': 0x01001ec0,
  'ecircumflexgrave': 0x01001ec1,
  'Ecircumflexhook': 0x01001ec2,
  'ecircumflexhook': 0x01001ec3,
  'Ecircumflextilde': 0x01001ec4,
  'ecircumflextilde': 0x01001ec5,
  'EcuSign': 0x010020a0,
  'Ediaeresis': 0x000000cb,
  'ediaeresis': 0x000000eb,
  'Egrave': 0x000000c8,
  'egrave': 0x000000e8,
  'Ehook': 0x01001eba,
  'ehook': 0x01001ebb,
  'eightsubscript': 0x01002088,
  'eightsuperior': 0x01002078,
  'Eisu_Shift': 0x0000ff2f,
  'Eisu_toggle': 0x0000ff30,
  'elementof': 0x01002208,
  'ellipsis': 0x00000aae,
  'em3space': 0x00000aa3,
  'em4space': 0x00000aa4,
  'Emacron': 0x000003aa,
  'emacron': 0x000003ba,
  'emdash': 0x00000aa9,
  'emfilledcircle': 0x00000ade,
  'emfilledrect': 0x00000adf,
  'emopencircle': 0x00000ace,
  'emopenrectangle': 0x00000acf,
  'emptyset': 0x01002205,
  'emspace': 0x00000aa1,
  'End': 0x0000ff57,
  'endash': 0x00000aaa,
  'enfilledcircbullet': 0x00000ae6,
  'enfilledsqbullet': 0x00000ae7,
  'ENG': 0x000003bd,
  'eng': 0x000003bf,
  'enopencircbullet': 0x00000ae0,
  'enopensquarebullet': 0x00000ae1,
  'enspace': 0x00000aa2,
  'Eogonek': 0x000001ca,
  'eogonek': 0x000001ea,
  'equal': 0x0000003d,
  'Escape': 0x0000ff1b,
  'ETH': 0x000000d0,
  'Eth': 0x000000d0,
  'eth': 0x000000f0,
  'Etilde': 0x01001ebc,
  'etilde': 0x01001ebd,
  'EuroSign': 0x000020ac,
  'exclam': 0x00000021,
  'exclamdown': 0x000000a1,
  'Execute': 0x0000ff62,
  'Ext16bit_L': 0x1000ff76,
  'Ext16bit_R': 0x1000ff77,
  'EZH': 0x010001b7,
  'ezh': 0x01000292,
  'F': 0x00000046,
  'f': 0x00000066,
  'F1': 0x0000ffbe,
  'F10': 0x0000ffc7,
  'F11': 0x0000ffc8,
  'F12': 0x0000ffc9,
  'F13': 0x0000ffca,
  'F14': 0x0000ffcb,
  'F15': 0x0000ffcc,
  'F16': 0x0000ffcd,
  'F17': 0x0000ffce,
  'F18': 0x0000ffcf,
  'F19': 0x0000ffd0,
  'F2': 0x0000ffbf,
  'F20': 0x0000ffd1,
  'F21': 0x0000ffd2,
  'F22': 0x0000ffd3,
  'F23': 0x0000ffd4,
  'F24': 0x0000ffd5,
  'F25': 0x0000ffd6,
  'F26': 0x0000ffd7,
  'F27': 0x0000ffd8,
  'F28': 0x0000ffd9,
  'F29': 0x0000ffda,
  'F3': 0x0000ffc0,
  'F30': 0x0000ffdb,
  'F31': 0x0000ffdc,
  'F32': 0x0000ffdd,
  'F33': 0x0000ffde,
  'F34': 0x0000ffdf,
  'F35': 0x0000ffe0,
  'F4': 0x0000ffc1,
  'F5': 0x0000ffc2,
  'F6': 0x0000ffc3,
  'F7': 0x0000ffc4,
  'F8': 0x0000ffc5,
  'F9': 0x0000ffc6,
  'Fabovedot': 0x01001e1e,
  'fabovedot': 0x01001e1f,
  'Farsi_0': 0x010006f0,
  'Farsi_1': 0x010006f1,
  'Farsi_2': 0x010006f2,
  'Farsi_3': 0x010006f3,
  'Farsi_4': 0x010006f4,
  'Farsi_5': 0x010006f5,
  'Farsi_6': 0x010006f6,
  'Farsi_7': 0x010006f7,
  'Farsi_8': 0x010006f8,
  'Farsi_9': 0x010006f9,
  'Farsi_yeh': 0x010006cc,
  'femalesymbol': 0x00000af8,
  'ff': 0x000009e3,
  'FFrancSign': 0x010020a3,
  'figdash': 0x00000abb,
  'filledlefttribullet': 0x00000adc,
  'filledrectbullet': 0x00000adb,
  'filledrighttribullet': 0x00000add,
  'filledtribulletdown': 0x00000ae9,
  'filledtribulletup': 0x00000ae8,
  'Find': 0x0000ff68,
  'First_Virtual_Screen': 0x0000fed0,
  'fiveeighths': 0x00000ac5,
  'fivesixths': 0x00000ab7,
  'fivesubscript': 0x01002085,
  'fivesuperior': 0x01002075,
  'fourfifths': 0x00000ab5,
  'foursubscript': 0x01002084,
  'foursuperior': 0x01002074,
  'fourthroot': 0x0100221c,
  'function': 0x000008f6,
  'G': 0x00000047,
  'g': 0x00000067,
  'Gabovedot': 0x000002d5,
  'gabovedot': 0x000002f5,
  'Gbreve': 0x000002ab,
  'gbreve': 0x000002bb,
  'Gcaron': 0x010001e6,
  'gcaron': 0x010001e7,
  'Gcedilla': 0x000003ab,
  'gcedilla': 0x000003bb,
  'Gcircumflex': 0x000002d8,
  'gcircumflex': 0x000002f8,
  'Georgian_an': 0x010010d0,
  'Georgian_ban': 0x010010d1,
  'Georgian_can': 0x010010ea,
  'Georgian_char': 0x010010ed,
  'Georgian_chin': 0x010010e9,
  'Georgian_cil': 0x010010ec,
  'Georgian_don': 0x010010d3,
  'Georgian_en': 0x010010d4,
  'Georgian_fi': 0x010010f6,
  'Georgian_gan': 0x010010d2,
  'Georgian_ghan': 0x010010e6,
  'Georgian_hae': 0x010010f0,
  'Georgian_har': 0x010010f4,
  'Georgian_he': 0x010010f1,
  'Georgian_hie': 0x010010f2,
  'Georgian_hoe': 0x010010f5,
  'Georgian_in': 0x010010d8,
  'Georgian_jhan': 0x010010ef,
  'Georgian_jil': 0x010010eb,
  'Georgian_kan': 0x010010d9,
  'Georgian_khar': 0x010010e5,
  'Georgian_las': 0x010010da,
  'Georgian_man': 0x010010db,
  'Georgian_nar': 0x010010dc,
  'Georgian_on': 0x010010dd,
  'Georgian_par': 0x010010de,
  'Georgian_phar': 0x010010e4,
  'Georgian_qar': 0x010010e7,
  'Georgian_rae': 0x010010e0,
  'Georgian_san': 0x010010e1,
  'Georgian_shin': 0x010010e8,
  'Georgian_tan': 0x010010d7,
  'Georgian_tar': 0x010010e2,
  'Georgian_un': 0x010010e3,
  'Georgian_vin': 0x010010d5,
  'Georgian_we': 0x010010f3,
  'Georgian_xan': 0x010010ee,
  'Georgian_zen': 0x010010d6,
  'Georgian_zhar': 0x010010df,
  'grave': 0x00000060,
  'greater': 0x0000003e,
  'greaterthanequal': 0x000008be,
  'Greek_accentdieresis': 0x000007ae,
  'Greek_ALPHA': 0x000007c1,
  'Greek_alpha': 0x000007e1,
  'Greek_ALPHAaccent': 0x000007a1,
  'Greek_alphaaccent': 0x000007b1,
  'Greek_BETA': 0x000007c2,
  'Greek_beta': 0x000007e2,
  'Greek_CHI': 0x000007d7,
  'Greek_chi': 0x000007f7,
  'Greek_DELTA': 0x000007c4,
  'Greek_delta': 0x000007e4,
  'Greek_EPSILON': 0x000007c5,
  'Greek_epsilon': 0x000007e5,
  'Greek_EPSILONaccent': 0x000007a2,
  'Greek_epsilonaccent': 0x000007b2,
  'Greek_ETA': 0x000007c7,
  'Greek_eta': 0x000007e7,
  'Greek_ETAaccent': 0x000007a3,
  'Greek_etaaccent': 0x000007b3,
  'Greek_finalsmallsigma': 0x000007f3,
  'Greek_GAMMA': 0x000007c3,
  'Greek_gamma': 0x000007e3,
  'Greek_horizbar': 0x000007af,
  'Greek_IOTA': 0x000007c9,
  'Greek_iota': 0x000007e9,
  'Greek_IOTAaccent': 0x000007a4,
  'Greek_iotaaccent': 0x000007b4,
  'Greek_iotaaccentdieresis': 0x000007b6,
  'Greek_IOTAdiaeresis': 0x000007a5,
  'Greek_IOTAdieresis': 0x000007a5,
  'Greek_iotadieresis': 0x000007b5,
  'Greek_KAPPA': 0x000007ca,
  'Greek_kappa': 0x000007ea,
  'Greek_LAMBDA': 0x000007cb,
  'Greek_lambda': 0x000007eb,
  'Greek_LAMDA': 0x000007cb,
  'Greek_lamda': 0x000007eb,
  'Greek_MU': 0x000007cc,
  'Greek_mu': 0x000007ec,
  'Greek_NU': 0x000007cd,
  'Greek_nu': 0x000007ed,
  'Greek_OMEGA': 0x000007d9,
  'Greek_omega': 0x000007f9,
  'Greek_OMEGAaccent': 0x000007ab,
  'Greek_omegaaccent': 0x000007bb,
  'Greek_OMICRON': 0x000007cf,
  'Greek_omicron': 0x000007ef,
  'Greek_OMICRONaccent': 0x000007a7,
  'Greek_omicronaccent': 0x000007b7,
  'Greek_PHI': 0x000007d6,
  'Greek_phi': 0x000007f6,
  'Greek_PI': 0x000007d0,
  'Greek_pi': 0x000007f0,
  'Greek_PSI': 0x000007d8,
  'Greek_psi': 0x000007f8,
  'Greek_RHO': 0x000007d1,
  'Greek_rho': 0x000007f1,
  'Greek_SIGMA': 0x000007d2,
  'Greek_sigma': 0x000007f2,
  'Greek_switch': 0x0000ff7e,
  'Greek_TAU': 0x000007d4,
  'Greek_tau': 0x000007f4,
  'Greek_THETA': 0x000007c8,
  'Greek_theta': 0x000007e8,
  'Greek_UPSILON': 0x000007d5,
  'Greek_upsilon': 0x000007f5,
  'Greek_UPSILONaccent': 0x000007a8,
  'Greek_upsilonaccent': 0x000007b8,
  'Greek_upsilonaccentdieresis': 0x000007ba,
  'Greek_UPSILONdieresis': 0x000007a9,
  'Greek_upsilondieresis': 0x000007b9,
  'Greek_XI': 0x000007ce,
  'Greek_xi': 0x000007ee,
  'Greek_ZETA': 0x000007c6,
  'Greek_zeta': 0x000007e6,
  'guilder': 0x100000be,
  'guillemotleft': 0x000000ab,
  'guillemotright': 0x000000bb,
  'H': 0x00000048,
  'h': 0x00000068,
  'hairspace': 0x00000aa8,
  'Hangul': 0x0000ff31,
  'Hangul_A': 0x00000ebf,
  'Hangul_AE': 0x00000ec0,
  'Hangul_AraeA': 0x00000ef6,
  'Hangul_AraeAE': 0x00000ef7,
  'Hangul_Banja': 0x0000ff39,
  'Hangul_Cieuc': 0x00000eba,
  'Hangul_Codeinput': 0x0000ff37,
  'Hangul_Dikeud': 0x00000ea7,
  'Hangul_E': 0x00000ec4,
  'Hangul_End': 0x0000ff33,
  'Hangul_EO': 0x00000ec3,
  'Hangul_EU': 0x00000ed1,
  'Hangul_Hanja': 0x0000ff34,
  'Hangul_Hieuh': 0x00000ebe,
  'Hangul_I': 0x00000ed3,
  'Hangul_Ieung': 0x00000eb7,
  'Hangul_J_Cieuc': 0x00000eea,
  'Hangul_J_Dikeud': 0x00000eda,
  'Hangul_J_Hieuh': 0x00000eee,
  'Hangul_J_Ieung': 0x00000ee8,
  'Hangul_J_Jieuj': 0x00000ee9,
  'Hangul_J_Khieuq': 0x00000eeb,
  'Hangul_J_Kiyeog': 0x00000ed4,
  'Hangul_J_KiyeogSios': 0x00000ed6,
  'Hangul_J_KkogjiDalrinIeung': 0x00000ef9,
  'Hangul_J_Mieum': 0x00000ee3,
  'Hangul_J_Nieun': 0x00000ed7,
  'Hangul_J_NieunHieuh': 0x00000ed9,
  'Hangul_J_NieunJieuj': 0x00000ed8,
  'Hangul_J_PanSios': 0x00000ef8,
  'Hangul_J_Phieuf': 0x00000eed,
  'Hangul_J_Pieub': 0x00000ee4,
  'Hangul_J_PieubSios': 0x00000ee5,
  'Hangul_J_Rieul': 0x00000edb,
  'Hangul_J_RieulHieuh': 0x00000ee2,
  'Hangul_J_RieulKiyeog': 0x00000edc,
  'Hangul_J_RieulMieum': 0x00000edd,
  'Hangul_J_RieulPhieuf': 0x00000ee1,
  'Hangul_J_RieulPieub': 0x00000ede,
  'Hangul_J_RieulSios': 0x00000edf,
  'Hangul_J_RieulTieut': 0x00000ee0,
  'Hangul_J_Sios': 0x00000ee6,
  'Hangul_J_SsangKiyeog': 0x00000ed5,
  'Hangul_J_SsangSios': 0x00000ee7,
  'Hangul_J_Tieut': 0x00000eec,
  'Hangul_J_YeorinHieuh': 0x00000efa,
  'Hangul_Jamo': 0x0000ff35,
  'Hangul_Jeonja': 0x0000ff38,
  'Hangul_Jieuj': 0x00000eb8,
  'Hangul_Khieuq': 0x00000ebb,
  'Hangul_Kiyeog': 0x00000ea1,
  'Hangul_KiyeogSios': 0x00000ea3,
  'Hangul_KkogjiDalrinIeung': 0x00000ef3,
  'Hangul_Mieum': 0x00000eb1,
  'Hangul_MultipleCandidate': 0x0000ff3d,
  'Hangul_Nieun': 0x00000ea4,
  'Hangul_NieunHieuh': 0x00000ea6,
  'Hangul_NieunJieuj': 0x00000ea5,
  'Hangul_O': 0x00000ec7,
  'Hangul_OE': 0x00000eca,
  'Hangul_PanSios': 0x00000ef2,
  'Hangul_Phieuf': 0x00000ebd,
  'Hangul_Pieub': 0x00000eb2,
  'Hangul_PieubSios': 0x00000eb4,
  'Hangul_PostHanja': 0x0000ff3b,
  'Hangul_PreHanja': 0x0000ff3a,
  'Hangul_PreviousCandidate': 0x0000ff3e,
  'Hangul_Rieul': 0x00000ea9,
  'Hangul_RieulHieuh': 0x00000eb0,
  'Hangul_RieulKiyeog': 0x00000eaa,
  'Hangul_RieulMieum': 0x00000eab,
  'Hangul_RieulPhieuf': 0x00000eaf,
  'Hangul_RieulPieub': 0x00000eac,
  'Hangul_RieulSios': 0x00000ead,
  'Hangul_RieulTieut': 0x00000eae,
  'Hangul_RieulYeorinHieuh': 0x00000eef,
  'Hangul_Romaja': 0x0000ff36,
  'Hangul_SingleCandidate': 0x0000ff3c,
  'Hangul_Sios': 0x00000eb5,
  'Hangul_Special': 0x0000ff3f,
  'Hangul_SsangDikeud': 0x00000ea8,
  'Hangul_SsangJieuj': 0x00000eb9,
  'Hangul_SsangKiyeog': 0x00000ea2,
  'Hangul_SsangPieub': 0x00000eb3,
  'Hangul_SsangSios': 0x00000eb6,
  'Hangul_Start': 0x0000ff32,
  'Hangul_SunkyeongeumMieum': 0x00000ef0,
  'Hangul_SunkyeongeumPhieuf': 0x00000ef4,
  'Hangul_SunkyeongeumPieub': 0x00000ef1,
  'Hangul_switch': 0x0000ff7e,
  'Hangul_Tieut': 0x00000ebc,
  'Hangul_U': 0x00000ecc,
  'Hangul_WA': 0x00000ec8,
  'Hangul_WAE': 0x00000ec9,
  'Hangul_WE': 0x00000ece,
  'Hangul_WEO': 0x00000ecd,
  'Hangul_WI': 0x00000ecf,
  'Hangul_YA': 0x00000ec1,
  'Hangul_YAE': 0x00000ec2,
  'Hangul_YE': 0x00000ec6,
  'Hangul_YEO': 0x00000ec5,
  'Hangul_YeorinHieuh': 0x00000ef5,
  'Hangul_YI': 0x00000ed2,
  'Hangul_YO': 0x00000ecb,
  'Hangul_YU': 0x00000ed0,
  'Hankaku': 0x0000ff29,
  'Hcircumflex': 0x000002a6,
  'hcircumflex': 0x000002b6,
  'heart': 0x00000aee,
  'hebrew_aleph': 0x00000ce0,
  'hebrew_ayin': 0x00000cf2,
  'hebrew_bet': 0x00000ce1,
  'hebrew_beth': 0x00000ce1,
  'hebrew_chet': 0x00000ce7,
  'hebrew_dalet': 0x00000ce3,
  'hebrew_daleth': 0x00000ce3,
  'hebrew_doublelowline': 0x00000cdf,
  'hebrew_finalkaph': 0x00000cea,
  'hebrew_finalmem': 0x00000ced,
  'hebrew_finalnun': 0x00000cef,
  'hebrew_finalpe': 0x00000cf3,
  'hebrew_finalzade': 0x00000cf5,
  'hebrew_finalzadi': 0x00000cf5,
  'hebrew_gimel': 0x00000ce2,
  'hebrew_gimmel': 0x00000ce2,
  'hebrew_he': 0x00000ce4,
  'hebrew_het': 0x00000ce7,
  'hebrew_kaph': 0x00000ceb,
  'hebrew_kuf': 0x00000cf7,
  'hebrew_lamed': 0x00000cec,
  'hebrew_mem': 0x00000cee,
  'hebrew_nun': 0x00000cf0,
  'hebrew_pe': 0x00000cf4,
  'hebrew_qoph': 0x00000cf7,
  'hebrew_resh': 0x00000cf8,
  'hebrew_samech': 0x00000cf1,
  'hebrew_samekh': 0x00000cf1,
  'hebrew_shin': 0x00000cf9,
  'Hebrew_switch': 0x0000ff7e,
  'hebrew_taf': 0x00000cfa,
  'hebrew_taw': 0x00000cfa,
  'hebrew_tet': 0x00000ce8,
  'hebrew_teth': 0x00000ce8,
  'hebrew_waw': 0x00000ce5,
  'hebrew_yod': 0x00000ce9,
  'hebrew_zade': 0x00000cf6,
  'hebrew_zadi': 0x00000cf6,
  'hebrew_zain': 0x00000ce6,
  'hebrew_zayin': 0x00000ce6,
  'Help': 0x0000ff6a,
  'Henkan': 0x0000ff23,
  'Henkan_Mode': 0x0000ff23,
  'hexagram': 0x00000ada,
  'Hiragana': 0x0000ff25,
  'Hiragana_Katakana': 0x0000ff27,
  'Home': 0x0000ff50,
  'horizconnector': 0x000008a3,
  'horizlinescan1': 0x000009ef,
  'horizlinescan3': 0x000009f0,
  'horizlinescan5': 0x000009f1,
  'horizlinescan7': 0x000009f2,
  'horizlinescan9': 0x000009f3,
  'hpBackTab': 0x1000ff74,
  'hpblock': 0x100000fc,
  'hpClearLine': 0x1000ff6f,
  'hpDeleteChar': 0x1000ff73,
  'hpDeleteLine': 0x1000ff71,
  'hpguilder': 0x100000be,
  'hpInsertChar': 0x1000ff72,
  'hpInsertLine': 0x1000ff70,
  'hpIO': 0x100000ee,
  'hpKP_BackTab': 0x1000ff75,
  'hplira': 0x100000af,
  'hplongminus': 0x100000f6,
  'hpModelock1': 0x1000ff48,
  'hpModelock2': 0x1000ff49,
  'hpmute_acute': 0x100000a8,
  'hpmute_asciicircum': 0x100000aa,
  'hpmute_asciitilde': 0x100000ac,
  'hpmute_diaeresis': 0x100000ab,
  'hpmute_grave': 0x100000a9,
  'hpReset': 0x1000ff6c,
  'hpSystem': 0x1000ff6d,
  'hpUser': 0x1000ff6e,
  'hpYdiaeresis': 0x100000ee,
  'Hstroke': 0x000002a1,
  'hstroke': 0x000002b1,
  'ht': 0x000009e2,
  'Hyper_L': 0x0000ffed,
  'Hyper_R': 0x0000ffee,
  'hyphen': 0x000000ad,
  'I': 0x00000049,
  'i': 0x00000069,
  'Iabovedot': 0x000002a9,
  'Iacute': 0x000000cd,
  'iacute': 0x000000ed,
  'Ibelowdot': 0x01001eca,
  'ibelowdot': 0x01001ecb,
  'Ibreve': 0x0100012c,
  'ibreve': 0x0100012d,
  'Icircumflex': 0x000000ce,
  'icircumflex': 0x000000ee,
  'identical': 0x000008cf,
  'Idiaeresis': 0x000000cf,
  'idiaeresis': 0x000000ef,
  'idotless': 0x000002b9,
  'ifonlyif': 0x000008cd,
  'Igrave': 0x000000cc,
  'igrave': 0x000000ec,
  'Ihook': 0x01001ec8,
  'ihook': 0x01001ec9,
  'Imacron': 0x000003cf,
  'imacron': 0x000003ef,
  'implies': 0x000008ce,
  'includedin': 0x000008da,
  'includes': 0x000008db,
  'infinity': 0x000008c2,
  'Insert': 0x0000ff63,
  'InsertChar': 0x1000ff72,
  'InsertLine': 0x1000ff70,
  'integral': 0x000008bf,
  'intersection': 0x000008dc,
  'IO': 0x100000ee,
  'Iogonek': 0x000003c7,
  'iogonek': 0x000003e7,
  'ISO_Center_Object': 0x0000fe33,
  'ISO_Continuous_Underline': 0x0000fe30,
  'ISO_Discontinuous_Underline': 0x0000fe31,
  'ISO_Emphasize': 0x0000fe32,
  'ISO_Enter': 0x0000fe34,
  'ISO_Fast_Cursor_Down': 0x0000fe2f,
  'ISO_Fast_Cursor_Left': 0x0000fe2c,
  'ISO_Fast_Cursor_Right': 0x0000fe2d,
  'ISO_Fast_Cursor_Up': 0x0000fe2e,
  'ISO_First_Group': 0x0000fe0c,
  'ISO_First_Group_Lock': 0x0000fe0d,
  'ISO_Group_Latch': 0x0000fe06,
  'ISO_Group_Lock': 0x0000fe07,
  'ISO_Group_Shift': 0x0000ff7e,
  'ISO_Last_Group': 0x0000fe0e,
  'ISO_Last_Group_Lock': 0x0000fe0f,
  'ISO_Left_Tab': 0x0000fe20,
  'ISO_Level2_Latch': 0x0000fe02,
  'ISO_Level3_Latch': 0x0000fe04,
  'ISO_Level3_Lock': 0x0000fe05,
  'ISO_Level3_Shift': 0x0000fe03,
  'ISO_Level5_Latch': 0x0000fe12,
  'ISO_Level5_Lock': 0x0000fe13,
  'ISO_Level5_Shift': 0x0000fe11,
  'ISO_Lock': 0x0000fe01,
  'ISO_Move_Line_Down': 0x0000fe22,
  'ISO_Move_Line_Up': 0x0000fe21,
  'ISO_Next_Group': 0x0000fe08,
  'ISO_Next_Group_Lock': 0x0000fe09,
  'ISO_Partial_Line_Down': 0x0000fe24,
  'ISO_Partial_Line_Up': 0x0000fe23,
  'ISO_Partial_Space_Left': 0x0000fe25,
  'ISO_Partial_Space_Right': 0x0000fe26,
  'ISO_Prev_Group': 0x0000fe0a,
  'ISO_Prev_Group_Lock': 0x0000fe0b,
  'ISO_Release_Both_Margins': 0x0000fe2b,
  'ISO_Release_Margin_Left': 0x0000fe29,
  'ISO_Release_Margin_Right': 0x0000fe2a,
  'ISO_Set_Margin_Left': 0x0000fe27,
  'ISO_Set_Margin_Right': 0x0000fe28,
  'Itilde': 0x000003a5,
  'itilde': 0x000003b5,
  'J': 0x0000004a,
  'j': 0x0000006a,
  'Jcircumflex': 0x000002ac,
  'jcircumflex': 0x000002bc,
  'jot': 0x00000bca,
  'K': 0x0000004b,
  'k': 0x0000006b,
  'kana_a': 0x000004a7,
  'kana_A': 0x000004b1,
  'kana_CHI': 0x000004c1,
  'kana_closingbracket': 0x000004a3,
  'kana_comma': 0x000004a4,
  'kana_conjunctive': 0x000004a5,
  'kana_e': 0x000004aa,
  'kana_E': 0x000004b4,
  'kana_FU': 0x000004cc,
  'kana_fullstop': 0x000004a1,
  'kana_HA': 0x000004ca,
  'kana_HE': 0x000004cd,
  'kana_HI': 0x000004cb,
  'kana_HO': 0x000004ce,
  'kana_HU': 0x000004cc,
  'kana_i': 0x000004a8,
  'kana_I': 0x000004b2,
  'kana_KA': 0x000004b6,
  'kana_KE': 0x000004b9,
  'kana_KI': 0x000004b7,
  'kana_KO': 0x000004ba,
  'kana_KU': 0x000004b8,
  'Kana_Lock': 0x0000ff2d,
  'kana_MA': 0x000004cf,
  'kana_ME': 0x000004d2,
  'kana_MI': 0x000004d0,
  'kana_middledot': 0x000004a5,
  'kana_MO': 0x000004d3,
  'kana_MU': 0x000004d1,
  'kana_N': 0x000004dd,
  'kana_NA': 0x000004c5,
  'kana_NE': 0x000004c8,
  'kana_NI': 0x000004c6,
  'kana_NO': 0x000004c9,
  'kana_NU': 0x000004c7,
  'kana_o': 0x000004ab,
  'kana_O': 0x000004b5,
  'kana_openingbracket': 0x000004a2,
  'kana_RA': 0x000004d7,
  'kana_RE': 0x000004da,
  'kana_RI': 0x000004d8,
  'kana_RO': 0x000004db,
  'kana_RU': 0x000004d9,
  'kana_SA': 0x000004bb,
  'kana_SE': 0x000004be,
  'kana_SHI': 0x000004bc,
  'Kana_Shift': 0x0000ff2e,
  'kana_SO': 0x000004bf,
  'kana_SU': 0x000004bd,
  'kana_switch': 0x0000ff7e,
  'kana_TA': 0x000004c0,
  'kana_TE': 0x000004c3,
  'kana_TI': 0x000004c1,
  'kana_TO': 0x000004c4,
  'kana_tsu': 0x000004af,
  'kana_TSU': 0x000004c2,
  'kana_tu': 0x000004af,
  'kana_TU': 0x000004c2,
  'kana_u': 0x000004a9,
  'kana_U': 0x000004b3,
  'kana_WA': 0x000004dc,
  'kana_WO': 0x000004a6,
  'kana_ya': 0x000004ac,
  'kana_YA': 0x000004d4,
  'kana_yo': 0x000004ae,
  'kana_YO': 0x000004d6,
  'kana_yu': 0x000004ad,
  'kana_YU': 0x000004d5,
  'Kanji': 0x0000ff21,
  'Kanji_Bangou': 0x0000ff37,
  'kappa': 0x000003a2,
  'Katakana': 0x0000ff26,
  'Kcedilla': 0x000003d3,
  'kcedilla': 0x000003f3,
  'Korean_Won': 0x00000eff,
  'KP_0': 0x0000ffb0,
  'KP_1': 0x0000ffb1,
  'KP_2': 0x0000ffb2,
  'KP_3': 0x0000ffb3,
  'KP_4': 0x0000ffb4,
  'KP_5': 0x0000ffb5,
  'KP_6': 0x0000ffb6,
  'KP_7': 0x0000ffb7,
  'KP_8': 0x0000ffb8,
  'KP_9': 0x0000ffb9,
  'KP_Add': 0x0000ffab,
  'KP_BackTab': 0x1000ff75,
  'KP_Begin': 0x0000ff9d,
  'KP_Decimal': 0x0000ffae,
  'KP_Delete': 0x0000ff9f,
  'KP_Divide': 0x0000ffaf,
  'KP_Down': 0x0000ff99,
  'KP_End': 0x0000ff9c,
  'KP_Enter': 0x0000ff8d,
  'KP_Equal': 0x0000ffbd,
  'KP_F1': 0x0000ff91,
  'KP_F2': 0x0000ff92,
  'KP_F3': 0x0000ff93,
  'KP_F4': 0x0000ff94,
  'KP_Home': 0x0000ff95,
  'KP_Insert': 0x0000ff9e,
  'KP_Left': 0x0000ff96,
  'KP_Multiply': 0x0000ffaa,
  'KP_Next': 0x0000ff9b,
  'KP_Page_Down': 0x0000ff9b,
  'KP_Page_Up': 0x0000ff9a,
  'KP_Prior': 0x0000ff9a,
  'KP_Right': 0x0000ff98,
  'KP_Separator': 0x0000ffac,
  'KP_Space': 0x0000ff80,
  'KP_Subtract': 0x0000ffad,
  'KP_Tab': 0x0000ff89,
  'KP_Up': 0x0000ff97,
  'kra': 0x000003a2,
  'L': 0x0000004c,
  'l': 0x0000006c,
  'L1': 0x0000ffc8,
  'L10': 0x0000ffd1,
  'L2': 0x0000ffc9,
  'L3': 0x0000ffca,
  'L4': 0x0000ffcb,
  'L5': 0x0000ffcc,
  'L6': 0x0000ffcd,
  'L7': 0x0000ffce,
  'L8': 0x0000ffcf,
  'L9': 0x0000ffd0,
  'Lacute': 0x000001c5,
  'lacute': 0x000001e5,
  'Last_Virtual_Screen': 0x0000fed4,
  'latincross': 0x00000ad9,
  'Lbelowdot': 0x01001e36,
  'lbelowdot': 0x01001e37,
  'Lcaron': 0x000001a5,
  'lcaron': 0x000001b5,
  'Lcedilla': 0x000003a6,
  'lcedilla': 0x000003b6,
  'Left': 0x0000ff51,
  'leftanglebracket': 0x00000abc,
  'leftarrow': 0x000008fb,
  'leftcaret': 0x00000ba3,
  'leftdoublequotemark': 0x00000ad2,
  'leftmiddlecurlybrace': 0x000008af,
  'leftopentriangle': 0x00000acc,
  'leftpointer': 0x00000aea,
  'leftradical': 0x000008a1,
  'leftshoe': 0x00000bda,
  'leftsinglequotemark': 0x00000ad0,
  'leftt': 0x000009f4,
  'lefttack': 0x00000bdc,
  'less': 0x0000003c,
  'lessthanequal': 0x000008bc,
  'lf': 0x000009e5,
  'Linefeed': 0x0000ff0a,
  'lira': 0x100000af,
  'LiraSign': 0x010020a4,
  'logicaland': 0x000008de,
  'logicalor': 0x000008df,
  'longminus': 0x100000f6,
  'lowleftcorner': 0x000009ed,
  'lowrightcorner': 0x000009ea,
  'Lstroke': 0x000001a3,
  'lstroke': 0x000001b3,
  'M': 0x0000004d,
  'm': 0x0000006d,
  'Mabovedot': 0x01001e40,
  'mabovedot': 0x01001e41,
  'Macedonia_dse': 0x000006a5,
  'Macedonia_DSE': 0x000006b5,
  'Macedonia_gje': 0x000006a2,
  'Macedonia_GJE': 0x000006b2,
  'Macedonia_kje': 0x000006ac,
  'Macedonia_KJE': 0x000006bc,
  'macron': 0x000000af,
  'Mae_Koho': 0x0000ff3e,
  'malesymbol': 0x00000af7,
  'maltesecross': 0x00000af0,
  'marker': 0x00000abf,
  'masculine': 0x000000ba,
  'Massyo': 0x0000ff2c,
  'Menu': 0x0000ff67,
  'Meta_L': 0x0000ffe7,
  'Meta_R': 0x0000ffe8,
  'MillSign': 0x010020a5,
  'minus': 0x0000002d,
  'minutes': 0x00000ad6,
  'Mode_switch': 0x0000ff7e,
  'MouseKeys_Accel_Enable': 0x0000fe77,
  'MouseKeys_Enable': 0x0000fe76,
  'mu': 0x000000b5,
  'Muhenkan': 0x0000ff22,
  'Multi_key': 0x0000ff20,
  'MultipleCandidate': 0x0000ff3d,
  'multiply': 0x000000d7,
  'musicalflat': 0x00000af6,
  'musicalsharp': 0x00000af5,
  'mute_acute': 0x100000a8,
  'mute_asciicircum': 0x100000aa,
  'mute_asciitilde': 0x100000ac,
  'mute_diaeresis': 0x100000ab,
  'mute_grave': 0x100000a9,
  'N': 0x0000004e,
  'n': 0x0000006e,
  'nabla': 0x000008c5,
  'Nacute': 0x000001d1,
  'nacute': 0x000001f1,
  'NairaSign': 0x010020a6,
  'Ncaron': 0x000001d2,
  'ncaron': 0x000001f2,
  'Ncedilla': 0x000003d1,
  'ncedilla': 0x000003f1,
  'NewSheqelSign': 0x010020aa,
  'Next': 0x0000ff56,
  'Next_Virtual_Screen': 0x0000fed2,
  'ninesubscript': 0x01002089,
  'ninesuperior': 0x01002079,
  'nl': 0x000009e8,
  'nobreakspace': 0x000000a0,
  'NoSymbol': 0x00000000,
  'notapproxeq': 0x01002247,
  'notelementof': 0x01002209,
  'notequal': 0x000008bd,
  'notidentical': 0x01002262,
  'notsign': 0x000000ac,
  'Ntilde': 0x000000d1,
  'ntilde': 0x000000f1,
  'Num_Lock': 0x0000ff7f,
  'numbersign': 0x00000023,
  'numerosign': 0x000006b0,
  'O': 0x0000004f,
  'o': 0x0000006f,
  'Oacute': 0x000000d3,
  'oacute': 0x000000f3,
  'Obarred': 0x0100019f,
  'obarred': 0x01000275,
  'Obelowdot': 0x01001ecc,
  'obelowdot': 0x01001ecd,
  'Ocaron': 0x010001d1,
  'ocaron': 0x010001d2,
  'Ocircumflex': 0x000000d4,
  'ocircumflex': 0x000000f4,
  'Ocircumflexacute': 0x01001ed0,
  'ocircumflexacute': 0x01001ed1,
  'Ocircumflexbelowdot': 0x01001ed8,
  'ocircumflexbelowdot': 0x01001ed9,
  'Ocircumflexgrave': 0x01001ed2,
  'ocircumflexgrave': 0x01001ed3,
  'Ocircumflexhook': 0x01001ed4,
  'ocircumflexhook': 0x01001ed5,
  'Ocircumflextilde': 0x01001ed6,
  'ocircumflextilde': 0x01001ed7,
  'Odiaeresis': 0x000000d6,
  'odiaeresis': 0x000000f6,
  'Odoubleacute': 0x000001d5,
  'odoubleacute': 0x000001f5,
  'OE': 0x000013bc,
  'oe': 0x000013bd,
  'ogonek': 0x000001b2,
  'Ograve': 0x000000d2,
  'ograve': 0x000000f2,
  'Ohook': 0x01001ece,
  'ohook': 0x01001ecf,
  'Ohorn': 0x010001a0,
  'ohorn': 0x010001a1,
  'Ohornacute': 0x01001eda,
  'ohornacute': 0x01001edb,
  'Ohornbelowdot': 0x01001ee2,
  'ohornbelowdot': 0x01001ee3,
  'Ohorngrave': 0x01001edc,
  'ohorngrave': 0x01001edd,
  'Ohornhook': 0x01001ede,
  'ohornhook': 0x01001edf,
  'Ohorntilde': 0x01001ee0,
  'ohorntilde': 0x01001ee1,
  'Omacron': 0x000003d2,
  'omacron': 0x000003f2,
  'oneeighth': 0x00000ac3,
  'onefifth': 0x00000ab2,
  'onehalf': 0x000000bd,
  'onequarter': 0x000000bc,
  'onesixth': 0x00000ab6,
  'onesubscript': 0x01002081,
  'onesuperior': 0x000000b9,
  'onethird': 0x00000ab0,
  'Ooblique': 0x000000d8,
  'ooblique': 0x000000f8,
  'openrectbullet': 0x00000ae2,
  'openstar': 0x00000ae5,
  'opentribulletdown': 0x00000ae4,
  'opentribulletup': 0x00000ae3,
  'ordfeminine': 0x000000aa,
  'osfActivate': 0x1004ff44,
  'osfAddMode': 0x1004ff31,
  'osfBackSpace': 0x1004ff08,
  'osfBackTab': 0x1004ff07,
  'osfBeginData': 0x1004ff5a,
  'osfBeginLine': 0x1004ff58,
  'osfCancel': 0x1004ff69,
  'osfClear': 0x1004ff0b,
  'osfCopy': 0x1004ff02,
  'osfCut': 0x1004ff03,
  'osfDelete': 0x1004ffff,
  'osfDeselectAll': 0x1004ff72,
  'osfDown': 0x1004ff54,
  'osfEndData': 0x1004ff59,
  'osfEndLine': 0x1004ff57,
  'osfEscape': 0x1004ff1b,
  'osfExtend': 0x1004ff74,
  'osfHelp': 0x1004ff6a,
  'osfInsert': 0x1004ff63,
  'osfLeft': 0x1004ff51,
  'osfMenu': 0x1004ff67,
  'osfMenuBar': 0x1004ff45,
  'osfNextField': 0x1004ff5e,
  'osfNextMenu': 0x1004ff5c,
  'osfPageDown': 0x1004ff42,
  'osfPageLeft': 0x1004ff40,
  'osfPageRight': 0x1004ff43,
  'osfPageUp': 0x1004ff41,
  'osfPaste': 0x1004ff04,
  'osfPrevField': 0x1004ff5d,
  'osfPrevMenu': 0x1004ff5b,
  'osfPrimaryPaste': 0x1004ff32,
  'osfQuickPaste': 0x1004ff33,
  'osfReselect': 0x1004ff73,
  'osfRestore': 0x1004ff78,
  'osfRight': 0x1004ff53,
  'osfSelect': 0x1004ff60,
  'osfSelectAll': 0x1004ff71,
  'osfUndo': 0x1004ff65,
  'osfUp': 0x1004ff52,
  'Oslash': 0x000000d8,
  'oslash': 0x000000f8,
  'Otilde': 0x000000d5,
  'otilde': 0x000000f5,
  'overbar': 0x00000bc0,
  'Overlay1_Enable': 0x0000fe78,
  'Overlay2_Enable': 0x0000fe79,
  'overline': 0x0000047e,
  'P': 0x00000050,
  'p': 0x00000070,
  'Pabovedot': 0x01001e56,
  'pabovedot': 0x01001e57,
  'Page_Down': 0x0000ff56,
  'Page_Up': 0x0000ff55,
  'paragraph': 0x000000b6,
  'parenleft': 0x00000028,
  'parenright': 0x00000029,
  'partdifferential': 0x01002202,
  'partialderivative': 0x000008ef,
  'Pause': 0x0000ff13,
  'percent': 0x00000025,
  'period': 0x0000002e,
  'periodcentered': 0x000000b7,
  'permille': 0x00000ad5,
  'PesetaSign': 0x010020a7,
  'phonographcopyright': 0x00000afb,
  'plus': 0x0000002b,
  'plusminus': 0x000000b1,
  'Pointer_Accelerate': 0x0000fefa,
  'Pointer_Button1': 0x0000fee9,
  'Pointer_Button2': 0x0000feea,
  'Pointer_Button3': 0x0000feeb,
  'Pointer_Button4': 0x0000feec,
  'Pointer_Button5': 0x0000feed,
  'Pointer_Button_Dflt': 0x0000fee8,
  'Pointer_DblClick1': 0x0000feef,
  'Pointer_DblClick2': 0x0000fef0,
  'Pointer_DblClick3': 0x0000fef1,
  'Pointer_DblClick4': 0x0000fef2,
  'Pointer_DblClick5': 0x0000fef3,
  'Pointer_DblClick_Dflt': 0x0000feee,
  'Pointer_DfltBtnNext': 0x0000fefb,
  'Pointer_DfltBtnPrev': 0x0000fefc,
  'Pointer_Down': 0x0000fee3,
  'Pointer_DownLeft': 0x0000fee6,
  'Pointer_DownRight': 0x0000fee7,
  'Pointer_Drag1': 0x0000fef5,
  'Pointer_Drag2': 0x0000fef6,
  'Pointer_Drag3': 0x0000fef7,
  'Pointer_Drag4': 0x0000fef8,
  'Pointer_Drag5': 0x0000fefd,
  'Pointer_Drag_Dflt': 0x0000fef4,
  'Pointer_EnableKeys': 0x0000fef9,
  'Pointer_Left': 0x0000fee0,
  'Pointer_Right': 0x0000fee1,
  'Pointer_Up': 0x0000fee2,
  'Pointer_UpLeft': 0x0000fee4,
  'Pointer_UpRight': 0x0000fee5,
  'prescription': 0x00000ad4,
  'Prev_Virtual_Screen': 0x0000fed1,
  'PreviousCandidate': 0x0000ff3e,
  'Print': 0x0000ff61,
  'Prior': 0x0000ff55,
  'prolongedsound': 0x000004b0,
  'punctspace': 0x00000aa6,
  'Q': 0x00000051,
  'q': 0x00000071,
  'quad': 0x00000bcc,
  'question': 0x0000003f,
  'questiondown': 0x000000bf,
  'quotedbl': 0x00000022,
  'quoteleft': 0x00000060,
  'quoteright': 0x00000027,
  'R': 0x00000052,
  'r': 0x00000072,
  'R1': 0x0000ffd2,
  'R10': 0x0000ffdb,
  'R11': 0x0000ffdc,
  'R12': 0x0000ffdd,
  'R13': 0x0000ffde,
  'R14': 0x0000ffdf,
  'R15': 0x0000ffe0,
  'R2': 0x0000ffd3,
  'R3': 0x0000ffd4,
  'R4': 0x0000ffd5,
  'R5': 0x0000ffd6,
  'R6': 0x0000ffd7,
  'R7': 0x0000ffd8,
  'R8': 0x0000ffd9,
  'R9': 0x0000ffda,
  'Racute': 0x000001c0,
  'racute': 0x000001e0,
  'radical': 0x000008d6,
  'Rcaron': 0x000001d8,
  'rcaron': 0x000001f8,
  'Rcedilla': 0x000003a3,
  'rcedilla': 0x000003b3,
  'Redo': 0x0000ff66,
  'registered': 0x000000ae,
  'RepeatKeys_Enable': 0x0000fe72,
  'Reset': 0x1000ff6c,
  'Return': 0x0000ff0d,
  'Right': 0x0000ff53,
  'rightanglebracket': 0x00000abe,
  'rightarrow': 0x000008fd,
  'rightcaret': 0x00000ba6,
  'rightdoublequotemark': 0x00000ad3,
  'rightmiddlecurlybrace': 0x000008b0,
  'rightmiddlesummation': 0x000008b7,
  'rightopentriangle': 0x00000acd,
  'rightpointer': 0x00000aeb,
  'rightshoe': 0x00000bd8,
  'rightsinglequotemark': 0x00000ad1,
  'rightt': 0x000009f5,
  'righttack': 0x00000bfc,
  'Romaji': 0x0000ff24,
  'RupeeSign': 0x010020a8,
  'S': 0x00000053,
  's': 0x00000073,
  'Sabovedot': 0x01001e60,
  'sabovedot': 0x01001e61,
  'Sacute': 0x000001a6,
  'sacute': 0x000001b6,
  'Scaron': 0x000001a9,
  'scaron': 0x000001b9,
  'Scedilla': 0x000001aa,
  'scedilla': 0x000001ba,
  'SCHWA': 0x0100018f,
  'schwa': 0x01000259,
  'Scircumflex': 0x000002de,
  'scircumflex': 0x000002fe,
  'script_switch': 0x0000ff7e,
  'Scroll_Lock': 0x0000ff14,
  'seconds': 0x00000ad7,
  'section': 0x000000a7,
  'Select': 0x0000ff60,
  'semicolon': 0x0000003b,
  'semivoicedsound': 0x000004df,
  'Serbian_dje': 0x000006a1,
  'Serbian_DJE': 0x000006b1,
  'Serbian_dze': 0x000006af,
  'Serbian_DZE': 0x000006bf,
  'Serbian_je': 0x000006a8,
  'Serbian_JE': 0x000006b8,
  'Serbian_lje': 0x000006a9,
  'Serbian_LJE': 0x000006b9,
  'Serbian_nje': 0x000006aa,
  'Serbian_NJE': 0x000006ba,
  'Serbian_tshe': 0x000006ab,
  'Serbian_TSHE': 0x000006bb,
  'seveneighths': 0x00000ac6,
  'sevensubscript': 0x01002087,
  'sevensuperior': 0x01002077,
  'Shift_L': 0x0000ffe1,
  'Shift_Lock': 0x0000ffe6,
  'Shift_R': 0x0000ffe2,
  'signaturemark': 0x00000aca,
  'signifblank': 0x00000aac,
  'similarequal': 0x000008c9,
  'SingleCandidate': 0x0000ff3c,
  'singlelowquotemark': 0x00000afd,
  'Sinh_a': 0x01000d85,
  'Sinh_aa': 0x01000d86,
  'Sinh_aa2': 0x01000dcf,
  'Sinh_ae': 0x01000d87,
  'Sinh_ae2': 0x01000dd0,
  'Sinh_aee': 0x01000d88,
  'Sinh_aee2': 0x01000dd1,
  'Sinh_ai': 0x01000d93,
  'Sinh_ai2': 0x01000ddb,
  'Sinh_al': 0x01000dca,
  'Sinh_au': 0x01000d96,
  'Sinh_au2': 0x01000dde,
  'Sinh_ba': 0x01000db6,
  'Sinh_bha': 0x01000db7,
  'Sinh_ca': 0x01000da0,
  'Sinh_cha': 0x01000da1,
  'Sinh_dda': 0x01000da9,
  'Sinh_ddha': 0x01000daa,
  'Sinh_dha': 0x01000daf,
  'Sinh_dhha': 0x01000db0,
  'Sinh_e': 0x01000d91,
  'Sinh_e2': 0x01000dd9,
  'Sinh_ee': 0x01000d92,
  'Sinh_ee2': 0x01000dda,
  'Sinh_fa': 0x01000dc6,
  'Sinh_ga': 0x01000d9c,
  'Sinh_gha': 0x01000d9d,
  'Sinh_h2': 0x01000d83,
  'Sinh_ha': 0x01000dc4,
  'Sinh_i': 0x01000d89,
  'Sinh_i2': 0x01000dd2,
  'Sinh_ii': 0x01000d8a,
  'Sinh_ii2': 0x01000dd3,
  'Sinh_ja': 0x01000da2,
  'Sinh_jha': 0x01000da3,
  'Sinh_jnya': 0x01000da5,
  'Sinh_ka': 0x01000d9a,
  'Sinh_kha': 0x01000d9b,
  'Sinh_kunddaliya': 0x01000df4,
  'Sinh_la': 0x01000dbd,
  'Sinh_lla': 0x01000dc5,
  'Sinh_lu': 0x01000d8f,
  'Sinh_lu2': 0x01000ddf,
  'Sinh_luu': 0x01000d90,
  'Sinh_luu2': 0x01000df3,
  'Sinh_ma': 0x01000db8,
  'Sinh_mba': 0x01000db9,
  'Sinh_na': 0x01000db1,
  'Sinh_ndda': 0x01000dac,
  'Sinh_ndha': 0x01000db3,
  'Sinh_ng': 0x01000d82,
  'Sinh_ng2': 0x01000d9e,
  'Sinh_nga': 0x01000d9f,
  'Sinh_nja': 0x01000da6,
  'Sinh_nna': 0x01000dab,
  'Sinh_nya': 0x01000da4,
  'Sinh_o': 0x01000d94,
  'Sinh_o2': 0x01000ddc,
  'Sinh_oo': 0x01000d95,
  'Sinh_oo2': 0x01000ddd,
  'Sinh_pa': 0x01000db4,
  'Sinh_pha': 0x01000db5,
  'Sinh_ra': 0x01000dbb,
  'Sinh_ri': 0x01000d8d,
  'Sinh_rii': 0x01000d8e,
  'Sinh_ru2': 0x01000dd8,
  'Sinh_ruu2': 0x01000df2,
  'Sinh_sa': 0x01000dc3,
  'Sinh_sha': 0x01000dc1,
  'Sinh_ssha': 0x01000dc2,
  'Sinh_tha': 0x01000dad,
  'Sinh_thha': 0x01000dae,
  'Sinh_tta': 0x01000da7,
  'Sinh_ttha': 0x01000da8,
  'Sinh_u': 0x01000d8b,
  'Sinh_u2': 0x01000dd4,
  'Sinh_uu': 0x01000d8c,
  'Sinh_uu2': 0x01000dd6,
  'Sinh_va': 0x01000dc0,
  'Sinh_ya': 0x01000dba,
  'sixsubscript': 0x01002086,
  'sixsuperior': 0x01002076,
  'slash': 0x0000002f,
  'SlowKeys_Enable': 0x0000fe73,
  'soliddiamond': 0x000009e0,
  'space': 0x00000020,
  'squareroot': 0x0100221a,
  'ssharp': 0x000000df,
  'sterling': 0x000000a3,
  'StickyKeys_Enable': 0x0000fe75,
  'stricteq': 0x01002263,
  'SunAgain': 0x0000ff66,
  'SunAltGraph': 0x0000ff7e,
  'SunAudioLowerVolume': 0x1005ff77,
  'SunAudioMute': 0x1005ff78,
  'SunAudioRaiseVolume': 0x1005ff79,
  'SunCompose': 0x0000ff20,
  'SunCopy': 0x1005ff72,
  'SunCut': 0x1005ff75,
  'SunF36': 0x1005ff10,
  'SunF37': 0x1005ff11,
  'SunFA_Acute': 0x1005ff03,
  'SunFA_Cedilla': 0x1005ff05,
  'SunFA_Circum': 0x1005ff01,
  'SunFA_Diaeresis': 0x1005ff04,
  'SunFA_Grave': 0x1005ff00,
  'SunFA_Tilde': 0x1005ff02,
  'SunFind': 0x0000ff68,
  'SunFront': 0x1005ff71,
  'SunOpen': 0x1005ff73,
  'SunPageDown': 0x0000ff56,
  'SunPageUp': 0x0000ff55,
  'SunPaste': 0x1005ff74,
  'SunPowerSwitch': 0x1005ff76,
  'SunPowerSwitchShift': 0x1005ff7d,
  'SunPrint_Screen': 0x0000ff61,
  'SunProps': 0x1005ff70,
  'SunStop': 0x0000ff69,
  'SunSys_Req': 0x1005ff60,
  'SunUndo': 0x0000ff65,
  'SunVideoDegauss': 0x1005ff7a,
  'SunVideoLowerBrightness': 0x1005ff7b,
  'SunVideoRaiseBrightness': 0x1005ff7c,
  'Super_L': 0x0000ffeb,
  'Super_R': 0x0000ffec,
  'Sys_Req': 0x0000ff15,
  'System': 0x1000ff6d,
  'T': 0x00000054,
  't': 0x00000074,
  'Tab': 0x0000ff09,
  'Tabovedot': 0x01001e6a,
  'tabovedot': 0x01001e6b,
  'Tcaron': 0x000001ab,
  'tcaron': 0x000001bb,
  'Tcedilla': 0x000001de,
  'tcedilla': 0x000001fe,
  'telephone': 0x00000af9,
  'telephonerecorder': 0x00000afa,
  'Terminate_Server': 0x0000fed5,
  'Thai_baht': 0x00000ddf,
  'Thai_bobaimai': 0x00000dba,
  'Thai_chochan': 0x00000da8,
  'Thai_chochang': 0x00000daa,
  'Thai_choching': 0x00000da9,
  'Thai_chochoe': 0x00000dac,
  'Thai_dochada': 0x00000dae,
  'Thai_dodek': 0x00000db4,
  'Thai_fofa': 0x00000dbd,
  'Thai_fofan': 0x00000dbf,
  'Thai_hohip': 0x00000dcb,
  'Thai_honokhuk': 0x00000dce,
  'Thai_khokhai': 0x00000da2,
  'Thai_khokhon': 0x00000da5,
  'Thai_khokhuat': 0x00000da3,
  'Thai_khokhwai': 0x00000da4,
  'Thai_khorakhang': 0x00000da6,
  'Thai_kokai': 0x00000da1,
  'Thai_lakkhangyao': 0x00000de5,
  'Thai_lekchet': 0x00000df7,
  'Thai_lekha': 0x00000df5,
  'Thai_lekhok': 0x00000df6,
  'Thai_lekkao': 0x00000df9,
  'Thai_leknung': 0x00000df1,
  'Thai_lekpaet': 0x00000df8,
  'Thai_leksam': 0x00000df3,
  'Thai_leksi': 0x00000df4,
  'Thai_leksong': 0x00000df2,
  'Thai_leksun': 0x00000df0,
  'Thai_lochula': 0x00000dcc,
  'Thai_loling': 0x00000dc5,
  'Thai_lu': 0x00000dc6,
  'Thai_maichattawa': 0x00000deb,
  'Thai_maiek': 0x00000de8,
  'Thai_maihanakat': 0x00000dd1,
  'Thai_maihanakat_maitho': 0x00000dde,
  'Thai_maitaikhu': 0x00000de7,
  'Thai_maitho': 0x00000de9,
  'Thai_maitri': 0x00000dea,
  'Thai_maiyamok': 0x00000de6,
  'Thai_moma': 0x00000dc1,
  'Thai_ngongu': 0x00000da7,
  'Thai_nikhahit': 0x00000ded,
  'Thai_nonen': 0x00000db3,
  'Thai_nonu': 0x00000db9,
  'Thai_oang': 0x00000dcd,
  'Thai_paiyannoi': 0x00000dcf,
  'Thai_phinthu': 0x00000dda,
  'Thai_phophan': 0x00000dbe,
  'Thai_phophung': 0x00000dbc,
  'Thai_phosamphao': 0x00000dc0,
  'Thai_popla': 0x00000dbb,
  'Thai_rorua': 0x00000dc3,
  'Thai_ru': 0x00000dc4,
  'Thai_saraa': 0x00000dd0,
  'Thai_saraaa': 0x00000dd2,
  'Thai_saraae': 0x00000de1,
  'Thai_saraaimaimalai': 0x00000de4,
  'Thai_saraaimaimuan': 0x00000de3,
  'Thai_saraam': 0x00000dd3,
  'Thai_sarae': 0x00000de0,
  'Thai_sarai': 0x00000dd4,
  'Thai_saraii': 0x00000dd5,
  'Thai_sarao': 0x00000de2,
  'Thai_sarau': 0x00000dd8,
  'Thai_saraue': 0x00000dd6,
  'Thai_sarauee': 0x00000dd7,
  'Thai_sarauu': 0x00000dd9,
  'Thai_sorusi': 0x00000dc9,
  'Thai_sosala': 0x00000dc8,
  'Thai_soso': 0x00000dab,
  'Thai_sosua': 0x00000dca,
  'Thai_thanthakhat': 0x00000dec,
  'Thai_thonangmontho': 0x00000db1,
  'Thai_thophuthao': 0x00000db2,
  'Thai_thothahan': 0x00000db7,
  'Thai_thothan': 0x00000db0,
  'Thai_thothong': 0x00000db8,
  'Thai_thothung': 0x00000db6,
  'Thai_topatak': 0x00000daf,
  'Thai_totao': 0x00000db5,
  'Thai_wowaen': 0x00000dc7,
  'Thai_yoyak': 0x00000dc2,
  'Thai_yoying': 0x00000dad,
  'therefore': 0x000008c0,
  'thinspace': 0x00000aa7,
  'THORN': 0x000000de,
  'Thorn': 0x000000de,
  'thorn': 0x000000fe,
  'threeeighths': 0x00000ac4,
  'threefifths': 0x00000ab4,
  'threequarters': 0x000000be,
  'threesubscript': 0x01002083,
  'threesuperior': 0x000000b3,
  'tintegral': 0x0100222d,
  'topintegral': 0x000008a4,
  'topleftparens': 0x000008ab,
  'topleftradical': 0x000008a2,
  'topleftsqbracket': 0x000008a7,
  'topleftsummation': 0x000008b1,
  'toprightparens': 0x000008ad,
  'toprightsqbracket': 0x000008a9,
  'toprightsummation': 0x000008b5,
  'topt': 0x000009f7,
  'topvertsummationconnector': 0x000008b3,
  'Touroku': 0x0000ff2b,
  'trademark': 0x00000ac9,
  'trademarkincircle': 0x00000acb,
  'Tslash': 0x000003ac,
  'tslash': 0x000003bc,
  'twofifths': 0x00000ab3,
  'twosubscript': 0x01002082,
  'twosuperior': 0x000000b2,
  'twothirds': 0x00000ab1,
  'U': 0x00000055,
  'u': 0x00000075,
  'Uacute': 0x000000da,
  'uacute': 0x000000fa,
  'Ubelowdot': 0x01001ee4,
  'ubelowdot': 0x01001ee5,
  'Ubreve': 0x000002dd,
  'ubreve': 0x000002fd,
  'Ucircumflex': 0x000000db,
  'ucircumflex': 0x000000fb,
  'Udiaeresis': 0x000000dc,
  'udiaeresis': 0x000000fc,
  'Udoubleacute': 0x000001db,
  'udoubleacute': 0x000001fb,
  'Ugrave': 0x000000d9,
  'ugrave': 0x000000f9,
  'Uhook': 0x01001ee6,
  'uhook': 0x01001ee7,
  'Uhorn': 0x010001af,
  'uhorn': 0x010001b0,
  'Uhornacute': 0x01001ee8,
  'uhornacute': 0x01001ee9,
  'Uhornbelowdot': 0x01001ef0,
  'uhornbelowdot': 0x01001ef1,
  'Uhorngrave': 0x01001eea,
  'uhorngrave': 0x01001eeb,
  'Uhornhook': 0x01001eec,
  'uhornhook': 0x01001eed,
  'Uhorntilde': 0x01001eee,
  'uhorntilde': 0x01001eef,
  'Ukrainian_ghe_with_upturn': 0x000006ad,
  'Ukrainian_GHE_WITH_UPTURN': 0x000006bd,
  'Ukrainian_i': 0x000006a6,
  'Ukrainian_I': 0x000006b6,
  'Ukrainian_ie': 0x000006a4,
  'Ukrainian_IE': 0x000006b4,
  'Ukrainian_yi': 0x000006a7,
  'Ukrainian_YI': 0x000006b7,
  'Ukranian_i': 0x000006a6,
  'Ukranian_I': 0x000006b6,
  'Ukranian_je': 0x000006a4,
  'Ukranian_JE': 0x000006b4,
  'Ukranian_yi': 0x000006a7,
  'Ukranian_YI': 0x000006b7,
  'Umacron': 0x000003de,
  'umacron': 0x000003fe,
  'underbar': 0x00000bc6,
  'underscore': 0x0000005f,
  'Undo': 0x0000ff65,
  'union': 0x000008dd,
  'Uogonek': 0x000003d9,
  'uogonek': 0x000003f9,
  'Up': 0x0000ff52,
  'uparrow': 0x000008fc,
  'upcaret': 0x00000ba9,
  'upleftcorner': 0x000009ec,
  'uprightcorner': 0x000009eb,
  'upshoe': 0x00000bc3,
  'upstile': 0x00000bd3,
  'uptack': 0x00000bce,
  'Uring': 0x000001d9,
  'uring': 0x000001f9,
  'User': 0x1000ff6e,
  'Utilde': 0x000003dd,
  'utilde': 0x000003fd,
  'V': 0x00000056,
  'v': 0x00000076,
  'variation': 0x000008c1,
  'vertbar': 0x000009f8,
  'vertconnector': 0x000008a6,
  'voicedsound': 0x000004de,
  'VoidSymbol': 0x00ffffff,
  'vt': 0x000009e9,
  'W': 0x00000057,
  'w': 0x00000077,
  'Wacute': 0x01001e82,
  'wacute': 0x01001e83,
  'Wcircumflex': 0x01000174,
  'wcircumflex': 0x01000175,
  'Wdiaeresis': 0x01001e84,
  'wdiaeresis': 0x01001e85,
  'Wgrave': 0x01001e80,
  'wgrave': 0x01001e81,
  'WonSign': 0x010020a9,
  'X': 0x00000058,
  'x': 0x00000078,
  'Xabovedot': 0x01001e8a,
  'xabovedot': 0x01001e8b,
  'XF8610ChannelsDown': 0x100811b9,
  'XF8610ChannelsUp': 0x100811b8,
  'XF863DMode': 0x1008126f,
  'XF86AddFavorite': 0x1008ff39,
  'XF86Addressbook': 0x100811ad,
  'XF86ALSToggle': 0x10081230,
  'XF86ApplicationLeft': 0x1008ff50,
  'XF86ApplicationRight': 0x1008ff51,
  'XF86AppSelect': 0x10081244,
  'XF86AspectRatio': 0x10081177,
  'XF86Assistant': 0x10081247,
  'XF86AttendantOff': 0x1008121c,
  'XF86AttendantOn': 0x1008121b,
  'XF86AttendantToggle': 0x1008121d,
  'XF86Audio': 0x10081188,
  'XF86AudioCycleTrack': 0x1008ff9b,
  'XF86AudioDesc': 0x1008126e,
  'XF86AudioForward': 0x1008ff97,
  'XF86AudioLowerVolume': 0x1008ff11,
  'XF86AudioMedia': 0x1008ff32,
  'XF86AudioMicMute': 0x1008ffb2,
  'XF86AudioMute': 0x1008ff12,
  'XF86AudioNext': 0x1008ff17,
  'XF86AudioPause': 0x1008ff31,
  'XF86AudioPlay': 0x1008ff14,
  'XF86AudioPreset': 0x1008ffb6,
  'XF86AudioPrev': 0x1008ff16,
  'XF86AudioRaiseVolume': 0x1008ff13,
  'XF86AudioRandomPlay': 0x1008ff99,
  'XF86AudioRecord': 0x1008ff1c,
  'XF86AudioRepeat': 0x1008ff98,
  'XF86AudioRewind': 0x1008ff3e,
  'XF86AudioStop': 0x1008ff15,
  'XF86Away': 0x1008ff8d,
  'XF86Back': 0x1008ff26,
  'XF86BackForward': 0x1008ff3f,
  'XF86Battery': 0x1008ff93,
  'XF86Blue': 0x1008ffa6,
  'XF86Bluetooth': 0x1008ff94,
  'XF86Book': 0x1008ff52,
  'XF86Break': 0x1008119b,
  'XF86BrightnessAdjust': 0x1008ff3b,
  'XF86BrightnessAuto': 0x100810f4,
  'XF86BrightnessMax': 0x10081251,
  'XF86BrightnessMin': 0x10081250,
  'XF86Buttonconfig': 0x10081240,
  'XF86Calculater': 0x1008ff54,
  'XF86Calculator': 0x1008ff1d,
  'XF86Calendar': 0x1008ff20,
  'XF86CameraDown': 0x10081218,
  'XF86CameraFocus': 0x10081210,
  'XF86CameraLeft': 0x10081219,
  'XF86CameraRight': 0x1008121a,
  'XF86CameraUp': 0x10081217,
  'XF86CameraZoomIn': 0x10081215,
  'XF86CameraZoomOut': 0x10081216,
  'XF86CD': 0x1008ff53,
  'XF86ChannelDown': 0x10081193,
  'XF86ChannelUp': 0x10081192,
  'XF86Clear': 0x1008ff55,
  'XF86ClearGrab': 0x1008fe21,
  'XF86Close': 0x1008ff56,
  'XF86Community': 0x1008ff3d,
  'XF86ContextMenu': 0x100811b6,
  'XF86ContrastAdjust': 0x1008ff22,
  'XF86ControlPanel': 0x10081243,
  'XF86Copy': 0x1008ff57,
  'XF86Cut': 0x1008ff58,
  'XF86CycleAngle': 0x1008ff9c,
  'XF86Data': 0x10081277,
  'XF86Database': 0x100811aa,
  'XF86Dictate': 0x1008124a,
  'XF86Display': 0x1008ff59,
  'XF86DisplayOff': 0x100810f5,
  'XF86DisplayToggle': 0x100811af,
  'XF86Documents': 0x1008ff5b,
  'XF86DOS': 0x1008ff5a,
  'XF86DVD': 0x10081185,
  'XF86Editor': 0x100811a6,
  'XF86Eject': 0x1008ff2c,
  'XF86EmojiPicker': 0x10081249,
  'XF86Excel': 0x1008ff5c,
  'XF86Explorer': 0x1008ff5d,
  'XF86FastReverse': 0x10081275,
  'XF86Favorites': 0x1008ff30,
  'XF86Finance': 0x1008ff3c,
  'XF86Fn': 0x100811d0,
  'XF86Fn_Esc': 0x100811d1,
  'XF86FnRightShift': 0x100811e5,
  'XF86Forward': 0x1008ff27,
  'XF86FrameBack': 0x1008ff9d,
  'XF86FrameForward': 0x1008ff9e,
  'XF86FullScreen': 0x1008ffb8,
  'XF86Game': 0x1008ff5e,
  'XF86Go': 0x1008ff5f,
  'XF86GraphicsEditor': 0x100811a8,
  'XF86Green': 0x1008ffa4,
  'XF86HangupPhone': 0x100811be,
  'XF86Hibernate': 0x1008ffa8,
  'XF86History': 0x1008ff37,
  'XF86HomePage': 0x1008ff18,
  'XF86HotLinks': 0x1008ff3a,
  'XF86Images': 0x100811ba,
  'XF86Info': 0x10081166,
  'XF86iTouch': 0x1008ff60,
  'XF86Journal': 0x10081242,
  'XF86KbdBrightnessDown': 0x1008ff06,
  'XF86KbdBrightnessUp': 0x1008ff05,
  'XF86KbdInputAssistAccept': 0x10081264,
  'XF86KbdInputAssistCancel': 0x10081265,
  'XF86KbdInputAssistNext': 0x10081261,
  'XF86KbdInputAssistNextgroup': 0x10081263,
  'XF86KbdInputAssistPrev': 0x10081260,
  'XF86KbdInputAssistPrevgroup': 0x10081262,
  'XF86KbdLcdMenu1': 0x100812b8,
  'XF86KbdLcdMenu2': 0x100812b9,
  'XF86KbdLcdMenu3': 0x100812ba,
  'XF86KbdLcdMenu4': 0x100812bb,
  'XF86KbdLcdMenu5': 0x100812bc,
  'XF86KbdLightOnOff': 0x1008ff04,
  'XF86Keyboard': 0x1008ffb3,
  'XF86Launch0': 0x1008ff40,
  'XF86Launch1': 0x1008ff41,
  'XF86Launch2': 0x1008ff42,
  'XF86Launch3': 0x1008ff43,
  'XF86Launch4': 0x1008ff44,
  'XF86Launch5': 0x1008ff45,
  'XF86Launch6': 0x1008ff46,
  'XF86Launch7': 0x1008ff47,
  'XF86Launch8': 0x1008ff48,
  'XF86Launch9': 0x1008ff49,
  'XF86LaunchA': 0x1008ff4a,
  'XF86LaunchB': 0x1008ff4b,
  'XF86LaunchC': 0x1008ff4c,
  'XF86LaunchD': 0x1008ff4d,
  'XF86LaunchE': 0x1008ff4e,
  'XF86LaunchF': 0x1008ff4f,
  'XF86LeftDown': 0x10081269,
  'XF86LeftUp': 0x10081268,
  'XF86LightBulb': 0x1008ff35,
  'XF86LightsToggle': 0x1008121e,
  'XF86LogGrabInfo': 0x1008fe25,
  'XF86LogOff': 0x1008ff61,
  'XF86LogWindowTree': 0x1008fe24,
  'XF86Macro1': 0x10081290,
  'XF86Macro10': 0x10081299,
  'XF86Macro11': 0x1008129a,
  'XF86Macro12': 0x1008129b,
  'XF86Macro13': 0x1008129c,
  'XF86Macro14': 0x1008129d,
  'XF86Macro15': 0x1008129e,
  'XF86Macro16': 0x1008129f,
  'XF86Macro17': 0x100812a0,
  'XF86Macro18': 0x100812a1,
  'XF86Macro19': 0x100812a2,
  'XF86Macro2': 0x10081291,
  'XF86Macro20': 0x100812a3,
  'XF86Macro21': 0x100812a4,
  'XF86Macro22': 0x100812a5,
  'XF86Macro23': 0x100812a6,
  'XF86Macro24': 0x100812a7,
  'XF86Macro25': 0x100812a8,
  'XF86Macro26': 0x100812a9,
  'XF86Macro27': 0x100812aa,
  'XF86Macro28': 0x100812ab,
  'XF86Macro29': 0x100812ac,
  'XF86Macro3': 0x10081292,
  'XF86Macro30': 0x100812ad,
  'XF86Macro4': 0x10081293,
  'XF86Macro5': 0x10081294,
  'XF86Macro6': 0x10081295,
  'XF86Macro7': 0x10081296,
  'XF86Macro8': 0x10081297,
  'XF86Macro9': 0x10081298,
  'XF86MacroPreset1': 0x100812b3,
  'XF86MacroPreset2': 0x100812b4,
  'XF86MacroPreset3': 0x100812b5,
  'XF86MacroPresetCycle': 0x100812b2,
  'XF86MacroRecordStart': 0x100812b0,
  'XF86MacroRecordStop': 0x100812b1,
  'XF86Mail': 0x1008ff19,
  'XF86MailForward': 0x1008ff90,
  'XF86Market': 0x1008ff62,
  'XF86MediaRepeat': 0x100811b7,
  'XF86MediaTopMenu': 0x1008126b,
  'XF86Meeting': 0x1008ff63,
  'XF86Memo': 0x1008ff1e,
  'XF86MenuKB': 0x1008ff65,
  'XF86MenuPB': 0x1008ff66,
  'XF86Messenger': 0x1008ff8e,
  'XF86ModeLock': 0x1008ff01,
  'XF86MonBrightnessCycle': 0x1008ff07,
  'XF86MonBrightnessDown': 0x1008ff03,
  'XF86MonBrightnessUp': 0x1008ff02,
  'XF86Music': 0x1008ff92,
  'XF86MyComputer': 0x1008ff33,
  'XF86MySites': 0x1008ff67,
  'XF86New': 0x1008ff68,
  'XF86News': 0x1008ff69,
  'XF86Next_VMode': 0x1008fe22,
  'XF86NextFavorite': 0x10081270,
  'XF86NotificationCenter': 0x100811bc,
  'XF86Numeric0': 0x10081200,
  'XF86Numeric1': 0x10081201,
  'XF86Numeric11': 0x1008126c,
  'XF86Numeric12': 0x1008126d,
  'XF86Numeric2': 0x10081202,
  'XF86Numeric3': 0x10081203,
  'XF86Numeric4': 0x10081204,
  'XF86Numeric5': 0x10081205,
  'XF86Numeric6': 0x10081206,
  'XF86Numeric7': 0x10081207,
  'XF86Numeric8': 0x10081208,
  'XF86Numeric9': 0x10081209,
  'XF86NumericA': 0x1008120c,
  'XF86NumericB': 0x1008120d,
  'XF86NumericC': 0x1008120e,
  'XF86NumericD': 0x1008120f,
  'XF86NumericPound': 0x1008120b,
  'XF86NumericStar': 0x1008120a,
  'XF86OfficeHome': 0x1008ff6a,
  'XF86OnScreenKeyboard': 0x10081278,
  'XF86Open': 0x1008ff6b,
  'XF86OpenURL': 0x1008ff38,
  'XF86Option': 0x1008ff6c,
  'XF86Paste': 0x1008ff6d,
  'XF86PauseRecord': 0x10081272,
  'XF86Phone': 0x1008ff6e,
  'XF86PickupPhone': 0x100811bd,
  'XF86Pictures': 0x1008ff91,
  'XF86PowerDown': 0x1008ff21,
  'XF86PowerOff': 0x1008ff2a,
  'XF86Presentation': 0x100811a9,
  'XF86Prev_VMode': 0x1008fe23,
  'XF86PrivacyScreenToggle': 0x10081279,
  'XF86Q': 0x1008ff70,
  'XF86Red': 0x1008ffa3,
  'XF86Refresh': 0x1008ff29,
  'XF86Reload': 0x1008ff73,
  'XF86Reply': 0x1008ff72,
  'XF86RFKill': 0x1008ffb5,
  'XF86RightDown': 0x10081267,
  'XF86RightUp': 0x10081266,
  'XF86RockerDown': 0x1008ff24,
  'XF86RockerEnter': 0x1008ff25,
  'XF86RockerUp': 0x1008ff23,
  'XF86RootMenu': 0x1008126a,
  'XF86RotateWindows': 0x1008ff74,
  'XF86RotationKB': 0x1008ff76,
  'XF86RotationLockToggle': 0x1008ffb7,
  'XF86RotationPB': 0x1008ff75,
  'XF86Save': 0x1008ff77,
  'XF86ScreenSaver': 0x1008ff2d,
  'XF86Screensaver': 0x10081245,
  'XF86ScrollClick': 0x1008ff7a,
  'XF86ScrollDown': 0x1008ff79,
  'XF86ScrollUp': 0x1008ff78,
  'XF86Search': 0x1008ff1b,
  'XF86Select': 0x1008ffa0,
  'XF86SelectiveScreenshot': 0x1008127a,
  'XF86Send': 0x1008ff7b,
  'XF86Shop': 0x1008ff36,
  'XF86Sleep': 0x1008ff2f,
  'XF86SlowReverse': 0x10081276,
  'XF86Spell': 0x1008ff7c,
  'XF86SpellCheck': 0x100811b0,
  'XF86SplitScreen': 0x1008ff7d,
  'XF86Standby': 0x1008ff10,
  'XF86Start': 0x1008ff1a,
  'XF86Stop': 0x1008ff28,
  'XF86StopRecord': 0x10081271,
  'XF86Subtitle': 0x1008ff9a,
  'XF86Support': 0x1008ff7e,
  'XF86Suspend': 0x1008ffa7,
  'XF86Switch_VT_1': 0x1008fe01,
  'XF86Switch_VT_10': 0x1008fe0a,
  'XF86Switch_VT_11': 0x1008fe0b,
  'XF86Switch_VT_12': 0x1008fe0c,
  'XF86Switch_VT_2': 0x1008fe02,
  'XF86Switch_VT_3': 0x1008fe03,
  'XF86Switch_VT_4': 0x1008fe04,
  'XF86Switch_VT_5': 0x1008fe05,
  'XF86Switch_VT_6': 0x1008fe06,
  'XF86Switch_VT_7': 0x1008fe07,
  'XF86Switch_VT_8': 0x1008fe08,
  'XF86Switch_VT_9': 0x1008fe09,
  'XF86Taskmanager': 0x10081241,
  'XF86TaskPane': 0x1008ff7f,
  'XF86Terminal': 0x1008ff80,
  'XF86Time': 0x1008ff9f,
  'XF86ToDoList': 0x1008ff1f,
  'XF86Tools': 0x1008ff81,
  'XF86TopMenu': 0x1008ffa2,
  'XF86TouchpadOff': 0x1008ffb1,
  'XF86TouchpadOn': 0x1008ffb0,
  'XF86TouchpadToggle': 0x1008ffa9,
  'XF86Travel': 0x1008ff82,
  'XF86Ungrab': 0x1008fe20,
  'XF86Unmute': 0x10081274,
  'XF86User1KB': 0x1008ff85,
  'XF86User2KB': 0x1008ff86,
  'XF86UserPB': 0x1008ff84,
  'XF86UWB': 0x1008ff96,
  'XF86VendorHome': 0x1008ff34,
  'XF86Video': 0x1008ff87,
  'XF86VideoPhone': 0x100811a0,
  'XF86View': 0x1008ffa1,
  'XF86VOD': 0x10081273,
  'XF86VoiceCommand': 0x10081246,
  'XF86Voicemail': 0x100811ac,
  'XF86WakeUp': 0x1008ff2b,
  'XF86WebCam': 0x1008ff8f,
  'XF86WheelButton': 0x1008ff88,
  'XF86WLAN': 0x1008ff95,
  'XF86Word': 0x1008ff89,
  'XF86WPSButton': 0x10081211,
  'XF86WWAN': 0x1008ffb4,
  'XF86WWW': 0x1008ff2e,
  'XF86Xfer': 0x1008ff8a,
  'XF86Yellow': 0x1008ffa5,
  'XF86ZoomIn': 0x1008ff8b,
  'XF86ZoomOut': 0x1008ff8c,
  'XF86ZoomReset': 0x100811a4,
  'Y': 0x00000059,
  'y': 0x00000079,
  'Yacute': 0x000000dd,
  'yacute': 0x000000fd,
  'Ybelowdot': 0x01001ef4,
  'ybelowdot': 0x01001ef5,
  'Ycircumflex': 0x01000176,
  'ycircumflex': 0x01000177,
  'ydiaeresis': 0x000000ff,
  'Ydiaeresis': 0x000013be,
  'yen': 0x000000a5,
  'Ygrave': 0x01001ef2,
  'ygrave': 0x01001ef3,
  'Yhook': 0x01001ef6,
  'yhook': 0x01001ef7,
  'Ytilde': 0x01001ef8,
  'ytilde': 0x01001ef9,
  'Z': 0x0000005a,
  'z': 0x0000007a,
  'Zabovedot': 0x000001af,
  'zabovedot': 0x000001bf,
  'Zacute': 0x000001ac,
  'zacute': 0x000001bc,
  'Zcaron': 0x000001ae,
  'zcaron': 0x000001be,
  'Zen_Koho': 0x0000ff3d,
  'Zenkaku': 0x0000ff28,
  'Zenkaku_Hankaku': 0x0000ff2a,
  'zerosubscript': 0x01002080,
  'zerosuperior': 0x01002070,
  'Zstroke': 0x010001b5,
  'zstroke': 0x010001b6,
};