static char rcsid[] = "$Id$";
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "mergeinfo.h"

#include "mem.h"


void
Mergeinfo_uint4_free (Mergeinfo_uint4_T *old) {
  FREE((*old)->combined);
  FREE((*old)->totals);
  FREE((*old)->heap);
  FREE((*old)->nelts);
  FREE(*old);
  return;
}


Mergeinfo_uint4_T
Mergeinfo_uint4_new (int querylength) {
  Mergeinfo_uint4_T new = (Mergeinfo_uint4_T) MALLOC(sizeof(*new));
  int max_nstreams = querylength;
  int max_heapsize = 2*max_nstreams + 1;

  new->querylength = querylength;

  new->combined = (UINT4 **) MALLOC(max_nstreams * sizeof(UINT4 *));
  new->totals = (int *) MALLOC(max_nstreams * sizeof(int));
  new->heap = (UINT4 **) MALLOC((max_heapsize + 1)*sizeof(UINT4 *));
  new->nelts = (int *) MALLOC((max_heapsize + 1)*sizeof(int));

  return new;
}

void
Mergeinfo_uint8_free (Mergeinfo_uint8_T *old) {
  FREE((*old)->combined);
  FREE((*old)->totals);
  FREE((*old)->heap);
  FREE((*old)->nelts);
  FREE(*old);
  return;
}


Mergeinfo_uint8_T
Mergeinfo_uint8_new (int querylength) {
  Mergeinfo_uint8_T new = (Mergeinfo_uint8_T) MALLOC(sizeof(*new));
  int max_nstreams = querylength;
  int max_heapsize = 2*max_nstreams + 1;

  new->querylength = querylength;

  new->combined = (UINT8 **) MALLOC(max_nstreams * sizeof(UINT8 *));
  new->totals = (int *) MALLOC(max_nstreams * sizeof(int));
  new->heap = (UINT8 **) MALLOC((max_heapsize + 1)*sizeof(UINT8 *));
  new->nelts = (int *) MALLOC((max_heapsize + 1)*sizeof(int));

  return new;
}



