# frozen_string_literal: true

# See https://docs.gitlab.com/ee/development/migration_style_guide.html
# for more information on how to write migrations for GitLab.

class DropTmpIndexFromVulnerabilityOccurrences < Gitlab::Database::Migration[2.2]
  TABLE_NAME = :vulnerability_occurrences
  INITIAL_PIPELINE_INDEX = 'tmp_index_vulnerability_occurrences_id_and_initial_pipline_id'
  LATEST_PIPELINE_INDEX = 'tmp_index_vulnerability_occurrences_id_and_latest_pipeline_id'

  INITIAL_PIPELINE_COLUMNS = [:id, :initial_pipeline_id]
  LATEST_PIPELINE_COLUMNS = [:id, :latest_pipeline_id]

  milestone '17.3'
  disable_ddl_transaction!

  def up
    remove_concurrent_index_by_name TABLE_NAME, name: INITIAL_PIPELINE_INDEX
    remove_concurrent_index_by_name TABLE_NAME, name: LATEST_PIPELINE_INDEX
  end

  def down
    add_concurrent_index TABLE_NAME, INITIAL_PIPELINE_COLUMNS, name: INITIAL_PIPELINE_INDEX,
      where: 'initial_pipeline_id IS NULL'
    add_concurrent_index TABLE_NAME, LATEST_PIPELINE_COLUMNS, name: LATEST_PIPELINE_INDEX,
      where: 'latest_pipeline_id IS NULL'
  end
end
