//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsynapse

import "time"

// AADAdminProperties - Workspace active directory administrator properties
type AADAdminProperties struct {
	// Workspace active directory administrator type
	AdministratorType *string `json:"administratorType,omitempty"`

	// Login of the workspace active directory administrator
	Login *string `json:"login,omitempty"`

	// Object ID of the workspace active directory administrator
	Sid *string `json:"sid,omitempty"`

	// Tenant ID of the workspace active directory administrator
	TenantID *string `json:"tenantId,omitempty"`
}

// AttachedDatabaseConfiguration - Class representing an attached database configuration.
type AttachedDatabaseConfiguration struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// The properties of the attached database configuration.
	Properties *AttachedDatabaseConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AttachedDatabaseConfigurationListResult - The list attached database configurations operation response.
type AttachedDatabaseConfigurationListResult struct {
	// The list of attached database configurations.
	Value []*AttachedDatabaseConfiguration `json:"value,omitempty"`
}

// AttachedDatabaseConfigurationProperties - Class representing the an attached database configuration properties of kind
// specific.
type AttachedDatabaseConfigurationProperties struct {
	// REQUIRED; The name of the database which you would like to attach, use * if you want to follow all current and future databases.
	DatabaseName *string `json:"databaseName,omitempty"`

	// REQUIRED; The default principals modification kind
	DefaultPrincipalsModificationKind *DefaultPrincipalsModificationKind `json:"defaultPrincipalsModificationKind,omitempty"`

	// REQUIRED; The resource id of the kusto pool where the databases you would like to attach reside.
	KustoPoolResourceID *string `json:"clusterResourceId,omitempty"`

	// Table level sharing specifications
	TableLevelSharingProperties *TableLevelSharingProperties `json:"tableLevelSharingProperties,omitempty"`

	// READ-ONLY; The list of databases from the clusterResourceId which are currently attached to the kusto pool.
	AttachedDatabaseNames []*string `json:"attachedDatabaseNames,omitempty" azure:"ro"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AutoPauseProperties - Auto-pausing properties of a Big Data pool powered by Apache Spark
type AutoPauseProperties struct {
	// Number of minutes of idle time before the Big Data pool is automatically paused.
	DelayInMinutes *int32 `json:"delayInMinutes,omitempty"`

	// Whether auto-pausing is enabled for the Big Data pool.
	Enabled *bool `json:"enabled,omitempty"`
}

// AutoScaleProperties - Auto-scaling properties of a Big Data pool powered by Apache Spark
type AutoScaleProperties struct {
	// Whether automatic scaling is enabled for the Big Data pool.
	Enabled *bool `json:"enabled,omitempty"`

	// The maximum number of nodes the Big Data pool can support.
	MaxNodeCount *int32 `json:"maxNodeCount,omitempty"`

	// The minimum number of nodes the Big Data pool can support.
	MinNodeCount *int32 `json:"minNodeCount,omitempty"`
}

// AvailableRpOperation - An operation that is available in this resource provider
type AvailableRpOperation struct {
	// Display properties of the operation
	Display *AvailableRpOperationDisplayInfo `json:"display,omitempty"`

	// Whether this operation is a data action
	IsDataAction *string `json:"isDataAction,omitempty"`

	// Operation name
	Name *string `json:"name,omitempty"`

	// Operation origin
	Origin *string `json:"origin,omitempty"`

	// Operation properties
	Properties *OperationMetaPropertyInfo `json:"properties,omitempty"`
}

// AvailableRpOperationDisplayInfo - Description of an available operation
type AvailableRpOperationDisplayInfo struct {
	// Operation description
	Description *string `json:"description,omitempty"`

	// Operation name
	Operation *string `json:"operation,omitempty"`

	// Resource provider name
	Provider *string `json:"provider,omitempty"`

	// Resource type
	Resource *string `json:"resource,omitempty"`
}

// AzureADOnlyAuthentication - Azure Active Directory Only Authentication Info
type AzureADOnlyAuthentication struct {
	// azureADOnlyAuthentication resource properties
	Properties *AzureADOnlyAuthenticationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AzureADOnlyAuthenticationListResult - A list of active directory only authentications.
type AzureADOnlyAuthenticationListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*AzureADOnlyAuthentication `json:"value,omitempty" azure:"ro"`
}

// AzureADOnlyAuthenticationProperties - Properties of a active directory only authentication.
type AzureADOnlyAuthenticationProperties struct {
	// REQUIRED; Azure Active Directory only Authentication enabled.
	AzureADOnlyAuthentication *bool `json:"azureADOnlyAuthentication,omitempty"`

	// READ-ONLY; property configuration date
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; property configuration state
	State *StateValue `json:"state,omitempty" azure:"ro"`
}

// AzureADOnlyAuthenticationsClientBeginCreateOptions contains the optional parameters for the AzureADOnlyAuthenticationsClient.BeginCreate
// method.
type AzureADOnlyAuthenticationsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AzureADOnlyAuthenticationsClientGetOptions contains the optional parameters for the AzureADOnlyAuthenticationsClient.Get
// method.
type AzureADOnlyAuthenticationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AzureADOnlyAuthenticationsClientListOptions contains the optional parameters for the AzureADOnlyAuthenticationsClient.List
// method.
type AzureADOnlyAuthenticationsClientListOptions struct {
	// placeholder for future optional parameters
}

// AzureCapacity - Azure capacity definition.
type AzureCapacity struct {
	// REQUIRED; The default capacity that would be used.
	Default *int32 `json:"default,omitempty"`

	// REQUIRED; Maximum allowed capacity.
	Maximum *int32 `json:"maximum,omitempty"`

	// REQUIRED; Minimum allowed capacity.
	Minimum *int32 `json:"minimum,omitempty"`

	// REQUIRED; Scale type.
	ScaleType *AzureScaleType `json:"scaleType,omitempty"`
}

// AzureEntityResource - The resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AzureResourceSKU - Azure resource SKU definition.
type AzureResourceSKU struct {
	// The number of instances of the cluster.
	Capacity *AzureCapacity `json:"capacity,omitempty"`

	// Resource Namespace and Type.
	ResourceType *string `json:"resourceType,omitempty"`

	// The SKU details.
	SKU *AzureSKU `json:"sku,omitempty"`
}

// AzureSKU - Azure SKU definition.
type AzureSKU struct {
	// REQUIRED; SKU name.
	Name *SKUName `json:"name,omitempty"`

	// REQUIRED; SKU size.
	Size *SKUSize `json:"size,omitempty"`

	// The number of instances of the cluster.
	Capacity *int32 `json:"capacity,omitempty"`
}

// BigDataPoolPatchInfo - Properties patch for a Big Data pool
type BigDataPoolPatchInfo struct {
	// Updated tags for the Big Data pool
	Tags map[string]*string `json:"tags,omitempty"`
}

// BigDataPoolResourceInfo - A Big Data pool
type BigDataPoolResourceInfo struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Big Data pool properties
	Properties *BigDataPoolResourceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BigDataPoolResourceInfoListResult - Collection of Big Data pool information
type BigDataPoolResourceInfoListResult struct {
	// Link to the next page of results
	NextLink *string `json:"nextLink,omitempty"`

	// List of Big Data pools
	Value []*BigDataPoolResourceInfo `json:"value,omitempty"`
}

// BigDataPoolResourceProperties - Properties of a Big Data pool powered by Apache Spark
type BigDataPoolResourceProperties struct {
	// Auto-pausing properties
	AutoPause *AutoPauseProperties `json:"autoPause,omitempty"`

	// Auto-scaling properties
	AutoScale *AutoScaleProperties `json:"autoScale,omitempty"`

	// The cache size
	CacheSize *int32 `json:"cacheSize,omitempty"`

	// List of custom libraries/packages associated with the spark pool.
	CustomLibraries []*LibraryInfo `json:"customLibraries,omitempty"`

	// The default folder where Spark logs will be written.
	DefaultSparkLogFolder *string `json:"defaultSparkLogFolder,omitempty"`

	// Dynamic Executor Allocation
	DynamicExecutorAllocation *DynamicExecutorAllocation `json:"dynamicExecutorAllocation,omitempty"`

	// Whether compute isolation is required or not.
	IsComputeIsolationEnabled *bool `json:"isComputeIsolationEnabled,omitempty"`

	// Library version requirements
	LibraryRequirements *LibraryRequirements `json:"libraryRequirements,omitempty"`

	// The number of nodes in the Big Data pool.
	NodeCount *int32 `json:"nodeCount,omitempty"`

	// The level of compute power that each node in the Big Data pool has.
	NodeSize *NodeSize `json:"nodeSize,omitempty"`

	// The kind of nodes that the Big Data pool provides.
	NodeSizeFamily *NodeSizeFamily `json:"nodeSizeFamily,omitempty"`

	// The state of the Big Data pool.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Whether session level packages enabled.
	SessionLevelPackagesEnabled *bool `json:"sessionLevelPackagesEnabled,omitempty"`

	// Spark configuration file to specify additional properties
	SparkConfigProperties *SparkConfigProperties `json:"sparkConfigProperties,omitempty"`

	// The Spark events folder
	SparkEventsFolder *string `json:"sparkEventsFolder,omitempty"`

	// The Apache Spark version.
	SparkVersion *string `json:"sparkVersion,omitempty"`

	// READ-ONLY; The time when the Big Data pool was created.
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; The time when the Big Data pool was updated successfully.
	LastSucceededTimestamp *time.Time `json:"lastSucceededTimestamp,omitempty" azure:"ro"`
}

// BigDataPoolsClientBeginCreateOrUpdateOptions contains the optional parameters for the BigDataPoolsClient.BeginCreateOrUpdate
// method.
type BigDataPoolsClientBeginCreateOrUpdateOptions struct {
	// Whether to stop any running jobs in the Big Data pool
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BigDataPoolsClientBeginDeleteOptions contains the optional parameters for the BigDataPoolsClient.BeginDelete method.
type BigDataPoolsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BigDataPoolsClientGetOptions contains the optional parameters for the BigDataPoolsClient.Get method.
type BigDataPoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// BigDataPoolsClientListByWorkspaceOptions contains the optional parameters for the BigDataPoolsClient.ListByWorkspace method.
type BigDataPoolsClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// BigDataPoolsClientUpdateOptions contains the optional parameters for the BigDataPoolsClient.Update method.
type BigDataPoolsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// CheckNameAvailabilityRequest - A request about whether a workspace name is available
type CheckNameAvailabilityRequest struct {
	// Workspace name
	Name *string `json:"name,omitempty"`

	// Type: workspace
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse - A response saying whether the workspace name is available
type CheckNameAvailabilityResponse struct {
	// Whether the workspace name is available
	Available *bool `json:"available,omitempty"`

	// Validation message
	Message *string `json:"message,omitempty"`

	// Workspace name
	Name *string `json:"name,omitempty"`

	// Reason the workspace name is or is not available
	Reason *string `json:"reason,omitempty"`
}

// CheckNameResult - The result returned from a check name availability request.
type CheckNameResult struct {
	// Message indicating an unavailable name due to a conflict, or a description of the naming rules that are violated.
	Message *string `json:"message,omitempty"`

	// The name that was checked.
	Name *string `json:"name,omitempty"`

	// Specifies a Boolean value that indicates if the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// Message providing the reason why the given name is invalid.
	Reason *Reason `json:"reason,omitempty"`
}

// ClusterPrincipalAssignment - Class representing a cluster principal assignment.
type ClusterPrincipalAssignment struct {
	// The cluster principal.
	Properties *ClusterPrincipalProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClusterPrincipalAssignmentCheckNameRequest - A principal assignment check name availability request.
type ClusterPrincipalAssignmentCheckNameRequest struct {
	// REQUIRED; Principal Assignment resource name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The type of resource, Microsoft.Synapse/workspaces/kustoPools/principalAssignments.
	Type *string `json:"type,omitempty"`
}

// ClusterPrincipalAssignmentListResult - The list Kusto cluster principal assignments operation response.
type ClusterPrincipalAssignmentListResult struct {
	// The list of Kusto cluster principal assignments.
	Value []*ClusterPrincipalAssignment `json:"value,omitempty"`
}

// ClusterPrincipalProperties - A class representing cluster principal property.
type ClusterPrincipalProperties struct {
	// REQUIRED; The principal ID assigned to the cluster principal. It can be a user email, application ID, or security group
	// name.
	PrincipalID *string `json:"principalId,omitempty"`

	// REQUIRED; Principal type.
	PrincipalType *PrincipalType `json:"principalType,omitempty"`

	// REQUIRED; Cluster principal role.
	Role *ClusterPrincipalRole `json:"role,omitempty"`

	// The tenant id of the principal
	TenantID *string `json:"tenantId,omitempty"`

	// READ-ONLY; The principal name
	PrincipalName *string `json:"principalName,omitempty" azure:"ro"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The tenant name of the principal
	TenantName *string `json:"tenantName,omitempty" azure:"ro"`
}

// CmdkeySetup - The custom setup of running cmdkey commands.
type CmdkeySetup struct {
	// REQUIRED; The type of custom setup.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Cmdkey command custom setup type properties.
	TypeProperties *CmdkeySetupTypeProperties `json:"typeProperties,omitempty"`
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type CmdkeySetup.
func (c *CmdkeySetup) GetCustomSetupBase() *CustomSetupBase {
	return &CustomSetupBase{
		Type: c.Type,
	}
}

// CmdkeySetupTypeProperties - Cmdkey command custom setup type properties.
type CmdkeySetupTypeProperties struct {
	// REQUIRED; The password of data source access.
	Password SecretBaseClassification `json:"password,omitempty"`

	// REQUIRED; The server name of data source access.
	TargetName interface{} `json:"targetName,omitempty"`

	// REQUIRED; The user name of data source access.
	UserName interface{} `json:"userName,omitempty"`
}

// ComponentSetup - The custom setup of installing 3rd party components.
type ComponentSetup struct {
	// REQUIRED; The type of custom setup.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Install 3rd party component type properties.
	TypeProperties *LicensedComponentSetupTypeProperties `json:"typeProperties,omitempty"`
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type ComponentSetup.
func (c *ComponentSetup) GetCustomSetupBase() *CustomSetupBase {
	return &CustomSetupBase{
		Type: c.Type,
	}
}

// CreateSQLPoolRestorePointDefinition - Contains the information necessary to perform a create Sql pool restore point operation.
type CreateSQLPoolRestorePointDefinition struct {
	// REQUIRED; The restore point label to apply
	RestorePointLabel *string `json:"restorePointLabel,omitempty"`
}

// CspWorkspaceAdminProperties - Initial workspace AAD admin properties for a CSP subscription
type CspWorkspaceAdminProperties struct {
	// AAD object ID of initial workspace admin
	InitialWorkspaceAdminObjectID *string `json:"initialWorkspaceAdminObjectId,omitempty"`
}

// CustomSetupBaseClassification provides polymorphic access to related types.
// Call the interface's GetCustomSetupBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CmdkeySetup, *ComponentSetup, *CustomSetupBase, *EnvironmentVariableSetup
type CustomSetupBaseClassification interface {
	// GetCustomSetupBase returns the CustomSetupBase content of the underlying type.
	GetCustomSetupBase() *CustomSetupBase
}

// CustomSetupBase - The base definition of the custom setup.
type CustomSetupBase struct {
	// REQUIRED; The type of custom setup.
	Type *string `json:"type,omitempty"`
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type CustomSetupBase.
func (c *CustomSetupBase) GetCustomSetupBase() *CustomSetupBase { return c }

// CustomerManagedKeyDetails - Details of the customer managed key associated with the workspace
type CustomerManagedKeyDetails struct {
	// Key encryption key
	KekIdentity *KekIdentityProperties `json:"kekIdentity,omitempty"`

	// The key object of the workspace
	Key *WorkspaceKeyDetails `json:"key,omitempty"`

	// READ-ONLY; The customer managed key status on the workspace
	Status *string `json:"status,omitempty" azure:"ro"`
}

// DataConnectionClassification provides polymorphic access to related types.
// Call the interface's GetDataConnection() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DataConnection, *EventGridDataConnection, *EventHubDataConnection, *IotHubDataConnection
type DataConnectionClassification interface {
	// GetDataConnection returns the DataConnection content of the underlying type.
	GetDataConnection() *DataConnection
}

// DataConnection - Class representing a data connection.
type DataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind `json:"kind,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataConnection implements the DataConnectionClassification interface for type DataConnection.
func (d *DataConnection) GetDataConnection() *DataConnection { return d }

// DataConnectionCheckNameRequest - A data connection check name availability request.
type DataConnectionCheckNameRequest struct {
	// REQUIRED; Data Connection name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The type of resource, Microsoft.Synapse/workspaces/kustoPools/databases/dataConnections.
	Type *string `json:"type,omitempty"`
}

// DataConnectionListResult - The list Kusto data connections operation response.
type DataConnectionListResult struct {
	// The list of Kusto data connections.
	Value []DataConnectionClassification `json:"value,omitempty"`
}

// DataConnectionValidation - Class representing an data connection validation.
type DataConnectionValidation struct {
	// The name of the data connection.
	DataConnectionName *string `json:"dataConnectionName,omitempty"`

	// The data connection properties to validate.
	Properties DataConnectionClassification `json:"properties,omitempty"`
}

// DataConnectionValidationListResult - The list Kusto data connection validation result.
type DataConnectionValidationListResult struct {
	// The list of Kusto data connection validation errors.
	Value []*DataConnectionValidationResult `json:"value,omitempty"`
}

// DataConnectionValidationResult - The result returned from a data connection validation request.
type DataConnectionValidationResult struct {
	// A message which indicates a problem in data connection validation.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// DataLakeStorageAccountDetails - Details of the data lake storage account associated with the workspace
type DataLakeStorageAccountDetails struct {
	// Account URL
	AccountURL *string `json:"accountUrl,omitempty"`

	// Create managed private endpoint to this storage account or not
	CreateManagedPrivateEndpoint *bool `json:"createManagedPrivateEndpoint,omitempty"`

	// Filesystem name
	Filesystem *string `json:"filesystem,omitempty"`

	// ARM resource Id of this storage account
	ResourceID *string `json:"resourceId,omitempty"`
}

// DataMaskingPoliciesClientCreateOrUpdateOptions contains the optional parameters for the DataMaskingPoliciesClient.CreateOrUpdate
// method.
type DataMaskingPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DataMaskingPoliciesClientGetOptions contains the optional parameters for the DataMaskingPoliciesClient.Get method.
type DataMaskingPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

type DataMaskingPolicy struct {
	// The properties of the data masking policy.
	Properties *DataMaskingPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The kind of data masking policy. Metadata, used for Azure portal.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; The location of the data masking policy.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID of the sql pool
	ManagedBy *string `json:"managedBy,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataMaskingPolicyProperties - The properties of a database data masking policy.
type DataMaskingPolicyProperties struct {
	// REQUIRED; The state of the data masking policy.
	DataMaskingState *DataMaskingState `json:"dataMaskingState,omitempty"`

	// The list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking
	// policy does not apply. The specified users receive data results without masking
	// for all of the database queries.
	ExemptPrincipals *string `json:"exemptPrincipals,omitempty"`

	// READ-ONLY; The list of the application principals. This is a legacy parameter and is no longer used.
	ApplicationPrincipals *string `json:"applicationPrincipals,omitempty" azure:"ro"`

	// READ-ONLY; The masking level. This is a legacy parameter and is no longer used.
	MaskingLevel *string `json:"maskingLevel,omitempty" azure:"ro"`
}

// DataMaskingRule - Represents a Sql pool data masking rule.
type DataMaskingRule struct {
	// The properties of the resource.
	Properties *DataMaskingRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The kind of Data Masking Rule. Metadata, used for Azure portal.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; The location of the data masking rule.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataMaskingRuleListResult - The response to a list data masking rules request.
type DataMaskingRuleListResult struct {
	// The list of Sql pool data masking rules.
	Value []*DataMaskingRule `json:"value,omitempty"`
}

// DataMaskingRuleProperties - The properties of a Sql pool data masking rule.
type DataMaskingRuleProperties struct {
	// REQUIRED; The column name on which the data masking rule is applied.
	ColumnName *string `json:"columnName,omitempty"`

	// REQUIRED; The masking function that is used for the data masking rule.
	MaskingFunction *DataMaskingFunction `json:"maskingFunction,omitempty"`

	// REQUIRED; The schema name on which the data masking rule is applied.
	SchemaName *string `json:"schemaName,omitempty"`

	// REQUIRED; The table name on which the data masking rule is applied.
	TableName *string `json:"tableName,omitempty"`

	// The alias name. This is a legacy parameter and is no longer used.
	AliasName *string `json:"aliasName,omitempty"`

	// The numberFrom property of the masking rule. Required if maskingFunction is set to Number, otherwise this parameter will
	// be ignored.
	NumberFrom *string `json:"numberFrom,omitempty"`

	// The numberTo property of the data masking rule. Required if maskingFunction is set to Number, otherwise this parameter
	// will be ignored.
	NumberTo *string `json:"numberTo,omitempty"`

	// If maskingFunction is set to Text, the number of characters to show unmasked in the beginning of the string. Otherwise,
	// this parameter will be ignored.
	PrefixSize *string `json:"prefixSize,omitempty"`

	// If maskingFunction is set to Text, the character to use for masking the unexposed part of the string. Otherwise, this parameter
	// will be ignored.
	ReplacementString *string `json:"replacementString,omitempty"`

	// The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName, columnName, maskingFunction,
	// and specify ruleState as disabled. However, if the rule doesn't
	// already exist, the rule will be created with ruleState set to enabled, regardless of the provided value of ruleState.
	RuleState *DataMaskingRuleState `json:"ruleState,omitempty"`

	// If maskingFunction is set to Text, the number of characters to show unmasked at the end of the string. Otherwise, this
	// parameter will be ignored.
	SuffixSize *string `json:"suffixSize,omitempty"`

	// READ-ONLY; The rule Id.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// DataMaskingRulesClientCreateOrUpdateOptions contains the optional parameters for the DataMaskingRulesClient.CreateOrUpdate
// method.
type DataMaskingRulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DataMaskingRulesClientGetOptions contains the optional parameters for the DataMaskingRulesClient.Get method.
type DataMaskingRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataMaskingRulesClientListBySQLPoolOptions contains the optional parameters for the DataMaskingRulesClient.ListBySQLPool
// method.
type DataMaskingRulesClientListBySQLPoolOptions struct {
	// placeholder for future optional parameters
}

// DataWarehouseUserActivities - User activities of a data warehouse
type DataWarehouseUserActivities struct {
	// Resource properties.
	Properties *DataWarehouseUserActivitiesProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataWarehouseUserActivitiesProperties - User activities of a data warehouse. This currently includes the count of running
// or suspended queries. For more information, please view the sys.dmpdwexec_requests dynamic management view (DMV).
type DataWarehouseUserActivitiesProperties struct {
	// READ-ONLY; Count of running and suspended queries.
	ActiveQueriesCount *int32 `json:"activeQueriesCount,omitempty" azure:"ro"`
}

// DatabaseClassification provides polymorphic access to related types.
// Call the interface's GetDatabase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *Database, *ReadOnlyFollowingDatabase, *ReadWriteDatabase
type DatabaseClassification interface {
	// GetDatabase returns the Database content of the underlying type.
	GetDatabase() *Database
}

// Database - Class representing a Kusto database.
type Database struct {
	// REQUIRED; Kind of the database
	Kind *Kind `json:"kind,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDatabase implements the DatabaseClassification interface for type Database.
func (d *Database) GetDatabase() *Database { return d }

// DatabaseCheckNameRequest - The result returned from a database check name availability request.
type DatabaseCheckNameRequest struct {
	// REQUIRED; Resource name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The type of resource, for instance Microsoft.Synapse/workspaces/kustoPools/databases.
	Type *Type `json:"type,omitempty"`
}

// DatabaseListResult - The list Kusto databases operation response.
type DatabaseListResult struct {
	// The list of Kusto databases.
	Value []DatabaseClassification `json:"value,omitempty"`
}

// DatabasePrincipalAssignment - Class representing a database principal assignment.
type DatabasePrincipalAssignment struct {
	// The database principal.
	Properties *DatabasePrincipalProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabasePrincipalAssignmentCheckNameRequest - A principal assignment check name availability request.
type DatabasePrincipalAssignmentCheckNameRequest struct {
	// REQUIRED; Principal Assignment resource name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The type of resource, Microsoft.Synapse/workspaces/kustoPools/databases/principalAssignments.
	Type *string `json:"type,omitempty"`
}

// DatabasePrincipalAssignmentListResult - The list Kusto database principal assignments operation response.
type DatabasePrincipalAssignmentListResult struct {
	// The list of Kusto database principal assignments.
	Value []*DatabasePrincipalAssignment `json:"value,omitempty"`
}

// DatabasePrincipalProperties - A class representing database principal property.
type DatabasePrincipalProperties struct {
	// REQUIRED; The principal ID assigned to the database principal. It can be a user email, application ID, or security group
	// name.
	PrincipalID *string `json:"principalId,omitempty"`

	// REQUIRED; Principal type.
	PrincipalType *PrincipalType `json:"principalType,omitempty"`

	// REQUIRED; Database principal role.
	Role *DatabasePrincipalRole `json:"role,omitempty"`

	// The tenant id of the principal
	TenantID *string `json:"tenantId,omitempty"`

	// READ-ONLY; The principal name
	PrincipalName *string `json:"principalName,omitempty" azure:"ro"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The tenant name of the principal
	TenantName *string `json:"tenantName,omitempty" azure:"ro"`
}

// DatabaseStatistics - A class that contains database statistics information.
type DatabaseStatistics struct {
	// The database size - the total size of compressed data and index in bytes.
	Size *float32 `json:"size,omitempty"`
}

// DedicatedSQLminimalTLSSettings - Dedicated Sql Minimal Tls Settings Info
type DedicatedSQLminimalTLSSettings struct {
	// Resource properties.
	Properties *DedicatedSQLminimalTLSSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DedicatedSQLminimalTLSSettingsListResult - A list of the server's dedicated sql minimal tls settings.
type DedicatedSQLminimalTLSSettingsListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*DedicatedSQLminimalTLSSettings `json:"value,omitempty" azure:"ro"`
}

// DedicatedSQLminimalTLSSettingsPatchInfo - Dedicated SQL minimal tls settings patch info
type DedicatedSQLminimalTLSSettingsPatchInfo struct {
	// minimal tls version
	MinimalTLSVersion *string `json:"minimalTlsVersion,omitempty"`
}

// DedicatedSQLminimalTLSSettingsProperties - Properties of a dedicated sql minimal tls settings.
type DedicatedSQLminimalTLSSettingsProperties struct {
	// The minimal tls version of the sql server.
	MinimalTLSVersion *string `json:"minimalTlsVersion,omitempty"`
}

// DynamicExecutorAllocation - Dynamic Executor Allocation Properties
type DynamicExecutorAllocation struct {
	// Indicates whether Dynamic Executor Allocation is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`

	// The maximum number of executors alloted
	MaxExecutors *int32 `json:"maxExecutors,omitempty"`

	// The minimum number of executors alloted
	MinExecutors *int32 `json:"minExecutors,omitempty"`
}

// EncryptionDetails - Details of the encryption associated with the workspace
type EncryptionDetails struct {
	// Customer Managed Key Details
	Cmk *CustomerManagedKeyDetails `json:"cmk,omitempty"`

	// READ-ONLY; Double Encryption enabled
	DoubleEncryptionEnabled *bool `json:"doubleEncryptionEnabled,omitempty" azure:"ro"`
}

// EncryptionProtector - The server encryption protector.
type EncryptionProtector struct {
	// Resource properties.
	Properties *EncryptionProtectorProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EncryptionProtectorListResult - A list of server encryption protectors.
type EncryptionProtectorListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*EncryptionProtector `json:"value,omitempty" azure:"ro"`
}

// EncryptionProtectorProperties - Properties for an encryption protector execution.
type EncryptionProtectorProperties struct {
	// REQUIRED; The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
	ServerKeyType *ServerKeyType `json:"serverKeyType,omitempty"`

	// The name of the server key.
	ServerKeyName *string `json:"serverKeyName,omitempty"`

	// READ-ONLY; Subregion of the encryption protector.
	Subregion *string `json:"subregion,omitempty" azure:"ro"`

	// READ-ONLY; Thumbprint of the server key.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`

	// READ-ONLY; The URI of the server key.
	URI *string `json:"uri,omitempty" azure:"ro"`
}

// EntityReference - The entity reference.
type EntityReference struct {
	// The name of this referenced entity.
	ReferenceName *string `json:"referenceName,omitempty"`

	// The type of this referenced entity.
	Type *IntegrationRuntimeEntityReferenceType `json:"type,omitempty"`
}

// EnvironmentVariableSetup - The custom setup of setting environment variable.
type EnvironmentVariableSetup struct {
	// REQUIRED; The type of custom setup.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Add environment variable type properties.
	TypeProperties *EnvironmentVariableSetupTypeProperties `json:"typeProperties,omitempty"`
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type EnvironmentVariableSetup.
func (e *EnvironmentVariableSetup) GetCustomSetupBase() *CustomSetupBase {
	return &CustomSetupBase{
		Type: e.Type,
	}
}

// EnvironmentVariableSetupTypeProperties - Environment variable custom setup type properties.
type EnvironmentVariableSetupTypeProperties struct {
	// REQUIRED; The name of the environment variable.
	VariableName *string `json:"variableName,omitempty"`

	// REQUIRED; The value of the environment variable.
	VariableValue *string `json:"variableValue,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// EventGridConnectionProperties - Class representing the Kusto event grid connection properties.
type EventGridConnectionProperties struct {
	// REQUIRED; The event hub consumer group.
	ConsumerGroup *string `json:"consumerGroup,omitempty"`

	// REQUIRED; The resource ID where the event grid is configured to send events.
	EventHubResourceID *string `json:"eventHubResourceId,omitempty"`

	// REQUIRED; The resource ID of the storage account where the data resides.
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`

	// The name of blob storage event type to process.
	BlobStorageEventType *BlobStorageEventType `json:"blobStorageEventType,omitempty"`

	// The data format of the message. Optionally the data format can be added to each message.
	DataFormat *EventGridDataFormat `json:"dataFormat,omitempty"`

	// A Boolean value that, if set to true, indicates that ingestion should ignore the first record of every file
	IgnoreFirstRecord *bool `json:"ignoreFirstRecord,omitempty"`

	// The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string `json:"mappingRuleName,omitempty"`

	// The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string `json:"tableName,omitempty"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// EventGridDataConnection - Class representing an Event Grid data connection.
type EventGridDataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind `json:"kind,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// The properties of the Event Grid data connection.
	Properties *EventGridConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataConnection implements the DataConnectionClassification interface for type EventGridDataConnection.
func (e *EventGridDataConnection) GetDataConnection() *DataConnection {
	return &DataConnection{
		Location:   e.Location,
		Kind:       e.Kind,
		SystemData: e.SystemData,
		ID:         e.ID,
		Name:       e.Name,
		Type:       e.Type,
	}
}

// EventHubConnectionProperties - Class representing the Kusto event hub connection properties.
type EventHubConnectionProperties struct {
	// REQUIRED; The event hub consumer group.
	ConsumerGroup *string `json:"consumerGroup,omitempty"`

	// REQUIRED; The resource ID of the event hub to be used to create a data connection.
	EventHubResourceID *string `json:"eventHubResourceId,omitempty"`

	// The event hub messages compression type
	Compression *Compression `json:"compression,omitempty"`

	// The data format of the message. Optionally the data format can be added to each message.
	DataFormat *EventHubDataFormat `json:"dataFormat,omitempty"`

	// System properties of the event hub
	EventSystemProperties []*string `json:"eventSystemProperties,omitempty"`

	// The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub.
	ManagedIdentityResourceID *string `json:"managedIdentityResourceId,omitempty"`

	// The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string `json:"mappingRuleName,omitempty"`

	// The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string `json:"tableName,omitempty"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// EventHubDataConnection - Class representing an event hub data connection.
type EventHubDataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind `json:"kind,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// The Event Hub data connection properties to validate.
	Properties *EventHubConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataConnection implements the DataConnectionClassification interface for type EventHubDataConnection.
func (e *EventHubDataConnection) GetDataConnection() *DataConnection {
	return &DataConnection{
		Location:   e.Location,
		Kind:       e.Kind,
		SystemData: e.SystemData,
		ID:         e.ID,
		Name:       e.Name,
		Type:       e.Type,
	}
}

// ExtendedSQLPoolBlobAuditingPoliciesClientCreateOrUpdateOptions contains the optional parameters for the ExtendedSQLPoolBlobAuditingPoliciesClient.CreateOrUpdate
// method.
type ExtendedSQLPoolBlobAuditingPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ExtendedSQLPoolBlobAuditingPoliciesClientGetOptions contains the optional parameters for the ExtendedSQLPoolBlobAuditingPoliciesClient.Get
// method.
type ExtendedSQLPoolBlobAuditingPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExtendedSQLPoolBlobAuditingPoliciesClientListBySQLPoolOptions contains the optional parameters for the ExtendedSQLPoolBlobAuditingPoliciesClient.ListBySQLPool
// method.
type ExtendedSQLPoolBlobAuditingPoliciesClientListBySQLPoolOptions struct {
	// placeholder for future optional parameters
}

// ExtendedSQLPoolBlobAuditingPolicy - An extended Sql pool blob auditing policy.
type ExtendedSQLPoolBlobAuditingPolicy struct {
	// Resource properties.
	Properties *ExtendedSQLPoolBlobAuditingPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExtendedSQLPoolBlobAuditingPolicyListResult - A list of sql pool extended auditing settings.
type ExtendedSQLPoolBlobAuditingPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ExtendedSQLPoolBlobAuditingPolicy `json:"value,omitempty" azure:"ro"`
}

// ExtendedSQLPoolBlobAuditingPolicyProperties - Properties of an extended Sql pool blob auditing policy.
type ExtendedSQLPoolBlobAuditingPolicyProperties struct {
	// REQUIRED; Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
	State *BlobAuditingPolicyState `json:"state,omitempty"`

	// Specifies the Actions-Groups and Actions to audit.
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures
	// executed against the database, as well as successful and failed logins:
	// BATCHCOMPLETEDGROUP, SUCCESSFULDATABASEAUTHENTICATIONGROUP, FAILEDDATABASEAUTHENTICATIONGROUP.
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary
	// groups could lead to very large quantities of audit records):
	// APPLICATIONROLECHANGEPASSWORDGROUP BACKUPRESTOREGROUP DATABASELOGOUTGROUP DATABASEOBJECTCHANGEGROUP DATABASEOBJECTOWNERSHIPCHANGEGROUP
	// DATABASEOBJECTPERMISSIONCHANGEGROUP DATABASEOPERATIONGROUP
	// DATABASEPERMISSIONCHANGEGROUP DATABASEPRINCIPALCHANGEGROUP DATABASEPRINCIPALIMPERSONATIONGROUP DATABASEROLEMEMBERCHANGEGROUP
	// FAILEDDATABASEAUTHENTICATIONGROUP SCHEMAOBJECTACCESSGROUP SCHEMAOBJECT
	// CHANGEGROUP SCHEMAOBJECTOWNERSHIPCHANGEGROUP SCHEMAOBJECTPERMISSIONCHANGEGROUP SUCCESSFULDATABASEAUTHENTICATIONGROUP USERCHANGEPASSWORDGROUP
	// BATCHSTARTEDGROUP BATCHCOMPLETED_GROUP
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used
	// in combination with other groups as this will result in duplicate audit logs.
	// For more information, see Database-Level Audit Action Groups
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups].
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server
	// auditing policy). The supported actions to audit are: SELECT UPDATE INSERT DELETE
	// EXECUTE RECEIVE REFERENCES
	// The general form for defining an action to be audited is: {action} ON {object} BY {principal}
	// Note that in the above format can refer to an object like a table, view, or stored procedure, or an entire database or
	// schema. For the latter cases, the forms DATABASE::{dbname} and SCHEMA::{schema
	// name} are used, respectively.
	// For example: SELECT on dbo.myTable by public SELECT on DATABASE::myDatabase by public SELECT on SCHEMA::mySchema by public
	// For more information, see Database-Level Audit Actions
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions]
	AuditActionsAndGroups []*string `json:"auditActionsAndGroups,omitempty"`

	// Specifies whether audit events are sent to Azure Monitor. In order to send the events to Azure Monitor, specify 'state'
	// as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on
	// the database should be also created. Note that for server level audit you
	// should use the 'master' database as {databaseName}.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`

	// Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`

	// Specifies condition of where clause when creating an audit.
	PredicateExpression *string `json:"predicateExpression,omitempty"`

	// Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed. The default
	// minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`

	// Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`

	// Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, not
	// specifying the storageAccountAccessKey will use SQL server system-assigned
	// managed identity to access the storage. Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server
	// identity. For more information, see Auditing to storage using Managed
	// Identity authentication [https://go.microsoft.com/fwlink/?linkid=2114355]
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *string `json:"storageAccountSubscriptionId,omitempty"`

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint
	// or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
}

// ExtendedServerBlobAuditingPolicy - An extended server blob auditing policy.
type ExtendedServerBlobAuditingPolicy struct {
	// Resource properties.
	Properties *ExtendedServerBlobAuditingPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExtendedServerBlobAuditingPolicyListResult - A list of server extended auditing settings.
type ExtendedServerBlobAuditingPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ExtendedServerBlobAuditingPolicy `json:"value,omitempty" azure:"ro"`
}

// ExtendedServerBlobAuditingPolicyProperties - Properties of an extended server blob auditing policy.
type ExtendedServerBlobAuditingPolicyProperties struct {
	// REQUIRED; Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
	State *BlobAuditingPolicyState `json:"state,omitempty"`

	// Specifies the Actions-Groups and Actions to audit.
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures
	// executed against the database, as well as successful and failed logins:
	// BATCHCOMPLETEDGROUP, SUCCESSFULDATABASEAUTHENTICATIONGROUP, FAILEDDATABASEAUTHENTICATIONGROUP.
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary
	// groups could lead to very large quantities of audit records):
	// APPLICATIONROLECHANGEPASSWORDGROUP BACKUPRESTOREGROUP DATABASELOGOUTGROUP DATABASEOBJECTCHANGEGROUP DATABASEOBJECTOWNERSHIPCHANGEGROUP
	// DATABASEOBJECTPERMISSIONCHANGEGROUP DATABASEOPERATIONGROUP
	// DATABASEPERMISSIONCHANGEGROUP DATABASEPRINCIPALCHANGEGROUP DATABASEPRINCIPALIMPERSONATIONGROUP DATABASEROLEMEMBERCHANGEGROUP
	// FAILEDDATABASEAUTHENTICATIONGROUP SCHEMAOBJECTACCESSGROUP SCHEMAOBJECT
	// CHANGEGROUP SCHEMAOBJECTOWNERSHIPCHANGEGROUP SCHEMAOBJECTPERMISSIONCHANGEGROUP SUCCESSFULDATABASEAUTHENTICATIONGROUP USERCHANGEPASSWORDGROUP
	// BATCHSTARTEDGROUP BATCHCOMPLETED_GROUP
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used
	// in combination with other groups as this will result in duplicate audit logs.
	// For more information, see Database-Level Audit Action Groups
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups].
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server
	// auditing policy). The supported actions to audit are: SELECT UPDATE INSERT DELETE
	// EXECUTE RECEIVE REFERENCES
	// The general form for defining an action to be audited is: {action} ON {object} BY {principal}
	// Note that in the above format can refer to an object like a table, view, or stored procedure, or an entire database or
	// schema. For the latter cases, the forms DATABASE::{dbname} and SCHEMA::{schema
	// name} are used, respectively.
	// For example: SELECT on dbo.myTable by public SELECT on DATABASE::myDatabase by public SELECT on SCHEMA::mySchema by public
	// For more information, see Database-Level Audit Actions
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions]
	AuditActionsAndGroups []*string `json:"auditActionsAndGroups,omitempty"`

	// Specifies whether audit events are sent to Azure Monitor. In order to send the events to Azure Monitor, specify 'state'
	// as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on
	// the database should be also created. Note that for server level audit you
	// should use the 'master' database as {databaseName}.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`

	// Specifies the state of devops audit. If state is Enabled, devops logs will be sent to Azure Monitor. In order to send the
	// events to Azure Monitor, specify 'State' as 'Enabled',
	// 'IsAzureMonitorTargetEnabled' as true and 'IsDevopsAuditEnabled' as true
	// When using REST API to configure auditing, Diagnostic Settings with 'DevOpsOperationsAudit' diagnostic logs category on
	// the master database should also be created.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsDevopsAuditEnabled *bool `json:"isDevopsAuditEnabled,omitempty"`

	// Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`

	// Specifies condition of where clause when creating an audit.
	PredicateExpression *string `json:"predicateExpression,omitempty"`

	// Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed. The default
	// minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`

	// Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`

	// Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, not
	// specifying the storageAccountAccessKey will use SQL server system-assigned
	// managed identity to access the storage. Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server
	// identity. For more information, see Auditing to storage using Managed
	// Identity authentication [https://go.microsoft.com/fwlink/?linkid=2114355]
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *string `json:"storageAccountSubscriptionId,omitempty"`

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint
	// or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
}

// FollowerDatabaseDefinition - A class representing follower database request.
type FollowerDatabaseDefinition struct {
	// REQUIRED; Resource name of the attached database configuration in the follower cluster.
	AttachedDatabaseConfigurationName *string `json:"attachedDatabaseConfigurationName,omitempty"`

	// REQUIRED; Resource id of the cluster that follows a database owned by this cluster.
	KustoPoolResourceID *string `json:"clusterResourceId,omitempty"`

	// READ-ONLY; The database name owned by this cluster that was followed. * in case following all databases.
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`
}

// FollowerDatabaseListResult - The list Kusto database principals operation response.
type FollowerDatabaseListResult struct {
	// The list of follower database result.
	Value []*FollowerDatabaseDefinition `json:"value,omitempty"`
}

// GeoBackupPolicy - A database geo backup policy.
type GeoBackupPolicy struct {
	// REQUIRED; The properties of the geo backup policy.
	Properties *GeoBackupPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Kind of geo backup policy. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Backup policy location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GeoBackupPolicyListResult - The response to a list geo backup policies request.
type GeoBackupPolicyListResult struct {
	// The list of geo backup policies.
	Value []*GeoBackupPolicy `json:"value,omitempty"`
}

// GeoBackupPolicyProperties - The properties of the geo backup policy.
type GeoBackupPolicyProperties struct {
	// REQUIRED; The state of the geo backup policy.
	State *GeoBackupPolicyState `json:"state,omitempty"`

	// READ-ONLY; The storage type of the geo backup policy.
	StorageType *string `json:"storageType,omitempty" azure:"ro"`
}

// GetSsisObjectMetadataRequest - The request payload of get SSIS object metadata.
type GetSsisObjectMetadataRequest struct {
	// Metadata path.
	MetadataPath *string `json:"metadataPath,omitempty"`
}

// IPFirewallRuleInfo - IP firewall rule
type IPFirewallRuleInfo struct {
	// IP firewall rule properties
	Properties *IPFirewallRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IPFirewallRuleInfoListResult - List of IP firewall rules
type IPFirewallRuleInfoListResult struct {
	// Link to next page of results
	NextLink *string `json:"nextLink,omitempty"`

	// List of IP firewall rules
	Value []*IPFirewallRuleInfo `json:"value,omitempty"`
}

// IPFirewallRuleProperties - IP firewall rule properties
type IPFirewallRuleProperties struct {
	// The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress
	EndIPAddress *string `json:"endIpAddress,omitempty"`

	// The start IP address of the firewall rule. Must be IPv4 format
	StartIPAddress *string `json:"startIpAddress,omitempty"`

	// READ-ONLY; Resource provisioning state
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// IPFirewallRulesClientBeginCreateOrUpdateOptions contains the optional parameters for the IPFirewallRulesClient.BeginCreateOrUpdate
// method.
type IPFirewallRulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IPFirewallRulesClientBeginDeleteOptions contains the optional parameters for the IPFirewallRulesClient.BeginDelete method.
type IPFirewallRulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IPFirewallRulesClientBeginReplaceAllOptions contains the optional parameters for the IPFirewallRulesClient.BeginReplaceAll
// method.
type IPFirewallRulesClientBeginReplaceAllOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IPFirewallRulesClientGetOptions contains the optional parameters for the IPFirewallRulesClient.Get method.
type IPFirewallRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// IPFirewallRulesClientListByWorkspaceOptions contains the optional parameters for the IPFirewallRulesClient.ListByWorkspace
// method.
type IPFirewallRulesClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimeClassification provides polymorphic access to related types.
// Call the interface's GetIntegrationRuntime() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *IntegrationRuntime, *ManagedIntegrationRuntime, *SelfHostedIntegrationRuntime
type IntegrationRuntimeClassification interface {
	// GetIntegrationRuntime returns the IntegrationRuntime content of the underlying type.
	GetIntegrationRuntime() *IntegrationRuntime
}

// IntegrationRuntime - Azure Synapse nested object which serves as a compute resource for activities.
type IntegrationRuntime struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Integration runtime description.
	Description *string `json:"description,omitempty"`
}

// GetIntegrationRuntime implements the IntegrationRuntimeClassification interface for type IntegrationRuntime.
func (i *IntegrationRuntime) GetIntegrationRuntime() *IntegrationRuntime { return i }

// IntegrationRuntimeAuthKeys - The integration runtime authentication keys.
type IntegrationRuntimeAuthKeys struct {
	// The primary integration runtime authentication key.
	AuthKey1 *string `json:"authKey1,omitempty"`

	// The secondary integration runtime authentication key.
	AuthKey2 *string `json:"authKey2,omitempty"`
}

// IntegrationRuntimeAuthKeysClientListOptions contains the optional parameters for the IntegrationRuntimeAuthKeysClient.List
// method.
type IntegrationRuntimeAuthKeysClientListOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimeAuthKeysClientRegenerateOptions contains the optional parameters for the IntegrationRuntimeAuthKeysClient.Regenerate
// method.
type IntegrationRuntimeAuthKeysClientRegenerateOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimeComputeProperties - The compute resource properties for managed integration runtime.
type IntegrationRuntimeComputeProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Data flow properties for managed integration runtime.
	DataFlowProperties *IntegrationRuntimeDataFlowProperties `json:"dataFlowProperties,omitempty"`

	// The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
	Location *string `json:"location,omitempty"`

	// Maximum parallel executions count per node for managed integration runtime.
	MaxParallelExecutionsPerNode *int32 `json:"maxParallelExecutionsPerNode,omitempty"`

	// The node size requirement to managed integration runtime.
	NodeSize *string `json:"nodeSize,omitempty"`

	// The required number of nodes for managed integration runtime.
	NumberOfNodes *int32 `json:"numberOfNodes,omitempty"`

	// VNet properties for managed integration runtime.
	VNetProperties *IntegrationRuntimeVNetProperties `json:"vNetProperties,omitempty"`
}

// IntegrationRuntimeConnectionInfo - Connection information for encrypting the on-premises data source credentials.
type IntegrationRuntimeConnectionInfo struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; The on-premises integration runtime host URL.
	HostServiceURI *string `json:"hostServiceUri,omitempty" azure:"ro"`

	// READ-ONLY; The integration runtime SSL certificate thumbprint. Click-Once application uses it to do server validation.
	IdentityCertThumbprint *string `json:"identityCertThumbprint,omitempty" azure:"ro"`

	// READ-ONLY; Whether the identity certificate is expired.
	IsIdentityCertExprired *bool `json:"isIdentityCertExprired,omitempty" azure:"ro"`

	// READ-ONLY; The public key for encrypting a credential when transferring the credential to the integration runtime.
	PublicKey *string `json:"publicKey,omitempty" azure:"ro"`

	// READ-ONLY; The token generated in service. Callers use this token to authenticate to integration runtime.
	ServiceToken *string `json:"serviceToken,omitempty" azure:"ro"`

	// READ-ONLY; The integration runtime version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// IntegrationRuntimeConnectionInfosClientGetOptions contains the optional parameters for the IntegrationRuntimeConnectionInfosClient.Get
// method.
type IntegrationRuntimeConnectionInfosClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimeCredentialsClientSyncOptions contains the optional parameters for the IntegrationRuntimeCredentialsClient.Sync
// method.
type IntegrationRuntimeCredentialsClientSyncOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimeCustomSetupScriptProperties - Custom setup script properties for a managed dedicated integration runtime.
type IntegrationRuntimeCustomSetupScriptProperties struct {
	// The URI of the Azure blob container that contains the custom setup script.
	BlobContainerURI *string `json:"blobContainerUri,omitempty"`

	// The SAS token of the Azure blob container.
	SasToken *SecureString `json:"sasToken,omitempty"`
}

// IntegrationRuntimeDataFlowProperties - Data flow properties for managed integration runtime.
type IntegrationRuntimeDataFlowProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Cluster will not be recycled and it will be used in next data flow activity run until TTL (time to live) is reached if
	// this is set as false. Default is true.
	Cleanup *bool `json:"cleanup,omitempty"`

	// Compute type of the cluster which will execute data flow job.
	ComputeType *DataFlowComputeType `json:"computeType,omitempty"`

	// Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
	CoreCount *int32 `json:"coreCount,omitempty"`

	// Time to live (in minutes) setting of the cluster which will execute data flow job.
	TimeToLive *int32 `json:"timeToLive,omitempty"`
}

// IntegrationRuntimeDataProxyProperties - Data proxy properties for a managed dedicated integration runtime.
type IntegrationRuntimeDataProxyProperties struct {
	// The self-hosted integration runtime reference.
	ConnectVia *EntityReference `json:"connectVia,omitempty"`

	// The path to contain the staged data in the Blob storage.
	Path *string `json:"path,omitempty"`

	// The staging linked service reference.
	StagingLinkedService *EntityReference `json:"stagingLinkedService,omitempty"`
}

// IntegrationRuntimeListResponse - A list of integration runtime resources.
type IntegrationRuntimeListResponse struct {
	// REQUIRED; List of integration runtimes.
	Value []*IntegrationRuntimeResource `json:"value,omitempty"`

	// The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationRuntimeMonitoringData - Get monitoring data response.
type IntegrationRuntimeMonitoringData struct {
	// Integration runtime name.
	Name *string `json:"name,omitempty"`

	// Integration runtime node monitoring data.
	Nodes []*IntegrationRuntimeNodeMonitoringData `json:"nodes,omitempty"`
}

// IntegrationRuntimeMonitoringDataClientListOptions contains the optional parameters for the IntegrationRuntimeMonitoringDataClient.List
// method.
type IntegrationRuntimeMonitoringDataClientListOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimeNodeIPAddress - The IP address of self-hosted integration runtime node.
type IntegrationRuntimeNodeIPAddress struct {
	// READ-ONLY; The IP address of self-hosted integration runtime node.
	IPAddress *string `json:"ipAddress,omitempty" azure:"ro"`
}

// IntegrationRuntimeNodeIPAddressClientGetOptions contains the optional parameters for the IntegrationRuntimeNodeIPAddressClient.Get
// method.
type IntegrationRuntimeNodeIPAddressClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimeNodeMonitoringData - Monitoring data for integration runtime node.
type IntegrationRuntimeNodeMonitoringData struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; Available memory (MB) on the integration runtime node.
	AvailableMemoryInMB *int32 `json:"availableMemoryInMB,omitempty" azure:"ro"`

	// READ-ONLY; CPU percentage on the integration runtime node.
	CPUUtilization *int32 `json:"cpuUtilization,omitempty" azure:"ro"`

	// READ-ONLY; Maximum concurrent jobs on the integration runtime node.
	ConcurrentJobsLimit *int32 `json:"concurrentJobsLimit,omitempty" azure:"ro"`

	// READ-ONLY; The number of jobs currently running on the integration runtime node.
	ConcurrentJobsRunning *int32 `json:"concurrentJobsRunning,omitempty" azure:"ro"`

	// READ-ONLY; The maximum concurrent jobs in this integration runtime.
	MaxConcurrentJobs *int32 `json:"maxConcurrentJobs,omitempty" azure:"ro"`

	// READ-ONLY; Name of the integration runtime node.
	NodeName *string `json:"nodeName,omitempty" azure:"ro"`

	// READ-ONLY; Received bytes on the integration runtime node.
	ReceivedBytes *float32 `json:"receivedBytes,omitempty" azure:"ro"`

	// READ-ONLY; Sent bytes on the integration runtime node.
	SentBytes *float32 `json:"sentBytes,omitempty" azure:"ro"`
}

// IntegrationRuntimeNodesClientDeleteOptions contains the optional parameters for the IntegrationRuntimeNodesClient.Delete
// method.
type IntegrationRuntimeNodesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimeNodesClientGetOptions contains the optional parameters for the IntegrationRuntimeNodesClient.Get method.
type IntegrationRuntimeNodesClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimeNodesClientUpdateOptions contains the optional parameters for the IntegrationRuntimeNodesClient.Update
// method.
type IntegrationRuntimeNodesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimeObjectMetadataClientBeginRefreshOptions contains the optional parameters for the IntegrationRuntimeObjectMetadataClient.BeginRefresh
// method.
type IntegrationRuntimeObjectMetadataClientBeginRefreshOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IntegrationRuntimeObjectMetadataClientListOptions contains the optional parameters for the IntegrationRuntimeObjectMetadataClient.List
// method.
type IntegrationRuntimeObjectMetadataClientListOptions struct {
	// The parameters for getting a SSIS object metadata.
	GetMetadataRequest *GetSsisObjectMetadataRequest
}

// IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint - Azure-SSIS integration runtime outbound network dependency
// endpoints for one category.
type IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint struct {
	// The category of outbound network dependency.
	Category *string `json:"category,omitempty"`

	// The endpoints for outbound network dependency.
	Endpoints []*IntegrationRuntimeOutboundNetworkDependenciesEndpoint `json:"endpoints,omitempty"`
}

// IntegrationRuntimeOutboundNetworkDependenciesEndpoint - The endpoint for Azure-SSIS integration runtime outbound network
// dependency.
type IntegrationRuntimeOutboundNetworkDependenciesEndpoint struct {
	// The domain name of endpoint.
	DomainName *string `json:"domainName,omitempty"`

	// The details of endpoint.
	EndpointDetails []*IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails `json:"endpointDetails,omitempty"`
}

// IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails - The details of Azure-SSIS integration runtime outbound network
// dependency endpoint.
type IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails struct {
	// The port of endpoint.
	Port *int32 `json:"port,omitempty"`
}

// IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse - Azure-SSIS integration runtime outbound network dependency
// endpoints.
type IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse struct {
	// The list of outbound network dependency endpoints.
	Value []*IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint `json:"value,omitempty"`
}

// IntegrationRuntimeRegenerateKeyParameters - Parameters to regenerate the authentication key.
type IntegrationRuntimeRegenerateKeyParameters struct {
	// The name of the authentication key to regenerate.
	KeyName *IntegrationRuntimeAuthKeyName `json:"keyName,omitempty"`
}

// IntegrationRuntimeResource - Integration runtime resource type.
type IntegrationRuntimeResource struct {
	// REQUIRED; Integration runtime properties.
	Properties IntegrationRuntimeClassification `json:"properties,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IntegrationRuntimeSsisCatalogInfo - Catalog information for managed dedicated integration runtime.
type IntegrationRuntimeSsisCatalogInfo struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The password of the administrator user account of the catalog database.
	CatalogAdminPassword *SecureString `json:"catalogAdminPassword,omitempty"`

	// The administrator user name of catalog database.
	CatalogAdminUserName *string `json:"catalogAdminUserName,omitempty"`

	// The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
	CatalogPricingTier *IntegrationRuntimeSsisCatalogPricingTier `json:"catalogPricingTier,omitempty"`

	// The catalog database server URL.
	CatalogServerEndpoint *string `json:"catalogServerEndpoint,omitempty"`
}

// IntegrationRuntimeSsisProperties - SSIS properties for managed integration runtime.
type IntegrationRuntimeSsisProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Catalog information for managed dedicated integration runtime.
	CatalogInfo *IntegrationRuntimeSsisCatalogInfo `json:"catalogInfo,omitempty"`

	// Custom setup script properties for a managed dedicated integration runtime.
	CustomSetupScriptProperties *IntegrationRuntimeCustomSetupScriptProperties `json:"customSetupScriptProperties,omitempty"`

	// Data proxy properties for a managed dedicated integration runtime.
	DataProxyProperties *IntegrationRuntimeDataProxyProperties `json:"dataProxyProperties,omitempty"`

	// The edition for the SSIS Integration Runtime
	Edition *IntegrationRuntimeEdition `json:"edition,omitempty"`

	// Custom setup without script properties for a SSIS integration runtime.
	ExpressCustomSetupProperties []CustomSetupBaseClassification `json:"expressCustomSetupProperties,omitempty"`

	// License type for bringing your own license scenario.
	LicenseType *IntegrationRuntimeLicenseType `json:"licenseType,omitempty"`
}

// IntegrationRuntimeStatusClassification provides polymorphic access to related types.
// Call the interface's GetIntegrationRuntimeStatus() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *IntegrationRuntimeStatus, *ManagedIntegrationRuntimeStatus, *SelfHostedIntegrationRuntimeStatus
type IntegrationRuntimeStatusClassification interface {
	// GetIntegrationRuntimeStatus returns the IntegrationRuntimeStatus content of the underlying type.
	GetIntegrationRuntimeStatus() *IntegrationRuntimeStatus
}

// IntegrationRuntimeStatus - Integration runtime status.
type IntegrationRuntimeStatus struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; The workspace name which the integration runtime belong to.
	DataFactoryName *string `json:"dataFactoryName,omitempty" azure:"ro"`

	// READ-ONLY; The state of integration runtime.
	State *IntegrationRuntimeState `json:"state,omitempty" azure:"ro"`
}

// GetIntegrationRuntimeStatus implements the IntegrationRuntimeStatusClassification interface for type IntegrationRuntimeStatus.
func (i *IntegrationRuntimeStatus) GetIntegrationRuntimeStatus() *IntegrationRuntimeStatus { return i }

// IntegrationRuntimeStatusClientGetOptions contains the optional parameters for the IntegrationRuntimeStatusClient.Get method.
type IntegrationRuntimeStatusClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimeStatusResponse - Integration runtime status response.
type IntegrationRuntimeStatusResponse struct {
	// REQUIRED; Integration runtime properties.
	Properties IntegrationRuntimeStatusClassification `json:"properties,omitempty"`

	// READ-ONLY; The integration runtime name.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// IntegrationRuntimeVNetProperties - VNet properties for managed integration runtime.
type IntegrationRuntimeVNetProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Resource IDs of the public IP addresses that this integration runtime will use.
	PublicIPs []*string `json:"publicIPs,omitempty"`

	// The name of the subnet this integration runtime will join.
	Subnet *string `json:"subnet,omitempty"`

	// The ID of subnet, to which this Azure-SSIS integration runtime will be joined.
	SubnetID *string `json:"subnetId,omitempty"`

	// The ID of the VNet that this integration runtime will join.
	VNetID *string `json:"vNetId,omitempty"`
}

// IntegrationRuntimesClientBeginCreateOptions contains the optional parameters for the IntegrationRuntimesClient.BeginCreate
// method.
type IntegrationRuntimesClientBeginCreateOptions struct {
	// ETag of the integration runtime entity. Should only be specified for update, for which it should match existing entity
	// or can be * for unconditional update.
	IfMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IntegrationRuntimesClientBeginDeleteOptions contains the optional parameters for the IntegrationRuntimesClient.BeginDelete
// method.
type IntegrationRuntimesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IntegrationRuntimesClientBeginDisableInteractiveQueryOptions contains the optional parameters for the IntegrationRuntimesClient.BeginDisableInteractiveQuery
// method.
type IntegrationRuntimesClientBeginDisableInteractiveQueryOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IntegrationRuntimesClientBeginEnableInteractiveQueryOptions contains the optional parameters for the IntegrationRuntimesClient.BeginEnableInteractiveQuery
// method.
type IntegrationRuntimesClientBeginEnableInteractiveQueryOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IntegrationRuntimesClientBeginStartOptions contains the optional parameters for the IntegrationRuntimesClient.BeginStart
// method.
type IntegrationRuntimesClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IntegrationRuntimesClientBeginStopOptions contains the optional parameters for the IntegrationRuntimesClient.BeginStop
// method.
type IntegrationRuntimesClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IntegrationRuntimesClientGetOptions contains the optional parameters for the IntegrationRuntimesClient.Get method.
type IntegrationRuntimesClientGetOptions struct {
	// ETag of the integration runtime entity. Should only be specified for get. If the ETag matches the existing entity tag,
	// or if * was provided, then no content will be returned.
	IfNoneMatch *string
}

// IntegrationRuntimesClientListByWorkspaceOptions contains the optional parameters for the IntegrationRuntimesClient.ListByWorkspace
// method.
type IntegrationRuntimesClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimesClientListOutboundNetworkDependenciesEndpointsOptions contains the optional parameters for the IntegrationRuntimesClient.ListOutboundNetworkDependenciesEndpoints
// method.
type IntegrationRuntimesClientListOutboundNetworkDependenciesEndpointsOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimesClientUpdateOptions contains the optional parameters for the IntegrationRuntimesClient.Update method.
type IntegrationRuntimesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimesClientUpgradeOptions contains the optional parameters for the IntegrationRuntimesClient.Upgrade method.
type IntegrationRuntimesClientUpgradeOptions struct {
	// placeholder for future optional parameters
}

// IotHubConnectionProperties - Class representing the Kusto Iot hub connection properties.
type IotHubConnectionProperties struct {
	// REQUIRED; The iot hub consumer group.
	ConsumerGroup *string `json:"consumerGroup,omitempty"`

	// REQUIRED; The resource ID of the Iot hub to be used to create a data connection.
	IotHubResourceID *string `json:"iotHubResourceId,omitempty"`

	// REQUIRED; The name of the share access policy
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`

	// The data format of the message. Optionally the data format can be added to each message.
	DataFormat *IotHubDataFormat `json:"dataFormat,omitempty"`

	// System properties of the iot hub
	EventSystemProperties []*string `json:"eventSystemProperties,omitempty"`

	// The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string `json:"mappingRuleName,omitempty"`

	// The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string `json:"tableName,omitempty"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// IotHubDataConnection - Class representing an iot hub data connection.
type IotHubDataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind `json:"kind,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// The Iot Hub data connection properties.
	Properties *IotHubConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataConnection implements the DataConnectionClassification interface for type IotHubDataConnection.
func (i *IotHubDataConnection) GetDataConnection() *DataConnection {
	return &DataConnection{
		Location:   i.Location,
		Kind:       i.Kind,
		SystemData: i.SystemData,
		ID:         i.ID,
		Name:       i.Name,
		Type:       i.Type,
	}
}

// KekIdentityProperties - Key encryption key properties
type KekIdentityProperties struct {
	// Boolean specifying whether to use system assigned identity or not
	UseSystemAssignedIdentity interface{} `json:"useSystemAssignedIdentity,omitempty"`

	// User assigned identity resource Id
	UserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`
}

// Key - A workspace key
type Key struct {
	// Keys resource properties
	Properties *KeyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// KeyInfoListResult - List of keys
type KeyInfoListResult struct {
	// Link to the next page of results
	NextLink *string `json:"nextLink,omitempty"`

	// List of keys
	Value []*Key `json:"value,omitempty"`
}

// KeyProperties - Key properties
type KeyProperties struct {
	// Used to activate the workspace after a customer managed key is provided.
	IsActiveCMK *bool `json:"isActiveCMK,omitempty"`

	// The Key Vault Url of the workspace key.
	KeyVaultURL *string `json:"keyVaultUrl,omitempty"`
}

// KeysClientCreateOrUpdateOptions contains the optional parameters for the KeysClient.CreateOrUpdate method.
type KeysClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// KeysClientDeleteOptions contains the optional parameters for the KeysClient.Delete method.
type KeysClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// KeysClientGetOptions contains the optional parameters for the KeysClient.Get method.
type KeysClientGetOptions struct {
	// placeholder for future optional parameters
}

// KeysClientListByWorkspaceOptions contains the optional parameters for the KeysClient.ListByWorkspace method.
type KeysClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// KustoOperationsClientListOptions contains the optional parameters for the KustoOperationsClient.List method.
type KustoOperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// KustoPool - Class representing a Kusto kusto pool.
type KustoPool struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; The SKU of the kusto pool.
	SKU *AzureSKU `json:"sku,omitempty"`

	// The kusto pool properties.
	Properties *KustoPoolProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// KustoPoolAttachedDatabaseConfigurationsClientBeginCreateOrUpdateOptions contains the optional parameters for the KustoPoolAttachedDatabaseConfigurationsClient.BeginCreateOrUpdate
// method.
type KustoPoolAttachedDatabaseConfigurationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolAttachedDatabaseConfigurationsClientBeginDeleteOptions contains the optional parameters for the KustoPoolAttachedDatabaseConfigurationsClient.BeginDelete
// method.
type KustoPoolAttachedDatabaseConfigurationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolAttachedDatabaseConfigurationsClientGetOptions contains the optional parameters for the KustoPoolAttachedDatabaseConfigurationsClient.Get
// method.
type KustoPoolAttachedDatabaseConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolAttachedDatabaseConfigurationsClientListByKustoPoolOptions contains the optional parameters for the KustoPoolAttachedDatabaseConfigurationsClient.ListByKustoPool
// method.
type KustoPoolAttachedDatabaseConfigurationsClientListByKustoPoolOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolCheckNameRequest - The object sent for a kusto pool check name availability request.
type KustoPoolCheckNameRequest struct {
	// REQUIRED; Kusto Pool name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The type of resource, Microsoft.Synapse/workspaces/kustoPools.
	Type *string `json:"type,omitempty"`
}

// KustoPoolChildResourceClientCheckNameAvailabilityOptions contains the optional parameters for the KustoPoolChildResourceClient.CheckNameAvailability
// method.
type KustoPoolChildResourceClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolDataConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the KustoPoolDataConnectionsClient.BeginCreateOrUpdate
// method.
type KustoPoolDataConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolDataConnectionsClientBeginDataConnectionValidationOptions contains the optional parameters for the KustoPoolDataConnectionsClient.BeginDataConnectionValidation
// method.
type KustoPoolDataConnectionsClientBeginDataConnectionValidationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolDataConnectionsClientBeginDeleteOptions contains the optional parameters for the KustoPoolDataConnectionsClient.BeginDelete
// method.
type KustoPoolDataConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolDataConnectionsClientBeginUpdateOptions contains the optional parameters for the KustoPoolDataConnectionsClient.BeginUpdate
// method.
type KustoPoolDataConnectionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolDataConnectionsClientCheckNameAvailabilityOptions contains the optional parameters for the KustoPoolDataConnectionsClient.CheckNameAvailability
// method.
type KustoPoolDataConnectionsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolDataConnectionsClientGetOptions contains the optional parameters for the KustoPoolDataConnectionsClient.Get method.
type KustoPoolDataConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolDataConnectionsClientListByDatabaseOptions contains the optional parameters for the KustoPoolDataConnectionsClient.ListByDatabase
// method.
type KustoPoolDataConnectionsClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolDatabasePrincipalAssignmentsClientBeginCreateOrUpdateOptions contains the optional parameters for the KustoPoolDatabasePrincipalAssignmentsClient.BeginCreateOrUpdate
// method.
type KustoPoolDatabasePrincipalAssignmentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolDatabasePrincipalAssignmentsClientBeginDeleteOptions contains the optional parameters for the KustoPoolDatabasePrincipalAssignmentsClient.BeginDelete
// method.
type KustoPoolDatabasePrincipalAssignmentsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolDatabasePrincipalAssignmentsClientCheckNameAvailabilityOptions contains the optional parameters for the KustoPoolDatabasePrincipalAssignmentsClient.CheckNameAvailability
// method.
type KustoPoolDatabasePrincipalAssignmentsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolDatabasePrincipalAssignmentsClientGetOptions contains the optional parameters for the KustoPoolDatabasePrincipalAssignmentsClient.Get
// method.
type KustoPoolDatabasePrincipalAssignmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolDatabasePrincipalAssignmentsClientListOptions contains the optional parameters for the KustoPoolDatabasePrincipalAssignmentsClient.List
// method.
type KustoPoolDatabasePrincipalAssignmentsClientListOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolDatabasesClientBeginCreateOrUpdateOptions contains the optional parameters for the KustoPoolDatabasesClient.BeginCreateOrUpdate
// method.
type KustoPoolDatabasesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolDatabasesClientBeginDeleteOptions contains the optional parameters for the KustoPoolDatabasesClient.BeginDelete
// method.
type KustoPoolDatabasesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolDatabasesClientBeginUpdateOptions contains the optional parameters for the KustoPoolDatabasesClient.BeginUpdate
// method.
type KustoPoolDatabasesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolDatabasesClientGetOptions contains the optional parameters for the KustoPoolDatabasesClient.Get method.
type KustoPoolDatabasesClientGetOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolDatabasesClientListByKustoPoolOptions contains the optional parameters for the KustoPoolDatabasesClient.ListByKustoPool
// method.
type KustoPoolDatabasesClientListByKustoPoolOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolListResult - The list Kusto pools operation response.
type KustoPoolListResult struct {
	// The list of Kusto pools.
	Value []*KustoPool `json:"value,omitempty"`
}

// KustoPoolPrincipalAssignmentsClientBeginCreateOrUpdateOptions contains the optional parameters for the KustoPoolPrincipalAssignmentsClient.BeginCreateOrUpdate
// method.
type KustoPoolPrincipalAssignmentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolPrincipalAssignmentsClientBeginDeleteOptions contains the optional parameters for the KustoPoolPrincipalAssignmentsClient.BeginDelete
// method.
type KustoPoolPrincipalAssignmentsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolPrincipalAssignmentsClientCheckNameAvailabilityOptions contains the optional parameters for the KustoPoolPrincipalAssignmentsClient.CheckNameAvailability
// method.
type KustoPoolPrincipalAssignmentsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolPrincipalAssignmentsClientGetOptions contains the optional parameters for the KustoPoolPrincipalAssignmentsClient.Get
// method.
type KustoPoolPrincipalAssignmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolPrincipalAssignmentsClientListOptions contains the optional parameters for the KustoPoolPrincipalAssignmentsClient.List
// method.
type KustoPoolPrincipalAssignmentsClientListOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolProperties - Class representing the Kusto pool properties.
type KustoPoolProperties struct {
	// A boolean value that indicates if the purge operations are enabled.
	EnablePurge *bool `json:"enablePurge,omitempty"`

	// A boolean value that indicates if the streaming ingest is enabled.
	EnableStreamingIngest *bool `json:"enableStreamingIngest,omitempty"`

	// Optimized auto scale definition.
	OptimizedAutoscale *OptimizedAutoscale `json:"optimizedAutoscale,omitempty"`

	// The workspace unique identifier.
	WorkspaceUID *string `json:"workspaceUID,omitempty"`

	// READ-ONLY; The Kusto Pool data ingestion URI.
	DataIngestionURI *string `json:"dataIngestionUri,omitempty" azure:"ro"`

	// READ-ONLY; List of the Kusto Pool's language extensions.
	LanguageExtensions *LanguageExtensionsList `json:"languageExtensions,omitempty" azure:"ro"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The state of the resource.
	State *State `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; The reason for the Kusto Pool's current state.
	StateReason *string `json:"stateReason,omitempty" azure:"ro"`

	// READ-ONLY; The Kusto Pool URI.
	URI *string `json:"uri,omitempty" azure:"ro"`
}

// KustoPoolUpdate - Class representing an update to a Kusto kusto pool.
type KustoPoolUpdate struct {
	// The kusto pool properties.
	Properties *KustoPoolProperties `json:"properties,omitempty"`

	// The SKU of the kusto pool.
	SKU *AzureSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// KustoPoolsClientBeginAddLanguageExtensionsOptions contains the optional parameters for the KustoPoolsClient.BeginAddLanguageExtensions
// method.
type KustoPoolsClientBeginAddLanguageExtensionsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolsClientBeginCreateOrUpdateOptions contains the optional parameters for the KustoPoolsClient.BeginCreateOrUpdate
// method.
type KustoPoolsClientBeginCreateOrUpdateOptions struct {
	// The ETag of the Kusto Pool. Omit this value to always overwrite the current Kusto Pool. Specify the last-seen ETag value
	// to prevent accidentally overwriting concurrent changes.
	IfMatch *string
	// Set to '*' to allow a new Kusto Pool to be created, but to prevent updating an existing Kusto Pool. Other values will result
	// in a 412 Pre-condition Failed response.
	IfNoneMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolsClientBeginDeleteOptions contains the optional parameters for the KustoPoolsClient.BeginDelete method.
type KustoPoolsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolsClientBeginDetachFollowerDatabasesOptions contains the optional parameters for the KustoPoolsClient.BeginDetachFollowerDatabases
// method.
type KustoPoolsClientBeginDetachFollowerDatabasesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolsClientBeginRemoveLanguageExtensionsOptions contains the optional parameters for the KustoPoolsClient.BeginRemoveLanguageExtensions
// method.
type KustoPoolsClientBeginRemoveLanguageExtensionsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolsClientBeginStartOptions contains the optional parameters for the KustoPoolsClient.BeginStart method.
type KustoPoolsClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolsClientBeginStopOptions contains the optional parameters for the KustoPoolsClient.BeginStop method.
type KustoPoolsClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolsClientBeginUpdateOptions contains the optional parameters for the KustoPoolsClient.BeginUpdate method.
type KustoPoolsClientBeginUpdateOptions struct {
	// The ETag of the Kusto Pool. Omit this value to always overwrite the current Kusto Pool. Specify the last-seen ETag value
	// to prevent accidentally overwriting concurrent changes.
	IfMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KustoPoolsClientCheckNameAvailabilityOptions contains the optional parameters for the KustoPoolsClient.CheckNameAvailability
// method.
type KustoPoolsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolsClientGetOptions contains the optional parameters for the KustoPoolsClient.Get method.
type KustoPoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolsClientListByWorkspaceOptions contains the optional parameters for the KustoPoolsClient.ListByWorkspace method.
type KustoPoolsClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolsClientListFollowerDatabasesOptions contains the optional parameters for the KustoPoolsClient.ListFollowerDatabases
// method.
type KustoPoolsClientListFollowerDatabasesOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolsClientListLanguageExtensionsOptions contains the optional parameters for the KustoPoolsClient.ListLanguageExtensions
// method.
type KustoPoolsClientListLanguageExtensionsOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolsClientListSKUsByResourceOptions contains the optional parameters for the KustoPoolsClient.ListSKUsByResource
// method.
type KustoPoolsClientListSKUsByResourceOptions struct {
	// placeholder for future optional parameters
}

// KustoPoolsClientListSKUsOptions contains the optional parameters for the KustoPoolsClient.ListSKUs method.
type KustoPoolsClientListSKUsOptions struct {
	// placeholder for future optional parameters
}

// LanguageExtension - The language extension object.
type LanguageExtension struct {
	// The language extension name.
	LanguageExtensionName *LanguageExtensionName `json:"languageExtensionName,omitempty"`
}

// LanguageExtensionsList - The list of language extension objects.
type LanguageExtensionsList struct {
	// The list of language extensions.
	Value []*LanguageExtension `json:"value,omitempty"`
}

// LibrariesClientListByWorkspaceOptions contains the optional parameters for the LibrariesClient.ListByWorkspace method.
type LibrariesClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// LibraryClientGetOptions contains the optional parameters for the LibraryClient.Get method.
type LibraryClientGetOptions struct {
	// placeholder for future optional parameters
}

// LibraryInfo - Library/package information of a Big Data pool powered by Apache Spark
type LibraryInfo struct {
	// Storage blob container name.
	ContainerName *string `json:"containerName,omitempty"`

	// Name of the library.
	Name *string `json:"name,omitempty"`

	// Storage blob path of library.
	Path *string `json:"path,omitempty"`

	// Type of the library.
	Type *string `json:"type,omitempty"`

	// The last update time of the library.
	UploadedTimestamp *time.Time `json:"uploadedTimestamp,omitempty"`

	// READ-ONLY; Creator Id of the library/package.
	CreatorID *string `json:"creatorId,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status of the library/package.
	ProvisioningStatus *string `json:"provisioningStatus,omitempty" azure:"ro"`
}

// LibraryListResponse - A list of Library resources.
type LibraryListResponse struct {
	// REQUIRED; List of Library.
	Value []*LibraryResource `json:"value,omitempty"`

	// The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// LibraryRequirements - Library requirements for a Big Data pool powered by Apache Spark
type LibraryRequirements struct {
	// The library requirements.
	Content *string `json:"content,omitempty"`

	// The filename of the library requirements file.
	Filename *string `json:"filename,omitempty"`

	// READ-ONLY; The last update time of the library requirements file.
	Time *time.Time `json:"time,omitempty" azure:"ro"`
}

// LibraryResource - Library response details
type LibraryResource struct {
	// REQUIRED; Library/package properties.
	Properties *LibraryInfo `json:"properties,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LicensedComponentSetupTypeProperties - Installation of licensed component setup type properties.
type LicensedComponentSetupTypeProperties struct {
	// REQUIRED; The name of the 3rd party component.
	ComponentName *string `json:"componentName,omitempty"`

	// The license key to activate the component.
	LicenseKey SecretBaseClassification `json:"licenseKey,omitempty"`
}

// LinkedIntegrationRuntime - The linked integration runtime information.
type LinkedIntegrationRuntime struct {
	// READ-ONLY; The creating time of the linked integration runtime.
	CreateTime *time.Time `json:"createTime,omitempty" azure:"ro"`

	// READ-ONLY; The location of the workspace for which the linked integration runtime belong to.
	DataFactoryLocation *string `json:"dataFactoryLocation,omitempty" azure:"ro"`

	// READ-ONLY; The name of the workspace for which the linked integration runtime belong to.
	DataFactoryName *string `json:"dataFactoryName,omitempty" azure:"ro"`

	// READ-ONLY; The name of the linked integration runtime.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The subscription ID for which the linked integration runtime belong to.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`
}

// LinkedIntegrationRuntimeKeyAuthorization - The key authorization type integration runtime.
type LinkedIntegrationRuntimeKeyAuthorization struct {
	// REQUIRED; The authorization type for integration runtime sharing.
	AuthorizationType *string `json:"authorizationType,omitempty"`

	// REQUIRED; The key used for authorization.
	Key *SecureString `json:"key,omitempty"`
}

// GetLinkedIntegrationRuntimeType implements the LinkedIntegrationRuntimeTypeClassification interface for type LinkedIntegrationRuntimeKeyAuthorization.
func (l *LinkedIntegrationRuntimeKeyAuthorization) GetLinkedIntegrationRuntimeType() *LinkedIntegrationRuntimeType {
	return &LinkedIntegrationRuntimeType{
		AuthorizationType: l.AuthorizationType,
	}
}

// LinkedIntegrationRuntimeRbacAuthorization - The role based access control (RBAC) authorization type integration runtime.
type LinkedIntegrationRuntimeRbacAuthorization struct {
	// REQUIRED; The authorization type for integration runtime sharing.
	AuthorizationType *string `json:"authorizationType,omitempty"`

	// REQUIRED; The resource identifier of the integration runtime to be shared.
	ResourceID *string `json:"resourceId,omitempty"`
}

// GetLinkedIntegrationRuntimeType implements the LinkedIntegrationRuntimeTypeClassification interface for type LinkedIntegrationRuntimeRbacAuthorization.
func (l *LinkedIntegrationRuntimeRbacAuthorization) GetLinkedIntegrationRuntimeType() *LinkedIntegrationRuntimeType {
	return &LinkedIntegrationRuntimeType{
		AuthorizationType: l.AuthorizationType,
	}
}

// LinkedIntegrationRuntimeTypeClassification provides polymorphic access to related types.
// Call the interface's GetLinkedIntegrationRuntimeType() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *LinkedIntegrationRuntimeKeyAuthorization, *LinkedIntegrationRuntimeRbacAuthorization, *LinkedIntegrationRuntimeType
type LinkedIntegrationRuntimeTypeClassification interface {
	// GetLinkedIntegrationRuntimeType returns the LinkedIntegrationRuntimeType content of the underlying type.
	GetLinkedIntegrationRuntimeType() *LinkedIntegrationRuntimeType
}

// LinkedIntegrationRuntimeType - The base definition of a linked integration runtime.
type LinkedIntegrationRuntimeType struct {
	// REQUIRED; The authorization type for integration runtime sharing.
	AuthorizationType *string `json:"authorizationType,omitempty"`
}

// GetLinkedIntegrationRuntimeType implements the LinkedIntegrationRuntimeTypeClassification interface for type LinkedIntegrationRuntimeType.
func (l *LinkedIntegrationRuntimeType) GetLinkedIntegrationRuntimeType() *LinkedIntegrationRuntimeType {
	return l
}

// ListResourceSKUsResult - List of available SKUs for a Kusto Pool.
type ListResourceSKUsResult struct {
	// The collection of available SKUs for an existing resource.
	Value []*AzureResourceSKU `json:"value,omitempty"`
}

// ListSQLPoolSecurityAlertPolicies - A list of SQL pool security alert policies.
type ListSQLPoolSecurityAlertPolicies struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SQLPoolSecurityAlertPolicy `json:"value,omitempty" azure:"ro"`
}

// MaintenanceWindowOptions - Maintenance window options.
type MaintenanceWindowOptions struct {
	// Resource properties.
	Properties *MaintenanceWindowOptionsProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MaintenanceWindowOptionsProperties - Maintenance window options properties.
type MaintenanceWindowOptionsProperties struct {
	// Whether we allow multiple maintenance windows per cycle.
	AllowMultipleMaintenanceWindowsPerCycle *bool `json:"allowMultipleMaintenanceWindowsPerCycle,omitempty"`

	// Default duration for maintenance window.
	DefaultDurationInMinutes *int32 `json:"defaultDurationInMinutes,omitempty"`

	// Whether maintenance windows are enabled for the database.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// Available maintenance cycles e.g. {Saturday, 0, 4860}, {Wednesday, 0, 2460}.
	MaintenanceWindowCycles []*MaintenanceWindowTimeRange `json:"maintenanceWindowCycles,omitempty"`

	// Minimum number of maintenance windows cycles to be set on the database.
	MinCycles *int32 `json:"minCycles,omitempty"`

	// Minimum duration of maintenance window.
	MinDurationInMinutes *int32 `json:"minDurationInMinutes,omitempty"`

	// Time granularity in minutes for maintenance windows.
	TimeGranularityInMinutes *int32 `json:"timeGranularityInMinutes,omitempty"`
}

// MaintenanceWindowTimeRange - Maintenance window time range.
type MaintenanceWindowTimeRange struct {
	// Day of maintenance window.
	DayOfWeek *DayOfWeek `json:"dayOfWeek,omitempty"`

	// Duration of maintenance window in minutes.
	Duration *string `json:"duration,omitempty"`

	// Start time minutes offset from 12am.
	StartTime *string `json:"startTime,omitempty"`
}

// MaintenanceWindows - Maintenance windows.
type MaintenanceWindows struct {
	// Resource properties.
	Properties *MaintenanceWindowsProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MaintenanceWindowsProperties - Maintenance windows resource properties.
type MaintenanceWindowsProperties struct {
	TimeRanges []*MaintenanceWindowTimeRange `json:"timeRanges,omitempty"`
}

// ManagedIdentity - The workspace managed identity
type ManagedIdentity struct {
	// The type of managed identity for the workspace
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The user assigned managed identities.
	UserAssignedIdentities map[string]*UserAssignedManagedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal ID of the workspace managed identity
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of the workspace managed identity
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ManagedIdentitySQLControlSettingsModel - Sql Control Settings for workspace managed identity
type ManagedIdentitySQLControlSettingsModel struct {
	// Sql Control Settings for workspace managed identity
	Properties *ManagedIdentitySQLControlSettingsModelProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedIdentitySQLControlSettingsModelProperties - Sql Control Settings for workspace managed identity
type ManagedIdentitySQLControlSettingsModelProperties struct {
	// Grant sql control to managed identity
	GrantSQLControlToManagedIdentity *ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity `json:"grantSqlControlToManagedIdentity,omitempty"`
}

// ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity - Grant sql control to managed identity
type ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity struct {
	// Desired state
	DesiredState *ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityDesiredState `json:"desiredState,omitempty"`

	// READ-ONLY; Actual state
	ActualState *ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualState `json:"actualState,omitempty" azure:"ro"`
}

// ManagedIntegrationRuntime - Managed integration runtime, including managed elastic and managed dedicated integration runtimes.
type ManagedIntegrationRuntime struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType `json:"type,omitempty"`

	// REQUIRED; Managed integration runtime properties.
	TypeProperties *ManagedIntegrationRuntimeTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Integration runtime description.
	Description *string `json:"description,omitempty"`

	// Managed integration runtime managed virtual network.
	ManagedVirtualNetwork *ManagedIntegrationRuntimeManagedVirtualNetworkReference `json:"managedVirtualNetwork,omitempty"`

	// READ-ONLY; Integration runtime state, only valid for managed dedicated integration runtime.
	State *IntegrationRuntimeState `json:"state,omitempty" azure:"ro"`
}

// GetIntegrationRuntime implements the IntegrationRuntimeClassification interface for type ManagedIntegrationRuntime.
func (m *ManagedIntegrationRuntime) GetIntegrationRuntime() *IntegrationRuntime {
	return &IntegrationRuntime{
		Type:                 m.Type,
		Description:          m.Description,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// ManagedIntegrationRuntimeError - Error definition for managed integration runtime.
type ManagedIntegrationRuntimeError struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; Error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Managed integration runtime error parameters.
	Parameters []*string `json:"parameters,omitempty" azure:"ro"`

	// READ-ONLY; The time when the error occurred.
	Time *time.Time `json:"time,omitempty" azure:"ro"`
}

// ManagedIntegrationRuntimeManagedVirtualNetworkReference - Managed integration runtime managed virtual network reference.
type ManagedIntegrationRuntimeManagedVirtualNetworkReference struct {
	// The id of the managed virtual network.
	ID *string `json:"id,omitempty"`

	// The reference name of the managed virtual network.
	ReferenceName *string `json:"referenceName,omitempty"`

	// The type of the managed virtual network.
	Type *string `json:"type,omitempty"`
}

// ManagedIntegrationRuntimeNode - Properties of integration runtime node.
type ManagedIntegrationRuntimeNode struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The errors that occurred on this integration runtime node.
	Errors []*ManagedIntegrationRuntimeError `json:"errors,omitempty"`

	// READ-ONLY; The managed integration runtime node id.
	NodeID *string `json:"nodeId,omitempty" azure:"ro"`

	// READ-ONLY; The managed integration runtime node status.
	Status *ManagedIntegrationRuntimeNodeStatus `json:"status,omitempty" azure:"ro"`
}

// ManagedIntegrationRuntimeOperationResult - Properties of managed integration runtime operation result.
type ManagedIntegrationRuntimeOperationResult struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; The activity id for the operation request.
	ActivityID *string `json:"activityId,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	ErrorCode *string `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; Managed integration runtime error parameters.
	Parameters []*string `json:"parameters,omitempty" azure:"ro"`

	// READ-ONLY; The operation result.
	Result *string `json:"result,omitempty" azure:"ro"`

	// READ-ONLY; The start time of the operation.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The operation type. Could be start or stop.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedIntegrationRuntimeStatus - Managed integration runtime status.
type ManagedIntegrationRuntimeStatus struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType `json:"type,omitempty"`

	// REQUIRED; Managed integration runtime status type properties.
	TypeProperties *ManagedIntegrationRuntimeStatusTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; The workspace name which the integration runtime belong to.
	DataFactoryName *string `json:"dataFactoryName,omitempty" azure:"ro"`

	// READ-ONLY; The state of integration runtime.
	State *IntegrationRuntimeState `json:"state,omitempty" azure:"ro"`
}

// GetIntegrationRuntimeStatus implements the IntegrationRuntimeStatusClassification interface for type ManagedIntegrationRuntimeStatus.
func (m *ManagedIntegrationRuntimeStatus) GetIntegrationRuntimeStatus() *IntegrationRuntimeStatus {
	return &IntegrationRuntimeStatus{
		Type:                 m.Type,
		DataFactoryName:      m.DataFactoryName,
		State:                m.State,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// ManagedIntegrationRuntimeStatusTypeProperties - Managed integration runtime status type properties.
type ManagedIntegrationRuntimeStatusTypeProperties struct {
	// READ-ONLY; The time at which the integration runtime was created, in ISO8601 format.
	CreateTime *time.Time `json:"createTime,omitempty" azure:"ro"`

	// READ-ONLY; The last operation result that occurred on this integration runtime.
	LastOperation *ManagedIntegrationRuntimeOperationResult `json:"lastOperation,omitempty" azure:"ro"`

	// READ-ONLY; The list of nodes for managed integration runtime.
	Nodes []*ManagedIntegrationRuntimeNode `json:"nodes,omitempty" azure:"ro"`

	// READ-ONLY; The errors that occurred on this integration runtime.
	OtherErrors []*ManagedIntegrationRuntimeError `json:"otherErrors,omitempty" azure:"ro"`
}

// ManagedIntegrationRuntimeTypeProperties - Managed integration runtime type properties.
type ManagedIntegrationRuntimeTypeProperties struct {
	// The compute resource for managed integration runtime.
	ComputeProperties *IntegrationRuntimeComputeProperties `json:"computeProperties,omitempty"`

	// SSIS properties for managed integration runtime.
	SsisProperties *IntegrationRuntimeSsisProperties `json:"ssisProperties,omitempty"`
}

// ManagedVirtualNetworkSettings - Managed Virtual Network Settings
type ManagedVirtualNetworkSettings struct {
	// Allowed Aad Tenant Ids For Linking
	AllowedAADTenantIDsForLinking []*string `json:"allowedAadTenantIdsForLinking,omitempty"`

	// Linked Access Check On Target Resource
	LinkedAccessCheckOnTargetResource *bool `json:"linkedAccessCheckOnTargetResource,omitempty"`

	// Prevent Data Exfiltration
	PreventDataExfiltration *bool `json:"preventDataExfiltration,omitempty"`
}

// MetadataSyncConfig - Configuration for metadata sync
type MetadataSyncConfig struct {
	// Metadata Sync Config properties
	Properties *MetadataSyncConfigProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MetadataSyncConfigProperties - Metadata Sync Config properties
type MetadataSyncConfigProperties struct {
	// Indicates whether the metadata sync is enabled or disabled
	Enabled *bool `json:"enabled,omitempty"`

	// The Sync Interval in minutes.
	SyncIntervalInMinutes *int32 `json:"syncIntervalInMinutes,omitempty"`
}

// Operation - A REST API operation
type Operation struct {
	// The object that describes the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// This is of the format {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`

	// The intended executor of the operation.
	Origin *string `json:"origin,omitempty"`

	// Properties of the operation.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationDisplay - The object that describes the operation.
type OperationDisplay struct {
	// The friendly name of the operation.
	Description *string `json:"description,omitempty"`

	// For example: read, write, delete.
	Operation *string `json:"operation,omitempty"`

	// Friendly name of the resource provider.
	Provider *string `json:"provider,omitempty"`

	// The resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list REST API operations. It contains a list of operations and a URL nextLink
// to get the next set of results.
type OperationListResult struct {
	// The list of operations supported by the resource provider.
	Value []*Operation `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// OperationMetaLogSpecification - What is this?
type OperationMetaLogSpecification struct {
	// Time range the log covers
	BlobDuration *string `json:"blobDuration,omitempty"`

	// Log display name
	DisplayName *string `json:"displayName,omitempty"`

	// Log unique name
	Name *string `json:"name,omitempty"`
}

// OperationMetaMetricDimensionSpecification - What is this?
type OperationMetaMetricDimensionSpecification struct {
	// Dimension display name
	DisplayName *string `json:"displayName,omitempty"`

	// Dimension unique name
	Name *string `json:"name,omitempty"`

	// Whether this metric should be exported for Shoebox
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// OperationMetaMetricSpecification - What is this?
type OperationMetaMetricSpecification struct {
	// Metric aggregation type
	AggregationType *string `json:"aggregationType,omitempty"`

	// Metric dimensions
	Dimensions []*OperationMetaMetricDimensionSpecification `json:"dimensions,omitempty"`

	// Metric description
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Metric display name
	DisplayName *string `json:"displayName,omitempty"`

	// Whether the regional MDM account is enabled
	EnableRegionalMdmAccount *bool `json:"enableRegionalMdmAccount,omitempty"`

	// Metric filter
	MetricFilterPattern *string `json:"metricFilterPattern,omitempty"`

	// Metric unique name
	Name *string `json:"name,omitempty"`

	// The source MDM account
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty"`

	// The source MDM namespace
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`

	// Whether the metric supports instance-level aggregation
	SupportsInstanceLevelAggregation *bool `json:"supportsInstanceLevelAggregation,omitempty"`

	// Metric units
	Unit *string `json:"unit,omitempty"`
}

// OperationMetaPropertyInfo - What is this?
type OperationMetaPropertyInfo struct {
	// Operation service specification
	ServiceSpecification *OperationMetaServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationMetaServiceSpecification - What is this?
type OperationMetaServiceSpecification struct {
	// Service log specifications
	LogSpecifications []*OperationMetaLogSpecification `json:"logSpecifications,omitempty"`

	// Service metric specifications
	MetricSpecifications []*OperationMetaMetricSpecification `json:"metricSpecifications,omitempty"`
}

// OperationResource - An operation
type OperationResource struct {
	// Operation start time
	EndTime *time.Time `json:"endTime,omitempty"`

	// Errors from the operation
	Error *ErrorDetail `json:"error,omitempty"`

	// Operation ID
	ID *string `json:"id,omitempty"`

	// Operation name
	Name *string `json:"name,omitempty"`

	// Completion percentage of the operation
	PercentComplete *float32 `json:"percentComplete,omitempty"`

	// Operation properties
	Properties interface{} `json:"properties,omitempty"`

	// Operation start time
	StartTime *time.Time `json:"startTime,omitempty"`

	// Operation status
	Status *OperationStatus `json:"status,omitempty"`
}

// OperationsClientCheckNameAvailabilityOptions contains the optional parameters for the OperationsClient.CheckNameAvailability
// method.
type OperationsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// OperationsClientGetAzureAsyncHeaderResultOptions contains the optional parameters for the OperationsClient.GetAzureAsyncHeaderResult
// method.
type OperationsClientGetAzureAsyncHeaderResultOptions struct {
	// placeholder for future optional parameters
}

// OperationsClientGetLocationHeaderResultOptions contains the optional parameters for the OperationsClient.GetLocationHeaderResult
// method.
type OperationsClientGetLocationHeaderResultOptions struct {
	// placeholder for future optional parameters
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OptimizedAutoscale - A class that contains the optimized auto scale definition.
type OptimizedAutoscale struct {
	// REQUIRED; A boolean value that indicate if the optimized autoscale feature is enabled or not.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; Maximum allowed instances count.
	Maximum *int32 `json:"maximum,omitempty"`

	// REQUIRED; Minimum allowed instances count.
	Minimum *int32 `json:"minimum,omitempty"`

	// REQUIRED; The version of the template defined, for instance 1.
	Version *int32 `json:"version,omitempty"`
}

// PrivateEndpoint - Private endpoint details
type PrivateEndpoint struct {
	// READ-ONLY; Resource id of the private endpoint.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// Private endpoint connection properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type PrivateEndpointConnectionForPrivateLinkHub struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`

	// Properties of a private endpoint connection.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	Type       *string                              `json:"type,omitempty"`
}

// PrivateEndpointConnectionForPrivateLinkHubBasic - Private Endpoint Connection For Private Link Hub - Basic
type PrivateEndpointConnectionForPrivateLinkHubBasic struct {
	// Properties of private endpoint connection for private link hub
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; identifier
	ID *string `json:"id,omitempty" azure:"ro"`
}

type PrivateEndpointConnectionForPrivateLinkHubBasicAutoGenerated struct {
	ID *string `json:"id,omitempty"`

	// Properties of a private endpoint connection.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`
}

type PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse struct {
	NextLink *string                                       `json:"nextLink,omitempty"`
	Value    []*PrivateEndpointConnectionForPrivateLinkHub `json:"value,omitempty"`
}

// PrivateEndpointConnectionList - A list of private endpoint connections
type PrivateEndpointConnectionList struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*PrivateEndpointConnection `json:"value,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// The private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY; Provisioning state of the private endpoint connection.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginCreateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginCreate
// method.
type PrivateEndpointConnectionsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.List
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsPrivateLinkHubClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsPrivateLinkHubClient.Get
// method.
type PrivateEndpointConnectionsPrivateLinkHubClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsPrivateLinkHubClientListOptions contains the optional parameters for the PrivateEndpointConnectionsPrivateLinkHubClient.List
// method.
type PrivateEndpointConnectionsPrivateLinkHubClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkHub - A privateLinkHub
type PrivateLinkHub struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// PrivateLinkHub resource properties
	Properties *PrivateLinkHubProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkHubInfoListResult - List of privateLinkHubs
type PrivateLinkHubInfoListResult struct {
	// Link to the next page of results
	NextLink *string `json:"nextLink,omitempty"`

	// List of privateLinkHubs
	Value []*PrivateLinkHub `json:"value,omitempty"`
}

// PrivateLinkHubPatchInfo - PrivateLinkHub patch details
type PrivateLinkHubPatchInfo struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// PrivateLinkHubPrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkHubPrivateLinkResourcesClient.Get
// method.
type PrivateLinkHubPrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkHubPrivateLinkResourcesClientListOptions contains the optional parameters for the PrivateLinkHubPrivateLinkResourcesClient.List
// method.
type PrivateLinkHubPrivateLinkResourcesClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkHubProperties - PrivateLinkHub properties
type PrivateLinkHubProperties struct {
	// PrivateLinkHub provisioning state
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// READ-ONLY; List of private endpoint connections
	PrivateEndpointConnections []*PrivateEndpointConnectionForPrivateLinkHubBasic `json:"privateEndpointConnections,omitempty" azure:"ro"`
}

// PrivateLinkHubsClientBeginDeleteOptions contains the optional parameters for the PrivateLinkHubsClient.BeginDelete method.
type PrivateLinkHubsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkHubsClientCreateOrUpdateOptions contains the optional parameters for the PrivateLinkHubsClient.CreateOrUpdate
// method.
type PrivateLinkHubsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkHubsClientGetOptions contains the optional parameters for the PrivateLinkHubsClient.Get method.
type PrivateLinkHubsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkHubsClientListByResourceGroupOptions contains the optional parameters for the PrivateLinkHubsClient.ListByResourceGroup
// method.
type PrivateLinkHubsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkHubsClientListOptions contains the optional parameters for the PrivateLinkHubsClient.List method.
type PrivateLinkHubsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkHubsClientUpdateOptions contains the optional parameters for the PrivateLinkHubsClient.Update method.
type PrivateLinkHubsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*PrivateLinkResource `json:"value,omitempty" azure:"ro"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`

	// READ-ONLY; Required DNS zone names of the the private link resource.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListOptions contains the optional parameters for the PrivateLinkResourcesClient.List method.
type PrivateLinkResourcesClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - Connection state details of the private endpoint
type PrivateLinkServiceConnectionState struct {
	// The private link service connection description.
	Description *string `json:"description,omitempty"`

	// The private link service connection status.
	Status *string `json:"status,omitempty"`

	// READ-ONLY; The actions required for private link service connection.
	ActionsRequired *string `json:"actionsRequired,omitempty" azure:"ro"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PurviewConfiguration - Purview Configuration
type PurviewConfiguration struct {
	// Purview Resource ID
	PurviewResourceID *string `json:"purviewResourceId,omitempty"`
}

// QueryInterval - A database query.
type QueryInterval struct {
	// READ-ONLY; The number of times the query was executed during this interval.
	ExecutionCount *int32 `json:"executionCount,omitempty" azure:"ro"`

	// READ-ONLY; The start time of the measurement interval (ISO8601 format).
	IntervalStartTime *time.Time `json:"intervalStartTime,omitempty" azure:"ro"`

	// READ-ONLY; The list of query metrics during this interval.
	Metrics []*QueryMetric `json:"metrics,omitempty" azure:"ro"`
}

// QueryMetric - A database query.
type QueryMetric struct {
	// READ-ONLY; The name of the metric for display in user interface
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The name of the metric
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The unit of measurement
	Unit *QueryMetricUnit `json:"unit,omitempty" azure:"ro"`

	// READ-ONLY; The measured value
	Value *float64 `json:"value,omitempty" azure:"ro"`
}

// QueryStatistic - A database query.
type QueryStatistic struct {
	// READ-ONLY; The list of query intervals.
	Intervals []*QueryInterval `json:"intervals,omitempty" azure:"ro"`

	// READ-ONLY; The id of the query
	QueryID *string `json:"queryId,omitempty" azure:"ro"`
}

// ReadOnlyFollowingDatabase - Class representing a read only following database.
type ReadOnlyFollowingDatabase struct {
	// REQUIRED; Kind of the database
	Kind *Kind `json:"kind,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// The database properties.
	Properties *ReadOnlyFollowingDatabaseProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDatabase implements the DatabaseClassification interface for type ReadOnlyFollowingDatabase.
func (r *ReadOnlyFollowingDatabase) GetDatabase() *Database {
	return &Database{
		Location:   r.Location,
		Kind:       r.Kind,
		SystemData: r.SystemData,
		ID:         r.ID,
		Name:       r.Name,
		Type:       r.Type,
	}
}

// ReadOnlyFollowingDatabaseProperties - Class representing the Kusto database properties.
type ReadOnlyFollowingDatabaseProperties struct {
	// The time the data should be kept in cache for fast queries in TimeSpan.
	HotCachePeriod *string `json:"hotCachePeriod,omitempty"`

	// READ-ONLY; The name of the attached database configuration cluster
	AttachedDatabaseConfigurationName *string `json:"attachedDatabaseConfigurationName,omitempty" azure:"ro"`

	// READ-ONLY; The name of the leader cluster
	LeaderClusterResourceID *string `json:"leaderClusterResourceId,omitempty" azure:"ro"`

	// READ-ONLY; The principals modification kind of the database
	PrincipalsModificationKind *PrincipalsModificationKind `json:"principalsModificationKind,omitempty" azure:"ro"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The time the data should be kept before it stops being accessible to queries in TimeSpan.
	SoftDeletePeriod *string `json:"softDeletePeriod,omitempty" azure:"ro"`

	// READ-ONLY; The statistics of the database.
	Statistics *DatabaseStatistics `json:"statistics,omitempty" azure:"ro"`
}

// ReadWriteDatabase - Class representing a read write database.
type ReadWriteDatabase struct {
	// REQUIRED; Kind of the database
	Kind *Kind `json:"kind,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// The database properties.
	Properties *ReadWriteDatabaseProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDatabase implements the DatabaseClassification interface for type ReadWriteDatabase.
func (r *ReadWriteDatabase) GetDatabase() *Database {
	return &Database{
		Location:   r.Location,
		Kind:       r.Kind,
		SystemData: r.SystemData,
		ID:         r.ID,
		Name:       r.Name,
		Type:       r.Type,
	}
}

// ReadWriteDatabaseProperties - Class representing the Kusto database properties.
type ReadWriteDatabaseProperties struct {
	// The time the data should be kept in cache for fast queries in TimeSpan.
	HotCachePeriod *string `json:"hotCachePeriod,omitempty"`

	// The time the data should be kept before it stops being accessible to queries in TimeSpan.
	SoftDeletePeriod *string `json:"softDeletePeriod,omitempty"`

	// READ-ONLY; Indicates whether the database is followed.
	IsFollowed *bool `json:"isFollowed,omitempty" azure:"ro"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The statistics of the database.
	Statistics *DatabaseStatistics `json:"statistics,omitempty" azure:"ro"`
}

// RecommendedSensitivityLabelUpdate - A recommended sensitivity label update operation.
type RecommendedSensitivityLabelUpdate struct {
	// Resource properties.
	Properties *RecommendedSensitivityLabelUpdateProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecommendedSensitivityLabelUpdateList - A list of recommended sensitivity label update operations.
type RecommendedSensitivityLabelUpdateList struct {
	Operations []*RecommendedSensitivityLabelUpdate `json:"operations,omitempty"`
}

// RecommendedSensitivityLabelUpdateProperties - Properties of an operation executed on a recommended sensitivity label.
type RecommendedSensitivityLabelUpdateProperties struct {
	// REQUIRED; Column name to update.
	Column *string `json:"column,omitempty"`

	// REQUIRED
	Op *RecommendedSensitivityLabelUpdateKind `json:"op,omitempty"`

	// REQUIRED; Schema name of the column to update.
	Schema *string `json:"schema,omitempty"`

	// REQUIRED; Table name of the column to update.
	Table *string `json:"table,omitempty"`
}

// RecoverableSQLPool - A recoverable sql pool
type RecoverableSQLPool struct {
	// The properties of a recoverable sql pool
	Properties *RecoverableSQLPoolProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecoverableSQLPoolListResult - The response to a list recoverable sql pools request
type RecoverableSQLPoolListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A list of recoverable sql pool
	Value []*RecoverableSQLPool `json:"value,omitempty" azure:"ro"`
}

// RecoverableSQLPoolProperties - The properties of a recoverable sql pool
type RecoverableSQLPoolProperties struct {
	// READ-ONLY; The edition of the database
	Edition *string `json:"edition,omitempty" azure:"ro"`

	// READ-ONLY; The elastic pool name of the database
	ElasticPoolName *string `json:"elasticPoolName,omitempty" azure:"ro"`

	// READ-ONLY; The last available backup date of the database (ISO8601 format)
	LastAvailableBackupDate *time.Time `json:"lastAvailableBackupDate,omitempty" azure:"ro"`

	// READ-ONLY; The service level objective name of the database
	ServiceLevelObjective *string `json:"serviceLevelObjective,omitempty" azure:"ro"`
}

// ReplaceAllFirewallRulesOperationResponse - An existing operation for replacing the firewall rules
type ReplaceAllFirewallRulesOperationResponse struct {
	// The operation ID
	OperationID *string `json:"operationId,omitempty"`
}

// ReplaceAllIPFirewallRulesRequest - Replace all IP firewall rules request
type ReplaceAllIPFirewallRulesRequest struct {
	// IP firewall rule properties
	IPFirewallRules map[string]*IPFirewallRuleProperties `json:"ipFirewallRules,omitempty"`
}

// ReplicationLink - Represents a Sql pool replication link.
type ReplicationLink struct {
	// The properties representing the resource.
	Properties *ReplicationLinkProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Location of the workspace that contains this firewall rule.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReplicationLinkListResult - Represents the response to a List Sql pool replication link request.
type ReplicationLinkListResult struct {
	// The list of Sql pool replication links housed in the Sql pool.
	Value []*ReplicationLink `json:"value,omitempty"`

	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ReplicationLinkProperties - Represents the properties of a Sql pool replication link.
type ReplicationLinkProperties struct {
	// READ-ONLY; Legacy value indicating whether termination is allowed. Currently always returns true.
	IsTerminationAllowed *bool `json:"isTerminationAllowed,omitempty" azure:"ro"`

	// READ-ONLY; The name of the partner Sql pool.
	PartnerDatabase *string `json:"partnerDatabase,omitempty" azure:"ro"`

	// READ-ONLY; The Azure Region of the partner Sql pool.
	PartnerLocation *string `json:"partnerLocation,omitempty" azure:"ro"`

	// READ-ONLY; The role of the partner Sql pool in the replication link.
	PartnerRole *ReplicationRole `json:"partnerRole,omitempty" azure:"ro"`

	// READ-ONLY; The name of the workspace hosting the partner Sql pool.
	PartnerServer *string `json:"partnerServer,omitempty" azure:"ro"`

	// READ-ONLY; The percentage of seeding complete for the replication link.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`

	// READ-ONLY; Replication mode of this replication link.
	ReplicationMode *string `json:"replicationMode,omitempty" azure:"ro"`

	// READ-ONLY; The replication state for the replication link.
	ReplicationState *ReplicationState `json:"replicationState,omitempty" azure:"ro"`

	// READ-ONLY; The role of the Sql pool in the replication link.
	Role *ReplicationRole `json:"role,omitempty" azure:"ro"`

	// READ-ONLY; The start time for the replication link.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceMoveDefinition - Contains the information necessary to perform a resource move (rename).
type ResourceMoveDefinition struct {
	// REQUIRED; The target ID for the resource
	ID *string `json:"id,omitempty"`
}

// RestorableDroppedSQLPool - A restorable dropped Sql pool
type RestorableDroppedSQLPool struct {
	// The properties of a restorable dropped Sql pool
	Properties *RestorableDroppedSQLPoolProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorableDroppedSQLPoolListResult - The response to a list restorable dropped Sql pools request
type RestorableDroppedSQLPoolListResult struct {
	// REQUIRED; A list of restorable dropped Sql pools
	Value []*RestorableDroppedSQLPool `json:"value,omitempty"`
}

// RestorableDroppedSQLPoolProperties - The properties of a restorable dropped Sql pool
type RestorableDroppedSQLPoolProperties struct {
	// READ-ONLY; The creation date of the database (ISO8601 format)
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; The deletion date of the database (ISO8601 format)
	DeletionDate *time.Time `json:"deletionDate,omitempty" azure:"ro"`

	// READ-ONLY; The earliest restore date of the database (ISO8601 format)
	EarliestRestoreDate *time.Time `json:"earliestRestoreDate,omitempty" azure:"ro"`

	// READ-ONLY; The edition of the database
	Edition *string `json:"edition,omitempty" azure:"ro"`

	// READ-ONLY; The elastic pool name of the database
	ElasticPoolName *string `json:"elasticPoolName,omitempty" azure:"ro"`

	// READ-ONLY; The max size in bytes of the database
	MaxSizeBytes *string `json:"maxSizeBytes,omitempty" azure:"ro"`

	// READ-ONLY; The service level objective name of the database
	ServiceLevelObjective *string `json:"serviceLevelObjective,omitempty" azure:"ro"`
}

// RestorableDroppedSQLPoolsClientGetOptions contains the optional parameters for the RestorableDroppedSQLPoolsClient.Get
// method.
type RestorableDroppedSQLPoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RestorableDroppedSQLPoolsClientListByWorkspaceOptions contains the optional parameters for the RestorableDroppedSQLPoolsClient.ListByWorkspace
// method.
type RestorableDroppedSQLPoolsClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// RestorePoint - Database restore points.
type RestorePoint struct {
	// Resource properties.
	Properties *RestorePointProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorePointListResult - A list of long term retention backups.
type RestorePointListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*RestorePoint `json:"value,omitempty" azure:"ro"`
}

// RestorePointProperties - Properties of a database restore point
type RestorePointProperties struct {
	// READ-ONLY; The earliest time to which this database can be restored
	EarliestRestoreDate *time.Time `json:"earliestRestoreDate,omitempty" azure:"ro"`

	// READ-ONLY; The time the backup was taken
	RestorePointCreationDate *time.Time `json:"restorePointCreationDate,omitempty" azure:"ro"`

	// READ-ONLY; The label of restore point for backup request by user
	RestorePointLabel *string `json:"restorePointLabel,omitempty" azure:"ro"`

	// READ-ONLY; The type of restore point
	RestorePointType *RestorePointType `json:"restorePointType,omitempty" azure:"ro"`
}

// SKU - SQL pool SKU
type SKU struct {
	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`

	// The SKU name
	Name *string `json:"name,omitempty"`

	// The service tier
	Tier *string `json:"tier,omitempty"`
}

// SKUDescription - The Kusto SKU description of given resource type
type SKUDescription struct {
	// READ-ONLY; Locations and zones
	LocationInfo []*SKULocationInfoItem `json:"locationInfo,omitempty" azure:"ro"`

	// READ-ONLY; The set of locations that the SKU is available
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; The name of the SKU
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; The restrictions because of which SKU cannot be used
	Restrictions []interface{} `json:"restrictions,omitempty" azure:"ro"`

	// READ-ONLY; The size of the SKU
	Size *string `json:"size,omitempty" azure:"ro"`
}

// SKUDescriptionList - The list of the SKU descriptions
type SKUDescriptionList struct {
	// READ-ONLY; SKU descriptions
	Value []*SKUDescription `json:"value,omitempty" azure:"ro"`
}

// SKULocationInfoItem - The locations and zones info for SKU.
type SKULocationInfoItem struct {
	// REQUIRED; The available location of the SKU.
	Location *string `json:"location,omitempty"`

	// The available zone of the SKU.
	Zones []*string `json:"zones,omitempty"`
}

// SQLPool - A SQL Analytics pool
type SQLPool struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// SQL pool properties
	Properties *SQLPoolResourceProperties `json:"properties,omitempty"`

	// SQL pool SKU
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLPoolBlobAuditingPoliciesClientCreateOrUpdateOptions contains the optional parameters for the SQLPoolBlobAuditingPoliciesClient.CreateOrUpdate
// method.
type SQLPoolBlobAuditingPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolBlobAuditingPoliciesClientGetOptions contains the optional parameters for the SQLPoolBlobAuditingPoliciesClient.Get
// method.
type SQLPoolBlobAuditingPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolBlobAuditingPoliciesClientListBySQLPoolOptions contains the optional parameters for the SQLPoolBlobAuditingPoliciesClient.ListBySQLPool
// method.
type SQLPoolBlobAuditingPoliciesClientListBySQLPoolOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolBlobAuditingPolicy - A Sql pool blob auditing policy.
type SQLPoolBlobAuditingPolicy struct {
	// Resource properties.
	Properties *SQLPoolBlobAuditingPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLPoolBlobAuditingPolicyListResult - A list of Sql pool auditing settings.
type SQLPoolBlobAuditingPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SQLPoolBlobAuditingPolicy `json:"value,omitempty" azure:"ro"`
}

// SQLPoolBlobAuditingPolicyProperties - Properties of a Sql pool blob auditing policy.
type SQLPoolBlobAuditingPolicyProperties struct {
	// REQUIRED; Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
	State *BlobAuditingPolicyState `json:"state,omitempty"`

	// Specifies the Actions-Groups and Actions to audit.
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures
	// executed against the database, as well as successful and failed logins:
	// BATCHCOMPLETEDGROUP, SUCCESSFULDATABASEAUTHENTICATIONGROUP, FAILEDDATABASEAUTHENTICATIONGROUP.
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary
	// groups could lead to very large quantities of audit records):
	// APPLICATIONROLECHANGEPASSWORDGROUP BACKUPRESTOREGROUP DATABASELOGOUTGROUP DATABASEOBJECTCHANGEGROUP DATABASEOBJECTOWNERSHIPCHANGEGROUP
	// DATABASEOBJECTPERMISSIONCHANGEGROUP DATABASEOPERATIONGROUP
	// DATABASEPERMISSIONCHANGEGROUP DATABASEPRINCIPALCHANGEGROUP DATABASEPRINCIPALIMPERSONATIONGROUP DATABASEROLEMEMBERCHANGEGROUP
	// FAILEDDATABASEAUTHENTICATIONGROUP SCHEMAOBJECTACCESSGROUP SCHEMAOBJECT
	// CHANGEGROUP SCHEMAOBJECTOWNERSHIPCHANGEGROUP SCHEMAOBJECTPERMISSIONCHANGEGROUP SUCCESSFULDATABASEAUTHENTICATIONGROUP USERCHANGEPASSWORDGROUP
	// BATCHSTARTEDGROUP BATCHCOMPLETED_GROUP
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used
	// in combination with other groups as this will result in duplicate audit logs.
	// For more information, see Database-Level Audit Action Groups
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups].
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server
	// auditing policy). The supported actions to audit are: SELECT UPDATE INSERT DELETE
	// EXECUTE RECEIVE REFERENCES
	// The general form for defining an action to be audited is: {action} ON {object} BY {principal}
	// Note that in the above format can refer to an object like a table, view, or stored procedure, or an entire database or
	// schema. For the latter cases, the forms DATABASE::{dbname} and SCHEMA::{schema
	// name} are used, respectively.
	// For example: SELECT on dbo.myTable by public SELECT on DATABASE::myDatabase by public SELECT on SCHEMA::mySchema by public
	// For more information, see Database-Level Audit Actions
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions]
	AuditActionsAndGroups []*string `json:"auditActionsAndGroups,omitempty"`

	// Specifies whether audit events are sent to Azure Monitor. In order to send the events to Azure Monitor, specify 'state'
	// as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on
	// the database should be also created. Note that for server level audit you
	// should use the 'master' database as {databaseName}.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`

	// Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`

	// Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`

	// Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, storageAccountAccessKey
	// is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *string `json:"storageAccountSubscriptionId,omitempty"`

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint
	// is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
}

// SQLPoolBlobAuditingPolicySQLPoolOperationListResult - The response to a list Sql pool operations request
type SQLPoolBlobAuditingPolicySQLPoolOperationListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SQLPoolOperation `json:"value,omitempty" azure:"ro"`
}

// SQLPoolColumn - A Sql pool column resource.
type SQLPoolColumn struct {
	// Resource properties.
	Properties *SQLPoolColumnProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLPoolColumnListResult - A list of Sql pool columns.
type SQLPoolColumnListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SQLPoolColumn `json:"value,omitempty" azure:"ro"`
}

// SQLPoolColumnProperties - Sql pool column properties.
type SQLPoolColumnProperties struct {
	// The column data type.
	ColumnType *ColumnDataType `json:"columnType,omitempty"`

	// READ-ONLY; Indicates whether column value is computed or not
	IsComputed *bool `json:"isComputed,omitempty" azure:"ro"`
}

// SQLPoolColumnsClientGetOptions contains the optional parameters for the SQLPoolColumnsClient.Get method.
type SQLPoolColumnsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolConnectionPoliciesClientGetOptions contains the optional parameters for the SQLPoolConnectionPoliciesClient.Get
// method.
type SQLPoolConnectionPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolConnectionPolicy - A Sql pool connection policy.
type SQLPoolConnectionPolicy struct {
	// Resource properties.
	Properties *SQLPoolConnectionPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLPoolConnectionPolicyProperties - Properties of a Sql pool connection policy.
type SQLPoolConnectionPolicyProperties struct {
	// The fully qualified host name of the auditing proxy.
	ProxyDNSName *string `json:"proxyDnsName,omitempty"`

	// The port number of the auditing proxy.
	ProxyPort *string `json:"proxyPort,omitempty"`

	// The state of proxy redirection.
	RedirectionState *string `json:"redirectionState,omitempty"`

	// The state of security access.
	SecurityEnabledAccess *string `json:"securityEnabledAccess,omitempty"`

	// The connection policy state.
	State *string `json:"state,omitempty"`

	// Whether server default is enabled or disabled.
	UseServerDefault *string `json:"useServerDefault,omitempty"`

	// The visibility of the auditing proxy.
	Visibility *string `json:"visibility,omitempty"`
}

// SQLPoolDataWarehouseUserActivitiesClientGetOptions contains the optional parameters for the SQLPoolDataWarehouseUserActivitiesClient.Get
// method.
type SQLPoolDataWarehouseUserActivitiesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolGeoBackupPoliciesClientCreateOrUpdateOptions contains the optional parameters for the SQLPoolGeoBackupPoliciesClient.CreateOrUpdate
// method.
type SQLPoolGeoBackupPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolGeoBackupPoliciesClientGetOptions contains the optional parameters for the SQLPoolGeoBackupPoliciesClient.Get method.
type SQLPoolGeoBackupPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolGeoBackupPoliciesClientListOptions contains the optional parameters for the SQLPoolGeoBackupPoliciesClient.List
// method.
type SQLPoolGeoBackupPoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolInfoListResult - List of SQL pools
type SQLPoolInfoListResult struct {
	// Link to the next page of results
	NextLink *string `json:"nextLink,omitempty"`

	// List of SQL pools
	Value []*SQLPool `json:"value,omitempty"`
}

// SQLPoolMaintenanceWindowOptionsClientGetOptions contains the optional parameters for the SQLPoolMaintenanceWindowOptionsClient.Get
// method.
type SQLPoolMaintenanceWindowOptionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolMaintenanceWindowsClientCreateOrUpdateOptions contains the optional parameters for the SQLPoolMaintenanceWindowsClient.CreateOrUpdate
// method.
type SQLPoolMaintenanceWindowsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolMaintenanceWindowsClientGetOptions contains the optional parameters for the SQLPoolMaintenanceWindowsClient.Get
// method.
type SQLPoolMaintenanceWindowsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolMetadataSyncConfigsClientCreateOptions contains the optional parameters for the SQLPoolMetadataSyncConfigsClient.Create
// method.
type SQLPoolMetadataSyncConfigsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolMetadataSyncConfigsClientGetOptions contains the optional parameters for the SQLPoolMetadataSyncConfigsClient.Get
// method.
type SQLPoolMetadataSyncConfigsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolOperation - A Sql pool operation.
type SQLPoolOperation struct {
	// Resource properties.
	Properties *SQLPoolOperationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLPoolOperationProperties - The properties of a Sql pool operation.
type SQLPoolOperationProperties struct {
	// READ-ONLY; The name of the Sql pool the operation is being performed on.
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; The operation description.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty" azure:"ro"`

	// READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty" azure:"ro"`

	// READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *time.Time `json:"estimatedCompletionTime,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty" azure:"ro"`

	// READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty" azure:"ro"`

	// READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty" azure:"ro"`

	// READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`

	// READ-ONLY; The name of the server.
	ServerName *string `json:"serverName,omitempty" azure:"ro"`

	// READ-ONLY; The operation start time.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The operation state.
	State *ManagementOperationState `json:"state,omitempty" azure:"ro"`
}

// SQLPoolOperationResultsClientGetLocationHeaderResultOptions contains the optional parameters for the SQLPoolOperationResultsClient.GetLocationHeaderResult
// method.
type SQLPoolOperationResultsClientGetLocationHeaderResultOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolOperationsClientListOptions contains the optional parameters for the SQLPoolOperationsClient.List method.
type SQLPoolOperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolPatchInfo - A SQL Analytics pool patch info
type SQLPoolPatchInfo struct {
	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// SQL pool properties
	Properties *SQLPoolResourceProperties `json:"properties,omitempty"`

	// SQL pool SKU
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// SQLPoolRecommendedSensitivityLabelsClientUpdateOptions contains the optional parameters for the SQLPoolRecommendedSensitivityLabelsClient.Update
// method.
type SQLPoolRecommendedSensitivityLabelsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolReplicationLinksClientGetByNameOptions contains the optional parameters for the SQLPoolReplicationLinksClient.GetByName
// method.
type SQLPoolReplicationLinksClientGetByNameOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolReplicationLinksClientListOptions contains the optional parameters for the SQLPoolReplicationLinksClient.List method.
type SQLPoolReplicationLinksClientListOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolResourceProperties - Properties of a SQL Analytics pool
type SQLPoolResourceProperties struct {
	// Collation mode
	Collation *string `json:"collation,omitempty"`

	// Specifies the mode of sql pool creation.
	// Default: regular sql pool creation.
	// PointInTimeRestore: Creates a sql pool by restoring a point in time backup of an existing sql pool. sourceDatabaseId must
	// be specified as the resource ID of the existing sql pool, and
	// restorePointInTime must be specified.
	// Recovery: Creates a sql pool by a geo-replicated backup. sourceDatabaseId must be specified as the recoverableDatabaseId
	// to restore.
	// Restore: Creates a sql pool by restoring a backup of a deleted sql pool. SourceDatabaseId should be the sql pool's original
	// resource ID. SourceDatabaseId and sourceDatabaseDeletionDate must be
	// specified.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Maximum size in bytes
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`

	// Resource state
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Backup database to restore from
	RecoverableDatabaseID *string `json:"recoverableDatabaseId,omitempty"`

	// Snapshot time to restore
	RestorePointInTime *time.Time `json:"restorePointInTime,omitempty"`

	// Specifies the time that the sql pool was deleted
	SourceDatabaseDeletionDate *time.Time `json:"sourceDatabaseDeletionDate,omitempty"`

	// Source database to create from
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`

	// The storage account type used to store backups for this sql pool.
	StorageAccountType *StorageAccountType `json:"storageAccountType,omitempty"`

	// READ-ONLY; Date the SQL pool was created
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; Resource status
	Status *string `json:"status,omitempty" azure:"ro"`
}

// SQLPoolRestorePointsClientBeginCreateOptions contains the optional parameters for the SQLPoolRestorePointsClient.BeginCreate
// method.
type SQLPoolRestorePointsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLPoolRestorePointsClientDeleteOptions contains the optional parameters for the SQLPoolRestorePointsClient.Delete method.
type SQLPoolRestorePointsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolRestorePointsClientGetOptions contains the optional parameters for the SQLPoolRestorePointsClient.Get method.
type SQLPoolRestorePointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolRestorePointsClientListOptions contains the optional parameters for the SQLPoolRestorePointsClient.List method.
type SQLPoolRestorePointsClientListOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolSchema - A Sql pool schema resource.
type SQLPoolSchema struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLPoolSchemaListResult - A list of Sql pool schemas.
type SQLPoolSchemaListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SQLPoolSchema `json:"value,omitempty" azure:"ro"`
}

// SQLPoolSchemasClientGetOptions contains the optional parameters for the SQLPoolSchemasClient.Get method.
type SQLPoolSchemasClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolSchemasClientListOptions contains the optional parameters for the SQLPoolSchemasClient.List method.
type SQLPoolSchemasClientListOptions struct {
	// An OData filter expression that filters elements in the collection.
	Filter *string
}

// SQLPoolSecurityAlertPoliciesClientCreateOrUpdateOptions contains the optional parameters for the SQLPoolSecurityAlertPoliciesClient.CreateOrUpdate
// method.
type SQLPoolSecurityAlertPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolSecurityAlertPoliciesClientGetOptions contains the optional parameters for the SQLPoolSecurityAlertPoliciesClient.Get
// method.
type SQLPoolSecurityAlertPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolSecurityAlertPoliciesClientListOptions contains the optional parameters for the SQLPoolSecurityAlertPoliciesClient.List
// method.
type SQLPoolSecurityAlertPoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolSecurityAlertPolicy - A Sql pool security alert policy.
type SQLPoolSecurityAlertPolicy struct {
	// Resource properties.
	Properties *SecurityAlertPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLPoolSensitivityLabelsClientCreateOrUpdateOptions contains the optional parameters for the SQLPoolSensitivityLabelsClient.CreateOrUpdate
// method.
type SQLPoolSensitivityLabelsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolSensitivityLabelsClientDeleteOptions contains the optional parameters for the SQLPoolSensitivityLabelsClient.Delete
// method.
type SQLPoolSensitivityLabelsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolSensitivityLabelsClientDisableRecommendationOptions contains the optional parameters for the SQLPoolSensitivityLabelsClient.DisableRecommendation
// method.
type SQLPoolSensitivityLabelsClientDisableRecommendationOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolSensitivityLabelsClientEnableRecommendationOptions contains the optional parameters for the SQLPoolSensitivityLabelsClient.EnableRecommendation
// method.
type SQLPoolSensitivityLabelsClientEnableRecommendationOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolSensitivityLabelsClientGetOptions contains the optional parameters for the SQLPoolSensitivityLabelsClient.Get method.
type SQLPoolSensitivityLabelsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolSensitivityLabelsClientListCurrentOptions contains the optional parameters for the SQLPoolSensitivityLabelsClient.ListCurrent
// method.
type SQLPoolSensitivityLabelsClientListCurrentOptions struct {
	// An OData filter expression that filters elements in the collection.
	Filter *string
}

// SQLPoolSensitivityLabelsClientListRecommendedOptions contains the optional parameters for the SQLPoolSensitivityLabelsClient.ListRecommended
// method.
type SQLPoolSensitivityLabelsClientListRecommendedOptions struct {
	// An OData filter expression that filters elements in the collection.
	Filter *string
	// Specifies whether to include disabled recommendations or not.
	IncludeDisabledRecommendations *bool
	// An OData query option to indicate how many elements to skip in the collection.
	SkipToken *string
}

// SQLPoolSensitivityLabelsClientUpdateOptions contains the optional parameters for the SQLPoolSensitivityLabelsClient.Update
// method.
type SQLPoolSensitivityLabelsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolTable - A Sql pool table resource.
type SQLPoolTable struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLPoolTableColumnsClientListByTableNameOptions contains the optional parameters for the SQLPoolTableColumnsClient.ListByTableName
// method.
type SQLPoolTableColumnsClientListByTableNameOptions struct {
	// An OData filter expression that filters elements in the collection.
	Filter *string
}

// SQLPoolTableListResult - A list of Sql pool tables.
type SQLPoolTableListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SQLPoolTable `json:"value,omitempty" azure:"ro"`
}

// SQLPoolTablesClientGetOptions contains the optional parameters for the SQLPoolTablesClient.Get method.
type SQLPoolTablesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolTablesClientListBySchemaOptions contains the optional parameters for the SQLPoolTablesClient.ListBySchema method.
type SQLPoolTablesClientListBySchemaOptions struct {
	// An OData filter expression that filters elements in the collection.
	Filter *string
}

// SQLPoolTransparentDataEncryptionsClientCreateOrUpdateOptions contains the optional parameters for the SQLPoolTransparentDataEncryptionsClient.CreateOrUpdate
// method.
type SQLPoolTransparentDataEncryptionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolTransparentDataEncryptionsClientGetOptions contains the optional parameters for the SQLPoolTransparentDataEncryptionsClient.Get
// method.
type SQLPoolTransparentDataEncryptionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolTransparentDataEncryptionsClientListOptions contains the optional parameters for the SQLPoolTransparentDataEncryptionsClient.List
// method.
type SQLPoolTransparentDataEncryptionsClientListOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolUsage - The Sql pool usages.
type SQLPoolUsage struct {
	// READ-ONLY; The current value of the usage metric.
	CurrentValue *float64 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; The usage metric display name.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The current limit of the usage metric.
	Limit *float64 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; The name of the usage metric.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The next reset time for the usage metric (ISO8601 format).
	NextResetTime *time.Time `json:"nextResetTime,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	ResourceName *string `json:"resourceName,omitempty" azure:"ro"`

	// READ-ONLY; The units of the usage metric.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// SQLPoolUsageListResult - The response to a list Sql pool usages request.
type SQLPoolUsageListResult struct {
	// REQUIRED; The list of usages for the Sql pool.
	Value []*SQLPoolUsage `json:"value,omitempty"`

	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SQLPoolUsagesClientListOptions contains the optional parameters for the SQLPoolUsagesClient.List method.
type SQLPoolUsagesClientListOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolVulnerabilityAssessment - A Sql pool vulnerability assessment.
type SQLPoolVulnerabilityAssessment struct {
	// Resource properties.
	Properties *SQLPoolVulnerabilityAssessmentProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLPoolVulnerabilityAssessmentListResult - A list of the Sql pool's vulnerability assessments.
type SQLPoolVulnerabilityAssessmentListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SQLPoolVulnerabilityAssessment `json:"value,omitempty" azure:"ro"`
}

// SQLPoolVulnerabilityAssessmentProperties - Properties of a Sql pool Vulnerability Assessment.
type SQLPoolVulnerabilityAssessmentProperties struct {
	// The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties `json:"recurringScans,omitempty"`

	// Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey'
	// isn't specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/). It is required
	// if server level vulnerability assessment policy doesn't set
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`

	// A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter.
	// If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is
	// required.
	StorageContainerSasKey *string `json:"storageContainerSasKey,omitempty"`
}

// SQLPoolVulnerabilityAssessmentRuleBaseline - A Sql pool vulnerability assessment rule baseline.
type SQLPoolVulnerabilityAssessmentRuleBaseline struct {
	// Resource properties.
	Properties *SQLPoolVulnerabilityAssessmentRuleBaselineProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLPoolVulnerabilityAssessmentRuleBaselineItem - Properties for an Sql pool vulnerability assessment rule baseline's result.
type SQLPoolVulnerabilityAssessmentRuleBaselineItem struct {
	// REQUIRED; The rule baseline result
	Result []*string `json:"result,omitempty"`
}

// SQLPoolVulnerabilityAssessmentRuleBaselineProperties - Properties of a Sql pool vulnerability assessment rule baseline.
type SQLPoolVulnerabilityAssessmentRuleBaselineProperties struct {
	// REQUIRED; The rule baseline result
	BaselineResults []*SQLPoolVulnerabilityAssessmentRuleBaselineItem `json:"baselineResults,omitempty"`
}

// SQLPoolVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate
// method.
type SQLPoolVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolVulnerabilityAssessmentRuleBaselinesClientDeleteOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentRuleBaselinesClient.Delete
// method.
type SQLPoolVulnerabilityAssessmentRuleBaselinesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolVulnerabilityAssessmentRuleBaselinesClientGetOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentRuleBaselinesClient.Get
// method.
type SQLPoolVulnerabilityAssessmentRuleBaselinesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolVulnerabilityAssessmentScanExportProperties - Properties of the export operation's result.
type SQLPoolVulnerabilityAssessmentScanExportProperties struct {
	// READ-ONLY; Location of the exported report (e.g. https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
	ExportedReportLocation *string `json:"exportedReportLocation,omitempty" azure:"ro"`
}

// SQLPoolVulnerabilityAssessmentScansClientBeginInitiateScanOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentScansClient.BeginInitiateScan
// method.
type SQLPoolVulnerabilityAssessmentScansClientBeginInitiateScanOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLPoolVulnerabilityAssessmentScansClientExportOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentScansClient.Export
// method.
type SQLPoolVulnerabilityAssessmentScansClientExportOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolVulnerabilityAssessmentScansClientGetOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentScansClient.Get
// method.
type SQLPoolVulnerabilityAssessmentScansClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolVulnerabilityAssessmentScansClientListOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentScansClient.List
// method.
type SQLPoolVulnerabilityAssessmentScansClientListOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolVulnerabilityAssessmentScansExport - A Sql pool Vulnerability Assessment scan export resource.
type SQLPoolVulnerabilityAssessmentScansExport struct {
	// Resource properties.
	Properties *SQLPoolVulnerabilityAssessmentScanExportProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLPoolVulnerabilityAssessmentsClientCreateOrUpdateOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentsClient.CreateOrUpdate
// method.
type SQLPoolVulnerabilityAssessmentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolVulnerabilityAssessmentsClientDeleteOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentsClient.Delete
// method.
type SQLPoolVulnerabilityAssessmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolVulnerabilityAssessmentsClientGetOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentsClient.Get
// method.
type SQLPoolVulnerabilityAssessmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolVulnerabilityAssessmentsClientListOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentsClient.List
// method.
type SQLPoolVulnerabilityAssessmentsClientListOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolWorkloadClassifierClientBeginCreateOrUpdateOptions contains the optional parameters for the SQLPoolWorkloadClassifierClient.BeginCreateOrUpdate
// method.
type SQLPoolWorkloadClassifierClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLPoolWorkloadClassifierClientBeginDeleteOptions contains the optional parameters for the SQLPoolWorkloadClassifierClient.BeginDelete
// method.
type SQLPoolWorkloadClassifierClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLPoolWorkloadClassifierClientGetOptions contains the optional parameters for the SQLPoolWorkloadClassifierClient.Get
// method.
type SQLPoolWorkloadClassifierClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolWorkloadClassifierClientListOptions contains the optional parameters for the SQLPoolWorkloadClassifierClient.List
// method.
type SQLPoolWorkloadClassifierClientListOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolWorkloadGroupClientBeginCreateOrUpdateOptions contains the optional parameters for the SQLPoolWorkloadGroupClient.BeginCreateOrUpdate
// method.
type SQLPoolWorkloadGroupClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLPoolWorkloadGroupClientBeginDeleteOptions contains the optional parameters for the SQLPoolWorkloadGroupClient.BeginDelete
// method.
type SQLPoolWorkloadGroupClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLPoolWorkloadGroupClientGetOptions contains the optional parameters for the SQLPoolWorkloadGroupClient.Get method.
type SQLPoolWorkloadGroupClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolWorkloadGroupClientListOptions contains the optional parameters for the SQLPoolWorkloadGroupClient.List method.
type SQLPoolWorkloadGroupClientListOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolsClientBeginCreateOptions contains the optional parameters for the SQLPoolsClient.BeginCreate method.
type SQLPoolsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLPoolsClientBeginDeleteOptions contains the optional parameters for the SQLPoolsClient.BeginDelete method.
type SQLPoolsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLPoolsClientBeginPauseOptions contains the optional parameters for the SQLPoolsClient.BeginPause method.
type SQLPoolsClientBeginPauseOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLPoolsClientBeginResumeOptions contains the optional parameters for the SQLPoolsClient.BeginResume method.
type SQLPoolsClientBeginResumeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLPoolsClientGetOptions contains the optional parameters for the SQLPoolsClient.Get method.
type SQLPoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolsClientListByWorkspaceOptions contains the optional parameters for the SQLPoolsClient.ListByWorkspace method.
type SQLPoolsClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolsClientRenameOptions contains the optional parameters for the SQLPoolsClient.Rename method.
type SQLPoolsClientRenameOptions struct {
	// placeholder for future optional parameters
}

// SQLPoolsClientUpdateOptions contains the optional parameters for the SQLPoolsClient.Update method.
type SQLPoolsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// SecretBaseClassification provides polymorphic access to related types.
// Call the interface's GetSecretBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *SecretBase, *SecureString
type SecretBaseClassification interface {
	// GetSecretBase returns the SecretBase content of the underlying type.
	GetSecretBase() *SecretBase
}

// SecretBase - The base definition of a secret type.
type SecretBase struct {
	// REQUIRED; Type of the secret.
	Type *string `json:"type,omitempty"`
}

// GetSecretBase implements the SecretBaseClassification interface for type SecretBase.
func (s *SecretBase) GetSecretBase() *SecretBase { return s }

// SecureString - Azure Synapse secure string definition. The string value will be masked with asterisks '*' during Get or
// List API calls.
type SecureString struct {
	// REQUIRED; Type of the secret.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Value of secure string.
	Value *string `json:"value,omitempty"`
}

// GetSecretBase implements the SecretBaseClassification interface for type SecureString.
func (s *SecureString) GetSecretBase() *SecretBase {
	return &SecretBase{
		Type: s.Type,
	}
}

// SecurityAlertPolicyProperties - Properties of a security alert policy.
type SecurityAlertPolicyProperties struct {
	// REQUIRED; Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on
	// the specific Sql pool.
	State *SecurityAlertPolicyState `json:"state,omitempty"`

	// Specifies an array of alerts that are disabled. Allowed values are: SqlInjection, SqlInjectionVulnerability, AccessAnomaly,
	// DataExfiltration, UnsafeAction
	DisabledAlerts []*string `json:"disabledAlerts,omitempty"`

	// Specifies that the alert is sent to the account administrators.
	EmailAccountAdmins *bool `json:"emailAccountAdmins,omitempty"`

	// Specifies an array of e-mail addresses to which the alert is sent.
	EmailAddresses []*string `json:"emailAddresses,omitempty"`

	// Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32 `json:"retentionDays,omitempty"`

	// Specifies the identifier key of the Threat Detection audit storage account.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat
	// Detection audit logs.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`

	// READ-ONLY; Specifies the UTC creation time of the policy.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`
}

// SelfHostedIntegrationRuntime - Self-hosted integration runtime.
type SelfHostedIntegrationRuntime struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Integration runtime description.
	Description *string `json:"description,omitempty"`

	// When this property is not null, means this is a linked integration runtime. The property is used to access original integration
	// runtime.
	TypeProperties *SelfHostedIntegrationRuntimeTypeProperties `json:"typeProperties,omitempty"`
}

// GetIntegrationRuntime implements the IntegrationRuntimeClassification interface for type SelfHostedIntegrationRuntime.
func (s *SelfHostedIntegrationRuntime) GetIntegrationRuntime() *IntegrationRuntime {
	return &IntegrationRuntime{
		Type:                 s.Type,
		Description:          s.Description,
		AdditionalProperties: s.AdditionalProperties,
	}
}

// SelfHostedIntegrationRuntimeNode - Properties of Self-hosted integration runtime node.
type SelfHostedIntegrationRuntimeNode struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; The integration runtime capabilities dictionary
	Capabilities map[string]*string `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; Maximum concurrent jobs on the integration runtime node.
	ConcurrentJobsLimit *int32 `json:"concurrentJobsLimit,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the integration runtime will expire in ISO8601 format.
	ExpiryTime *time.Time `json:"expiryTime,omitempty" azure:"ro"`

	// READ-ONLY; URI for the host machine of the integration runtime.
	HostServiceURI *string `json:"hostServiceUri,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether this node is the active dispatcher for integration runtime requests.
	IsActiveDispatcher *bool `json:"isActiveDispatcher,omitempty" azure:"ro"`

	// READ-ONLY; The most recent time at which the integration runtime was connected in ISO8601 format.
	LastConnectTime *time.Time `json:"lastConnectTime,omitempty" azure:"ro"`

	// READ-ONLY; The last time for the integration runtime node update end.
	LastEndUpdateTime *time.Time `json:"lastEndUpdateTime,omitempty" azure:"ro"`

	// READ-ONLY; The time the node last started up.
	LastStartTime *time.Time `json:"lastStartTime,omitempty" azure:"ro"`

	// READ-ONLY; The last time for the integration runtime node update start.
	LastStartUpdateTime *time.Time `json:"lastStartUpdateTime,omitempty" azure:"ro"`

	// READ-ONLY; The integration runtime node last stop time.
	LastStopTime *time.Time `json:"lastStopTime,omitempty" azure:"ro"`

	// READ-ONLY; The result of the last integration runtime node update.
	LastUpdateResult *IntegrationRuntimeUpdateResult `json:"lastUpdateResult,omitempty" azure:"ro"`

	// READ-ONLY; Machine name of the integration runtime node.
	MachineName *string `json:"machineName,omitempty" azure:"ro"`

	// READ-ONLY; The maximum concurrent jobs in this integration runtime.
	MaxConcurrentJobs *int32 `json:"maxConcurrentJobs,omitempty" azure:"ro"`

	// READ-ONLY; Name of the integration runtime node.
	NodeName *string `json:"nodeName,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the integration runtime node was registered in ISO8601 format.
	RegisterTime *time.Time `json:"registerTime,omitempty" azure:"ro"`

	// READ-ONLY; Status of the integration runtime node.
	Status *SelfHostedIntegrationRuntimeNodeStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Version of the integration runtime node.
	Version *string `json:"version,omitempty" azure:"ro"`

	// READ-ONLY; Status of the integration runtime node version.
	VersionStatus *string `json:"versionStatus,omitempty" azure:"ro"`
}

// SelfHostedIntegrationRuntimeStatus - Self-hosted integration runtime status.
type SelfHostedIntegrationRuntimeStatus struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType `json:"type,omitempty"`

	// REQUIRED; Self-hosted integration runtime status type properties.
	TypeProperties *SelfHostedIntegrationRuntimeStatusTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; The workspace name which the integration runtime belong to.
	DataFactoryName *string `json:"dataFactoryName,omitempty" azure:"ro"`

	// READ-ONLY; The state of integration runtime.
	State *IntegrationRuntimeState `json:"state,omitempty" azure:"ro"`
}

// GetIntegrationRuntimeStatus implements the IntegrationRuntimeStatusClassification interface for type SelfHostedIntegrationRuntimeStatus.
func (s *SelfHostedIntegrationRuntimeStatus) GetIntegrationRuntimeStatus() *IntegrationRuntimeStatus {
	return &IntegrationRuntimeStatus{
		Type:                 s.Type,
		DataFactoryName:      s.DataFactoryName,
		State:                s.State,
		AdditionalProperties: s.AdditionalProperties,
	}
}

// SelfHostedIntegrationRuntimeStatusTypeProperties - Self-hosted integration runtime status type properties.
type SelfHostedIntegrationRuntimeStatusTypeProperties struct {
	// The list of linked integration runtimes that are created to share with this integration runtime.
	Links []*LinkedIntegrationRuntime `json:"links,omitempty"`

	// The newer versions on download center.
	NewerVersions []*string `json:"newerVersions,omitempty"`

	// The list of nodes for this integration runtime.
	Nodes []*SelfHostedIntegrationRuntimeNode `json:"nodes,omitempty"`

	// The service region of the integration runtime
	ServiceRegion *string `json:"serviceRegion,omitempty"`

	// READ-ONLY; Whether Self-hosted integration runtime auto update has been turned on.
	AutoUpdate *IntegrationRuntimeAutoUpdate `json:"autoUpdate,omitempty" azure:"ro"`

	// READ-ONLY; The estimated time when the self-hosted integration runtime will be updated.
	AutoUpdateETA *time.Time `json:"autoUpdateETA,omitempty" azure:"ro"`

	// READ-ONLY; Object with additional information about integration runtime capabilities.
	Capabilities map[string]*string `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the integration runtime was created, in ISO8601 format.
	CreateTime *time.Time `json:"createTime,omitempty" azure:"ro"`

	// READ-ONLY; It is used to set the encryption mode for node-node communication channel (when more than 2 self-hosted integration
	// runtime nodes exist).
	InternalChannelEncryption *IntegrationRuntimeInternalChannelEncryptionMode `json:"internalChannelEncryption,omitempty" azure:"ro"`

	// READ-ONLY; The latest version on download center.
	LatestVersion *string `json:"latestVersion,omitempty" azure:"ro"`

	// READ-ONLY; The local time zone offset in hours.
	LocalTimeZoneOffset *string `json:"localTimeZoneOffset,omitempty" azure:"ro"`

	// READ-ONLY; The node communication Channel encryption mode
	NodeCommunicationChannelEncryptionMode *string `json:"nodeCommunicationChannelEncryptionMode,omitempty" azure:"ro"`

	// READ-ONLY; The version that the integration runtime is going to update to.
	PushedVersion *string `json:"pushedVersion,omitempty" azure:"ro"`

	// READ-ONLY; The date at which the integration runtime will be scheduled to update, in ISO8601 format.
	ScheduledUpdateDate *time.Time `json:"scheduledUpdateDate,omitempty" azure:"ro"`

	// READ-ONLY; The URLs for the services used in integration runtime backend service.
	ServiceUrls []*string `json:"serviceUrls,omitempty" azure:"ro"`

	// READ-ONLY; The task queue id of the integration runtime.
	TaskQueueID *string `json:"taskQueueId,omitempty" azure:"ro"`

	// READ-ONLY; The time in the date scheduled by service to update the integration runtime, e.g., PT03H is 3 hours
	UpdateDelayOffset *string `json:"updateDelayOffset,omitempty" azure:"ro"`

	// READ-ONLY; Version of the integration runtime.
	Version *string `json:"version,omitempty" azure:"ro"`

	// READ-ONLY; Status of the integration runtime version.
	VersionStatus *string `json:"versionStatus,omitempty" azure:"ro"`
}

// SelfHostedIntegrationRuntimeTypeProperties - The self-hosted integration runtime properties.
type SelfHostedIntegrationRuntimeTypeProperties struct {
	// Linked integration runtime type from data factory
	LinkedInfo LinkedIntegrationRuntimeTypeClassification `json:"linkedInfo,omitempty"`
}

// SensitivityLabel - A sensitivity label.
type SensitivityLabel struct {
	// Resource properties.
	Properties *SensitivityLabelProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; managed by
	ManagedBy *string `json:"managedBy,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SensitivityLabelListResult - A list of sensitivity labels.
type SensitivityLabelListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SensitivityLabel `json:"value,omitempty" azure:"ro"`
}

// SensitivityLabelProperties - Properties of a sensitivity label.
type SensitivityLabelProperties struct {
	// The information type.
	InformationType *string `json:"informationType,omitempty"`

	// The information type ID.
	InformationTypeID *string `json:"informationTypeId,omitempty"`

	// The label ID.
	LabelID *string `json:"labelId,omitempty"`

	// The label name.
	LabelName *string               `json:"labelName,omitempty"`
	Rank      *SensitivityLabelRank `json:"rank,omitempty"`

	// READ-ONLY; The column name.
	ColumnName *string `json:"columnName,omitempty" azure:"ro"`

	// READ-ONLY; Is sensitivity recommendation disabled. Applicable for recommended sensitivity label only. Specifies whether
	// the sensitivity recommendation on this column is disabled (dismissed) or not.
	IsDisabled *bool `json:"isDisabled,omitempty" azure:"ro"`

	// READ-ONLY; The schema name.
	SchemaName *string `json:"schemaName,omitempty" azure:"ro"`

	// READ-ONLY; The table name.
	TableName *string `json:"tableName,omitempty" azure:"ro"`
}

// SensitivityLabelUpdate - A sensitivity label update operation.
type SensitivityLabelUpdate struct {
	// Resource properties.
	Properties *SensitivityLabelUpdateProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SensitivityLabelUpdateList - A list of sensitivity label update operations.
type SensitivityLabelUpdateList struct {
	Operations []*SensitivityLabelUpdate `json:"operations,omitempty"`
}

// SensitivityLabelUpdateProperties - Properties of an operation executed on a sensitivity label.
type SensitivityLabelUpdateProperties struct {
	// REQUIRED; Column name to update.
	Column *string `json:"column,omitempty"`

	// REQUIRED
	Op *SensitivityLabelUpdateKind `json:"op,omitempty"`

	// REQUIRED; Schema name of the column to update.
	Schema *string `json:"schema,omitempty"`

	// REQUIRED; Table name of the column to update.
	Table *string `json:"table,omitempty"`

	// The sensitivity label information to apply on a column.
	SensitivityLabel *SensitivityLabel `json:"sensitivityLabel,omitempty"`
}

// ServerBlobAuditingPolicy - A server blob auditing policy.
type ServerBlobAuditingPolicy struct {
	// Resource properties.
	Properties *ServerBlobAuditingPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerBlobAuditingPolicyListResult - A list of server auditing settings.
type ServerBlobAuditingPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerBlobAuditingPolicy `json:"value,omitempty" azure:"ro"`
}

// ServerBlobAuditingPolicyProperties - Properties of a server blob auditing policy.
type ServerBlobAuditingPolicyProperties struct {
	// REQUIRED; Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
	State *BlobAuditingPolicyState `json:"state,omitempty"`

	// Specifies the Actions-Groups and Actions to audit.
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures
	// executed against the database, as well as successful and failed logins:
	// BATCHCOMPLETEDGROUP, SUCCESSFULDATABASEAUTHENTICATIONGROUP, FAILEDDATABASEAUTHENTICATIONGROUP.
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary
	// groups could lead to very large quantities of audit records):
	// APPLICATIONROLECHANGEPASSWORDGROUP BACKUPRESTOREGROUP DATABASELOGOUTGROUP DATABASEOBJECTCHANGEGROUP DATABASEOBJECTOWNERSHIPCHANGEGROUP
	// DATABASEOBJECTPERMISSIONCHANGEGROUP DATABASEOPERATIONGROUP
	// DATABASEPERMISSIONCHANGEGROUP DATABASEPRINCIPALCHANGEGROUP DATABASEPRINCIPALIMPERSONATIONGROUP DATABASEROLEMEMBERCHANGEGROUP
	// FAILEDDATABASEAUTHENTICATIONGROUP SCHEMAOBJECTACCESSGROUP SCHEMAOBJECT
	// CHANGEGROUP SCHEMAOBJECTOWNERSHIPCHANGEGROUP SCHEMAOBJECTPERMISSIONCHANGEGROUP SUCCESSFULDATABASEAUTHENTICATIONGROUP USERCHANGEPASSWORDGROUP
	// BATCHSTARTEDGROUP BATCHCOMPLETED_GROUP
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used
	// in combination with other groups as this will result in duplicate audit logs.
	// For more information, see Database-Level Audit Action Groups
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups].
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server
	// auditing policy). The supported actions to audit are: SELECT UPDATE INSERT DELETE
	// EXECUTE RECEIVE REFERENCES
	// The general form for defining an action to be audited is: {action} ON {object} BY {principal}
	// Note that in the above format can refer to an object like a table, view, or stored procedure, or an entire database or
	// schema. For the latter cases, the forms DATABASE::{dbname} and SCHEMA::{schema
	// name} are used, respectively.
	// For example: SELECT on dbo.myTable by public SELECT on DATABASE::myDatabase by public SELECT on SCHEMA::mySchema by public
	// For more information, see Database-Level Audit Actions
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions]
	AuditActionsAndGroups []*string `json:"auditActionsAndGroups,omitempty"`

	// Specifies whether audit events are sent to Azure Monitor. In order to send the events to Azure Monitor, specify 'state'
	// as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on
	// the database should be also created. Note that for server level audit you
	// should use the 'master' database as {databaseName}.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`

	// Specifies the state of devops audit. If state is Enabled, devops logs will be sent to Azure Monitor. In order to send the
	// events to Azure Monitor, specify 'State' as 'Enabled',
	// 'IsAzureMonitorTargetEnabled' as true and 'IsDevopsAuditEnabled' as true
	// When using REST API to configure auditing, Diagnostic Settings with 'DevOpsOperationsAudit' diagnostic logs category on
	// the master database should also be created.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsDevopsAuditEnabled *bool `json:"isDevopsAuditEnabled,omitempty"`

	// Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`

	// Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed. The default
	// minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`

	// Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`

	// Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, not
	// specifying the storageAccountAccessKey will use SQL server system-assigned
	// managed identity to access the storage. Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server
	// identity. For more information, see Auditing to storage using Managed
	// Identity authentication [https://go.microsoft.com/fwlink/?linkid=2114355]
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *string `json:"storageAccountSubscriptionId,omitempty"`

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint
	// or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
}

// ServerSecurityAlertPolicy - Workspace managed Sql server security alert policy.
type ServerSecurityAlertPolicy struct {
	// Resource properties.
	Properties *ServerSecurityAlertPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerSecurityAlertPolicyListResult - A list of the workspace managed sql server's security alert policies.
type ServerSecurityAlertPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerSecurityAlertPolicy `json:"value,omitempty" azure:"ro"`
}

// ServerSecurityAlertPolicyProperties - Properties of a security alert policy.
type ServerSecurityAlertPolicyProperties struct {
	// REQUIRED; Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on
	// the specific server
	State *SecurityAlertPolicyState `json:"state,omitempty"`

	// Specifies an array of alerts that are disabled. Allowed values are: SqlInjection, SqlInjectionVulnerability, AccessAnomaly,
	// DataExfiltration, UnsafeAction
	DisabledAlerts []*string `json:"disabledAlerts,omitempty"`

	// Specifies that the alert is sent to the account administrators.
	EmailAccountAdmins *bool `json:"emailAccountAdmins,omitempty"`

	// Specifies an array of e-mail addresses to which the alert is sent.
	EmailAddresses []*string `json:"emailAddresses,omitempty"`

	// Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32 `json:"retentionDays,omitempty"`

	// Specifies the identifier key of the Threat Detection audit storage account.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat
	// Detection audit logs.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`

	// READ-ONLY; Specifies the UTC creation time of the policy.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`
}

// ServerUsage - Represents server metrics.
type ServerUsage struct {
	// READ-ONLY; The current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; The metric display name.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The current limit of the metric.
	Limit *float64 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; Name of the server usage metric.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The next reset time for the metric (ISO8601 format).
	NextResetTime *time.Time `json:"nextResetTime,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	ResourceName *string `json:"resourceName,omitempty" azure:"ro"`

	// READ-ONLY; The units of the metric.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// ServerUsageListResult - Represents the response to a list server metrics request.
type ServerUsageListResult struct {
	// REQUIRED; The list of server metrics for the server.
	Value []*ServerUsage `json:"value,omitempty"`

	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ServerVulnerabilityAssessment - A server vulnerability assessment.
type ServerVulnerabilityAssessment struct {
	// Resource properties.
	Properties *ServerVulnerabilityAssessmentProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerVulnerabilityAssessmentListResult - A list of the server's vulnerability assessments.
type ServerVulnerabilityAssessmentListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerVulnerabilityAssessment `json:"value,omitempty" azure:"ro"`
}

// ServerVulnerabilityAssessmentProperties - Properties of a server Vulnerability Assessment.
type ServerVulnerabilityAssessmentProperties struct {
	// REQUIRED; A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`

	// The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties `json:"recurringScans,omitempty"`

	// Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey'
	// isn't specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// A shared access signature (SAS Key) that has read and write access to the blob container specified in 'storageContainerPath'
	// parameter. If 'storageAccountAccessKey' isn't specified,
	// StorageContainerSasKey is required.
	StorageContainerSasKey *string `json:"storageContainerSasKey,omitempty"`
}

// SparkConfigProperties - SparkConfig Properties for a Big Data pool powered by Apache Spark
type SparkConfigProperties struct {
	// The type of the spark config properties file.
	ConfigurationType *ConfigurationType `json:"configurationType,omitempty"`

	// The spark config properties.
	Content *string `json:"content,omitempty"`

	// The filename of the spark config properties file.
	Filename *string `json:"filename,omitempty"`

	// READ-ONLY; The last update time of the spark config properties file.
	Time *time.Time `json:"time,omitempty" azure:"ro"`
}

// SparkConfigurationClientGetOptions contains the optional parameters for the SparkConfigurationClient.Get method.
type SparkConfigurationClientGetOptions struct {
	// placeholder for future optional parameters
}

// SparkConfigurationInfo - SparkConfiguration Artifact information
type SparkConfigurationInfo struct {
	// REQUIRED; SparkConfiguration configs.
	Configs map[string]*string `json:"configs,omitempty"`

	// Annotations for SparkConfiguration.
	Annotations []*string `json:"annotations,omitempty"`

	// The timestamp of resource creation.
	Created *time.Time `json:"created,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// Description about the SparkConfiguration.
	Description *string `json:"description,omitempty"`

	// additional Notes.
	Notes *string `json:"notes,omitempty"`
}

// SparkConfigurationListResponse - A list of SparkConfiguration resources.
type SparkConfigurationListResponse struct {
	// REQUIRED; List of SparkConfiguration.
	Value []*SparkConfigurationResource `json:"value,omitempty"`

	// The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// SparkConfigurationResource - SparkConfiguration response details
type SparkConfigurationResource struct {
	// REQUIRED; SparkConfiguration properties.
	Properties *SparkConfigurationInfo `json:"properties,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SparkConfigurationsClientListByWorkspaceOptions contains the optional parameters for the SparkConfigurationsClient.ListByWorkspace
// method.
type SparkConfigurationsClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// SsisEnvironment - Ssis environment.
type SsisEnvironment struct {
	// REQUIRED; Type of metadata.
	Type *SsisObjectMetadataType `json:"type,omitempty"`

	// Metadata description.
	Description *string `json:"description,omitempty"`

	// Folder id which contains environment.
	FolderID *int64 `json:"folderId,omitempty"`

	// Metadata id.
	ID *int64 `json:"id,omitempty"`

	// Metadata name.
	Name *string `json:"name,omitempty"`

	// Variable in environment
	Variables []*SsisVariable `json:"variables,omitempty"`
}

// GetSsisObjectMetadata implements the SsisObjectMetadataClassification interface for type SsisEnvironment.
func (s *SsisEnvironment) GetSsisObjectMetadata() *SsisObjectMetadata {
	return &SsisObjectMetadata{
		Type:        s.Type,
		ID:          s.ID,
		Name:        s.Name,
		Description: s.Description,
	}
}

// SsisEnvironmentReference - Ssis environment reference.
type SsisEnvironmentReference struct {
	// Environment folder name.
	EnvironmentFolderName *string `json:"environmentFolderName,omitempty"`

	// Environment name.
	EnvironmentName *string `json:"environmentName,omitempty"`

	// Environment reference id.
	ID *int64 `json:"id,omitempty"`

	// Reference type
	ReferenceType *string `json:"referenceType,omitempty"`
}

// SsisFolder - Ssis folder.
type SsisFolder struct {
	// REQUIRED; Type of metadata.
	Type *SsisObjectMetadataType `json:"type,omitempty"`

	// Metadata description.
	Description *string `json:"description,omitempty"`

	// Metadata id.
	ID *int64 `json:"id,omitempty"`

	// Metadata name.
	Name *string `json:"name,omitempty"`
}

// GetSsisObjectMetadata implements the SsisObjectMetadataClassification interface for type SsisFolder.
func (s *SsisFolder) GetSsisObjectMetadata() *SsisObjectMetadata {
	return &SsisObjectMetadata{
		Type:        s.Type,
		ID:          s.ID,
		Name:        s.Name,
		Description: s.Description,
	}
}

// SsisObjectMetadataClassification provides polymorphic access to related types.
// Call the interface's GetSsisObjectMetadata() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *SsisEnvironment, *SsisFolder, *SsisObjectMetadata, *SsisPackage, *SsisProject
type SsisObjectMetadataClassification interface {
	// GetSsisObjectMetadata returns the SsisObjectMetadata content of the underlying type.
	GetSsisObjectMetadata() *SsisObjectMetadata
}

// SsisObjectMetadata - SSIS object metadata.
type SsisObjectMetadata struct {
	// REQUIRED; Type of metadata.
	Type *SsisObjectMetadataType `json:"type,omitempty"`

	// Metadata description.
	Description *string `json:"description,omitempty"`

	// Metadata id.
	ID *int64 `json:"id,omitempty"`

	// Metadata name.
	Name *string `json:"name,omitempty"`
}

// GetSsisObjectMetadata implements the SsisObjectMetadataClassification interface for type SsisObjectMetadata.
func (s *SsisObjectMetadata) GetSsisObjectMetadata() *SsisObjectMetadata { return s }

// SsisObjectMetadataListResponse - A list of SSIS object metadata.
type SsisObjectMetadataListResponse struct {
	// The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`

	// List of SSIS object metadata.
	Value []SsisObjectMetadataClassification `json:"value,omitempty"`
}

// SsisObjectMetadataStatusResponse - The status of the operation.
type SsisObjectMetadataStatusResponse struct {
	// The operation error message.
	Error *string `json:"error,omitempty"`

	// The operation name.
	Name *string `json:"name,omitempty"`

	// The operation properties.
	Properties *string `json:"properties,omitempty"`

	// The status of the operation.
	Status *string `json:"status,omitempty"`
}

// SsisPackage - Ssis Package.
type SsisPackage struct {
	// REQUIRED; Type of metadata.
	Type *SsisObjectMetadataType `json:"type,omitempty"`

	// Metadata description.
	Description *string `json:"description,omitempty"`

	// Folder id which contains package.
	FolderID *int64 `json:"folderId,omitempty"`

	// Metadata id.
	ID *int64 `json:"id,omitempty"`

	// Metadata name.
	Name *string `json:"name,omitempty"`

	// Parameters in package
	Parameters []*SsisParameter `json:"parameters,omitempty"`

	// Project id which contains package.
	ProjectID *int64 `json:"projectId,omitempty"`

	// Project version which contains package.
	ProjectVersion *int64 `json:"projectVersion,omitempty"`
}

// GetSsisObjectMetadata implements the SsisObjectMetadataClassification interface for type SsisPackage.
func (s *SsisPackage) GetSsisObjectMetadata() *SsisObjectMetadata {
	return &SsisObjectMetadata{
		Type:        s.Type,
		ID:          s.ID,
		Name:        s.Name,
		Description: s.Description,
	}
}

// SsisParameter - Ssis parameter.
type SsisParameter struct {
	// Parameter type.
	DataType *string `json:"dataType,omitempty"`

	// Default value of parameter.
	DefaultValue *string `json:"defaultValue,omitempty"`

	// Parameter description.
	Description *string `json:"description,omitempty"`

	// Design default value of parameter.
	DesignDefaultValue *string `json:"designDefaultValue,omitempty"`

	// Parameter id.
	ID *int64 `json:"id,omitempty"`

	// Parameter name.
	Name *string `json:"name,omitempty"`

	// Whether parameter is required.
	Required *bool `json:"required,omitempty"`

	// Whether parameter is sensitive.
	Sensitive *bool `json:"sensitive,omitempty"`

	// Default sensitive value of parameter.
	SensitiveDefaultValue *string `json:"sensitiveDefaultValue,omitempty"`

	// Parameter value set.
	ValueSet *bool `json:"valueSet,omitempty"`

	// Parameter value type.
	ValueType *string `json:"valueType,omitempty"`

	// Parameter reference variable.
	Variable *string `json:"variable,omitempty"`
}

// SsisProject - Ssis project.
type SsisProject struct {
	// REQUIRED; Type of metadata.
	Type *SsisObjectMetadataType `json:"type,omitempty"`

	// Metadata description.
	Description *string `json:"description,omitempty"`

	// Environment reference in project
	EnvironmentRefs []*SsisEnvironmentReference `json:"environmentRefs,omitempty"`

	// Folder id which contains project.
	FolderID *int64 `json:"folderId,omitempty"`

	// Metadata id.
	ID *int64 `json:"id,omitempty"`

	// Metadata name.
	Name *string `json:"name,omitempty"`

	// Parameters in project
	Parameters []*SsisParameter `json:"parameters,omitempty"`

	// Project version.
	Version *int64 `json:"version,omitempty"`
}

// GetSsisObjectMetadata implements the SsisObjectMetadataClassification interface for type SsisProject.
func (s *SsisProject) GetSsisObjectMetadata() *SsisObjectMetadata {
	return &SsisObjectMetadata{
		Type:        s.Type,
		ID:          s.ID,
		Name:        s.Name,
		Description: s.Description,
	}
}

// SsisVariable - Ssis variable.
type SsisVariable struct {
	// Variable type.
	DataType *string `json:"dataType,omitempty"`

	// Variable description.
	Description *string `json:"description,omitempty"`

	// Variable id.
	ID *int64 `json:"id,omitempty"`

	// Variable name.
	Name *string `json:"name,omitempty"`

	// Whether variable is sensitive.
	Sensitive *bool `json:"sensitive,omitempty"`

	// Variable sensitive value.
	SensitiveValue *string `json:"sensitiveValue,omitempty"`

	// Variable value.
	Value *string `json:"value,omitempty"`
}

// SubResource - Azure Synapse nested resource, which belongs to a workspace.
type SubResource struct {
	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TableLevelSharingProperties - Tables that will be included and excluded in the follower database
type TableLevelSharingProperties struct {
	// List of external tables exclude from the follower database
	ExternalTablesToExclude []*string `json:"externalTablesToExclude,omitempty"`

	// List of external tables to include in the follower database
	ExternalTablesToInclude []*string `json:"externalTablesToInclude,omitempty"`

	// List of materialized views exclude from the follower database
	MaterializedViewsToExclude []*string `json:"materializedViewsToExclude,omitempty"`

	// List of materialized views to include in the follower database
	MaterializedViewsToInclude []*string `json:"materializedViewsToInclude,omitempty"`

	// List of tables to exclude from the follower database
	TablesToExclude []*string `json:"tablesToExclude,omitempty"`

	// List of tables to include in the follower database
	TablesToInclude []*string `json:"tablesToInclude,omitempty"`
}

// TopQueries - A database query.
type TopQueries struct {
	// READ-ONLY; The function that is used to aggregate each query's metrics.
	AggregationFunction *QueryAggregationFunction `json:"aggregationFunction,omitempty" azure:"ro"`

	// READ-ONLY; The execution type that is used to filter the query instances that are returned.
	ExecutionType *QueryExecutionType `json:"executionType,omitempty" azure:"ro"`

	// READ-ONLY; The duration of the interval (ISO8601 duration format).
	IntervalType *string `json:"intervalType,omitempty" azure:"ro"`

	// READ-ONLY; The number of requested queries.
	NumberOfTopQueries *int32 `json:"numberOfTopQueries,omitempty" azure:"ro"`

	// READ-ONLY; The end time for queries that are returned (ISO8601 format)
	ObservationEndTime *time.Time `json:"observationEndTime,omitempty" azure:"ro"`

	// READ-ONLY; The start time for queries that are returned (ISO8601 format)
	ObservationStartTime *time.Time `json:"observationStartTime,omitempty" azure:"ro"`

	// READ-ONLY; The type of metric to use for ordering the top metrics.
	ObservedMetric *QueryObservedMetricType `json:"observedMetric,omitempty" azure:"ro"`

	// READ-ONLY; The list of queries.
	Queries []*QueryStatistic `json:"queries,omitempty" azure:"ro"`
}

// TopQueriesListResult - Represents the response to a get top queries request.
type TopQueriesListResult struct {
	// REQUIRED; The list of top queries.
	Value []*TopQueries `json:"value,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TransparentDataEncryption - Represents a Sql pool transparent data encryption configuration.
type TransparentDataEncryption struct {
	// Represents the properties of the resource.
	Properties *TransparentDataEncryptionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TransparentDataEncryptionListResult - A list of transparent data encryption configurations.
type TransparentDataEncryptionListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*TransparentDataEncryption `json:"value,omitempty" azure:"ro"`
}

// TransparentDataEncryptionProperties - Represents the properties of a database transparent data encryption.
type TransparentDataEncryptionProperties struct {
	// The status of the database transparent data encryption.
	Status *TransparentDataEncryptionStatus `json:"status,omitempty"`
}

// UpdateIntegrationRuntimeNodeRequest - Update integration runtime node request.
type UpdateIntegrationRuntimeNodeRequest struct {
	// The number of concurrent jobs permitted to run on the integration runtime node. Values between 1 and maxConcurrentJobs(inclusive)
	// are allowed.
	ConcurrentJobsLimit *int32 `json:"concurrentJobsLimit,omitempty"`
}

// UpdateIntegrationRuntimeRequest - Update integration runtime request.
type UpdateIntegrationRuntimeRequest struct {
	// Enables or disables the auto-update feature of the self-hosted integration runtime. See https://go.microsoft.com/fwlink/?linkid=854189.
	AutoUpdate *IntegrationRuntimeAutoUpdate `json:"autoUpdate,omitempty"`

	// The time offset (in hours) in the day, e.g., PT03H is 3 hours. The integration runtime auto update will happen on that
	// time.
	UpdateDelayOffset *string `json:"updateDelayOffset,omitempty"`
}

// UserAssignedManagedIdentity - User Assigned Managed Identity
type UserAssignedManagedIdentity struct {
	// READ-ONLY; The client ID.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal ID.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// VirtualNetworkProfile - Virtual Network Profile
type VirtualNetworkProfile struct {
	// Subnet ID used for computes in workspace
	ComputeSubnetID *string `json:"computeSubnetId,omitempty"`
}

// VulnerabilityAssessmentRecurringScansProperties - Properties of a Vulnerability Assessment recurring scans.
type VulnerabilityAssessmentRecurringScansProperties struct {
	// Specifies that the schedule scan notification will be is sent to the subscription administrators.
	EmailSubscriptionAdmins *bool `json:"emailSubscriptionAdmins,omitempty"`

	// Specifies an array of e-mail addresses to which the scan notification is sent.
	Emails []*string `json:"emails,omitempty"`

	// Recurring scans state.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// VulnerabilityAssessmentScanError - Properties of a vulnerability assessment scan error.
type VulnerabilityAssessmentScanError struct {
	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// VulnerabilityAssessmentScanRecord - A vulnerability assessment scan record.
type VulnerabilityAssessmentScanRecord struct {
	// Resource properties.
	Properties *VulnerabilityAssessmentScanRecordProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VulnerabilityAssessmentScanRecordListResult - A list of vulnerability assessment scan records.
type VulnerabilityAssessmentScanRecordListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*VulnerabilityAssessmentScanRecord `json:"value,omitempty" azure:"ro"`
}

// VulnerabilityAssessmentScanRecordProperties - Properties of a vulnerability assessment scan record.
type VulnerabilityAssessmentScanRecordProperties struct {
	// READ-ONLY; The scan end time (UTC).
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The scan errors.
	Errors []*VulnerabilityAssessmentScanError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; The number of failed security checks.
	NumberOfFailedSecurityChecks *int32 `json:"numberOfFailedSecurityChecks,omitempty" azure:"ro"`

	// READ-ONLY; The scan ID.
	ScanID *string `json:"scanId,omitempty" azure:"ro"`

	// READ-ONLY; The scan start time (UTC).
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The scan status.
	State *VulnerabilityAssessmentScanState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; The scan results storage container path.
	StorageContainerPath *string `json:"storageContainerPath,omitempty" azure:"ro"`

	// READ-ONLY; The scan trigger type.
	TriggerType *VulnerabilityAssessmentScanTriggerType `json:"triggerType,omitempty" azure:"ro"`
}

// WorkloadClassifier - Workload classifier operations for a data warehouse
type WorkloadClassifier struct {
	// Resource properties.
	Properties *WorkloadClassifierProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadClassifierListResult - A list of workload classifiers for a workload group.
type WorkloadClassifierListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*WorkloadClassifier `json:"value,omitempty" azure:"ro"`
}

// WorkloadClassifierProperties - Workload classifier definition. For more information look at sys.workloadmanagementworkload_classifiers
// (DMV).
type WorkloadClassifierProperties struct {
	// REQUIRED; The workload classifier member name.
	MemberName *string `json:"memberName,omitempty"`

	// The workload classifier context.
	Context *string `json:"context,omitempty"`

	// The workload classifier end time for classification.
	EndTime *string `json:"endTime,omitempty"`

	// The workload classifier importance.
	Importance *string `json:"importance,omitempty"`

	// The workload classifier label.
	Label *string `json:"label,omitempty"`

	// The workload classifier start time for classification.
	StartTime *string `json:"startTime,omitempty"`
}

// WorkloadGroup - Workload group operations for a sql pool
type WorkloadGroup struct {
	// Resource properties.
	Properties *WorkloadGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadGroupListResult - A list of workload groups.
type WorkloadGroupListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*WorkloadGroup `json:"value,omitempty" azure:"ro"`
}

// WorkloadGroupProperties - Workload group definition. For more information look at sys.workloadmanagementworkload_groups
// (DMV).
type WorkloadGroupProperties struct {
	// REQUIRED; The workload group cap percentage resource.
	MaxResourcePercent *int32 `json:"maxResourcePercent,omitempty"`

	// REQUIRED; The workload group minimum percentage resource.
	MinResourcePercent *int32 `json:"minResourcePercent,omitempty"`

	// REQUIRED; The workload group request minimum grant percentage.
	MinResourcePercentPerRequest *float64 `json:"minResourcePercentPerRequest,omitempty"`

	// The workload group importance level.
	Importance *string `json:"importance,omitempty"`

	// The workload group request maximum grant percentage.
	MaxResourcePercentPerRequest *float64 `json:"maxResourcePercentPerRequest,omitempty"`

	// The workload group query execution timeout.
	QueryExecutionTimeout *int32 `json:"queryExecutionTimeout,omitempty"`
}

// Workspace - A workspace
type Workspace struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Identity of the workspace
	Identity *ManagedIdentity `json:"identity,omitempty"`

	// Workspace resource properties
	Properties *WorkspaceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkspaceAADAdminInfo - Workspace active directory administrator
type WorkspaceAADAdminInfo struct {
	// Workspace active directory administrator properties
	Properties *AADAdminProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkspaceAADAdminsClientBeginCreateOrUpdateOptions contains the optional parameters for the WorkspaceAADAdminsClient.BeginCreateOrUpdate
// method.
type WorkspaceAADAdminsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspaceAADAdminsClientBeginDeleteOptions contains the optional parameters for the WorkspaceAADAdminsClient.BeginDelete
// method.
type WorkspaceAADAdminsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspaceAADAdminsClientGetOptions contains the optional parameters for the WorkspaceAADAdminsClient.Get method.
type WorkspaceAADAdminsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceInfoListResult - List of workspaces
type WorkspaceInfoListResult struct {
	// Link to the next page of results
	NextLink *string `json:"nextLink,omitempty"`

	// List of workspaces
	Value []*Workspace `json:"value,omitempty"`
}

// WorkspaceKeyDetails - Details of the customer managed key associated with the workspace
type WorkspaceKeyDetails struct {
	// Workspace Key sub-resource key vault url
	KeyVaultURL *string `json:"keyVaultUrl,omitempty"`

	// Workspace Key sub-resource name
	Name *string `json:"name,omitempty"`
}

// WorkspaceManagedIdentitySQLControlSettingsClientBeginCreateOrUpdateOptions contains the optional parameters for the WorkspaceManagedIdentitySQLControlSettingsClient.BeginCreateOrUpdate
// method.
type WorkspaceManagedIdentitySQLControlSettingsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspaceManagedIdentitySQLControlSettingsClientGetOptions contains the optional parameters for the WorkspaceManagedIdentitySQLControlSettingsClient.Get
// method.
type WorkspaceManagedIdentitySQLControlSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerBlobAuditingPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the
// WorkspaceManagedSQLServerBlobAuditingPoliciesClient.BeginCreateOrUpdate method.
type WorkspaceManagedSQLServerBlobAuditingPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspaceManagedSQLServerBlobAuditingPoliciesClientGetOptions contains the optional parameters for the WorkspaceManagedSQLServerBlobAuditingPoliciesClient.Get
// method.
type WorkspaceManagedSQLServerBlobAuditingPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerBlobAuditingPoliciesClientListByWorkspaceOptions contains the optional parameters for the WorkspaceManagedSQLServerBlobAuditingPoliciesClient.ListByWorkspace
// method.
type WorkspaceManagedSQLServerBlobAuditingPoliciesClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientBeginUpdateOptions contains the optional parameters for the
// WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient.BeginUpdate method.
type WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientGetOptions contains the optional parameters for the WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient.Get
// method.
type WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientListOptions contains the optional parameters for the WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient.List
// method.
type WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerEncryptionProtectorClientBeginCreateOrUpdateOptions contains the optional parameters for the WorkspaceManagedSQLServerEncryptionProtectorClient.BeginCreateOrUpdate
// method.
type WorkspaceManagedSQLServerEncryptionProtectorClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspaceManagedSQLServerEncryptionProtectorClientBeginRevalidateOptions contains the optional parameters for the WorkspaceManagedSQLServerEncryptionProtectorClient.BeginRevalidate
// method.
type WorkspaceManagedSQLServerEncryptionProtectorClientBeginRevalidateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspaceManagedSQLServerEncryptionProtectorClientGetOptions contains the optional parameters for the WorkspaceManagedSQLServerEncryptionProtectorClient.Get
// method.
type WorkspaceManagedSQLServerEncryptionProtectorClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerEncryptionProtectorClientListOptions contains the optional parameters for the WorkspaceManagedSQLServerEncryptionProtectorClient.List
// method.
type WorkspaceManagedSQLServerEncryptionProtectorClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters
// for the WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient.BeginCreateOrUpdate method.
type WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClientGetOptions contains the optional parameters for the WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient.Get
// method.
type WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClientListByWorkspaceOptions contains the optional parameters for
// the WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient.ListByWorkspace method.
type WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerRecoverableSQLPoolsClientGetOptions contains the optional parameters for the WorkspaceManagedSQLServerRecoverableSQLPoolsClient.Get
// method.
type WorkspaceManagedSQLServerRecoverableSQLPoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerRecoverableSQLPoolsClientListOptions contains the optional parameters for the WorkspaceManagedSQLServerRecoverableSQLPoolsClient.List
// method.
type WorkspaceManagedSQLServerRecoverableSQLPoolsClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerSecurityAlertPolicyClientBeginCreateOrUpdateOptions contains the optional parameters for the WorkspaceManagedSQLServerSecurityAlertPolicyClient.BeginCreateOrUpdate
// method.
type WorkspaceManagedSQLServerSecurityAlertPolicyClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspaceManagedSQLServerSecurityAlertPolicyClientGetOptions contains the optional parameters for the WorkspaceManagedSQLServerSecurityAlertPolicyClient.Get
// method.
type WorkspaceManagedSQLServerSecurityAlertPolicyClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerSecurityAlertPolicyClientListOptions contains the optional parameters for the WorkspaceManagedSQLServerSecurityAlertPolicyClient.List
// method.
type WorkspaceManagedSQLServerSecurityAlertPolicyClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerUsagesClientListOptions contains the optional parameters for the WorkspaceManagedSQLServerUsagesClient.List
// method.
type WorkspaceManagedSQLServerUsagesClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerVulnerabilityAssessmentsClientCreateOrUpdateOptions contains the optional parameters for the WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.CreateOrUpdate
// method.
type WorkspaceManagedSQLServerVulnerabilityAssessmentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerVulnerabilityAssessmentsClientDeleteOptions contains the optional parameters for the WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.Delete
// method.
type WorkspaceManagedSQLServerVulnerabilityAssessmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerVulnerabilityAssessmentsClientGetOptions contains the optional parameters for the WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.Get
// method.
type WorkspaceManagedSQLServerVulnerabilityAssessmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceManagedSQLServerVulnerabilityAssessmentsClientListOptions contains the optional parameters for the WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.List
// method.
type WorkspaceManagedSQLServerVulnerabilityAssessmentsClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkspacePatchInfo - Workspace patch details
type WorkspacePatchInfo struct {
	// The identity of the workspace
	Identity *ManagedIdentity `json:"identity,omitempty"`

	// Workspace patch properties
	Properties *WorkspacePatchProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// WorkspacePatchProperties - Workspace patch properties
type WorkspacePatchProperties struct {
	// The encryption details of the workspace
	Encryption *EncryptionDetails `json:"encryption,omitempty"`

	// Managed Virtual Network Settings
	ManagedVirtualNetworkSettings *ManagedVirtualNetworkSettings `json:"managedVirtualNetworkSettings,omitempty"`

	// Enable or Disable public network access to workspace
	PublicNetworkAccess *WorkspacePublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Purview Configuration
	PurviewConfiguration *PurviewConfiguration `json:"purviewConfiguration,omitempty"`

	// SQL administrator login password
	SQLAdministratorLoginPassword *string `json:"sqlAdministratorLoginPassword,omitempty"`

	// Git integration settings
	WorkspaceRepositoryConfiguration *WorkspaceRepositoryConfiguration `json:"workspaceRepositoryConfiguration,omitempty"`

	// READ-ONLY; Resource provisioning state
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// WorkspaceProperties - Workspace properties
type WorkspaceProperties struct {
	// Enable or Disable AzureADOnlyAuthentication on All Workspace subresource
	AzureADOnlyAuthentication *bool `json:"azureADOnlyAuthentication,omitempty"`

	// Connectivity endpoints
	ConnectivityEndpoints map[string]*string `json:"connectivityEndpoints,omitempty"`

	// Initial workspace AAD admin properties for a CSP subscription
	CspWorkspaceAdminProperties *CspWorkspaceAdminProperties `json:"cspWorkspaceAdminProperties,omitempty"`

	// Workspace default data lake storage account details
	DefaultDataLakeStorage *DataLakeStorageAccountDetails `json:"defaultDataLakeStorage,omitempty"`

	// The encryption details of the workspace
	Encryption *EncryptionDetails `json:"encryption,omitempty"`

	// Workspace managed resource group. The resource group name uniquely identifies the resource group within the user subscriptionId.
	// The resource group name must be no longer than 90 characters long, and
	// must be alphanumeric characters (Char.IsLetterOrDigit()) and '-', '_', '(', ')' and'.'. Note that the name cannot end with
	// '.'
	ManagedResourceGroupName *string `json:"managedResourceGroupName,omitempty"`

	// Setting this to 'default' will ensure that all compute for this workspace is in a virtual network managed on behalf of
	// the user.
	ManagedVirtualNetwork *string `json:"managedVirtualNetwork,omitempty"`

	// Managed Virtual Network Settings
	ManagedVirtualNetworkSettings *ManagedVirtualNetworkSettings `json:"managedVirtualNetworkSettings,omitempty"`

	// Private endpoint connections to the workspace
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`

	// Enable or Disable public network access to workspace
	PublicNetworkAccess *WorkspacePublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Purview Configuration
	PurviewConfiguration *PurviewConfiguration `json:"purviewConfiguration,omitempty"`

	// Login for workspace SQL active directory administrator
	SQLAdministratorLogin *string `json:"sqlAdministratorLogin,omitempty"`

	// SQL administrator login password
	SQLAdministratorLoginPassword *string `json:"sqlAdministratorLoginPassword,omitempty"`

	// Is trustedServiceBypassEnabled for the workspace
	TrustedServiceBypassEnabled *bool `json:"trustedServiceBypassEnabled,omitempty"`

	// Virtual Network profile
	VirtualNetworkProfile *VirtualNetworkProfile `json:"virtualNetworkProfile,omitempty"`

	// Git integration settings
	WorkspaceRepositoryConfiguration *WorkspaceRepositoryConfiguration `json:"workspaceRepositoryConfiguration,omitempty"`

	// READ-ONLY; The ADLA resource ID.
	AdlaResourceID *string `json:"adlaResourceId,omitempty" azure:"ro"`

	// READ-ONLY; Workspace level configs and feature flags
	ExtraProperties map[string]interface{} `json:"extraProperties,omitempty" azure:"ro"`

	// READ-ONLY; Resource provisioning state
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Workspace settings
	Settings map[string]interface{} `json:"settings,omitempty" azure:"ro"`

	// READ-ONLY; The workspace unique identifier
	WorkspaceUID *string `json:"workspaceUID,omitempty" azure:"ro"`
}

// WorkspaceRepositoryConfiguration - Git integration settings
type WorkspaceRepositoryConfiguration struct {
	// Account name
	AccountName *string `json:"accountName,omitempty"`

	// Collaboration branch
	CollaborationBranch *string `json:"collaborationBranch,omitempty"`

	// GitHub Enterprise host name. For example: https://github.mydomain.com
	HostName *string `json:"hostName,omitempty"`

	// The last commit ID
	LastCommitID *string `json:"lastCommitId,omitempty"`

	// VSTS project name
	ProjectName *string `json:"projectName,omitempty"`

	// Repository name
	RepositoryName *string `json:"repositoryName,omitempty"`

	// Root folder to use in the repository
	RootFolder *string `json:"rootFolder,omitempty"`

	// The VSTS tenant ID
	TenantID *string `json:"tenantId,omitempty"`

	// Type of workspace repositoryID configuration. Example WorkspaceVSTSConfiguration, WorkspaceGitHubConfiguration
	Type *string `json:"type,omitempty"`
}

// WorkspaceSQLAADAdminsClientBeginCreateOrUpdateOptions contains the optional parameters for the WorkspaceSQLAADAdminsClient.BeginCreateOrUpdate
// method.
type WorkspaceSQLAADAdminsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspaceSQLAADAdminsClientBeginDeleteOptions contains the optional parameters for the WorkspaceSQLAADAdminsClient.BeginDelete
// method.
type WorkspaceSQLAADAdminsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspaceSQLAADAdminsClientGetOptions contains the optional parameters for the WorkspaceSQLAADAdminsClient.Get method.
type WorkspaceSQLAADAdminsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientBeginCreateOrUpdateOptions contains the optional parameters for the WorkspacesClient.BeginCreateOrUpdate
// method.
type WorkspacesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacesClientBeginDeleteOptions contains the optional parameters for the WorkspacesClient.BeginDelete method.
type WorkspacesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacesClientBeginUpdateOptions contains the optional parameters for the WorkspacesClient.BeginUpdate method.
type WorkspacesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacesClientGetOptions contains the optional parameters for the WorkspacesClient.Get method.
type WorkspacesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientListByResourceGroupOptions contains the optional parameters for the WorkspacesClient.ListByResourceGroup
// method.
type WorkspacesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientListOptions contains the optional parameters for the WorkspacesClient.List method.
type WorkspacesClientListOptions struct {
	// placeholder for future optional parameters
}
