//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdelegatednetwork

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// OrchestratorInstanceServiceClient contains the methods for the OrchestratorInstanceService group.
// Don't use this type directly, use NewOrchestratorInstanceServiceClient() instead.
type OrchestratorInstanceServiceClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewOrchestratorInstanceServiceClient creates a new instance of OrchestratorInstanceServiceClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewOrchestratorInstanceServiceClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*OrchestratorInstanceServiceClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &OrchestratorInstanceServiceClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreate - Create a orchestrator instance
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
// resourceGroupName - The name of the resource group. The name is case insensitive.
// resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
// parameters - OrchestratorInstance type parameters
// options - OrchestratorInstanceServiceClientBeginCreateOptions contains the optional parameters for the OrchestratorInstanceServiceClient.BeginCreate
// method.
func (client *OrchestratorInstanceServiceClient) BeginCreate(ctx context.Context, resourceGroupName string, resourceName string, parameters Orchestrator, options *OrchestratorInstanceServiceClientBeginCreateOptions) (*runtime.Poller[OrchestratorInstanceServiceClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, resourceName, parameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[OrchestratorInstanceServiceClientCreateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[OrchestratorInstanceServiceClientCreateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Create - Create a orchestrator instance
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
func (client *OrchestratorInstanceServiceClient) create(ctx context.Context, resourceGroupName string, resourceName string, parameters Orchestrator, options *OrchestratorInstanceServiceClientBeginCreateOptions) (*http.Response, error) {
	req, err := client.createCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createCreateRequest creates the Create request.
func (client *OrchestratorInstanceServiceClient) createCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters Orchestrator, options *OrchestratorInstanceServiceClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/orchestrators/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// BeginDelete - Deletes the Orchestrator Instance
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
// resourceGroupName - The name of the resource group. The name is case insensitive.
// resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
// options - OrchestratorInstanceServiceClientBeginDeleteOptions contains the optional parameters for the OrchestratorInstanceServiceClient.BeginDelete
// method.
func (client *OrchestratorInstanceServiceClient) BeginDelete(ctx context.Context, resourceGroupName string, resourceName string, options *OrchestratorInstanceServiceClientBeginDeleteOptions) (*runtime.Poller[OrchestratorInstanceServiceClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, resourceName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[OrchestratorInstanceServiceClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[OrchestratorInstanceServiceClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Deletes the Orchestrator Instance
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
func (client *OrchestratorInstanceServiceClient) deleteOperation(ctx context.Context, resourceGroupName string, resourceName string, options *OrchestratorInstanceServiceClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *OrchestratorInstanceServiceClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *OrchestratorInstanceServiceClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/orchestrators/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	if options != nil && options.ForceDelete != nil {
		reqQP.Set("forceDelete", strconv.FormatBool(*options.ForceDelete))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetDetails - Gets details about the orchestrator instance.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
// resourceGroupName - The name of the resource group. The name is case insensitive.
// resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
// options - OrchestratorInstanceServiceClientGetDetailsOptions contains the optional parameters for the OrchestratorInstanceServiceClient.GetDetails
// method.
func (client *OrchestratorInstanceServiceClient) GetDetails(ctx context.Context, resourceGroupName string, resourceName string, options *OrchestratorInstanceServiceClientGetDetailsOptions) (OrchestratorInstanceServiceClientGetDetailsResponse, error) {
	req, err := client.getDetailsCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return OrchestratorInstanceServiceClientGetDetailsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return OrchestratorInstanceServiceClientGetDetailsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return OrchestratorInstanceServiceClientGetDetailsResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDetailsHandleResponse(resp)
}

// getDetailsCreateRequest creates the GetDetails request.
func (client *OrchestratorInstanceServiceClient) getDetailsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *OrchestratorInstanceServiceClientGetDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/orchestrators/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDetailsHandleResponse handles the GetDetails response.
func (client *OrchestratorInstanceServiceClient) getDetailsHandleResponse(resp *http.Response) (OrchestratorInstanceServiceClientGetDetailsResponse, error) {
	result := OrchestratorInstanceServiceClientGetDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Orchestrator); err != nil {
		return OrchestratorInstanceServiceClientGetDetailsResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Get all the OrchestratorInstances resources in a resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - OrchestratorInstanceServiceClientListByResourceGroupOptions contains the optional parameters for the OrchestratorInstanceServiceClient.ListByResourceGroup
// method.
func (client *OrchestratorInstanceServiceClient) NewListByResourceGroupPager(resourceGroupName string, options *OrchestratorInstanceServiceClientListByResourceGroupOptions) *runtime.Pager[OrchestratorInstanceServiceClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[OrchestratorInstanceServiceClientListByResourceGroupResponse]{
		More: func(page OrchestratorInstanceServiceClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *OrchestratorInstanceServiceClientListByResourceGroupResponse) (OrchestratorInstanceServiceClientListByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return OrchestratorInstanceServiceClientListByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return OrchestratorInstanceServiceClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return OrchestratorInstanceServiceClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *OrchestratorInstanceServiceClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *OrchestratorInstanceServiceClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/orchestrators"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *OrchestratorInstanceServiceClient) listByResourceGroupHandleResponse(resp *http.Response) (OrchestratorInstanceServiceClientListByResourceGroupResponse, error) {
	result := OrchestratorInstanceServiceClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Orchestrators); err != nil {
		return OrchestratorInstanceServiceClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - Get all the orchestratorInstance resources in a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
// options - OrchestratorInstanceServiceClientListBySubscriptionOptions contains the optional parameters for the OrchestratorInstanceServiceClient.ListBySubscription
// method.
func (client *OrchestratorInstanceServiceClient) NewListBySubscriptionPager(options *OrchestratorInstanceServiceClientListBySubscriptionOptions) *runtime.Pager[OrchestratorInstanceServiceClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[OrchestratorInstanceServiceClientListBySubscriptionResponse]{
		More: func(page OrchestratorInstanceServiceClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *OrchestratorInstanceServiceClientListBySubscriptionResponse) (OrchestratorInstanceServiceClientListBySubscriptionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listBySubscriptionCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return OrchestratorInstanceServiceClientListBySubscriptionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return OrchestratorInstanceServiceClientListBySubscriptionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return OrchestratorInstanceServiceClientListBySubscriptionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *OrchestratorInstanceServiceClient) listBySubscriptionCreateRequest(ctx context.Context, options *OrchestratorInstanceServiceClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DelegatedNetwork/orchestrators"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *OrchestratorInstanceServiceClient) listBySubscriptionHandleResponse(resp *http.Response) (OrchestratorInstanceServiceClientListBySubscriptionResponse, error) {
	result := OrchestratorInstanceServiceClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Orchestrators); err != nil {
		return OrchestratorInstanceServiceClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// Patch - Update Orchestrator Instance
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
// resourceGroupName - The name of the resource group. The name is case insensitive.
// resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
// parameters - OrchestratorInstance update parameters
// options - OrchestratorInstanceServiceClientPatchOptions contains the optional parameters for the OrchestratorInstanceServiceClient.Patch
// method.
func (client *OrchestratorInstanceServiceClient) Patch(ctx context.Context, resourceGroupName string, resourceName string, parameters OrchestratorResourceUpdateParameters, options *OrchestratorInstanceServiceClientPatchOptions) (OrchestratorInstanceServiceClientPatchResponse, error) {
	req, err := client.patchCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return OrchestratorInstanceServiceClientPatchResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return OrchestratorInstanceServiceClientPatchResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return OrchestratorInstanceServiceClientPatchResponse{}, runtime.NewResponseError(resp)
	}
	return client.patchHandleResponse(resp)
}

// patchCreateRequest creates the Patch request.
func (client *OrchestratorInstanceServiceClient) patchCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters OrchestratorResourceUpdateParameters, options *OrchestratorInstanceServiceClientPatchOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/orchestrators/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// patchHandleResponse handles the Patch response.
func (client *OrchestratorInstanceServiceClient) patchHandleResponse(resp *http.Response) (OrchestratorInstanceServiceClientPatchResponse, error) {
	result := OrchestratorInstanceServiceClientPatchResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Orchestrator); err != nil {
		return OrchestratorInstanceServiceClientPatchResponse{}, err
	}
	return result, nil
}
