#############################################################################
##
#W bgnilp.gi                     Polycyc                         Bettina Eick
##

#############################################################################
##
#F This is a set of nilpotent groups defined by Burde und Grunewald.
##
InstallGlobalFunction( BurdeGrunewaldPcpGroup, function( s, t )
    local F, k3, k4, k5, k6, k7, k8, k9, k10, k11, G;

    F := FromTheLeftCollector( 11 );

    k11 := 2*(203230225 - 12930435*s + 677376*s^2 + 4372200*t);
    k10 := -2267555 + 151088*s - 126000*t;
    k9 := 6*(-1108 - 525*s - 1400*t);
    k8 := 4*(79 - 60*s);
    k7 := 109;
    k6 := -5;
    k5 := 2;
    k4 := 1;
    k3 := -1;
    SetConjugate( F, 2, 1, [2,1,3,k3,4,k4,5,k5,6,k6,7,k7,8,k8,9,k9,
                            10,k10,11,k11] );

    k11 := 180*(-5202055 + 135870*s + 18816*s^2 - 190050*t);
    k10 := 80*(45515 - 3066*s + 3150*t);
    k9 := 35*(829 + 180*s - 360*t);
    k8 := 6*(-91 - 60*s);
    k7 := 185;
    k6 := -4;
    k5 := 3;
    k4 := -2;
    SetConjugate( F, 3, 1, [3,1,4,k4,5,k5,6,k6,7,k7,8,k8,9,k9,
                            10,k10,11,k11] );

    k11 := 3780*(-41975 - 13035*s - 2688*s^2 + 5150*t);
    k10 := 6720*(-585 - 28*s - 75*t);
    k9 := 840*(-26 - 15*s + 15*t);
    k8 := 360*(3 + s);
    k7 := -120;
    k5 := -6;
    SetConjugate( F, 3, 2, [3,1,5,k5,7,k7,8,k8,9,k9,
                            10,k10,11,k11] );

    k11 := 90*(836225 + 60480*s + 28224*s^2 - 222075*t);
    k10 := 140*(-2425 -  864*s);
    k9 := 16905;
    k8 := 15;
    k7 := -10;
    k6 :=6;
    k5 :=-3;
    SetConjugate( F, 4, 1, [4,1,5,k5,6,k6,7,k7,8,k8,9,k9,
                            10,k10,11,k11] );

    k11 := 13494600*s;
    k10 := 8400*(341 + 60*t);
    k9 := 12600*s;
    k8 := -900;
    k6 := -12;
    SetConjugate( F, 4, 2, [4,1,6,k6,8,k8,9,k9,10,k10,11,k11] );

    k11 := -85050*(4725 + 334*s);
    k10 := -5896800;
    k9 := 12600*t;
    k8 := 360*s;
    k7 := -180;
    SetConjugate( F, 4, 3, [4,1,7,k7,8,k8,9,k9,10,k10,11,k11] );

    k11 := 21708750;
    k10 := -1400;
    k9 := 175;
    k8 := -20;
    k7 := 10;
    k6 := -4;
    SetConjugate( F, 5, 1, [5,1,6,k6,7,k7,8,k8,9,k9,10,k10,11,k11] );

    k11 := 1260*(-12350 + 4032*s^2 - 7725*t);
    k10 := 94080*s;
    k9 := 840*(13 - 5*t);
    k8 := -120*s;
    k7 := 40;
    SetConjugate( F, 5, 2, [5,1,7,k7,8,k8,9,k9,10,k10,11,k11] );

    k11 := 91003500;
    k10 := 168000*t;
    k9 :=  4200*s;
    k8 :=  -360;
    SetConjugate( F, 5, 3, [5,1,8,k8,9,k9,10,k10,11,k11] );

    k11 :=  3780*(-448*s^2 + 3525*t);
    k10 :=  80640*s;
    k9 :=  -11340 ;
    SetConjugate( F, 5, 4, [5,1,9,k9,10,k10,11,k11] );

    k11 := -31500;
    k10 := 1750;
    k9 := -175;
    k8 := 15;
    k7 := -5;
    SetConjugate( F, 6, 1, [6,1,7,k7,8,k8,9,k9,10,k10,11,k11] );

    k11 := -6095250*s;
    k10 := 42000*(-13 - 2*t);
    k9 := -2100*s;
    k8 := 150;
    SetConjugate( F, 6, 2, [6,1,8,k8,9,k9,10,k10,11,k11] );

    k11 := 1890*(448*s^2 - 1525*t);
    k10 := 1680*s;
    k9 := 2520;
    SetConjugate( F, 6, 3, [6,1,9,k9,10,k10,11,k11] );

    k11 := 1814400*s;
    k10 := -113400;
    SetConjugate( F, 6, 4, [6,1,10,k10,11,k11] );

    k11 := -10843875;
    SetConjugate( F, 6, 5, [6,1,11,k11] );

    k11 := 31500;
    k10 := -1400;
    k9 := 105;
    k8 := -6;
    SetConjugate( F, 7, 1, [7,1,8,k8,9,k9,10,k10,11,k11] );

    k11 := 189*(-6175 - 896*s^2 - 4950*t);
    k10 := -17136*s;
    k9 := 546;
    SetConjugate( F, 7, 2, [7,1,9,k9,10,k10,11,k11] );

    k11 := -695520*s;
    k10 := 65520;
    SetConjugate( F, 7, 3, [7,1,10,k10,11,k11] );

    k11 := 4465125;
    SetConjugate( F, 7, 4, [7,1,11,k11] );

    k11 := -21000;
    k10 := 700;
    k9 := -35;
    SetConjugate( F, 8, 1, [8,1,9,k9,10,k10,11,k11] );

    k11 := -141120*s;
    k10 := -7280;
    SetConjugate( F, 8, 2, [8,1,10,k10,11,k11] );

    k11 := -505575;
    SetConjugate( F, 8, 3, [8,1,11,k11] );

    k11 := 1800;
    k10 := -40;
    SetConjugate( F, 9, 1, [9,1,10,k10,11,k11] );

    k11 := -4275;
    SetConjugate( F, 9, 2, [9,1,11,k11] );

    k11 := -90;
    SetConjugate( F, 10, 1, [10,1,11,k11] );

    G := PcpGroupByCollector( F );
    return G;
end );

