(include "#.scm")

(check-equal? (string->utf8 "ABC") '#u8(65 66 67))
(check-equal? (string->utf8 "ABC" 0) '#u8(65 66 67))
(check-equal? (string->utf8 "ABC" 3) '#u8())
(check-equal? (string->utf8 "ABC" 1 2) '#u8(66))
(check-equal? (string->utf8 "ABC" 1 3) '#u8(66 67))
(check-equal? (string->utf8 "ABC" 3 3) '#u8())

(check-equal? (string->utf8 "") '#u8())
(check-equal? (string->utf8 "\x0;") '#u8(#x00))
(check-equal? (string->utf8 "\x7f;") '#u8(#x7F))
(check-equal? (string->utf8 "\x80;") '#u8(#xC2 #x80))
(check-equal? (string->utf8 "\xbf;") '#u8(#xC2 #xBF))
(check-equal? (string->utf8 "\x7c0;") '#u8(#xDF #x80))
(check-equal? (string->utf8 "\x7ff;") '#u8(#xDF #xBF))
(check-equal? (string->utf8 "\x800;") '#u8(#xE0 #xA0 #x80))
(check-equal? (string->utf8 "\x83f;") '#u8(#xE0 #xA0 #xBF))
(check-equal? (string->utf8 "\xfc0;") '#u8(#xE0 #xBF #x80))
(check-equal? (string->utf8 "\xfff;") '#u8(#xE0 #xBF #xBF))
(check-equal? (string->utf8 "\x1000;") '#u8(#xE1 #x80 #x80))
(check-equal? (string->utf8 "\x103f;") '#u8(#xE1 #x80 #xBF))
(check-equal? (string->utf8 "\x1fc0;") '#u8(#xE1 #xBF #x80))
(check-equal? (string->utf8 "\x1fff;") '#u8(#xE1 #xBF #xBF))
(check-equal? (string->utf8 "\xf000;") '#u8(#xEF #x80 #x80))
(check-equal? (string->utf8 "\xf03f;") '#u8(#xEF #x80 #xBF))
(check-equal? (string->utf8 "\xffc0;") '#u8(#xEF #xBF #x80))
(check-equal? (string->utf8 "\xffff;") '#u8(#xEF #xBF #xBF))
(check-equal? (string->utf8 "\xd7ff;") '#u8(#xED #x9F #xBF))
(check-equal? (string->utf8 "\xe000;") '#u8(#xEE #x80 #x80))
(check-equal? (string->utf8 "\x10000;") '#u8(#xF0 #x90 #x80 #x80))
(check-equal? (string->utf8 "\x1003f;") '#u8(#xF0 #x90 #x80 #xBF))
(check-equal? (string->utf8 "\x10fc0;") '#u8(#xF0 #x90 #xBF #x80))
(check-equal? (string->utf8 "\x10fff;") '#u8(#xF0 #x90 #xBF #xBF))
(check-equal? (string->utf8 "\x3f000;") '#u8(#xF0 #xBF #x80 #x80))
(check-equal? (string->utf8 "\x3f03f;") '#u8(#xF0 #xBF #x80 #xBF))
(check-equal? (string->utf8 "\x3ffc0;") '#u8(#xF0 #xBF #xBF #x80))
(check-equal? (string->utf8 "\x3ffff;") '#u8(#xF0 #xBF #xBF #xBF))
(check-equal? (string->utf8 "\x40000;") '#u8(#xF1 #x80 #x80 #x80))
(check-equal? (string->utf8 "\x4003f;") '#u8(#xF1 #x80 #x80 #xBF))
(check-equal? (string->utf8 "\x40fc0;") '#u8(#xF1 #x80 #xBF #x80))
(check-equal? (string->utf8 "\x40fff;") '#u8(#xF1 #x80 #xBF #xBF))
(check-equal? (string->utf8 "\x7f000;") '#u8(#xF1 #xBF #x80 #x80))
(check-equal? (string->utf8 "\x7f03f;") '#u8(#xF1 #xBF #x80 #xBF))
(check-equal? (string->utf8 "\x7ffc0;") '#u8(#xF1 #xBF #xBF #x80))
(check-equal? (string->utf8 "\x7ffff;") '#u8(#xF1 #xBF #xBF #xBF))
(check-equal? (string->utf8 "\xc0000;") '#u8(#xF3 #x80 #x80 #x80))
(check-equal? (string->utf8 "\xc003f;") '#u8(#xF3 #x80 #x80 #xBF))
(check-equal? (string->utf8 "\xc0fc0;") '#u8(#xF3 #x80 #xBF #x80))
(check-equal? (string->utf8 "\xc0fff;") '#u8(#xF3 #x80 #xBF #xBF))
(check-equal? (string->utf8 "\xff000;") '#u8(#xF3 #xBF #x80 #x80))
(check-equal? (string->utf8 "\xff03f;") '#u8(#xF3 #xBF #x80 #xBF))
(check-equal? (string->utf8 "\xfffc0;") '#u8(#xF3 #xBF #xBF #x80))
(check-equal? (string->utf8 "\xfffff;") '#u8(#xF3 #xBF #xBF #xBF))
(check-equal? (string->utf8 "\x100000;") '#u8(#xF4 #x80 #x80 #x80))
(check-equal? (string->utf8 "\x10003f;") '#u8(#xF4 #x80 #x80 #xBF))
(check-equal? (string->utf8 "\x100fc0;") '#u8(#xF4 #x80 #xBF #x80))
(check-equal? (string->utf8 "\x100fff;") '#u8(#xF4 #x80 #xBF #xBF))
(check-equal? (string->utf8 "\x10f000;") '#u8(#xF4 #x8F #x80 #x80))
(check-equal? (string->utf8 "\x10f03f;") '#u8(#xF4 #x8F #x80 #xBF))
(check-equal? (string->utf8 "\x10ffc0;") '#u8(#xF4 #x8F #xBF #x80))
(check-equal? (string->utf8 "\x10ffff;") '#u8(#xF4 #x8F #xBF #xBF))

(check-tail-exn type-exception? (lambda () (string->utf8 #f)))
(check-tail-exn type-exception? (lambda () (string->utf8 "ABC" #f)))
(check-tail-exn type-exception? (lambda () (string->utf8 "ABC" 0 #f)))

(check-tail-exn range-exception? (lambda () (string->utf8 "ABC" -1)))
(check-tail-exn range-exception? (lambda () (string->utf8 "ABC" 4)))
(check-tail-exn range-exception? (lambda () (string->utf8 "ABC" 0 4)))

(check-tail-exn wrong-number-of-arguments-exception? (lambda () (string->utf8)))
(check-tail-exn wrong-number-of-arguments-exception? (lambda () (string->utf8 "" 0 0 0)))
