#!/bin/sh


set -eu

SRC_BRANCH=upstream-git/master

HEAD=`git log --format=oneline $SRC_BRANCH -1|head -1|cut -d" " -f1`
REV=`git log --format=oneline --abbrev-commit -1 $HEAD | cut -f1 -d' '`
DATE=`git show --pretty=format:%ai $HEAD | awk '{print $1; exit;}'|sed 's/-//g'`

echo $SRC_BRANCH head is $HEAD, r$REV from $DATE

if [ -n "${1:-}" ];
then
    echo Syntax: $0
    exit 1
fi

upstream_ver() {
    COMPONENT=$1
    RES=`git show $SRC_BRANCH:src/frversion.h | awk "/^#define FR_VERSION_$COMPONENT / { print \\$3 }"`
    if [ -z "$RES" ]; then
        echo "FR_VERSION_$COMPONENT not found in $SRC_BRANCH:src/frversion.h:"
        git show $SRC_BRANCH:src/frversion.h
        exit 1
    else
        echo $RES
    fi
}

VER=`upstream_ver MAJOR`.`upstream_ver MINOR`.`upstream_ver RLS`

ORIG="flamerobin_$VER~+${DATE}.${REV}.orig"

echo "Version is $VER"

TMP=`mktemp -d`

trap "rm -rf $TMP" 0 EXIT TERM QUIT

git archive --format=tar --prefix=$ORIG/ $HEAD \
    | tar -C $TMP -x

REVISIONINFOFILE=$TMP/$ORIG/src/revisioninfo.h
echo "// auto-generated by debian/pack-upstream-snapshot.sh" > $REVISIONINFOFILE
echo "Writing git hash $REV to $REVISIONINFOFILE"
echo "#define FR_GIT_HASH \"$REV\"" >> $REVISIONINFOFILE

tar -C $TMP -c $ORIG/ | xz > ../$ORIG.tar.xz

echo ../$ORIG.tar.xz ready.
