/*
 *      fhist - file history and comparison tools
 *      Copyright (C) 2000, 2008, 2010 Peter Miller
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 3 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program. If not, see
 *      <http://www.gnu.org/licenses/>.
 */

#ifndef COMMON_ATTRIB_FORMA_H
#define COMMON_ATTRIB_FORMA_H

#ifdef __GNCU__

#define ATTRIBUTE_FORMAT(x, y) __attribute__ ((__format__ (__printf__, x, y)))
#define ATTRIBUTE_FORMAT_1_2 ATTRIBUTE_FORMAT(1, 2)
#define ATTRIBUTE_FORMAT_2_3 ATTRIBUTE_FORMAT(2, 3)
#define ATTRIBUTE_FORMAT_3_4 ATTRIBUTE_FORMAT(3, 4)
#define ATTRIBUTE_FORMAT_4_5 ATTRIBUTE_FORMAT(4, 5)

#else

#define ATTRIBUTE_FORMAT(x, y)
#define ATTRIBUTE_FORMAT_1_2
#define ATTRIBUTE_FORMAT_2_3
#define ATTRIBUTE_FORMAT_3_4
#define ATTRIBUTE_FORMAT_4_5

#endif

#endif /* COMMON_ATTRIB_FORMA_H */
