/*
Copyright (C) 2021 The Falco Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

*/

#pragma once

class sinsp_container_info;
class sinsp_threadinfo;

#include "container_engine/container_engine_base.h"
#include "container_engine/sinsp_container_type.h"

namespace libsinsp
{
namespace container_engine
{
/**
 * static container can be used in cases where we a-priori know that every thread comes from a
 * single container, for which there is not necessarily an accessible runtime interface, and for
 * which we already know all appropriate metadata statically. It can be used, say, for userspace
 * monitoring inside a single container
 */
class static_container : public container_engine_base
{
public:
	static_container(container_cache_interface& cache,
	                 const std::string& id,
	                 const std::string& name,
	                 const std::string& image);

	bool resolve(sinsp_threadinfo* tinfo, bool query_os_for_missing_info) override;

private:
	std::shared_ptr<sinsp_container_info> m_static_container_info;
};
}  // namespace container_engine
}  // namespace libsinsp
