!{\src2tex{textfont=tt}}
!!****m* etsf_basisdata/etsf_io_basisdata_get
!! NAME
!!  etsf_io_basisdata_get
!!
!! FUNCTION
!!    Read an opened ETSF file to get data related to the given group.
!!    Only associated pointers of argument @folder will be accessed. If any accessed
!!    variable is missing, this routine returns an error (usually an access_mode_id
!!    of argument error_data set to ERROR_MODE_INQ). Any other errors implies a
!!    return with @lstat = .false..
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * ncid = 
!!     integer returned by an 'open' NetCDF call. The file can be 
!!     either in define or write mode. This status can be changed
!!     by the call.
!! * use_atomic_units = (optional) 
!!     set this flag to .true. makes the library use the value of the attribute
!!     scale_to_atomic_units to multiply the read variables (that are units dependent)
!!     by this factor (if different from 1.0d0).
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!! SIDE EFFECTS
!! * folder <type(etsf_basisdata)> = 
!!     an allocated structure with pointers on allocated areas in memory.
!!     These areas will be read or written if the pointer is associated, if
!!     not, the variable will be ignored. It is possible to access to specific
!!     dimensions of a variable using the <short_var_name>__kpoint_access or
!!     <short_var_name>__spin_access of this @folder structure. The 
!!     <short_var_name>__number_of_<something> can also been set if only a subpart
!!     in one dimension should be accessed (this is possible when the specifications
!!     have been declared with a max_number_of_<something>.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_basisdata_get(ncid, folder, lstat, error_data, use_atomic_units)

  !Arguments ------------------------------------
  integer, intent(in) :: ncid
  type(etsf_basisdata), intent(inout) :: folder
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data
  logical, optional, intent(in) :: use_atomic_units

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_basisdata_get'
  logical :: my_use_atomic_units
  integer,allocatable :: varid(:)
  integer,allocatable :: start(:)
  integer,allocatable :: count(:)
  integer :: len
  character(etsf_charlen) :: flag


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_basisdata_get : enter'
!ENDDEBUG

  ! Get values for optional arguments, set default.
  if (present(use_atomic_units)) then
    my_use_atomic_units = use_atomic_units
  else
    my_use_atomic_units = .true.
  end if
  
  allocate(varid(6))
  
  if (associated(folder%basis_set)) then
    call etsf_io_low_read_var(ncid, "basis_set", &
                            & folder%basis_set, etsf_charlen, &
                            & lstat, ncvarid = varid(1), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%kinetic_energy_cutoff)) then
    call etsf_io_low_read_var(ncid, "kinetic_energy_cutoff", &
                            & folder%kinetic_energy_cutoff, &
                            & lstat, ncvarid = varid(2), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%number_of_coefficients)) then
    ! Handle the k_dependent attribute.
    call etsf_io_low_read_att(ncid, "number_of_coefficients", &
                            & "k_dependent", &
                            & etsf_charlen, flag, &
                            & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    if (flag(1:2) == "no") then
      call etsf_io_low_read_dim(ncid, "max_number_of_coefficients", len, &
                              & lstat, error_data = error_data)
      folder%number_of_coefficients = len
    else
      call etsf_io_low_read_var(ncid, "number_of_coefficients", &
                              & folder%number_of_coefficients, &
                              & lstat, ncvarid = varid(3), &
                              & error_data = error_data)
    end if
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%reduced_coordinates_of_plane_waves)) then
    ! Handle the k_dependent attribute.
    call etsf_io_low_read_att(ncid, "reduced_coordinates_of_plane_waves", &
                            & "k_dependent", &
                            & etsf_charlen, flag, &
                            & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    if (flag(1:2) == "no") then
      allocate(start(2), count(2))
    else
      allocate(start(3), count(3))
    end if
    start(:) = 1
    count(:) = 0
    if (flag(1:3) == "yes" .and. &
      & folder%red_coord_pw__kpoint_access /= etsf_no_sub_access) then
      start(3) = folder%red_coord_pw__kpoint_access
      count(3) = 1
    end if
    count(2) = folder%red_coord_pw__number_of_coefficients
    call etsf_io_low_read_var(ncid, "reduced_coordinates_of_plane_waves", &
                            & folder%reduced_coordinates_of_plane_waves, &
                            & lstat, ncvarid = varid(4), &
                            & error_data = error_data, start = start, count = count)
    deallocate(start, count)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%coordinates_of_basis_grid_points)) then
    allocate(start(3), count(3))
    start(:) = 1
    count(:) = 0
    count(2) = folder%coord_grid__number_of_basis_grid_points
    call etsf_io_low_read_var(ncid, "coordinates_of_basis_grid_points", &
                            & folder%coordinates_of_basis_grid_points, &
                            & lstat, ncvarid = varid(5), &
                            & error_data = error_data, start = start, count = count)
    deallocate(start, count)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%number_of_coefficients_per_grid_point)) then
    allocate(start(2), count(2))
    start(:) = 1
    count(:) = 0
    count(1) = folder%n_coeff_grid__number_of_basis_grid_points
    call etsf_io_low_read_var(ncid, "number_of_coefficients_per_grid_point", &
                            & folder%number_of_coefficients_per_grid_point, &
                            & lstat, ncvarid = varid(6), &
                            & error_data = error_data, start = start, count = count)
    deallocate(start, count)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  ! Handle all attributes for the group.
  if (associated(folder%kinetic_energy_cutoff)) then
    ! Handle the units attribute.
    call etsf_io_low_read_att(ncid, varid(2), &
                            & "units", &
                            & etsf_charlen, folder%kin_cutoff__units, &
                            & lstat, error_data = error_data)
    if (.not. lstat) return
    if (trim(folder%kin_cutoff__units) /= "atomic units") then
      call etsf_io_low_read_att(ncid, varid(2), &
                              & "scale_to_atomic_units", &
                              & folder%kin_cutoff__scale_to_atomic_units, &
                              & lstat, error_data = error_data)
      if (.not. lstat) return
    else
      folder%kin_cutoff__scale_to_atomic_units = 1.0d0
    end if
    if (my_use_atomic_units .and. &
      & folder%kin_cutoff__scale_to_atomic_units /= 1.0d0) then
      folder%kinetic_energy_cutoff = folder%kinetic_energy_cutoff * &
        & folder%kin_cutoff__scale_to_atomic_units
    end if
  end if
  
  
  deallocate(varid)

!DEBUG
!write (*,*) 'etsf_io_basisdata_get : exit'
!ENDDEBUG

end subroutine etsf_io_basisdata_get
!!***
