/* Ergo, version 3.8.2, a program for linear scaling electronic structure
 * calculations.
 * Copyright (C) 2023 Elias Rudberg, Emanuel H. Rubensson, Pawel Salek,
 * and Anastasia Kruchinina.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Primary academic reference:
 * Ergo: An open-source program for linear-scaling electronic structure
 * calculations,
 * Elias Rudberg, Emanuel H. Rubensson, Pawel Salek, and Anastasia
 * Kruchinina,
 * SoftwareX 7, 107 (2018),
 * <http://dx.doi.org/10.1016/j.softx.2018.03.005>
 * 
 * For further information about Ergo, see <http://www.ergoscf.org>.
 */

/*-*-mode: C; c-indentation-style: "bsd"; c-basic-offset: 4; -*-*/
/** @file fun-pbec.c PBEc implementation.

   Automatically generated code implementing PBEC functional and
   its derivatives. It is generated by func-codegen.pl being a part of
   a "Automatic code generation framework for analytical functional
   derivative evaluation", Pawel Salek, 2005

    This functional is connected by making following changes:
    1. add "extern Functional pbecFunctional;" to 'functionals.h'
    2. add "&pbecFunctional," to 'functionals.c'
    3. add "fun-pbec.c" to 'Makefile.am', 'Makefile.in' or 'Makefile'.

    This functional has been generated from following input:
    ------ cut here -------
  parameter fuer PW92C 
c:1.709921;
T:[0.031091,0.015545,0.016887];
U:[0.21370,0.20548,0.11125];
V:[7.5957,14.1189,10.357];
W:[3.5876,6.1977,3.6231];
X:[1.6382,3.3662,0.88026];
Y:[0.49294,0.62517,0.49671];
P:[1,1,1];

 funktionen fuer PW92C 
r(a,b):=(3/(4*%PI*(a+b)))^(1/3);
zet(a,b):=(a-b)/(a+b);
omega(z):=((1+z)^(4/3)+(1-z)^(4/3)-2)/(2^(4/3)-2);
en(r,t,u,v,w,x,y,p):=-2*t*(1+u*r)
          *log(1+1/(2*t*(v*sqrt(r)+w*r+x*r^(3/2)+y*r^(p+1))));

eps(a,b) := en(r(a,b),T[1],U[1],V[1],W[1],X[1],Y[1],P[1])
          - en(r(a,b),T[3],U[3],V[3],W[3],X[3],Y[3],P[3])
             *omega(zet(a,b))*(1-(zet(a,b))^4)/c
          + (en(r(a,b),T[2],U[2],V[2],W[2],X[2],Y[2],P[2])          
            -en(r(a,b),T[1],U[1],V[1],W[1],X[1],Y[1],P[1]))
             *omega(zet(a,b))*(zet(a,b))^4;
  
 parameter fuer pbec 
iota:0.0716;
nu:16/%PI*(3*%PI^2)^(1/3);
kappa:0.004235;
lamda:nu*kappa;
Z:-0.001667;
Xi:23.266;
Phi:0.007389;
Lamda:8.723;
Upsilon:0.472;

 funktionen fuer pbec 
 u(a,b)  := ((1+zet(a,b))^(2/3)+(1-zet(a,b)^(2/3)))/2; 

u(a,b) := 0.5*((2*a)^(2/3)+(2*b)^(2/3))/(a+b)^(2/3);
theta(r):= 10^(-3)*(2.568+Xi*r+Phi*r^2)
           /(1+Lamda*r+Upsilon*r^2+10*Phi*r^3);
phi(r)  := theta(r)-Z;
sigma(ga,gb,gab) := ga*ga+gb*gb+2*gab;
d(a,b,ga,gb,gab) := sqrt(sigma(ga,gb,gab))
                    /(4*u(a,b)*(3/%PI)^(1/6)*(a+b)^(7/6));
A(a,b)   := 2*iota/(lamda*(exp(-2*iota*eps(a,b)/(lamda^2*(u(a,b))^3))-1));
L(d,a,b) := (u(a,b))^3*lamda^2/(2*iota)
      *log((1+2*(iota*(d^2+A(a,b)*d^4))
      /(lamda*(1+A(a,b)*d^2+(A(a,b))^2*d^4))));
 
 kernel 
K(rhoa,grada,rhob,gradb,gradab):=
   (rhoa+rhob)*(eps(rhoa,rhob)+
                L(d(rhoa,rhob,grada,gradb,gradab),rhoa,rhob));

    ------ cut here -------
*/

#include <math.h>
#include <stddef.h>
 
#define __CVERSION__
 
#include "functionals.h"
 
/* INTERFACE PART */
static int pbec_isgga(void) { return 1; } /* FIXME: detect! */
static int pbec_read(const char *conf_line);
static real pbec_energy(const FunDensProp* dp);
static void pbec_first(FunFirstFuncDrv *ds,   real factor,
                         const FunDensProp* dp);
static void pbec_second(FunSecondFuncDrv *ds, real factor,
                          const FunDensProp* dp);
 
Functional PbecFunctional = {
  "PBEC",       /* name */
  pbec_isgga,   /* gga-corrected */
  pbec_read,
  NULL,
  pbec_energy,
  pbec_first,
  pbec_second /*,
  pbec_third,
  pbec_fourth */
};
 
/* IMPLEMENTATION PART */
static int
pbec_read(const char *conf_line)
{
    fun_set_hf_weight(0);
    return 1;
}

static real
pbec_energy(const FunDensProp *dp)
{
    real res;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    real t11, t12, t13, t14, t15, t16, t17, t18;
    real t19, t20, t21, t22, t23, t24, t25, t26;
    real t27, t28, t29, t30, t31, t32, t33, t34;
    real t35, t36, t37, t38, t39, t40, t41, t42;
    real t43;

    t1 = rhob+rhoa;
    t2 = POW(3.0,.3333333333333333);
    t3 = 1/POW(4.0,.3333333333333333);
    t4 = POW(3.141592653589793,.3333333333333333);
    t5 = 1/t4;
    t6 = 1/POW(t1,.3333333333333333);
    t7 = 0.2137*t2*t3*t5*t6+1.0;
    t8 = POW(3.0,.6666666666666666);
    t9 = 1/POW(4.0,.6666666666666666);
    t10 = POW(3.141592653589793,.6666666666666666);
    t11 = 1/t10;
    t12 = 1/POW(t1,.6666666666666666);
    t13 = 1.732050807568877;
    t14 = .5641895835477563;
    t15 = 1/SQRT(t1);
    t16 = POW(2.0,.3333333333333333);
    t17 = 1/t16;
    t18 = POW(3.0,.1666666666666667);
    t19 = 1/POW(3.141592653589793,.1666666666666667);
    t20 = 1/POW(t1,.1666666666666667);
    t21 = LOG(16.0818243221511/(7.5957*t17*t18*t19*t20+3.5876*
        t2*t3*t5*t6+0.8191*t13*t14*t15+0.49294*t8*t9*t11*t12)+1.0);
    t22 = -
        0.062182*t7*t21;
    t23 = 1/(2.0*t16-2.0);
    t24 = rhoa-1.0*rhob;
    t25 = POW(t24,4.0);
    t26 = 1/POW(t1,4.0);
    t27 = 1/t1;
    t28 = POW(t24*t27+1.0,1.333333333333333)+POW(1.0-1.0*
        t24*t27,1.333333333333333)-2.0;
    t29 = .0197517897025652*LOG(29.60857464321668/(10.357*
        t17*t18*t19*t20+3.6231*t2*t3*t5*t6+0.44013*t13*t14*t15+0.49671*
        t8*t9*t11*t12)+1.0)*t23*(1.0-1.0*t25*t26)*t28*(0.11125*t2*
        t3*t5*t6+1.0);
    t30 = t23*t25*t26*t28*(0.062182*t7*t21-0.03109*LOG(32.1646831778707/
        (14.1189*t17*t18*t19*t20+6.1977*t2*t3*t5*t6+1.6831*t13*t14*
        t15+0.62517*t8*t9*t11*t12)+1.0)*(0.20548*t2*t3*t5*t6+1.0));
    t31 = POW(2.0,
        .6666666666666666);
    t32 = t31*POW(rhob,.6666666666666666)+t31*POW(rhoa,.6666666666666666);
    t33 = POW(t32,
        3.0);
    t34 = POW(t1,2.0);
    t35 = 1/t34;
    t36 = 1/t2;
    t37 = POW(gradb,2.0)+2.0*gradab+POW(grada,2.0);
    t38 = 1/POW(t32,2.0);
    t39 = POW(t37,2.0);
    t40 = 1/POW(t32,4.0);
    t41 = 1/t8;
    t42 = 1/POW(2.718281828459045,249.5089969598932*t10*(t30+
        t29+t22)*t34*t41/t33)-1.0;
    t43 = 1/t42;

   /* code */
    res = t1*(.0040078715083799*t11*t33*t35*LOG(2.113341204250295*
        t36*t4*(.1383178583708611*t35*t39*t40*t43+0.25*t36*t4*t37*
        t38*t27)/(.5283353010625738*t41*t10*t37*t38*t27*t43+.0930460634496268*
        POW(3.141592653589793,1.333333333333333)*t35*t36*t39*t40/POW(t42,
        2.0)+1.0)+1.0)*t8+t30+t29+t22);

    return res;
}

static void
pbec_first(FunFirstFuncDrv *ds, real factor, const FunDensProp *dp)
{
    real dfdra, dfdrb, dfdga, dfdgb, dfdgab;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    real t11, t12, t13, t14, t15, t16, t17, t18;
    real t19, t20, t21, t22, t23, t24, t25, t26;
    real t27, t28, t29, t30, t31, t32, t33, t34;
    real t35, t36, t37, t38, t39, t40, t41, t42;
    real t43, t44, t45, t46, t47, t48, t49, t50;
    real t51, t52, t53, t54, t55, t56, t57, t58;
    real t59, t60, t61, t62, t63, t64, t65, t66;
    real t67, t68, t69, t70, t71, t72, t73, t74;
    real t75, t76, t77, t78, t79, t80, t81, t82;
    real t83, t84, t85, t86, t87, t88, t89, t90;
    real t91, t92, t93, t94, t95, t96, t97, t98;
    real t99, t100, t101, t102, t103, t104, t105;
    real t106, t107, t108, t109, t110, t111, t112;
    real t113, t114, t115, t116;

    t1 = POW(3.0,.3333333333333333);
    t2 = 1/POW(4.0,.3333333333333333);
    t3 = POW(3.141592653589793,.3333333333333333);
    t4 = 1/t3;
    t5 = rhob+rhoa;
    t6 = 1/POW(t5,.3333333333333333);
    t7 = 0.2137*t1*t2*t4*t6+1.0;
    t8 = POW(3.0,.6666666666666666);
    t9 = 1/POW(4.0,.6666666666666666);
    t10 = POW(3.141592653589793,.6666666666666666);
    t11 = 1/t10;
    t12 = 1/POW(t5,.6666666666666666);
    t13 = 1.732050807568877;
    t14 = .5641895835477563;
    t15 = SQRT(t5);
    t16 = 1/t15;
    t17 = POW(2.0,.3333333333333333);
    t18 = 1/t17;
    t19 = POW(3.0,.1666666666666667);
    t20 = 1/POW(3.141592653589793,.1666666666666667);
    t21 = 1/POW(t5,.1666666666666667);
    t22 = 7.5957*t18*t19*t20*t21+3.5876*t1*t2*t4*t6+0.8191*
        t13*t14*t16+0.49294*t8*t9*t11*t12;
    t23 = 16.0818243221511/t22+1.0;
    t24 = LOG(t23);
    t25 = -0.062182*t7*t24;
    t26 = 1/(2.0*t17-2.0);
    t27 = rhoa-1.0*rhob;
    t28 = POW(t27,4.0);
    t29 = 1/POW(t5,4.0);
    t30 = 1.0-1.0*t28*t29;
    t31 = 0.11125*t1*t2*t4*t6+1.0;
    t32 = 1/t5;
    t33 = 1.0-1.0*t27*t32;
    t34 = t27*t32+1.0;
    t35 = POW(t34,1.333333333333333)+POW(t33,1.333333333333333)-
        2.0;
    t36 = 10.357*t18*t19*t20*t21+3.6231*t1*t2*t4*t6+0.44013*
        t13*t14*t16+0.49671*t8*t9*t11*t12;
    t37 = 29.60857464321668/t36+1.0;
    t38 = LOG(t37);
    t39 = .0197517897025652*t26*t30*t31*t35*t38;
    t40 = 0.20548*t1*t2*t4*t6+1.0;
    t41 = 14.1189*t18*t19*t20*t21+6.1977*t1*t2*t4*t6+1.6831*
        t13*t14*t16+0.62517*t8*t9*t11*t12;
    t42 = 32.1646831778707/t41+1.0;
    t43 = LOG(t42);
    t44 = 0.062182*t7*t24-0.03109*t40*t43;
    t45 = t26*t28*t29*t35*t44;
    t46 = POW(2.0,.6666666666666666);
    t47 = t46*POW(rhob,.6666666666666666)+t46*POW(rhoa,.6666666666666666);
    t48 = POW(t47,
        3.0);
    t49 = POW(t5,2.0);
    t50 = 1/t49;
    t51 = 1/t1;
    t52 = POW(gradb,2.0)+2.0*gradab+POW(grada,2.0);
    t53 = POW(t47,2.0);
    t54 = 1/t53;
    t55 = POW(t52,2.0);
    t56 = 1/POW(t47,4.0);
    t57 = 1/t8;
    t58 = 1/t48;
    t59 = t45+t39+t25;
    t60 = 1/POW(2.718281828459045,249.5089969598932*t57*t10*
        t58*t49*t59);
    t61 = t60-1.0;
    t62 = 1/t61;
    t63 = .1383178583708611*t50*t55*t56*t62+0.25*t51*t3*t52*
        t54*t32;
    t64 = POW(3.141592653589793,1.333333333333333);
    t65 = 1/POW(t61,2.0);
    t66 = .0930460634496268*t51*t64*t55*t56*t50*t65+.5283353010625738*
        t57*t10*t52*t54*t32*t62+1.0;
    t67 = 1/t66;
    t68 = 2.113341204250295*t51*t3*t63*t67+1.0;
    t69 = LOG(t68);
    t70 = .0040078715083799*t8*t11*t48*t50*t69;
    t71 = 1/POW(t5,1.666666666666667);
    t72 = 1/POW(t15,3.0);
    t73 = 1/POW(t5,1.333333333333333);
    t74 = 1/POW(t5,1.166666666666667);
    t75 = -1.26595*t18*t19*t20*t74-1.195866666666667*t1*t2*
        t4*t73-0.40955*t13*t14*t72-.3286266666666666*t8*t9*t11*t71;
    t76 = 1/
        POW(t22,2.0);
    t77 = 1/t23;
    t78 = .9999999999999999*t75*t7*t76*t77;
    t79 = -.5848223397455204*t26*t30*t31*t35*(-1.726166666666666*
        t18*t19*t20*t74-1.2077*t1*t2*t4*t73-0.220065*t13*t14*t72-0.33114*
        t8*t9*t11*t71)/(POW(t36,2.0)*t37);
    t80 = .0044294311333333*t1*t2*t4*t73*t24;
    t81 = t27*t50;
    t82 = -1.0*t32;
    t83 = POW(t33,.3333333333333333);
    t84 = -1.0*t27*t50;
    t85 = POW(t34,.3333333333333333);
    t86 = 1.333333333333333*(t32+t84)*t85+1.333333333333333*
        (t82+t81)*t83;
    t87 = .0197517897025652*t26*t30*t31*t86*t38;
    t88 = -7.324622014701263e-4*t26*t1*t2*t4*t73*t30*t35*
        t38;
    t89 = 1/POW(t5,5.0);
    t90 = 4.0*t28*t89;
    t91 = POW(t27,3.0);
    t92 = .0197517897025652*t26*t31*t35*t38*(t90-4.0*t29*
        t91);
    t93 = t26*t28*t29*t35*(-.9999999999999999*t75*t7*t76*
        t77+t40*(-2.35315*t18*t19*t20*t74-2.0659*t1*t2*t4*t73-0.84155*
        t13*t14*t72-0.41678*t8*t9*t11*t71)/(POW(t41,2.0)*t42)+.0021294577333333*
        t1*t2*t4*t73*t43-.0044294311333333*t1*t2*t4*t73*t24);
    t94 = t26*t28*t29*t86*t44;
    t95 = -4.0*t26*t28*t35*t44*t89;
    t96 = 4.0*t26*t29*t35*t44*t91;
    t97 = 1/t68;
    t98 = -0.25*t51*t3*t52*t54*t50;
    t99 = 1/POW(rhoa,.3333333333333333);
    t100 = 1/POW(t5,3.0);
    t101 = -.2766357167417222*t100*t55*t56*t62;
    t102 = 1/POW(t47,5.0);
    t103 = -499.0179939197864*t57*t10*t58*t5*t59;
    t104 = 499.0179939197864*t46*t57*t10*t99*t56*t49*t59+
        t103-249.5089969598932*t57*t10*t58*t49*(t96+t95+t94+t93+t92+
        t88+t87+t80+t79+t78);
    t105 = 1/POW(t66,2.0);
    t106 = -.1860921268992536*t51*t64*t55*t56*t100*t65;
    t107 = -
        .5283353010625738*t57*t10*t52*t54*t50*t62;
    t108 = 1/POW(t61,3.0);
    t109 = -.0080157430167598*t8*t11*t48*t100*t69;
    t110 = 1.333333333333333*(t82+t84)*t85+1.333333333333333*
        (t32+t81)*t83;
    t111 = .0197517897025652*t26*t30*t31*t110*t38;
    t112 = .0197517897025652*t26*t31*t35*t38*(4.0*t29*t91+
        t90);
    t113 = t26*t28*t29*t110*t44;
    t114 = -4.0*t26*t29*t35*t44*t91;
    t115 = 1/POW(rhob,.3333333333333333);
    t116 = 499.0179939197864*t46*t57*t10*t56*t115*t49*t59+
        t103-249.5089969598932*t57*t10*t58*t49*(t114+t95+t113+t93+
        t112+t88+t111+t80+t79+t78);

   /* code */
    dfdra = t5*(.0040078715083799*t11*t48*t50*t8*t97*(2.113341204250295*
        t3*t51*t67*(-.3688476223222962*t102*t46*t50*t55*t62*t99+t98-
        .1383178583708611*t104*t50*t55*t56*t60*t65-.3333333333333333*
        t46*t51*t3*t52*t99*t58*t32+t101)-2.113341204250295*t51*t3*
        t63*t105*(-.5283353010625738*t57*t10*t52*t54*t32*t104*t65*
        t60-.1860921268992536*t51*t64*t55*t56*t50*t104*t108*t60-.7044470680834316*
        t46*t57*t10*t52*t99*t58*t32*t62+t107-.2481228358656715*t46*
        t51*t64*t55*t99*t102*t50*t65+t106))+t96+t95+t94+t93+t92+t88+
        t87+t80+t79+t78+.0080157430167598*t46*t8*t11*t99*t53*t50*t69+
        t109)+t70+t45+t39+t25;
    dfdrb = t5*(.0040078715083799*t11*t48*t50*t8*t97*(2.113341204250295*
        t3*t51*t67*(t98-.1383178583708611*t116*t50*t55*t56*t60*t65-
        .3688476223222962*t102*t115*t46*t50*t55*t62-.3333333333333333*
        t46*t51*t3*t52*t58*t115*t32+t101)-2.113341204250295*t51*t3*
        t63*t105*(-.5283353010625738*t57*t10*t52*t54*t32*t116*t65*
        t60-.1860921268992536*t51*t64*t55*t56*t50*t116*t108*t60-.7044470680834316*
        t46*t57*t10*t52*t58*t115*t32*t62+t107-.2481228358656715*t46*
        t51*t64*t55*t102*t115*t50*t65+t106))+t95+t93+t88+t80+t79+t78+
        .0080157430167598*t46*t8*t11*t53*t115*t50*t69+t114+t113+t112+
        t111+t109)+t70+t45+t39+t25;
    dfdga = .0040078715083799*t11*t32*t48*t8*t97*(2.113341204250295*
        t3*t51*t67*(.5532714334834444*t50*t52*t56*t62*grada+0.5*t51*
        t3*grada*t54*t32)-2.113341204250295*t51*t3*t63*(1.056670602125148*
        t57*t10*grada*t54*t32*t62+.3721842537985072*t51*t64*grada*
        t52*t56*t50*t65)*t105);
    dfdgb = .0040078715083799*t11*t32*t48*t8*t97*(2.113341204250295*
        t3*t51*t67*(.5532714334834444*t50*t52*t56*t62*gradb+0.5*t51*
        t3*gradb*t54*t32)-2.113341204250295*t51*t3*t63*(1.056670602125148*
        t57*t10*gradb*t54*t32*t62+.3721842537985072*t51*t64*gradb*
        t52*t56*t50*t65)*t105);
    dfdgab = .0040078715083799*t11*t32*t48*(2.113341204250295*
        t3*t51*(.5532714334834444*t50*t52*t56*t62+0.5*t51*t3*t54*t32)*
        t67-2.113341204250295*t51*t3*t63*(1.056670602125148*t57*t10*
        t54*t32*t62+.3721842537985072*t51*t64*t52*t56*t50*t65)*t105)*
        t8*t97;


    ds->df1000 += factor*dfdra;
    ds->df0100 += factor*dfdrb;
    ds->df0010 += factor*dfdga;
    ds->df0001 += factor*dfdgb;
    ds->df00001+= factor*dfdgab;
   
}

static void
pbec_second(FunSecondFuncDrv *ds, real factor, const FunDensProp* dp)
{
    real dfdra, dfdrb, dfdga, dfdgb, dfdgab;
    real d2fdrara, d2fdrarb, d2fdraga, d2fdragb, d2fdraab, d2fdrbrb,
        d2fdrbga, d2fdrbgb, d2fdrbgab, d2fdgaga, d2fdgagb, d2fdgagab,
        d2fdgbgb, d2fdgbgab, d2fdgabgab;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    real t11, t12, t13, t14, t15, t16, t17, t18;
    real t19, t20, t21, t22, t23, t24, t25, t26;
    real t27, t28, t29, t30, t31, t32, t33, t34;
    real t35, t36, t37, t38, t39, t40, t41, t42;
    real t43, t44, t45, t46, t47, t48, t49, t50;
    real t51, t52, t53, t54, t55, t56, t57, t58;
    real t59, t60, t61, t62, t63, t64, t65, t66;
    real t67, t68, t69, t70, t71, t72, t73, t74;
    real t75, t76, t77, t78, t79, t80, t81, t82;
    real t83, t84, t85, t86, t87, t88, t89, t90;
    real t91, t92, t93, t94, t95, t96, t97, t98;
    real t99, t100, t101, t102, t103, t104, t105;
    real t106, t107, t108, t109, t110, t111, t112;
    real t113, t114, t115, t116, t117, t118, t119;
    real t120, t121, t122, t123, t124, t125, t126;
    real t127, t128, t129, t130, t131, t132, t133;
    real t134, t135, t136, t137, t138, t139, t140;
    real t141, t142, t143, t144, t145, t146, t147;
    real t148, t149, t150, t151, t152, t153, t154;
    real t155, t156, t157, t158, t159, t160, t161;
    real t162, t163, t164, t165, t166, t167, t168;
    real t169, t170, t171, t172, t173, t174, t175;
    real t176, t177, t178, t179, t180, t181, t182;
    real t183, t184, t185, t186, t187, t188, t189;
    real t190, t191, t192, t193, t194, t195, t196;
    real t197, t198, t199, t200, t201, t202, t203;
    real t204, t205, t206, t207, t208, t209, t210;
    real t211, t212, t213, t214, t215, t216, t217;
    real t218, t219, t220, t221, t222, t223, t224;
    real t225, t226, t227, t228, t229, t230, t231;
    real t232, t233, t234, t235, t236, t237, t238;
    real t239, t240, t241, t242, t243, t244, t245;
    real t246, t247, t248, t249, t250, t251, t252;
    real t253, t254, t255, t256, t257, t258, t259;
    real t260, t261, t262, t263, t264, t265, t266;
    real t267, t268, t269, t270, t271, t272, t273;
    real t274, t275, t276, t277, t278, t279, t280;
    real t281, t282, t283, t284, t285, t286, t287;
    real t288;

    t1 = POW(3.0,.3333333333333333);
    t2 = 1/POW(4.0,.3333333333333333);
    t3 = POW(3.141592653589793,.3333333333333333);
    t4 = 1/t3;
    t5 = rhob+rhoa;
    t6 = 1/POW(t5,.3333333333333333);
    t7 = 0.2137*t1*t2*t4*t6+1.0;
    t8 = POW(3.0,.6666666666666666);
    t9 = 1/POW(4.0,.6666666666666666);
    t10 = POW(3.141592653589793,.6666666666666666);
    t11 = 1/t10;
    t12 = 1/POW(t5,.6666666666666666);
    t13 = 1.732050807568877;
    t14 = .5641895835477563;
    t15 = SQRT(t5);
    t16 = 1/t15;
    t17 = POW(2.0,.3333333333333333);
    t18 = 1/t17;
    t19 = POW(3.0,.1666666666666667);
    t20 = 1/POW(3.141592653589793,.1666666666666667);
    t21 = 1/POW(t5,.1666666666666667);
    t22 = 7.5957*t18*t19*t20*t21+3.5876*t1*t2*t4*t6+0.8191*
        t13*t14*t16+0.49294*t8*t9*t11*t12;
    t23 = 16.0818243221511/t22+1.0;
    t24 = LOG(t23);
    t25 = -0.062182*t7*t24;
    t26 = 1/(2.0*t17-2.0);
    t27 = rhoa-1.0*rhob;
    t28 = POW(t27,4.0);
    t29 = 1/POW(t5,4.0);
    t30 = 1.0-1.0*t28*t29;
    t31 = 0.11125*t1*t2*t4*t6+1.0;
    t32 = 1/t5;
    t33 = 1.0-1.0*t27*t32;
    t34 = t27*t32+1.0;
    t35 = POW(t34,1.333333333333333)+POW(t33,1.333333333333333)-
        2.0;
    t36 = 10.357*t18*t19*t20*t21+3.6231*t1*t2*t4*t6+0.44013*
        t13*t14*t16+0.49671*t8*t9*t11*t12;
    t37 = 29.60857464321668/t36+1.0;
    t38 = LOG(t37);
    t39 = .0197517897025652*t26*t30*t31*t35*t38;
    t40 = 0.20548*t1*t2*t4*t6+1.0;
    t41 = 14.1189*t18*t19*t20*t21+6.1977*t1*t2*t4*t6+1.6831*
        t13*t14*t16+0.62517*t8*t9*t11*t12;
    t42 = 32.1646831778707/t41+1.0;
    t43 = LOG(t42);
    t44 = 0.062182*t7*t24-0.03109*t40*t43;
    t45 = t26*t28*t29*t35*t44;
    t46 = POW(2.0,.6666666666666666);
    t47 = POW(rhoa,.6666666666666666);
    t48 = POW(rhob,.6666666666666666);
    t49 = t46*t48+t46*t47;
    t50 = POW(t49,3.0);
    t51 = POW(t5,2.0);
    t52 = 1/t51;
    t53 = 1/t1;
    t54 = POW(grada,2.0);
    t55 = POW(gradb,2.0);
    t56 = 2.0*gradab+t55+t54;
    t57 = POW(t49,2.0);
    t58 = 1/t57;
    t59 = POW(t56,2.0);
    t60 = 1/POW(t49,4.0);
    t61 = 1/t8;
    t62 = 1/t50;
    t63 = t45+t39+t25;
    t64 = 1/POW(2.718281828459045,249.5089969598932*t61*t10*
        t62*t51*t63);
    t65 = t64-1.0;
    t66 = 1/t65;
    t67 = .1383178583708611*t52*t59*t60*t66+0.25*t53*t3*t56*
        t58*t32;
    t68 = POW(3.141592653589793,1.333333333333333);
    t69 = 1/POW(t65,2.0);
    t70 = .0930460634496268*t53*t68*t59*t60*t52*t69+.5283353010625738*
        t61*t10*t56*t58*t32*t66+1.0;
    t71 = 1/t70;
    t72 = 2.113341204250295*t53*t3*t67*t71+1.0;
    t73 = LOG(t72);
    t74 = .0040078715083799*t8*t11*t50*t52*t73;
    t75 = 1/POW(t5,1.666666666666667);
    t76 = 1/POW(t15,3.0);
    t77 = 1/POW(t5,1.333333333333333);
    t78 = 1/POW(t5,1.166666666666667);
    t79 = -1.26595*t18*t19*t20*t78-1.195866666666667*t1*t2*
        t4*t77-0.40955*t13*t14*t76-.3286266666666666*t8*t9*t11*t75;
    t80 = 1/
        POW(t22,2.0);
    t81 = 1/t23;
    t82 = .9999999999999999*t79*t7*t80*t81;
    t83 = -1.726166666666666*t18*t19*t20*t78-1.2077*t1*t2*
        t4*t77-0.220065*t13*t14*t76-0.33114*t8*t9*t11*t75;
    t84 = 1/POW(t36,2.0);
    t85 = 1/t37;
    t86 = -.5848223397455204*t26*t30*t83*t31*t84*t35*t85;
    t87 = .0044294311333333*
        t1*t2*t4*t77*t24;
    t88 = t27*t52;
    t89 = -1.0*t32;
    t90 = t89+t88;
    t91 = POW(t33,.3333333333333333);
    t92 = -1.0*t27*t52;
    t93 = t32+t92;
    t94 = POW(t34,.3333333333333333);
    t95 = 1.333333333333333*t93*t94+1.333333333333333*t90*
        t91;
    t96 = .0197517897025652*t26*t30*t31*t95*t38;
    t97 = -7.324622014701263e-4*t26*t1*t2*t4*t77*t30*t35*
        t38;
    t98 = 1/POW(t5,5.0);
    t99 = 4.0*t28*t98;
    t100 = POW(t27,3.0);
    t101 = t99-4.0*t100*t29;
    t102 = .0197517897025652*t26*t101*t31*t35*t38;
    t103 = -2.35315*t18*t19*t20*t78-2.0659*t1*t2*t4*t77-0.84155*
        t13*t14*t76-0.41678*t8*t9*t11*t75;
    t104 = 1/POW(t41,2.0);
    t105 = 1/t42;
    t106 = .0021294577333333*t1*t2*t4*t77*t43-.0044294311333333*
        t1*t2*t4*t77*t24+t103*t40*t104*t105-.9999999999999999*t79*
        t7*t80*t81;
    t107 = t26*t28*t29*t35*t106;
    t108 = t26*t28*t29*t95*t44;
    t109 = -4.0*t26*t28*t35*t44*t98;
    t110 = 4.0*t100*t26*t29*t35*t44;
    t111 = 1/t72;
    t112 = -0.25*t53*t3*t56*t58*t52;
    t113 = 1/POW(rhoa,.3333333333333333);
    t114 = 1/POW(t5,3.0);
    t115 = -.2766357167417222*t114*t59*t60*t66;
    t116 = 1/POW(t49,5.0);
    t117 = t110+t109+t108+t107+t102+t97+t96+t87+t86+t82;
    t118 = -
        499.0179939197864*t61*t10*t62*t5*t63;
    t119 = 499.0179939197864*t46*t61*t10*t113*t60*t51*t63+
        t118-249.5089969598932*t61*t10*t62*t51*t117;
    t120 = -.1383178583708611*t119*t52*t59*t60*t64*t69-.3688476223222962*
        t113*t116*t46*t52*t59*t66-.3333333333333333*t46*t53*t3*t56*
        t113*t62*t32+t115+t112;
    t121 = 1/POW(t70,2.0);
    t122 = -.1860921268992536*t53*t68*t59*t60*t114*t69;
    t123 = -
        .5283353010625738*t61*t10*t56*t58*t52*t66;
    t124 = 1/POW(t65,3.0);
    t125 = -.5283353010625738*t61*t10*t56*t58*t32*t119*t69*
        t64-.1860921268992536*t53*t68*t59*t60*t52*t119*t124*t64-.7044470680834316*
        t46*t61*t10*t56*t113*t62*t32*t66+t123-.2481228358656715*t46*
        t53*t68*t59*t113*t116*t52*t69+t122;
    t126 = 2.113341204250295*t53*t3*t71*t120-2.113341204250295*
        t53*t3*t67*t121*t125;
    t127 = .0040078715083799*t8*t11*t50*t52*t111*t126;
    t128 = -.0080157430167598*t8*t11*t50*t114*t73;
    t129 = .0080157430167598*t46*t8*t11*t113*t57*t52*t73;
    t130 = t32+
        t88;
    t131 = t89+t92;
    t132 = 1.333333333333333*t131*t94+1.333333333333333*t130*
        t91;
    t133 = .0197517897025652*t26*t30*t31*t132*t38;
    t134 = t99+4.0*t100*t29;
    t135 = .0197517897025652*t26*t134*t31*t35*t38;
    t136 = t26*t28*t29*t132*t44;
    t137 = -4.0*t100*t26*t29*t35*t44;
    t138 = 1/POW(rhob,.3333333333333333);
    t139 = t137+t109+t136+t107+t135+t97+t133+t87+t86+t82;
    t140 = 499.0179939197864*
        t46*t61*t10*t60*t138*t51*t63+t118-249.5089969598932*t61*t10*
        t62*t51*t139;
    t141 = -.1383178583708611*t140*t52*t59*t60*t64*t69-.3688476223222962*
        t116*t138*t46*t52*t59*t66-.3333333333333333*t46*t53*t3*t56*
        t62*t138*t32+t115+t112;
    t142 = -.5283353010625738*t61*t10*t56*t58*t32*t140*t69*
        t64-.1860921268992536*t53*t68*t59*t60*t52*t140*t124*t64-.7044470680834316*
        t46*t61*t10*t56*t62*t138*t32*t66+t123-.2481228358656715*t46*
        t53*t68*t59*t116*t138*t52*t69+t122;
    t143 = 2.113341204250295*t53*t3*t71*t141-2.113341204250295*
        t53*t3*t67*t121*t142;
    t144 = .0040078715083799*t8*t11*t50*t52*t111*t143;
    t145 = .0080157430167598*t46*t8*t11*t57*t138*t52*t73;
    t146 = 1.056670602125148*
        t61*t10*grada*t58*t32*t66+.3721842537985072*t53*t68*grada*
        t56*t60*t52*t69;
    t147 = .5532714334834444*t52*t56*t60*t66*grada+0.5*t53*
        t3*grada*t58*t32;
    t148 = 2.113341204250295*t53*t3*t147*t71-2.113341204250295*
        t53*t3*t67*t146*t121;
    t149 = 1.056670602125148*t61*t10*gradb*t58*t32*t66+.3721842537985072*
        t53*t68*gradb*t56*t60*t52*t69;
    t150 = .5532714334834444*t52*t56*t60*t66*gradb+0.5*t53*
        t3*gradb*t58*t32;
    t151 = 2.113341204250295*t53*t3*t150*t71-2.113341204250295*
        t53*t3*t67*t149*t121;
    t152 = .3721842537985072*t53*t68*t56*t60*t52*t69;
    t153 = 1.056670602125148*t61*t10*t58*t32*t66;
    t154 = t153+t152;
    t155 = 0.5*t53*t3*t58*t32;
    t156 = .5532714334834444*t52*t56*t60*t66;
    t157 = t156+t155;
    t158 = 2.113341204250295*t53*t3*t157*t71-2.113341204250295*
        t53*t3*t67*t154*t121;
    t159 = 2.0*t79*t7*t80*t81;
    t160 = -1.169644679491041*t26*t30*t83*t31*t84*t35*t85;
    t161 = .0088588622666667*
        t1*t2*t4*t77*t24;
    t162 = -.0014649244029403*t26*t1*t2*t4*t77*t30*t35*t38;
    t163 = 2.0*
        t106*t26*t28*t29*t35;
    t164 = -8.0*t26*t28*t35*t44*t98;
    t165 = -.0160314860335196*t8*t11*t50*t114*t73;
    t166 = POW(t79,2.0);
    t167 = 1/POW(t22,4.0);
    t168 = 1/POW(t23,2.0);
    t169 = 16.0818243221511*t166*t7*t167*t168;
    t170 = 1/POW(t22,3.0);
    t171 = -2.0*t166*t7*t170*t81;
    t172 = -.1424666666666666*t1*t2*t4*t77*t79*t80*t81;
    t173 = 1/
        POW(t5,2.666666666666667);
    t174 = 1/POW(t15,5.0);
    t175 = 1/POW(t5,2.333333333333333);
    t176 = 1/POW(t5,2.166666666666667);
    t177 = 1.476941666666667*t18*t19*t20*t176+1.594488888888889*
        t1*t2*t4*t175+0.614325*t13*t14*t174+0.547711111111111*t8*t9*
        t11*t173;
    t178 = .9999999999999999*t177*t7*t80*t81;
    t179 = POW(t83,2.0);
    t180 = -17.31575589937587*t179*t26*t30*t31*t35/(POW(t36,
        4.0)*POW(t37,2.0));
    t181 = -1.169644679491041*t26*t30*t83*t31*t84*t95*t85;
    t182 = 1.169644679491041*
        t179*t26*t30*t31*t35*t85/POW(t36,3.0);
    t183 = .0433743235311261*t26*t1*t2*t4*t77*t30*t83*t84*
        t35*t85;
    t184 = -.5848223397455204*t26*t30*(2.013861111111111*
        t18*t19*t20*t176+1.610266666666667*t1*t2*t4*t175+0.3300975*
        t13*t14*t174+.5519000000000001*t8*t9*t11*t173)*t31*t84*t35*
        t85;
    t185 = -1.169644679491041*t26*t101*t83*t31*t84*t35*t85;
    t186 = -
        .0059059081777778*t1*t2*t4*t175*t24;
    t187 = 1/POW(t33,.6666666666666666);
    t188 = -2.0*t114*t27;
    t189 = 2.0*t52;
    t190 = 1/POW(t34,.6666666666666666);
    t191 = 2.0*t114*t27;
    t192 = -2.0*t52;
    t193 = 1.333333333333333*(t192+t191)*t94+.4444444444444444*
        t190*POW(t93,2.0)+1.333333333333333*(t189+t188)*t91+.4444444444444444*
        t187*POW(t90,2.0);
    t194 = .0197517897025652*t26*t30*t31*t193*t38;
    t195 = -.0014649244029403*t26*t1*t2*t4*t77*t30*t95*t38;
    t196 = .0395035794051304*
        t26*t101*t31*t95*t38;
    t197 = -.0014649244029403*t26*t1*t2*t4*t77*t101*t35*t38;
    t198 = 9.766162686268349e-4*t26*t1*t2*t4*t175*t30*t35*
        t38;
    t199 = 1/POW(t5,6.0);
    t200 = -20.0*t199*t28;
    t201 = POW(t27,2.0);
    t202 = -12.0*t201*t29;
    t203 = .0197517897025652*t26*t31*t35*t38*(32.0*t100*t98+
        t202+t200);
    t204 = POW(t103,2.0);
    t205 = t26*t28*t29*t35*(.1424666666666666*t1*t2*t4*t77*
        t79*t80*t81-.9999999999999999*t177*t7*t80*t81+2.0*t166*t7*
        t170*t81-.0028392769777778*t1*t2*t4*t175*t43+32.1646831778707*
        t204*t40/(POW(t41,4.0)*POW(t42,2.0))-2.0*t105*t204*t40/POW(t41,
        3.0)+.0059059081777778*t1*t2*t4*t175*t24-16.0818243221511*
        t166*t7*t167*t168+(2.745341666666667*t18*t19*t20*t176+2.754533333333333*
        t1*t2*t4*t175+1.262325*t13*t14*t174+.6946333333333333*t8*t9*
        t11*t173)*t40*t104*t105-.1369866666666666*t1*t2*t4*t77*t103*
        t104*t105);
    t206 = 2.0*t106*t26*t28*t29*t95;
    t207 = -8.0*t106*t26*t28*t35*t98;
    t208 = 8.0*t100*t106*t26*t29*t35;
    t209 = t26*t28*t29*t193*t44;
    t210 = -8.0*t26*t28*t44*t95*t98;
    t211 = 8.0*t100*t26*t29*t44*t95;
    t212 = 20.0*t199*t26*t28*t35*t44;
    t213 = -32.0*t100*t26*t35*t44*t98;
    t214 = 12.0*t201*t26*t29*t35*t44;
    t215 = 1/POW(t72,2.0);
    t216 = 1/POW(t70,3.0);
    t217 = 0.5*t53*t3*t56*t58*t114;
    t218 = 1/t47;
    t219 = 1/POW(rhoa,1.333333333333333);
    t220 = POW(t119,2.0);
    t221 = 1/POW(2.718281828459045,499.0179939197864*t61*
        t10*t62*t51*t63);
    t222 = .8299071502251667*t29*t59*t60*t66;
    t223 = 1/POW(t49,6.0);
    t224 = -499.0179939197864*t61*t10*t62*t63;
    t225 = -166.3393313065955*t46*t61*t10*t219*t60*t51*t63-
        2661.429300905527*t17*t61*t10*t218*t116*t51*t63+1996.071975679145*
        t46*t61*t10*t113*t60*t5*t63+t224+998.0359878395727*t46*t61*
        t10*t113*t60*t51*t117-998.0359878395727*t61*t10*t62*t5*t117-
        249.5089969598932*t61*t10*t62*t51*(t214+t213+t212+t211+t210+
        t209+t208+t207+t206+t205+t203+t198+t197+t196+t195+t194+t186+
        t185+t184+t183+t182+t181+t180+t178+t172+t171+t169);
    t226 = 1/POW(t65,4.0);
    t227 = .5582763806977609*t53*t68*t59*t60*t29*t69;
    t228 = 1.056670602125148*t61*t10*t56*t58*t114*t66;
    t229 = .0240472290502793*t8*t11*t50*t29*t73;
    t230 = -.5848223397455204*t26*t30*t83*t31*t84*t132*t85;
    t231 = -
        .5848223397455204*t26*t30*t83*t31*t84*t95*t85;
    t232 = -.5848223397455204*t26*t101*t83*t31*t84*t35*t85;
    t233 = -
        .5848223397455204*t26*t134*t83*t31*t84*t35*t85;
    t234 = 2.666666666666667*t114*t27*t94+.4444444444444444*
        t131*t190*t93-2.666666666666667*t114*t27*t91+.4444444444444444*
        t130*t187*t90;
    t235 = .0197517897025652*t26*t30*t31*t234*t38;
    t236 = -7.324622014701263e-4*t26*t1*t2*t4*t77*t30*t132*
        t38;
    t237 = .0197517897025652*t26*t101*t31*t132*t38;
    t238 = -7.324622014701263e-4*t26*t1*t2*t4*t77*t30*t95*
        t38;
    t239 = .0197517897025652*t26*t134*t31*t95*t38;
    t240 = -7.324622014701263e-4*t26*t1*t2*t4*t77*t101*t35*
        t38;
    t241 = -7.324622014701263e-4*t26*t1*t2*t4*t77*t134*t35*
        t38;
    t242 = .0197517897025652*t26*(12.0*t201*t29+t200)*t31*
        t35*t38;
    t243 = t26*t28*t29*t132*t106;
    t244 = t26*t28*t29*t95*t106;
    t245 = t26*t28*t29*t234*t44;
    t246 = -4.0*t132*t26*t28*t44*t98;
    t247 = 4.0*t100*t132*t26*t29*t44;
    t248 = -4.0*t26*t28*t44*t95*t98;
    t249 = -4.0*t100*t26*t29*t44*t95;
    t250 = -12.0*t201*t26*t29*t35*t44;
    t251 = -2661.429300905527*t17*t61*t10*t113*t116*t138*
        t51*t63+998.0359878395727*t46*t61*t10*t60*t138*t5*t63+998.0359878395727*
        t46*t61*t10*t113*t60*t5*t63+t224+499.0179939197864*t46*t61*
        t10*t60*t138*t51*t117-499.0179939197864*t61*t10*t62*t5*t117+
        499.0179939197864*t46*t61*t10*t113*t60*t51*t139-499.0179939197864*
        t61*t10*t62*t5*t139-249.5089969598932*t61*t10*t62*t51*(t250+
        t212+t249+t248+t247+t246+t245+t207+t244+t243+t205+t242+t198+
        t241+t240+t239+t238+t237+t236+t235+t186+t233+t232+t184+t183+
        t182+t231+t230+t180+t178+t172+t171+t169);
    t252 = .0040078715083799*t8*t11*t50*t52*t148*t111;
    t253 = -.0080157430167598*t8*t11*t50*t114*t148*t111;
    t254 = -
        0.5*t53*t3*grada*t58*t52;
    t255 = -1.106542866966889*t114*t56*t60*t66*grada;
    t256 = -.7443685075970145*t53*t68*grada*t56*t60*t114*
        t69;
    t257 = -1.056670602125148*t61*t10*grada*t58*t52*t66;
    t258 = .0040078715083799*
        t8*t11*t50*t52*t151*t111;
    t259 = -.0080157430167598*t8*t11*t50*t114*t151*t111;
    t260 = -
        0.5*t53*t3*gradb*t58*t52;
    t261 = -1.106542866966889*t114*t56*t60*t66*gradb;
    t262 = -.7443685075970145*t53*t68*gradb*t56*t60*t114*
        t69;
    t263 = -1.056670602125148*t61*t10*gradb*t58*t52*t66;
    t264 = .0040078715083799*
        t8*t11*t50*t52*t158*t111;
    t265 = -.0080157430167598*t8*t11*t50*t114*t158*t111;
    t266 = -
        0.5*t53*t3*t58*t52;
    t267 = -1.106542866966889*t114*t56*t60*t66;
    t268 = -.7443685075970145*t53*t68*t56*t60*t114*t69;
    t269 = -
        1.056670602125148*t61*t10*t58*t52*t66;
    t270 = -1.169644679491041*t26*t30*t83*t31*t84*t132*t85;
    t271 = -
        1.169644679491041*t26*t134*t83*t31*t84*t35*t85;
    t272 = 1.333333333333333*(t189+t191)*t94+1.333333333333333*
        (t192+t188)*t91+.4444444444444444*POW(t131,2.0)*t190+.4444444444444444*
        POW(t130,2.0)*t187;
    t273 = .0197517897025652*t26*t30*t31*t272*t38;
    t274 = -.0014649244029403*t26*t1*t2*t4*t77*t30*t132*t38;
    t275 = .0395035794051304*
        t26*t134*t31*t132*t38;
    t276 = -.0014649244029403*t26*t1*t2*t4*t77*t134*t35*t38;
    t277 = .0197517897025652*
        t26*t31*t35*t38*(-32.0*t100*t98+t202+t200);
    t278 = 2.0*t106*t132*t26*t28*t29;
    t279 = -8.0*t100*t106*t26*t29*t35;
    t280 = t26*t28*t29*t272*t44;
    t281 = -8.0*t132*t26*t28*t44*t98;
    t282 = -8.0*t100*t132*t26*t29*t44;
    t283 = 32.0*t100*t26*t35*t44*t98;
    t284 = 1/POW(rhob,1.333333333333333);
    t285 = 1/t48;
    t286 = POW(t140,2.0);
    t287 = -2661.429300905527*t17*t61*t10*t116*t285*t51*t63-
        166.3393313065955*t46*t61*t10*t60*t284*t51*t63+1996.071975679145*
        t46*t61*t10*t60*t138*t5*t63+t224+998.0359878395727*t46*t61*
        t10*t60*t138*t51*t139-998.0359878395727*t61*t10*t62*t5*t139-
        249.5089969598932*t61*t10*t62*t51*(t214+t283+t212+t282+t281+
        t280+t279+t207+t278+t205+t277+t198+t276+t275+t274+t273+t186+
        t271+t184+t183+t182+t270+t180+t178+t172+t171+t169);
    t288 = POW(3.141592653589793,1.666666666666667);

   /* code */
    dfdra = t5*(t129+t128+t127+t110+t109+t108+t107+t102+t97+
        t96+t87+t86+t82)+t74+t45+t39+t25;
    dfdrb = t5*(t145+t128+t144+t137+t109+t136+t107+t135+t97+
        t133+t87+t86+t82)+t74+t45+t39+t25;
    dfdga = .0040078715083799*t8*t11*t50*t32*t148*t111;
    dfdgb = .0040078715083799*
        t8*t11*t50*t32*t151*t111;
    dfdgab = .0040078715083799*t8*t11*t50*t32*t158*t111;
    d2fdrara = 2.0*
        t26*t28*t29*t44*t95+t5*(.0040078715083799*t11*t111*t50*t52*
        (2.113341204250295*t3*t53*(-.1383178583708611*t225*t52*t59*
        t60*t64*t69-.1383178583708611*t220*t52*t59*t60*t64*t69+.5532714334834444*
        t114*t119*t59*t60*t64*t69+.7376952446445925*t113*t116*t119*
        t46*t52*t59*t64*t69+.1229492074407654*t116*t219*t46*t52*t59*
        t66+2.458984148815308*t17*t218*t223*t52*t59*t66+1.475390489289185*
        t113*t114*t116*t46*t59*t66+.2766357167417222*t124*t220*t221*
        t52*t59*t60+.6666666666666666*t46*t53*t3*t56*t113*t62*t52+
        .1111111111111111*t46*t53*t3*t56*t219*t62*t32+1.333333333333333*
        t17*t53*t3*t56*t218*t60*t32+t222+t217)*t71+4.22668240850059*
        POW(t125,2.0)*t216*t3*t53*t67-2.113341204250295*t53*t3*t67*
        t121*(-.5283353010625738*t61*t10*t56*t58*t32*t220*t69*t64+
        1.408894136166863*t46*t61*t10*t56*t113*t62*t32*t119*t69*t64+
        1.056670602125148*t61*t10*t56*t58*t52*t119*t69*t64-.5283353010625738*
        t61*t10*t56*t58*t32*t225*t69*t64-.1860921268992536*t53*t68*
        t59*t60*t52*t220*t124*t64+.9924913434626859*t46*t53*t68*t59*
        t113*t116*t52*t119*t124*t64+.7443685075970145*t53*t68*t59*
        t60*t114*t119*t124*t64-.1860921268992536*t53*t68*t59*t60*t52*
        t225*t124*t64+.2348156893611439*t46*t61*t10*t56*t219*t62*t32*
        t66+2.817788272333726*t17*t61*t10*t56*t218*t60*t32*t66+1.408894136166863*
        t46*t61*t10*t56*t113*t62*t52*t66+t228+.0827076119552238*t46*
        t53*t68*t59*t219*t116*t52*t69+1.654152239104477*t17*t53*t68*
        t59*t218*t223*t52*t69+.9924913434626859*t46*t53*t68*t59*t113*
        t116*t114*t69+t227+1.056670602125148*t61*t10*t56*t58*t32*t220*
        t221*t124+.5582763806977609*t53*t68*t59*t60*t52*t220*t221*
        t226)-4.22668240850059*t53*t3*t121*t120*t125)*t8-.0040078715083799*
        t11*POW(t126,2.0)*t215*t50*t52*t8-.0026719143389199*t46*t8*
        t11*t219*t57*t52*t73+.0213753147113594*t17*t8*t11*t218*t49*
        t52*t73-.0320629720670391*t46*t8*t11*t113*t57*t114*t73+t229+
        t214+t213+t212+t211+t210+t209+t208+t207+t206+t205+t203+t198+
        t197+t196+t195+t194+t186+t185+t184+t183+t182+t181+t180+t178+
        t172+t171+t169+.0160314860335196*t46*t8*t11*t113*t57*t52*t111*
        t126-.0160314860335196*t8*t11*t50*t114*t111*t126)+.0160314860335196*
        t46*t8*t11*t113*t57*t52*t73+8.0*t100*t26*t29*t35*t44+.0395035794051304*
        t26*t30*t31*t95*t38+.0395035794051304*t26*t101*t31*t35*t38+
        t165+t164+t163+t162+t161+t160+t159+.0080157430167598*t8*t11*
        t50*t52*t111*t126;
    d2fdrarb = t96+t5*(.0040078715083799*t11*t111*t50*t52*
        (2.113341204250295*t3*t53*(-.1383178583708611*t251*t52*t59*
        t60*t64*t69-.1383178583708611*t119*t140*t52*t59*t60*t64*t69+
        .2766357167417222*t114*t140*t59*t60*t64*t69+.2766357167417222*
        t114*t119*t59*t60*t64*t69+.3688476223222962*t113*t116*t140*
        t46*t52*t59*t64*t69+.3688476223222962*t116*t119*t138*t46*t52*
        t59*t64*t69+2.458984148815308*t113*t138*t17*t223*t52*t59*t66+
        .7376952446445925*t114*t116*t138*t46*t59*t66+.7376952446445925*
        t113*t114*t116*t46*t59*t66+.2766357167417222*t119*t124*t140*
        t221*t52*t59*t60+.3333333333333333*t46*t53*t3*t56*t113*t62*
        t52+.3333333333333333*t46*t53*t3*t56*t62*t138*t52+1.333333333333333*
        t17*t53*t3*t56*t113*t60*t138*t32+t222+t217)*t71-2.113341204250295*
        t53*t3*t67*t121*(-.5283353010625738*t61*t10*t56*t58*t32*t119*
        t140*t69*t64+.7044470680834316*t46*t61*t10*t56*t113*t62*t32*
        t140*t69*t64+.5283353010625738*t61*t10*t56*t58*t52*t140*t69*
        t64-.5283353010625738*t61*t10*t56*t58*t32*t251*t69*t64+.7044470680834316*
        t46*t61*t10*t56*t62*t138*t32*t119*t69*t64+.5283353010625738*
        t61*t10*t56*t58*t52*t119*t69*t64-.1860921268992536*t53*t68*
        t59*t60*t52*t119*t140*t124*t64+.4962456717313429*t46*t53*t68*
        t59*t113*t116*t52*t140*t124*t64+.3721842537985072*t53*t68*
        t59*t60*t114*t140*t124*t64-.1860921268992536*t53*t68*t59*t60*
        t52*t251*t124*t64+.4962456717313429*t46*t53*t68*t59*t116*t138*
        t52*t119*t124*t64+.3721842537985072*t53*t68*t59*t60*t114*t119*
        t124*t64+2.817788272333726*t17*t61*t10*t56*t113*t60*t138*t32*
        t66+.7044470680834316*t46*t61*t10*t56*t62*t138*t52*t66+.7044470680834316*
        t46*t61*t10*t56*t113*t62*t52*t66+t228+1.654152239104477*t17*
        t53*t68*t59*t113*t223*t138*t52*t69+.4962456717313429*t46*t53*
        t68*t59*t116*t138*t114*t69+.4962456717313429*t46*t53*t68*t59*
        t113*t116*t114*t69+t227+1.056670602125148*t61*t10*t56*t58*
        t32*t119*t140*t221*t124+.5582763806977609*t53*t68*t59*t60*
        t52*t119*t140*t221*t226)+4.22668240850059*t53*t3*t67*t216*
        t125*t142-2.113341204250295*t53*t3*t121*t120*t142-2.113341204250295*
        t53*t3*t121*t125*t141)*t8+.0213753147113594*t17*t8*t11*t113*
        t49*t138*t52*t73-.0160314860335196*t46*t8*t11*t113*t57*t114*
        t73-.0160314860335196*t46*t8*t11*t57*t138*t114*t73+t250+t249+
        t248+t247+t246+t245+t244+t243+t242+t241+t240+t239+t238+t237+
        t236+t235+t233+t232+t231+t230+t229+t212+t207+t205+t198+t186+
        t184+t183+t182+t180+t178+t172+t171+t169-.0040078715083799*
        t8*t11*t50*t52*t215*t126*t143+.0080157430167598*t46*t8*t11*
        t113*t57*t52*t111*t143-.0080157430167598*t8*t11*t50*t114*t111*
        t143+.0080157430167598*t46*t8*t11*t57*t138*t52*t111*t126-.0080157430167598*
        t8*t11*t50*t114*t111*t126)+t165+t164+t163+t162+t161+t160+t159+
        t145+t144+t136+t135+t133+t129+t127+t108+t102;
    d2fdraga = t5*(.0040078715083799*t11*t111*t50*t52*t8*
        (2.113341204250295*t3*t53*t71*(-.5532714334834444*t119*t52*
        t56*t60*t64*t69*grada-1.475390489289185*t113*t116*t46*t52*
        t56*t66*grada-.6666666666666666*t46*t53*t3*grada*t113*t62*
        t32+t255+t254)-2.113341204250295*t53*t3*t67*t121*(-1.056670602125148*
        t61*t10*grada*t58*t32*t119*t69*t64-.7443685075970145*t53*t68*
        grada*t56*t60*t52*t119*t124*t64-1.408894136166863*t46*t61*
        t10*grada*t113*t62*t32*t66+t257-.9924913434626859*t46*t53*
        t68*grada*t56*t113*t116*t52*t69+t256)+4.22668240850059*t53*
        t3*t67*t146*t216*t125-2.113341204250295*t53*t3*t147*t121*t125-
        2.113341204250295*t53*t3*t146*t121*t120)+t253-.0040078715083799*
        t8*t11*t50*t52*t148*t215*t126+.0080157430167598*t46*t8*t11*
        t113*t57*t52*t148*t111)+t252;
    d2fdragb = t5*(.0040078715083799*t11*t111*t50*t52*t8*
        (2.113341204250295*t3*t53*t71*(-.5532714334834444*t119*t52*
        t56*t60*t64*t69*gradb-1.475390489289185*t113*t116*t46*t52*
        t56*t66*gradb-.6666666666666666*t46*t53*t3*gradb*t113*t62*
        t32+t261+t260)-2.113341204250295*t53*t3*t67*t121*(-1.056670602125148*
        t61*t10*gradb*t58*t32*t119*t69*t64-.7443685075970145*t53*t68*
        gradb*t56*t60*t52*t119*t124*t64-1.408894136166863*t46*t61*
        t10*gradb*t113*t62*t32*t66+t263-.9924913434626859*t46*t53*
        t68*gradb*t56*t113*t116*t52*t69+t262)+4.22668240850059*t53*
        t3*t67*t149*t216*t125-2.113341204250295*t53*t3*t150*t121*t125-
        2.113341204250295*t53*t3*t149*t121*t120)+t259-.0040078715083799*
        t8*t11*t50*t52*t151*t215*t126+.0080157430167598*t46*t8*t11*
        t113*t57*t52*t151*t111)+t258;
    d2fdraab = t5*(.0040078715083799*t11*t111*t50*t52*(2.113341204250295*
        t3*t53*(-.5532714334834444*t119*t52*t56*t60*t64*t69-1.475390489289185*
        t113*t116*t46*t52*t56*t66-.6666666666666666*t46*t53*t3*t113*
        t62*t32+t267+t266)*t71-2.113341204250295*t53*t3*t67*t121*(-
        1.056670602125148*t61*t10*t58*t32*t119*t69*t64-.7443685075970145*
        t53*t68*t56*t60*t52*t119*t124*t64-1.408894136166863*t46*t61*
        t10*t113*t62*t32*t66+t269-.9924913434626859*t46*t53*t68*t56*
        t113*t116*t52*t69+t268)+4.22668240850059*t53*t3*t67*t154*t216*
        t125-2.113341204250295*t53*t3*t157*t121*t125-2.113341204250295*
        t53*t3*t154*t121*t120)*t8+t265-.0040078715083799*t8*t11*t50*
        t52*t158*t215*t126+.0080157430167598*t46*t8*t11*t113*t57*t52*
        t158*t111)+t264;
    d2fdrbrb = t5*(.0040078715083799*t11*t111*t50*t52*(2.113341204250295*
        t3*t53*(-.1383178583708611*t287*t52*t59*t60*t64*t69-.1383178583708611*
        t286*t52*t59*t60*t64*t69+.5532714334834444*t114*t140*t59*t60*
        t64*t69+.7376952446445925*t116*t138*t140*t46*t52*t59*t64*t69+
        .1229492074407654*t116*t284*t46*t52*t59*t66+2.458984148815308*
        t17*t223*t285*t52*t59*t66+1.475390489289185*t114*t116*t138*
        t46*t59*t66+.2766357167417222*t124*t221*t286*t52*t59*t60+.6666666666666666*
        t46*t53*t3*t56*t62*t138*t52+1.333333333333333*t17*t53*t3*t56*
        t60*t285*t32+.1111111111111111*t46*t53*t3*t56*t62*t284*t32+
        t222+t217)*t71+4.22668240850059*POW(t142,2.0)*t216*t3*t53*
        t67-2.113341204250295*t53*t3*t67*t121*(-.5283353010625738*
        t61*t10*t56*t58*t32*t286*t69*t64+1.408894136166863*t46*t61*
        t10*t56*t62*t138*t32*t140*t69*t64+1.056670602125148*t61*t10*
        t56*t58*t52*t140*t69*t64-.5283353010625738*t61*t10*t56*t58*
        t32*t287*t69*t64-.1860921268992536*t53*t68*t59*t60*t52*t286*
        t124*t64+.9924913434626859*t46*t53*t68*t59*t116*t138*t52*t140*
        t124*t64+.7443685075970145*t53*t68*t59*t60*t114*t140*t124*
        t64-.1860921268992536*t53*t68*t59*t60*t52*t287*t124*t64+2.817788272333726*
        t17*t61*t10*t56*t60*t285*t32*t66+.2348156893611439*t46*t61*
        t10*t56*t62*t284*t32*t66+1.408894136166863*t46*t61*t10*t56*
        t62*t138*t52*t66+t228+1.654152239104477*t17*t53*t68*t59*t223*
        t285*t52*t69+.0827076119552238*t46*t53*t68*t59*t116*t284*t52*
        t69+.9924913434626859*t46*t53*t68*t59*t116*t138*t114*t69+t227+
        1.056670602125148*t61*t10*t56*t58*t32*t286*t221*t124+.5582763806977609*
        t53*t68*t59*t60*t52*t286*t221*t226)-4.22668240850059*t53*t3*
        t121*t141*t142)*t8-.0040078715083799*t11*POW(t143,2.0)*t215*
        t50*t52*t8+.0213753147113594*t17*t8*t11*t49*t285*t52*t73-.0026719143389199*
        t46*t8*t11*t57*t284*t52*t73-.0320629720670391*t46*t8*t11*t57*
        t138*t114*t73+t283+t282+t281+t280+t279+t278+t277+t276+t275+
        t274+t273+t271+t270+t229+t214+t212+t207+t205+t198+t186+t184+
        t183+t182+t180+t178+t172+t171+t169+.0160314860335196*t46*t8*
        t11*t57*t138*t52*t111*t143-.0160314860335196*t8*t11*t50*t114*
        t111*t143)+.0160314860335196*t46*t8*t11*t57*t138*t52*t73-8.0*
        t100*t26*t29*t35*t44+2.0*t132*t26*t28*t29*t44+.0395035794051304*
        t26*t134*t31*t35*t38+.0395035794051304*t26*t30*t31*t132*t38+
        t165+t164+t163+t162+t161+t160+t159+.0080157430167598*t8*t11*
        t50*t52*t111*t143;
    d2fdrbga = t5*(.0040078715083799*t11*t111*t50*t52*t8*
        (2.113341204250295*t3*t53*t71*(-.5532714334834444*t140*t52*
        t56*t60*t64*t69*grada-1.475390489289185*t116*t138*t46*t52*
        t56*t66*grada-.6666666666666666*t46*t53*t3*grada*t62*t138*
        t32+t255+t254)-2.113341204250295*t53*t3*t67*t121*(-1.056670602125148*
        t61*t10*grada*t58*t32*t140*t69*t64-.7443685075970145*t53*t68*
        grada*t56*t60*t52*t140*t124*t64-1.408894136166863*t46*t61*
        t10*grada*t62*t138*t32*t66+t257-.9924913434626859*t46*t53*
        t68*grada*t56*t116*t138*t52*t69+t256)+4.22668240850059*t53*
        t3*t67*t146*t216*t142-2.113341204250295*t53*t3*t147*t121*t142-
        2.113341204250295*t53*t3*t146*t121*t141)+t253-.0040078715083799*
        t8*t11*t50*t52*t148*t215*t143+.0080157430167598*t46*t8*t11*
        t57*t138*t52*t148*t111)+t252;
    d2fdrbgb = t5*(.0040078715083799*t11*t111*t50*t52*t8*
        (2.113341204250295*t3*t53*t71*(-.5532714334834444*t140*t52*
        t56*t60*t64*t69*gradb-1.475390489289185*t116*t138*t46*t52*
        t56*t66*gradb-.6666666666666666*t46*t53*t3*gradb*t62*t138*
        t32+t261+t260)-2.113341204250295*t53*t3*t67*t121*(-1.056670602125148*
        t61*t10*gradb*t58*t32*t140*t69*t64-.7443685075970145*t53*t68*
        gradb*t56*t60*t52*t140*t124*t64-1.408894136166863*t46*t61*
        t10*gradb*t62*t138*t32*t66+t263-.9924913434626859*t46*t53*
        t68*gradb*t56*t116*t138*t52*t69+t262)+4.22668240850059*t53*
        t3*t67*t149*t216*t142-2.113341204250295*t53*t3*t150*t121*t142-
        2.113341204250295*t53*t3*t149*t121*t141)+t259-.0040078715083799*
        t8*t11*t50*t52*t151*t215*t143+.0080157430167598*t46*t8*t11*
        t57*t138*t52*t151*t111)+t258;
    d2fdrbgab = t5*(.0040078715083799*t11*t111*t50*t52*(2.113341204250295*
        t3*t53*(-.5532714334834444*t140*t52*t56*t60*t64*t69-1.475390489289185*
        t116*t138*t46*t52*t56*t66-.6666666666666666*t46*t53*t3*t62*
        t138*t32+t267+t266)*t71-2.113341204250295*t53*t3*t67*t121*
        (-1.056670602125148*t61*t10*t58*t32*t140*t69*t64-.7443685075970145*
        t53*t68*t56*t60*t52*t140*t124*t64-1.408894136166863*t46*t61*
        t10*t62*t138*t32*t66+t269-.9924913434626859*t46*t53*t68*t56*
        t116*t138*t52*t69+t268)+4.22668240850059*t53*t3*t67*t154*t216*
        t142-2.113341204250295*t53*t3*t157*t121*t142-2.113341204250295*
        t53*t3*t154*t121*t141)*t8+t265-.0040078715083799*t8*t11*t50*
        t52*t158*t215*t143+.0080157430167598*t46*t8*t11*t57*t138*t52*
        t158*t111)+t264;
    d2fdgaga = .0040078715083799*t11*t111*t32*t50*(2.113341204250295*
        t3*t53*(1.106542866966889*t52*t54*t60*t66+t156+t155)*t71+4.22668240850059*
        POW(t146,2.0)*t216*t3*t53*t67-2.113341204250295*t53*t3*t67*
        (t153+t152+.7443685075970145*t53*t68*t54*t60*t52*t69)*t121-
        4.22668240850059*t53*t3*t147*t146*t121)*t8-.0040078715083799*
        t11*POW(t148,2.0)*t215*t32*t50*t8;
    d2fdgagb = .0040078715083799*t8*t11*t50*t32*t111*(.7443685075970145*
        t53*t68*grada*gradb*t60*t52*t71*t66-1.573104638251069*t61*
        t288*grada*gradb*t60*t52*t67*t121*t69-2.113341204250295*t53*
        t3*t147*t149*t121-2.113341204250295*t53*t3*t150*t146*t121+
        4.22668240850059*t53*t3*t67*t146*t149*t216)-.0040078715083799*
        t8*t11*t50*t32*t148*t151*t215;
    d2fdgagab = .0040078715083799*t8*t11*t50*t32*t111*(.7443685075970145*
        t53*t68*grada*t60*t52*t71*t66-1.573104638251069*t61*t288*grada*
        t60*t52*t67*t121*t69-2.113341204250295*t53*t3*t157*t146*t121-
        2.113341204250295*t53*t3*t147*t154*t121+4.22668240850059*t53*
        t3*t67*t154*t146*t216)-.0040078715083799*t8*t11*t50*t32*t158*
        t148*t215;
    d2fdgbgb = .0040078715083799*t11*t111*t32*t50*(2.113341204250295*
        t3*t53*(1.106542866966889*t52*t55*t60*t66+t156+t155)*t71+4.22668240850059*
        POW(t149,2.0)*t216*t3*t53*t67-2.113341204250295*t53*t3*t67*
        (t153+t152+.7443685075970145*t53*t68*t55*t60*t52*t69)*t121-
        4.22668240850059*t53*t3*t150*t149*t121)*t8-.0040078715083799*
        t11*POW(t151,2.0)*t215*t32*t50*t8;
    d2fdgbgab = .0040078715083799*t8*t11*t50*t32*t111*(.7443685075970145*
        t53*t68*gradb*t60*t52*t71*t66-1.573104638251069*t61*t288*gradb*
        t60*t52*t67*t121*t69-2.113341204250295*t53*t3*t157*t149*t121-
        2.113341204250295*t53*t3*t150*t154*t121+4.22668240850059*t53*
        t3*t67*t154*t149*t216)-.0040078715083799*t8*t11*t50*t32*t158*
        t151*t215;
    d2fdgabgab = .0040078715083799*t11*t111*t32*t50*(-1.573104638251069*
        t61*t288*t60*t52*t67*t121*t69+4.22668240850059*POW(t154,2.0)*
        t216*t3*t53*t67+.7443685075970145*t53*t68*t60*t52*t71*t66-
        4.22668240850059*t53*t3*t157*t154*t121)*t8-.0040078715083799*
        t11*POW(t158,2.0)*t215*t32*t50*t8;


    ds->df1000 += factor*dfdra;
    ds->df0100 += factor*dfdrb;
    ds->df0010 += factor*dfdga;
    ds->df0001 += factor*dfdgb;
    ds->df00001+= factor*dfdgab;

    ds->df2000 += factor*d2fdrara;
    ds->df1100 += factor*d2fdrarb;
    ds->df1010 += factor*d2fdraga;
    ds->df1001 += factor*d2fdragb;
    ds->df10001+= factor*d2fdraab;
    ds->df0200 += factor*d2fdrbrb;
    ds->df0110 += factor*d2fdrbga;
    ds->df0101 += factor*d2fdrbgb;
    ds->df01001+= factor*d2fdrbgab;
    ds->df0020 += factor*d2fdgaga;
    ds->df0011 += factor*d2fdgagb;
    ds->df00101+= factor*d2fdgagab;
    ds->df0002 += factor*d2fdgbgb;
    ds->df00011+= factor*d2fdgbgab;
    ds->df00002+= factor*d2fdgabgab;

}
